/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.BaseQueryable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Parameter;
import org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Litmus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class Smalls {
    public static final Method GENERATE_STRINGS_METHOD = Types.lookupMethod(Smalls.class, (String)"generateStrings", (Class[])new Class[]{Integer.class});
    public static final Method MAZE_METHOD = Types.lookupMethod(MazeTable.class, (String)"generate", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
    public static final Method MAZE2_METHOD = Types.lookupMethod(MazeTable.class, (String)"generate2", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.class});
    public static final Method MAZE3_METHOD = Types.lookupMethod(MazeTable.class, (String)"generate3", (Class[])new Class[]{String.class});
    public static final Method MULTIPLICATION_TABLE_METHOD = Types.lookupMethod(Smalls.class, (String)"multiplicationTable", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.class});
    public static final Method FIBONACCI_TABLE_METHOD = Types.lookupMethod(Smalls.class, (String)"fibonacciTable", (Class[])new Class[0]);
    public static final Method FIBONACCI2_TABLE_METHOD = Types.lookupMethod(Smalls.class, (String)"fibonacciTableWithLimit", (Class[])new Class[]{Long.TYPE});
    public static final Method VIEW_METHOD = Types.lookupMethod(Smalls.class, (String)"view", (Class[])new Class[]{String.class});
    public static final Method STR_METHOD = Types.lookupMethod(Smalls.class, (String)"str", (Class[])new Class[]{Object.class, Object.class});
    public static final Method STRING_UNION_METHOD = Types.lookupMethod(Smalls.class, (String)"stringUnion", (Class[])new Class[]{Queryable.class, Queryable.class});
    public static final Method PROCESS_CURSOR_METHOD = Types.lookupMethod(Smalls.class, (String)"processCursor", (Class[])new Class[]{Integer.TYPE, Enumerable.class});
    public static final Method PROCESS_CURSORS_METHOD = Types.lookupMethod(Smalls.class, (String)"processCursors", (Class[])new Class[]{Integer.TYPE, Enumerable.class, Enumerable.class});

    private Smalls() {
    }

    private static QueryableTable oneThreePlus(String s) {
        ImmutableList items;
        if (s == null) {
            items = ImmutableList.of();
        } else {
            Integer latest = Integer.parseInt(s.substring(1, s.length() - 1));
            items = ImmutableList.of((Object)1, (Object)3, (Object)latest);
        }
        final Enumerable enumerable = Linq4j.asEnumerable((List)items);
        return new AbstractQueryableTable((Type)((Object)Integer.class)){

            public <E> Queryable<E> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                return enumerable.asQueryable();
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("c", SqlTypeName.INTEGER).build();
            }
        };
    }

    public static <T> Queryable<T> stringUnion(Queryable<T> q0, Queryable<T> q1) {
        return q0.concat(q1);
    }

    public static QueryableTable generateStrings(final Integer count) {
        return new AbstractQueryableTable((Type)((Object)IntString.class)){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.createJavaType(IntString.class);
            }

            public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                BaseQueryable<IntString> queryable = new BaseQueryable<IntString>(null, IntString.class, null){

                    public Enumerator<IntString> enumerator() {
                        return new Enumerator<IntString>(){
                            static final String Z = "abcdefghijklm";
                            int i = 0;
                            int curI;
                            String curS;

                            public IntString current() {
                                return new IntString(this.curI, this.curS);
                            }

                            public boolean moveNext() {
                                if (this.i < count) {
                                    this.curI = this.i;
                                    this.curS = Z.substring(0, this.i % Z.length());
                                    ++this.i;
                                    return true;
                                }
                                return false;
                            }

                            public void reset() {
                                this.i = 0;
                            }

                            public void close() {
                            }
                        };
                    }
                };
                return queryable;
            }
        };
    }

    public static QueryableTable multiplicationTable(final int ncol, final int nrow, Integer offset) {
        final int offs = offset == null ? 0 : offset;
        return new AbstractQueryableTable((Type)((Object)Object[].class)){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
                builder.add("row_name", typeFactory.createJavaType(String.class));
                RelDataType int_ = typeFactory.createJavaType(Integer.TYPE);
                for (int i = 1; i <= ncol; ++i) {
                    builder.add("c" + i, int_);
                }
                return builder.build();
            }

            public Queryable<Object[]> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                AbstractList<Object[]> table = new AbstractList<Object[]>(){

                    @Override
                    public Object[] get(int index) {
                        Object[] cur = new Object[ncol + 1];
                        cur[0] = "row " + index;
                        for (int j = 1; j <= ncol; ++j) {
                            cur[j] = j * (index + 1) + offs;
                        }
                        return cur;
                    }

                    @Override
                    public int size() {
                        return nrow;
                    }
                };
                return Linq4j.asEnumerable((List)table).asQueryable();
            }
        };
    }

    public static ScannableTable fibonacciTable() {
        return Smalls.fibonacciTableWithLimit(-1L);
    }

    public static ScannableTable fibonacciTableWithLimit(final long limit) {
        return new ScannableTable(){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("N", SqlTypeName.BIGINT).build();
            }

            public Enumerable<Object[]> scan(DataContext root) {
                return new AbstractEnumerable<Object[]>(){

                    public Enumerator<Object[]> enumerator() {
                        return new Enumerator<Object[]>(){
                            private long prev = 1L;
                            private long current = 0L;

                            public Object[] current() {
                                return new Object[]{this.current};
                            }

                            public boolean moveNext() {
                                long next = this.current + this.prev;
                                if (limit >= 0L && next > limit) {
                                    return false;
                                }
                                this.prev = this.current;
                                this.current = next;
                                return true;
                            }

                            public void reset() {
                                this.prev = 0L;
                                this.current = 1L;
                            }

                            public void close() {
                            }
                        };
                    }
                };
            }

            public Statistic getStatistic() {
                return Statistics.UNKNOWN;
            }

            public Schema.TableType getJdbcTableType() {
                return Schema.TableType.TABLE;
            }

            public boolean isRolledUp(String column) {
                return false;
            }

            public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
                return true;
            }
        };
    }

    public static QueryableTable processCursor(int offset, Enumerable<Object[]> a) {
        return new AbstractQueryableTable((Type)((Object)Object[].class), (Enumerable)a, offset){
            final /* synthetic */ Enumerable val$a;
            final /* synthetic */ int val$offset;
            {
                this.val$a = enumerable;
                this.val$offset = n;
                super(x0);
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("result", SqlTypeName.INTEGER).build();
            }

            public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                Enumerable enumerable = this.val$a.select(a0 -> this.val$offset + (Integer)a0[0]);
                return enumerable.asQueryable();
            }
        };
    }

    public static QueryableTable processCursors(int offset, Enumerable<Object[]> a, Enumerable<IntString> b) {
        return new AbstractQueryableTable((Type)((Object)Object[].class), (Enumerable)a, (Enumerable)b, offset){
            final /* synthetic */ Enumerable val$a;
            final /* synthetic */ Enumerable val$b;
            final /* synthetic */ int val$offset;
            {
                this.val$a = enumerable;
                this.val$b = enumerable2;
                this.val$offset = n;
                super(x0);
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("result", SqlTypeName.INTEGER).build();
            }

            public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                Enumerable enumerable = this.val$a.zip(this.val$b, (v0, v1) -> (Integer)v0[1] + v1.n + this.val$offset);
                return enumerable.asQueryable();
            }
        };
    }

    public static TranslatableTable view(String s) {
        return new ViewTable(Object.class, typeFactory -> typeFactory.builder().add("c", SqlTypeName.INTEGER).build(), "values (1), (3), " + s, (List)ImmutableList.of(), Arrays.asList("view"));
    }

    public static TranslatableTable strView(String s) {
        return new ViewTable(Object.class, typeFactory -> typeFactory.builder().add("c", SqlTypeName.VARCHAR, 100).build(), "values (" + CalciteSqlDialect.DEFAULT.quoteStringLiteral(s) + ")", (List)ImmutableList.of(), Arrays.asList("view"));
    }

    public static TranslatableTable str(Object o, Object p) {
        Assert.assertThat((Object)RexLiteral.validConstant((Object)o, (Litmus)Litmus.THROW), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexLiteral.validConstant((Object)p, (Litmus)Litmus.THROW), (Matcher)CoreMatchers.is((Object)true));
        return new ViewTable(Object.class, typeFactory -> typeFactory.builder().add("c", SqlTypeName.VARCHAR, 100).build(), "values " + CalciteSqlDialect.DEFAULT.quoteStringLiteral(o.toString()) + ", " + CalciteSqlDialect.DEFAULT.quoteStringLiteral(p.toString()), (List)ImmutableList.of(), Arrays.asList("view"));
    }

    public static class WideProductSale {
        public final int prodId;
        public final double sale0;
        public final double sale1 = 10.0;
        public final double sale2 = 10.0;
        public final double sale3 = 10.0;
        public final double sale4 = 10.0;
        public final double sale5 = 10.0;
        public final double sale6 = 10.0;
        public final double sale7 = 10.0;
        public final double sale8 = 10.0;
        public final double sale9 = 10.0;
        public final double sale10 = 10.0;
        public final double sale11 = 10.0;
        public final double sale12 = 10.0;
        public final double sale13 = 10.0;
        public final double sale14 = 10.0;
        public final double sale15 = 10.0;
        public final double sale16 = 10.0;
        public final double sale17 = 10.0;
        public final double sale18 = 10.0;
        public final double sale19 = 10.0;
        public final double sale20 = 10.0;
        public final double sale21 = 10.0;
        public final double sale22 = 10.0;
        public final double sale23 = 10.0;
        public final double sale24 = 10.0;
        public final double sale25 = 10.0;
        public final double sale26 = 10.0;
        public final double sale27 = 10.0;
        public final double sale28 = 10.0;
        public final double sale29 = 10.0;
        public final double sale30 = 10.0;
        public final double sale31 = 10.0;
        public final double sale32 = 10.0;
        public final double sale33 = 10.0;
        public final double sale34 = 10.0;
        public final double sale35 = 10.0;
        public final double sale36 = 10.0;
        public final double sale37 = 10.0;
        public final double sale38 = 10.0;
        public final double sale39 = 10.0;
        public final double sale40 = 10.0;
        public final double sale41 = 10.0;
        public final double sale42 = 10.0;
        public final double sale43 = 10.0;
        public final double sale44 = 10.0;
        public final double sale45 = 10.0;
        public final double sale46 = 10.0;
        public final double sale47 = 10.0;
        public final double sale48 = 10.0;
        public final double sale49 = 10.0;
        public final double sale50 = 10.0;
        public final double sale51 = 10.0;
        public final double sale52 = 10.0;
        public final double sale53 = 10.0;
        public final double sale54 = 10.0;
        public final double sale55 = 10.0;
        public final double sale56 = 10.0;
        public final double sale57 = 10.0;
        public final double sale58 = 10.0;
        public final double sale59 = 10.0;
        public final double sale60 = 10.0;
        public final double sale61 = 10.0;
        public final double sale62 = 10.0;
        public final double sale63 = 10.0;
        public final double sale64 = 10.0;
        public final double sale65 = 10.0;
        public final double sale66 = 10.0;
        public final double sale67 = 10.0;
        public final double sale68 = 10.0;
        public final double sale69 = 10.0;
        public final double sale70 = 10.0;
        public final double sale71 = 10.0;
        public final double sale72 = 10.0;
        public final double sale73 = 10.0;
        public final double sale74 = 10.0;
        public final double sale75 = 10.0;
        public final double sale76 = 10.0;
        public final double sale77 = 10.0;
        public final double sale78 = 10.0;
        public final double sale79 = 10.0;
        public final double sale80 = 10.0;
        public final double sale81 = 10.0;
        public final double sale82 = 10.0;
        public final double sale83 = 10.0;
        public final double sale84 = 10.0;
        public final double sale85 = 10.0;
        public final double sale86 = 10.0;
        public final double sale87 = 10.0;
        public final double sale88 = 10.0;
        public final double sale89 = 10.0;
        public final double sale90 = 10.0;
        public final double sale91 = 10.0;
        public final double sale92 = 10.0;
        public final double sale93 = 10.0;
        public final double sale94 = 10.0;
        public final double sale95 = 10.0;
        public final double sale96 = 10.0;
        public final double sale97 = 10.0;
        public final double sale98 = 10.0;
        public final double sale99 = 10.0;
        public final double sale100 = 10.0;
        public final double sale101 = 10.0;
        public final double sale102 = 10.0;
        public final double sale103 = 10.0;
        public final double sale104 = 10.0;
        public final double sale105 = 10.0;
        public final double sale106 = 10.0;
        public final double sale107 = 10.0;
        public final double sale108 = 10.0;
        public final double sale109 = 10.0;
        public final double sale110 = 10.0;
        public final double sale111 = 10.0;
        public final double sale112 = 10.0;
        public final double sale113 = 10.0;
        public final double sale114 = 10.0;
        public final double sale115 = 10.0;
        public final double sale116 = 10.0;
        public final double sale117 = 10.0;
        public final double sale118 = 10.0;
        public final double sale119 = 10.0;
        public final double sale120 = 10.0;
        public final double sale121 = 10.0;
        public final double sale122 = 10.0;
        public final double sale123 = 10.0;
        public final double sale124 = 10.0;
        public final double sale125 = 10.0;
        public final double sale126 = 10.0;
        public final double sale127 = 10.0;
        public final double sale128 = 10.0;
        public final double sale129 = 10.0;
        public final double sale130 = 10.0;
        public final double sale131 = 10.0;
        public final double sale132 = 10.0;
        public final double sale133 = 10.0;
        public final double sale134 = 10.0;
        public final double sale135 = 10.0;
        public final double sale136 = 10.0;
        public final double sale137 = 10.0;
        public final double sale138 = 10.0;
        public final double sale139 = 10.0;
        public final double sale140 = 10.0;
        public final double sale141 = 10.0;
        public final double sale142 = 10.0;
        public final double sale143 = 10.0;
        public final double sale144 = 10.0;
        public final double sale145 = 10.0;
        public final double sale146 = 10.0;
        public final double sale147 = 10.0;
        public final double sale148 = 10.0;
        public final double sale149 = 10.0;
        public final double sale150 = 10.0;
        public final double sale151 = 10.0;
        public final double sale152 = 10.0;
        public final double sale153 = 10.0;
        public final double sale154 = 10.0;
        public final double sale155 = 10.0;
        public final double sale156 = 10.0;
        public final double sale157 = 10.0;
        public final double sale158 = 10.0;
        public final double sale159 = 10.0;
        public final double sale160 = 10.0;
        public final double sale161 = 10.0;
        public final double sale162 = 10.0;
        public final double sale163 = 10.0;
        public final double sale164 = 10.0;
        public final double sale165 = 10.0;
        public final double sale166 = 10.0;
        public final double sale167 = 10.0;
        public final double sale168 = 10.0;
        public final double sale169 = 10.0;
        public final double sale170 = 10.0;
        public final double sale171 = 10.0;
        public final double sale172 = 10.0;
        public final double sale173 = 10.0;
        public final double sale174 = 10.0;
        public final double sale175 = 10.0;
        public final double sale176 = 10.0;
        public final double sale177 = 10.0;
        public final double sale178 = 10.0;
        public final double sale179 = 10.0;
        public final double sale180 = 10.0;
        public final double sale181 = 10.0;
        public final double sale182 = 10.0;
        public final double sale183 = 10.0;
        public final double sale184 = 10.0;
        public final double sale185 = 10.0;
        public final double sale186 = 10.0;
        public final double sale187 = 10.0;
        public final double sale188 = 10.0;
        public final double sale189 = 10.0;
        public final double sale190 = 10.0;
        public final double sale191 = 10.0;
        public final double sale192 = 10.0;
        public final double sale193 = 10.0;
        public final double sale194 = 10.0;
        public final double sale195 = 10.0;
        public final double sale196 = 10.0;
        public final double sale197 = 10.0;
        public final double sale198 = 10.0;
        public final double sale199 = 10.0;

        public WideProductSale(int prodId, double sale) {
            this.prodId = prodId;
            this.sale0 = sale;
        }
    }

    public static class WideSaleSchema {
        public final WideProductSale[] prod = new WideProductSale[]{new WideProductSale(100, 10.0)};

        public String toString() {
            return "WideSaleSchema";
        }
    }

    public static class MazeTable
    extends AbstractTable
    implements ScannableTable {
        private final String content;

        public MazeTable(String content) {
            this.content = content;
        }

        public static ScannableTable generate(int width, int height, int seed) {
            return new MazeTable(String.format(Locale.ROOT, "generate(w=%d, h=%d, s=%d)", width, height, seed));
        }

        public static ScannableTable generate2(@Parameter(name="WIDTH") int width, @Parameter(name="HEIGHT") int height, @Parameter(name="SEED", optional=true) Integer seed) {
            return new MazeTable(String.format(Locale.ROOT, "generate2(w=%d, h=%d, s=%d)", width, height, seed));
        }

        public static ScannableTable generate3(@Parameter(name="FOO") String foo) {
            return new MazeTable(String.format(Locale.ROOT, "generate3(foo=%s)", foo));
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("S", SqlTypeName.VARCHAR, 12).build();
        }

        public Enumerable<Object[]> scan(DataContext root) {
            Object[][] rows = new Object[][]{{"abcde"}, {"xyz"}, {this.content}};
            return Linq4j.asEnumerable((Object[])rows);
        }
    }

    public static class TestStaticTableFunction {
        public static QueryableTable eval(String s) {
            return Smalls.oneThreePlus(s);
        }
    }

    public static class MyTableFunction {
        public QueryableTable eval(String s) {
            return Smalls.oneThreePlus(s);
        }
    }

    public static class SimpleTableFunction {
        public QueryableTable eval(Integer s) {
            return Smalls.generateStrings(s);
        }
    }

    public static class TableMacroFunctionWithNamedParameters {
        public TranslatableTable eval(@Parameter(name="R", optional=true) String r, @Parameter(name="S") String s, @Parameter(name="T", optional=true) Integer t) {
            StringBuilder sb = new StringBuilder();
            this.abc(sb, r);
            this.abc(sb, s);
            this.abc(sb, t);
            return Smalls.view(sb.toString());
        }

        private void abc(StringBuilder sb, Object s) {
            if (s != null) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append('(').append(s).append(')');
            }
        }
    }

    public static class StaticTableMacroFunction {
        public static TranslatableTable eval(String s) {
            return Smalls.view(s);
        }
    }

    public static class TableMacroFunction {
        public TranslatableTable eval(String s) {
            return Smalls.view(s);
        }
    }

    public static class SumFunctionBadIAdd {
        public long init() {
            return 0L;
        }

        public long add(short accumulator, int v) {
            return accumulator + v;
        }
    }

    public static class MyThreeParamsSumFunctionWithFilter2 {
        public static long init() {
            return 0L;
        }

        public static long add(long accumulator, int v1, int v2, int v3) {
            if (v3 > 250) {
                return accumulator + (long)v1 + (long)v2;
            }
            return accumulator;
        }

        public static long merge(long accumulator0, long accumulator1) {
            return accumulator0 + accumulator1;
        }

        public static long result(long accumulator) {
            return accumulator;
        }
    }

    public static class MyThreeParamsSumFunctionWithFilter1 {
        public static long init() {
            return 0L;
        }

        public static long add(long accumulator, int v1, String v2, String v3) {
            if (v2.equals(v3)) {
                return accumulator + (long)v1;
            }
            return accumulator;
        }

        public static long merge(long accumulator0, long accumulator1) {
            return accumulator0 + accumulator1;
        }

        public static long result(long accumulator) {
            return accumulator;
        }
    }

    public static class MyTwoParamsSumFunctionFilter2 {
        public long init() {
            return 0L;
        }

        public long add(long accumulator, int v1, String v2) {
            if (v2.equals("Eric")) {
                return accumulator + (long)v1;
            }
            return accumulator;
        }

        public long merge(long accumulator0, long accumulator1) {
            return accumulator0 + accumulator1;
        }

        public long result(long accumulator) {
            return accumulator;
        }
    }

    public static class MyTwoParamsSumFunctionFilter1 {
        public int init() {
            return 0;
        }

        public int add(int accumulator, int v1, int v2) {
            if (v1 > v2) {
                return accumulator + v1;
            }
            return accumulator;
        }

        public int merge(int accumulator0, int accumulator1) {
            return accumulator0 + accumulator1;
        }

        public int result(int accumulator) {
            return accumulator;
        }
    }

    public static class MyStaticSumFunction {
        public static long init() {
            return 0L;
        }

        public static long add(long accumulator, int v) {
            return accumulator + (long)v;
        }

        public static long merge(long accumulator0, long accumulator1) {
            return accumulator0 + accumulator1;
        }

        public static long result(long accumulator) {
            return accumulator;
        }
    }

    public static class MySum3
    implements MyGenericAggFunction<Integer, Integer, Integer> {
        @Override
        public Integer init() {
            return 0;
        }

        @Override
        public Integer add(Integer accumulator, Integer val) {
            return accumulator + val;
        }

        @Override
        public Integer merge(Integer accumulator1, Integer accumulator2) {
            return accumulator1 + accumulator2;
        }

        @Override
        public Integer result(Integer accumulator) {
            return accumulator;
        }
    }

    private static interface MyGenericAggFunction<A, V, R> {
        public A init();

        public A add(A var1, V var2);

        public A merge(A var1, A var2);

        public R result(A var1);
    }

    public static class MySumFunction {
        public long init() {
            return 0L;
        }

        public long add(long accumulator, int v) {
            return accumulator + (long)v;
        }

        public long merge(long accumulator0, long accumulator1) {
            return accumulator0 + accumulator1;
        }

        public long result(long accumulator) {
            return accumulator;
        }
    }

    @Deterministic
    public static class AllTypesFunction {
        private AllTypesFunction() {
        }

        public static long dateFun(Date v) {
            return v == null ? -1L : SqlFunctions.toLong((java.util.Date)v);
        }

        public static long timestampFun(Timestamp v) {
            return v == null ? -1L : SqlFunctions.toLong((Timestamp)v);
        }

        public static long timeFun(Time v) {
            return v == null ? -1L : SqlFunctions.toLong((java.util.Date)v);
        }

        public static Date toDateFun(int v) {
            return SqlFunctions.internalToDate((int)v);
        }

        public static Date toDateFun(Long v) {
            return v == null ? null : SqlFunctions.internalToDate((int)v.intValue());
        }

        public static Timestamp toTimestampFun(Long v) {
            return SqlFunctions.internalToTimestamp((Long)v);
        }

        public static Time toTimeFun(Long v) {
            return v == null ? null : SqlFunctions.internalToTime((int)v.intValue());
        }

        public static double toDouble(BigDecimal var) {
            return var == null ? null : Double.valueOf(var.doubleValue());
        }

        public static double toDouble(Double var) {
            return var == null ? 0.0 : var;
        }

        public static double toDouble(Float var) {
            return var == null ? 0.0 : Double.valueOf(var.toString());
        }

        public static List arrayAppendFun(List v, Integer i) {
            if (v == null || i == null) {
                return null;
            }
            v.add(i);
            return v;
        }

        public static long toLong(Date date) {
            return date == null ? 0L : SqlFunctions.toLong((java.util.Date)date);
        }

        public static long toLong(Timestamp timestamp) {
            return timestamp == null ? 0L : SqlFunctions.toLong((Timestamp)timestamp);
        }

        public static long toLong(Time time) {
            return time == null ? 0L : SqlFunctions.toLong((java.util.Date)time);
        }
    }

    public static class MultipleFunction {
        private MultipleFunction() {
        }

        public static String fun1(String x) {
            return x.toLowerCase(Locale.ROOT);
        }

        public static int fun1(int x) {
            return x * 2;
        }

        public static int fun1(int x, int y) {
            return x + y;
        }

        public static int fun2(int x) {
            return x * 3;
        }

        public int nonStatic(int x) {
            return x * 3;
        }
    }

    public static abstract class AwkwardFunction {
        private AwkwardFunction() {
        }

        public int eval(int x) {
            return 0;
        }
    }

    public static abstract class CountArgs2Function {
        private CountArgs2Function() {
        }

        public static int eval(int x, int y) {
            return 2;
        }
    }

    public static abstract class CountArgs1NullableFunction {
        private CountArgs1NullableFunction() {
        }

        public static int eval(Short x) {
            return -1;
        }
    }

    public static abstract class CountArgs1Function {
        private CountArgs1Function() {
        }

        public static int eval(int x) {
            return 1;
        }
    }

    public static abstract class CountArgs0Function {
        private CountArgs0Function() {
        }

        public static int eval() {
            return 0;
        }
    }

    public static class MyIncrement {
        public float eval(int x, int y) {
            return x + x * y / 100;
        }
    }

    public static abstract class MyDoubleFunction {
        private MyDoubleFunction() {
        }

        public static int eval(int x) {
            return x * 2;
        }
    }

    public static class Null8Function {
        @SemiStrict
        public static String eval(@Parameter(name="s") String s) {
            if (s.length() == 8) {
                return null;
            }
            return s;
        }
    }

    public static class Null4Function {
        @SemiStrict
        public static String eval(@Parameter(name="s") String s) {
            if (s == null || s.length() == 4) {
                return null;
            }
            return s;
        }
    }

    public static class MyToStringFunction {
        public static String eval(@Parameter(name="o") Object o) {
            if (o == null) {
                return "<null>";
            }
            return "<" + o.toString() + ">";
        }
    }

    public static class MyAbcdeFunction {
        public String eval(@Parameter(name="A", optional=false) Integer a, @Parameter(name="B", optional=true) Integer b, @Parameter(name="C", optional=false) Integer c, @Parameter(name="D", optional=true) Integer d, @Parameter(name="E", optional=true) Integer e) {
            return "{a: " + a + ", b: " + b + ", c: " + c + ", d: " + d + ", e: " + e + "}";
        }
    }

    public static class MyLeftFunction {
        public String eval(@Parameter(name="s") String s, @Parameter(name="n") int n) {
            return s.substring(0, n);
        }
    }

    public static class MyDeterministicPlusFunction {
        public static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);

        @Deterministic
        public MyDeterministicPlusFunction() {
            INSTANCE_COUNT.incrementAndGet();
        }

        public int eval(@Parameter(name="x") int x, @Parameter(name="y") int y) {
            return x + y;
        }
    }

    public static class MyPlusFunction {
        public static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);

        public MyPlusFunction() {
            INSTANCE_COUNT.incrementAndGet();
        }

        public int eval(@Parameter(name="x") int x, @Parameter(name="y") int y) {
            return x + y;
        }
    }

    public static class IntString {
        public final int n;
        public final String s;

        public IntString(int n, String s) {
            this.n = n;
            this.s = s;
        }

        public String toString() {
            return "{n=" + this.n + ", s=" + this.s + "}";
        }
    }
}

