/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.DiffRepository;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlLimitsTest {
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(SqlLimitsTest.class);
    }

    public static List<RelDataType> getTypes(RelDataTypeFactory typeFactory) {
        int maxPrecision = typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.DECIMAL);
        return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.BOOLEAN), (Object)typeFactory.createSqlType(SqlTypeName.TINYINT), (Object)typeFactory.createSqlType(SqlTypeName.SMALLINT), (Object)typeFactory.createSqlType(SqlTypeName.INTEGER), (Object)typeFactory.createSqlType(SqlTypeName.BIGINT), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, 5), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, 6, 2), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, maxPrecision, 0), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, maxPrecision, 5), (Object)typeFactory.createSqlType(SqlTypeName.CHAR, 5), (Object)typeFactory.createSqlType(SqlTypeName.VARCHAR, 1), (Object[])new RelDataType[]{typeFactory.createSqlType(SqlTypeName.VARCHAR, 20), typeFactory.createSqlType(SqlTypeName.BINARY, 3), typeFactory.createSqlType(SqlTypeName.VARBINARY, 4), typeFactory.createSqlType(SqlTypeName.DATE), typeFactory.createSqlType(SqlTypeName.TIME, 0), typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 0)});
    }

    @BeforeClass
    public static void setUSLocale() {
        Locale.setDefault(Locale.US);
    }

    @Test
    public void testPrintLimits() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        List<RelDataType> types = SqlLimitsTest.getTypes((RelDataTypeFactory)new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT));
        for (RelDataType type : types) {
            pw.println(type.toString());
            this.printLimit(pw, "  min - epsilon:          ", type, false, SqlTypeName.Limit.OVERFLOW, true);
            this.printLimit(pw, "  min:                    ", type, false, SqlTypeName.Limit.OVERFLOW, false);
            this.printLimit(pw, "  zero - delta:           ", type, false, SqlTypeName.Limit.UNDERFLOW, false);
            this.printLimit(pw, "  zero - delta + epsilon: ", type, false, SqlTypeName.Limit.UNDERFLOW, true);
            this.printLimit(pw, "  zero:                   ", type, false, SqlTypeName.Limit.ZERO, false);
            this.printLimit(pw, "  zero + delta - epsilon: ", type, true, SqlTypeName.Limit.UNDERFLOW, true);
            this.printLimit(pw, "  zero + delta:           ", type, true, SqlTypeName.Limit.UNDERFLOW, false);
            this.printLimit(pw, "  max:                    ", type, true, SqlTypeName.Limit.OVERFLOW, false);
            this.printLimit(pw, "  max + epsilon:          ", type, true, SqlTypeName.Limit.OVERFLOW, true);
            pw.println();
        }
        pw.flush();
        this.getDiffRepos().assertEquals("output", "${output}", sw.toString());
    }

    private void printLimit(PrintWriter pw, String desc, RelDataType type, boolean sign, SqlTypeName.Limit limit, boolean beyond) {
        String s;
        Object o = ((BasicSqlType)type).getLimit(sign, limit, beyond);
        if (o == null) {
            return;
        }
        pw.print(desc);
        if (o instanceof byte[]) {
            int k = 0;
            StringBuilder buf = new StringBuilder("{");
            for (byte b : (byte[])o) {
                if (k++ > 0) {
                    buf.append(", ");
                }
                buf.append(Integer.toHexString(b & 0xFF));
            }
            buf.append("}");
            s = buf.toString();
        } else if (o instanceof Calendar) {
            Calendar calendar = (Calendar)o;
            DateFormat dateFormat = this.getDateFormat(type.getSqlTypeName());
            dateFormat.setTimeZone(DateTimeUtils.UTC_ZONE);
            s = dateFormat.format(calendar.getTime());
        } else {
            s = o.toString();
        }
        pw.print(s);
        SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
        pw.print("; as SQL: ");
        pw.print(literal.toSqlString(AnsiSqlDialect.DEFAULT));
        pw.println();
    }

    private DateFormat getDateFormat(SqlTypeName typeName) {
        switch (typeName) {
            case DATE: {
                return new SimpleDateFormat("MMM d, yyyy", Locale.ROOT);
            }
            case TIME: {
                return new SimpleDateFormat("hh:mm:ss a", Locale.ROOT);
            }
        }
        return new SimpleDateFormat("MMM d, yyyy hh:mm:ss a", Locale.ROOT);
    }
}

