/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RexImplicationChecker;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class RexImplicationCheckerTest {
    @Test
    public void testSimpleGreaterCond() {
        Fixture f = new Fixture();
        RexNode iGt10 = f.gt(f.i, (RexNode)f.literal(10));
        RexNode iGt30 = f.gt(f.i, (RexNode)f.literal(30));
        RexNode iGe30 = f.ge(f.i, (RexNode)f.literal(30));
        RexNode iGe10 = f.ge(f.i, (RexNode)f.literal(10));
        RexNode iEq30 = f.eq(f.i, (RexNode)f.literal(30));
        RexNode iNe10 = f.ne(f.i, (RexNode)f.literal(10));
        f.checkImplies(iGt30, iGt10);
        f.checkNotImplies(iGt10, iGt30);
        f.checkNotImplies(iGt10, iGe30);
        f.checkImplies(iGe30, iGt10);
        f.checkImplies(iEq30, iGt10);
        f.checkNotImplies(iGt10, iEq30);
        f.checkNotImplies(iGt10, iNe10);
        f.checkNotImplies(iGe10, iNe10);
        f.checkImplies(iGt10, iGt10);
        f.checkImplies(iGe30, iGe30);
    }

    @Test
    public void testSimpleLesserCond() {
        Fixture f = new Fixture();
        RexNode iLt10 = f.lt(f.i, (RexNode)f.literal(10));
        RexNode iLt30 = f.lt(f.i, (RexNode)f.literal(30));
        RexNode iLe30 = f.le(f.i, (RexNode)f.literal(30));
        RexNode iLe10 = f.le(f.i, (RexNode)f.literal(10));
        RexNode iEq10 = f.eq(f.i, (RexNode)f.literal(10));
        RexNode iNe10 = f.ne(f.i, (RexNode)f.literal(10));
        f.checkImplies(iLt10, iLt30);
        f.checkNotImplies(iLt30, iLt10);
        f.checkImplies(iLt10, iLe30);
        f.checkNotImplies(iLe30, iLt10);
        f.checkImplies(iEq10, iLt30);
        f.checkNotImplies(iLt30, iEq10);
        f.checkNotImplies(iLt10, iEq10);
        f.checkNotImplies(iLt10, iNe10);
        f.checkNotImplies(iLe10, iNe10);
        f.checkImplies(iLt10, iLt10);
        f.checkImplies(iLe30, iLe30);
    }

    @Test
    public void testSimpleEq() {
        Fixture f = new Fixture();
        RexNode iEq30 = f.eq(f.i, (RexNode)f.literal(30));
        RexNode iNe10 = f.ne(f.i, (RexNode)f.literal(10));
        RexNode iNe30 = f.ne(f.i, (RexNode)f.literal(30));
        f.checkImplies(iEq30, iEq30);
        f.checkImplies(iNe10, iNe10);
        f.checkImplies(iEq30, iNe10);
        f.checkNotImplies(iNe10, iEq30);
        f.checkNotImplies(iNe30, iEq30);
    }

    @Test
    public void testSimpleDec() {
        Fixture f = new Fixture();
        RexNode node1 = f.lt(f.dec, (RexNode)f.floatLiteral(30.9));
        RexNode node2 = f.lt(f.dec, (RexNode)f.floatLiteral(40.33));
        f.checkImplies(node1, node2);
        f.checkNotImplies(node2, node1);
    }

    @Test
    public void testSimpleBoolean() {
        Fixture f = new Fixture();
        RexNode bEqTrue = f.eq(f.bl, (RexNode)f.rexBuilder.makeLiteral(true));
        RexNode bEqFalse = f.eq(f.bl, (RexNode)f.rexBuilder.makeLiteral(false));
        f.checkNotImplies(bEqTrue, bEqFalse);
    }

    @Test
    public void testSimpleLong() {
        Fixture f = new Fixture();
        RexNode xGeBig = f.ge(f.lg, f.longLiteral(324324L));
        RexNode xGtBigger = f.gt(f.lg, f.longLiteral(324325L));
        RexNode xGeBigger = f.ge(f.lg, f.longLiteral(324325L));
        f.checkImplies(xGtBigger, xGeBig);
        f.checkImplies(xGtBigger, xGeBigger);
        f.checkImplies(xGeBigger, xGeBig);
        f.checkNotImplies(xGeBig, xGtBigger);
    }

    @Test
    public void testSimpleShort() {
        Fixture f = new Fixture();
        RexNode xGe10 = f.ge(f.sh, f.shortLiteral((short)10));
        RexNode xGe11 = f.ge(f.sh, f.shortLiteral((short)11));
        f.checkImplies(xGe11, xGe10);
        f.checkNotImplies(xGe10, xGe11);
    }

    @Test
    public void testSimpleChar() {
        Fixture f = new Fixture();
        RexNode xGeB = f.ge(f.ch, (RexNode)f.charLiteral("b"));
        RexNode xGeA = f.ge(f.ch, (RexNode)f.charLiteral("a"));
        f.checkImplies(xGeB, xGeA);
        f.checkNotImplies(xGeA, xGeB);
    }

    @Test
    public void testSimpleString() {
        Fixture f = new Fixture();
        RexNode node1 = f.eq(f.str, (RexNode)f.rexBuilder.makeLiteral("en"));
        f.checkImplies(node1, node1);
    }

    @Test
    public void testSimpleDate() {
        Fixture f = new Fixture();
        DateString d = DateString.fromCalendarFields((Calendar)Util.calendar());
        RexNode node1 = f.ge(f.d, f.dateLiteral(d));
        RexNode node2 = f.eq(f.d, f.dateLiteral(d));
        f.checkImplies(node2, node1);
        f.checkNotImplies(node1, node2);
        DateString dBeforeEpoch1 = DateString.fromDaysSinceEpoch((int)-12345);
        DateString dBeforeEpoch2 = DateString.fromDaysSinceEpoch((int)-123);
        RexNode nodeBe1 = f.lt(f.d, f.dateLiteral(dBeforeEpoch1));
        RexNode nodeBe2 = f.lt(f.d, f.dateLiteral(dBeforeEpoch2));
        f.checkImplies(nodeBe1, nodeBe2);
        f.checkNotImplies(nodeBe2, nodeBe1);
    }

    @Test
    public void testSimpleTimeStamp() {
        Fixture f = new Fixture();
        TimestampString ts = TimestampString.fromCalendarFields((Calendar)Util.calendar());
        RexNode node1 = f.lt(f.ts, f.timestampLiteral(ts));
        RexNode node2 = f.le(f.ts, f.timestampLiteral(ts));
        f.checkImplies(node1, node2);
        f.checkNotImplies(node2, node1);
        TimestampString tsBeforeEpoch1 = TimestampString.fromMillisSinceEpoch((long)-1234567890L);
        TimestampString tsBeforeEpoch2 = TimestampString.fromMillisSinceEpoch((long)-1234567L);
        RexNode nodeBe1 = f.lt(f.ts, f.timestampLiteral(tsBeforeEpoch1));
        RexNode nodeBe2 = f.lt(f.ts, f.timestampLiteral(tsBeforeEpoch2));
        f.checkImplies(nodeBe1, nodeBe2);
        f.checkNotImplies(nodeBe2, nodeBe1);
    }

    @Test
    public void testSimpleTime() {
        Fixture f = new Fixture();
        TimeString t = TimeString.fromCalendarFields((Calendar)Util.calendar());
        RexNode node1 = f.lt(f.t, f.timeLiteral(t));
        RexNode node2 = f.le(f.t, f.timeLiteral(t));
        f.checkImplies(node1, node2);
        f.checkNotImplies(node2, node1);
    }

    @Test
    public void testSimpleBetween() {
        Fixture f = new Fixture();
        RexNode iGe30 = f.ge(f.i, (RexNode)f.literal(30));
        RexNode iLt70 = f.lt(f.i, (RexNode)f.literal(70));
        RexNode iGe30AndLt70 = f.and(iGe30, iLt70);
        RexNode iGe50 = f.ge(f.i, (RexNode)f.literal(50));
        RexNode iLt60 = f.lt(f.i, (RexNode)f.literal(60));
        RexNode iGe50AndLt60 = f.and(iGe50, iLt60);
        f.checkNotImplies(iGe30AndLt70, iGe50);
        f.checkNotImplies(iGe30AndLt70, iLt60);
        f.checkNotImplies(iGe30AndLt70, iGe50AndLt60);
        f.checkNotImplies(iGe30, iGe50AndLt60);
        f.checkNotImplies(iLt70, iGe50AndLt60);
        f.checkImplies(iGe50AndLt60, iGe30AndLt70);
        f.checkImplies(iGe50AndLt60, iLt70);
        f.checkImplies(iGe50AndLt60, iGe30);
    }

    @Test
    public void testSimpleBetweenCornerCases() {
        Fixture f = new Fixture();
        RexNode node1 = f.gt(f.i, (RexNode)f.literal(30));
        RexNode node2 = f.gt(f.i, (RexNode)f.literal(50));
        RexNode node3 = f.lt(f.i, (RexNode)f.literal(60));
        RexNode node4 = f.lt(f.i, (RexNode)f.literal(80));
        RexNode node5 = f.lt(f.i, (RexNode)f.literal(90));
        RexNode node6 = f.lt(f.i, (RexNode)f.literal(100));
        f.checkNotImplies(f.and(node1, node2), f.and(node3, node4));
        f.checkNotImplies(f.and(node5, node6), f.and(node3, node4));
        f.checkNotImplies(f.and(node1, node2), node6);
        f.checkNotImplies(node6, f.and(node1, node2));
        f.checkImplies(f.and(node3, node4), f.and(node5, node6));
    }

    @Test
    public void testOr() {
        Fixture f = new Fixture();
        RexNode xGt1 = f.gt(f.i, (RexNode)f.literal(1));
        RexNode yGt2 = f.gt(f.dec, (RexNode)f.literal(2));
        RexNode yGt3 = f.gt(f.dec, (RexNode)f.literal(3));
        RexNode zGt4 = f.gt(f.lg, (RexNode)f.literal(4));
        RexNode zGt5 = f.gt(f.lg, (RexNode)f.literal(5));
        RexNode yGt2AndZGt4 = f.and(yGt2, zGt4);
        RexNode yGt3AndZGt5 = f.and(yGt3, zGt5);
        RexNode or = f.or(xGt1, yGt2AndZGt4);
        f.checkImplies(yGt3AndZGt5, or);
    }

    @Test
    public void testNotNull() {
        Fixture f = new Fixture();
        RexNode node1 = f.eq(f.str, (RexNode)f.rexBuilder.makeLiteral("en"));
        RexNode node2 = f.notNull(f.str);
        RexNode node3 = f.gt(f.str, (RexNode)f.rexBuilder.makeLiteral("abc"));
        f.checkImplies(node1, node2);
        f.checkNotImplies(node2, node1);
        f.checkImplies(node3, node2);
        f.checkImplies(node2, node2);
    }

    @Test
    public void testIsNull() {
        Fixture f = new Fixture();
        RexNode sEqEn = f.eq(f.str, (RexNode)f.charLiteral("en"));
        RexNode sIsNotNull = f.notNull(f.str);
        RexNode sIsNull = f.isNull(f.str);
        RexNode iEq5 = f.eq(f.i, (RexNode)f.literal(5));
        RexNode iIsNull = f.isNull(f.i);
        RexNode iIsNotNull = f.notNull(f.i);
        f.checkNotImplies(sIsNotNull, sIsNull);
        f.checkNotImplies(sIsNull, sIsNotNull);
        f.checkNotImplies(sEqEn, sIsNull);
        f.checkNotImplies(sIsNull, sEqEn);
        f.checkImplies(sEqEn, sIsNotNull);
        f.checkImplies(sIsNotNull, sIsNotNull);
        f.checkImplies(sIsNull, sIsNull);
        f.checkImplies(f.and(sIsNotNull, iEq5), sIsNotNull);
        f.checkImplies(f.and(iEq5, sIsNotNull), sIsNotNull);
        f.checkNotImplies(iIsNull, sIsNotNull);
        f.checkNotImplies(f.or(sIsNotNull, iEq5), sIsNotNull);
        f.checkImplies(sIsNotNull, f.or(sIsNotNull, iEq5));
        f.checkImplies(sIsNotNull, f.or(iEq5, sIsNotNull));
        f.checkImplies(f.gt(f.i, (RexNode)f.literal(10)), iIsNotNull);
        f.checkImplies(f.gt((RexNode)f.literal(-20), f.i), iIsNotNull);
        f.checkImplies(f.and(sIsNull, f.gt((RexNode)f.literal(-20), f.i)), iIsNotNull);
        f.checkNotImplies(f.gt(f.i, (RexNode)f.literal(10)), iIsNull);
    }

    @Test
    public void testSimplifyCastMatchNullability() {
        Fixture f = new Fixture();
        RexNode e = f.cast(f.intRelDataType, (RexNode)f.literal(2014));
        Assert.assertThat((Object)f.simplify.simplifyPreservingType(e, RexUnknownAs.UNKNOWN, true).toString(), (Matcher)Is.is((Object)"CAST(2014):JavaType(class java.lang.Integer)"));
        Assert.assertThat((Object)f.simplify.simplifyPreservingType(e, RexUnknownAs.UNKNOWN, false).toString(), (Matcher)Is.is((Object)"2014"));
        RelDataType notNullIntRelDataType = f.typeFactory.createJavaType(Integer.TYPE);
        RexNode e2 = f.cast(notNullIntRelDataType, f.cast(notNullIntRelDataType, (RexNode)f.literal(2014)));
        Assert.assertThat((Object)f.simplify.simplifyPreservingType(e2, RexUnknownAs.UNKNOWN, true).toString(), (Matcher)Is.is((Object)"2014"));
        Assert.assertThat((Object)f.simplify.simplifyPreservingType(e2, RexUnknownAs.UNKNOWN, false).toString(), (Matcher)Is.is((Object)"2014"));
    }

    @Test
    public void testSimplifyCeilFloor() {
        RexCall ceilSimplifiedExpr;
        RexCall floorSimplifiedExpr;
        RexNode outerCeilCall;
        RexNode outerFloorCall;
        int j;
        RexNode innerCeilCall;
        RexNode innerFloorCall;
        int i;
        ImmutableList timeUnitRanges = ImmutableList.of((Object)TimeUnitRange.YEAR, (Object)TimeUnitRange.MONTH);
        Fixture f = new Fixture();
        RexNode literalTs = f.timestampLiteral(new TimestampString("2010-10-10 00:00:00"));
        for (i = 0; i < timeUnitRanges.size(); ++i) {
            innerFloorCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{literalTs, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(i))});
            innerCeilCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CEIL, new RexNode[]{literalTs, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(i))});
            for (j = 0; j <= i; ++j) {
                outerFloorCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{innerFloorCall, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(j))});
                outerCeilCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CEIL, new RexNode[]{innerCeilCall, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(j))});
                floorSimplifiedExpr = (RexCall)f.simplify.simplifyPreservingType(outerFloorCall, RexUnknownAs.UNKNOWN, true);
                Assert.assertThat((Object)floorSimplifiedExpr.getKind(), (Matcher)Is.is((Object)SqlKind.FLOOR));
                Assert.assertThat((Object)((RexLiteral)floorSimplifiedExpr.getOperands().get(1)).getValue().toString(), (Matcher)Is.is((Object)((TimeUnitRange)timeUnitRanges.get(j)).toString()));
                Assert.assertThat((Object)((RexNode)floorSimplifiedExpr.getOperands().get(0)).toString(), (Matcher)Is.is((Object)literalTs.toString()));
                ceilSimplifiedExpr = (RexCall)f.simplify.simplifyPreservingType(outerCeilCall, RexUnknownAs.UNKNOWN, true);
                Assert.assertThat((Object)ceilSimplifiedExpr.getKind(), (Matcher)Is.is((Object)SqlKind.CEIL));
                Assert.assertThat((Object)((RexLiteral)ceilSimplifiedExpr.getOperands().get(1)).getValue().toString(), (Matcher)Is.is((Object)((TimeUnitRange)timeUnitRanges.get(j)).toString()));
                Assert.assertThat((Object)((RexNode)ceilSimplifiedExpr.getOperands().get(0)).toString(), (Matcher)Is.is((Object)literalTs.toString()));
            }
        }
        for (i = timeUnitRanges.size() - 1; i >= 0; --i) {
            innerFloorCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{literalTs, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(i))});
            innerCeilCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CEIL, new RexNode[]{literalTs, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(i))});
            for (j = timeUnitRanges.size() - 1; j > i; --j) {
                outerFloorCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{innerFloorCall, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(j))});
                outerCeilCall = f.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CEIL, new RexNode[]{innerCeilCall, f.rexBuilder.makeFlag((Enum)timeUnitRanges.get(j))});
                floorSimplifiedExpr = (RexCall)f.simplify.simplifyPreservingType(outerFloorCall, RexUnknownAs.UNKNOWN, true);
                Assert.assertThat((Object)floorSimplifiedExpr.toString(), (Matcher)Is.is((Object)outerFloorCall.toString()));
                ceilSimplifiedExpr = (RexCall)f.simplify.simplifyPreservingType(outerCeilCall, RexUnknownAs.UNKNOWN, true);
                Assert.assertThat((Object)ceilSimplifiedExpr.toString(), (Matcher)Is.is((Object)outerCeilCall.toString()));
            }
        }
    }

    public static class Fixture {
        public final RelDataTypeFactory typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        public final RexBuilder rexBuilder = new RexBuilder(this.typeFactory);
        public final RelDataType boolRelDataType = this.typeFactory.createJavaType(Boolean.class);
        public final RelDataType intRelDataType = this.typeFactory.createJavaType(Integer.class);
        public final RelDataType decRelDataType = this.typeFactory.createJavaType(Double.class);
        public final RelDataType longRelDataType = this.typeFactory.createJavaType(Long.class);
        public final RelDataType shortDataType = this.typeFactory.createJavaType(Short.class);
        public final RelDataType byteDataType = this.typeFactory.createJavaType(Byte.class);
        public final RelDataType floatDataType = this.typeFactory.createJavaType(Float.class);
        public final RelDataType charDataType = this.typeFactory.createJavaType(Character.class);
        public final RelDataType dateDataType = this.typeFactory.createJavaType(Date.class);
        public final RelDataType timestampDataType = this.typeFactory.createJavaType(Timestamp.class);
        public final RelDataType timeDataType = this.typeFactory.createJavaType(Time.class);
        public final RelDataType stringDataType = this.typeFactory.createJavaType(String.class);
        public final RexNode bl = this.ref(0, this.boolRelDataType);
        public final RexNode i = this.ref(1, this.intRelDataType);
        public final RexNode dec = this.ref(2, this.decRelDataType);
        public final RexNode lg = this.ref(3, this.longRelDataType);
        public final RexNode sh = this.ref(4, this.shortDataType);
        public final RexNode by = this.ref(5, this.byteDataType);
        public final RexNode fl = this.ref(6, this.floatDataType);
        public final RexNode d;
        public final RexNode ch = this.ref(7, this.charDataType);
        public final RexNode ts;
        public final RexNode t;
        public final RexNode str;
        public final RexImplicationChecker checker;
        public final RelDataType rowType;
        public final RexExecutorImpl executor;
        public final RexSimplify simplify;

        public Fixture() {
            this.d = this.ref(8, this.dateDataType);
            this.ts = this.ref(9, this.timestampDataType);
            this.t = this.ref(10, this.timeDataType);
            this.str = this.ref(11, this.stringDataType);
            this.rowType = this.typeFactory.builder().add("bool", this.boolRelDataType).add("int", this.intRelDataType).add("dec", this.decRelDataType).add("long", this.longRelDataType).add("short", this.shortDataType).add("byte", this.byteDataType).add("float", this.floatDataType).add("char", this.charDataType).add("date", this.dateDataType).add("timestamp", this.timestampDataType).add("time", this.timeDataType).add("string", this.stringDataType).build();
            final Holder holder = Holder.of(null);
            Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(){

                public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                    DataContext dataContext = Schemas.createDataContext((Connection)statement.getConnection(), (SchemaPlus)rootSchema);
                    holder.set((Object)new RexExecutorImpl(dataContext));
                    return null;
                }
            });
            this.executor = (RexExecutorImpl)holder.get();
            this.simplify = new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, (RexExecutor)this.executor).withParanoid(true);
            this.checker = new RexImplicationChecker(this.rexBuilder, this.executor, this.rowType);
        }

        public RexInputRef ref(int i, RelDataType type) {
            return new RexInputRef(i, this.typeFactory.createTypeWithNullability(type, true));
        }

        public RexLiteral literal(int i) {
            return this.rexBuilder.makeExactLiteral(new BigDecimal(i));
        }

        public RexNode gt(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{node1, node2});
        }

        public RexNode ge(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{node1, node2});
        }

        public RexNode eq(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{node1, node2});
        }

        public RexNode ne(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{node1, node2});
        }

        public RexNode lt(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{node1, node2});
        }

        public RexNode le(RexNode node1, RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{node1, node2});
        }

        public RexNode notNull(RexNode node1) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{node1});
        }

        public RexNode isNull(RexNode node2) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{node2});
        }

        public RexNode and(RexNode ... nodes) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, nodes);
        }

        public RexNode or(RexNode ... nodes) {
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, nodes);
        }

        public RexNode longLiteral(long value) {
            return this.rexBuilder.makeLiteral((Object)value, this.longRelDataType, true);
        }

        public RexNode shortLiteral(short value) {
            return this.rexBuilder.makeLiteral((Object)value, this.shortDataType, true);
        }

        public RexLiteral floatLiteral(double value) {
            return this.rexBuilder.makeApproxLiteral(new BigDecimal(value));
        }

        public RexLiteral charLiteral(String z) {
            return this.rexBuilder.makeCharLiteral(new NlsString(z, null, SqlCollation.COERCIBLE));
        }

        public RexNode dateLiteral(DateString d) {
            return this.rexBuilder.makeDateLiteral(d);
        }

        public RexNode timestampLiteral(TimestampString ts) {
            return this.rexBuilder.makeTimestampLiteral(ts, this.timestampDataType.getPrecision());
        }

        public RexNode timestampLocalTzLiteral(TimestampString ts) {
            return this.rexBuilder.makeTimestampWithLocalTimeZoneLiteral(ts, this.timestampDataType.getPrecision());
        }

        public RexNode timeLiteral(TimeString t) {
            return this.rexBuilder.makeTimeLiteral(t, this.timeDataType.getPrecision());
        }

        public RexNode cast(RelDataType type, RexNode exp) {
            return this.rexBuilder.makeCast(type, exp, true);
        }

        void checkImplies(RexNode node1, RexNode node2) {
            String message = node1 + " does not imply " + node2 + " when it should";
            Assert.assertTrue((String)message, (boolean)this.checker.implies(node1, node2));
        }

        void checkNotImplies(RexNode node1, RexNode node2) {
            String message = node1 + " does implies " + node2 + " when it should not";
            Assert.assertFalse((String)message, (boolean)this.checker.implies(node1, node2));
        }
    }
}

