/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdColumnUniqueness;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcAdapterTest;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.test.MockRelOptPlanner;
import org.apache.calcite.test.RelBuilderTest;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.SaffronProperties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class RelMetadataTest
extends SqlToRelTestBase {
    private static final double EPSILON = 1.0E-5;
    private static final double DEFAULT_EQUAL_SELECTIVITY = 0.15;
    private static final double DEFAULT_EQUAL_SELECTIVITY_SQUARED = 0.0225;
    private static final double DEFAULT_COMP_SELECTIVITY = 0.5;
    private static final double DEFAULT_NOTNULL_SELECTIVITY = 0.9;
    private static final double DEFAULT_SELECTIVITY = 0.25;
    private static final double EMP_SIZE = 14.0;
    private static final double DEPT_SIZE = 4.0;
    private static final List<String> EMP_QNAME = ImmutableList.of((Object)"CATALOG", (Object)"SALES", (Object)"EMP");
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final SqlOperator NONDETERMINISTIC_OP = new SqlSpecialOperator("NDC", SqlKind.OTHER_FUNCTION, 0, false, ReturnTypes.BOOLEAN, null, null){

        public boolean isDeterministic() {
            return false;
        }
    };

    private RelNode convertSql(String sql) {
        RelRoot root = this.tester.convertSqlToRel(sql);
        root.rel.getCluster().setMetadataProvider((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
        return root.rel;
    }

    private void checkPercentageOriginalRows(String sql, double expected) {
        this.checkPercentageOriginalRows(sql, expected, 1.0E-5);
    }

    private void checkPercentageOriginalRows(String sql, double expected, double epsilon) {
        RelNode rel = this.convertSql(sql);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Double result = mq.getPercentageOriginalRows(rel);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)epsilon);
    }

    @Test
    public void testPercentageOriginalRowsTableOnly() {
        this.checkPercentageOriginalRows("select * from dept", 1.0);
    }

    @Test
    public void testPercentageOriginalRowsAgg() {
        this.checkPercentageOriginalRows("select deptno from dept group by deptno", 1.0);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsOneFilter() {
        this.checkPercentageOriginalRows("select * from dept where deptno = 20", 0.15);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsTwoFilters() {
        this.checkPercentageOriginalRows("select * from (\n  select * from dept where name='X')\nwhere deptno = 20", 0.0225);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsRedundantFilter() {
        this.checkPercentageOriginalRows("select * from (\n  select * from dept where deptno=20)\nwhere deptno = 20", 0.15);
    }

    @Test
    public void testPercentageOriginalRowsJoin() {
        this.checkPercentageOriginalRows("select * from emp inner join dept on emp.deptno=dept.deptno", 1.0);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsJoinTwoFilters() {
        this.checkPercentageOriginalRows("select * from (\n  select * from emp where deptno=10) e\ninner join (select * from dept where deptno=10) d\non e.deptno=d.deptno", 0.0225);
    }

    @Test
    public void testPercentageOriginalRowsUnionNoFilter() {
        this.checkPercentageOriginalRows("select name from dept union all select ename from emp", 1.0);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsUnionLittleFilter() {
        this.checkPercentageOriginalRows("select name from dept where deptno=20 union all select ename from emp", 0.8111111111111111);
    }

    @Ignore
    @Test
    public void testPercentageOriginalRowsUnionBigFilter() {
        this.checkPercentageOriginalRows("select name from dept union all select ename from emp where deptno=20", 0.33888888888888885);
    }

    private Set<RelColumnOrigin> checkColumnOrigin(String sql) {
        RelNode rel = this.convertSql(sql);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        return mq.getColumnOrigins(rel, 0);
    }

    private void checkNoColumnOrigin(String sql) {
        Set<RelColumnOrigin> result = this.checkColumnOrigin(sql);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    public static void checkColumnOrigin(RelColumnOrigin rco, String expectedTableName, String expectedColumnName, boolean expectedDerived) {
        RelOptTable actualTable = rco.getOriginTable();
        List actualTableName = actualTable.getQualifiedName();
        Assert.assertEquals((Object)Iterables.getLast((Iterable)actualTableName), (Object)expectedTableName);
        Assert.assertEquals((Object)((RelDataTypeField)actualTable.getRowType().getFieldList().get(rco.getOriginColumnOrdinal())).getName(), (Object)expectedColumnName);
        Assert.assertEquals((Object)rco.isDerived(), (Object)expectedDerived);
    }

    private void checkSingleColumnOrigin(String sql, String expectedTableName, String expectedColumnName, boolean expectedDerived) {
        Set<RelColumnOrigin> result = this.checkColumnOrigin(sql);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)result.size());
        RelColumnOrigin rco = result.iterator().next();
        RelMetadataTest.checkColumnOrigin(rco, expectedTableName, expectedColumnName, expectedDerived);
    }

    private void checkTwoColumnOrigin(String sql, String expectedTableName1, String expectedColumnName1, String expectedTableName2, String expectedColumnName2, boolean expectedDerived) {
        Set<RelColumnOrigin> result = this.checkColumnOrigin(sql);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)result.size());
        for (RelColumnOrigin rco : result) {
            RelOptTable actualTable = rco.getOriginTable();
            List actualTableName = actualTable.getQualifiedName();
            String actualUnqualifiedName = (String)Iterables.getLast((Iterable)actualTableName);
            if (actualUnqualifiedName.equals(expectedTableName1)) {
                RelMetadataTest.checkColumnOrigin(rco, expectedTableName1, expectedColumnName1, expectedDerived);
                continue;
            }
            RelMetadataTest.checkColumnOrigin(rco, expectedTableName2, expectedColumnName2, expectedDerived);
        }
    }

    @Test
    public void testColumnOriginsTableOnly() {
        this.checkSingleColumnOrigin("select name as dname from dept", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsExpression() {
        this.checkSingleColumnOrigin("select upper(name) as dname from dept", "DEPT", "NAME", true);
    }

    @Test
    public void testColumnOriginsDyadicExpression() {
        this.checkTwoColumnOrigin("select name||ename from dept,emp", "DEPT", "NAME", "EMP", "ENAME", true);
    }

    @Test
    public void testColumnOriginsConstant() {
        this.checkNoColumnOrigin("select 'Minstrelsy' as dname from dept");
    }

    @Test
    public void testColumnOriginsFilter() {
        this.checkSingleColumnOrigin("select name as dname from dept where deptno=10", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsJoinLeft() {
        this.checkSingleColumnOrigin("select ename from emp,dept", "EMP", "ENAME", false);
    }

    @Test
    public void testColumnOriginsJoinRight() {
        this.checkSingleColumnOrigin("select name as dname from emp,dept", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsJoinOuter() {
        this.checkSingleColumnOrigin("select name as dname from emp left outer join dept on emp.deptno = dept.deptno", "DEPT", "NAME", true);
    }

    @Test
    public void testColumnOriginsJoinFullOuter() {
        this.checkSingleColumnOrigin("select name as dname from emp full outer join dept on emp.deptno = dept.deptno", "DEPT", "NAME", true);
    }

    @Test
    public void testColumnOriginsAggKey() {
        this.checkSingleColumnOrigin("select name,count(deptno) from dept group by name", "DEPT", "NAME", false);
    }

    @Test
    public void testColumnOriginsAggReduced() {
        this.checkNoColumnOrigin("select count(deptno),name from dept group by name");
    }

    @Test
    public void testColumnOriginsAggCountNullable() {
        this.checkSingleColumnOrigin("select count(mgr),ename from emp group by ename", "EMP", "MGR", true);
    }

    @Test
    public void testColumnOriginsAggCountStar() {
        this.checkNoColumnOrigin("select count(*),name from dept group by name");
    }

    @Test
    public void testColumnOriginsValues() {
        this.checkNoColumnOrigin("values(1,2,3)");
    }

    @Test
    public void testColumnOriginsUnion() {
        this.checkTwoColumnOrigin("select name from dept union all select ename from emp", "DEPT", "NAME", "EMP", "ENAME", false);
    }

    @Test
    public void testColumnOriginsSelfUnion() {
        this.checkSingleColumnOrigin("select ename from emp union all select ename from emp", "EMP", "ENAME", false);
    }

    private void checkRowCount(String sql, double expected, double expectedMin, double expectedMax) {
        RelNode rel = this.convertSql(sql);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Double result = mq.getRowCount(rel);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((double)expected, (double)result, (double)0.0);
        Double max = mq.getMaxRowCount(rel);
        Assert.assertThat((Object)max, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((double)expectedMax, (double)max, (double)0.0);
        Double min = mq.getMinRowCount(rel);
        Assert.assertThat((Object)max, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((double)expectedMin, (double)min, (double)0.0);
    }

    @Test
    public void testRowCountEmp() {
        String sql = "select * from emp";
        this.checkRowCount("select * from emp", 14.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountDept() {
        String sql = "select * from dept";
        this.checkRowCount("select * from dept", 4.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountValues() {
        String sql = "select * from (values (1), (2)) as t(c)";
        this.checkRowCount("select * from (values (1), (2)) as t(c)", 2.0, 2.0, 2.0);
    }

    @Test
    public void testRowCountCartesian() {
        String sql = "select * from emp,dept";
        this.checkRowCount("select * from emp,dept", 56.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountJoin() {
        String sql = "select * from emp\ninner join dept on emp.deptno = dept.deptno";
        this.checkRowCount("select * from emp\ninner join dept on emp.deptno = dept.deptno", 8.4, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountJoinFinite() {
        String sql = "select * from (select * from emp limit 14) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        this.checkRowCount("select * from (select * from emp limit 14) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", 8.4, 0.0, 56.0);
    }

    @Test
    public void testRowCountJoinEmptyFinite() {
        String sql = "select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        this.checkRowCount("select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", 1.0, 0.0, 0.0);
    }

    @Test
    public void testRowCountLeftJoinEmptyFinite() {
        String sql = "select * from (select * from emp limit 0) as emp\nleft join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        this.checkRowCount("select * from (select * from emp limit 0) as emp\nleft join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", 1.0, 0.0, 0.0);
    }

    @Test
    public void testRowCountRightJoinEmptyFinite() {
        String sql = "select * from (select * from emp limit 0) as emp\nright join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        this.checkRowCount("select * from (select * from emp limit 0) as emp\nright join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", 1.0, 0.0, 4.0);
    }

    @Test
    public void testRowCountJoinFiniteEmpty() {
        String sql = "select * from (select * from emp limit 7) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno";
        this.checkRowCount("select * from (select * from emp limit 7) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno", 1.0, 0.0, 0.0);
    }

    @Test
    public void testRowCountJoinEmptyEmpty() {
        String sql = "select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno";
        this.checkRowCount("select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno", 1.0, 0.0, 0.0);
    }

    @Test
    public void testRowCountUnion() {
        String sql = "select ename from emp\nunion all\nselect name from dept";
        this.checkRowCount("select ename from emp\nunion all\nselect name from dept", 18.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountUnionOnFinite() {
        String sql = "select ename from (select * from emp limit 100)\nunion all\nselect name from (select * from dept limit 40)";
        this.checkRowCount("select ename from (select * from emp limit 100)\nunion all\nselect name from (select * from dept limit 40)", 18.0, 0.0, 140.0);
    }

    @Test
    public void testRowCountIntersectOnFinite() {
        String sql = "select ename from (select * from emp limit 100)\nintersect\nselect name from (select * from dept limit 40)";
        this.checkRowCount("select ename from (select * from emp limit 100)\nintersect\nselect name from (select * from dept limit 40)", Math.min(14.0, 4.0), 0.0, 40.0);
    }

    @Test
    public void testRowCountMinusOnFinite() {
        String sql = "select ename from (select * from emp limit 100)\nexcept\nselect name from (select * from dept limit 40)";
        this.checkRowCount("select ename from (select * from emp limit 100)\nexcept\nselect name from (select * from dept limit 40)", 4.0, 0.0, 100.0);
    }

    @Test
    public void testRowCountFilter() {
        String sql = "select * from emp where ename='Mathilda'";
        this.checkRowCount("select * from emp where ename='Mathilda'", 2.1, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountFilterOnFinite() {
        String sql = "select * from (select * from emp limit 10)\nwhere ename='Mathilda'";
        this.checkRowCount("select * from (select * from emp limit 10)\nwhere ename='Mathilda'", 1.5, 0.0, 10.0);
    }

    @Test
    public void testRowCountFilterFalse() {
        String sql = "select * from (values 'a', 'b') as t(x) where false";
        this.checkRowCount("select * from (values 'a', 'b') as t(x) where false", 1.0, 0.0, 0.0);
    }

    @Test
    public void testRowCountSort() {
        String sql = "select * from emp order by ename";
        this.checkRowCount("select * from emp order by ename", 14.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountSortHighLimit() {
        String sql = "select * from emp order by ename limit 123456";
        this.checkRowCount("select * from emp order by ename limit 123456", 14.0, 0.0, 123456.0);
    }

    @Test
    public void testRowCountSortHighOffset() {
        String sql = "select * from emp order by ename offset 123456";
        this.checkRowCount("select * from emp order by ename offset 123456", 1.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountSortHighOffsetLimit() {
        String sql = "select * from emp order by ename limit 5 offset 123456";
        this.checkRowCount("select * from emp order by ename limit 5 offset 123456", 1.0, 0.0, 5.0);
    }

    @Test
    public void testRowCountSortLimit() {
        String sql = "select * from emp order by ename limit 10";
        this.checkRowCount("select * from emp order by ename limit 10", 10.0, 0.0, 10.0);
    }

    @Test
    public void testRowCountSortLimit0() {
        String sql = "select * from emp order by ename limit 10";
        this.checkRowCount("select * from emp order by ename limit 10", 10.0, 0.0, 10.0);
    }

    @Test
    public void testRowCountSortLimitOffset() {
        String sql = "select * from emp order by ename limit 10 offset 5";
        this.checkRowCount("select * from emp order by ename limit 10 offset 5", 9.0, 0.0, 10.0);
    }

    @Test
    public void testRowCountSortLimitOffsetOnFinite() {
        String sql = "select * from (select * from emp limit 12)\norder by ename limit 20 offset 5";
        this.checkRowCount("select * from (select * from emp limit 12)\norder by ename limit 20 offset 5", 7.0, 0.0, 7.0);
    }

    @Test
    public void testRowCountAggregate() {
        String sql = "select deptno from emp group by deptno";
        this.checkRowCount("select deptno from emp group by deptno", 1.4, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountAggregateGroupingSets() {
        String sql = "select deptno from emp\ngroup by grouping sets ((deptno), (ename, deptno))";
        this.checkRowCount("select deptno from emp\ngroup by grouping sets ((deptno), (ename, deptno))", 2.8, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountAggregateGroupingSetsOneEmpty() {
        String sql = "select deptno from emp\ngroup by grouping sets ((deptno), ())";
        this.checkRowCount("select deptno from emp\ngroup by grouping sets ((deptno), ())", 2.8, 0.0, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testRowCountAggregateEmptyKey() {
        String sql = "select count(*) from emp";
        this.checkRowCount("select count(*) from emp", 1.0, 1.0, 1.0);
    }

    @Test
    public void testRowCountFilterAggregateEmptyKey() {
        String sql = "select count(*) from emp where 1 = 0";
        this.checkRowCount("select count(*) from emp where 1 = 0", 1.0, 1.0, 1.0);
    }

    @Test
    public void testRowCountAggregateEmptyKeyOnEmptyTable() {
        String sql = "select count(*) from (select * from emp limit 0)";
        this.checkRowCount("select count(*) from (select * from emp limit 0)", 1.0, 1.0, 1.0);
    }

    private void checkFilterSelectivity(String sql, double expected) {
        RelNode rel = this.convertSql(sql);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Double result = mq.getSelectivity(rel, null);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)1.0E-5);
    }

    @Test
    public void testSelectivityIsNotNullFilter() {
        this.checkFilterSelectivity("select * from emp where mgr is not null", 0.9);
    }

    @Test
    public void testSelectivityIsNotNullFilterOnNotNullColumn() {
        this.checkFilterSelectivity("select * from emp where deptno is not null", 1.0);
    }

    @Test
    public void testSelectivityComparisonFilter() {
        this.checkFilterSelectivity("select * from emp where deptno > 10", 0.5);
    }

    @Test
    public void testSelectivityAndFilter() {
        this.checkFilterSelectivity("select * from emp where ename = 'foo' and deptno = 10", 0.0225);
    }

    @Test
    public void testSelectivityOrFilter() {
        this.checkFilterSelectivity("select * from emp where ename = 'foo' or deptno = 10", 0.25);
    }

    @Test
    public void testSelectivityJoin() {
        this.checkFilterSelectivity("select * from emp join dept using (deptno) where ename = 'foo'", 0.15);
    }

    private void checkRelSelectivity(RelNode rel, double expected) {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Double result = mq.getSelectivity(rel, null);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((double)expected, (double)result, (double)1.0E-5);
    }

    @Test
    public void testSelectivityRedundantFilter() {
        RelNode rel = this.convertSql("select * from emp where deptno = 10");
        this.checkRelSelectivity(rel, 0.15);
    }

    @Test
    public void testSelectivitySort() {
        RelNode rel = this.convertSql("select * from emp where deptno = 10order by ename");
        this.checkRelSelectivity(rel, 0.15);
    }

    @Test
    public void testSelectivityUnion() {
        RelNode rel = this.convertSql("select * from (\n  select * from emp union all select * from emp) where deptno = 10");
        this.checkRelSelectivity(rel, 0.15);
    }

    @Test
    public void testSelectivityAgg() {
        RelNode rel = this.convertSql("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        this.checkRelSelectivity(rel, 0.075);
    }

    @Test
    public void testSelectivityAggCached() {
        RelNode rel = this.convertSql("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        rel.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(rel.getCluster().getMetadataProvider(), rel.getCluster().getPlanner()));
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Double result = mq.getSelectivity(rel, null);
        Assert.assertThat((Object)result, Matchers.within(0.075, 1.0E-5));
    }

    @Test
    public void testMetadataHandlerCacheLimit() {
        Assume.assumeTrue((String)"too slow to run every day, and it does not reproduce the issue", (boolean)CalciteAssert.ENABLE_SLOW);
        Assume.assumeTrue((String)"If cache size is too large, this test may fail and the test won't be to blame", (SaffronProperties.INSTANCE.metadataHandlerCacheMaximumSize().get() < 10000 ? 1 : 0) != 0);
        int iterationCount = 2000;
        RelNode rel = this.convertSql("select * from emp");
        RelMetadataProvider metadataProvider = rel.getCluster().getMetadataProvider();
        RelOptPlanner planner = rel.getCluster().getPlanner();
        for (int i = 0; i < 2000; ++i) {
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)new CachingRelMetadataProvider(metadataProvider, planner)));
            RelMetadataQuery mq = RelMetadataQuery.instance();
            Double result = mq.getRowCount(rel);
            Assert.assertThat((Object)result, Matchers.within(14.0, 0.1));
        }
    }

    @Test
    public void testDistinctRowCountTable() {
        RelNode rel = this.convertSql("select * from emp where deptno = 10");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        ImmutableBitSet groupKey = ImmutableBitSet.of((int[])new int[]{rel.getRowType().getFieldNames().indexOf("DEPTNO")});
        Double result = mq.getDistinctRowCount(rel, groupKey, null);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDistinctRowCountTableEmptyKey() {
        RelNode rel = this.convertSql("select * from emp where deptno = 10");
        ImmutableBitSet groupKey = ImmutableBitSet.of();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Double result = mq.getDistinctRowCount(rel, groupKey, null);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)1.0));
    }

    private void assertUniqueConsistent(RelNode rel) {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set uniqueKeys = mq.getUniqueKeys(rel);
        ImmutableBitSet allCols = ImmutableBitSet.range((int)0, (int)rel.getRowType().getFieldCount());
        for (ImmutableBitSet key : allCols.powerSet()) {
            Boolean result2 = mq.areColumnsUnique(rel, key);
            Assert.assertTrue((result2 == null || result2.booleanValue() == this.isUnique(uniqueKeys, key) ? 1 : 0) != 0);
        }
    }

    private boolean isUnique(Set<ImmutableBitSet> uniqueKeys, ImmutableBitSet key) {
        for (ImmutableBitSet uniqueKey : uniqueKeys) {
            if (!key.contains(uniqueKey)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testJoinUniqueKeys() {
        RelNode rel = this.convertSql("select * from emp join bonus using (ename)");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set result = mq.getUniqueKeys(rel);
        Assert.assertThat((Object)result.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        this.assertUniqueConsistent(rel);
    }

    @Test
    public void testCorrelateUniqueKeys() {
        String sql = "select *\nfrom (select distinct deptno from emp) as e,\n  lateral (\n    select * from dept where dept.deptno = e.deptno)";
        RelNode rel = this.convertSql("select *\nfrom (select distinct deptno from emp) as e,\n  lateral (\n    select * from dept where dept.deptno = e.deptno)");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Assert.assertThat((Object)rel, (Matcher)CoreMatchers.isA(Project.class));
        Project project = (Project)rel;
        Set result = mq.getUniqueKeys((RelNode)project);
        Assert.assertThat((Object)result, RelMetadataTest.sortsAs("[{0}]"));
        Assert.assertThat((Object)project.getInput(), (Matcher)CoreMatchers.isA(Correlate.class));
        Correlate correlate = (Correlate)project.getInput();
        Set result2 = mq.getUniqueKeys((RelNode)correlate);
        Assert.assertThat((Object)result2, RelMetadataTest.sortsAs("[{0}]"));
    }

    @Test
    public void testGroupByEmptyUniqueKeys() {
        RelNode rel = this.convertSql("select count(*) from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set result = mq.getUniqueKeys(rel);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)ImmutableBitSet.of())));
        this.assertUniqueConsistent(rel);
    }

    @Test
    public void testGroupByEmptyHavingUniqueKeys() {
        RelNode rel = this.convertSql("select count(*) from emp where 1 = 1");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set result = mq.getUniqueKeys(rel);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)ImmutableBitSet.of())));
        this.assertUniqueConsistent(rel);
    }

    @Test
    public void testGroupBy() {
        RelNode rel = this.convertSql("select deptno, count(*), sum(sal) from emp\ngroup by deptno");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set result = mq.getUniqueKeys(rel);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)ImmutableBitSet.of((int[])new int[]{0}))));
        this.assertUniqueConsistent(rel);
    }

    @Test
    public void testUnion() {
        RelNode rel = this.convertSql("select deptno from emp\nunion\nselect deptno from dept");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set result = mq.getUniqueKeys(rel);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)ImmutableBitSet.of((int[])new int[]{0}))));
        this.assertUniqueConsistent(rel);
    }

    @Test
    public void testBrokenCustomProvider() {
        ArrayList buf = new ArrayList();
        ColTypeImpl.THREAD_LIST.set(buf);
        String sql = "select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0";
        RelRoot root = this.tester.withClusterFactory(cluster -> {
            cluster.setMetadataProvider(ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)BrokenColTypeImpl.SOURCE, (Object)cluster.getMetadataProvider())));
            return cluster;
        }).convertSqlToRel("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        RelNode rel = root.rel;
        Assert.assertThat((Object)rel, (Matcher)CoreMatchers.instanceOf(LogicalFilter.class));
        MyRelMetadataQuery mq = new MyRelMetadataQuery();
        try {
            Assert.assertThat((Object)this.colType(mq, rel, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-rel"));
            Assert.fail((String)"expected error");
        }
        catch (IllegalArgumentException e) {
            String value = "No handler for method [public abstract java.lang.String org.apache.calcite.test.RelMetadataTest$ColType.getColType(int)] applied to argument of type [interface org.apache.calcite.rel.RelNode]; we recommend you create a catch-all (RelNode) handler";
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"No handler for method [public abstract java.lang.String org.apache.calcite.test.RelMetadataTest$ColType.getColType(int)] applied to argument of type [interface org.apache.calcite.rel.RelNode]; we recommend you create a catch-all (RelNode) handler"));
        }
    }

    public String colType(RelMetadataQuery mq, RelNode rel, int column) {
        if (mq instanceof MyRelMetadataQuery) {
            return ((MyRelMetadataQuery)mq).colType(rel, column);
        }
        return ((ColType)rel.metadata(ColType.class, mq)).getColType(column);
    }

    @Test
    public void testCustomProvider() {
        ArrayList buf = new ArrayList();
        ColTypeImpl.THREAD_LIST.set(buf);
        String sql = "select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0";
        RelRoot root = this.tester.withClusterFactory(cluster -> {
            ImmutableList list = ImmutableList.of((Object)ColTypeImpl.SOURCE, (Object)ColTypeImpl.SOURCE, (Object)cluster.getMetadataProvider());
            cluster.setMetadataProvider(ChainedRelMetadataProvider.of((List)list));
            return cluster;
        }).convertSqlToRel("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        RelNode rel = root.rel;
        Assert.assertThat((Object)rel, (Matcher)CoreMatchers.instanceOf(LogicalFilter.class));
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Assert.assertThat((Object)this.colType(mq, rel, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-rel"));
        Assert.assertThat((Object)this.colType(mq, rel, 1), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1-rel"));
        RelNode input = rel.getInput(0);
        Assert.assertThat((Object)input, (Matcher)CoreMatchers.instanceOf(LogicalAggregate.class));
        Assert.assertThat((Object)this.colType(mq, input, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)((Object)buf).toString(), (Matcher)CoreMatchers.equalTo((Object)"[DEPTNO-rel, EXPR$1-rel, DEPTNO-agg]"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)this.colType(mq, input, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        RelOptPlanner planner = rel.getCluster().getPlanner();
        rel.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(rel.getCluster().getMetadataProvider(), planner));
        Assert.assertThat((Object)this.colType(mq, input, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)this.colType(mq, input, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)this.colType(mq, input, 1), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)this.colType(mq, input, 1), (Matcher)CoreMatchers.equalTo((Object)"EXPR$1-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)this.colType(mq, input, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        long timestamp = planner.getRelMetadataTimestamp(rel);
        Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.equalTo((Object)0L));
        ((MockRelOptPlanner)planner).setRelMetadataTimestamp(timestamp + 1L);
        Assert.assertThat((Object)this.colType(mq, input, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)7));
        Assert.assertThat((Object)this.colType(mq, input, 0), (Matcher)CoreMatchers.equalTo((Object)"DEPTNO-agg"));
        Assert.assertThat((Object)buf.size(), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void testCollation() {
        Project rel = (Project)this.convertSql("select * from emp, dept");
        Join join = (Join)rel.getInput();
        RelOptTable empTable = join.getInput(0).getTable();
        RelOptTable deptTable = join.getInput(1).getTable();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            this.checkCollation(cluster, empTable, deptTable);
            return null;
        });
    }

    private void checkCollation(RelOptCluster cluster, RelOptTable empTable, RelOptTable deptTable) {
        EnumerableMergeJoin join;
        RexBuilder rexBuilder = cluster.getRexBuilder();
        LogicalTableScan empScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)empTable);
        List collations = RelMdCollation.table((RelOptTable)empScan.getTable());
        Assert.assertThat((Object)collations.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        RelCollation collation = RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(0), new RelFieldCollation(1)});
        collations = RelMdCollation.sort((RelCollation)collation);
        Assert.assertThat((Object)collations.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((RelCollation)collations.get(0)).getFieldCollations().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        LogicalSort empSort = LogicalSort.create((RelNode)empScan, (RelCollation)collation, null, null);
        ImmutableList projects = ImmutableList.of((Object)rexBuilder.makeInputRef((RelNode)empSort, 1), (Object)rexBuilder.makeLiteral("foo"), (Object)rexBuilder.makeInputRef((RelNode)empSort, 0), (Object)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{rexBuilder.makeInputRef((RelNode)empSort, 0), rexBuilder.makeInputRef((RelNode)empSort, 3)}));
        RelMetadataQuery mq = RelMetadataQuery.instance();
        collations = RelMdCollation.project((RelMetadataQuery)mq, (RelNode)empSort, (List)projects);
        Assert.assertThat((Object)collations.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((RelCollation)collations.get(0)).getFieldCollations().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((RelFieldCollation)((RelCollation)collations.get(0)).getFieldCollations().get(0)).getFieldIndex(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((RelFieldCollation)((RelCollation)collations.get(0)).getFieldCollations().get(1)).getFieldIndex(), (Matcher)CoreMatchers.equalTo((Object)0));
        LogicalProject project = LogicalProject.create((RelNode)empSort, (List)projects, (List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        LogicalTableScan deptScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)deptTable);
        RelCollation deptCollation = RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(0), new RelFieldCollation(1)});
        LogicalSort deptSort = LogicalSort.create((RelNode)deptScan, (RelCollation)deptCollation, null, null);
        ImmutableIntList leftKeys = ImmutableIntList.of((int[])new int[]{2});
        ImmutableIntList rightKeys = ImmutableIntList.of((int[])new int[]{0});
        try {
            join = EnumerableMergeJoin.create((RelNode)project, (RelNode)deptSort, (RexLiteral)rexBuilder.makeLiteral(true), (ImmutableIntList)leftKeys, (ImmutableIntList)rightKeys, (JoinRelType)JoinRelType.INNER);
        }
        catch (InvalidRelException e) {
            throw new RuntimeException(e);
        }
        collations = RelMdCollation.mergeJoin((RelMetadataQuery)mq, (RelNode)project, (RelNode)deptSort, (ImmutableIntList)leftKeys, (ImmutableIntList)rightKeys);
        Assert.assertThat((Object)collations, (Matcher)CoreMatchers.equalTo((Object)join.getTraitSet().getTraits((RelTraitDef)RelCollationTraitDef.INSTANCE)));
        collations = RelMdCollation.values((RelMetadataQuery)mq, (RelDataType)empTable.getRowType(), (ImmutableList)ImmutableList.of());
        Assert.assertThat((Object)collations.toString(), (Matcher)CoreMatchers.equalTo((Object)"[[0, 1, 2, 3, 4, 5, 6, 7, 8], [1, 2, 3, 4, 5, 6, 7, 8], [2, 3, 4, 5, 6, 7, 8], [3, 4, 5, 6, 7, 8], [4, 5, 6, 7, 8], [5, 6, 7, 8], [6, 7, 8], [7, 8], [8]]"));
        LogicalValues emptyValues = LogicalValues.createEmpty((RelOptCluster)cluster, (RelDataType)empTable.getRowType());
        Assert.assertThat((Object)mq.collations((RelNode)emptyValues), (Matcher)CoreMatchers.equalTo((Object)collations));
        RelDataType rowType = cluster.getTypeFactory().builder().add("a", SqlTypeName.INTEGER).add("b", SqlTypeName.INTEGER).add("c", SqlTypeName.INTEGER).add("d", SqlTypeName.INTEGER).build();
        ImmutableList.Builder tuples = ImmutableList.builder();
        this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 1, 1, 1, 1);
        this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 1, 2, 0, 3);
        this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 2, 3, 2, 2);
        this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 3, 3, 1, 4);
        collations = RelMdCollation.values((RelMetadataQuery)mq, (RelDataType)rowType, (ImmutableList)tuples.build());
        Assert.assertThat((Object)collations.toString(), (Matcher)CoreMatchers.equalTo((Object)"[[0, 1, 2, 3], [1, 3]]"));
        LogicalValues values = LogicalValues.create((RelOptCluster)cluster, (RelDataType)rowType, (ImmutableList)tuples.build());
        Assert.assertThat((Object)mq.collations((RelNode)values), (Matcher)CoreMatchers.equalTo((Object)collations));
    }

    @Test
    public void testColumnUniquenessForValues() {
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelDataType rowType = cluster.getTypeFactory().builder().add("a", SqlTypeName.INTEGER).add("b", SqlTypeName.VARCHAR).build();
            ImmutableList.Builder tuples = ImmutableList.builder();
            this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 1, "X");
            this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 2, "Y");
            this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 3, "X");
            this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 4, "X");
            LogicalValues values = LogicalValues.create((RelOptCluster)cluster, (RelDataType)rowType, (ImmutableList)tuples.build());
            ImmutableBitSet colNone = ImmutableBitSet.of();
            ImmutableBitSet col0 = ImmutableBitSet.of((int[])new int[]{0});
            ImmutableBitSet col1 = ImmutableBitSet.of((int[])new int[]{1});
            ImmutableBitSet colAll = ImmutableBitSet.of((int[])new int[]{0, 1});
            Assert.assertThat((Object)mq.areColumnsUnique((RelNode)values, col0), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)mq.areColumnsUnique((RelNode)values, col1), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)mq.areColumnsUnique((RelNode)values, colAll), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)mq.areColumnsUnique((RelNode)values, colNone), (Matcher)CoreMatchers.is((Object)false));
            RelMdColumnUniqueness handler = (RelMdColumnUniqueness)RelMdColumnUniqueness.SOURCE.handlers(BuiltInMetadata.ColumnUniqueness.DEF).get((Object)BuiltInMethod.COLUMN_UNIQUENESS.method).iterator().next();
            Assert.assertThat((Object)handler.areColumnsUnique((Values)values, mq, col0, false), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)handler.areColumnsUnique((Values)values, mq, col1, false), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)handler.areColumnsUnique((Values)values, mq, colAll, false), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)handler.areColumnsUnique((Values)values, mq, colNone, false), (Matcher)CoreMatchers.is((Object)false));
            return null;
        });
    }

    private void addRow(ImmutableList.Builder<ImmutableList<RexLiteral>> builder, RexBuilder rexBuilder, Object ... values) {
        ImmutableList.Builder b = ImmutableList.builder();
        RelDataType varcharType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
        for (Object value : values) {
            RexLiteral literal = value == null ? rexBuilder.makeNullLiteral(varcharType) : (value instanceof Integer ? rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Integer)value).intValue())) : rexBuilder.makeLiteral((String)value));
            b.add((Object)literal);
        }
        builder.add((Object)b.build());
    }

    @Test
    public void testAverageRowSize() {
        Project rel = (Project)this.convertSql("select * from emp, dept");
        Join join = (Join)rel.getInput();
        RelOptTable empTable = join.getInput(0).getTable();
        RelOptTable deptTable = join.getInput(1).getTable();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            this.checkAverageRowSize(cluster, empTable, deptTable);
            return null;
        });
    }

    private void checkAverageRowSize(RelOptCluster cluster, RelOptTable empTable, RelOptTable deptTable) {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        LogicalTableScan empScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)empTable);
        Double rowSize = mq.getAverageRowSize((RelNode)empScan);
        List columnSizes = mq.getAverageColumnSizes((RelNode)empScan);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)empScan.getRowType().getFieldCount()));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 40.0, 20.0, 4.0, 8.0, 4.0, 4.0, 4.0, 1.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)89.0));
        LogicalValues emptyValues = LogicalValues.createEmpty((RelOptCluster)cluster, (RelDataType)empTable.getRowType());
        rowSize = mq.getAverageRowSize((RelNode)emptyValues);
        columnSizes = mq.getAverageColumnSizes((RelNode)emptyValues);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)emptyValues.getRowType().getFieldCount()));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 40.0, 20.0, 4.0, 8.0, 4.0, 4.0, 4.0, 1.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)89.0));
        RelDataType rowType = cluster.getTypeFactory().builder().add("a", SqlTypeName.INTEGER).add("b", SqlTypeName.VARCHAR).add("c", SqlTypeName.VARCHAR).build();
        ImmutableList.Builder tuples = ImmutableList.builder();
        this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 1, "1234567890", "ABC");
        this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 2, "1", "A");
        this.addRow((ImmutableList.Builder<ImmutableList<RexLiteral>>)tuples, rexBuilder, 3, "2", null);
        LogicalValues values = LogicalValues.create((RelOptCluster)cluster, (RelDataType)rowType, (ImmutableList)tuples.build());
        rowSize = mq.getAverageRowSize((RelNode)values);
        columnSizes = mq.getAverageColumnSizes((RelNode)values);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)values.getRowType().getFieldCount()));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 8.0, 3.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)15.0));
        LogicalUnion union = LogicalUnion.create((List)ImmutableList.of((Object)empScan, (Object)emptyValues), (boolean)true);
        rowSize = mq.getAverageRowSize((RelNode)union);
        columnSizes = mq.getAverageColumnSizes((RelNode)union);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)9));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 40.0, 20.0, 4.0, 8.0, 4.0, 4.0, 4.0, 1.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)89.0));
        LogicalTableScan deptScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)deptTable);
        LogicalFilter filter = LogicalFilter.create((RelNode)deptScan, (RexNode)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{rexBuilder.makeInputRef((RelNode)deptScan, 0), rexBuilder.makeExactLiteral(BigDecimal.TEN)}));
        rowSize = mq.getAverageRowSize((RelNode)filter);
        columnSizes = mq.getAverageColumnSizes((RelNode)filter);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 20.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)24.0));
        LogicalProject deptProject = LogicalProject.create((RelNode)filter, (List)ImmutableList.of((Object)rexBuilder.makeInputRef((RelNode)filter, 0), (Object)rexBuilder.makeInputRef((RelNode)filter, 1), (Object)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeInputRef((RelNode)filter, 0), rexBuilder.makeExactLiteral(BigDecimal.ONE)}), (Object)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, new RexNode[]{rexBuilder.makeInputRef((RelNode)filter, 1)})), (List)null);
        rowSize = mq.getAverageRowSize((RelNode)deptProject);
        columnSizes = mq.getAverageColumnSizes((RelNode)deptProject);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 20.0, 4.0, 4.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)32.0));
        LogicalJoin join = LogicalJoin.create((RelNode)empScan, (RelNode)deptProject, (RexNode)rexBuilder.makeLiteral(true), (Set)ImmutableSet.of(), (JoinRelType)JoinRelType.INNER);
        rowSize = mq.getAverageRowSize((RelNode)join);
        columnSizes = mq.getAverageColumnSizes((RelNode)join);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)13));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 40.0, 20.0, 4.0, 8.0, 4.0, 4.0, 4.0, 1.0, 4.0, 20.0, 4.0, 4.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)121.0));
        LogicalAggregate aggregate = LogicalAggregate.create((RelNode)join, (ImmutableBitSet)ImmutableBitSet.of((int[])new int[]{2, 0}), (List)ImmutableList.of(), (List)ImmutableList.of((Object)AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)false, (boolean)false, (List)ImmutableIntList.of(), (int)-1, (RelCollation)RelCollations.EMPTY, (int)2, (RelNode)join, null, null)));
        rowSize = mq.getAverageRowSize((RelNode)aggregate);
        columnSizes = mq.getAverageColumnSizes((RelNode)aggregate);
        Assert.assertThat((Object)columnSizes.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)columnSizes, (Matcher)CoreMatchers.equalTo(Arrays.asList(4.0, 20.0, 8.0)));
        Assert.assertThat((Object)rowSize, (Matcher)CoreMatchers.equalTo((Object)32.0));
        Assert.assertThat((Object)mq.memory((RelNode)aggregate), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)mq.cumulativeMemoryWithinPhase((RelNode)aggregate), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)mq.cumulativeMemoryWithinPhaseSplit((RelNode)aggregate), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)mq.isPhaseTransition((RelNode)aggregate), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)mq.splitCount((RelNode)aggregate), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testPredicates() {
        Project rel = (Project)this.convertSql("select * from emp, dept");
        Join join = (Join)rel.getInput();
        RelOptTable empTable = join.getInput(0).getTable();
        RelOptTable deptTable = join.getInput(1).getTable();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            this.checkPredicates(cluster, empTable, deptTable);
            return null;
        });
    }

    private void checkPredicates(RelOptCluster cluster, RelOptTable empTable, RelOptTable deptTable) {
        RelBuilder relBuilder = RelBuilder.proto((Object[])new Object[0]).create(cluster, null);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        LogicalTableScan empScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)empTable);
        relBuilder.push((RelNode)empScan);
        RelOptPredicateList predicates = mq.getPulledUpPredicates((RelNode)empScan);
        Assert.assertThat((Object)predicates.pulledUpPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        relBuilder.filter(new RexNode[]{relBuilder.equals((RexNode)relBuilder.field("EMPNO"), relBuilder.literal((Object)BigDecimal.ONE))});
        RelNode filter = relBuilder.peek();
        predicates = mq.getPulledUpPredicates(filter);
        Assert.assertThat((Object)predicates.pulledUpPredicates.toString(), (Matcher)CoreMatchers.is((Object)"[=($0, 1)]"));
        LogicalTableScan deptScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)deptTable);
        relBuilder.push((RelNode)deptScan);
        relBuilder.semiJoin(new RexNode[]{relBuilder.equals((RexNode)relBuilder.field(2, 0, "DEPTNO"), (RexNode)relBuilder.field(2, 1, "DEPTNO"))});
        SemiJoin semiJoin = (SemiJoin)relBuilder.build();
        predicates = mq.getPulledUpPredicates((RelNode)semiJoin);
        Assert.assertThat((Object)predicates.pulledUpPredicates, RelMetadataTest.sortsAs("[=($0, 1)]"));
        Assert.assertThat((Object)predicates.leftInferredPredicates, RelMetadataTest.sortsAs("[]"));
        Assert.assertThat((Object)predicates.rightInferredPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        relBuilder.push(filter);
        relBuilder.push((RelNode)deptScan);
        relBuilder.join(JoinRelType.INNER, relBuilder.equals((RexNode)relBuilder.field(2, 0, "DEPTNO"), (RexNode)relBuilder.field(2, 1, "DEPTNO")));
        relBuilder.project(new RexNode[]{relBuilder.field("DEPTNO")});
        RelNode project = relBuilder.peek();
        predicates = mq.getPulledUpPredicates(project);
        Assert.assertThat((Object)predicates.pulledUpPredicates, RelMetadataTest.sortsAs("[]"));
        Assert.assertThat((Object)project.getRowType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"RecordType(INTEGER NOT NULL DEPTNO) NOT NULL"));
        Assert.assertThat((Object)predicates.leftInferredPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)predicates.rightInferredPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        relBuilder.push(filter);
        relBuilder.push((RelNode)deptScan);
        relBuilder.join(JoinRelType.INNER, relBuilder.equals((RexNode)relBuilder.field(2, 0, "MGR"), (RexNode)relBuilder.field(2, 1, "DEPTNO")));
        relBuilder.project(new RexNode[]{relBuilder.field("MGR")});
        RelNode project2 = relBuilder.peek();
        predicates = mq.getPulledUpPredicates(project2);
        Assert.assertThat((Object)predicates.pulledUpPredicates, RelMetadataTest.sortsAs("[IS NOT NULL($0)]"));
        Assert.assertThat((Object)predicates.leftInferredPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)predicates.rightInferredPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        relBuilder.push(filter);
        relBuilder.project(Iterables.concat((Iterable)relBuilder.fields(), (Iterable)ImmutableList.of((Object)relBuilder.alias(relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{relBuilder.field("MGR"), relBuilder.field("COMM")}), "MGR_COMM"))));
        relBuilder.push((RelNode)deptScan);
        relBuilder.join(JoinRelType.INNER, relBuilder.equals(relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{relBuilder.field(2, 0, "MGR"), relBuilder.field(2, 0, "EMPNO")}), relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{relBuilder.field(2, 1, "DEPTNO"), relBuilder.field(2, 0, "MGR_COMM")})));
        relBuilder.project(new RexNode[]{relBuilder.field("MGR"), relBuilder.field("NAME"), relBuilder.field("MGR_COMM"), relBuilder.field("COMM")});
        RelNode project3 = relBuilder.peek();
        predicates = mq.getPulledUpPredicates(project3);
        Assert.assertThat((Object)predicates.pulledUpPredicates, RelMetadataTest.sortsAs("[OR(IS NOT NULL($0), IS NOT NULL($2))]"));
        Assert.assertThat((Object)predicates.leftInferredPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)predicates.rightInferredPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testPullUpPredicatesFromAggregation() {
        String sql = "select a, max(b) from (\n  select 1 as a, 2 as b from emp)subq\ngroup by a";
        Aggregate rel = (Aggregate)this.convertSql("select a, max(b) from (\n  select 1 as a, 2 as b from emp)subq\ngroup by a");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList inputSet = mq.getPulledUpPredicates((RelNode)rel);
        ImmutableList pulledUpPredicates = inputSet.pulledUpPredicates;
        Assert.assertThat((Object)pulledUpPredicates, RelMetadataTest.sortsAs("[=($0, 1)]"));
    }

    @Test(timeout=20000L)
    public void testPullUpPredicatesForExprsItr() {
        Assume.assumeThat((String)"Too slow to run on Windows", (Object)Character.valueOf(File.separatorChar), (Matcher)Is.is((Object)Character.valueOf('/')));
        String sql = "select a.EMPNO, a.ENAME\nfrom (select * from sales.emp ) a\njoin (select * from sales.emp  ) b\non a.empno = b.deptno\n  and a.comm = b.comm\n  and a.mgr=b.mgr\n  and (a.empno < 10 or a.comm < 3 or a.deptno < 10\n    or a.job ='abc' or a.ename='abc' or a.sal='30' or a.mgr >3\n    or a.slacker is not null  or a.HIREDATE is not null\n    or b.empno < 9 or b.comm < 3 or b.deptno < 10 or b.job ='abc'\n    or b.ename='abc' or b.sal='30' or b.mgr >3 or b.slacker )\njoin emp c\non b.mgr =a.mgr and a.empno =b.deptno and a.comm=b.comm\n  and a.deptno=b.deptno and a.job=b.job and a.ename=b.ename\n  and a.mgr=b.deptno and a.slacker=b.slacker";
        try (JdbcAdapterTest.LockWrapper ignore = JdbcAdapterTest.LockWrapper.lock(LOCK);){
            RelNode rel = this.convertSql("select a.EMPNO, a.ENAME\nfrom (select * from sales.emp ) a\njoin (select * from sales.emp  ) b\non a.empno = b.deptno\n  and a.comm = b.comm\n  and a.mgr=b.mgr\n  and (a.empno < 10 or a.comm < 3 or a.deptno < 10\n    or a.job ='abc' or a.ename='abc' or a.sal='30' or a.mgr >3\n    or a.slacker is not null  or a.HIREDATE is not null\n    or b.empno < 9 or b.comm < 3 or b.deptno < 10 or b.job ='abc'\n    or b.ename='abc' or b.sal='30' or b.mgr >3 or b.slacker )\njoin emp c\non b.mgr =a.mgr and a.empno =b.deptno and a.comm=b.comm\n  and a.deptno=b.deptno and a.job=b.job and a.ename=b.ename\n  and a.mgr=b.deptno and a.slacker=b.slacker");
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList inputSet = mq.getPulledUpPredicates(rel.getInput(0));
            Assert.assertThat((Object)inputSet.pulledUpPredicates.size(), (Matcher)CoreMatchers.is((Object)18));
        }
    }

    @Test
    public void testPullUpPredicatesOnConstant() {
        String sql = "select deptno, mgr, x, 'y' as y, z from (\n  select deptno, mgr, cast(null as integer) as x, cast('1' as int) as z\n  from emp\n  where mgr is null and deptno < 10)";
        RelNode rel = this.convertSql("select deptno, mgr, x, 'y' as y, z from (\n  select deptno, mgr, cast(null as integer) as x, cast('1' as int) as z\n  from emp\n  where mgr is null and deptno < 10)");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList list = mq.getPulledUpPredicates(rel);
        Assert.assertThat((Object)list.pulledUpPredicates, RelMetadataTest.sortsAs("[<($0, 10), =($3, 'y'), =($4, 1), IS NULL($1), IS NULL($2)]"));
    }

    @Test
    public void testPullUpPredicatesOnNullableConstant() {
        String sql = "select nullif(1, 1) as c\n  from emp\n  where mgr is null and deptno < 10";
        RelNode rel = this.convertSql("select nullif(1, 1) as c\n  from emp\n  where mgr is null and deptno < 10");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList list = mq.getPulledUpPredicates(rel);
        Assert.assertThat((Object)list.pulledUpPredicates, RelMetadataTest.sortsAs("[IS NULL($0)]"));
    }

    @Test
    public void testDistributionSimple() {
        RelNode rel = this.convertSql("select * from emp where deptno = 10");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelDistribution d = mq.getDistribution(rel);
        Assert.assertThat((Object)d, (Matcher)CoreMatchers.is((Object)RelDistributions.BROADCAST_DISTRIBUTED));
    }

    @Test
    public void testDistributionHash() {
        RelNode rel = this.convertSql("select * from emp");
        RelDistribution dist = RelDistributions.hash((Collection)ImmutableList.of((Object)1));
        LogicalExchange exchange = LogicalExchange.create((RelNode)rel, (RelDistribution)dist);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelDistribution d = mq.getDistribution((RelNode)exchange);
        Assert.assertThat((Object)d, (Matcher)CoreMatchers.is((Object)dist));
    }

    @Test
    public void testDistributionHashEmpty() {
        RelNode rel = this.convertSql("select * from emp");
        RelDistribution dist = RelDistributions.hash((Collection)ImmutableList.of());
        LogicalExchange exchange = LogicalExchange.create((RelNode)rel, (RelDistribution)dist);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelDistribution d = mq.getDistribution((RelNode)exchange);
        Assert.assertThat((Object)d, (Matcher)CoreMatchers.is((Object)dist));
    }

    @Test
    public void testDistributionSingleton() {
        RelNode rel = this.convertSql("select * from emp");
        RelDistribution dist = RelDistributions.SINGLETON;
        LogicalExchange exchange = LogicalExchange.create((RelNode)rel, (RelDistribution)dist);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelDistribution d = mq.getDistribution((RelNode)exchange);
        Assert.assertThat((Object)d, (Matcher)CoreMatchers.is((Object)dist));
    }

    @Test
    public void testLinear() {
        Assert.assertThat((Object)RelMdUtil.linear((int)0, (int)0, (int)10, (double)100.0, (double)200.0), (Matcher)CoreMatchers.is((Object)100.0));
        Assert.assertThat((Object)RelMdUtil.linear((int)5, (int)0, (int)10, (double)100.0, (double)200.0), (Matcher)CoreMatchers.is((Object)150.0));
        Assert.assertThat((Object)RelMdUtil.linear((int)6, (int)0, (int)10, (double)100.0, (double)200.0), (Matcher)CoreMatchers.is((Object)160.0));
        Assert.assertThat((Object)RelMdUtil.linear((int)10, (int)0, (int)10, (double)100.0, (double)200.0), (Matcher)CoreMatchers.is((Object)200.0));
        Assert.assertThat((Object)RelMdUtil.linear((int)-2, (int)0, (int)10, (double)100.0, (double)200.0), (Matcher)CoreMatchers.is((Object)100.0));
        Assert.assertThat((Object)RelMdUtil.linear((int)12, (int)0, (int)10, (double)100.0, (double)200.0), (Matcher)CoreMatchers.is((Object)200.0));
    }

    @Test
    public void testExpressionLineageStar() {
        RelNode tableRel = this.convertSql("select * from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)4, (List)tableRel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(tableRel, (RexNode)ref);
        String inputRef = RexInputRef.of((int)4, (List)tableRel.getRowType().getFieldList()).toString();
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        String resultString = ((RexNode)r.iterator().next()).toString();
        Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.startsWith((String)EMP_QNAME.toString()));
        Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.endsWith((String)inputRef));
    }

    @Test
    public void testExpressionLineageTwoColumns() {
        RelNode rel = this.convertSql("select mgr, deptno from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref1 = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r1 = mq.getExpressionLineage(rel, (RexNode)ref1);
        Assert.assertThat((Object)r1.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result1 = (RexTableInputRef)r1.iterator().next();
        Assert.assertEquals((Object)result1.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)result1.getIndex(), (Matcher)CoreMatchers.is((Object)3));
        RexInputRef ref2 = RexInputRef.of((int)1, (List)rel.getRowType().getFieldList());
        Set r2 = mq.getExpressionLineage(rel, (RexNode)ref2);
        Assert.assertThat((Object)r2.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result2 = (RexTableInputRef)r2.iterator().next();
        Assert.assertEquals((Object)result2.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)result2.getIndex(), (Matcher)CoreMatchers.is((Object)7));
        Assert.assertThat((Object)result1.getIdentifier(), (Matcher)CoreMatchers.is((Object)result2.getIdentifier()));
    }

    @Test
    public void testExpressionLineageTwoColumnsSwapped() {
        RelNode rel = this.convertSql("select deptno, mgr from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref1 = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r1 = mq.getExpressionLineage(rel, (RexNode)ref1);
        Assert.assertThat((Object)r1.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result1 = (RexTableInputRef)r1.iterator().next();
        Assert.assertEquals((Object)result1.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)result1.getIndex(), (Matcher)CoreMatchers.is((Object)7));
        RexInputRef ref2 = RexInputRef.of((int)1, (List)rel.getRowType().getFieldList());
        Set r2 = mq.getExpressionLineage(rel, (RexNode)ref2);
        Assert.assertThat((Object)r2.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result2 = (RexTableInputRef)r2.iterator().next();
        Assert.assertEquals((Object)result2.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)result2.getIndex(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)result1.getIdentifier(), (Matcher)CoreMatchers.is((Object)result2.getIdentifier()));
    }

    @Test
    public void testExpressionLineageCombineTwoColumns() {
        RelNode rel = this.convertSql("select empno + deptno from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        RexNode result = (RexNode)r.iterator().next();
        Assert.assertThat((Object)result.getKind(), (Matcher)CoreMatchers.is((Object)SqlKind.PLUS));
        RexCall call = (RexCall)result;
        Assert.assertThat((Object)call.getOperands().size(), (Matcher)CoreMatchers.is((Object)2));
        RexTableInputRef inputRef1 = (RexTableInputRef)call.getOperands().get(0);
        Assert.assertEquals((Object)inputRef1.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)inputRef1.getIndex(), (Matcher)CoreMatchers.is((Object)0));
        RexTableInputRef inputRef2 = (RexTableInputRef)call.getOperands().get(1);
        Assert.assertEquals((Object)inputRef2.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)inputRef2.getIndex(), (Matcher)CoreMatchers.is((Object)7));
        Assert.assertThat((Object)inputRef1.getIdentifier(), (Matcher)CoreMatchers.is((Object)inputRef2.getIdentifier()));
    }

    @Test
    public void testExpressionLineageInnerJoinLeft() {
        RelNode rel = this.convertSql("select ename from emp,dept");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result = (RexTableInputRef)r.iterator().next();
        Assert.assertEquals((Object)result.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)result.getIndex(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testExpressionLineageInnerJoinRight() {
        RelNode rel = this.convertSql("select bonus.ename from emp join bonus using (ename)");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result = (RexTableInputRef)r.iterator().next();
        Assert.assertEquals((Object)result.getQualifiedName(), (Object)ImmutableList.of((Object)"CATALOG", (Object)"SALES", (Object)"BONUS"));
        Assert.assertThat((Object)result.getIndex(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testExpressionLineageLeftJoinLeft() {
        RelNode rel = this.convertSql("select ename from emp left join dept using (deptno)");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result = (RexTableInputRef)r.iterator().next();
        Assert.assertEquals((Object)result.getQualifiedName(), EMP_QNAME);
        Assert.assertThat((Object)result.getIndex(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testExpressionLineageRightJoinRight() {
        RelNode rel = this.convertSql("select bonus.ename from emp right join bonus using (ename)");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        RexTableInputRef result = (RexTableInputRef)r.iterator().next();
        Assert.assertEquals((Object)result.getQualifiedName(), (Object)ImmutableList.of((Object)"CATALOG", (Object)"SALES", (Object)"BONUS"));
        Assert.assertThat((Object)result.getIndex(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testExpressionLineageSelfJoin() {
        RelNode rel = this.convertSql("select a.deptno, b.sal from (select * from emp limit 7) as a\ninner join (select * from emp limit 2) as b\non a.deptno = b.deptno");
        RelNode tableRel = this.convertSql("select * from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref1 = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r1 = mq.getExpressionLineage(rel, (RexNode)ref1);
        String inputRef1 = RexInputRef.of((int)7, (List)tableRel.getRowType().getFieldList()).toString();
        Assert.assertThat((Object)r1.size(), (Matcher)CoreMatchers.is((Object)1));
        String resultString1 = ((RexNode)r1.iterator().next()).toString();
        Assert.assertThat((Object)resultString1, (Matcher)CoreMatchers.startsWith((String)EMP_QNAME.toString()));
        Assert.assertThat((Object)resultString1, (Matcher)CoreMatchers.endsWith((String)inputRef1));
        RexInputRef ref2 = RexInputRef.of((int)1, (List)rel.getRowType().getFieldList());
        Set r2 = mq.getExpressionLineage(rel, (RexNode)ref2);
        String inputRef2 = RexInputRef.of((int)5, (List)tableRel.getRowType().getFieldList()).toString();
        Assert.assertThat((Object)r2.size(), (Matcher)CoreMatchers.is((Object)1));
        String resultString2 = ((RexNode)r2.iterator().next()).toString();
        Assert.assertThat((Object)resultString2, (Matcher)CoreMatchers.startsWith((String)EMP_QNAME.toString()));
        Assert.assertThat((Object)resultString2, (Matcher)CoreMatchers.endsWith((String)inputRef2));
        Assert.assertThat((Object)((RexTableInputRef)r1.iterator().next()).getIdentifier(), (Matcher)CoreMatchers.not((Object)((RexTableInputRef)r2.iterator().next()).getIdentifier()));
    }

    @Test
    public void testExpressionLineageOuterJoin() {
        RelNode rel = this.convertSql("select name as dname from emp left outer join dept on emp.deptno = dept.deptno");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertNull((Object)r);
    }

    @Test
    public void testExpressionLineageFilter() {
        RelNode rel = this.convertSql("select ename from emp where deptno = 10");
        RelNode tableRel = this.convertSql("select * from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        String inputRef = RexInputRef.of((int)1, (List)tableRel.getRowType().getFieldList()).toString();
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        String resultString = ((RexNode)r.iterator().next()).toString();
        Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.startsWith((String)EMP_QNAME.toString()));
        Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.endsWith((String)inputRef));
    }

    @Test
    public void testExpressionLineageAggregateGroupColumn() {
        RelNode rel = this.convertSql("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        RelNode tableRel = this.convertSql("select * from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        String inputRef = RexInputRef.of((int)7, (List)tableRel.getRowType().getFieldList()).toString();
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)1));
        String resultString = ((RexNode)r.iterator().next()).toString();
        Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.startsWith((String)EMP_QNAME.toString()));
        Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.endsWith((String)inputRef));
    }

    @Test
    public void testExpressionLineageAggregateAggColumn() {
        RelNode rel = this.convertSql("select deptno, count(*) from emp where deptno > 10 group by deptno having count(*) = 0");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)1, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertNull((Object)r);
    }

    @Test
    public void testExpressionLineageUnion() {
        RelNode rel = this.convertSql("select sal from (\n  select * from emp union all select * from emp) where deptno = 10");
        RelNode tableRel = this.convertSql("select * from emp");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        String inputRef = RexInputRef.of((int)5, (List)tableRel.getRowType().getFieldList()).toString();
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)2));
        for (RexNode result : r) {
            String resultString = result.toString();
            Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.startsWith((String)EMP_QNAME.toString()));
            Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.endsWith((String)inputRef));
        }
        Iterator it = r.iterator();
        Assert.assertThat((Object)((RexTableInputRef)it.next()).getIdentifier(), (Matcher)CoreMatchers.not((Object)((RexTableInputRef)it.next()).getIdentifier()));
    }

    @Test
    public void testExpressionLineageMultiUnion() {
        RelNode rel = this.convertSql("select a.empno + b.sal from \n (select empno, ename from emp,dept) a join  (select * from emp union all select * from emp) b \n on a.empno = b.empno \n where b.deptno = 10");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        HashSet<List> set = new HashSet<List>();
        Assert.assertThat((Object)r.size(), (Matcher)CoreMatchers.is((Object)2));
        for (RexNode result : r) {
            Assert.assertThat((Object)result.getKind(), (Matcher)CoreMatchers.is((Object)SqlKind.PLUS));
            RexCall call = (RexCall)result;
            Assert.assertThat((Object)call.getOperands().size(), (Matcher)CoreMatchers.is((Object)2));
            RexTableInputRef inputRef1 = (RexTableInputRef)call.getOperands().get(0);
            Assert.assertEquals((Object)inputRef1.getQualifiedName(), EMP_QNAME);
            set.add(inputRef1.getQualifiedName());
            Assert.assertThat((Object)inputRef1.getIndex(), (Matcher)CoreMatchers.is((Object)0));
            RexTableInputRef inputRef2 = (RexTableInputRef)call.getOperands().get(1);
            Assert.assertEquals((Object)inputRef2.getQualifiedName(), EMP_QNAME);
            Assert.assertThat((Object)inputRef2.getIndex(), (Matcher)CoreMatchers.is((Object)5));
            Assert.assertThat((Object)inputRef1.getIdentifier(), (Matcher)CoreMatchers.not((Object)inputRef2.getIdentifier()));
        }
        Assert.assertThat((Object)set.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testExpressionLineageValues() {
        RelNode rel = this.convertSql("select * from (values (1), (2)) as t(c)");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RexInputRef ref = RexInputRef.of((int)0, (List)rel.getRowType().getFieldList());
        Set r = mq.getExpressionLineage(rel, (RexNode)ref);
        Assert.assertNull((Object)r);
    }

    @Test
    public void testAllPredicates() {
        Project rel = (Project)this.convertSql("select * from emp, dept");
        Join join = (Join)rel.getInput();
        RelOptTable empTable = join.getInput(0).getTable();
        RelOptTable deptTable = join.getInput(1).getTable();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            this.checkAllPredicates(cluster, empTable, deptTable);
            return null;
        });
    }

    private void checkAllPredicates(RelOptCluster cluster, RelOptTable empTable, RelOptTable deptTable) {
        RelBuilder relBuilder = RelBuilder.proto((Object[])new Object[0]).create(cluster, null);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        LogicalTableScan empScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)empTable);
        relBuilder.push((RelNode)empScan);
        RelOptPredicateList predicates = mq.getAllPredicates((RelNode)empScan);
        Assert.assertThat((Object)predicates.pulledUpPredicates.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        relBuilder.filter(new RexNode[]{relBuilder.equals((RexNode)relBuilder.field("EMPNO"), relBuilder.literal((Object)BigDecimal.ONE))});
        RelNode filter = relBuilder.peek();
        predicates = mq.getAllPredicates(filter);
        Assert.assertThat((Object)predicates.pulledUpPredicates.size(), (Matcher)CoreMatchers.is((Object)1));
        RexCall call = (RexCall)predicates.pulledUpPredicates.get(0);
        Assert.assertThat((Object)call.getOperands().size(), (Matcher)CoreMatchers.is((Object)2));
        RexTableInputRef inputRef1 = (RexTableInputRef)call.getOperands().get(0);
        Assert.assertTrue((boolean)inputRef1.getQualifiedName().equals(EMP_QNAME));
        Assert.assertThat((Object)inputRef1.getIndex(), (Matcher)CoreMatchers.is((Object)0));
        LogicalTableScan deptScan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)deptTable);
        relBuilder.push((RelNode)deptScan);
        relBuilder.join(JoinRelType.INNER, relBuilder.equals((RexNode)relBuilder.field(2, 0, "DEPTNO"), (RexNode)relBuilder.field(2, 1, "DEPTNO")));
        relBuilder.project(new RexNode[]{relBuilder.field("DEPTNO")});
        RelNode project = relBuilder.peek();
        predicates = mq.getAllPredicates(project);
        Assert.assertThat((Object)predicates.pulledUpPredicates.size(), (Matcher)CoreMatchers.is((Object)2));
        call = (RexCall)predicates.pulledUpPredicates.get(0);
        Assert.assertThat((Object)call.getOperands().size(), (Matcher)CoreMatchers.is((Object)2));
        inputRef1 = (RexTableInputRef)call.getOperands().get(0);
        Assert.assertTrue((boolean)inputRef1.getQualifiedName().equals(EMP_QNAME));
        Assert.assertThat((Object)inputRef1.getIndex(), (Matcher)CoreMatchers.is((Object)0));
        call = (RexCall)predicates.pulledUpPredicates.get(1);
        Assert.assertThat((Object)call.getOperands().size(), (Matcher)CoreMatchers.is((Object)2));
        inputRef1 = (RexTableInputRef)call.getOperands().get(0);
        Assert.assertTrue((boolean)inputRef1.getQualifiedName().equals(EMP_QNAME));
        Assert.assertThat((Object)inputRef1.getIndex(), (Matcher)CoreMatchers.is((Object)7));
        RexTableInputRef inputRef2 = (RexTableInputRef)call.getOperands().get(1);
        Assert.assertTrue((boolean)inputRef2.getQualifiedName().equals(ImmutableList.of((Object)"CATALOG", (Object)"SALES", (Object)"DEPT")));
        Assert.assertThat((Object)inputRef2.getIndex(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAllPredicatesAggregate1() {
        String sql = "select a, max(b) from (\n  select empno as a, sal as b from emp where empno = 5)subq\ngroup by a";
        RelNode rel = this.convertSql("select a, max(b) from (\n  select empno as a, sal as b from emp where empno = 5)subq\ngroup by a");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList inputSet = mq.getAllPredicates(rel);
        ImmutableList pulledUpPredicates = inputSet.pulledUpPredicates;
        Assert.assertThat((Object)pulledUpPredicates.size(), (Matcher)CoreMatchers.is((Object)1));
        RexCall call = (RexCall)pulledUpPredicates.get(0);
        Assert.assertThat((Object)call.getOperands().size(), (Matcher)CoreMatchers.is((Object)2));
        RexTableInputRef inputRef1 = (RexTableInputRef)call.getOperands().get(0);
        Assert.assertTrue((boolean)inputRef1.getQualifiedName().equals(EMP_QNAME));
        Assert.assertThat((Object)inputRef1.getIndex(), (Matcher)CoreMatchers.is((Object)0));
        RexLiteral constant = (RexLiteral)call.getOperands().get(1);
        Assert.assertThat((Object)constant.toString(), (Matcher)CoreMatchers.is((Object)"5"));
    }

    @Test
    public void testAllPredicatesAggregate2() {
        String sql = "select * from (select a, max(b) from (\n  select empno as a, sal as b from emp)subq\ngroup by a) \nwhere a = 5";
        RelNode rel = this.convertSql("select * from (select a, max(b) from (\n  select empno as a, sal as b from emp)subq\ngroup by a) \nwhere a = 5");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList inputSet = mq.getAllPredicates(rel);
        ImmutableList pulledUpPredicates = inputSet.pulledUpPredicates;
        Assert.assertThat((Object)pulledUpPredicates.size(), (Matcher)CoreMatchers.is((Object)1));
        RexCall call = (RexCall)pulledUpPredicates.get(0);
        Assert.assertThat((Object)call.getOperands().size(), (Matcher)CoreMatchers.is((Object)2));
        RexTableInputRef inputRef1 = (RexTableInputRef)call.getOperands().get(0);
        Assert.assertTrue((boolean)inputRef1.getQualifiedName().equals(EMP_QNAME));
        Assert.assertThat((Object)inputRef1.getIndex(), (Matcher)CoreMatchers.is((Object)0));
        RexLiteral constant = (RexLiteral)call.getOperands().get(1);
        Assert.assertThat((Object)constant.toString(), (Matcher)CoreMatchers.is((Object)"5"));
    }

    @Test
    public void testAllPredicatesAggregate3() {
        String sql = "select * from (select a, max(b) as b from (\n  select empno as a, sal as b from emp)subq\ngroup by a) \nwhere b = 5";
        RelNode rel = this.convertSql("select * from (select a, max(b) as b from (\n  select empno as a, sal as b from emp)subq\ngroup by a) \nwhere b = 5");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList inputSet = mq.getAllPredicates(rel);
        Assert.assertNull((Object)inputSet);
    }

    @Test
    public void testAllPredicatesAndTablesJoin() {
        String sql = "select x.sal, y.deptno from\n(select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno) as x\ninner join\n(select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno) as y\non x.deptno = y.deptno";
        RelNode rel = this.convertSql("select x.sal, y.deptno from\n(select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno) as x\ninner join\n(select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno) as y\non x.deptno = y.deptno");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList inputSet = mq.getAllPredicates(rel);
        Assert.assertThat((Object)inputSet.pulledUpPredicates.toString(), (Matcher)CoreMatchers.equalTo((Object)"[true, =([CATALOG, SALES, EMP].#0.$7, [CATALOG, SALES, EMP].#1.$7), true, =([CATALOG, SALES, EMP].#2.$7, [CATALOG, SALES, EMP].#3.$7), =([CATALOG, SALES, EMP].#0.$7, [CATALOG, SALES, EMP].#2.$7)]"));
        TreeSet tableReferences = Sets.newTreeSet((Iterable)mq.getTableReferences(rel));
        Assert.assertThat((Object)((Object)tableReferences).toString(), (Matcher)CoreMatchers.equalTo((Object)"[[CATALOG, SALES, DEPT].#0, [CATALOG, SALES, DEPT].#1, [CATALOG, SALES, EMP].#0, [CATALOG, SALES, EMP].#1, [CATALOG, SALES, EMP].#2, [CATALOG, SALES, EMP].#3]"));
    }

    @Test
    public void testAllPredicatesAndTableUnion() {
        String sql = "select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno\nunion all\nselect a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno";
        RelNode rel = this.convertSql("select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno\nunion all\nselect a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ninner join (select * from emp limit 2) as c\non a.deptno = c.deptno");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList inputSet = mq.getAllPredicates(rel);
        Assert.assertThat((Object)inputSet.pulledUpPredicates.toString(), (Matcher)CoreMatchers.equalTo((Object)"[true, =([CATALOG, SALES, EMP].#0.$7, [CATALOG, SALES, EMP].#1.$7), true, =([CATALOG, SALES, EMP].#2.$7, [CATALOG, SALES, EMP].#3.$7)]"));
        TreeSet tableReferences = Sets.newTreeSet((Iterable)mq.getTableReferences(rel));
        Assert.assertThat((Object)((Object)tableReferences).toString(), (Matcher)CoreMatchers.equalTo((Object)"[[CATALOG, SALES, DEPT].#0, [CATALOG, SALES, DEPT].#1, [CATALOG, SALES, EMP].#0, [CATALOG, SALES, EMP].#1, [CATALOG, SALES, EMP].#2, [CATALOG, SALES, EMP].#3]"));
    }

    @Test
    public void testAllPredicatesCrossJoinMultiTable() {
        String sql = "select x.sal from\n(select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ncross join (select * from emp where empno = 5 limit 2) as c) as x";
        RelNode rel = this.convertSql("select x.sal from\n(select a.deptno, c.sal from (select * from emp limit 7) as a\ncross join (select * from dept limit 1) as b\ncross join (select * from emp where empno = 5 limit 2) as c) as x");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        TreeSet tableReferences = Sets.newTreeSet((Iterable)mq.getTableReferences(rel));
        Assert.assertThat((Object)((Object)tableReferences).toString(), (Matcher)CoreMatchers.equalTo((Object)"[[CATALOG, SALES, DEPT].#0, [CATALOG, SALES, EMP].#0, [CATALOG, SALES, EMP].#1]"));
        RelOptPredicateList inputSet = mq.getAllPredicates(rel);
        Assert.assertThat((Object)inputSet.pulledUpPredicates.toString(), (Matcher)CoreMatchers.equalTo((Object)"[true, =([CATALOG, SALES, EMP].#1.$0, 5), true]"));
    }

    @Test
    public void testTableReferencesJoinUnknownNode() {
        String sql = "select * from emp limit 10";
        RelNode node = this.convertSql("select * from emp limit 10");
        DummyRelNode nodeWithUnknown = new DummyRelNode(node.getCluster(), node.getTraitSet(), node);
        RexBuilder rexBuilder = node.getCluster().getRexBuilder();
        LogicalJoin join = LogicalJoin.create((RelNode)nodeWithUnknown, (RelNode)node, (RexNode)rexBuilder.makeLiteral(true), (Set)ImmutableSet.of(), (JoinRelType)JoinRelType.INNER);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set tableReferences = mq.getTableReferences((RelNode)join);
        Assert.assertNull((Object)tableReferences);
    }

    @Test
    public void testAllPredicatesUnionMultiTable() {
        String sql = "select x.sal from\n(select a.deptno, a.sal from (select * from emp) as a\nunion all select emp.deptno, emp.sal from emp\nunion all select emp.deptno, emp.sal from emp where empno = 5) as x";
        RelNode rel = this.convertSql("select x.sal from\n(select a.deptno, a.sal from (select * from emp) as a\nunion all select emp.deptno, emp.sal from emp\nunion all select emp.deptno, emp.sal from emp where empno = 5) as x");
        RelMetadataQuery mq = RelMetadataQuery.instance();
        TreeSet tableReferences = Sets.newTreeSet((Iterable)mq.getTableReferences(rel));
        Assert.assertThat((Object)((Object)tableReferences).toString(), (Matcher)CoreMatchers.equalTo((Object)"[[CATALOG, SALES, EMP].#0, [CATALOG, SALES, EMP].#1, [CATALOG, SALES, EMP].#2]"));
        RelOptPredicateList inputSet = mq.getAllPredicates(rel);
        Assert.assertThat((Object)inputSet.pulledUpPredicates.toString(), (Matcher)CoreMatchers.equalTo((Object)"[=([CATALOG, SALES, EMP].#2.$0, 5)]"));
    }

    @Test
    public void testTableReferencesUnionUnknownNode() {
        String sql = "select * from emp limit 10";
        RelNode node = this.convertSql("select * from emp limit 10");
        DummyRelNode nodeWithUnknown = new DummyRelNode(node.getCluster(), node.getTraitSet(), node);
        LogicalUnion union = LogicalUnion.create((List)ImmutableList.of((Object)((Object)nodeWithUnknown), (Object)node), (boolean)true);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Set tableReferences = mq.getTableReferences((RelNode)union);
        Assert.assertNull((Object)tableReferences);
    }

    private void checkNodeTypeCount(String sql, Map<Class<? extends RelNode>, Integer> expected) {
        RelNode rel = this.convertSql(sql);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Multimap result = mq.getNodeTypes(rel);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        HashMap resultCount = new HashMap();
        for (Map.Entry e : result.asMap().entrySet()) {
            resultCount.put(e.getKey(), ((Collection)e.getValue()).size());
        }
        Assert.assertEquals(expected, resultCount);
    }

    @Test
    public void testNodeTypeCountEmp() {
        String sql = "select * from emp";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        this.checkNodeTypeCount("select * from emp", expected);
    }

    @Test
    public void testNodeTypeCountDept() {
        String sql = "select * from dept";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        this.checkNodeTypeCount("select * from dept", expected);
    }

    @Test
    public void testNodeTypeCountValues() {
        String sql = "select * from (values (1), (2)) as t(c)";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(Values.class, 1);
        expected.put(Project.class, 1);
        this.checkNodeTypeCount("select * from (values (1), (2)) as t(c)", expected);
    }

    @Test
    public void testNodeTypeCountCartesian() {
        String sql = "select * from emp,dept";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 1);
        this.checkNodeTypeCount("select * from emp,dept", expected);
    }

    @Test
    public void testNodeTypeCountJoin() {
        String sql = "select * from emp\ninner join dept on emp.deptno = dept.deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 1);
        this.checkNodeTypeCount("select * from emp\ninner join dept on emp.deptno = dept.deptno", expected);
    }

    @Test
    public void testNodeTypeCountJoinFinite() {
        String sql = "select * from (select * from emp limit 14) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 3);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select * from (select * from emp limit 14) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", expected);
    }

    @Test
    public void testNodeTypeCountJoinEmptyFinite() {
        String sql = "select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 3);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", expected);
    }

    @Test
    public void testNodeTypeCountLeftJoinEmptyFinite() {
        String sql = "select * from (select * from emp limit 0) as emp\nleft join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 3);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select * from (select * from emp limit 0) as emp\nleft join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", expected);
    }

    @Test
    public void testNodeTypeCountRightJoinEmptyFinite() {
        String sql = "select * from (select * from emp limit 0) as emp\nright join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 3);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select * from (select * from emp limit 0) as emp\nright join (select * from dept limit 4) as dept\non emp.deptno = dept.deptno", expected);
    }

    @Test
    public void testNodeTypeCountJoinFiniteEmpty() {
        String sql = "select * from (select * from emp limit 7) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 3);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select * from (select * from emp limit 7) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno", expected);
    }

    @Test
    public void testNodeTypeCountJoinEmptyEmpty() {
        String sql = "select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Join.class, 1);
        expected.put(Project.class, 3);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select * from (select * from emp limit 0) as emp\ninner join (select * from dept limit 0) as dept\non emp.deptno = dept.deptno", expected);
    }

    @Test
    public void testNodeTypeCountUnion() {
        String sql = "select ename from emp\nunion all\nselect name from dept";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Project.class, 2);
        expected.put(Union.class, 1);
        this.checkNodeTypeCount("select ename from emp\nunion all\nselect name from dept", expected);
    }

    @Test
    public void testNodeTypeCountUnionOnFinite() {
        String sql = "select ename from (select * from emp limit 100)\nunion all\nselect name from (select * from dept limit 40)";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Union.class, 1);
        expected.put(Project.class, 4);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select ename from (select * from emp limit 100)\nunion all\nselect name from (select * from dept limit 40)", expected);
    }

    @Test
    public void testNodeTypeCountMinusOnFinite() {
        String sql = "select ename from (select * from emp limit 100)\nexcept\nselect name from (select * from dept limit 40)";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 2);
        expected.put(Minus.class, 1);
        expected.put(Project.class, 4);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select ename from (select * from emp limit 100)\nexcept\nselect name from (select * from dept limit 40)", expected);
    }

    @Test
    public void testNodeTypeCountFilter() {
        String sql = "select * from emp where ename='Mathilda'";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        expected.put(Filter.class, 1);
        this.checkNodeTypeCount("select * from emp where ename='Mathilda'", expected);
    }

    @Test
    public void testNodeTypeCountSort() {
        String sql = "select * from emp order by ename";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        expected.put(Sort.class, 1);
        this.checkNodeTypeCount("select * from emp order by ename", expected);
    }

    @Test
    public void testNodeTypeCountSortLimit() {
        String sql = "select * from emp order by ename limit 10";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        expected.put(Sort.class, 1);
        this.checkNodeTypeCount("select * from emp order by ename limit 10", expected);
    }

    @Test
    public void testNodeTypeCountSortLimitOffset() {
        String sql = "select * from emp order by ename limit 10 offset 5";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        expected.put(Sort.class, 1);
        this.checkNodeTypeCount("select * from emp order by ename limit 10 offset 5", expected);
    }

    @Test
    public void testNodeTypeCountSortLimitOffsetOnFinite() {
        String sql = "select * from (select * from emp limit 12)\norder by ename limit 20 offset 5";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 2);
        expected.put(Sort.class, 2);
        this.checkNodeTypeCount("select * from (select * from emp limit 12)\norder by ename limit 20 offset 5", expected);
    }

    @Test
    public void testNodeTypeCountAggregate() {
        String sql = "select deptno from emp group by deptno";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        expected.put(Aggregate.class, 1);
        this.checkNodeTypeCount("select deptno from emp group by deptno", expected);
    }

    @Test
    public void testNodeTypeCountAggregateGroupingSets() {
        String sql = "select deptno from emp\ngroup by grouping sets ((deptno), (ename, deptno))";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 2);
        expected.put(Aggregate.class, 1);
        this.checkNodeTypeCount("select deptno from emp\ngroup by grouping sets ((deptno), (ename, deptno))", expected);
    }

    @Test
    public void testNodeTypeCountAggregateEmptyKeyOnEmptyTable() {
        String sql = "select count(*) from (select * from emp limit 0)";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 2);
        expected.put(Aggregate.class, 1);
        expected.put(Sort.class, 1);
        this.checkNodeTypeCount("select count(*) from (select * from emp limit 0)", expected);
    }

    @Test
    public void testNodeTypeCountFilterAggregateEmptyKey() {
        String sql = "select count(*) from emp where 1 = 0";
        HashMap<Class<? extends RelNode>, Integer> expected = new HashMap<Class<? extends RelNode>, Integer>();
        expected.put(TableScan.class, 1);
        expected.put(Project.class, 1);
        expected.put(Filter.class, 1);
        expected.put(Aggregate.class, 1);
        this.checkNodeTypeCount("select count(*) from emp where 1 = 0", expected);
    }

    @Test
    public void testEmptyAggregateTableOrigin() {
        FrameworkConfig config = RelBuilderTest.config().build();
        RelBuilder builder = RelBuilder.create((FrameworkConfig)config);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelNode agg = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(), new RelBuilder.AggCall[0]).build();
        RelOptTable tableOrigin = mq.getTableOrigin(agg);
        Assert.assertThat((Object)tableOrigin, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetPredicatesForJoin() throws Exception {
        FrameworkConfig config = RelBuilderTest.config().build();
        RelBuilder builder = RelBuilder.create((FrameworkConfig)config);
        RelNode join = builder.scan(new String[]{"EMP"}).scan(new String[]{"DEPT"}).join(JoinRelType.INNER, builder.call(NONDETERMINISTIC_OP, new RexNode[0])).build();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Assert.assertTrue((boolean)mq.getPulledUpPredicates((RelNode)join).pulledUpPredicates.isEmpty());
        RelNode join1 = builder.scan(new String[]{"EMP"}).scan(new String[]{"DEPT"}).join(JoinRelType.INNER, builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field(2, 0, 0), builder.field(2, 1, 0)})).build();
        Assert.assertEquals((Object)"=($0, $8)", (Object)((RexNode)mq.getPulledUpPredicates((RelNode)join1).pulledUpPredicates.get(0)).toString());
    }

    @Test
    public void testGetPredicatesForFilter() throws Exception {
        FrameworkConfig config = RelBuilderTest.config().build();
        RelBuilder builder = RelBuilder.create((FrameworkConfig)config);
        RelNode filter = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call(NONDETERMINISTIC_OP, new RexNode[0])}).build();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Assert.assertTrue((boolean)mq.getPulledUpPredicates((RelNode)filter).pulledUpPredicates.isEmpty());
        RelNode filter1 = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field(1, 0, 0), builder.field(1, 0, 1)})}).build();
        Assert.assertEquals((Object)"=($0, $1)", (Object)((RexNode)mq.getPulledUpPredicates((RelNode)filter1).pulledUpPredicates.get(0)).toString());
    }

    static <T> Matcher<Iterable<? extends T>> sortsAs(final String value) {
        return new CustomTypeSafeMatcher<Iterable<? extends T>>(value){

            protected boolean matchesSafely(Iterable<? extends T> item) {
                ArrayList<String> strings = new ArrayList<String>();
                for (Object t : item) {
                    strings.add(t.toString());
                }
                Collections.sort(strings);
                return value.equals(((Object)strings).toString());
            }
        };
    }

    private class DummyRelNode
    extends SingleRel {
        DummyRelNode(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
            super(cluster, traits, input);
        }
    }

    private static class MyRelMetadataQuery
    extends RelMetadataQuery {
        private ColType.Handler colTypeHandler = (ColType.Handler)MyRelMetadataQuery.initialHandler(ColType.Handler.class);

        MyRelMetadataQuery() {
            super((JaninoRelMetadataProvider)THREAD_PROVIDERS.get(), EMPTY);
        }

        public String colType(RelNode rel, int column) {
            while (true) {
                try {
                    return this.colTypeHandler.getColType(rel, this, column);
                }
                catch (JaninoRelMetadataProvider.NoHandler e) {
                    this.colTypeHandler = (ColType.Handler)this.revise(e.relClass, ColType.DEF);
                    continue;
                }
                break;
            }
        }
    }

    public static class BrokenColTypeImpl
    extends PartialColTypeImpl {
        public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)ColType.METHOD, (MetadataHandler)new BrokenColTypeImpl());
    }

    public static class ColTypeImpl
    extends PartialColTypeImpl {
        public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)ColType.METHOD, (MetadataHandler)new ColTypeImpl());

        public String getColType(RelNode rel, RelMetadataQuery mq, int column) {
            String name = ((RelDataTypeField)rel.getRowType().getFieldList().get(column)).getName() + "-rel";
            ((List)THREAD_LIST.get()).add(name);
            return name;
        }
    }

    public static abstract class PartialColTypeImpl
    implements MetadataHandler<ColType> {
        static final ThreadLocal<List<String>> THREAD_LIST = new ThreadLocal();

        public MetadataDef<ColType> getDef() {
            return ColType.DEF;
        }

        public String getColType(Aggregate rel, RelMetadataQuery mq, int column) {
            String name = ((RelDataTypeField)rel.getRowType().getFieldList().get(column)).getName() + "-agg";
            THREAD_LIST.get().add(name);
            return name;
        }
    }

    public static interface ColType
    extends Metadata {
        public static final Method METHOD = Types.lookupMethod(ColType.class, (String)"getColType", (Class[])new Class[]{Integer.TYPE});
        public static final MetadataDef<ColType> DEF = MetadataDef.of(ColType.class, Handler.class, (Method[])new Method[]{METHOD});

        public String getColType(int var1);

        public static interface Handler
        extends MetadataHandler<ColType> {
            public String getColType(RelNode var1, RelMetadataQuery var2, int var3);
        }
    }
}

