/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.calcite.adapter.clone.CloneSchema;
import org.apache.calcite.adapter.generate.RangeTable;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.Handler;
import org.apache.calcite.avatica.HandlerImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.rules.IntersectToDistinctRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.ModifiableView;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFactory;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.schema.impl.TableMacroImpl;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.impl.SqlParserImpl;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionSpec;
import org.apache.calcite.test.FoodMartQuerySet;
import org.apache.calcite.test.JdbcFrontLinqBackTest;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.test.MultiJdbcSchemaJoinTest;
import org.apache.calcite.test.ReflectiveSchemaTest;
import org.apache.calcite.test.TableInRootSchemaTest;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Smalls;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hsqldb.jdbcDriver;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JdbcTest {
    public static final String FOODMART_SCHEMA = "     {\n       type: 'jdbc',\n       name: 'foodmart',\n       jdbcDriver: " + JdbcTest.q(CalciteAssert.DB.foodmart.driver) + ",\n       jdbcUser: " + JdbcTest.q(CalciteAssert.DB.foodmart.username) + ",\n       jdbcPassword: " + JdbcTest.q(CalciteAssert.DB.foodmart.password) + ",\n       jdbcUrl: " + JdbcTest.q(CalciteAssert.DB.foodmart.url) + ",\n       jdbcCatalog: " + JdbcTest.q(CalciteAssert.DB.foodmart.catalog) + ",\n       jdbcSchema: " + JdbcTest.q(CalciteAssert.DB.foodmart.schema) + "\n     }\n";
    public static final String FOODMART_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'foodmart',\n   schemas: [\n" + FOODMART_SCHEMA + "   ]\n}";
    public static final ConnectionSpec SCOTT = (ConnectionSpec)Util.first((Object)CalciteAssert.DB.scott, (Object)CalciteAssert.DatabaseInstance.HSQLDB.scott);
    public static final String SCOTT_SCHEMA = "     {\n       type: 'jdbc',\n       name: 'SCOTT',\n       jdbcDriver: " + JdbcTest.q(JdbcTest.SCOTT.driver) + ",\n       jdbcUser: " + JdbcTest.q(JdbcTest.SCOTT.username) + ",\n       jdbcPassword: " + JdbcTest.q(JdbcTest.SCOTT.password) + ",\n       jdbcUrl: " + JdbcTest.q(JdbcTest.SCOTT.url) + ",\n       jdbcCatalog: " + JdbcTest.q(JdbcTest.SCOTT.catalog) + ",\n       jdbcSchema: " + JdbcTest.q(JdbcTest.SCOTT.schema) + "\n     }\n";
    public static final String SCOTT_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'SCOTT',\n   schemas: [\n" + SCOTT_SCHEMA + "   ]\n}";
    public static final String HR_SCHEMA = "     {\n       type: 'custom',\n       name: 'hr',\n       factory: '" + ReflectiveSchema.Factory.class.getName() + "',\n       operand: {\n         class: '" + HrSchema.class.getName() + "'\n       }\n     }\n";
    public static final String HR_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'hr',\n   schemas: [\n" + HR_SCHEMA + "   ]\n}";
    public static final String START_OF_GROUP_DATA = "(values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)";
    private static final String[] QUERIES = new String[]{"select count(*) from (select 1 as \"c0\" from \"salary\" as \"salary\") as \"init\"", "EXPR$0=21252\n", "select count(*) from (select 1 as \"c0\" from \"salary\" as \"salary2\") as \"init\"", "EXPR$0=21252\n", "select count(*) from (select 1 as \"c0\" from \"department\" as \"department\") as \"init\"", "EXPR$0=12\n", "select count(*) from (select 1 as \"c0\" from \"employee\" as \"employee\") as \"init\"", "EXPR$0=1155\n", "select count(*) from (select 1 as \"c0\" from \"employee_closure\" as \"employee_closure\") as \"init\"", "EXPR$0=7179\n", "select count(*) from (select 1 as \"c0\" from \"position\" as \"position\") as \"init\"", "EXPR$0=18\n", "select count(*) from (select 1 as \"c0\" from \"promotion\" as \"promotion\") as \"init\"", "EXPR$0=1864\n", "select count(*) from (select 1 as \"c0\" from \"store\" as \"store\") as \"init\"", "EXPR$0=25\n", "select count(*) from (select 1 as \"c0\" from \"product\" as \"product\") as \"init\"", "EXPR$0=1560\n", "select count(*) from (select 1 as \"c0\" from \"product_class\" as \"product_class\") as \"init\"", "EXPR$0=110\n", "select count(*) from (select 1 as \"c0\" from \"time_by_day\" as \"time_by_day\") as \"init\"", "EXPR$0=730\n", "select count(*) from (select 1 as \"c0\" from \"customer\" as \"customer\") as \"init\"", "EXPR$0=10281\n", "select count(*) from (select 1 as \"c0\" from \"sales_fact_1997\" as \"sales_fact_1997\") as \"init\"", "EXPR$0=86837\n", "select count(*) from (select 1 as \"c0\" from \"inventory_fact_1997\" as \"inventory_fact_1997\") as \"init\"", "EXPR$0=4070\n", "select count(*) from (select 1 as \"c0\" from \"warehouse\" as \"warehouse\") as \"init\"", "EXPR$0=24\n", "select count(*) from (select 1 as \"c0\" from \"agg_c_special_sales_fact_1997\" as \"agg_c_special_sales_fact_1997\") as \"init\"", "EXPR$0=86805\n", "select count(*) from (select 1 as \"c0\" from \"agg_pl_01_sales_fact_1997\" as \"agg_pl_01_sales_fact_1997\") as \"init\"", "EXPR$0=86829\n", "select count(*) from (select 1 as \"c0\" from \"agg_l_05_sales_fact_1997\" as \"agg_l_05_sales_fact_1997\") as \"init\"", "EXPR$0=86154\n", "select count(*) from (select 1 as \"c0\" from \"agg_g_ms_pcat_sales_fact_1997\" as \"agg_g_ms_pcat_sales_fact_1997\") as \"init\"", "EXPR$0=2637\n", "select count(*) from (select 1 as \"c0\" from \"agg_c_14_sales_fact_1997\" as \"agg_c_14_sales_fact_1997\") as \"init\"", "EXPR$0=86805\n", "select \"time_by_day\".\"the_year\" as \"c0\" from \"time_by_day\" as \"time_by_day\" group by \"time_by_day\".\"the_year\" order by \"time_by_day\".\"the_year\" ASC", "c0=1997\nc0=1998\n", "select \"store\".\"store_country\" as \"c0\" from \"store\" as \"store\" where UPPER(\"store\".\"store_country\") = UPPER('USA') group by \"store\".\"store_country\" order by \"store\".\"store_country\" ASC", "c0=USA\n", "select \"store\".\"store_state\" as \"c0\" from \"store\" as \"store\" where (\"store\".\"store_country\" = 'USA') and UPPER(\"store\".\"store_state\") = UPPER('CA') group by \"store\".\"store_state\" order by \"store\".\"store_state\" ASC", "c0=CA\n", "select \"store\".\"store_city\" as \"c0\", \"store\".\"store_state\" as \"c1\" from \"store\" as \"store\" where (\"store\".\"store_state\" = 'CA' and \"store\".\"store_country\" = 'USA') and UPPER(\"store\".\"store_city\") = UPPER('Los Angeles') group by \"store\".\"store_city\", \"store\".\"store_state\" order by \"store\".\"store_city\" ASC", "c0=Los Angeles; c1=CA\n", "select \"customer\".\"country\" as \"c0\" from \"customer\" as \"customer\" where UPPER(\"customer\".\"country\") = UPPER('USA') group by \"customer\".\"country\" order by \"customer\".\"country\" ASC", "c0=USA\n", "select \"customer\".\"state_province\" as \"c0\", \"customer\".\"country\" as \"c1\" from \"customer\" as \"customer\" where (\"customer\".\"country\" = 'USA') and UPPER(\"customer\".\"state_province\") = UPPER('CA') group by \"customer\".\"state_province\", \"customer\".\"country\" order by \"customer\".\"state_province\" ASC", "c0=CA; c1=USA\n", "select \"customer\".\"city\" as \"c0\", \"customer\".\"country\" as \"c1\", \"customer\".\"state_province\" as \"c2\" from \"customer\" as \"customer\" where (\"customer\".\"country\" = 'USA' and \"customer\".\"state_province\" = 'CA' and \"customer\".\"country\" = 'USA' and \"customer\".\"state_province\" = 'CA' and \"customer\".\"country\" = 'USA') and UPPER(\"customer\".\"city\") = UPPER('Los Angeles') group by \"customer\".\"city\", \"customer\".\"country\", \"customer\".\"state_province\" order by \"customer\".\"city\" ASC", "c0=Los Angeles; c1=USA; c2=CA\n", "select \"store\".\"store_country\" as \"c0\" from \"store\" as \"store\" where UPPER(\"store\".\"store_country\") = UPPER('Gender') group by \"store\".\"store_country\" order by \"store\".\"store_country\" ASC", "", "select \"store\".\"store_type\" as \"c0\" from \"store\" as \"store\" where UPPER(\"store\".\"store_type\") = UPPER('Gender') group by \"store\".\"store_type\" order by \"store\".\"store_type\" ASC", "", "select \"product_class\".\"product_family\" as \"c0\" from \"product\" as \"product\", \"product_class\" as \"product_class\" where \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and UPPER(\"product_class\".\"product_family\") = UPPER('Gender') group by \"product_class\".\"product_family\" order by \"product_class\".\"product_family\" ASC", "", "select \"promotion\".\"media_type\" as \"c0\" from \"promotion\" as \"promotion\" where UPPER(\"promotion\".\"media_type\") = UPPER('Gender') group by \"promotion\".\"media_type\" order by \"promotion\".\"media_type\" ASC", "", "select \"promotion\".\"promotion_name\" as \"c0\" from \"promotion\" as \"promotion\" where UPPER(\"promotion\".\"promotion_name\") = UPPER('Gender') group by \"promotion\".\"promotion_name\" order by \"promotion\".\"promotion_name\" ASC", "", "select \"promotion\".\"media_type\" as \"c0\" from \"promotion\" as \"promotion\" where UPPER(\"promotion\".\"media_type\") = UPPER('No Media') group by \"promotion\".\"media_type\" order by \"promotion\".\"media_type\" ASC", "c0=No Media\n", "select \"promotion\".\"media_type\" as \"c0\" from \"promotion\" as \"promotion\" group by \"promotion\".\"media_type\" order by \"promotion\".\"media_type\" ASC", "c0=Bulk Mail\nc0=Cash Register Handout\nc0=Daily Paper\nc0=Daily Paper, Radio\nc0=Daily Paper, Radio, TV\nc0=In-Store Coupon\nc0=No Media\nc0=Product Attachment\nc0=Radio\nc0=Street Handout\nc0=Sunday Paper\nc0=Sunday Paper, Radio\nc0=Sunday Paper, Radio, TV\nc0=TV\n", "select count(distinct \"the_year\") from \"time_by_day\"", "EXPR$0=2\n", "select \"time_by_day\".\"the_year\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 group by \"time_by_day\".\"the_year\"", "c0=1997; m0=266773.0000\n", "select \"time_by_day\".\"the_year\" as \"c0\", \"promotion\".\"media_type\" as \"c1\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"promotion\" as \"promotion\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\" group by \"time_by_day\".\"the_year\", \"promotion\".\"media_type\"", "c0=1997; c1=Bulk Mail; m0=4320.0000\nc0=1997; c1=Radio; m0=2454.0000\nc0=1997; c1=Street Handout; m0=5753.0000\nc0=1997; c1=TV; m0=3607.0000\nc0=1997; c1=No Media; m0=195448.0000\nc0=1997; c1=In-Store Coupon; m0=3798.0000\nc0=1997; c1=Sunday Paper, Radio, TV; m0=2726.0000\nc0=1997; c1=Product Attachment; m0=7544.0000\nc0=1997; c1=Daily Paper; m0=7738.0000\nc0=1997; c1=Cash Register Handout; m0=6697.0000\nc0=1997; c1=Daily Paper, Radio; m0=6891.0000\nc0=1997; c1=Daily Paper, Radio, TV; m0=9513.0000\nc0=1997; c1=Sunday Paper, Radio; m0=5945.0000\nc0=1997; c1=Sunday Paper; m0=4339.0000\n", "select \"store\".\"store_country\" as \"c0\", sum(\"inventory_fact_1997\".\"supply_time\") as \"m0\" from \"store\" as \"store\", \"inventory_fact_1997\" as \"inventory_fact_1997\" where \"inventory_fact_1997\".\"store_id\" = \"store\".\"store_id\" group by \"store\".\"store_country\"", "c0=USA; m0=10425\n", "select \"sn\".\"desc\" as \"c0\" from (SELECT * FROM (VALUES (1, 'SameName')) AS \"t\" (\"id\", \"desc\")) as \"sn\" group by \"sn\".\"desc\" order by \"sn\".\"desc\" ASC NULLS LAST", "c0=SameName\n", "select \"the_year\", count(*) as c, min(\"the_month\") as m\nfrom \"foodmart2\".\"time_by_day\"\ngroup by \"the_year\"\norder by 1, 2", "the_year=1997; C=365; M=April\nthe_year=1998; C=365; M=April\n", "select\n \"store\".\"store_state\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\",\n sum(\"sales_fact_1997\".\"store_sales\") as \"m1\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_state\" in ('DF', 'WA')\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"store\".\"store_state\", \"time_by_day\".\"the_year\"", "c0=WA; c1=1997; m0=124366.0000; m1=263793.2200\n", "select count(distinct \"product_id\") from \"product\"", "EXPR$0=1560\n", "select \"store\".\"store_name\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n sum(\"sales_fact_1997\".\"store_sales\") as \"m0\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_name\" in ('Store 1', 'Store 10', 'Store 11', 'Store 15', 'Store 16', 'Store 24', 'Store 3', 'Store 7')\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"store\".\"store_name\",\n \"time_by_day\".\"the_year\"\n", "c0=Store 7; c1=1997; m0=54545.2800\nc0=Store 24; c1=1997; m0=54431.1400\nc0=Store 16; c1=1997; m0=49634.4600\nc0=Store 3; c1=1997; m0=52896.3000\nc0=Store 15; c1=1997; m0=52644.0700\nc0=Store 11; c1=1997; m0=55058.7900\n", "select \"customer\".\"yearly_income\" as \"c0\", \"customer\".\"education\" as \"c1\"\nfrom \"customer\" as \"customer\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\n and ((not (\"customer\".\"yearly_income\" in ('$10K - $30K', '$50K - $70K'))\n or (\"customer\".\"yearly_income\" is null)))\ngroup by \"customer\".\"yearly_income\",\n \"customer\".\"education\"\norder by \"customer\".\"yearly_income\" ASC NULLS LAST,\n \"customer\".\"education\" ASC NULLS LAST", "c0=$110K - $130K; c1=Bachelors Degree\nc0=$110K - $130K; c1=Graduate Degree\nc0=$110K - $130K; c1=High School Degree\nc0=$110K - $130K; c1=Partial College\nc0=$110K - $130K; c1=Partial High School\nc0=$130K - $150K; c1=Bachelors Degree\nc0=$130K - $150K; c1=Graduate Degree\nc0=$130K - $150K; c1=High School Degree\nc0=$130K - $150K; c1=Partial College\nc0=$130K - $150K; c1=Partial High School\nc0=$150K +; c1=Bachelors Degree\nc0=$150K +; c1=Graduate Degree\nc0=$150K +; c1=High School Degree\nc0=$150K +; c1=Partial College\nc0=$150K +; c1=Partial High School\nc0=$30K - $50K; c1=Bachelors Degree\nc0=$30K - $50K; c1=Graduate Degree\nc0=$30K - $50K; c1=High School Degree\nc0=$30K - $50K; c1=Partial College\nc0=$30K - $50K; c1=Partial High School\nc0=$70K - $90K; c1=Bachelors Degree\nc0=$70K - $90K; c1=Graduate Degree\nc0=$70K - $90K; c1=High School Degree\nc0=$70K - $90K; c1=Partial College\nc0=$70K - $90K; c1=Partial High School\nc0=$90K - $110K; c1=Bachelors Degree\nc0=$90K - $110K; c1=Graduate Degree\nc0=$90K - $110K; c1=High School Degree\nc0=$90K - $110K; c1=Partial College\nc0=$90K - $110K; c1=Partial High School\n", "ignore:select \"time_by_day\".\"the_year\" as \"c0\", \"product_class\".\"product_family\" as \"c1\", \"customer\".\"state_province\" as \"c2\", \"customer\".\"city\" as \"c3\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product_class\" as \"product_class\", \"product\" as \"product\", \"customer\" as \"customer\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"product_class\".\"product_family\" = 'Drink' and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" and \"customer\".\"state_province\" = 'WA' and \"customer\".\"city\" in ('Anacortes', 'Ballard', 'Bellingham', 'Bremerton', 'Burien', 'Edmonds', 'Everett', 'Issaquah', 'Kirkland', 'Lynnwood', 'Marysville', 'Olympia', 'Port Orchard', 'Puyallup', 'Redmond', 'Renton', 'Seattle', 'Sedro Woolley', 'Spokane', 'Tacoma', 'Walla Walla', 'Yakima') group by \"time_by_day\".\"the_year\", \"product_class\".\"product_family\", \"customer\".\"state_province\", \"customer\".\"city\"", "c0=1997; c1=Drink; c2=WA; c3=Sedro Woolley; m0=58.0000\n", "select \"store\".\"store_country\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n sum(\"sales_fact_1997\".\"store_cost\") as \"m0\",\n count(\"sales_fact_1997\".\"product_id\") as \"m1\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m2\",\n sum((case when \"sales_fact_1997\".\"promotion_id\" = 0 then 0\n     else \"sales_fact_1997\".\"store_sales\" end)) as \"m3\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"store\".\"store_country\", \"time_by_day\".\"the_year\"", "c0=USA; c1=1997; m0=225627.2336; m1=86837; m2=5581; m3=151211.2100\n", "ignore:select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand (((\"product\".\"brand_name\" = 'Cormorant'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable')\n or (\"product\".\"brand_name\" = 'Denny'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable')\n or (\"product\".\"brand_name\" = 'High Quality'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable')\n or (\"product\".\"brand_name\" = 'Red Wing'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable'))\n or (\"product_class\".\"product_subcategory\" = 'Pots and Pans'\n   and \"product_class\".\"product_category\" = 'Kitchen Products'\n   and \"product_class\".\"product_department\" = 'Household'\n   and \"product_class\".\"product_family\" = 'Non-Consumable'))\ngroup by \"time_by_day\".\"the_year\"\n", "xxtodo", "ignore:select count(\"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand ((\"product\".\"brand_name\" = 'Cormorant'\n   and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers')\n or (\"product_class\".\"product_subcategory\" = 'Pots and Pans'))\n", "xxxx", "select count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand \"product\".\"brand_name\" = 'Cormorant'\n", "m0=1298", "select \"store\".\"store_country\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n \"time_by_day\".\"quarter\" as \"c2\",\n \"product_class\".\"product_family\" as \"c3\",\n count(\"sales_fact_1997\".\"product_id\") as \"m0\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m1\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_country\" = 'USA'\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"time_by_day\".\"quarter\" = 'Q3'\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand \"product_class\".\"product_family\" = 'Food'\ngroup by \"store\".\"store_country\",\n \"time_by_day\".\"the_year\",\n \"time_by_day\".\"quarter\",\n \"product_class\".\"product_family\"", "c0=USA; c1=1997; c2=Q3; c3=Food; m0=15449; m1=2939"};
    public static final List<Pair<String, String>> FOODMART_QUERIES = JdbcTest.querify(QUERIES);

    private static String q(String s) {
        return s == null ? "null" : "'" + s + "'";
    }

    public static List<Pair<String, String>> getFoodmartQueries() {
        return FOODMART_QUERIES;
    }

    @Test
    public void testModelWithModifiableView() throws Exception {
        ArrayList<Employee> employees = new ArrayList<Employee>();
        employees.add(new Employee(135, 10, "Simon", 56.7f, null));
        try (TryThreadLocal.Memo ignore = EmpDeptTableFactory.THREAD_COLLECTION.push(employees);){
            CalciteAssert.AssertThat with = this.modelWithView("select \"name\", \"empid\" as e, \"salary\" from \"MUTABLE_EMPLOYEES\" where \"deptno\" = 10", null);
            with.query("select \"name\" from \"adhoc\".V order by \"name\"").returns("name=Simon\n");
            with.doWithConnection(connection -> {
                try {
                    PreparedStatement s;
                    Statement statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery("explain plan for\ninsert into \"adhoc\".V\nvalues ('Fred', 56, 123.4)");
                    Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)resultSet.getString(1), Matchers.isLinux("EnumerableTableModify(table=[[adhoc, MUTABLE_EMPLOYEES]], operation=[INSERT], flattened=[false])\n  EnumerableCalc(expr#0..2=[{inputs}], expr#3=[CAST($t1):JavaType(int) NOT NULL], expr#4=[10], expr#5=[CAST($t0):JavaType(class java.lang.String)], expr#6=[CAST($t2):JavaType(float) NOT NULL], expr#7=[null:JavaType(class java.lang.Integer)], empid=[$t3], deptno=[$t4], name=[$t5], salary=[$t6], commission=[$t7])\n    EnumerableValues(tuples=[[{ 'Fred', 56, 123.4 }]])\n"));
                    resultSet = statement.executeQuery("explain plan for\ninsert into \"adhoc\".V (\"name\", e, \"salary\")\nvalues ('Fred', 56, 123.4)");
                    Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    resultSet = statement.executeQuery("explain plan for\ninsert into \"adhoc\".V (e, \"salary\", \"name\")\nvalues (56, 123.4, 'Fred')");
                    Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    try {
                        s = connection.prepareStatement("explain plan for\ninsert into \"adhoc\".V (empno, \"salary\", \"name\")\nvalues (56, 123.4, 'Fred')");
                        Assert.fail((String)("expected error, got " + s));
                    }
                    catch (SQLException e) {
                        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Error while preparing statement"));
                    }
                    try {
                        s = connection.prepareStatement("explain plan for\ninsert into \"adhoc\".V (e, name)\nvalues (56, 'Fred')");
                        Assert.fail((String)("expected error, got " + s));
                    }
                    catch (SQLException e) {
                        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Error while preparing statement"));
                    }
                    statement.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Test
    public void testModelWithInvalidModifiableView() throws Exception {
        ArrayList<Employee> employees = new ArrayList<Employee>();
        employees.add(new Employee(135, 10, "Simon", 56.7f, null));
        try (TryThreadLocal.Memo ignore = EmpDeptTableFactory.THREAD_COLLECTION.push(employees);){
            Util.discard((Object)Static.RESOURCE.noValueSuppliedForViewColumn(null, null));
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\" from \"MUTABLE_EMPLOYEES\" where \"commission\" = 10", true).query("select \"name\" from \"adhoc\".V order by \"name\"").throws_("View is not modifiable. No value is supplied for NOT NULL column 'deptno' of base table 'MUTABLE_EMPLOYEES'");
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\" from \"MUTABLE_EMPLOYEES\" where \"commission\" = 10", null).query("select \"name\" from \"adhoc\".V order by \"name\"").runs();
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\" from \"MUTABLE_EMPLOYEES\" where \"deptno\" IN (10, 20)", true).query("select \"name\" from \"adhoc\".V order by \"name\"").throws_("Modifiable view must be predicated only on equality expressions");
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\" from \"MUTABLE_EMPLOYEES\"\nwhere \"deptno\" = 10 AND (\"deptno\" < 20 OR \"commission\" > 1000)", true).query("insert into \"adhoc\".v values ('n',1,2)").throws_("Modifiable view must be predicated only on equality expressions");
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\" from \"MUTABLE_EMPLOYEES\"\nwhere \"deptno\" = 10 AND (\"deptno\" > 20 AND \"commission\" > 1000)", true).query("insert into \"adhoc\".v values ('n',1,2)").throws_("Modifiable view must be predicated only on equality expressions");
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\" from \"MUTABLE_EMPLOYEES\"\nwhere \"commission\" = 100 AND \"deptno\" = 20", true).query("select \"name\" from \"adhoc\".V order by \"name\"").runs();
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\", \"empid\" + 3 as e3, 1 as uno\nfrom \"MUTABLE_EMPLOYEES\"\nwhere \"commission\" = 100 AND \"deptno\" = 20", true).query("select \"name\" from \"adhoc\".V order by \"name\"").runs();
            Util.discard((Object)Static.RESOURCE.moreThanOneMappedColumn(null, null));
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\", \"name\" as n2 from \"MUTABLE_EMPLOYEES\" where \"deptno\" IN (10, 20)", true).query("select \"name\" from \"adhoc\".V order by \"name\"").throws_("View is not modifiable. More than one expression maps to column 'name' of base table 'MUTABLE_EMPLOYEES'");
            this.modelWithView("select \"name\", \"empid\" as e, \"salary\", \"name\" as n2 from \"MUTABLE_EMPLOYEES\" where \"deptno\" IN (10, 20)", null).query("select \"name\" from \"adhoc\".V order by \"name\"").runs();
        }
    }

    @Test
    public void testTableMacro() throws SQLException, ClassNotFoundException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableMacro tableMacro = TableMacroImpl.create((Method)Smalls.VIEW_METHOD);
        schema.add("View", (Function)tableMacro);
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(\"s\".\"View\"('(10), (20)')) as t(n)\nwhere n < 15");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"N=1\nN=3\nN=10\n"));
        connection.close();
    }

    @Test
    public void testTableMacroMap() throws SQLException, ClassNotFoundException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableMacro tableMacro = TableMacroImpl.create((Method)Smalls.STR_METHOD);
        schema.add("Str", (Function)tableMacro);
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(\"s\".\"Str\"(MAP['a', 1, 'baz', 2],\n                         ARRAY[3, 4, CAST(null AS INTEGER)])) as t(n)");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"N={'a'=1, 'baz'=2}\nN=[3, 4, null]    \n"));
        connection.close();
    }

    @Test
    public void testTableMacroWithNamedParameters() throws Exception {
        CalciteAssert.AssertThat with = this.assertWithMacro(Smalls.TableMacroFunctionWithNamedParameters.class);
        with.query("select * from table(\"adhoc\".\"View\"('(5)'))").throws_("No match found for function signature View(<CHARACTER>)");
        String expected1 = "c=1\nc=3\nc=5\nc=6\n";
        with.query("select * from table(\"adhoc\".\"View\"('5', '6'))").returns("c=1\nc=3\nc=5\nc=6\n");
        String expected2 = "c=1\nc=3\nc=5\nc=6\n";
        with.query("select * from table(\"adhoc\".\"View\"(r=>'5', s=>'6'))").returns("c=1\nc=3\nc=5\nc=6\n");
        with.query("select * from table(\"adhoc\".\"View\"(t=>'5', t=>'6'))").throws_("Duplicate argument name 'T'");
        with.query("select * from table(\"adhoc\".\"View\"(t=>'5', s=>'6'))").throws_("No match found for function signature View(T => <CHARACTER>, S => <CHARACTER>)");
        String expected3 = "c=1\nc=3\nc=6\nc=5\n";
        with.query("select * from table(\"adhoc\".\"View\"(t=>5, s=>'6'))").returns("c=1\nc=3\nc=6\nc=5\n");
    }

    @Test
    public void testTableMacroInModel() throws Exception {
        this.checkTableMacroInModel(Smalls.TableMacroFunction.class);
    }

    @Test
    public void testStaticTableMacroInModel() throws Exception {
        this.checkTableMacroInModel(Smalls.StaticTableMacroFunction.class);
    }

    @Test
    public void testTableFunctionInModel() throws Exception {
        this.checkTableFunctionInModel(Smalls.MyTableFunction.class);
    }

    @Test
    public void testStaticTableFunctionInModel() throws Exception {
        this.checkTableFunctionInModel(Smalls.TestStaticTableFunction.class);
    }

    private CalciteAssert.AssertThat assertWithMacro(Class clazz) {
        return CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       functions: [\n         {\n           name: 'View',\n           className: '" + clazz.getName() + "'\n         }\n       ]\n     }\n   ]\n}");
    }

    private void checkTableMacroInModel(Class clazz) {
        this.assertWithMacro(clazz).query("select * from table(\"adhoc\".\"View\"('(30)'))").returns("c=1\nc=3\nc=30\n");
    }

    private void checkTableFunctionInModel(Class clazz) {
        this.checkTableMacroInModel(clazz);
        this.assertWithMacro(clazz).query("select \"a\".\"c\" a, \"b\".\"c\" b\n  from table(\"adhoc\".\"View\"('(30)')) \"a\",\n lateral(select *\n   from table(\"adhoc\".\"View\"('('||\n          cast(\"a\".\"c\" as varchar(10))||')'))) \"b\"").returnsUnordered("A=1; B=1", "A=1; B=3", "A=1; B=1", "A=3; B=1", "A=3; B=3", "A=3; B=3", "A=30; B=1", "A=30; B=3", "A=30; B=30");
    }

    @Test
    public void testOnConnectionClose() throws Exception {
        final int[] closeCount = new int[]{0};
        final int[] statementCloseCount = new int[]{0};
        HandlerImpl h = new HandlerImpl(){

            public void onConnectionClose(AvaticaConnection connection) {
                closeCount[0] = closeCount[0] + 1;
                throw new RuntimeException();
            }

            public void onStatementClose(AvaticaStatement statement) {
                statementCloseCount[0] = statementCloseCount[0] + 1;
                throw new RuntimeException();
            }
        };
        try (TryThreadLocal.Memo ignore = HandlerDriver.HANDLERS.push((Object)h);){
            HandlerDriver driver = new HandlerDriver();
            CalciteConnection connection = (CalciteConnection)driver.connect("jdbc:calcite:", new Properties());
            SchemaPlus rootSchema = connection.getRootSchema();
            rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
            connection.setSchema("hr");
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from \"emps\"");
            Assert.assertEquals((long)0L, (long)closeCount[0]);
            Assert.assertEquals((long)0L, (long)statementCloseCount[0]);
            resultSet.close();
            try {
                resultSet.next();
                Assert.fail((String)"resultSet.next() should throw SQLException when closed");
            }
            catch (SQLException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"ResultSet closed"));
            }
            Assert.assertEquals((long)0L, (long)closeCount[0]);
            Assert.assertEquals((long)0L, (long)statementCloseCount[0]);
            try {
                statement.close();
                Assert.fail((String)"expecting error");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)closeCount[0]);
            Assert.assertEquals((long)1L, (long)statementCloseCount[0]);
            try {
                connection.close();
                Assert.fail((String)"expecting error");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assert.assertEquals((long)1L, (long)closeCount[0]);
            Assert.assertEquals((long)1L, (long)statementCloseCount[0]);
            connection.close();
            Assert.assertEquals((long)1L, (long)closeCount[0]);
            Assert.assertEquals((long)1L, (long)statementCloseCount[0]);
        }
    }

    @Test
    public void testStatementCloseOnCompletion() throws Exception {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.7") < 0) {
            return;
        }
        org.apache.calcite.jdbc.Driver driver = new org.apache.calcite.jdbc.Driver();
        CalciteConnection connection = (CalciteConnection)driver.connect("jdbc:calcite:", new Properties());
        SchemaPlus rootSchema = connection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
        connection.setSchema("hr");
        Statement statement = connection.createStatement();
        Assert.assertFalse((boolean)((Boolean)CalciteAssert.call(statement, "isCloseOnCompletion", new Object[0])));
        CalciteAssert.call(statement, "closeOnCompletion", new Object[0]);
        Assert.assertTrue((boolean)((Boolean)CalciteAssert.call(statement, "isCloseOnCompletion", new Object[0])));
        ResultSet resultSet = statement.executeQuery("select * from \"emps\"");
        Assert.assertFalse((boolean)resultSet.isClosed());
        Assert.assertFalse((boolean)statement.isClosed());
        Assert.assertFalse((boolean)connection.isClosed());
        resultSet.close();
        Assert.assertTrue((boolean)resultSet.isClosed());
        Assert.assertTrue((boolean)statement.isClosed());
        Assert.assertFalse((boolean)connection.isClosed());
        connection.close();
        Assert.assertTrue((boolean)resultSet.isClosed());
        Assert.assertTrue((boolean)statement.isClosed());
        Assert.assertTrue((boolean)connection.isClosed());
    }

    @Test
    public void testWhereInOr() {
        String sql = "select \"empid\"\nfrom \"hr\".\"emps\" t\nwhere (\"empid\" in (select \"empid\" from \"hr\".\"emps\")\n    or \"empid\" in (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,\n        12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25))\nand \"empid\" in (100, 200, 150)";
        CalciteAssert.hr().query("select \"empid\"\nfrom \"hr\".\"emps\" t\nwhere (\"empid\" in (select \"empid\" from \"hr\".\"emps\")\n    or \"empid\" in (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,\n        12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25))\nand \"empid\" in (100, 200, 150)").returnsUnordered("empid=100", "empid=200", "empid=150");
    }

    @Test
    public void testMockDdl() throws Exception {
        MockDdlDriver driver = new MockDdlDriver();
        try (Connection connection = driver.connect("jdbc:calcite:", new Properties());
             Statement statement = connection.createStatement();){
            Assert.assertThat((Object)driver.counter, (Matcher)CoreMatchers.is((Object)0));
            statement.executeUpdate("COMMIT");
            Assert.assertThat((Object)driver.counter, (Matcher)CoreMatchers.is((Object)1));
        }
    }

    @Test
    public void testReadme() throws ClassNotFoundException, SQLException {
        Properties info = new Properties();
        info.setProperty("lex", "JAVA");
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
        Statement statement = calciteConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("select d.deptno, min(e.empid)\nfrom hr.emps as e\njoin hr.depts as d\n  on e.deptno = d.deptno\ngroup by d.deptno\nhaving count(*) > 1");
        String s = CalciteAssert.toString(resultSet);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.notNullValue());
        resultSet.close();
        statement.close();
        connection.close();
    }

    @Test
    public void testConnectionProperties() throws ClassNotFoundException, SQLException {
        Driver driver = DriverManager.getDriver("jdbc:calcite:");
        DriverPropertyInfo[] propertyInfo = driver.getPropertyInfo("jdbc:calcite:", new Properties());
        HashSet<String> names = new HashSet<String>();
        for (DriverPropertyInfo info : propertyInfo) {
            names.add(info.name);
        }
        Assert.assertTrue((boolean)names.contains("SCHEMA"));
        Assert.assertTrue((boolean)names.contains("TIME_ZONE"));
        Assert.assertTrue((boolean)names.contains("MATERIALIZATIONS_ENABLED"));
    }

    @Test
    public void testVersion() throws ClassNotFoundException, SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        DatabaseMetaData metaData = calciteConnection.getMetaData();
        Assert.assertEquals((Object)"Calcite JDBC Driver", (Object)metaData.getDriverName());
        String driverVersion = metaData.getDriverVersion();
        int driverMajor = metaData.getDriverMajorVersion();
        int driverMinor = metaData.getDriverMinorVersion();
        Assert.assertEquals((long)1L, (long)driverMajor);
        Assert.assertTrue((driverMinor >= 0 && driverMinor < 20 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Calcite", (Object)metaData.getDatabaseProductName());
        String databaseVersion = metaData.getDatabaseProductVersion();
        int databaseMajor = metaData.getDatabaseMajorVersion();
        Assert.assertEquals((long)driverMajor, (long)databaseMajor);
        int databaseMinor = metaData.getDatabaseMinorVersion();
        Assert.assertEquals((long)driverMinor, (long)databaseMinor);
        Assert.assertTrue((boolean)driverVersion.startsWith(driverMajor + "."));
        Assert.assertTrue((driverVersion.split("\\.").length >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((driverVersion.equals(this.mm(driverMajor, driverMinor)) || driverVersion.startsWith(this.mm(driverMajor, driverMinor) + ".") || driverVersion.startsWith(this.mm(driverMajor, driverMinor) + "-") || driverVersion.endsWith("-SNAPSHOT") && driverVersion.startsWith(this.mm(driverMajor, driverMinor + 1)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)databaseVersion.startsWith("1."));
        Assert.assertTrue((databaseVersion.split("\\.").length >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((databaseVersion.equals(this.mm(databaseMajor, databaseMinor)) || databaseVersion.startsWith(this.mm(databaseMajor, databaseMinor) + ".") || databaseVersion.startsWith(this.mm(databaseMajor, databaseMinor) + "-") || databaseVersion.endsWith("-SNAPSHOT") && databaseVersion.startsWith(this.mm(driverMajor, driverMinor + 1)) ? 1 : 0) != 0);
        connection.close();
    }

    private String mm(int majorVersion, int minorVersion) {
        return majorVersion + "." + minorVersion;
    }

    @Test
    public void testMetaDataColumns() throws ClassNotFoundException, SQLException {
        Connection connection = CalciteAssert.that(CalciteAssert.Config.REGULAR).connect();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getColumns(null, null, null, null);
        Assert.assertTrue((boolean)resultSet.next());
        String name = resultSet.getString(4);
        int type = resultSet.getInt(5);
        String typeName = resultSet.getString(6);
        int columnSize = resultSet.getInt(7);
        int decimalDigits = resultSet.getInt(9);
        int numPrecRadix = resultSet.getInt(10);
        int charOctetLength = resultSet.getInt(16);
        String isNullable = resultSet.getString(18);
        resultSet.close();
        connection.close();
    }

    @Test
    public void testMetaDataPrimaryKeys() throws ClassNotFoundException, SQLException {
        Connection connection = CalciteAssert.that(CalciteAssert.Config.REGULAR).connect();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getPrimaryKeys(null, null, null);
        Assert.assertFalse((boolean)resultSet.next());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)6L, (long)resultSetMetaData.getColumnCount());
        Assert.assertEquals((Object)"TABLE_CAT", (Object)resultSetMetaData.getColumnName(1));
        Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
        Assert.assertEquals((Object)"PK_NAME", (Object)resultSetMetaData.getColumnName(6));
        resultSet.close();
        connection.close();
    }

    @Test
    public void testLikeToRegex() {
        this.checkLikeToRegex(true, "%", "abc");
        this.checkLikeToRegex(true, "abc", "abc");
        this.checkLikeToRegex(false, "abc", "abcd");
        this.checkLikeToRegex(false, "abc", "0abc");
        this.checkLikeToRegex(false, "abc", "aBc");
        this.checkLikeToRegex(true, "a[b]c", "a[b]c");
        this.checkLikeToRegex(true, "a$c", "a$c");
        this.checkLikeToRegex(false, "a$", "a");
        this.checkLikeToRegex(true, "a%c", "ac");
        this.checkLikeToRegex(true, "a%c", "abbbc");
        this.checkLikeToRegex(false, "a%c", "acccd");
        this.checkLikeToRegex(true, "a\\%c", "a%c");
        this.checkLikeToRegex(false, "a\\%c", "abc");
        this.checkLikeToRegex(false, "a\\%c", "a\\%c");
        this.checkLikeToRegex(true, "a%c%d", "abcdaaad");
        this.checkLikeToRegex(false, "a%c%d", "abcdc");
    }

    private void checkLikeToRegex(boolean b, String pattern, String abc) {
        Pattern regex = CalciteMetaImpl.likeToRegex((Meta.Pat)Meta.Pat.of((String)pattern));
        Assert.assertTrue((b == regex.matcher(abc).matches() ? 1 : 0) != 0);
    }

    @Test
    public void testResultSetMetaData() throws ClassNotFoundException, SQLException {
        try (Connection connection = CalciteAssert.that(CalciteAssert.Config.REGULAR).connect();){
            String sql0 = "select \"empid\", \"deptno\" as x, 1 as y\nfrom \"hr\".\"emps\"";
            this.checkResultSetMetaData(connection, "select \"empid\", \"deptno\" as x, 1 as y\nfrom \"hr\".\"emps\"");
            String sql1 = "select \"empid\", \"deptno\" as x, 1 as y\nfrom \"hr\".\"emps\"\norder by 1";
            this.checkResultSetMetaData(connection, "select \"empid\", \"deptno\" as x, 1 as y\nfrom \"hr\".\"emps\"\norder by 1");
        }
    }

    private void checkResultSetMetaData(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            Assert.assertEquals((long)3L, (long)metaData.getColumnCount());
            Assert.assertEquals((Object)"empid", (Object)metaData.getColumnLabel(1));
            Assert.assertEquals((Object)"empid", (Object)metaData.getColumnName(1));
            Assert.assertEquals((Object)"emps", (Object)metaData.getTableName(1));
            Assert.assertEquals((Object)"X", (Object)metaData.getColumnLabel(2));
            Assert.assertEquals((Object)"deptno", (Object)metaData.getColumnName(2));
            Assert.assertEquals((Object)"emps", (Object)metaData.getTableName(2));
            Assert.assertEquals((Object)"Y", (Object)metaData.getColumnLabel(3));
            Assert.assertEquals((Object)"Y", (Object)metaData.getColumnName(3));
            Assert.assertEquals(null, (Object)metaData.getTableName(3));
        }
    }

    @Test
    public void testSimple() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("SELECT 1").returns("EXPR$0=1\n");
    }

    @Test
    public void testGetByName() throws Exception {
        CalciteAssert.that().doWithConnection(c -> {
            try {
                int x2;
                Statement s = c.createStatement();
                ResultSet rs = s.executeQuery("SELECT 1 as \"a\", 2 as \"b\", 3 as \"a\", 4 as \"B\"\nFROM (VALUES (0))");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getInt("a"));
                Assert.assertEquals((long)1L, (long)rs.getInt("A"));
                Assert.assertEquals((long)2L, (long)rs.getInt("b"));
                Assert.assertEquals((long)2L, (long)rs.getInt("B"));
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
                Assert.assertEquals((long)2L, (long)rs.getInt(2));
                Assert.assertEquals((long)3L, (long)rs.getInt(3));
                Assert.assertEquals((long)4L, (long)rs.getInt(4));
                try {
                    x2 = rs.getInt("z");
                    Assert.fail((String)("expected error, got " + x2));
                }
                catch (SQLException x2) {
                    // empty catch block
                }
                Assert.assertEquals((long)1L, (long)rs.findColumn("a"));
                Assert.assertEquals((long)1L, (long)rs.findColumn("A"));
                Assert.assertEquals((long)2L, (long)rs.findColumn("b"));
                Assert.assertEquals((long)2L, (long)rs.findColumn("B"));
                try {
                    x2 = rs.findColumn("z");
                    Assert.fail((String)("expected error, got " + x2));
                }
                catch (SQLException e) {
                    Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"column 'z' not found"));
                }
                try {
                    int x3 = rs.getInt(0);
                    Assert.fail((String)("expected error, got " + x3));
                }
                catch (SQLException e) {
                    Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"invalid column ordinal: 0"));
                }
                try {
                    int x4 = rs.getInt(5);
                    Assert.fail((String)("expected error, got " + x4));
                }
                catch (SQLException e) {
                    Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"invalid column ordinal: 5"));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testCloneSchema() throws ClassNotFoundException, SQLException {
        Connection connection = CalciteAssert.that(CalciteAssert.Config.JDBC_FOODMART).connect();
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus foodmart = rootSchema.getSubSchema("foodmart");
        rootSchema.add("foodmart2", (Schema)new CloneSchema(foodmart));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from \"foodmart2\".\"time_by_day\"");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((long)730L, (long)resultSet.getInt(1));
        resultSet.close();
        connection.close();
    }

    @Test
    public void testCloneGroupBy() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"the_year\", count(*) as c, min(\"the_month\") as m\nfrom \"foodmart2\".\"time_by_day\"\ngroup by \"the_year\"\norder by 1, 2").returns("the_year=1997; C=365; M=April\nthe_year=1998; C=365; M=April\n");
    }

    @Ignore(value="The test returns expected results. Not sure why it is disabled")
    @Test
    public void testCloneGroupBy2() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"product_class\".\"product_family\" as \"c2\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"product_class\".\"product_family\"").returnsUnordered("c0=1997; c1=Q2; c2=Drink; m0=5895.0000", "c0=1997; c1=Q1; c2=Food; m0=47809.0000", "c0=1997; c1=Q3; c2=Drink; m0=6065.0000", "c0=1997; c1=Q4; c2=Drink; m0=6661.0000", "c0=1997; c1=Q4; c2=Food; m0=51866.0000", "c0=1997; c1=Q1; c2=Drink; m0=5976.0000", "c0=1997; c1=Q3; c2=Non-Consumable; m0=12343.0000", "c0=1997; c1=Q4; c2=Non-Consumable; m0=13497.0000", "c0=1997; c1=Q2; c2=Non-Consumable; m0=11890.0000", "c0=1997; c1=Q2; c2=Food; m0=44825.0000", "c0=1997; c1=Q3; c2=Food; m0=47440.0000", "c0=1997; c1=Q1; c2=Non-Consumable; m0=12506.0000");
    }

    @Ignore(value="The actual and expected plan differ")
    @Test
    public void testCloneGroupBy2Plan() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("explain plan for select \"time_by_day\".\"the_year\" as \"c0\", \"time_by_day\".\"quarter\" as \"c1\", \"product_class\".\"product_family\" as \"c2\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"product_class\".\"product_family\"").returns("PLAN=EnumerableAggregate(group=[{0, 1, 2}], m0=[SUM($3)])\n  EnumerableCalc(expr#0..37=[{inputs}], c0=[$t9], c1=[$t13], c2=[$t4], unit_sales=[$t22])\n    EnumerableJoin(condition=[=($23, $0)], joinType=[inner])\n      EnumerableTableScan(table=[[foodmart2, product_class]])\n      EnumerableJoin(condition=[=($10, $19)], joinType=[inner])\n        EnumerableJoin(condition=[=($11, $0)], joinType=[inner])\n          EnumerableCalc(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], proj#0..9=[{exprs}], $condition=[$t12])\n            EnumerableTableScan(table=[[foodmart2, time_by_day]])\n          EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n        EnumerableTableScan(table=[[foodmart2, product]])\n\n");
    }

    @Test
    public void testOrderByCase() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\" from \"time_by_day\" as \"time_by_day\" group by \"time_by_day\".\"the_year\" order by CASE WHEN \"time_by_day\".\"the_year\" IS NULL THEN 1 ELSE 0 END, \"time_by_day\".\"the_year\" ASC").returns("c0=1997\nc0=1998\n");
    }

    @Test
    public void testAlmostBushy() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select *\nfrom \"sales_fact_1997\" as s\njoin \"customer\" as c\n  on s.\"customer_id\" = c.\"customer_id\"\njoin \"product\" as p\n  on s.\"product_id\" = p.\"product_id\"\nwhere c.\"city\" = 'San Francisco'\nand p.\"brand_name\" = 'Washington'").explainMatches("including all attributes ", CalciteAssert.checkMaskedResultContains("EnumerableJoin(condition=[=($0, $38)], joinType=[inner]): rowcount = 7.050660528307499E8, cumulative cost = {1.0640240216183146E9 rows, 777302.0 cpu, 0.0 io}\n  EnumerableJoin(condition=[=($2, $8)], joinType=[inner]): rowcount = 2.0087351932499997E7, cumulative cost = {2.117504719375143E7 rows, 724261.0 cpu, 0.0 io}\n    EnumerableTableScan(table=[[foodmart2, sales_fact_1997]]): rowcount = 86837.0, cumulative cost = {86837.0 rows, 86838.0 cpu, 0.0 io}\n    EnumerableCalc(expr#0..28=[{inputs}], expr#29=['San Francisco':VARCHAR(30)], expr#30=[=($t9, $t29)], proj#0..28=[{exprs}], $condition=[$t30]): rowcount = 1542.1499999999999, cumulative cost = {11823.15 rows, 637423.0 cpu, 0.0 io}\n      EnumerableTableScan(table=[[foodmart2, customer]]): rowcount = 10281.0, cumulative cost = {10281.0 rows, 10282.0 cpu, 0.0 io}\n  EnumerableCalc(expr#0..14=[{inputs}], expr#15=['Washington':VARCHAR(60)], expr#16=[=($t2, $t15)], proj#0..14=[{exprs}], $condition=[$t16]): rowcount = 234.0, cumulative cost = {1794.0 rows, 53041.0 cpu, 0.0 io}\n    EnumerableTableScan(table=[[foodmart2, product]]): rowcount = 1560.0, cumulative cost = {1560.0 rows, 1561.0 cpu, 0.0 io}\n"));
    }

    @Ignore(value="extremely slow - a bit better if you disable ProjectMergeRule")
    @Test
    public void testBushy() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select *\nfrom \"sales_fact_1997\" as s\n  join \"customer\" as c using (\"customer_id\")\n  join \"product\" as p using (\"product_id\")\n  join \"product_class\" as pc using (\"product_class_id\")\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks'\n").explainMatches("including all attributes ", CalciteAssert.checkMaskedResultContains("EnumerableCalcRel(expr#0..56=[{inputs}], expr#57=['San Francisco'], expr#58=[=($t9, $t57)], expr#59=['Snacks'], expr#60=[=($t32, $t59)], expr#61=[AND($t58, $t60)], product_id=[$t49], time_id=[$t50], customer_id=[$t51], promotion_id=[$t52], store_id=[$t53], store_sales=[$t54], store_cost=[$t55], unit_sales=[$t56], customer_id0=[$t0], account_num=[$t1], lname=[$t2], fname=[$t3], mi=[$t4], address1=[$t5], address2=[$t6], address3=[$t7], address4=[$t8], city=[$t9], state_province=[$t10], postal_code=[$t11], country=[$t12], customer_region_id=[$t13], phone1=[$t14], phone2=[$t15], birthdate=[$t16], marital_status=[$t17], yearly_income=[$t18], gender=[$t19], total_children=[$t20], num_children_at_home=[$t21], education=[$t22], date_accnt_opened=[$t23], member_card=[$t24], occupation=[$t25], houseowner=[$t26], num_cars_owned=[$t27], fullname=[$t28], product_class_id=[$t34], product_id0=[$t35], brand_name=[$t36], product_name=[$t37], SKU=[$t38], SRP=[$t39], gross_weight=[$t40], net_weight=[$t41], recyclable_package=[$t42], low_fat=[$t43], units_per_case=[$t44], cases_per_pallet=[$t45], shelf_width=[$t46], shelf_height=[$t47], shelf_depth=[$t48], product_class_id0=[$t29], product_subcategory=[$t30], product_category=[$t31], product_department=[$t32], product_family=[$t33], $condition=[$t61]): rowcount = 1953.8325, cumulative cost = {728728.1144018068 rows, 1.0519232E7 cpu, 0.0 io}\n  EnumerableJoinRel(condition=[=($51, $0)], joinType=[inner]): rowcount = 86837.0, cumulative cost = {726774.2819018068 rows, 98792.0 cpu, 0.0 io}\n    EnumerableTableScan(table=[[foodmart2, customer]]): rowcount = 10281.0, cumulative cost = {10281.0 rows, 10282.0 cpu, 0.0 io}\n    EnumerableJoinRel(condition=[=($5, $0)], joinType=[inner]): rowcount = 86837.0, cumulative cost = {447842.86095661717 rows, 88510.0 cpu, 0.0 io}\n      EnumerableTableScan(table=[[foodmart2, product_class]]): rowcount = 110.0, cumulative cost = {110.0 rows, 111.0 cpu, 0.0 io}\n      EnumerableJoinRel(condition=[=($15, $1)], joinType=[inner]): rowcount = 86837.0, cumulative cost = {273541.80811638 rows, 88399.0 cpu, 0.0 io}\n        EnumerableTableScan(table=[[foodmart2, product]]): rowcount = 1560.0, cumulative cost = {1560.0 rows, 1561.0 cpu, 0.0 io}\n        EnumerableTableScan(table=[[foodmart2, sales_fact_1997]]): rowcount = 86837.0, cumulative cost = {86837.0 rows, 86838.0 cpu, 0.0 io}\n"));
    }

    @Test
    public void testJanino169() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select \"time_id\" from \"foodmart\".\"time_by_day\" as \"t\"\n").returnsCount(730);
    }

    @Test
    public void testAnd3() {
        CalciteAssert.hr().query("select \"deptno\" from \"hr\".\"emps\"\nwhere \"emps\".\"empid\" < 240\nand \"salary\" > 7500.0and \"emps\".\"deptno\" > 10\n").returnsUnordered("deptno=20");
    }

    @Test
    public void testJdbcDate() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select count(*) as c from (\n  select 1 from \"foodmart\".\"employee\" as e1\n  where \"position_title\" = 'VP Country Manager'\n  and \"birth_date\" < DATE '1950-01-01'\n  and \"gender\" = 'F')").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.ORACLE).returns2("C=1\n");
    }

    @Test
    public void testJdbcTimestamp() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select count(*) as c from (\n  select 1 from \"foodmart\".\"employee\" as e1\n  where \"hire_date\" < TIMESTAMP '1996-06-05 00:00:00'\n  and \"gender\" = 'F')").returns("C=287\n");
    }

    @Test
    public void testExtract() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("values extract(year from date '2008-2-23')").returns(resultSet -> {
            BigDecimal bigDecimal;
            try {
                bigDecimal = resultSet.getBigDecimal(1);
                Assert.fail((String)("expected error, got " + bigDecimal));
            }
            catch (SQLException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"java.util.NoSuchElementException: Expecting cursor position to be Position.OK, actual is Position.BEFORE_START"));
            }
            try {
                Assert.assertTrue((boolean)resultSet.next());
                bigDecimal = resultSet.getBigDecimal(1);
                Assert.assertThat((Object)bigDecimal, (Matcher)CoreMatchers.equalTo((Object)BigDecimal.valueOf(2008L)));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testExtractMonthFromTimestamp() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select extract(month from \"birth_date\") as c \nfrom \"foodmart\".\"employee\" where \"employee_id\"=1").returns("C=8\n");
    }

    @Test
    public void testExtractYearFromTimestamp() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select extract(year from \"birth_date\") as c \nfrom \"foodmart\".\"employee\" where \"employee_id\"=1").returns("C=1961\n");
    }

    @Test
    public void testExtractFromInterval() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select extract(month from interval '2-3' year to month) as c \nfrom \"foodmart\".\"employee\" where \"employee_id\"=1").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.MYSQL && CalciteAssert.DB != CalciteAssert.DatabaseInstance.H2).returns("C=3\n");
    }

    @Test
    public void testExtractOnNullDateField() {
        String sql = "select\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\nfrom \"foodmart\".\"employee\"\nwhere extract(year from \"end_date\") in (1994, 1995, 1996)\ngroup by\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\n";
        String sql2 = "select\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\nfrom \"foodmart\".\"employee\"\nwhere extract(year from \"end_date\") in (1994, 1995, 1996)\ngroup by\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\n\nlimit 10000";
        String sql3 = "select *\nfrom \"foodmart\".\"employee\"\nwhere extract(year from \"end_date\") in (1994, 1995, 1996)";
        CalciteAssert.AssertThat with = CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE);
        with.query("select\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\nfrom \"foodmart\".\"employee\"\nwhere extract(year from \"end_date\") in (1994, 1995, 1996)\ngroup by\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\n").returns("");
        with.query("select\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\nfrom \"foodmart\".\"employee\"\nwhere extract(year from \"end_date\") in (1994, 1995, 1996)\ngroup by\n  extract(year from \"end_date\"), \"hire_date\", \"birth_date\"\n\nlimit 10000").returns("");
        with.query("select *\nfrom \"foodmart\".\"employee\"\nwhere extract(year from \"end_date\") in (1994, 1995, 1996)").returns("");
    }

    @Test
    public void testFloorDate() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select floor(timestamp '2011-9-14 19:27:23' to month) as c \nfrom \"foodmart\".\"employee\" limit 1").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.MYSQL && CalciteAssert.DB != CalciteAssert.DatabaseInstance.H2).returns("C=2011-09-01 00:00:00\n");
    }

    @Test
    public void testTrue() {
        CalciteAssert.AssertThat that = CalciteAssert.that();
        that.query("select case when deptno = 10 then null else true end as x\nfrom (values (10), (20)) as t(deptno)").returnsUnordered("X=null", "X=true");
        that.query("select case when deptno = 10 then null else 100 end as x\nfrom (values (10), (20)) as t(deptno)").returnsUnordered("X=null", "X=100");
        that.query("select case when deptno = 10 then null else 'xy' end as x\nfrom (values (10), (20)) as t(deptno)").returnsUnordered("X=null", "X=xy");
    }

    @Test
    public void testSelfJoin() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select count(*) as c from (\n  select 1 from \"foodmart\".\"employee\" as e1\n  join \"foodmart\".\"employee\" as e2 using (\"position_title\"))").returns("C=247149\n");
    }

    @Test
    public void testSelfJoinDifferentColumns() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select e1.\"full_name\"\n  from \"foodmart\".\"employee\" as e1\n  join \"foodmart\".\"employee\" as e2 on e1.\"first_name\" = e2.\"last_name\"\norder by e1.\"last_name\" limit 3").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.H2).returns("full_name=James Aguilar\nfull_name=Carol Amyotte\nfull_name=Terry Anderson\n");
    }

    @Test
    public void testIsNotDistinctInFilter() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select *\n  from \"foodmart\".\"employee\" as e1\n  where e1.\"last_name\" is distinct from e1.\"last_name\"").runs();
    }

    @Test
    public void testMixedEqualAndIsNotDistinctJoin() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select *\n  from \"foodmart\".\"employee\" as e1\n  join \"foodmart\".\"employee\" as e2 on\n  e1.\"first_name\" = e1.\"first_name\"\n  and e1.\"last_name\" is distinct from e2.\"last_name\"").runs();
    }

    @Test
    public void testEquiThetaJoin() {
        CalciteAssert.hr().query("select e.\"empid\", d.\"name\", e.\"name\"\nfrom \"hr\".\"emps\" as e\njoin \"hr\".\"depts\" as d\non e.\"deptno\" = d.\"deptno\"\nand e.\"name\" <> d.\"name\"\n").returns("empid=100; name=Sales; name=Bill\nempid=150; name=Sales; name=Sebastian\nempid=110; name=Sales; name=Theodore\n");
    }

    @Test
    public void testThetaJoin() {
        CalciteAssert.hr().query("select e.\"empid\", d.\"name\", e.\"name\"\nfrom \"hr\".\"emps\" as e\nleft join \"hr\".\"depts\" as d\non e.\"deptno\" < d.\"deptno\"\n").returnsUnordered("empid=100; name=Marketing; name=Bill", "empid=100; name=HR; name=Bill", "empid=200; name=Marketing; name=Eric", "empid=200; name=HR; name=Eric", "empid=150; name=Marketing; name=Sebastian", "empid=150; name=HR; name=Sebastian", "empid=110; name=Marketing; name=Theodore", "empid=110; name=HR; name=Theodore");
    }

    @Ignore
    @Test
    public void testJoinJoin() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select\n   \"product_class\".\"product_family\" as \"c0\",\n   \"product_class\".\"product_department\" as \"c1\",\n   \"customer\".\"country\" as \"c2\",\n   \"customer\".\"state_province\" as \"c3\",\n   \"customer\".\"city\" as \"c4\"\nfrom\n   \"sales_fact_1997\" as \"sales_fact_1997\"\njoin (\"product\" as \"product\"\n     join \"product_class\" as \"product_class\"\n     on \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\")\non  \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\njoin \"customer\" as \"customer\"\non  \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\njoin \"promotion\" as \"promotion\"\non \"sales_fact_1997\".\"promotion_id\" = \"promotion\".\"promotion_id\"\nwhere (\"promotion\".\"media_type\" = 'Radio'\n or \"promotion\".\"media_type\" = 'TV'\n or \"promotion\".\"media_type\" = 'Sunday Paper'\n or \"promotion\".\"media_type\" = 'Street Handout')\n and (\"product_class\".\"product_family\" = 'Drink')\n and (\"customer\".\"country\" = 'USA' and \"customer\".\"state_province\" = 'WA' and \"customer\".\"city\" = 'Bellingham')\ngroup by \"product_class\".\"product_family\",\n   \"product_class\".\"product_department\",\n   \"customer\".\"country\",\n   \"customer\".\"state_province\",\n   \"customer\".\"city\"\norder by ISNULL(\"product_class\".\"product_family\") ASC,   \"product_class\".\"product_family\" ASC,\n   ISNULL(\"product_class\".\"product_department\") ASC,   \"product_class\".\"product_department\" ASC,\n   ISNULL(\"customer\".\"country\") ASC,   \"customer\".\"country\" ASC,\n   ISNULL(\"customer\".\"state_province\") ASC,   \"customer\".\"state_province\" ASC,\n   ISNULL(\"customer\".\"city\") ASC,   \"customer\".\"city\" ASC").returns("+-------+---------------------+-----+------+------------+\n| c0    | c1                  | c2  | c3   | c4         |\n+-------+---------------------+-----+------+------------+\n| Drink | Alcoholic Beverages | USA | WA   | Bellingham |\n| Drink | Dairy               | USA | WA   | Bellingham |\n+-------+---------------------+-----+------+------------+");
    }

    @Ignore
    @Test
    public void testJoinFiveWay() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"store\".\"store_country\" as \"c0\",\n \"time_by_day\".\"the_year\" as \"c1\",\n \"product_class\".\"product_family\" as \"c2\",\n count(\"sales_fact_1997\".\"product_id\") as \"m0\"\nfrom \"store\" as \"store\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"time_by_day\" as \"time_by_day\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\"\nwhere \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\"\nand \"store\".\"store_country\" = 'USA'\nand \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\ngroup by \"store\".\"store_country\",\n \"time_by_day\".\"the_year\",\n \"product_class\".\"product_family\"").explainContains("EnumerableAggregateRel(group=[{0, 1, 2}], m0=[COUNT($3)])\n  EnumerableCalcRel(expr#0..61=[{inputs}], c0=[$t19], c1=[$t4], c2=[$t46], product_id=[$t34])\n    EnumerableJoinRel(condition=[=($35, $0)], joinType=[inner])\n      EnumerableCalcRel(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], proj#0..9=[{exprs}], $condition=[$t12])\n        EnumerableTableScan(table=[[foodmart2, time_by_day]])\n      EnumerableCalcRel(expr#0..51=[{inputs}], proj#0..23=[{exprs}], product_id=[$t44], time_id=[$t45], customer_id=[$t46], promotion_id=[$t47], store_id0=[$t48], store_sales=[$t49], store_cost=[$t50], unit_sales=[$t51], product_class_id=[$t24], product_subcategory=[$t25], product_category=[$t26], product_department=[$t27], product_family=[$t28], product_class_id0=[$t29], product_id0=[$t30], brand_name=[$t31], product_name=[$t32], SKU=[$t33], SRP=[$t34], gross_weight=[$t35], net_weight=[$t36], recyclable_package=[$t37], low_fat=[$t38], units_per_case=[$t39], cases_per_pallet=[$t40], shelf_width=[$t41], shelf_height=[$t42], shelf_depth=[$t43])\n        EnumerableJoinRel(condition=[=($48, $0)], joinType=[inner])\n          EnumerableCalcRel(expr#0..23=[{inputs}], expr#24=['USA'], expr#25=[=($t9, $t24)], proj#0..23=[{exprs}], $condition=[$t25])\n            EnumerableTableScan(table=[[foodmart2, store]])\n          EnumerableCalcRel(expr#0..27=[{inputs}], proj#0..4=[{exprs}], product_class_id0=[$t13], product_id=[$t14], brand_name=[$t15], product_name=[$t16], SKU=[$t17], SRP=[$t18], gross_weight=[$t19], net_weight=[$t20], recyclable_package=[$t21], low_fat=[$t22], units_per_case=[$t23], cases_per_pallet=[$t24], shelf_width=[$t25], shelf_height=[$t26], shelf_depth=[$t27], product_id0=[$t5], time_id=[$t6], customer_id=[$t7], promotion_id=[$t8], store_id=[$t9], store_sales=[$t10], store_cost=[$t11], unit_sales=[$t12])\n            EnumerableJoinRel(condition=[=($13, $0)], joinType=[inner])\n              EnumerableTableScan(table=[[foodmart2, product_class]])\n              EnumerableJoinRel(condition=[=($0, $9)], joinType=[inner])\n                EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n                EnumerableTableScan(table=[[foodmart2, product]])\n\n]>").returns("+-------+---------------------+-----+------+------------+\n| c0    | c1                  | c2  | c3   | c4         |\n+-------+---------------------+-----+------+------------+\n| Drink | Alcoholic Beverages | USA | WA   | Bellingham |\n| Drink | Dairy               | USA | WA   | Bellingham |\n+-------+---------------------+-----+------+------------+");
    }

    @Test
    public void testJoinManyWay() {
        JdbcTest.checkJoinNWay(1);
        JdbcTest.checkJoinNWay(3);
        JdbcTest.checkJoinNWay(6);
    }

    private static void checkJoinNWay(int n) {
        int i;
        assert (n > 0);
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*)");
        for (i = 0; i < n; ++i) {
            buf.append(i == 0 ? "\nfrom " : ",\n").append("\"hr\".\"depts\" as d").append(i);
        }
        for (i = 1; i < n; ++i) {
            buf.append(i == 1 ? "\nwhere" : "\nand").append(" d").append(i).append(".\"deptno\" = d").append(i - 1).append(".\"deptno\"");
        }
        CalciteAssert.hr().query(buf.toString()).returns("EXPR$0=3\n");
    }

    private static List<Pair<String, String>> querify(String[] queries1) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < queries1.length; ++i) {
            String query = queries1[i];
            String expected = null;
            if (i + 1 < queries1.length && queries1[i + 1] != null && !queries1[i + 1].startsWith("select")) {
                expected = queries1[++i];
            }
            list.add((Pair<String, String>)Pair.of((Object)query, expected));
        }
        return list;
    }

    @Ignore
    @Test
    public void testCloneQueries() {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE);
        for (Ord query : Ord.zip(FOODMART_QUERIES)) {
            try {
                String sql = (String)((Pair)query.e).left;
                if (sql.startsWith("ignore:")) continue;
                String expected = (String)((Pair)query.e).right;
                CalciteAssert.AssertQuery query1 = with.query(sql);
                if (expected != null) {
                    if (sql.contains("order by")) {
                        query1.returns(expected);
                        continue;
                    }
                    query1.returnsUnordered(expected.split("\n"));
                    continue;
                }
                query1.runs();
            }
            catch (Throwable e) {
                throw new RuntimeException("while running query #" + query.i, e);
            }
        }
    }

    @Test
    public void testArray() throws Exception {
        String url = MultiJdbcSchemaJoinTest.TempDb.INSTANCE.getUrl();
        Connection baseConnection = DriverManager.getConnection(url);
        Statement baseStmt = baseConnection.createStatement();
        baseStmt.execute("CREATE TABLE ARR_TABLE (\nID INTEGER,\nVALS INTEGER ARRAY)");
        baseStmt.execute("INSERT INTO ARR_TABLE VALUES (1, ARRAY[1,2,3])");
        baseStmt.execute("CREATE TABLE ARR_TABLE2 (\nID INTEGER,\nVALS INTEGER ARRAY,\nVALVALS VARCHAR(10) ARRAY)");
        baseStmt.execute("INSERT INTO ARR_TABLE2 VALUES (1, ARRAY[1,2,3], ARRAY['x','y'])");
        baseStmt.close();
        baseConnection.commit();
        Properties info = new Properties();
        info.put("model", "inline:{\n  version: '1.0',\n  defaultSchema: 'BASEJDBC',\n  schemas: [\n     {\n       type: 'jdbc',\n       name: 'BASEJDBC',\n       jdbcDriver: '" + jdbcDriver.class.getName() + "',\n       jdbcUrl: '" + url + "',\n       jdbcCatalog: null,\n       jdbcSchema: null\n     }\n  ]\n}");
        Connection calciteConnection = DriverManager.getConnection("jdbc:calcite:", info);
        Statement calciteStatement = calciteConnection.createStatement();
        String sql = "SELECT ID, VALS FROM ARR_TABLE";
        ResultSet rs = calciteStatement.executeQuery("SELECT ID, VALS FROM ARR_TABLE");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Array array = rs.getArray(2);
        Assert.assertNotNull((Object)array);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])((int[])array.getArray()));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = calciteStatement.executeQuery("SELECT ID, CARDINALITY(VALS), VALS[2] FROM ARR_TABLE");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = calciteStatement.executeQuery("SELECT * FROM ARR_TABLE2");
        ResultSetMetaData metaData = rs.getMetaData();
        Assert.assertThat((Object)metaData.getColumnTypeName(1), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
        Assert.assertThat((Object)metaData.getColumnTypeName(2), (Matcher)CoreMatchers.equalTo((Object)"INTEGER ARRAY"));
        Assert.assertThat((Object)metaData.getColumnTypeName(3), (Matcher)CoreMatchers.equalTo((Object)"VARCHAR(10) ARRAY"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertThat((Object)rs.getArray(2), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)rs.getArray(3), (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((boolean)rs.next());
        calciteConnection.close();
    }

    @Test
    public void testArray2() {
        CalciteAssert.hr().query("select \"deptno\", cardinality(\"employees\") as c\nfrom \"hr\".\"depts\"").returnsUnordered("deptno=10; C=2", "deptno=30; C=0", "deptno=40; C=1");
    }

    @Test
    public void testNestedArray() throws Exception {
        CalciteAssert.hr().doWithConnection(connection -> {
            try {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select \"empid\",\n  array[\n    array['x', 'y', 'z'],\n    array[\"name\"]] as a\nfrom \"hr\".\"emps\"");
                Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)100));
                Assert.assertThat((Object)resultSet.getString(2), (Matcher)CoreMatchers.equalTo((Object)"[[x, y, z], [Bill]]"));
                Array array = resultSet.getArray(2);
                Assert.assertThat((Object)array.getBaseType(), (Matcher)CoreMatchers.equalTo((Object)2003));
                Object[] arrayValues = (Object[])array.getArray();
                Assert.assertThat((Object)arrayValues.length, (Matcher)CoreMatchers.equalTo((Object)2));
                Array subArray = (Array)arrayValues[0];
                Assert.assertThat((Object)subArray.getBaseType(), (Matcher)CoreMatchers.equalTo((Object)12));
                Object[] subArrayValues = (Object[])subArray.getArray();
                Assert.assertThat((Object)subArrayValues.length, (Matcher)CoreMatchers.equalTo((Object)3));
                Assert.assertThat((Object)subArrayValues[2], (Matcher)CoreMatchers.equalTo((Object)"z"));
                ResultSet subResultSet = subArray.getResultSet();
                Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)subResultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"x"));
                try {
                    String string = subResultSet.getString(2);
                    Assert.fail((String)("expected error, got " + string));
                }
                catch (SQLException e) {
                    Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"invalid column ordinal: 2"));
                }
                Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)subResultSet.isAfterLast(), (Matcher)CoreMatchers.is((Object)false));
                Assert.assertThat((Object)subResultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"z"));
                Assert.assertThat((Object)subResultSet.next(), (Matcher)CoreMatchers.is((Object)false));
                Assert.assertThat((Object)subResultSet.isAfterLast(), (Matcher)CoreMatchers.is((Object)true));
                statement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testArrayConstructor() {
        CalciteAssert.that().query("select array[1,2] as a from (values (1))").returnsUnordered("A=[1, 2]");
    }

    @Test
    public void testMultisetConstructor() {
        CalciteAssert.that().query("select multiset[1,2] as a from (values (1))").returnsUnordered("A=[1, 2]");
    }

    @Test
    public void testMultisetQuery() {
        CalciteAssert.hr().query("select multiset(\n  select \"deptno\", \"empid\" from \"hr\".\"emps\") as a\nfrom (values (1))").returnsUnordered("A=[{10, 100}, {20, 200}, {10, 150}, {10, 110}]");
    }

    @Test
    public void testMultisetQueryWithSingleColumn() {
        CalciteAssert.hr().query("select multiset(\n  select \"deptno\" from \"hr\".\"emps\") as a\nfrom (values (1))").returnsUnordered("A=[{10}, {20}, {10}, {10}]");
    }

    @Test
    public void testUnnestArray() {
        CalciteAssert.that().query("select*from unnest(array[1,2])").returnsUnordered("EXPR$0=1", "EXPR$0=2");
    }

    @Test
    public void testUnnestArrayWithOrdinality() {
        CalciteAssert.that().query("select*from unnest(array[10,20]) with ordinality as t(i, o)").returnsUnordered("I=10; O=1", "I=20; O=2");
    }

    @Test
    public void testUnnestMultiset() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select*from unnest(multiset[1,2]) as t(c)").returnsUnordered("C=1", "C=2");
    }

    @Test
    public void testUnnestMultiset2() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select*from unnest(\n select \"employees\" from \"hr\".\"depts\"\n where \"deptno\" = 10)").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000", "empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null");
    }

    @Test
    public void testAggUnnestColumn() {
        String sql = "select count(d.\"name\") as c\nfrom \"hr\".\"depts\" as d,\n UNNEST(d.\"employees\") as e";
        CalciteAssert.hr().query("select count(d.\"name\") as c\nfrom \"hr\".\"depts\" as d,\n UNNEST(d.\"employees\") as e").returnsUnordered("C=3");
    }

    @Test
    public void testArrayElement() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select element(\"employees\") from \"hr\".\"depts\"\nwhere cardinality(\"employees\") < 2").returnsUnordered("EXPR$0={200, 20, Eric, 8000.0, 500}", "EXPR$0=null");
    }

    @Test
    public void testLateral() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\",\n LATERAL (select * from \"hr\".\"depts\" where \"emps\".\"deptno\" = \"depts\".\"deptno\")").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; deptno0=10; name0=Sales; employees=[{100, 10, Bill, 10000.0, 1000}, {150, 10, Sebastian, 7000.0, null}]; location={-122, 38}", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; deptno0=10; name0=Sales; employees=[{100, 10, Bill, 10000.0, 1000}, {150, 10, Sebastian, 7000.0, null}]; location={-122, 38}", "empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null; deptno0=10; name0=Sales; employees=[{100, 10, Bill, 10000.0, 1000}, {150, 10, Sebastian, 7000.0, null}]; location={-122, 38}");
    }

    @Test
    public void testLateralWithOver() {
        String sql = "select \"emps\".\"name\", d.\"deptno\", d.m\nfrom \"hr\".\"emps\",\n  LATERAL (\n    select \"depts\".\"deptno\",\n      max(\"deptno\" + \"emps\".\"empid\") over (\n        partition by \"emps\".\"deptno\") as m\n     from \"hr\".\"depts\"\n     where \"emps\".\"deptno\" = \"depts\".\"deptno\") as d";
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select \"emps\".\"name\", d.\"deptno\", d.m\nfrom \"hr\".\"emps\",\n  LATERAL (\n    select \"depts\".\"deptno\",\n      max(\"deptno\" + \"emps\".\"empid\") over (\n        partition by \"emps\".\"deptno\") as m\n     from \"hr\".\"depts\"\n     where \"emps\".\"deptno\" = \"depts\".\"deptno\") as d").returnsUnordered("name=Bill; deptno=10; M=190", "name=Bill; deptno=30; M=190", "name=Bill; deptno=40; M=190", "name=Eric; deptno=10; M=240", "name=Eric; deptno=30; M=240", "name=Eric; deptno=40; M=240", "name=Sebastian; deptno=10; M=190", "name=Sebastian; deptno=30; M=190", "name=Sebastian; deptno=40; M=190", "name=Theodore; deptno=10; M=190", "name=Theodore; deptno=30; M=190", "name=Theodore; deptno=40; M=190");
    }

    @Test
    public void testUnnestArrayColumn() {
        CalciteAssert.hr().query("select d.\"name\", e.*\nfrom \"hr\".\"depts\" as d,\n UNNEST(d.\"employees\") as e").returnsUnordered("name=HR; empid=200; deptno=20; name0=Eric; salary=8000.0; commission=500", "name=Sales; empid=100; deptno=10; name0=Bill; salary=10000.0; commission=1000", "name=Sales; empid=150; deptno=10; name0=Sebastian; salary=7000.0; commission=null");
    }

    @Test
    public void testUnnestArrayScalarArray() {
        CalciteAssert.hr().query("select d.\"name\", e.*\nfrom \"hr\".\"depts\" as d,\n UNNEST(d.\"employees\", array[1, 2]) as e").returnsUnordered("name=HR; empid=200; deptno=20; name0=Eric; salary=8000.0; commission=500; EXPR$1=1", "name=HR; empid=200; deptno=20; name0=Eric; salary=8000.0; commission=500; EXPR$1=2", "name=Sales; empid=100; deptno=10; name0=Bill; salary=10000.0; commission=1000; EXPR$1=1", "name=Sales; empid=100; deptno=10; name0=Bill; salary=10000.0; commission=1000; EXPR$1=2", "name=Sales; empid=150; deptno=10; name0=Sebastian; salary=7000.0; commission=null; EXPR$1=1", "name=Sales; empid=150; deptno=10; name0=Sebastian; salary=7000.0; commission=null; EXPR$1=2");
    }

    @Test
    public void testUnnestArrayScalarArrayAliased() {
        CalciteAssert.hr().query("select d.\"name\", e.*\nfrom \"hr\".\"depts\" as d,\n UNNEST(d.\"employees\", array[1, 2]) as e (ei, d, n, s, c, i)\nwhere ei + i > 151").returnsUnordered("name=HR; EI=200; D=20; N=Eric; S=8000.0; C=500; I=1", "name=HR; EI=200; D=20; N=Eric; S=8000.0; C=500; I=2", "name=Sales; EI=150; D=10; N=Sebastian; S=7000.0; C=null; I=2");
    }

    @Test
    public void testUnnestArrayScalarArrayWithOrdinal() {
        CalciteAssert.hr().query("select d.\"name\", e.*\nfrom \"hr\".\"depts\" as d,\n UNNEST(d.\"employees\", array[1, 2]) with ordinality as e (ei, d, n, s, c, i, o)\nwhere ei + i > 151").returnsUnordered("name=HR; EI=200; D=20; N=Eric; S=8000.0; C=500; I=1; O=2", "name=HR; EI=200; D=20; N=Eric; S=8000.0; C=500; I=2; O=4", "name=Sales; EI=150; D=10; N=Sebastian; S=7000.0; C=null; I=2; O=5");
    }

    @Test
    public void testUnnestItemsInMap() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        String sql = "select * from unnest(MAP['a', 1, 'b', 2]) as um(k, v)";
        ResultSet resultSet = connection.createStatement().executeQuery("select * from unnest(MAP['a', 1, 'b', 2]) as um(k, v)");
        String expected = "K=a; V=1\nK=b; V=2\n";
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"K=a; V=1\nK=b; V=2\n"));
        connection.close();
    }

    @Test
    public void testUnnestItemsInMapWithOrdinality() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        String sql = "select *\nfrom unnest(MAP['a', 1, 'b', 2]) with ordinality as um(k, v, i)";
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom unnest(MAP['a', 1, 'b', 2]) with ordinality as um(k, v, i)");
        String expected = "K=a; V=1; I=1\nK=b; V=2; I=2\n";
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"K=a; V=1; I=1\nK=b; V=2; I=2\n"));
        connection.close();
    }

    @Test
    public void testUnnestItemsInMapWithNoAliasAndAdditionalArgument() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        String sql = "select * from unnest(MAP['a', 1, 'b', 2], array[5, 6, 7])";
        ResultSet resultSet = connection.createStatement().executeQuery("select * from unnest(MAP['a', 1, 'b', 2], array[5, 6, 7])");
        List map = FlatLists.of((Object)"KEY=a; VALUE=1", (Object)"KEY=b; VALUE=2");
        List array = FlatLists.of((Object)" EXPR$1=5", (Object)" EXPR$1=6", (Object)" EXPR$1=7");
        StringBuilder b = new StringBuilder();
        for (List row : Linq4j.product((Iterable)FlatLists.of((Object)map, (Object)array))) {
            b.append((String)row.get(0)).append(";").append((String)row.get(1)).append("\n");
        }
        String expected = b.toString();
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)expected));
        connection.close();
    }

    private CalciteAssert.AssertQuery withFoodMartQuery(int id) throws IOException {
        FoodMartQuerySet set = FoodMartQuerySet.instance();
        return CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query(set.queries.get((Object)Integer.valueOf((int)id)).sql);
    }

    @Ignore
    @Test
    public void testNoCalcBetweenJoins() throws IOException {
        FoodMartQuerySet set = FoodMartQuerySet.instance();
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query(set.queries.get((Object)Integer.valueOf((int)16)).sql).explainContains("EnumerableSortRel(sort0=[$0], sort1=[$1], sort2=[$2], sort3=[$4], sort4=[$10], sort5=[$11], sort6=[$12], sort7=[$13], sort8=[$22], sort9=[$23], sort10=[$24], sort11=[$25], sort12=[$26], sort13=[$27], dir0=[Ascending-nulls-last], dir1=[Ascending-nulls-last], dir2=[Ascending-nulls-last], dir3=[Ascending-nulls-last], dir4=[Ascending-nulls-last], dir5=[Ascending-nulls-last], dir6=[Ascending-nulls-last], dir7=[Ascending-nulls-last], dir8=[Ascending-nulls-last], dir9=[Ascending-nulls-last], dir10=[Ascending-nulls-last], dir11=[Ascending-nulls-last], dir12=[Ascending-nulls-last], dir13=[Ascending-nulls-last])\n  EnumerableCalcRel(expr#0..26=[{inputs}], proj#0..4=[{exprs}], c5=[$t4], c6=[$t5], c7=[$t6], c8=[$t7], c9=[$t8], c10=[$t9], c11=[$t10], c12=[$t11], c13=[$t12], c14=[$t13], c15=[$t14], c16=[$t15], c17=[$t16], c18=[$t17], c19=[$t18], c20=[$t19], c21=[$t20], c22=[$t21], c23=[$t22], c24=[$t23], c25=[$t24], c26=[$t25], c27=[$t26])\n    EnumerableAggregateRel(group=[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26}])\n      EnumerableCalcRel(expr#0..80=[{inputs}], c0=[$t12], c1=[$t10], c2=[$t9], c3=[$t0], fullname=[$t28], c6=[$t19], c7=[$t17], c8=[$t22], c9=[$t18], c10=[$t46], c11=[$t44], c12=[$t43], c13=[$t40], c14=[$t38], c15=[$t47], c16=[$t52], c17=[$t53], c18=[$t54], c19=[$t55], c20=[$t56], c21=[$t42], c22=[$t80], c23=[$t79], c24=[$t78], c25=[$t77], c26=[$t63], c27=[$t64])\n        EnumerableJoinRel(condition=[=($61, $76)], joinType=[inner])\n          EnumerableJoinRel(condition=[=($29, $62)], joinType=[inner])\n            EnumerableJoinRel(condition=[=($33, $37)], joinType=[inner])\n              EnumerableCalcRel(expr#0..36=[{inputs}], customer_id=[$t8], account_num=[$t9], lname=[$t10], fname=[$t11], mi=[$t12], address1=[$t13], address2=[$t14], address3=[$t15], address4=[$t16], city=[$t17], state_province=[$t18], postal_code=[$t19], country=[$t20], customer_region_id=[$t21], phone1=[$t22], phone2=[$t23], birthdate=[$t24], marital_status=[$t25], yearly_income=[$t26], gender=[$t27], total_children=[$t28], num_children_at_home=[$t29], education=[$t30], date_accnt_opened=[$t31], member_card=[$t32], occupation=[$t33], houseowner=[$t34], num_cars_owned=[$t35], fullname=[$t36], product_id=[$t0], time_id=[$t1], customer_id0=[$t2], promotion_id=[$t3], store_id=[$t4], store_sales=[$t5], store_cost=[$t6], unit_sales=[$t7])\n                EnumerableJoinRel(condition=[=($2, $8)], joinType=[inner])\n                  EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n                  EnumerableTableScan(table=[[foodmart2, customer]])\n              EnumerableTableScan(table=[[foodmart2, store]])\n            EnumerableTableScan(table=[[foodmart2, product]])\n          EnumerableTableScan(table=[[foodmart2, product_class]])\n");
    }

    @Ignore
    @Test
    public void testExplainJoin() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query((String)JdbcTest.FOODMART_QUERIES.get((int)48).left).explainContains("EnumerableAggregateRel(group=[{}], m0=[COUNT($0)])\n  EnumerableAggregateRel(group=[{0}])\n    EnumerableCalcRel(expr#0..27=[{inputs}], customer_id=[$t7])\n      EnumerableJoinRel(condition=[=($13, $0)], joinType=[inner])\n        EnumerableTableScan(table=[[foodmart2, product_class]])\n        EnumerableJoinRel(condition=[=($0, $9)], joinType=[inner])\n          EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n          EnumerableCalcRel(expr#0..14=[{inputs}], expr#15=['Cormorant'], expr#16=[=($t2, $t15)], proj#0..14=[{exprs}], $condition=[$t16])\n            EnumerableTableScan(table=[[foodmart2, product]]");
    }

    @Ignore
    @Test
    public void testExplainJoin2() throws IOException {
        this.withFoodMartQuery(2482).explainContains("EnumerableSortRel(sort0=[$0], sort1=[$1], dir0=[Ascending-nulls-last], dir1=[Ascending-nulls-last])\n  EnumerableAggregateRel(group=[{0, 1}])\n    EnumerableCalcRel(expr#0..5=[{inputs}], c0=[$t4], c1=[$t1])\n      EnumerableJoinRel(condition=[=($3, $5)], joinType=[inner])\n        EnumerableCalcRel(expr#0..3=[{inputs}], store_id=[$t2], store_country=[$t3], store_id0=[$t0], month_of_year=[$t1])\n          EnumerableJoinRel(condition=[=($0, $2)], joinType=[inner])\n            EnumerableCalcRel(expr#0..10=[{inputs}], store_id=[$t2], month_of_year=[$t4])\n              EnumerableTableScan(table=[[foodmart2, agg_c_14_sales_fact_1997]])\n            EnumerableCalcRel(expr#0..23=[{inputs}], store_id=[$t0], store_country=[$t9])\n              EnumerableTableScan(table=[[foodmart2, store]])\n        EnumerableCalcRel(expr#0..9=[{inputs}], the_year=[$t4], month_of_year=[$t7])\n          EnumerableTableScan(table=[[foodmart2, time_by_day]])\n").runs();
    }

    @Ignore
    @Test
    public void testExplainJoin3() throws IOException {
        this.withFoodMartQuery(8).explainContains("EnumerableSortRel(sort0=[$0], sort1=[$1], sort2=[$2], sort3=[$4], dir0=[Ascending-nulls-last], dir1=[Ascending-nulls-last], dir2=[Ascending-nulls-last], dir3=[Ascending-nulls-last])\n  EnumerableCalcRel(expr#0..8=[{inputs}], expr#9=['%Jeanne%'], expr#10=[LIKE($t4, $t9)], proj#0..4=[{exprs}], c5=[$t4], c6=[$t5], c7=[$t6], c8=[$t7], c9=[$t8], $condition=[$t10])\n    EnumerableAggregateRel(group=[{0, 1, 2, 3, 4, 5, 6, 7, 8}])\n      EnumerableCalcRel(expr#0..46=[{inputs}], c0=[$t12], c1=[$t10], c2=[$t9], c3=[$t0], fullname=[$t28], c6=[$t19], c7=[$t17], c8=[$t22], c9=[$t18])\n        EnumerableJoinRel(condition=[=($30, $37)], joinType=[inner])\n          EnumerableCalcRel(expr#0..36=[{inputs}], customer_id=[$t8], account_num=[$t9], lname=[$t10], fname=[$t11], mi=[$t12], address1=[$t13], address2=[$t14], address3=[$t15], address4=[$t16], city=[$t17], state_province=[$t18], postal_code=[$t19], country=[$t20], customer_region_id=[$t21], phone1=[$t22], phone2=[$t23], birthdate=[$t24], marital_status=[$t25], yearly_income=[$t26], gender=[$t27], total_children=[$t28], num_children_at_home=[$t29], education=[$t30], date_accnt_opened=[$t31], member_card=[$t32], occupation=[$t33], houseowner=[$t34], num_cars_owned=[$t35], fullname=[$t36], product_id=[$t0], time_id=[$t1], customer_id0=[$t2], promotion_id=[$t3], store_id=[$t4], store_sales=[$t5], store_cost=[$t6], unit_sales=[$t7])\n            EnumerableJoinRel(condition=[=($2, $8)], joinType=[inner])\n              EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n              EnumerableTableScan(table=[[foodmart2, customer]])\n          EnumerableCalcRel(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], proj#0..9=[{exprs}], $condition=[$t12])\n            EnumerableTableScan(table=[[foodmart2, time_by_day]])").runs();
    }

    @Ignore
    @Test
    public void testFoodmartLattice() throws IOException {
        FoodMartQuerySet set = FoodMartQuerySet.instance();
        FoodMartQuerySet.FoodmartQuery query = set.queries.get(8);
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART_WITH_LATTICE).withDefaultSchema("foodmart").pooled().query(query.sql).enableMaterializations(true).explainContains("EnumerableCalc(expr#0..8=[{inputs}], c0=[$t3], c1=[$t2], c2=[$t1], c3=[$t0], c4=[$t8], c5=[$t8], c6=[$t6], c7=[$t4], c8=[$t7], c9=[$t5])\n  EnumerableSort(sort0=[$3], sort1=[$2], sort2=[$1], sort3=[$8], dir0=[ASC-nulls-last], dir1=[ASC-nulls-last], dir2=[ASC-nulls-last], dir3=[ASC-nulls-last])\n    EnumerableAggregate(group=[{0, 1, 2, 3, 4, 5, 6, 7, 8}])\n      EnumerableCalc(expr#0..9=[{inputs}], expr#10=[CAST($t0):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], expr#13=['%Jeanne%'], expr#14=[LIKE($t9, $t13)], expr#15=[AND($t12, $t14)], $f0=[$t1], $f1=[$t2], $f2=[$t3], $f3=[$t4], $f4=[$t5], $f5=[$t6], $f6=[$t7], $f7=[$t8], $f8=[$t9], $f9=[$t0], $condition=[$t15])\n        EnumerableTableScan(table=[[foodmart, m{12, 18, 27, 28, 30, 35, 36, 37, 40, 46}]])").runs();
    }

    @Ignore
    @Test
    public void testExplainJoin4() throws IOException {
        this.withFoodMartQuery(5217).explainContains("EnumerableAggregateRel(group=[{0, 1, 2, 3}], m0=[COUNT($4)])\n  EnumerableCalcRel(expr#0..69=[{inputs}], c0=[$t4], c1=[$t27], c2=[$t61], c3=[$t66], $f11=[$t11])\n    EnumerableJoinRel(condition=[=($68, $69)], joinType=[inner])\n      EnumerableCalcRel(expr#0..67=[{inputs}], proj#0..67=[{exprs}], $f68=[$t66])\n        EnumerableJoinRel(condition=[=($11, $65)], joinType=[inner])\n          EnumerableJoinRel(condition=[=($46, $59)], joinType=[inner])\n            EnumerableCalcRel(expr#0..58=[{inputs}], $f0=[$t49], $f1=[$t50], $f2=[$t51], $f3=[$t52], $f4=[$t53], $f5=[$t54], $f6=[$t55], $f7=[$t56], $f8=[$t57], $f9=[$t58], $f10=[$t41], $f11=[$t42], $f12=[$t43], $f13=[$t44], $f14=[$t45], $f15=[$t46], $f16=[$t47], $f17=[$t48], $f18=[$t0], $f19=[$t1], $f20=[$t2], $f21=[$t3], $f22=[$t4], $f23=[$t5], $f24=[$t6], $f25=[$t7], $f26=[$t8], $f27=[$t9], $f28=[$t10], $f29=[$t11], $f30=[$t12], $f31=[$t13], $f32=[$t14], $f33=[$t15], $f34=[$t16], $f35=[$t17], $f36=[$t18], $f37=[$t19], $f38=[$t20], $f39=[$t21], $f40=[$t22], $f41=[$t23], $f42=[$t24], $f43=[$t25], $f44=[$t26], $f45=[$t27], $f46=[$t28], $f47=[$t29], $f48=[$t30], $f49=[$t31], $f50=[$t32], $f51=[$t33], $f52=[$t34], $f53=[$t35], $f54=[$t36], $f55=[$t37], $f56=[$t38], $f57=[$t39], $f58=[$t40])\n              EnumerableJoinRel(condition=[=($41, $50)], joinType=[inner])\n                EnumerableCalcRel(expr#0..48=[{inputs}], $f0=[$t25], $f1=[$t26], $f2=[$t27], $f3=[$t28], $f4=[$t29], $f5=[$t30], $f6=[$t31], $f7=[$t32], $f8=[$t33], $f9=[$t34], $f10=[$t35], $f11=[$t36], $f12=[$t37], $f13=[$t38], $f14=[$t39], $f15=[$t40], $f16=[$t41], $f17=[$t42], $f18=[$t43], $f19=[$t44], $f20=[$t45], $f21=[$t46], $f22=[$t47], $f23=[$t48], $f24=[$t8], $f25=[$t9], $f26=[$t10], $f27=[$t11], $f28=[$t12], $f29=[$t13], $f30=[$t14], $f31=[$t15], $f32=[$t16], $f33=[$t17], $f34=[$t18], $f35=[$t19], $f36=[$t20], $f37=[$t21], $f38=[$t22], $f39=[$t23], $f40=[$t24], $f41=[$t0], $f42=[$t1], $f43=[$t2], $f44=[$t3], $f45=[$t4], $f46=[$t5], $f47=[$t6], $f48=[$t7])\n                  EnumerableJoinRel(condition=[=($14, $25)], joinType=[inner])\n                    EnumerableJoinRel(condition=[=($1, $8)], joinType=[inner])\n                      EnumerableTableScan(table=[[foodmart2, salary]])\n                      EnumerableTableScan(table=[[foodmart2, employee]])\n                    EnumerableTableScan(table=[[foodmart2, store]])\n                EnumerableTableScan(table=[[foodmart2, time_by_day]])\n            EnumerableTableScan(table=[[foodmart2, position]])\n          EnumerableTableScan(table=[[foodmart2, employee_closure]])\n      EnumerableAggregateRel(group=[{0}])\n        EnumerableValuesRel(tuples=[[{ 1 }, { 2 }, { 20 }, { 21 }, { 22 }, { 23 }, { 24 }, { 25 }, { 26 }, { 27 }, { 28 }, { 29 }, { 30 }, { 31 }, { 53 }, { 54 }, { 55 }, { 56 }, { 57 }, { 58 }, { 59 }, { 60 }, { 61 }, { 62 }, { 63 }, { 64 }, { 65 }, { 66 }, { 67 }, { 68 }, { 69 }, { 70 }, { 71 }, { 72 }, { 73 }, { 74 }, { 75 }, { 76 }, { 77 }, { 78 }, { 79 }, { 80 }, { 81 }, { 82 }, { 83 }, { 84 }, { 85 }, { 86 }, { 87 }, { 88 }, { 89 }, { 90 }, { 91 }, { 92 }, { 93 }, { 94 }, { 95 }, { 96 }, { 97 }, { 98 }, { 99 }, { 100 }, { 101 }, { 102 }, { 103 }, { 104 }, { 105 }, { 106 }, { 107 }, { 108 }, { 109 }, { 110 }, { 111 }, { 112 }, { 113 }, { 114 }, { 115 }, { 116 }, { 117 }, { 118 }, { 119 }, { 120 }, { 121 }, { 122 }, { 123 }, { 124 }, { 125 }, { 126 }, { 127 }, { 128 }, { 129 }, { 130 }, { 131 }, { 132 }, { 133 }, { 134 }, { 135 }, { 136 }, { 137 }, { 138 }, { 139 }, { 140 }, { 141 }, { 142 }, { 143 }, { 144 }, { 145 }, { 146 }, { 147 }, { 148 }, { 149 }, { 150 }, { 151 }, { 152 }, { 153 }, { 154 }, { 155 }, { 156 }, { 157 }, { 158 }, { 159 }, { 160 }, { 161 }, { 162 }, { 163 }, { 164 }, { 165 }, { 166 }, { 167 }, { 168 }, { 169 }, { 170 }, { 171 }, { 172 }, { 173 }, { 174 }, { 175 }, { 176 }, { 177 }, { 178 }, { 179 }, { 180 }, { 181 }, { 182 }, { 183 }, { 184 }, { 185 }, { 186 }, { 187 }, { 188 }, { 189 }, { 190 }, { 191 }, { 192 }, { 193 }, { 194 }, { 195 }, { 196 }, { 197 }, { 198 }, { 199 }, { 200 }, { 201 }, { 202 }, { 203 }, { 204 }, { 205 }, { 206 }, { 207 }, { 208 }, { 209 }, { 210 }, { 211 }, { 212 }, { 213 }, { 214 }, { 215 }, { 216 }, { 217 }, { 218 }, { 219 }, { 220 }, { 221 }, { 222 }, { 223 }, { 224 }, { 225 }, { 226 }, { 227 }, { 228 }, { 229 }, { 230 }, { 231 }, { 232 }, { 233 }, { 234 }, { 235 }, { 236 }, { 237 }, { 238 }, { 239 }, { 240 }, { 241 }, { 242 }, { 243 }, { 244 }, { 245 }, { 246 }, { 247 }, { 248 }, { 249 }, { 250 }, { 251 }, { 252 }, { 253 }, { 254 }, { 255 }, { 256 }, { 257 }, { 258 }, { 259 }, { 260 }, { 261 }, { 262 }, { 263 }, { 264 }, { 265 }, { 266 }, { 267 }, { 268 }, { 269 }, { 270 }, { 271 }, { 272 }, { 273 }, { 274 }, { 275 }, { 276 }, { 277 }, { 278 }, { 279 }, { 280 }, { 281 }, { 282 }, { 283 }, { 284 }, { 285 }, { 286 }, { 287 }, { 288 }, { 289 }, { 290 }, { 291 }, { 292 }, { 293 }, { 294 }, { 295 }, { 296 }, { 297 }, { 298 }, { 299 }, { 300 }, { 301 }, { 302 }, { 303 }, { 304 }, { 305 }, { 306 }, { 307 }, { 308 }, { 309 }, { 310 }, { 311 }, { 312 }, { 313 }, { 314 }, { 315 }, { 316 }, { 317 }, { 318 }, { 319 }, { 320 }, { 321 }, { 322 }, { 323 }, { 324 }, { 325 }, { 326 }, { 327 }, { 328 }, { 329 }, { 330 }, { 331 }, { 332 }, { 333 }, { 334 }, { 335 }, { 336 }, { 337 }, { 338 }, { 339 }, { 340 }, { 341 }, { 342 }, { 343 }, { 344 }, { 345 }, { 346 }, { 347 }, { 348 }, { 349 }, { 350 }, { 351 }, { 352 }, { 353 }, { 354 }, { 355 }, { 356 }, { 357 }, { 358 }, { 359 }, { 360 }, { 361 }, { 362 }, { 363 }, { 364 }, { 365 }, { 366 }, { 367 }, { 368 }, { 369 }, { 370 }, { 371 }, { 372 }, { 373 }, { 374 }, { 375 }, { 376 }, { 377 }, { 378 }, { 379 }, { 380 }, { 381 }, { 382 }, { 383 }, { 384 }, { 385 }, { 386 }, { 387 }, { 388 }, { 389 }, { 390 }, { 391 }, { 392 }, { 393 }, { 394 }, { 395 }, { 396 }, { 397 }, { 398 }, { 399 }, { 400 }, { 401 }, { 402 }, { 403 }, { 404 }, { 405 }, { 406 }, { 407 }, { 408 }, { 409 }, { 410 }, { 411 }, { 412 }, { 413 }, { 414 }, { 415 }, { 416 }, { 417 }, { 418 }, { 419 }, { 420 }, { 421 }, { 422 }, { 423 }, { 424 }, { 425 }, { 430 }, { 431 }, { 432 }, { 433 }, { 434 }, { 435 }, { 436 }, { 437 }, { 442 }, { 443 }, { 444 }, { 445 }, { 446 }, { 447 }, { 448 }, { 449 }, { 450 }, { 451 }, { 457 }, { 458 }, { 459 }, { 460 }, { 461 }, { 462 }, { 463 }, { 469 }, { 470 }, { 471 }, { 472 }, { 473 }]])\n").runs();
    }

    @Ignore
    @Test
    public void testExplainJoinOrderingWithOr() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query((String)JdbcTest.FOODMART_QUERIES.get((int)47).left).explainContains("xxx");
    }

    @Test
    public void testNullableTimestamp() {
        this.checkNullableTimestamp(CalciteAssert.Config.FOODMART_CLONE);
    }

    @Test
    public void testNullableTimestamp2() {
        this.checkNullableTimestamp(CalciteAssert.Config.JDBC_FOODMART);
    }

    private void checkNullableTimestamp(CalciteAssert.Config config) {
        CalciteAssert.that().with(config).query("select \"hire_date\", \"end_date\", \"birth_date\" from \"foodmart\".\"employee\" where \"employee_id\" = 1").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.MYSQL).returns2("hire_date=1994-12-01; end_date=null; birth_date=1961-08-26\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking() {
        CalciteAssert.hr().query("select upper((case when \"empid\">\"deptno\"*10 then 'y' else null end)) T from \"hr\".\"emps\"").planContains("static final String $L4J$C$org_apache_calcite_runtime_SqlFunctions_upper_y_ = org.apache.calcite.runtime.SqlFunctions.upper(\"y\");").planContains("return current.empid <= current.deptno * 10 ? (String) null : $L4J$C$org_apache_calcite_runtime_SqlFunctions_upper_y_;").returns("T=null\nT=null\nT=Y\nT=Y\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking2() {
        CalciteAssert.hr().query("select upper((case when \"empid\">\"deptno\"*10 then \"name\" end)) T from \"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("return current.empid <= current.deptno * 10 || inp2_ == null ? (String) null : org.apache.calcite.runtime.SqlFunctions.upper(inp2_);").returns("T=null\nT=null\nT=SEBASTIAN\nT=THEODORE\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking3() {
        CalciteAssert.hr().query("select substring(\"name\", \"deptno\"+case when user <> 'sa' then 1 end) from \"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("static final boolean $L4J$C$org_apache_calcite_runtime_SqlFunctions_ne_sa_sa_ = org.apache.calcite.runtime.SqlFunctions.ne(\"sa\", \"sa\");").planContains("static final boolean $L4J$C$_org_apache_calcite_runtime_SqlFunctions_ne_sa_sa_ = !$L4J$C$org_apache_calcite_runtime_SqlFunctions_ne_sa_sa_;").planContains("return inp2_ == null || $L4J$C$_org_apache_calcite_runtime_SqlFunctions_ne_sa_sa_ ? (String) null : org.apache.calcite.runtime.SqlFunctions.substring(inp2_, current.deptno + 1);");
    }

    @Test
    public void testReuseExpressionWhenNullChecking4() {
        CalciteAssert.hr().query("select substring(trim(\nsubstring(\"name\",\n  \"deptno\"*0+case when user = 'sa' then 1 end)\n), case when \"empid\">\"deptno\" then 4\n   else\n     case when \"deptno\"*8>8 then 5 end\n   end-2) T\nfrom\n\"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("final int inp1_ = current.deptno;").planContains("static final boolean $L4J$C$org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_ = org.apache.calcite.runtime.SqlFunctions.eq(\"sa\", \"sa\");").planContains("static final boolean $L4J$C$_org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_ = !$L4J$C$org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_;").planContains("return inp2_ == null || $L4J$C$_org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_ || !v5 && inp1_ * 8 <= 8 ? (String) null : org.apache.calcite.runtime.SqlFunctions.substring(org.apache.calcite.runtime.SqlFunctions.trim(true, true, \" \", org.apache.calcite.runtime.SqlFunctions.substring(inp2_, inp1_ * 0 + 1), true), (v5 ? 4 : 5) - 2);").returns("T=ill\nT=ric\nT=ebastian\nT=heodore\n");
    }

    @Test
    public void testReuseExpressionWhenNullChecking5() {
        CalciteAssert.hr().query("select substring(trim(\nsubstring(\"name\",\n  \"deptno\"*0+case when user = 'sa' then 1 end)\n), case when \"empid\">\"deptno\" then 5\n   else\n     case when \"deptno\"*8>8 then 5 end\n   end-2) T\nfrom\n\"hr\".\"emps\"").planContains("final String inp2_ = current.name;").planContains("final int inp1_ = current.deptno;").planContains("static final int $L4J$C$5_2 = 5 - 2;").planContains("static final boolean $L4J$C$org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_ = org.apache.calcite.runtime.SqlFunctions.eq(\"sa\", \"sa\");").planContains("static final boolean $L4J$C$_org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_ = !$L4J$C$org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_;").planContains("return inp2_ == null || $L4J$C$_org_apache_calcite_runtime_SqlFunctions_eq_sa_sa_ || current.empid <= inp1_ && inp1_ * 8 <= 8 ? (String) null : org.apache.calcite.runtime.SqlFunctions.substring(org.apache.calcite.runtime.SqlFunctions.trim(true, true, \" \", org.apache.calcite.runtime.SqlFunctions.substring(inp2_, inp1_ * 0 + 1), true), $L4J$C$5_2);").returns("T=ll\nT=ic\nT=bastian\nT=eodore\n");
    }

    @Test
    public void testValues() {
        CalciteAssert.that().query("values (1), (2)").returns("EXPR$0=1\nEXPR$0=2\n");
    }

    @Test
    public void testValuesAlias() {
        CalciteAssert.that().query("select \"desc\" from (VALUES ROW(1, 'SameName')) AS \"t\" (\"id\", \"desc\")").returns("desc=SameName\n");
    }

    @Test
    public void testValuesMinus() {
        CalciteAssert.that().query("values (-2-1)").returns("EXPR$0=-3\n");
    }

    @Test
    public void testSelectWithoutFrom() {
        CalciteAssert.that().query("select 2+2").returns("EXPR$0=4\n");
    }

    @Test
    public void testValuesComposite() {
        CalciteAssert.that().query("values (1, 'a'), (2, 'abc')").returns("EXPR$0=1; EXPR$1=a  \nEXPR$0=2; EXPR$1=abc\n");
    }

    @Test
    public void testValuesCompositeRenamed() {
        CalciteAssert.that().query("select EXPR$0 q, EXPR$1 w from (values (1, 'a'), (2, 'abc'))").explainContains("PLAN=EnumerableValues(tuples=[[{ 1, 'a  ' }, { 2, 'abc' }]])\n").returns("Q=1; W=a  \nQ=2; W=abc\n");
    }

    @Test
    public void testValuesCompositeRenamedSameNames() {
        CalciteAssert.that().query("select EXPR$0 q, EXPR$1 q from (values (1, 'a'), (2, 'abc'))").explainContains("PLAN=EnumerableValues(tuples=[[{ 1, 'a  ' }, { 2, 'abc' }]])\n").returnsUnordered("Q=1; Q=a  ", "Q=2; Q=abc");
    }

    @Test
    public void testUnionWithSameColumnNames() {
        CalciteAssert.hr().query("select \"deptno\", \"deptno\" from \"hr\".\"depts\" union select \"deptno\", \"empid\" from \"hr\".\"emps\"").explainContains("PLAN=EnumerableUnion(all=[false])\n  EnumerableCalc(expr#0..3=[{inputs}], deptno=[$t0], deptno0=[$t0])\n    EnumerableTableScan(table=[[hr, depts]])\n  EnumerableCalc(expr#0..4=[{inputs}], deptno=[$t1], empid=[$t0])\n    EnumerableTableScan(table=[[hr, emps]])\n").returnsUnordered("deptno=10; deptno=110", "deptno=10; deptno=10", "deptno=20; deptno=200", "deptno=10; deptno=100", "deptno=10; deptno=150", "deptno=30; deptno=30", "deptno=40; deptno=40");
    }

    @Test
    public void testInnerJoinValues() {
        CalciteAssert.that().with(CalciteAssert.Config.LINGUAL).query("select empno, desc from sales.emps,\n  (SELECT * FROM (VALUES (10, 'SameName')) AS t (id, desc)) as sn\nwhere emps.deptno = sn.id and sn.desc = 'SameName' group by empno, desc").explainContains("EnumerableCalc(expr#0..1=[{inputs}], EMPNO=[$t1], DESC=[$t0])\n  EnumerableAggregate(group=[{1, 2}])\n    EnumerableCalc(expr#0..3=[{inputs}], expr#4=[CAST($t3):INTEGER NOT NULL], expr#5=[=($t4, $t0)], expr#6=['SameName'], expr#7=[=($t1, $t6)], expr#8=[AND($t5, $t7)], proj#0..3=[{exprs}], $condition=[$t8])\n      EnumerableJoin(condition=[true], joinType=[inner])\n        EnumerableValues(tuples=[[{ 10, 'SameName' }]])\n        EnumerableTableScan(table=[[SALES, EMPS]])\n").returns("EMPNO=1; DESC=SameName\n");
    }

    @Test
    public void testMergeJoin() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select \"emps\".\"empid\",\n \"depts\".\"deptno\", \"depts\".\"name\"\nfrom \"hr\".\"emps\"\n join \"hr\".\"depts\" using (\"deptno\")").explainContains("EnumerableCalc(expr#0..3=[{inputs}], empid=[$t2], deptno=[$t0], name=[$t1])\n  EnumerableJoin(condition=[=($0, $3)], joinType=[inner])\n    EnumerableCalc(expr#0..3=[{inputs}], proj#0..1=[{exprs}])\n      EnumerableTableScan(table=[[hr, depts]])\n    EnumerableCalc(expr#0..4=[{inputs}], proj#0..1=[{exprs}])\n      EnumerableTableScan(table=[[hr, emps]])").returns("empid=100; deptno=10; name=Sales\nempid=150; deptno=10; name=Sales\nempid=110; deptno=10; name=Sales\n");
    }

    @Test
    public void testCartesianJoin() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\", \"hr\".\"depts\" where \"emps\".\"empid\" < 140 and \"depts\".\"deptno\" > 20").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; deptno0=30; name0=Marketing; employees=[]; location={0, 52}", "empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; deptno0=40; name0=HR; employees=[{200, 20, Eric, 8000.0, 500}]; location=null", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; deptno0=30; name0=Marketing; employees=[]; location={0, 52}", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; deptno0=40; name0=HR; employees=[{200, 20, Eric, 8000.0, 500}]; location=null");
    }

    @Test
    public void testDistinctCountSimple() {
        String s = "select count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"";
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"").explainContains("EnumerableAggregate(group=[{}], m0=[COUNT($0)])\n  EnumerableAggregate(group=[{7}])\n    EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])").returns("m0=6\n");
    }

    @Test
    public void testDistinctCount2() {
        String s = "select cast(\"unit_sales\" as integer) as \"u\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"\ngroup by \"unit_sales\"";
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select cast(\"unit_sales\" as integer) as \"u\",\n count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"\ngroup by \"unit_sales\"").explainContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[CAST($t0):INTEGER NOT NULL], u=[$t2], m0=[$t1])\n  EnumerableAggregate(group=[{1}], m0=[COUNT($0)])\n    EnumerableAggregate(group=[{2, 7}])\n      EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])").returnsUnordered("u=1; m0=523", "u=5; m0=1059", "u=4; m0=4459", "u=6; m0=19", "u=3; m0=4895", "u=2; m0=4735");
    }

    @Test
    public void testDistinctCount() {
        String s = "select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"";
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.ORACLE).explainContains("EnumerableAggregate(group=[{0}], m0=[COUNT($1)])\n  EnumerableAggregate(group=[{1, 3}])\n    EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n      EnumerableCalc(expr#0..9=[{inputs}], expr#10=[CAST($t4):INTEGER], expr#11=[1997], expr#12=[=($t10, $t11)], time_id=[$t0], the_year=[$t4], $condition=[$t12])\n        EnumerableTableScan(table=[[foodmart2, time_by_day]])\n      EnumerableCalc(expr#0..7=[{inputs}], time_id=[$t1], unit_sales=[$t7])\n        EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])").returns("c0=1997; m0=6\n");
    }

    @Test
    public void testDistinctCountComposite() {
        String s = "select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"product_id\",\n       \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"";
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\",\n count(distinct \"sales_fact_1997\".\"product_id\",\n       \"sales_fact_1997\".\"customer_id\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_year\"").returns("c0=1997; m0=85452\n");
    }

    @Test
    public void testAggregateFilter() {
        String s = "select \"the_month\",\n count(*) as \"c\",\n count(*) filter (where \"day_of_month\" > 20) as \"c2\"\nfrom \"time_by_day\" as \"time_by_day\"\nwhere \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_month\"\norder by \"time_by_day\".\"the_month\"";
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"the_month\",\n count(*) as \"c\",\n count(*) filter (where \"day_of_month\" > 20) as \"c2\"\nfrom \"time_by_day\" as \"time_by_day\"\nwhere \"time_by_day\".\"the_year\" = 1997\ngroup by \"time_by_day\".\"the_month\"\norder by \"time_by_day\".\"the_month\"").returns("the_month=April; c=30; c2=10\nthe_month=August; c=31; c2=11\nthe_month=December; c=31; c2=11\nthe_month=February; c=28; c2=8\nthe_month=January; c=31; c2=11\nthe_month=July; c=31; c2=11\nthe_month=June; c=30; c2=10\nthe_month=March; c=31; c2=11\nthe_month=May; c=31; c2=11\nthe_month=November; c=30; c2=10\nthe_month=October; c=31; c2=11\nthe_month=September; c=30; c2=10\n");
    }

    @Test
    public void testSimpleIn() {
        CalciteAssert.hr().query("select * from \"hr\".\"depts\" where \"deptno\" in (\n  select \"deptno\" from \"hr\".\"emps\"\n  where \"empid\" < 150)").convertContains("LogicalProject(deptno=[$0], name=[$1], employees=[$2], location=[$3])\n  LogicalFilter(condition=[IN($0, {\nLogicalProject(deptno=[$1])\n  LogicalFilter(condition=[<($0, 150)])\n    EnumerableTableScan(table=[[hr, emps]])\n})])\n    EnumerableTableScan(table=[[hr, depts]])").explainContains("EnumerableSemiJoin(condition=[=($0, $5)], joinType=[inner])\n  EnumerableTableScan(table=[[hr, depts]])\n  EnumerableCalc(expr#0..4=[{inputs}], expr#5=[150], expr#6=[<($t0, $t5)], proj#0..4=[{exprs}], $condition=[$t6])\n    EnumerableTableScan(table=[[hr, emps]])").returnsUnordered("deptno=10; name=Sales; employees=[{100, 10, Bill, 10000.0, 1000}, {150, 10, Sebastian, 7000.0, null}]; location={-122, 38}");
    }

    @Ignore
    @Test
    public void testIn() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"time_by_day\".\"the_year\" as \"c0\",\n \"product_class\".\"product_family\" as \"c1\",\n \"customer\".\"country\" as \"c2\",\n \"customer\".\"state_province\" as \"c3\",\n \"customer\".\"city\" as \"c4\",\n sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"time_by_day\",\n \"sales_fact_1997\" as \"sales_fact_1997\",\n \"product_class\" as \"product_class\",\n \"product\" as \"product\", \"customer\" as \"customer\"\nwhere \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\"\nand \"time_by_day\".\"the_year\" = 1997\nand \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nand \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nand \"product_class\".\"product_family\" = 'Drink'\nand \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nand \"customer\".\"country\" = 'USA'\nand \"customer\".\"state_province\" = 'WA'\nand \"customer\".\"city\" in ('Anacortes', 'Ballard', 'Bellingham', 'Bremerton', 'Burien', 'Edmonds', 'Everett', 'Issaquah', 'Kirkland', 'Lynnwood', 'Marysville', 'Olympia', 'Port Orchard', 'Puyallup', 'Redmond', 'Renton', 'Seattle', 'Sedro Woolley', 'Spokane', 'Tacoma', 'Walla Walla', 'Yakima')\ngroup by \"time_by_day\".\"the_year\",\n \"product_class\".\"product_family\",\n \"customer\".\"country\",\n \"customer\".\"state_province\",\n \"customer\".\"city\"").returns("c0=1997; c1=Drink; c2=USA; c3=WA; c4=Sedro Woolley; m0=58.0000\n");
    }

    @Test
    public void testSql92JoinParenthesized() {
    }

    @Test
    public void testOrderBy() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2").returns("store_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\nstore_id=0; grocery_sqft=null\n");
    }

    @Test
    public void testOrderByDesc() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 desc").returns("store_id=0; grocery_sqft=null\nstore_id=2; grocery_sqft=22271\nstore_id=1; grocery_sqft=17475\n");
    }

    @Test
    public void testOrderByExpr() {
        CalciteAssert.hr().query("select \"name\", \"empid\" from \"hr\".\"emps\"\norder by - \"empid\"").returns("name=Eric; empid=200\nname=Sebastian; empid=150\nname=Theodore; empid=110\nname=Bill; empid=100\n");
    }

    @Test
    public void testOrderStarByExpr() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\"\norder by - \"empid\"").explainContains("EnumerableSort(sort0=[$5], dir0=[ASC])\n  EnumerableCalc(expr#0..4=[{inputs}], expr#5=[-($t0)], proj#0..5=[{exprs}])\n    EnumerableTableScan(table=[[hr, emps]])").returns("empid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testOrderUnionStarByExpr() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\" where \"empid\" < 150\nunion all\nselect * from \"hr\".\"emps\" where \"empid\" > 150\norder by - \"empid\"").returns("empid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testOrderByCast() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"customer_id\", \"postal_code\" from \"customer\"\nwhere \"customer_id\" < 5\norder by cast(substring(\"postal_code\" from 3) as integer) desc").returns("customer_id=3; postal_code=73980\ncustomer_id=4; postal_code=74674\ncustomer_id=2; postal_code=17172\ncustomer_id=1; postal_code=15057\n");
    }

    @Test
    public void testOrderByNulls() {
        this.checkOrderByNulls(CalciteAssert.Config.FOODMART_CLONE);
        this.checkOrderByNulls(CalciteAssert.Config.JDBC_FOODMART);
    }

    private void checkOrderByNulls(CalciteAssert.Config clone) {
        this.checkOrderByDescNullsFirst(clone);
        this.checkOrderByNullsFirst(clone);
        this.checkOrderByDescNullsLast(clone);
        this.checkOrderByNullsLast(clone);
    }

    private void checkOrderByDescNullsFirst(CalciteAssert.Config config) {
        CalciteAssert.that().with(config).query("select \"store_id\", \"grocery_sqft\"\nfrom \"foodmart\".\"store\"\nwhere \"store_id\" < 3 order by 2 desc nulls first").returns("store_id=0; grocery_sqft=null\nstore_id=2; grocery_sqft=22271\nstore_id=1; grocery_sqft=17475\n");
    }

    private void checkOrderByNullsFirst(CalciteAssert.Config config) {
        CalciteAssert.that().with(config).query("select \"store_id\", \"grocery_sqft\"\nfrom \"foodmart\".\"store\"\nwhere \"store_id\" < 3 order by 2 nulls first").returns("store_id=0; grocery_sqft=null\nstore_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\n");
    }

    private void checkOrderByDescNullsLast(CalciteAssert.Config config) {
        CalciteAssert.that().with(config).query("select \"store_id\", \"grocery_sqft\"\nfrom \"foodmart\".\"store\"\nwhere \"store_id\" < 3 order by 2 desc nulls last").returns("store_id=2; grocery_sqft=22271\nstore_id=1; grocery_sqft=17475\nstore_id=0; grocery_sqft=null\n");
    }

    private void checkOrderByNullsLast(CalciteAssert.Config config) {
        CalciteAssert.that().with(config).query("select \"store_id\", \"grocery_sqft\"\nfrom \"foodmart\".\"store\"\nwhere \"store_id\" < 3 order by 2 nulls last").returns("store_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\nstore_id=0; grocery_sqft=null\n");
    }

    @Test
    public void testOrderByVarious() {
        boolean[] booleans = new boolean[]{false, true};
        for (NullCollation nullCollation : NullCollation.values()) {
            for (boolean asc : booleans) {
                this.checkOrderBy(asc, nullCollation);
            }
        }
    }

    public void checkOrderBy(boolean desc, NullCollation nullCollation) {
        Consumer<ResultSet> checker = resultSet -> {
            String msg = (desc ? "DESC" : "ASC") + ":" + nullCollation;
            ArrayList<Number> numbers = new ArrayList<Number>();
            try {
                while (resultSet.next()) {
                    numbers.add((Number)resultSet.getObject(2));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            Assert.assertThat((String)msg, (Object)numbers.size(), (Matcher)CoreMatchers.is((Object)3));
            Assert.assertThat((String)msg, numbers.get(nullCollation.last(desc) ? 2 : 0), (Matcher)CoreMatchers.nullValue());
        };
        CalciteAssert.AssertThat with = CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).with((ConnectionProperty)CalciteConnectionProperty.DEFAULT_NULL_COLLATION, (Object)nullCollation);
        String sql = "select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 " + (desc ? " DESC" : "");
        String sql1 = "select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by \"florist\", 2 " + (desc ? " DESC" : "");
        String sql2 = "select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 3 order by 2 " + (desc ? " DESC" : "") + ", 1";
        with.query(sql).returns(checker);
        with.query(sql1).returns(checker);
        with.query(sql2).returns(checker);
    }

    @Test
    public void testOrderByFetch() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 10\norder by 1 fetch first 5 rows only").explainContains("PLAN=EnumerableCalc(expr#0..23=[{inputs}], store_id=[$t0], grocery_sqft=[$t16])\n  EnumerableLimit(fetch=[5])\n    EnumerableCalc(expr#0..23=[{inputs}], expr#24=[10], expr#25=[<($t0, $t24)], proj#0..23=[{exprs}], $condition=[$t25])\n      EnumerableTableScan(table=[[foodmart2, store]])\n").returns("store_id=0; grocery_sqft=null\nstore_id=1; grocery_sqft=17475\nstore_id=2; grocery_sqft=22271\nstore_id=3; grocery_sqft=24390\nstore_id=4; grocery_sqft=16844\n");
    }

    @Test
    public void testOrderByOffsetFetch() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"store_id\", \"grocery_sqft\" from \"store\"\nwhere \"store_id\" < 10\norder by 1 offset 2 rows fetch next 5 rows only").returns("store_id=2; grocery_sqft=22271\nstore_id=3; grocery_sqft=24390\nstore_id=4; grocery_sqft=16844\nstore_id=5; grocery_sqft=15012\nstore_id=6; grocery_sqft=15337\n");
    }

    @Test
    public void testFetch() {
        CalciteAssert.hr().query("select \"empid\" from \"hr\".\"emps\"\nfetch first 2 rows only").returns("empid=100\nempid=200\n");
    }

    @Test
    public void testFetchStar() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\"\nfetch first 2 rows only").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=200; deptno=20; name=Eric; salary=8000.0; commission=500\n");
    }

    @Test
    public void testLimitZero() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\"\nlimit 0").returns("").planContains("return org.apache.calcite.linq4j.Linq4j.asEnumerable(new Object[] {})");
    }

    @Test
    public void testLimitStar() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\"\nlimit 2").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=200; deptno=20; name=Eric; salary=8000.0; commission=500\n");
    }

    @Test
    public void testLimitOnQueryableTable() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select * from \"days\"\nlimit 2").returns("day=1; week_day=Sunday\nday=2; week_day=Monday\n");
    }

    @Test
    public void testSelfJoinCount() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select count(*) as c from \"foodmart\".\"store\" as p1 join \"foodmart\".\"store\" as p2 using (\"store_id\")").returns("C=25\n").explainContains("JdbcToEnumerableConverter\n  JdbcAggregate(group=[{}], C=[COUNT()])\n    JdbcJoin(condition=[=($0, $1)], joinType=[inner])\n      JdbcProject(store_id=[$0])\n        JdbcTableScan(table=[[foodmart, store]])\n      JdbcProject(store_id=[$0])\n        JdbcTableScan(table=[[foodmart, store]])\n");
    }

    @Test
    public void testGroupByNull() {
        CalciteAssert.hr().query("select \"deptno\", \"commission\", sum(\"salary\") s\nfrom \"hr\".\"emps\"\ngroup by \"deptno\", \"commission\"").returnsUnordered("deptno=10; commission=null; S=7000.0", "deptno=20; commission=500; S=8000.0", "deptno=10; commission=1000; S=10000.0", "deptno=10; commission=250; S=11500.0");
    }

    @Test
    public void testGroupingSets() {
        CalciteAssert.hr().query("select \"deptno\", count(*) as c, sum(\"salary\") as s\nfrom \"hr\".\"emps\"\ngroup by grouping sets((\"deptno\"), ())").returnsUnordered("deptno=null; C=4; S=36500.0", "deptno=10; C=3; S=28500.0", "deptno=20; C=1; S=8000.0");
    }

    @Test
    public void testRollup() {
        CalciteAssert.hr().query("select \"deptno\", count(*) as c, sum(\"salary\") as s\nfrom \"hr\".\"emps\"\ngroup by rollup(\"deptno\")").returnsUnordered("deptno=null; C=4; S=36500.0", "deptno=10; C=3; S=28500.0", "deptno=20; C=1; S=8000.0");
    }

    @Test
    public void testSelectDistinct() {
        CalciteAssert.hr().query("select distinct \"deptno\"\nfrom \"hr\".\"emps\"\n").returnsUnordered("deptno=10", "deptno=20");
    }

    @Test
    public void testSelectDistinctStar() {
        CalciteAssert.hr().query("select distinct *\nfrom \"hr\".\"emps\"\n").returnsCount(4).planContains(".distinct(");
    }

    @Test
    public void testSelectDistinctComposite() {
        CalciteAssert.hr().query("select distinct \"empid\" > 140 as c, \"deptno\"\nfrom \"hr\".\"emps\"\n").returnsUnordered("C=false; deptno=10", "C=true; deptno=10", "C=true; deptno=20").planContains(".distinct(");
    }

    @Test
    public void testGroupByNoAggregates() {
        CalciteAssert.hr().query("select \"deptno\"\nfrom \"hr\".\"emps\"\ngroup by \"deptno\"").returnsUnordered("deptno=10", "deptno=20");
    }

    @Test
    public void testGroupByNoAggregatesAllColumns() {
        CalciteAssert.hr().query("select \"deptno\"\nfrom \"hr\".\"emps\"\ngroup by \"deptno\", \"empid\", \"name\", \"salary\", \"commission\"").returnsCount(4).planContains(".distinct(");
    }

    @Test
    public void testGroupByMax1IsNull() {
        CalciteAssert.hr().query("select * from (\nselect max(1) max_id\nfrom \"hr\".\"emps\" where 1=2\n) where max_id is null").returnsUnordered("MAX_ID=null");
    }

    @Test
    public void testGroupBy1Max1() {
        CalciteAssert.hr().query("select * from (\nselect max(u) max_id\nfrom (select \"empid\"+\"deptno\" u, 1 cnst\nfrom \"hr\".\"emps\" a) where 1=2\ngroup by cnst\n) where max_id is null").returnsCount(0);
    }

    @Test
    public void testHavingNot() throws IOException {
        this.withFoodMartQuery(6597).runs();
    }

    @Test
    public void testHavingNot2() throws IOException {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select 1\nfrom \"store\"\ngroup by \"store\".\"store_street_address\"\nhaving NOT (sum(\"store\".\"grocery_sqft\") < 20000)").returnsCount(10);
    }

    @Test
    public void testOrderOnSortedTable() throws IOException {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"day\"\nfrom \"days\"\norder by \"day\"").returns("day=1\nday=2\nday=3\nday=4\nday=5\nday=6\nday=7\n");
    }

    @Test
    public void testOrderSorted() throws IOException {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"store_id\"\nfrom \"store\"\norder by \"store_id\" limit 3").returns("store_id=0\nstore_id=1\nstore_id=2\n");
    }

    @Test
    public void testWhereNot() throws IOException {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select 1\nfrom \"store\"\nwhere NOT (\"store\".\"grocery_sqft\" < 22000)\ngroup by \"store\".\"store_street_address\"\n").returnsCount(8);
    }

    @Test
    public void testCountStar() {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            CalciteAssert.hr().query("select count(*) c from \"hr\".\"emps\", \"hr\".\"depts\"").convertContains("LogicalAggregate(group=[{}], C=[COUNT()])\n  LogicalProject(DUMMY=[0])\n    LogicalJoin(condition=[true], joinType=[inner])\n      LogicalProject(DUMMY=[0])\n        EnumerableTableScan(table=[[hr, emps]])\n      LogicalProject(DUMMY=[0])\n        EnumerableTableScan(table=[[hr, depts]])");
        }
    }

    @Test
    public void testCountUnionAll() {
        CalciteAssert.hr().query("select count(*) c from (\nselect * from \"hr\".\"emps\" where 1=2\nunion all\nselect * from \"hr\".\"emps\" where 3=4\n)").returnsUnordered("C=0");
    }

    @Test
    public void testUnionAll() {
        CalciteAssert.hr().query("select \"empid\", \"name\" from \"hr\".\"emps\" where \"deptno\"=10\nunion all\nselect \"empid\", \"name\" from \"hr\".\"emps\" where \"empid\">=150").explainContains("PLAN=EnumerableUnion(all=[true])").returnsUnordered("empid=100; name=Bill", "empid=110; name=Theodore", "empid=150; name=Sebastian", "empid=150; name=Sebastian", "empid=200; name=Eric");
    }

    @Test
    public void testUnion() {
        String sql = "select \"empid\", \"name\" from \"hr\".\"emps\" where \"deptno\"=10\nunion\nselect \"empid\", \"name\" from \"hr\".\"emps\" where \"empid\">=150";
        CalciteAssert.hr().query("select \"empid\", \"name\" from \"hr\".\"emps\" where \"deptno\"=10\nunion\nselect \"empid\", \"name\" from \"hr\".\"emps\" where \"empid\">=150").explainContains("PLAN=EnumerableUnion(all=[false])").returnsUnordered("empid=100; name=Bill", "empid=110; name=Theodore", "empid=150; name=Sebastian", "empid=200; name=Eric");
    }

    @Test
    public void testIntersect() {
        String sql = "select \"empid\", \"name\" from \"hr\".\"emps\" where \"deptno\"=10\nintersect\nselect \"empid\", \"name\" from \"hr\".\"emps\" where \"empid\">=150";
        CalciteAssert.hr().query("select \"empid\", \"name\" from \"hr\".\"emps\" where \"deptno\"=10\nintersect\nselect \"empid\", \"name\" from \"hr\".\"emps\" where \"empid\">=150").withHook(Hook.PLANNER, planner -> planner.removeRule((RelOptRule)IntersectToDistinctRule.INSTANCE)).explainContains("PLAN=EnumerableIntersect(all=[false])").returnsUnordered("empid=150; name=Sebastian");
    }

    @Test
    public void testExcept() {
        String sql = "select \"empid\", \"name\" from \"hr\".\"emps\" where \"deptno\"=10\nexcept\nselect \"empid\", \"name\" from \"hr\".\"emps\" where \"empid\">=150";
        CalciteAssert.hr().query("select \"empid\", \"name\" from \"hr\".\"emps\" where \"deptno\"=10\nexcept\nselect \"empid\", \"name\" from \"hr\".\"emps\" where \"empid\">=150").explainContains("PLAN=EnumerableMinus(all=[false])").returnsUnordered("empid=100; name=Bill", "empid=110; name=Theodore");
    }

    @Test
    public void testAggregateEmpty() {
        CalciteAssert.hr().query("select\n count(*) as cs,\n count(\"deptno\") as c,\n sum(\"deptno\") as s,\n avg(\"deptno\") as a\nfrom \"hr\".\"emps\"\nwhere \"deptno\" < 0").explainContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[0], expr#3=[=($t0, $t2)], expr#4=[null:JavaType(class java.lang.Integer)], expr#5=[CASE($t3, $t4, $t1)], expr#6=[/($t5, $t0)], expr#7=[CAST($t6):JavaType(class java.lang.Integer)], CS=[$t0], C=[$t0], S=[$t5], A=[$t7])\n  EnumerableAggregate(group=[{}], CS=[COUNT()], S=[$SUM0($1)])\n    EnumerableCalc(expr#0..4=[{inputs}], expr#5=[0], expr#6=[<($t1, $t5)], proj#0..4=[{exprs}], $condition=[$t6])\n      EnumerableTableScan(table=[[hr, emps]])\n").returns("CS=0; C=0; S=null; A=null\n");
    }

    @Test
    public void testReduceCountNotNullable() {
        CalciteAssert.hr().query("select\n count(\"deptno\") as cs,\n count(*) as cs2\nfrom \"hr\".\"emps\"\nwhere \"deptno\" < 0").explainContains("PLAN=EnumerableCalc(expr#0=[{inputs}], CS=[$t0], CS2=[$t0])\n  EnumerableAggregate(group=[{}], CS=[COUNT()])\n    EnumerableCalc(expr#0..4=[{inputs}], expr#5=[0], expr#6=[<($t1, $t5)], proj#0..4=[{exprs}], $condition=[$t6])\n      EnumerableTableScan(table=[[hr, emps]])\n").returns("CS=0; CS2=0\n");
    }

    @Test
    public void testReduceCompositeCountNotNullable() {
        CalciteAssert.hr().query("select\n count(\"deptno\", \"commission\", \"commission\" + 1) as cs\nfrom \"hr\".\"emps\"").explainContains("EnumerableAggregate(group=[{}], CS=[COUNT($0, $1)])\n  EnumerableCalc(expr#0..4=[{inputs}], expr#5=[1], expr#6=[+($t4, $t5)], commission=[$t4], $f2=[$t6])\n    EnumerableTableScan(table=[[hr, emps]])").returns("CS=3\n");
    }

    @Test
    public void testOrderByOnSortedTable() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select * from \"time_by_day\"\norder by \"time_id\"").explainContains("PLAN=EnumerableTableScan(table=[[foodmart2, time_by_day]])\n");
    }

    @Test
    public void testOrderByOnSortedTable2() {
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).query("select \"time_id\", \"the_date\" from \"time_by_day\"\nwhere \"time_id\" < 370\norder by \"time_id\"").returns("time_id=367; the_date=1997-01-01 00:00:00\ntime_id=368; the_date=1997-01-02 00:00:00\ntime_id=369; the_date=1997-01-03 00:00:00\n").explainContains("PLAN=EnumerableCalc(expr#0..9=[{inputs}], expr#10=[370], expr#11=[<($t0, $t10)], proj#0..1=[{exprs}], $condition=[$t11])\n  EnumerableTableScan(table=[[foodmart2, time_by_day]])\n\n");
    }

    @Test
    public void testWithInsideWhereExists() {
        CalciteAssert.hr().query("select \"deptno\" from \"hr\".\"emps\"\nwhere exists (\n  with dept2 as (select * from \"hr\".\"depts\" where \"depts\".\"deptno\" >= \"emps\".\"deptno\")\n  select 1 from dept2 where \"deptno\" <= \"emps\".\"deptno\")").returnsUnordered("deptno=10", "deptno=10", "deptno=10");
    }

    @Test
    public void testWithOrderBy() {
        CalciteAssert.hr().query("with emp2 as (select * from \"hr\".\"emps\")\nselect * from emp2\norder by \"deptno\" desc, \"empid\" desc").returns("empid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testWinAgg() {
        CalciteAssert.hr().query("select \"deptno\",\n \"empid\",\nsum(\"salary\" + \"empid\") over w as s,\n 5 as five,\n min(\"salary\") over w as m,\n count(*) over w as c\nfrom \"hr\".\"emps\"\nwindow w as (partition by \"deptno\" order by \"empid\" rows 1 preceding)").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, S REAL, FIVE INTEGER NOT NULL, M REAL, C BIGINT NOT NULL]").explainContains("EnumerableCalc(expr#0..7=[{inputs}], expr#8=[0:BIGINT], expr#9=[>($t4, $t8)], expr#10=[null:JavaType(class java.lang.Float)], expr#11=[CASE($t9, $t5, $t10)], expr#12=[5], deptno=[$t1], empid=[$t0], S=[$t11], FIVE=[$t12], M=[$t6], C=[$t7])\n  EnumerableWindow(window#0=[window(partition {1} order by [0] rows between $4 PRECEDING and CURRENT ROW aggs [COUNT($3), $SUM0($3), MIN($2), COUNT()])])\n    EnumerableCalc(expr#0..4=[{inputs}], expr#5=[+($t3, $t0)], proj#0..1=[{exprs}], salary=[$t3], $3=[$t5])\n      EnumerableTableScan(table=[[hr, emps]])\n").returnsUnordered("deptno=10; empid=100; S=10100.0; FIVE=5; M=10000.0; C=1", "deptno=10; empid=110; S=21710.0; FIVE=5; M=10000.0; C=2", "deptno=10; empid=150; S=18760.0; FIVE=5; M=7000.0; C=2", "deptno=20; empid=200; S=8200.0; FIVE=5; M=8000.0; C=1").planContains(CalcitePrepareImpl.DEBUG ? "_list.add(new Object[] {\n        row[0],\n        row[1],\n        row[2],\n        row[3],\n        COUNTa0w0,\n        $SUM0a1w0,\n        MINa2w0,\n        COUNTa3w0});" : "_list.add(new Object[] {\n        row[0],\n        row[1],\n        row[2],\n        row[3],\n        a0w0,\n        a1w0,\n        a2w0,\n        a3w0});").planContains("return new Object[] {\n                  current[1],\n                  current[0],\n                  org.apache.calcite.runtime.SqlFunctions.toLong(current[4]) > 0L ? Float.valueOf(org.apache.calcite.runtime.SqlFunctions.toFloat(current[5])) : (Float) null,\n                  5,\n                  current[6],\n                  current[7]};\n");
    }

    @Test
    public void testWinAgg2() {
        CalciteAssert.hr().query("select \"deptno\",\n \"empid\",\nsum(\"salary\" + \"empid\") over w as s,\n 5 as five,\n min(\"salary\") over w as m,\n count(*) over w as c,\n count(*) over w2 as c2,\n count(*) over w11 as c11,\n count(*) over w11dept as c11dept\nfrom \"hr\".\"emps\"\nwindow w as (order by \"empid\" rows 1 preceding),\n w2 as (order by \"empid\" rows 2 preceding),\n w11 as (order by \"empid\" rows between 1 preceding and 1 following),\n w11dept as (partition by \"deptno\" order by \"empid\" rows between 1 preceding and 1 following)").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, S REAL, FIVE INTEGER NOT NULL, M REAL, C BIGINT NOT NULL, C2 BIGINT NOT NULL, C11 BIGINT NOT NULL, C11DEPT BIGINT NOT NULL]").planContains("tempList.size()").returnsUnordered("deptno=20; empid=200; S=15350.0; FIVE=5; M=7000.0; C=2; C2=3; C11=2; C11DEPT=1", "deptno=10; empid=100; S=10100.0; FIVE=5; M=10000.0; C=1; C2=1; C11=2; C11DEPT=2", "deptno=10; empid=110; S=21710.0; FIVE=5; M=10000.0; C=2; C2=2; C11=3; C11DEPT=3", "deptno=10; empid=150; S=18760.0; FIVE=5; M=7000.0; C=2; C2=3; C11=3; C11DEPT=2");
    }

    @Test
    public void testWinAggScalarNonNullPhysType() {
        String planLine = "a0s0w0 = org.apache.calcite.runtime.SqlFunctions.lesser(a0s0w0, org.apache.calcite.runtime.SqlFunctions.toFloat(_rows[j]));";
        if (CalcitePrepareImpl.DEBUG) {
            planLine = planLine.replaceAll("a0s0w0", "MINa0s0w0");
        }
        CalciteAssert.hr().query("select min(\"salary\"+1) over w as m\nfrom \"hr\".\"emps\"\nwindow w as (order by \"salary\"+1 rows 1 preceding)\n").typeIs("[M REAL]").planContains(planLine).returnsUnordered("M=7001.0", "M=7001.0", "M=8001.0", "M=10001.0");
    }

    @Test
    public void testWinAggScalarNonNullPhysTypePlusOne() {
        String planLine = "a0s0w0 = org.apache.calcite.runtime.SqlFunctions.lesser(a0s0w0, org.apache.calcite.runtime.SqlFunctions.toFloat(_rows[j]));";
        if (CalcitePrepareImpl.DEBUG) {
            planLine = planLine.replaceAll("a0s0w0", "MINa0s0w0");
        }
        CalciteAssert.hr().query("select 1+min(\"salary\"+1) over w as m\nfrom \"hr\".\"emps\"\nwindow w as (order by \"salary\"+1 rows 1 preceding)\n").typeIs("[M REAL]").planContains(planLine).returnsUnordered("M=7002.0", "M=7002.0", "M=8002.0", "M=10002.0");
    }

    @Test
    public void testWinAggRank() {
        CalciteAssert.hr().query("select  \"deptno\",\n \"empid\",\n \"commission\",\n rank() over (partition by \"deptno\" order by \"commission\" desc nulls first) as rcnf,\n rank() over (partition by \"deptno\" order by \"commission\" desc nulls last) as rcnl,\n rank() over (partition by \"deptno\" order by \"empid\") as r,\n rank() over (partition by \"deptno\" order by \"empid\" desc) as rd\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, RCNF BIGINT NOT NULL, RCNL BIGINT NOT NULL, R BIGINT NOT NULL, RD BIGINT NOT NULL]").returnsUnordered("deptno=10; empid=100; commission=1000; RCNF=2; RCNL=1; R=1; RD=3", "deptno=10; empid=110; commission=250; RCNF=3; RCNL=2; R=2; RD=2", "deptno=10; empid=150; commission=null; RCNF=1; RCNL=3; R=3; RD=1", "deptno=20; empid=200; commission=500; RCNF=1; RCNL=1; R=1; RD=1");
    }

    @Test
    public void testWinAggRankValues() {
        CalciteAssert.hr().query("select  \"deptno\",\n rank() over (order by \"deptno\") as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R BIGINT NOT NULL]").returnsUnordered("deptno=10; R=1", "deptno=10; R=1", "deptno=10; R=1", "deptno=20; R=4");
    }

    @Test
    public void testWinAggRankValuesDesc() {
        CalciteAssert.hr().query("select  \"deptno\",\n rank() over (order by \"deptno\" desc) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R BIGINT NOT NULL]").returnsUnordered("deptno=10; R=2", "deptno=10; R=2", "deptno=10; R=2", "deptno=20; R=1");
    }

    @Test
    public void testWinAggDenseRankValues() {
        CalciteAssert.hr().query("select  \"deptno\",\n dense_rank() over (order by \"deptno\") as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R BIGINT NOT NULL]").returnsUnordered("deptno=10; R=1", "deptno=10; R=1", "deptno=10; R=1", "deptno=20; R=2");
    }

    @Test
    public void testWinAggDenseRankValuesDesc() {
        CalciteAssert.hr().query("select  \"deptno\",\n dense_rank() over (order by \"deptno\" desc) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, R BIGINT NOT NULL]").returnsUnordered("deptno=10; R=2", "deptno=10; R=2", "deptno=10; R=2", "deptno=20; R=1");
    }

    @Test
    public void testWinIntervalFrame() {
        CalciteAssert.hr().query("select  \"deptno\",\n \"empid\",\n \"hire_date\",\n count(*) over (partition by \"deptno\" order by \"hire_date\" range between interval '1' year preceding and interval '1' year following) as r\nfrom (select \"empid\", \"deptno\",\n  DATE '2014-06-12' + \"empid\"*interval '0' day \"hire_date\"\n  from \"hr\".\"emps\")").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, hire_date DATE NOT NULL, R BIGINT NOT NULL]").returnsUnordered("deptno=10; empid=100; hire_date=2014-06-12; R=3", "deptno=10; empid=110; hire_date=2014-06-12; R=3", "deptno=10; empid=150; hire_date=2014-06-12; R=3", "deptno=20; empid=200; hire_date=2014-06-12; R=1");
    }

    private void startOfGroupStep1(String startOfGroup) {
        CalciteAssert.that().query("select t.*\n  from (\n       select  t.*,\n               case when " + startOfGroup + " then 0 else 1 end start_of_group\n         from " + START_OF_GROUP_DATA + ") t\n").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, START_OF_GROUP INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; START_OF_GROUP=1", "RN=2; VAL=0; EXPECTED=1; START_OF_GROUP=0", "RN=3; VAL=1; EXPECTED=2; START_OF_GROUP=1", "RN=4; VAL=0; EXPECTED=3; START_OF_GROUP=1", "RN=5; VAL=0; EXPECTED=3; START_OF_GROUP=0", "RN=6; VAL=0; EXPECTED=3; START_OF_GROUP=0", "RN=7; VAL=1; EXPECTED=4; START_OF_GROUP=1", "RN=8; VAL=1; EXPECTED=4; START_OF_GROUP=0");
    }

    private void startOfGroupStep2(String startOfGroup) {
        CalciteAssert.that().query("select t.*\n       ,sum(start_of_group) over (order by rn rows unbounded preceding) group_id\n  from (\n       select  t.*,\n               case when " + startOfGroup + " then 0 else 1 end start_of_group\n         from " + START_OF_GROUP_DATA + ") t\n").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, START_OF_GROUP INTEGER NOT NULL, GROUP_ID INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; START_OF_GROUP=1; GROUP_ID=1", "RN=2; VAL=0; EXPECTED=1; START_OF_GROUP=0; GROUP_ID=1", "RN=3; VAL=1; EXPECTED=2; START_OF_GROUP=1; GROUP_ID=2", "RN=4; VAL=0; EXPECTED=3; START_OF_GROUP=1; GROUP_ID=3", "RN=5; VAL=0; EXPECTED=3; START_OF_GROUP=0; GROUP_ID=3", "RN=6; VAL=0; EXPECTED=3; START_OF_GROUP=0; GROUP_ID=3", "RN=7; VAL=1; EXPECTED=4; START_OF_GROUP=1; GROUP_ID=4", "RN=8; VAL=1; EXPECTED=4; START_OF_GROUP=0; GROUP_ID=4");
    }

    private void startOfGroupStep3(String startOfGroup) {
        CalciteAssert.that().query("select group_id, min(rn) min_rn, max(rn) max_rn,\n  count(rn) cnt_rn, avg(val) avg_val from (\nselect t.*\n       ,sum(start_of_group) over (order by rn rows unbounded preceding) group_id\n  from (\n       select  t.*,\n               case when " + startOfGroup + " then 0 else 1 end start_of_group\n         from " + START_OF_GROUP_DATA + ") t\n) group by group_id\n").typeIs("[GROUP_ID INTEGER NOT NULL, MIN_RN INTEGER NOT NULL, MAX_RN INTEGER NOT NULL, CNT_RN BIGINT NOT NULL, AVG_VAL INTEGER NOT NULL]").returnsUnordered("GROUP_ID=1; MIN_RN=1; MAX_RN=2; CNT_RN=2; AVG_VAL=0", "GROUP_ID=2; MIN_RN=3; MAX_RN=3; CNT_RN=1; AVG_VAL=1", "GROUP_ID=3; MIN_RN=4; MAX_RN=6; CNT_RN=3; AVG_VAL=0", "GROUP_ID=4; MIN_RN=7; MAX_RN=8; CNT_RN=2; AVG_VAL=1");
    }

    @Test
    public void testStartOfGroupLastValueStep1() {
        this.startOfGroupStep1("val = last_value(val) over (order by rn rows between 1 preceding and 1 preceding)");
    }

    @Test
    public void testStartOfGroupLastValueStep2() {
        this.startOfGroupStep2("val = last_value(val) over (order by rn rows between 1 preceding and 1 preceding)");
    }

    @Test
    public void testStartOfGroupLastValueStep3() {
        this.startOfGroupStep3("val = last_value(val) over (order by rn rows between 1 preceding and 1 preceding)");
    }

    @Test
    public void testStartOfGroupLagStep1() {
        this.startOfGroupStep1("val = lag(val) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLagValueStep2() {
        this.startOfGroupStep2("val = lag(val) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLagStep3() {
        this.startOfGroupStep3("val = lag(val) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLeadStep1() {
        this.startOfGroupStep1("val = lead(val, -1) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLeadValueStep2() {
        this.startOfGroupStep2("val = lead(val, -1) over (order by rn)");
    }

    @Test
    public void testStartOfGroupLeadStep3() {
        this.startOfGroupStep3("val = lead(val, -1) over (order by rn)");
    }

    @Test
    public void testLagDefaultValue() {
        CalciteAssert.that().query("select t.*, lag(rn+expected,1,42) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; L=42", "RN=2; VAL=0; EXPECTED=1; L=2", "RN=3; VAL=1; EXPECTED=2; L=3", "RN=4; VAL=0; EXPECTED=3; L=5", "RN=5; VAL=0; EXPECTED=3; L=7", "RN=6; VAL=0; EXPECTED=3; L=8", "RN=7; VAL=1; EXPECTED=4; L=9", "RN=8; VAL=1; EXPECTED=4; L=11");
    }

    @Test
    public void testLeadDefaultValue() {
        CalciteAssert.that().query("select t.*, lead(rn+expected,1,42) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; L=3", "RN=2; VAL=0; EXPECTED=1; L=5", "RN=3; VAL=1; EXPECTED=2; L=7", "RN=4; VAL=0; EXPECTED=3; L=8", "RN=5; VAL=0; EXPECTED=3; L=9", "RN=6; VAL=0; EXPECTED=3; L=11", "RN=7; VAL=1; EXPECTED=4; L=12", "RN=8; VAL=1; EXPECTED=4; L=42");
    }

    @Test
    public void testLagExpressionOffset() {
        CalciteAssert.that().query("select t.*, lag(rn, expected, 42) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; VAL=0; EXPECTED=1; L=42", "RN=2; VAL=0; EXPECTED=1; L=1", "RN=3; VAL=1; EXPECTED=2; L=1", "RN=4; VAL=0; EXPECTED=3; L=1", "RN=5; VAL=0; EXPECTED=3; L=2", "RN=6; VAL=0; EXPECTED=3; L=3", "RN=7; VAL=1; EXPECTED=4; L=3", "RN=8; VAL=1; EXPECTED=4; L=4");
    }

    @Test
    public void testLagInvalidOffsetArgument() {
        CalciteAssert.that().query("select t.*,\n  lag(rn, DATE '2014-06-20', 42) over (order by rn) l\nfrom (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").throws_("Cannot apply 'LAG' to arguments of type 'LAG(<INTEGER>, <DATE>, <INTEGER>)'");
    }

    @Test
    public void testNtile1() {
        CalciteAssert.that().query("select rn, ntile(1) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, L BIGINT NOT NULL]").returnsUnordered("RN=1; L=1", "RN=2; L=1", "RN=3; L=1", "RN=4; L=1", "RN=5; L=1", "RN=6; L=1", "RN=7; L=1", "RN=8; L=1");
    }

    @Test
    public void testNtile2() {
        CalciteAssert.that().query("select rn, ntile(2) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, L BIGINT NOT NULL]").returnsUnordered("RN=1; L=1", "RN=2; L=1", "RN=3; L=1", "RN=4; L=1", "RN=5; L=2", "RN=6; L=2", "RN=7; L=2", "RN=8; L=2");
    }

    @Ignore(value="Have no idea how to validate that expression is constant")
    @Test
    public void testNtileConstantArgs() {
        CalciteAssert.that().query("select rn, ntile(1+1) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").typeIs("[RN INTEGER NOT NULL, VAL INTEGER NOT NULL, EXPECTED INTEGER NOT NULL, L INTEGER NOT NULL]").returnsUnordered("RN=1; L=1", "RN=2; L=1", "RN=3; L=1", "RN=4; L=1", "RN=5; L=2", "RN=6; L=2", "RN=7; L=2", "RN=8; L=2");
    }

    @Test
    public void testNtileNegativeArg() {
        CalciteAssert.that().query("select rn, ntile(-1) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").throws_("Argument to function 'NTILE' must be a positive integer literal");
    }

    @Test
    public void testNtileDecimalArg() {
        CalciteAssert.that().query("select rn, ntile(3.141592653) over (order by rn) l\n from (values(1,0,1),\n(2,0,1),\n(3,1,2),\n(4,0,3),\n(5,0,3),\n(6,0,3),\n(7,1,4),\n(8,1,4))\n as t(rn,val,expected)").throws_("Cannot apply 'NTILE' to arguments of type 'NTILE(<DECIMAL(10, 9)>)'");
    }

    @Test
    public void testWinAggFirstValue() {
        CalciteAssert.hr().query("select  \"deptno\",\n \"empid\",\n \"commission\",\n first_value(\"commission\") over (partition by \"deptno\" order by \"empid\") as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, R INTEGER]").returnsUnordered("deptno=10; empid=100; commission=1000; R=1000", "deptno=10; empid=110; commission=250; R=1000", "deptno=10; empid=150; commission=null; R=1000", "deptno=20; empid=200; commission=500; R=500");
    }

    @Test
    public void testWinAggFirstValueDesc() {
        CalciteAssert.hr().query("select  \"deptno\",\n \"empid\",\n \"commission\",\n first_value(\"commission\") over (partition by \"deptno\" order by \"empid\" desc) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, R INTEGER]").returnsUnordered("deptno=10; empid=100; commission=1000; R=null", "deptno=10; empid=110; commission=250; R=null", "deptno=10; empid=150; commission=null; R=null", "deptno=20; empid=200; commission=500; R=500");
    }

    @Test
    public void testWinAggFirstValueEmptyWindow() {
        CalciteAssert.hr().query("select \"deptno\",\n \"empid\",\n \"commission\",\n first_value(\"commission\") over (partition by \"deptno\" order by \"empid\" desc range between 1000 preceding and 999 preceding) as r\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, R INTEGER]").returnsUnordered("deptno=10; empid=100; commission=1000; R=null", "deptno=10; empid=110; commission=250; R=null", "deptno=10; empid=150; commission=null; R=null", "deptno=20; empid=200; commission=500; R=null");
    }

    @Test
    public void testWinRowNumber() {
        CalciteAssert.hr().query("select \"deptno\",\n \"empid\",\n \"commission\",\n row_number() over (partition by \"deptno\") as r,\n row_number() over (partition by \"deptno\" order by \"commission\" desc nulls first) as rcnf,\n row_number() over (partition by \"deptno\" order by \"commission\" desc nulls last) as rcnl,\n row_number() over (partition by \"deptno\" order by \"empid\") as r,\n row_number() over (partition by \"deptno\" order by \"empid\" desc) as rd\nfrom \"hr\".\"emps\"").typeIs("[deptno INTEGER NOT NULL, empid INTEGER NOT NULL, commission INTEGER, R BIGINT NOT NULL, RCNF BIGINT NOT NULL, RCNL BIGINT NOT NULL, R BIGINT NOT NULL, RD BIGINT NOT NULL]").returnsUnordered("deptno=10; empid=100; commission=1000; R=1; RCNF=2; RCNL=1; R=1; RD=3", "deptno=10; empid=110; commission=250; R=3; RCNF=3; RCNL=2; R=2; RD=2", "deptno=10; empid=150; commission=null; R=2; RCNF=1; RCNL=3; R=3; RD=1", "deptno=20; empid=200; commission=500; R=1; RCNF=1; RCNL=1; R=1; RD=1");
    }

    @Test
    public void testOverUnboundedPreceding() {
        CalciteAssert.hr().query("select \"empid\",\n  \"commission\",\n  count(\"empid\") over (partition by 42\n    order by \"commission\" nulls first\n    rows between UNBOUNDED PRECEDING and current row) as m\nfrom \"hr\".\"emps\"").typeIs("[empid INTEGER NOT NULL, commission INTEGER, M BIGINT NOT NULL]").returnsUnordered("empid=100; commission=1000; M=4", "empid=200; commission=500; M=3", "empid=150; commission=null; M=1", "empid=110; commission=250; M=2");
    }

    @Test
    public void testSumOverUnboundedPreceding() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select \"empid\",\n  \"commission\",\n  sum(\"empid\") over (partition by 42\n    order by \"commission\" nulls first\n    rows between UNBOUNDED PRECEDING and current row) as m\nfrom \"hr\".\"emps\"").typeIs("[empid INTEGER NOT NULL, commission INTEGER, M INTEGER NOT NULL]").returnsUnordered("empid=100; commission=1000; M=560", "empid=110; commission=250; M=260", "empid=150; commission=null; M=150", "empid=200; commission=500; M=460");
    }

    @Test
    public void testSumOverPossiblyEmptyWindow() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select \"empid\",\n  \"commission\",\n  sum(\"empid\") over (partition by 42\n    order by \"commission\" nulls first\n    rows between UNBOUNDED PRECEDING and 1 preceding) as m\nfrom \"hr\".\"emps\"").typeIs("[empid INTEGER NOT NULL, commission INTEGER, M INTEGER]").returnsUnordered("empid=100; commission=1000; M=460", "empid=110; commission=250; M=150", "empid=150; commission=null; M=null", "empid=200; commission=500; M=260");
    }

    @Test
    public void testOverNoOrder() {
        String sql = "select *,\n count(*) over (partition by deptno) as m1,\n count(*) over (partition by deptno order by ename) as m2,\n count(*) over () as m3\nfrom emp";
        this.withEmpDept("select *,\n count(*) over (partition by deptno) as m1,\n count(*) over (partition by deptno order by ename) as m2,\n count(*) over () as m3\nfrom emp").returnsUnordered("ENAME=Adam ; DEPTNO=50; GENDER=M; M1=2; M2=1; M3=9", "ENAME=Alice; DEPTNO=30; GENDER=F; M1=2; M2=1; M3=9", "ENAME=Bob  ; DEPTNO=10; GENDER=M; M1=2; M2=1; M3=9", "ENAME=Eric ; DEPTNO=20; GENDER=M; M1=1; M2=1; M3=9", "ENAME=Eve  ; DEPTNO=50; GENDER=F; M1=2; M2=2; M3=9", "ENAME=Grace; DEPTNO=60; GENDER=F; M1=1; M2=1; M3=9", "ENAME=Jane ; DEPTNO=10; GENDER=F; M1=2; M2=2; M3=9", "ENAME=Susan; DEPTNO=30; GENDER=F; M1=2; M2=2; M3=9", "ENAME=Wilma; DEPTNO=null; GENDER=F; M1=1; M2=1; M3=9");
    }

    @Test
    public void testTrimFields() throws Exception {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            CalciteAssert.hr().query("select \"name\", count(\"commission\") + 1\nfrom \"hr\".\"emps\"\ngroup by \"deptno\", \"name\"").convertContains("LogicalProject(name=[$1], EXPR$1=[+($2, 1)])\n  LogicalAggregate(group=[{0, 1}], agg#0=[COUNT($2)])\n    LogicalProject(deptno=[$1], name=[$2], commission=[$4])\n      EnumerableTableScan(table=[[hr, emps]])\n");
        }
    }

    @Test
    public void testTrimFieldsOver() throws Exception {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            CalciteAssert.hr().query("select \"name\",\n  count(\"commission\") over (partition by \"deptno\") + 1\nfrom \"hr\".\"emps\"\nwhere \"empid\" > 10").convertContains("LogicalProject(name=[$2], EXPR$1=[+(COUNT($3) OVER (PARTITION BY $1 RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING), 1)])\n  LogicalFilter(condition=[>($0, 10)])\n    LogicalProject(empid=[$0], deptno=[$1], name=[$2], commission=[$4])\n      EnumerableTableScan(table=[[hr, emps]])\n");
        }
    }

    @Test
    public void testWinAggConstant() {
        CalciteAssert.hr().query("select max(1) over (partition by \"deptno\"\n  order by \"empid\") as m\nfrom \"hr\".\"emps\"").returnsUnordered("M=1", "M=1", "M=1", "M=1");
    }

    @Test
    public void testWinAggConstantMultipleConstants() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select \"deptno\", sum(1) over (partition by \"deptno\"\n  order by \"empid\" rows between unbounded preceding and current row) as a,\n sum(-1) over (partition by \"deptno\"\n  order by \"empid\" rows between unbounded preceding and current row) as b\nfrom \"hr\".\"emps\"").returnsUnordered("deptno=10; A=1; B=-1", "deptno=10; A=2; B=-2", "deptno=10; A=3; B=-3", "deptno=20; A=1; B=-1");
    }

    @Test
    public void testWinAggPartitionByConstant() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select max(\"empid\"*0) over (partition by 42\n  order by \"empid\") as m\nfrom \"hr\".\"emps\"").returnsUnordered("M=0", "M=0", "M=0", "M=0");
    }

    @Test
    public void testWinAggOrderByConstant() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select max(\"empid\"*0) over (partition by \"deptno\"\n  order by 42) as m\nfrom \"hr\".\"emps\"").returnsUnordered("M=0", "M=0", "M=0", "M=0");
    }

    @Test
    public void testWhereNullable() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nwhere \"commission\" > 800").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testWhereOrAndNullable() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("with tst(c) as (values('a'),('b'),('c'),(cast(null as varchar))) select u.c u, v.c v from tst u, tst v where ((u.c = 'a' and v.c = 'b') or (u.c = 'b' and v.c = 'c'))").returnsUnordered("U=a; V=b", "U=b; V=c");
    }

    @Ignore(value="Fails with org.codehaus.commons.compiler.CompileException: Line 16, Column 112: Cannot compare types \"int\" and \"java.lang.String\"\n")
    @Test
    public void testComparingIntAndString() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)new ReflectiveSchema((Object)new ReflectiveSchemaTest.CatchallSchema())).query("select a.\"value\", b.\"value\"\n  from \"bools\" a\n     , \"bools\" b\n where b.\"value\" = 'T'\n order by 1, 2").returnsUnordered("should fail with 'not a number' sql error while converting text to number");
    }

    @Test
    public void testTrivialSort() {
        String sql = "select a.\"value\", b.\"value\"\n  from \"bools\" a\n     , \"bools\" b\n offset 0";
        CalciteAssert.that().withSchema("s", (Schema)new ReflectiveSchema((Object)new ReflectiveSchemaTest.CatchallSchema())).query("select a.\"value\", b.\"value\"\n  from \"bools\" a\n     , \"bools\" b\n offset 0").returnsUnordered("value=T; value=T", "value=T; value=F", "value=T; value=null", "value=F; value=T", "value=F; value=F", "value=F; value=null");
    }

    @Test
    public void testLike() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nwhere \"name\" like '%i__'").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\n");
    }

    @Test
    public void testArrayIndexing() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select \"deptno\", \"employees\"[1] as e from \"hr\".\"depts\"\n").returnsUnordered("deptno=10; E={100, 10, Bill, 10000.0, 1000}", "deptno=30; E=null", "deptno=40; E={200, 20, Eric, 8000.0, 500}");
    }

    @Test
    public void testVarcharEquals() {
        CalciteAssert.model(FOODMART_MODEL).query("select \"lname\" from \"customer\" where \"lname\" = 'Nowmer'").returns("lname=Nowmer\n");
        CalciteAssert.model(FOODMART_MODEL).query("select count(*) as c from \"customer\" where \"lname\" = 'this string is longer than 30 characters'").returns("C=0\n");
        CalciteAssert.model(FOODMART_MODEL).query("select count(*) as c from \"customer\" where cast(\"customer_id\" as char(20)) = 'this string is longer than 30 characters'").returns("C=0\n");
    }

    @Test
    public void testJoinMismatchedVarchar() {
        String sql = "select count(*) as c\nfrom \"customer\" as c\njoin \"product\" as p on c.\"lname\" = p.\"brand_name\"";
        CalciteAssert.model(FOODMART_MODEL).query("select count(*) as c\nfrom \"customer\" as c\njoin \"product\" as p on c.\"lname\" = p.\"brand_name\"").returns("C=607\n");
    }

    @Test
    public void testIntersectMismatchedVarchar() {
        String sql = "select count(*) as c from (\n  select \"lname\" from \"customer\" as c\n  intersect\n  select \"brand_name\" from \"product\" as p)";
        CalciteAssert.model(FOODMART_MODEL).query("select count(*) as c from (\n  select \"lname\" from \"customer\" as c\n  intersect\n  select \"brand_name\" from \"product\" as p)").returns("C=12\n");
    }

    @Test
    public void testNotIn() {
        this.predicate("\"name\" not in ('a', 'b') or \"name\" is null").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=200; deptno=20; name=Eric; salary=8000.0; commission=500\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
        this.predicate("\"name\" in ('a', 'b') or \"name\" is null");
        this.predicate("\"name\" in ('a', 'b', null) or \"name\" is null");
        this.predicate("\"name\" in ('a', 'b') or \"name\" is not null");
        this.predicate("\"name\" in ('a', 'b', null) or \"name\" is not null");
        this.predicate("\"name\" not in ('a', 'b', null) or \"name\" is not null");
        this.predicate("\"name\" not in ('a', 'b', null) and \"name\" is not null");
    }

    @Test
    public void testNotInEmptyQuery() {
        String sql = "select deptno from emp where deptno not in (\nselect deptno from dept where deptno = -1)";
        this.withEmpDept("select deptno from emp where deptno not in (\nselect deptno from dept where deptno = -1)").returnsUnordered("DEPTNO=null", "DEPTNO=10", "DEPTNO=10", "DEPTNO=20", "DEPTNO=30", "DEPTNO=30", "DEPTNO=50", "DEPTNO=50", "DEPTNO=60");
    }

    @Test
    public void testNotInQuery() {
        String sql = "select deptno from emp where deptno not in (\nselect deptno from dept)";
        this.withEmpDept("select deptno from emp where deptno not in (\nselect deptno from dept)").returnsUnordered("DEPTNO=50", "DEPTNO=50", "DEPTNO=60");
    }

    @Test
    public void testNotInQueryWithNull() {
        String sql = "select deptno from emp where deptno not in (\nselect deptno from emp)";
        this.withEmpDept("select deptno from emp where deptno not in (\nselect deptno from emp)").returnsCount(0);
    }

    @Test
    public void testTrim() {
        CalciteAssert.model(FOODMART_MODEL).query("select trim(\"lname\") as \"lname\" from \"customer\" where \"lname\" = 'Nowmer'").returns("lname=Nowmer\n");
        CalciteAssert.model(FOODMART_MODEL).query("select trim(leading 'N' from \"lname\") as \"lname\" from \"customer\" where \"lname\" = 'Nowmer'").returns("lname=owmer\n");
    }

    private CalciteAssert.AssertQuery predicate(String foo) {
        return CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select * from \"hr\".\"emps\"\nwhere " + foo).runs();
    }

    @Test
    public void testExistsCorrelated() {
        String sql = "select*from \"hr\".\"emps\" where exists (\n select 1 from \"hr\".\"depts\"\n where \"emps\".\"deptno\"=\"depts\".\"deptno\")";
        String plan = "LogicalProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  LogicalFilter(condition=[EXISTS({\nLogicalFilter(condition=[=($cor0.deptno, $0)])\n  EnumerableTableScan(table=[[hr, depts]])\n})], variablesSet=[[$cor0]])\n    EnumerableTableScan(table=[[hr, emps]])\n";
        CalciteAssert.hr().query("select*from \"hr\".\"emps\" where exists (\n select 1 from \"hr\".\"depts\"\n where \"emps\".\"deptno\"=\"depts\".\"deptno\")").convertContains("LogicalProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  LogicalFilter(condition=[EXISTS({\nLogicalFilter(condition=[=($cor0.deptno, $0)])\n  EnumerableTableScan(table=[[hr, depts]])\n})], variablesSet=[[$cor0]])\n    EnumerableTableScan(table=[[hr, emps]])\n").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000", "empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250");
    }

    @Test
    public void testNotExistsCorrelated() {
        String plan = "PLAN=EnumerableCalc(expr#0..5=[{inputs}], expr#6=[IS NULL($t5)], proj#0..4=[{exprs}], $condition=[$t6])\n  EnumerableCorrelate(correlation=[$cor0], joinType=[left], requiredColumns=[{1}])\n    EnumerableTableScan(table=[[hr, emps]])\n    EnumerableAggregate(group=[{0}])\n      EnumerableCalc(expr#0..3=[{inputs}], expr#4=[true], expr#5=[$cor0], expr#6=[$t5.deptno], expr#7=[=($t6, $t0)], i=[$t4], $condition=[$t7])\n        EnumerableTableScan(table=[[hr, depts]])\n";
        String sql = "select * from \"hr\".\"emps\" where not exists (\n select 1 from \"hr\".\"depts\"\n where \"emps\".\"deptno\"=\"depts\".\"deptno\")";
        CalciteAssert.hr().with((ConnectionProperty)CalciteConnectionProperty.FORCE_DECORRELATE, (Object)false).query("select * from \"hr\".\"emps\" where not exists (\n select 1 from \"hr\".\"depts\"\n where \"emps\".\"deptno\"=\"depts\".\"deptno\")").explainContains("PLAN=EnumerableCalc(expr#0..5=[{inputs}], expr#6=[IS NULL($t5)], proj#0..4=[{exprs}], $condition=[$t6])\n  EnumerableCorrelate(correlation=[$cor0], joinType=[left], requiredColumns=[{1}])\n    EnumerableTableScan(table=[[hr, emps]])\n    EnumerableAggregate(group=[{0}])\n      EnumerableCalc(expr#0..3=[{inputs}], expr#4=[true], expr#5=[$cor0], expr#6=[$t5.deptno], expr#7=[=($t6, $t0)], i=[$t4], $condition=[$t7])\n        EnumerableTableScan(table=[[hr, depts]])\n").returnsUnordered("empid=200; deptno=20; name=Eric; salary=8000.0; commission=500");
    }

    @Test
    public void testNotExistsCorrelated2() {
        String sql = "select * from \"hr\".\"emps\" as e left join lateral (\n select distinct true as i\n from \"hr\".\"depts\"\n where e.\"deptno\"=\"depts\".\"deptno\") on true";
        String explain = "EnumerableCalc(expr#0..6=[{inputs}], proj#0..4=[{exprs}], I=[$t6])\n  EnumerableJoin(condition=[=($1, $5)], joinType=[left])\n    EnumerableTableScan(table=[[hr, emps]])\n    EnumerableCalc(expr#0=[{inputs}], expr#1=[true], proj#0..1=[{exprs}])\n      EnumerableAggregate(group=[{0}])\n        EnumerableTableScan(table=[[hr, depts]])";
        CalciteAssert.hr().query("select * from \"hr\".\"emps\" as e left join lateral (\n select distinct true as i\n from \"hr\".\"depts\"\n where e.\"deptno\"=\"depts\".\"deptno\") on true").explainContains("EnumerableCalc(expr#0..6=[{inputs}], proj#0..4=[{exprs}], I=[$t6])\n  EnumerableJoin(condition=[=($1, $5)], joinType=[left])\n    EnumerableTableScan(table=[[hr, emps]])\n    EnumerableCalc(expr#0=[{inputs}], expr#1=[true], proj#0..1=[{exprs}])\n      EnumerableAggregate(group=[{0}])\n        EnumerableTableScan(table=[[hr, depts]])").returnsUnordered("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000; I=true", "empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250; I=true", "empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null; I=true", "empid=200; deptno=20; name=Eric; salary=8000.0; commission=500; I=null");
    }

    @Test
    public void testJoinInCorrelatedSubQuery() {
        CalciteAssert.hr().query("select *\nfrom \"hr\".\"depts\" as d\nwhere \"deptno\" in (\n  select d2.\"deptno\"\n  from \"hr\".\"depts\" as d2\n  join \"hr\".\"emps\" as e2 using (\"deptno\")\nwhere d.\"deptno\" = d2.\"deptno\")").convertMatches(relNode -> {
            String s = RelOptUtil.toString((RelNode)relNode);
            Assert.assertThat((Object)s, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Correlate")));
            return null;
        });
    }

    @Test
    public void testScalarSubQuery() {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_EXPAND.push((Object)true);){
            CalciteAssert.hr().query("select \"empid\", \"deptno\",\n (select \"name\" from \"hr\".\"depts\"\n  where \"deptno\" = e.\"deptno\") as dname\nfrom \"hr\".\"emps\" as e").returnsUnordered("empid=100; deptno=10; DNAME=Sales", "empid=110; deptno=10; DNAME=Sales", "empid=150; deptno=10; DNAME=Sales", "empid=200; deptno=20; DNAME=null");
        }
    }

    @Test
    public void testJoinCorrelatedScalarSubQuery() throws SQLException {
        String sql = "select e.employee_id, d.department_id  from employee e, department d  where e.department_id = d.department_id  and e.salary > (select avg(e2.salary)                  from employee e2                  where e2.store_id = e.store_id)";
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).with(Lex.JAVA).query("select e.employee_id, d.department_id  from employee e, department d  where e.department_id = d.department_id  and e.salary > (select avg(e2.salary)                  from employee e2                  where e2.store_id = e.store_id)").returnsCount(599);
    }

    @Ignore(value="[CALCITE-685]")
    @Test
    public void testCorrelatedScalarSubQuery() throws SQLException {
        String sql = "select e.department_id, sum(e.employee_id),\n       ( select sum(e2.employee_id)\n         from  employee e2\n         where e.department_id = e2.department_id\n       )\nfrom employee e\ngroup by e.department_id\n";
        String explain = "EnumerableJoin(condition=[true], joinType=[left])\n  EnumerableAggregate(group=[{7}], EXPR$1=[$SUM0($0)])\n    EnumerableTableScan(table=[[foodmart2, employee]])\n  EnumerableAggregate(group=[{}], EXPR$0=[SUM($0)])\n    EnumerableCalc(expr#0..16=[{inputs}], expr#17=[$cor0], expr#18=[$t17.department_id], expr#19=[=($t18, $t7)], employee_id=[$t0], department_id=[$t7], $condition=[$t19])\n      EnumerableTableScan(table=[[foodmart2, employee]])\n";
        CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).with(Lex.JAVA).query("select e.department_id, sum(e.employee_id),\n       ( select sum(e2.employee_id)\n         from  employee e2\n         where e.department_id = e2.department_id\n       )\nfrom employee e\ngroup by e.department_id\n").explainContains("EnumerableJoin(condition=[true], joinType=[left])\n  EnumerableAggregate(group=[{7}], EXPR$1=[$SUM0($0)])\n    EnumerableTableScan(table=[[foodmart2, employee]])\n  EnumerableAggregate(group=[{}], EXPR$0=[SUM($0)])\n    EnumerableCalc(expr#0..16=[{inputs}], expr#17=[$cor0], expr#18=[$t17.department_id], expr#19=[=($t18, $t7)], employee_id=[$t0], department_id=[$t7], $condition=[$t19])\n      EnumerableTableScan(table=[[foodmart2, employee]])\n").returnsCount(0);
    }

    @Test
    public void testLeftJoin() {
        CalciteAssert.hr().query("select e.\"deptno\", d.\"deptno\"\nfrom \"hr\".\"emps\" as e\n  left join \"hr\".\"depts\" as d using (\"deptno\")").returnsUnordered("deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=20; deptno=null");
    }

    @Test
    public void testFullJoin() {
        CalciteAssert.hr().query("select e.\"deptno\", d.\"deptno\"\nfrom \"hr\".\"emps\" as e\n  full join \"hr\".\"depts\" as d using (\"deptno\")").returnsUnordered("deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=20; deptno=null", "deptno=null; deptno=30", "deptno=null; deptno=40");
    }

    @Test
    public void testRightJoin() {
        CalciteAssert.hr().query("select e.\"deptno\", d.\"deptno\"\nfrom \"hr\".\"emps\" as e\n  right join \"hr\".\"depts\" as d using (\"deptno\")").returnsUnordered("deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=null; deptno=30", "deptno=null; deptno=40");
    }

    @Test
    public void testLeftJoinWhereStructIsNotNull() {
        CalciteAssert.hr().query("select e.\"deptno\", d.\"deptno\"\nfrom \"hr\".\"emps\" as e\n  left join \"hr\".\"depts\" as d using (\"deptno\")where d.\"location\" is not null").returnsUnordered("deptno=10; deptno=10", "deptno=10; deptno=10", "deptno=10; deptno=10");
    }

    @Test
    public void testVariousOuter() {
        String sql = "select * from emp join dept on emp.deptno = dept.deptno";
        this.withEmpDept("select * from emp join dept on emp.deptno = dept.deptno").returnsUnordered("ENAME=Alice; DEPTNO=30; GENDER=F; DEPTNO0=30; DNAME=Engineering", "ENAME=Bob  ; DEPTNO=10; GENDER=M; DEPTNO0=10; DNAME=Sales      ", "ENAME=Eric ; DEPTNO=20; GENDER=M; DEPTNO0=20; DNAME=Marketing  ", "ENAME=Jane ; DEPTNO=10; GENDER=F; DEPTNO0=10; DNAME=Sales      ", "ENAME=Susan; DEPTNO=30; GENDER=F; DEPTNO0=30; DNAME=Engineering");
    }

    private CalciteAssert.AssertQuery withEmpDept(String sql) {
        return CalciteAssert.that().query("with\n  emp(ename, deptno, gender) as (values\n    ('Jane', 10, 'F'),\n    ('Bob', 10, 'M'),\n    ('Eric', 20, 'M'),\n    ('Susan', 30, 'F'),\n    ('Alice', 30, 'F'),\n    ('Adam', 50, 'M'),\n    ('Eve', 50, 'F'),\n    ('Grace', 60, 'F'),\n    ('Wilma', cast(null as integer), 'F')),\n  dept(deptno, dname) as (values\n    (10, 'Sales'),\n    (20, 'Marketing'),\n    (30, 'Engineering'),\n    (40, 'Empty'))\n" + sql);
    }

    @Test
    public void testScalarSubQueryUncorrelated() {
        CalciteAssert.hr().query("select \"empid\", \"deptno\",\n (select \"name\" from \"hr\".\"depts\"\n  where \"deptno\" = 30) as dname\nfrom \"hr\".\"emps\" as e").returnsUnordered("empid=100; deptno=10; DNAME=Marketing", "empid=110; deptno=10; DNAME=Marketing", "empid=150; deptno=10; DNAME=Marketing", "empid=200; deptno=20; DNAME=Marketing");
    }

    @Test
    public void testScalarSubQueryInCase() {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_EXPAND.push((Object)true);){
            CalciteAssert.hr().query("select e.\"name\",\n (CASE e.\"deptno\"\n  WHEN (Select \"deptno\" from \"hr\".\"depts\" d\n        where d.\"deptno\" = e.\"deptno\")\n  THEN (Select d.\"name\" from \"hr\".\"depts\" d\n        where d.\"deptno\" = e.\"deptno\")\n  ELSE 'DepartmentNotFound'  END) AS DEPTNAME\nfrom \"hr\".\"emps\" e").returnsUnordered("name=Bill; DEPTNAME=Sales", "name=Eric; DEPTNAME=DepartmentNotFound", "name=Sebastian; DEPTNAME=Sales", "name=Theodore; DEPTNAME=Sales");
        }
    }

    @Test
    public void testScalarSubQueryInCase2() {
        CalciteAssert.hr().query("select e.\"name\",\n (CASE WHEN e.\"deptno\" = (\n    Select \"deptno\" from \"hr\".\"depts\" d\n    where d.\"name\" = 'Sales')\n  THEN 'Sales'\n  ELSE 'Not Matched'  END) AS DEPTNAME\nfrom \"hr\".\"emps\" e").returnsUnordered("name=Bill; DEPTNAME=Sales      ", "name=Eric; DEPTNAME=Not Matched", "name=Sebastian; DEPTNAME=Sales      ", "name=Theodore; DEPTNAME=Sales      ");
    }

    @Test
    public void testMetaTables() {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR_PLUS_METADATA).query("select * from \"metadata\".TABLES").returns(CalciteAssert.checkResultContains("tableSchem=metadata; tableName=COLUMNS; tableType=SYSTEM TABLE; "));
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR_PLUS_METADATA).query("select count(distinct \"tableSchem\") as c\nfrom \"metadata\".TABLES").returns("C=3\n");
    }

    @Test
    public void testSetMaxRows() throws Exception {
        CalciteAssert.hr().doWithConnection(connection -> {
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.setMaxRows(-1);
                    Assert.fail((String)"expected error");
                }
                catch (SQLException e) {
                    Assert.assertEquals((Object)e.getMessage(), (Object)"illegal maxRows value: -1");
                }
                statement.setMaxRows(2);
                Assert.assertEquals((long)2L, (long)statement.getMaxRows());
                ResultSet resultSet = statement.executeQuery("select * from \"hr\".\"emps\"");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
                resultSet.close();
                statement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testPreparedStatement() throws Exception {
        CalciteAssert.hr().doWithConnection(connection -> {
            try {
                ResultSet resultSet;
                PreparedStatement preparedStatement = connection.prepareStatement("select \"deptno\", \"name\" from \"hr\".\"emps\"\nwhere \"deptno\" < ? and \"name\" like ?");
                try {
                    resultSet = preparedStatement.executeQuery();
                    Assert.fail((String)("expected error, got " + resultSet));
                }
                catch (SQLException e) {
                    Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"exception while executing query: unbound parameter"));
                }
                preparedStatement.setNull(1, 4);
                preparedStatement.setNull(2, 12);
                resultSet = preparedStatement.executeQuery();
                Assert.assertFalse((boolean)resultSet.next());
                preparedStatement.setInt(1, 15);
                preparedStatement.setString(2, "%");
                resultSet = preparedStatement.executeQuery();
                Assert.assertEquals((Object)"deptno=10; name=Bill\ndeptno=10; name=Sebastian\ndeptno=10; name=Theodore\n", (Object)CalciteAssert.toString(resultSet));
                preparedStatement.setString(2, "%r%");
                resultSet = preparedStatement.executeQuery();
                Assert.assertEquals((Object)"deptno=10; name=Theodore\n", (Object)CalciteAssert.toString(resultSet));
                String sql2 = "select \"deptno\", \"name\" from \"hr\".\"emps\"\nwhere \"deptno\" between symmetric ? and ?\norder by 2";
                PreparedStatement preparedStatement2 = connection.prepareStatement("select \"deptno\", \"name\" from \"hr\".\"emps\"\nwhere \"deptno\" between symmetric ? and ?\norder by 2");
                preparedStatement2.setInt(1, 15);
                preparedStatement2.setInt(2, 5);
                resultSet = preparedStatement2.executeQuery();
                Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"deptno=10; name=Bill\ndeptno=10; name=Sebastian\ndeptno=10; name=Theodore\n"));
                resultSet.close();
                preparedStatement2.close();
                preparedStatement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testPreparedOffsetFetch() throws Exception {
        this.checkPreparedOffsetFetch(0, 0, Matchers.returnsUnordered(new String[0]));
        this.checkPreparedOffsetFetch(100, 4, Matchers.returnsUnordered(new String[0]));
        this.checkPreparedOffsetFetch(3, 4, Matchers.returnsUnordered("name=Eric"));
    }

    private void checkPreparedOffsetFetch(int offset, int fetch, Matcher<? super ResultSet> matcher) throws Exception {
        CalciteAssert.hr().doWithConnection(connection -> {
            String sql = "select \"name\"\nfrom \"hr\".\"emps\"\norder by \"empid\" offset ? fetch next ? rows only";
            try (PreparedStatement p = connection.prepareStatement("select \"name\"\nfrom \"hr\".\"emps\"\norder by \"empid\" offset ? fetch next ? rows only");){
                ParameterMetaData pmd = p.getParameterMetaData();
                Assert.assertThat((Object)pmd.getParameterCount(), (Matcher)CoreMatchers.is((Object)2));
                Assert.assertThat((Object)pmd.getParameterType(1), (Matcher)CoreMatchers.is((Object)4));
                Assert.assertThat((Object)pmd.getParameterType(2), (Matcher)CoreMatchers.is((Object)4));
                p.setInt(1, offset);
                p.setInt(2, fetch);
                try (ResultSet r = p.executeQuery();){
                    Assert.assertThat((Object)r, (Matcher)matcher);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testModel() {
        CalciteAssert.model(FOODMART_MODEL).query("select count(*) as c from \"foodmart\".\"time_by_day\"").returns("C=730\n");
    }

    @Test
    public void testModelWithComment() {
        String model = FOODMART_MODEL.replace("schemas:", "/* comment */ schemas:");
        Assert.assertThat((Object)model, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)FOODMART_MODEL)));
        CalciteAssert.model(model).query("select count(*) as c from \"foodmart\".\"time_by_day\"").returns("C=730\n");
    }

    @Ignore(value="until JdbcSchema can define materialized views")
    @Test
    public void testModelWithMaterializedView() {
        CalciteAssert.model(FOODMART_MODEL).enable(false).query("select count(*) as c from \"foodmart\".\"sales_fact_1997\" join \"foodmart\".\"time_by_day\" using (\"time_id\")").returns("C=86837\n");
        CalciteAssert.that().withMaterializations(FOODMART_MODEL, "agg_c_10_sales_fact_1997", "select t.`month_of_year`, t.`quarter`, t.`the_year`, sum(s.`store_sales`) as `store_sales`, sum(s.`store_cost`), sum(s.`unit_sales`), count(distinct s.`customer_id`), count(*) as `fact_count` from `time_by_day` as t join `sales_fact_1997` as s using (`time_id`) group by t.`month_of_year`, t.`quarter`, t.`the_year`").query("select t.\"month_of_year\", t.\"quarter\", t.\"the_year\", sum(s.\"store_sales\") as \"store_sales\", sum(s.\"store_cost\"), sum(s.\"unit_sales\"), count(distinct s.\"customer_id\"), count(*) as \"fact_count\" from \"time_by_day\" as t join \"sales_fact_1997\" as s using (\"time_id\") group by t.\"month_of_year\", t.\"quarter\", t.\"the_year\"").explainContains("JdbcTableScan(table=[[foodmart, agg_c_10_sales_fact_1997]])").enableMaterializations(false).explainContains("JdbcTableScan(table=[[foodmart, sales_fact_1997]])").sameResultWithMaterializationsDisabled();
    }

    @Test
    public void testModelCustomTable() {
        CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + EmpDeptTableFactory.class.getName() + "',\n           operand: {'foo': 1, 'bar': [345, 357] }\n         }\n       ]\n     }\n   ]\n}").query("select * from \"adhoc\".EMPLOYEES where \"deptno\" = 10").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
    }

    @Test
    public void testModelCustomTable2() {
        this.testRangeTable("object");
    }

    @Test
    public void testModelCustomTableArrayRowSingleColumn() {
        this.testRangeTable("array");
    }

    @Test
    public void testModelCustomTableIntegerRowSingleColumn() {
        this.testRangeTable("integer");
    }

    private void testRangeTable(String elementType) {
        CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'MATH',\n       tables: [\n         {\n           name: 'INTEGERS',\n           type: 'custom',\n           factory: '" + RangeTable.Factory.class.getName() + "',\n           operand: {'column': 'N', 'start': 3, 'end': 7,  'elementType': '" + elementType + "'}\n         }\n       ]\n     }\n   ]\n}").query("select * from math.integers").returns("N=3\nN=4\nN=5\nN=6\n");
    }

    @Test
    public void testModelCustomSchema() throws Exception {
        CalciteAssert.AssertThat that = CalciteAssert.model("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [\n    {\n      name: 'empty'\n    },\n    {\n      name: 'adhoc',\n      type: 'custom',\n      factory: '" + MySchemaFactory.class.getName() + "',\n      operand: {'tableName': 'ELVIS'}\n    }\n  ]\n}");
        that.doWithConnection(connection -> {
            try {
                Assert.assertEquals((Object)"adhoc", (Object)connection.getSchema());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        that.query("select * from \"adhoc\".ELVIS where \"deptno\" = 10").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
        that.query("select * from \"adhoc\".EMPLOYEES").throws_("Object 'EMPLOYEES' not found within 'adhoc'");
    }

    @Test
    public void testCustomSchemaInFileInPwd() throws SQLException {
        this.checkCustomSchemaInFileInPwd("custom-schema-model.json");
        switch (File.pathSeparatorChar) {
            case '/': {
                this.checkCustomSchemaInFileInPwd("." + File.pathSeparatorChar + "custom-schema-model2.json");
            }
        }
    }

    private void checkCustomSchemaInFileInPwd(String fileName) throws SQLException {
        File file = new File(fileName);
        try (PrintWriter pw = Util.printWriter((File)file);){
            file.deleteOnExit();
            pw.println("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [\n    {\n      name: 'empty'\n    },\n    {\n      name: 'adhoc',\n      type: 'custom',\n      factory: '" + MySchemaFactory.class.getName() + "',\n      operand: {'tableName': 'ELVIS'}\n    }\n  ]\n}");
            pw.flush();
            String url = "jdbc:calcite:model=" + file;
            try (Connection c = DriverManager.getConnection(url);
                 Statement s = c.createStatement();
                 ResultSet r = s.executeQuery("values 1");){
                Assert.assertThat((Object)r.next(), (Matcher)CoreMatchers.is((Object)true));
            }
            file.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCustomSchemaDirectConnection() throws Exception {
        String url = "jdbc:calcite:schemaFactory=" + MySchemaFactory.class.getName() + "; schema.tableName=ELVIS";
        this.checkCustomSchema(url, "adhoc");
        this.checkCustomSchema(url + "; schema=xyz", "xyz");
    }

    private void checkCustomSchema(String url, String schemaName) throws SQLException {
        try (Connection connection = DriverManager.getConnection(url);){
            Assert.assertThat((Object)connection.getSchema(), (Matcher)CoreMatchers.is((Object)schemaName));
            String sql = "select * from \"" + schemaName + "\".ELVIS where \"deptno\" = 10";
            String sql2 = "select * from ELVIS where \"deptno\" = 10";
            String expected = "empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n";
            try (Statement statement = connection.createStatement();){
                try (ResultSet resultSet = statement.executeQuery(sql);){
                    Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)expected));
                }
                resultSet = statement.executeQuery("select * from ELVIS where \"deptno\" = 10");
                var11_15 = null;
                try {
                    Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)expected));
                }
                catch (Throwable throwable) {
                    var11_15 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultSet != null) {
                        if (var11_15 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {
                                var11_15.addSuppressed(throwable);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testJdbcSchemaDirectConnection() throws Exception {
        this.checkJdbcSchemaDirectConnection("schemaFactory=org.apache.calcite.adapter.jdbc.JdbcSchema$Factory");
        this.checkJdbcSchemaDirectConnection("schemaType=JDBC");
    }

    private void checkJdbcSchemaDirectConnection(String s) throws SQLException {
        StringBuilder b = new StringBuilder("jdbc:calcite:");
        b.append(s);
        this.pv(b, "schema.jdbcUser", JdbcTest.SCOTT.username);
        this.pv(b, "schema.jdbcPassword", JdbcTest.SCOTT.password);
        this.pv(b, "schema.jdbcUrl", JdbcTest.SCOTT.url);
        this.pv(b, "schema.jdbcCatalog", JdbcTest.SCOTT.catalog);
        this.pv(b, "schema.jdbcDriver", JdbcTest.SCOTT.driver);
        this.pv(b, "schema.jdbcSchema", JdbcTest.SCOTT.schema);
        String url = b.toString();
        Connection connection = DriverManager.getConnection(url);
        Assert.assertThat((Object)connection.getSchema(), (Matcher)CoreMatchers.is((Object)"adhoc"));
        String expected = "C=14\n";
        String sql = "select count(*) as c from emp";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select count(*) as c from emp");){
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)expected));
        }
    }

    private void pv(StringBuilder b, String p, String v) {
        if (v != null) {
            b.append("; ").append(p).append("=").append(v);
        }
    }

    @Test
    public void testMapSchemaDirectConnection() throws Exception {
        this.checkMapSchemaDirectConnection("schemaType=MAP");
        this.checkMapSchemaDirectConnection("schemaFactory=org.apache.calcite.schema.impl.AbstractSchema$Factory");
    }

    private void checkMapSchemaDirectConnection(String s) throws SQLException {
        String url = "jdbc:calcite:" + s;
        Connection connection = DriverManager.getConnection(url);
        Assert.assertThat((Object)connection.getSchema(), (Matcher)CoreMatchers.is((Object)"adhoc"));
        String expected = "EXPR$0=1\n";
        String sql = "values 1";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("values 1");){
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)expected));
        }
    }

    @Test
    public void testModelImmutableSchemaCannotContainView() throws Exception {
        CalciteAssert.model("{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [\n    {\n      name: 'empty'\n    },\n    {\n      name: 'adhoc',\n      type: 'custom',\n      tables: [\n        {\n          name: 'v',\n          type: 'view',\n          sql: 'values (1)'\n        }\n      ],\n      factory: '" + MySchemaFactory.class.getName() + "',\n      operand: {\n           'tableName': 'ELVIS',\n           'mutable': false\n      }\n    }\n  ]\n}").connectThrows("Cannot define view; parent schema 'adhoc' is not mutable");
    }

    private CalciteAssert.AssertThat modelWithView(String view, Boolean modifiable) {
        Class<EmpDeptTableFactory> clazz = EmpDeptTableFactory.class;
        return CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + clazz.getName() + "',\n           operand: {'foo': true, 'bar': 345}\n         },\n         {\n           name: 'MUTABLE_EMPLOYEES',\n           type: 'custom',\n           factory: '" + clazz.getName() + "',\n           operand: {'foo': false}\n         },\n         {\n           name: 'V',\n           type: 'view',\n" + (modifiable == null ? "" : " modifiable: " + modifiable + ",\n") + "           sql: " + new JsonBuilder().toJsonString((Object)view) + "\n         }\n       ]\n     }\n   ]\n}");
    }

    @Test
    public void testModelView() throws Exception {
        CalciteAssert.AssertThat with = this.modelWithView("select * from \"EMPLOYEES\" where \"deptno\" = 10", null);
        with.query("select * from \"adhoc\".V order by \"name\" desc").returns("empid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
        with.doWithConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet r = metaData.getTables(null, "adhoc", null, null);){
                    Assert.assertEquals((Object)"TABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=EMPLOYEES; TABLE_TYPE=TABLE; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=MUTABLE_EMPLOYEES; TABLE_TYPE=TABLE; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; TABLE_TYPE=VIEW; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\n", (Object)CalciteAssert.toString(r));
                }
                r = metaData.getTables(null, null, null, null);
                var3_4 = null;
                try {
                    Assert.assertEquals((Object)"TABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=EMPLOYEES; TABLE_TYPE=TABLE; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=MUTABLE_EMPLOYEES; TABLE_TYPE=TABLE; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; TABLE_TYPE=VIEW; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\nTABLE_CAT=null; TABLE_SCHEM=metadata; TABLE_NAME=COLUMNS; TABLE_TYPE=SYSTEM TABLE; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\nTABLE_CAT=null; TABLE_SCHEM=metadata; TABLE_NAME=TABLES; TABLE_TYPE=SYSTEM TABLE; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\n", (Object)CalciteAssert.toString(r));
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var3_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
                r = metaData.getTables(null, "adhoc", null, new String[]{Schema.TableType.VIEW.jdbcName});
                var3_4 = null;
                try {
                    Assert.assertEquals((Object)"TABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; TABLE_TYPE=VIEW; REMARKS=null; TYPE_CAT=null; TYPE_SCHEM=null; TYPE_NAME=null; SELF_REFERENCING_COL_NAME=null; REF_GENERATION=null\n", (Object)CalciteAssert.toString(r));
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var3_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
                r = metaData.getColumns(null, "adhoc", "V", null);
                var3_4 = null;
                try {
                    Assert.assertEquals((Object)"TABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=empid; DATA_TYPE=4; TYPE_NAME=JavaType(int) NOT NULL; COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=0; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=1; IS_NULLABLE=NO; SCOPE_CATALOG=null; SCOPE_SCHEMA=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=; IS_GENERATEDCOLUMN=\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=deptno; DATA_TYPE=4; TYPE_NAME=JavaType(int) NOT NULL; COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=0; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=2; IS_NULLABLE=NO; SCOPE_CATALOG=null; SCOPE_SCHEMA=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=; IS_GENERATEDCOLUMN=\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=name; DATA_TYPE=12; TYPE_NAME=JavaType(class java.lang.String); COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=1; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=3; IS_NULLABLE=YES; SCOPE_CATALOG=null; SCOPE_SCHEMA=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=; IS_GENERATEDCOLUMN=\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=salary; DATA_TYPE=7; TYPE_NAME=JavaType(float) NOT NULL; COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=0; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=4; IS_NULLABLE=NO; SCOPE_CATALOG=null; SCOPE_SCHEMA=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=; IS_GENERATEDCOLUMN=\nTABLE_CAT=null; TABLE_SCHEM=adhoc; TABLE_NAME=V; COLUMN_NAME=commission; DATA_TYPE=4; TYPE_NAME=JavaType(class java.lang.Integer); COLUMN_SIZE=-1; BUFFER_LENGTH=null; DECIMAL_DIGITS=null; NUM_PREC_RADIX=10; NULLABLE=1; REMARKS=null; COLUMN_DEF=null; SQL_DATA_TYPE=null; SQL_DATETIME_SUB=null; CHAR_OCTET_LENGTH=-1; ORDINAL_POSITION=5; IS_NULLABLE=YES; SCOPE_CATALOG=null; SCOPE_SCHEMA=null; SCOPE_TABLE=null; SOURCE_DATA_TYPE=null; IS_AUTOINCREMENT=; IS_GENERATEDCOLUMN=\n", (Object)CalciteAssert.toString(r));
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var3_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
                r = metaData.getCatalogs();
                var3_4 = null;
                try {
                    Assert.assertEquals((Object)"TABLE_CAT=null\n", (Object)CalciteAssert.toString(r));
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var3_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
                r = metaData.getSchemas();
                var3_4 = null;
                try {
                    Assert.assertEquals((Object)"TABLE_SCHEM=adhoc; TABLE_CATALOG=null\nTABLE_SCHEM=metadata; TABLE_CATALOG=null\n", (Object)CalciteAssert.toString(r));
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var3_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
                r = metaData.getSchemas(null, "adhoc");
                var3_4 = null;
                try {
                    Assert.assertEquals((Object)"TABLE_SCHEM=adhoc; TABLE_CATALOG=null\n", (Object)CalciteAssert.toString(r));
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var3_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
                r = metaData.getTableTypes();
                var3_4 = null;
                try {
                    Assert.assertEquals((Object)"TABLE_TYPE=TABLE\nTABLE_TYPE=VIEW\n", (Object)CalciteAssert.toString(r));
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var3_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testOrderByView() throws Exception {
        CalciteAssert.AssertThat with = this.modelWithView("select * from \"EMPLOYEES\" where \"deptno\" = 10 order by \"empid\" limit 2", null);
        with.query("select \"name\" from \"adhoc\".V order by \"name\"").returns("name=Bill\nname=Theodore\n");
        with.query("select \"name\" from (\nselect * from \"adhoc\".\"EMPLOYEES\" where \"deptno\" = 10\norder by \"empid\" limit 2)\norder by \"name\"").returns("name=Bill\nname=Theodore\n");
    }

    @Test
    public void testSelfReferentialView() throws Exception {
        CalciteAssert.AssertThat with = this.modelWithView("select * from \"V\"", null);
        with.query("select \"name\" from \"adhoc\".V").throws_("Cannot resolve 'adhoc.V'; it references view 'adhoc.V', whose definition is cyclic");
    }

    @Test
    public void testSelfReferentialView2() throws Exception {
        String model = "{\n  version: '1.0',\n  defaultSchema: 'adhoc',\n  schemas: [ {\n    name: 'adhoc',\n    tables: [ {\n      name: 'A',\n      type: 'view',\n      sql: " + new JsonBuilder().toJsonString((Object)"select * from B") + "\n    }, {\n      name: 'B',\n      type: 'view',\n      sql: " + new JsonBuilder().toJsonString((Object)"select * from C") + "\n    }, {\n      name: 'C',\n      type: 'view',\n      sql: " + new JsonBuilder().toJsonString((Object)"select * from D, B") + "\n    }, {\n      name: 'D',\n      type: 'view',\n      sql: " + new JsonBuilder().toJsonString((Object)"select * from (values (1, 'a')) as t(x, y)") + "\n    } ]\n  } ]\n}";
        CalciteAssert.AssertThat with = CalciteAssert.model(model);
        with.query("select x from \"adhoc\".a").throws_("Cannot resolve 'adhoc.A'; it references view 'adhoc.B', whose definition is cyclic");
        with.query("select x from \"adhoc\".b").throws_("Cannot resolve 'adhoc.B'; it references view 'adhoc.B', whose definition is cyclic");
        with.query("select x from b").throws_("Cannot resolve 'B'; it references view 'adhoc.B', whose definition is cyclic");
        with.query("select x from \"adhoc\".c").throws_("Cannot resolve 'adhoc.C'; it references view 'adhoc.C', whose definition is cyclic");
        with.query("select x from \"adhoc\".d").returns("X=1\n");
        with.query("select x from \"adhoc\".d except select x from \"adhoc\".a").throws_("Cannot resolve 'adhoc.A'; it references view 'adhoc.B', whose definition is cyclic");
    }

    @Test
    public void testAutomaticTemporaryTable() throws Exception {
        final ArrayList objects = new ArrayList();
        CalciteAssert.that().with(new CalciteAssert.ConnectionFactory(){

            public CalciteConnection createConnection() throws SQLException {
                CalciteConnection connection = (CalciteConnection)new AutoTempDriver(objects).connect("jdbc:calcite:", new Properties());
                SchemaPlus rootSchema = connection.getRootSchema();
                rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new HrSchema()));
                connection.setSchema("hr");
                return connection;
            }
        }).doWithConnection(connection -> {
            try {
                String sql = "select * from \"hr\".\"emps\" where \"deptno\" = 10";
                connection.createStatement().executeQuery("select * from \"hr\".\"emps\" where \"deptno\" = 10");
                Assert.assertThat((Object)objects.size(), (Matcher)CoreMatchers.is((Object)1));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testExplain() {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE);
        with.query("explain plan for values (1, 'ab')").returns("PLAN=EnumerableValues(tuples=[[{ 1, 'ab' }]])\n\n");
        String expectedXml = "PLAN=<RelNode type=\"EnumerableValues\">\n\t<Property name=\"tuples\">\n\t\t[{ 1, &#39;ab&#39; }]\t</Property>\n\t<Inputs/>\n</RelNode>\n\n";
        with.query("explain plan as xml for values (1, 'ab')").returns("PLAN=<RelNode type=\"EnumerableValues\">\n\t<Property name=\"tuples\">\n\t\t[{ 1, &#39;ab&#39; }]\t</Property>\n\t<Inputs/>\n</RelNode>\n\n");
        String expectedJson = "PLAN={\n  \"rels\": [\n    {\n      \"id\": \"0\",\n      \"relOp\": \"org.apache.calcite.adapter.enumerable.EnumerableValues\",\n      \"type\": [\n        {\n          \"type\": \"INTEGER\",\n          \"nullable\": false,\n          \"name\": \"EXPR$0\"\n        },\n        {\n          \"type\": \"CHAR\",\n          \"nullable\": false,\n          \"precision\": 2,\n          \"name\": \"EXPR$1\"\n        }\n      ],\n      \"tuples\": [\n        [\n          1,\n          \"ab\"\n        ]\n      ],\n      \"inputs\": []\n    }\n  ]\n}\n";
        with.query("explain plan as json for values (1, 'ab')").returns("PLAN={\n  \"rels\": [\n    {\n      \"id\": \"0\",\n      \"relOp\": \"org.apache.calcite.adapter.enumerable.EnumerableValues\",\n      \"type\": [\n        {\n          \"type\": \"INTEGER\",\n          \"nullable\": false,\n          \"name\": \"EXPR$0\"\n        },\n        {\n          \"type\": \"CHAR\",\n          \"nullable\": false,\n          \"precision\": 2,\n          \"name\": \"EXPR$1\"\n        }\n      ],\n      \"tuples\": [\n        [\n          1,\n          \"ab\"\n        ]\n      ],\n      \"inputs\": []\n    }\n  ]\n}\n");
        with.query("explain plan with implementation for values (1, 'ab')").returns("PLAN=EnumerableValues(tuples=[[{ 1, 'ab' }]])\n\n");
        with.query("explain plan without implementation for values (1, 'ab')").returns("PLAN=LogicalValues(tuples=[[{ 1, 'ab' }]])\n\n");
        with.query("explain plan with type for values (1, 'ab')").returns("PLAN=EXPR$0 INTEGER NOT NULL,\nEXPR$1 CHAR(2) NOT NULL\n");
    }

    @Test
    public void testDifferentTypesSameFields() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("TEST", (Schema)new ReflectiveSchema((Object)new MySchema()));
        Statement statement = calciteConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT \"myvalue\" from TEST.\"mytable2\"");
        Assert.assertEquals((Object)"myvalue=2\n", (Object)CalciteAssert.toString(resultSet));
        resultSet.close();
        statement.close();
        connection.close();
    }

    @Test
    public void testCurrentTimestamp() throws Exception {
        CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.TIME_ZONE, (Object)"GMT+1:00").doWithConnection(connection -> {
            try {
                PreparedStatement statement = connection.prepareStatement("VALUES CURRENT_TIMESTAMP");
                ResultSet resultSet = statement.executeQuery();
                Assert.assertTrue((boolean)resultSet.next());
                String s0 = resultSet.getString(1);
                Assert.assertFalse((boolean)resultSet.next());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                resultSet = statement.executeQuery();
                Assert.assertTrue((boolean)resultSet.next());
                String s1 = resultSet.getString(1);
                Assert.assertFalse((boolean)resultSet.next());
                Assert.assertTrue((String)("\ns0=" + s0 + "\ns1=" + s1 + "\n"), (s0.compareTo(s1) < 0 ? 1 : 0) != 0);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testGetTimestamp() throws Exception {
        CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.TIME_ZONE, (Object)"GMT+1:00").doWithConnection(connection -> {
            try {
                this.checkGetTimestamp((Connection)connection);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void checkGetTimestamp(Connection con) throws SQLException {
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery("SELECT * FROM (VALUES(\n TIMESTAMP '1970-01-01 00:00:00',\n /* TIMESTAMP '2005-01-01 15:00:00 +0300', */\n TIMESTAMP '2005-01-01 15:00:00',\n TIME '15:00:00',\n /* TIME '15:00:00 +0300', */\n DATE '2005-01-01'\n)) AS t(ts0, /* tstz, */ ts, t, /* tz, */ d)");
        Assert.assertTrue((boolean)rs.next());
        TimeZone tzUtc = TimeZone.getTimeZone("UTC");
        TimeZone tzGmt03 = TimeZone.getTimeZone("GMT+03");
        TimeZone tzGmt05 = TimeZone.getTimeZone("GMT-05");
        TimeZone tzGmt13 = TimeZone.getTimeZone("GMT+13");
        Calendar cUtc = Calendar.getInstance(tzUtc, Locale.ROOT);
        Calendar cGmt03 = Calendar.getInstance(tzGmt03, Locale.ROOT);
        Calendar cGmt05 = Calendar.getInstance(tzGmt05, Locale.ROOT);
        Calendar cGmt13 = Calendar.getInstance(tzGmt13, Locale.ROOT);
        int c = 1;
        Timestamp ts = rs.getTimestamp(c);
        Assert.assertEquals((long)-3600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)0L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)-10800000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)18000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)-46800000L, (long)ts.getTime());
        String s = rs.getString(c);
        Assert.assertEquals((Object)"1970-01-01 00:00:00", (Object)s);
        ts = rs.getTimestamp(++c);
        Assert.assertEquals((long)1104588000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)1104591600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)1104580800000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)1104609600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)1104544800000L, (long)ts.getTime());
        s = rs.getString(c);
        Assert.assertEquals((Object)"2005-01-01 15:00:00", (Object)s);
        ts = rs.getTimestamp(++c);
        Assert.assertEquals((long)50400000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)54000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)43200000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)72000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)0x6DDD00L, (long)ts.getTime());
        s = rs.getString(c);
        Assert.assertEquals((Object)"15:00:00", (Object)s);
        ts = rs.getTimestamp(++c);
        Assert.assertEquals((long)1104534000000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cUtc);
        Assert.assertEquals((long)1104537600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt03);
        Assert.assertEquals((long)1104526800000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt05);
        Assert.assertEquals((long)1104555600000L, (long)ts.getTime());
        ts = rs.getTimestamp(c, cGmt13);
        Assert.assertEquals((long)1104490800000L, (long)ts.getTime());
        s = rs.getString(c);
        Assert.assertEquals((Object)"2005-01-01", (Object)s);
        ++c;
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void testGetDate() throws Exception {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).doWithConnection(connection -> {
            try {
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery("select min(\"date\") mindate from \"foodmart\".\"currency\"");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)Date.valueOf("1997-01-01"), (Object)rs.getDate(1));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testGetDateAsString() throws Exception {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select min(\"date\") mindate from \"foodmart\".\"currency\"").returns2("MINDATE=1997-01-01\n");
    }

    @Test
    public void testGetTimestampObject() throws Exception {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).doWithConnection(connection -> {
            try {
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery("select \"hire_date\" from \"foodmart\".\"employee\" where \"employee_id\" = 1");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)Timestamp.valueOf("1994-12-01 00:00:00"), (Object)rs.getTimestamp(1));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testRowComparison() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_SCOTT).query("SELECT empno FROM JDBC_SCOTT.emp WHERE (ename, job) < ('Blake', 'Manager')").returnsUnordered("EMPNO=7876", "EMPNO=7499", "EMPNO=7698");
    }

    @Test
    public void testUnicode() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE);
        with.query("values _UTF16'\u82f1\u56fd'").returns("EXPR$0=\u82f1\u56fd\n");
        with.query("values U&'\\82F1\\56FD'").returns("EXPR$0=\u82f1\u56fd\n");
        with.query("values u&'\\82f1\\56fd'").returns("EXPR$0=\u82f1\u56fd\n");
        with.query("values '\u82f1\u56fd'").throws_("Failed to encode '\u82f1\u56fd' in character set 'ISO-8859-1'");
        with.query("select * from \"employee\" where \"full_name\" = '\u82f1\u56fd'").throws_("Failed to encode '\u82f1\u56fd' in character set 'ISO-8859-1'");
        with.query("select * from \"employee\" where \"full_name\" = _UTF16'\u82f1\u56fd'").throws_("Cannot apply = to the two different charsets ISO-8859-1 and UTF-16LE");
        with.query("select * from \"employee\"\nwhere convert(\"full_name\" using UTF16) = _UTF16'\u82f1\u56fd'").throws_("Column 'UTF16' not found in any table");
    }

    @Test
    public void testLexMySQL() throws Exception {
        CalciteAssert.that().with(Lex.MYSQL).doWithConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"`"));
                Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLexMySQLANSI() throws Exception {
        CalciteAssert.that().with(Lex.MYSQL_ANSI).doWithConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"\""));
                Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLexSqlServer() throws Exception {
        CalciteAssert.that().with(Lex.SQL_SERVER).doWithConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"["));
                Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLexOracle() throws Exception {
        CalciteAssert.that().with(Lex.ORACLE).doWithConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"\""));
                Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesUpperCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLexJava() throws Exception {
        CalciteAssert.that().with(Lex.JAVA).doWithConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"`"));
                Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesUpperCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLexOracleAsJava() throws Exception {
        CalciteAssert.that().with(Lex.ORACLE).with((ConnectionProperty)CalciteConnectionProperty.QUOTING, (Object)Quoting.BACK_TICK).with((ConnectionProperty)CalciteConnectionProperty.UNQUOTED_CASING, (Object)Casing.UNCHANGED).with((ConnectionProperty)CalciteConnectionProperty.QUOTED_CASING, (Object)Casing.UNCHANGED).with((ConnectionProperty)CalciteConnectionProperty.CASE_SENSITIVE, (Object)true).doWithConnection(connection -> {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                Assert.assertThat((Object)metaData.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)"`"));
                Assert.assertThat((Object)metaData.supportsMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesMixedCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesUpperCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.supportsMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)true));
                Assert.assertThat((Object)metaData.storesMixedCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesUpperCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
                Assert.assertThat((Object)metaData.storesLowerCaseQuotedIdentifiers(), (Matcher)CoreMatchers.equalTo((Object)false));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLexCaseInsensitive() {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(Lex.MYSQL);
        with.query("select COUNT(*) as c from metaData.tAbles").returns("c=2\n");
        with.query("select COUNT(*) as c from `metaData`.`tAbles`").returns("c=2\n");
        CalciteAssert.AssertThat with2 = CalciteAssert.that().with(Lex.JAVA);
        with2.query("select COUNT(*) as c from `metaData`.`tAbles`").throws_("Object 'metaData' not found; did you mean 'metadata'?");
        with2.query("select COUNT(*) as c from `metaData`.`TABLES`").throws_("Object 'metaData' not found; did you mean 'metadata'?");
        with2.query("select COUNT(*) as c from `metaData`.`tables`").throws_("Object 'metaData' not found; did you mean 'metadata'?");
        with2.query("select COUNT(*) as c from `metaData`.`nonExistent`").throws_("Object 'metaData' not found; did you mean 'metadata'?");
        with2.query("select COUNT(*) as c from `metadata`.`tAbles`").throws_("Object 'tAbles' not found within 'metadata'; did you mean 'TABLES'?");
    }

    @Test
    public void testLexCaseInsensitiveFindsNonexistentTable() {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(Lex.MYSQL);
        with.query("select COUNT(*) as c from `metaData`.`zoo`").throws_("Object 'zoo' not found within 'metadata'");
        with.query("select COUNT(*) as c from `metaData`.`tAbLes`").returns("c=2\n");
    }

    @Test
    public void testLexCaseInsensitiveSubQueryField() {
        CalciteAssert.that().with(Lex.MYSQL).query("select DID\nfrom (select deptid as did\n         FROM\n            ( values (1), (2) ) as T1(deptid)\n         ) ").returnsUnordered("DID=1", "DID=2");
    }

    @Test
    public void testLexCaseInsensitiveTableAlias() {
        CalciteAssert.that().with(Lex.MYSQL).query("select e.empno\nfrom (values (1, 2)) as E (empno, deptno),\n  (values (3, 4)) as d (deptno, name)").returnsUnordered("empno=1");
    }

    @Test
    public void testFunOracle() {
        CalciteAssert.that(CalciteAssert.Config.REGULAR).with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"oracle").query("select nvl(\"commission\", -99) as c from \"hr\".\"emps\"").returnsUnordered("C=-99", "C=1000", "C=250", "C=500");
        CalciteAssert.that(CalciteAssert.Config.REGULAR).query("select nvl(\"commission\", -99) as c from \"hr\".\"emps\"").throws_("No match found for function signature NVL(<NUMERIC>, <NUMERIC>)");
    }

    @Test
    public void testFunSpatial() {
        String sql = "select distinct\n  ST_PointFromText('POINT(-71.0642.28)') as c\nfrom \"hr\".\"emps\"";
        CalciteAssert.that(CalciteAssert.Config.REGULAR).with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"spatial").query("select distinct\n  ST_PointFromText('POINT(-71.0642.28)') as c\nfrom \"hr\".\"emps\"").returnsUnordered("C={\"x\":-71.0642,\"y\":0.28}");
        CalciteAssert.that(CalciteAssert.Config.REGULAR).query("select nvl(\"commission\", -99) as c from \"hr\".\"emps\"").throws_("No match found for function signature NVL(<NUMERIC>, <NUMERIC>)");
    }

    @Test
    public void testLateralJoin() {
        String sql = "SELECT *\nFROM AUX.SIMPLETABLE ST\nCROSS JOIN LATERAL TABLE(AUX.TBLFUN(ST.INTCOL))";
        CalciteAssert.that(CalciteAssert.Config.AUX).query("SELECT *\nFROM AUX.SIMPLETABLE ST\nCROSS JOIN LATERAL TABLE(AUX.TBLFUN(ST.INTCOL))").returnsUnordered("STRCOL=ABC; INTCOL=1; n=0; s=", "STRCOL=DEF; INTCOL=2; n=0; s=", "STRCOL=DEF; INTCOL=2; n=1; s=a", "STRCOL=GHI; INTCOL=3; n=0; s=", "STRCOL=GHI; INTCOL=3; n=1; s=a", "STRCOL=GHI; INTCOL=3; n=2; s=ab");
    }

    @Test
    public void testExpandViewWithLateralJoin() {
        String sql = "SELECT * FROM AUX.VIEWLATERAL";
        CalciteAssert.that(CalciteAssert.Config.AUX).query("SELECT * FROM AUX.VIEWLATERAL").returnsUnordered("STRCOL=ABC; INTCOL=1; n=0; s=", "STRCOL=DEF; INTCOL=2; n=0; s=", "STRCOL=DEF; INTCOL=2; n=1; s=a", "STRCOL=GHI; INTCOL=3; n=0; s=", "STRCOL=GHI; INTCOL=3; n=1; s=a", "STRCOL=GHI; INTCOL=3; n=2; s=ab");
    }

    @Test
    public void testHook() {
        int[] callCount = new int[]{0};
        try (Hook.Closeable ignored = Hook.PARSE_TREE.addThread(args -> {
            Assert.assertThat((Object)((Object[])args).length, (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat((Object)args[0], (Matcher)CoreMatchers.instanceOf(String.class));
            Assert.assertThat((Object)args[0], (Matcher)CoreMatchers.equalTo((Object)"select \"deptno\", \"commission\", sum(\"salary\") s\nfrom \"hr\".\"emps\"\ngroup by \"deptno\", \"commission\""));
            Assert.assertThat((Object)args[1], (Matcher)CoreMatchers.instanceOf(SqlSelect.class));
            callCount[0] = callCount[0] + 1;
        });){
            this.testSimple();
            Assert.assertThat((Object)callCount[0], (Matcher)CoreMatchers.equalTo((Object)0));
            this.testGroupByNull();
            Assert.assertThat((Object)callCount[0], (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    public void testDialect() {
        String[] sqls = new String[]{null};
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select count(*) as c from \"foodmart\".\"employee\" as e1\n  where \"first_name\" = 'abcde'\n  and \"gender\" = 'F'").withHook(Hook.QUERY_PLAN, sql -> {
            sqls[0] = sql;
        }).returns("C=0\n");
        switch (CalciteAssert.DB) {
            case HSQLDB: {
                Assert.assertThat((Object)sqls[0], Matchers.isLinux("SELECT COUNT(*) AS \"C\"\nFROM \"foodmart\".\"employee\"\nWHERE \"first_name\" = 'abcde' AND \"gender\" = 'F'"));
            }
        }
    }

    @Test
    public void testExplicitImplicitSchemaSameName() throws Exception {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false).plus();
        final HashMap<String, AbstractSchema> aSubSchemaMap = new HashMap<String, AbstractSchema>();
        SchemaPlus aSchema = rootSchema.add("a", (Schema)new AbstractSchema(){

            protected Map<String, Schema> getSubSchemaMap() {
                return aSubSchemaMap;
            }
        });
        aSchema.add("b", (Schema)new AbstractSchema());
        aSubSchemaMap.put("b", new AbstractSchema());
        aSchema.setCacheEnabled(true);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSimpleCalciteSchema() throws Exception {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        final HashMap<String, AbstractSchema> aSubSchemaMap = new HashMap<String, AbstractSchema>();
        SchemaPlus aSchema = rootSchema.add("a", (Schema)new AbstractSchema(){

            protected Map<String, Schema> getSubSchemaMap() {
                return aSubSchemaMap;
            }
        });
        aSchema.add("b", (Schema)new AbstractSchema());
        aSubSchemaMap.put("c", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchema("c"), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)aSchema.getSubSchema("b"), (Matcher)CoreMatchers.notNullValue());
        aSubSchemaMap.put("b", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testSimpleCalciteSchemaWithView() throws Exception {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        LinkedListMultimap functionMap = LinkedListMultimap.create();
        SchemaPlus aSchema = rootSchema.add("a", (Schema)new AbstractSchema((Multimap)functionMap){
            final /* synthetic */ Multimap val$functionMap;
            {
                this.val$functionMap = multimap;
            }

            protected Multimap<String, Function> getFunctionMultimap() {
                return this.val$functionMap;
            }
        });
        String viewName = "V";
        ViewTableMacro view = ViewTable.viewMacro((SchemaPlus)rootSchema.getSubSchema("a"), (String)"values('1', '2')", null, null, (Boolean)false);
        functionMap.put((Object)"V", (Object)view);
        CalciteSchema calciteSchema = CalciteSchema.from((SchemaPlus)aSchema);
        Assert.assertThat((Object)calciteSchema.getTableBasedOnNullaryFunction("V", true), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)calciteSchema.getTableBasedOnNullaryFunction("V", false), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)calciteSchema.getTableBasedOnNullaryFunction("V1", true), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)calciteSchema.getTableBasedOnNullaryFunction("V1", false), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)calciteSchema.getFunctions("V", true), (Matcher)CoreMatchers.hasItem((Object)view));
        Assert.assertThat((Object)calciteSchema.getFunctions("V", false), (Matcher)CoreMatchers.hasItem((Object)view));
        Assert.assertThat((Object)calciteSchema.getFunctions("V1", true), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)view)));
        Assert.assertThat((Object)calciteSchema.getFunctions("V1", false), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)view)));
    }

    @Test
    public void testSchemaCaching() throws Exception {
        Connection connection = CalciteAssert.that(CalciteAssert.Config.JDBC_FOODMART).connect();
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        final HashMap<String, AbstractSchema> aSubSchemaMap = new HashMap<String, AbstractSchema>();
        SchemaPlus aSchema = rootSchema.add("a", (Schema)new AbstractSchema(){

            protected Map<String, Schema> getSubSchemaMap() {
                return aSubSchemaMap;
            }
        });
        aSchema.setCacheEnabled(true);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        aSubSchemaMap.put("b1", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)aSchema.getSubSchema("b1"), (Matcher)CoreMatchers.nullValue());
        aSchema.setCacheEnabled(false);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)aSchema.getSubSchema("b1"), (Matcher)CoreMatchers.notNullValue());
        aSubSchemaMap.put("b2", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)2));
        aSchema.setCacheEnabled(true);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)2));
        aSchema.add("b3", (Schema)new AbstractSchema());
        aSubSchemaMap.put("b4", new AbstractSchema());
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)3));
        aSchema.setCacheEnabled(false);
        Assert.assertThat((Object)aSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)4));
        for (String name : aSchema.getSubSchemaNames()) {
            Assert.assertThat((Object)aSchema.getSubSchema(name), (Matcher)CoreMatchers.notNullValue());
        }
        final HashMap<String, AbstractSchema> a2SubSchemaMap = new HashMap<String, AbstractSchema>();
        SchemaPlus a2Schema = rootSchema.add("a", (Schema)new AbstractSchema(){

            protected Map<String, Schema> getSubSchemaMap() {
                return a2SubSchemaMap;
            }
        });
        a2Schema.setCacheEnabled(true);
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        a2SubSchemaMap.put("b3", new AbstractSchema());
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        Thread.sleep(1L);
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)0));
        a2Schema.setCacheEnabled(false);
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)1));
        a2SubSchemaMap.put("b4", new AbstractSchema());
        Assert.assertThat((Object)a2Schema.getSubSchemaNames().size(), (Matcher)CoreMatchers.is((Object)2));
        for (String name : aSchema.getSubSchemaNames()) {
            Assert.assertThat((Object)aSchema.getSubSchema(name), (Matcher)CoreMatchers.notNullValue());
        }
        TableInRootSchemaTest.SimpleTable table = new TableInRootSchemaTest.SimpleTable();
        a2Schema.add("table1", (Table)table);
        a2Schema.add("TABLE1", (Table)table);
        a2Schema.add("tabLe1", (Table)table);
        a2Schema.add("tabLe2", (Table)table);
        Assert.assertThat((Object)a2Schema.getTableNames().size(), (Matcher)CoreMatchers.equalTo((Object)4));
        CalciteSchema a2CalciteSchema = CalciteSchema.from((SchemaPlus)a2Schema);
        Assert.assertThat((Object)a2CalciteSchema.getTable("table1", true), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)a2CalciteSchema.getTable("table1", false), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)a2CalciteSchema.getTable("taBle1", true), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)a2CalciteSchema.getTable("taBle1", false), (Matcher)CoreMatchers.notNullValue());
        ViewTableMacro function = ViewTable.viewMacro((SchemaPlus)a2Schema, (String)"values 1", null, null, null);
        Util.discard((Object)function);
        connection.close();
    }

    @Test
    public void testCaseSensitiveSubQueryOracle() {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(Lex.ORACLE);
        with.query("select DID from (select DEPTID as did FROM\n     ( values (1), (2) ) as T1(deptid) ) ").returnsUnordered("DID=1", "DID=2");
        with.query("select x.DID from (select DEPTID as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X").returnsUnordered("DID=1", "DID=2");
    }

    @Test
    public void testUnquotedCaseSensitiveSubQueryMySql() {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(Lex.MYSQL);
        with.query("select DID from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) ").returnsUnordered("DID=1", "DID=2");
        with.query("select x.DID from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X ").returnsUnordered("DID=1", "DID=2");
        with.query("select X.DID from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X ").returnsUnordered("DID=1", "DID=2");
        with.query("select X.DID2 from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X (DID2)").returnsUnordered("DID2=1", "DID2=2");
        with.query("select X.DID2 from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X (DID2)").returnsUnordered("DID2=1", "DID2=2");
    }

    @Test
    public void testQuotedCaseSensitiveSubQueryMySql() {
        CalciteAssert.AssertThat with = CalciteAssert.that().with(Lex.MYSQL);
        with.query("select `DID` from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) ").returnsUnordered("DID=1", "DID=2");
        with.query("select `x`.`DID` from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X ").returnsUnordered("DID=1", "DID=2");
        with.query("select `X`.`DID` from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X ").returnsUnordered("DID=1", "DID=2");
        with.query("select `X`.`DID2` from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X (DID2)").returnsUnordered("DID2=1", "DID2=2");
        with.query("select `X`.`DID2` from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) X (DID2)").returnsUnordered("DID2=1", "DID2=2");
    }

    @Test
    public void testUnquotedCaseSensitiveSubQuerySqlServer() {
        CalciteAssert.that().with(Lex.SQL_SERVER).query("select DID from (select deptid as did FROM\n     ( values (1), (2) ) as T1(deptid) ) ").returnsUnordered("DID=1", "DID=2");
    }

    @Test
    public void testQuotedCaseSensitiveSubQuerySqlServer() {
        CalciteAssert.that().with(Lex.SQL_SERVER).query("select [DID] from (select deptid as did FROM\n     ( values (1), (2) ) as T1([deptid]) ) ").returnsUnordered("DID=1", "DID=2");
    }

    @Test
    public void testPrimitiveColumnsWithNullValues() throws Exception {
        String hsqldbMemUrl = "jdbc:hsqldb:mem:.";
        Connection baseConnection = DriverManager.getConnection(hsqldbMemUrl);
        Statement baseStmt = baseConnection.createStatement();
        baseStmt.execute("CREATE TABLE T1 (\nID INTEGER,\nVALS DOUBLE)");
        baseStmt.execute("INSERT INTO T1 VALUES (1, 1.0)");
        baseStmt.execute("INSERT INTO T1 VALUES (2, null)");
        baseStmt.execute("INSERT INTO T1 VALUES (null, 2.0)");
        baseStmt.close();
        baseConnection.commit();
        Properties info = new Properties();
        info.put("model", "inline:{\n  version: '1.0',\n  defaultSchema: 'BASEJDBC',\n  schemas: [\n     {\n       type: 'jdbc',\n       name: 'BASEJDBC',\n       jdbcDriver: '" + jdbcDriver.class.getName() + "',\n       jdbcUrl: '" + hsqldbMemUrl + "',\n       jdbcCatalog: null,\n       jdbcSchema: null\n     }\n  ]\n}");
        Connection calciteConnection = DriverManager.getConnection("jdbc:calcite:", info);
        ResultSet rs = calciteConnection.prepareStatement("select * from t1").executeQuery();
        Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Integer)rs.getObject("ID")), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Double)rs.getObject("VALS")), (Matcher)CoreMatchers.equalTo((Object)1.0));
        Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Integer)rs.getObject("ID")), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)rs.getObject("VALS"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)rs.getObject("ID"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)((Double)rs.getObject("VALS")), (Matcher)CoreMatchers.equalTo((Object)2.0));
        rs.close();
        calciteConnection.close();
    }

    @Test
    public void testUpdateBind() throws Exception {
        String hsqldbMemUrl = "jdbc:hsqldb:mem:.";
        try (Connection baseConnection = DriverManager.getConnection(hsqldbMemUrl);
             Statement baseStmt = baseConnection.createStatement();){
            baseStmt.execute("CREATE TABLE T2 (\nID INTEGER,\nVALS DOUBLE)");
            baseStmt.execute("INSERT INTO T2 VALUES (1, 1.0)");
            baseStmt.execute("INSERT INTO T2 VALUES (2, null)");
            baseStmt.execute("INSERT INTO T2 VALUES (null, 2.0)");
            baseStmt.close();
            baseConnection.commit();
            Properties info = new Properties();
            String model = "inline:{\n  version: '1.0',\n  defaultSchema: 'BASEJDBC',\n  schemas: [\n     {\n       type: 'jdbc',\n       name: 'BASEJDBC',\n       jdbcDriver: '" + jdbcDriver.class.getName() + "',\n       jdbcUrl: '" + hsqldbMemUrl + "',\n       jdbcCatalog: null,\n       jdbcSchema: null\n     }\n  ]\n}";
            info.put("model", model);
            Connection calciteConnection = DriverManager.getConnection("jdbc:calcite:", info);
            ResultSet rs = calciteConnection.prepareStatement("select * from t2").executeQuery();
            Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)((Integer)rs.getObject("ID")), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)((Double)rs.getObject("VALS")), (Matcher)CoreMatchers.is((Object)1.0));
            Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)((Integer)rs.getObject("ID")), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)rs.getObject("VALS"), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)rs.getObject("ID"), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)((Double)rs.getObject("VALS")), (Matcher)CoreMatchers.equalTo((Object)2.0));
            rs.close();
            String sql = "update t2 set vals=? where id=?";
            try (PreparedStatement ps = calciteConnection.prepareStatement("update t2 set vals=? where id=?");){
                ParameterMetaData pmd = ps.getParameterMetaData();
                Assert.assertThat((Object)pmd.getParameterCount(), (Matcher)CoreMatchers.is((Object)2));
                Assert.assertThat((Object)pmd.getParameterType(1), (Matcher)CoreMatchers.is((Object)8));
                Assert.assertThat((Object)pmd.getParameterType(2), (Matcher)CoreMatchers.is((Object)4));
                ps.close();
            }
            calciteConnection.close();
        }
    }

    @Test
    public void testNullableNumericColumnInCloneSchema() {
        CalciteAssert.model("{\n  version: '1.0',\n  defaultSchema: 'SCOTT_CLONE',\n  schemas: [ {\n    name: 'SCOTT_CLONE',\n    type: 'custom',\n    factory: 'org.apache.calcite.adapter.clone.CloneSchema$Factory',\n    operand: {\n      jdbcDriver: '" + JdbcTest.SCOTT.driver + "',\n      jdbcUser: '" + JdbcTest.SCOTT.username + "',\n      jdbcPassword: '" + JdbcTest.SCOTT.password + "',\n      jdbcUrl: '" + JdbcTest.SCOTT.url + "',\n      jdbcSchema: 'SCOTT'\n   } } ]\n}").query("select * from emp").returns(input -> {
            StringBuilder buf = new StringBuilder();
            try {
                int columnCount = input.getMetaData().getColumnCount();
                while (input.next()) {
                    for (int i = 0; i < columnCount; ++i) {
                        buf.append(input.getObject(i + 1));
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testAggMultipleMeasures() throws SQLException {
        org.apache.calcite.jdbc.Driver driver = new org.apache.calcite.jdbc.Driver();
        CalciteConnection connection = (CalciteConnection)driver.connect("jdbc:calcite:", new Properties());
        SchemaPlus rootSchema = connection.getRootSchema();
        rootSchema.add("sale", (Schema)new ReflectiveSchema((Object)new Smalls.WideSaleSchema()));
        connection.setSchema("sale");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select s.\"prodId\"" + JdbcTest.sums(200, true) + "\nfrom \"sale\".\"prod\" as s group by s.\"prodId\"\n");
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)resultSet.getInt(200), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        int n = 800;
        resultSet = statement.executeQuery("select s.\"prodId\"" + JdbcTest.sums(800, false) + "\nfrom \"sale\".\"prod\" as s group by s.\"prodId\"\n");
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)resultSet.getInt(800), (Matcher)CoreMatchers.is((Object)808));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        connection.close();
    }

    @Test
    public void testWithinGroupClause1() {
        String sql = "select X,\n collect(Y) within group (order by Y desc) as \"SET\"\nfrom (values (1, 'a'), (1, 'b'),\n             (3, 'c'), (3, 'd')) AS t(X, Y)\ngroup by X\nlimit 10";
        CalciteAssert.that().query("select X,\n collect(Y) within group (order by Y desc) as \"SET\"\nfrom (values (1, 'a'), (1, 'b'),\n             (3, 'c'), (3, 'd')) AS t(X, Y)\ngroup by X\nlimit 10").returnsUnordered("X=1; SET=[b, a]", "X=3; SET=[d, c]");
    }

    @Test
    public void testWithinGroupClause2() {
        String sql = "select X,\n collect(Y) within group (order by Y desc) as SET_1,\n collect(Y) within group (order by Y asc) as SET_2\nfrom (values (1, 'a'), (1, 'b'), (3, 'c'), (3, 'd')) AS t(X, Y)\ngroup by X\nlimit 10";
        CalciteAssert.that().query("select X,\n collect(Y) within group (order by Y desc) as SET_1,\n collect(Y) within group (order by Y asc) as SET_2\nfrom (values (1, 'a'), (1, 'b'), (3, 'c'), (3, 'd')) AS t(X, Y)\ngroup by X\nlimit 10").returnsUnordered("X=1; SET_1=[b, a]; SET_2=[a, b]", "X=3; SET_1=[d, c]; SET_2=[c, d]");
    }

    @Test
    public void testWithinGroupClause3() {
        String sql = "select collect(Y) within group (order by Y desc) as SET_1,\n collect(Y) within group (order by Y asc) as SET_2\nfrom (values (1, 'a'), (1, 'b'), (3, 'c'), (3, 'd')) AS t(X, Y)\nlimit 10";
        CalciteAssert.that().query("select collect(Y) within group (order by Y desc) as SET_1,\n collect(Y) within group (order by Y asc) as SET_2\nfrom (values (1, 'a'), (1, 'b'), (3, 'c'), (3, 'd')) AS t(X, Y)\nlimit 10").returns("SET_1=[d, c, b, a]; SET_2=[a, b, c, d]\n");
    }

    @Test
    public void testWithinGroupClause4() {
        String sql = "select collect(Y) within group (order by Y desc) as SET_1,\n collect(Y) within group (order by Y asc) as SET_2\nfrom (values (1, 'a'), (1, 'b'), (3, 'c'), (3, 'd')) AS t(X, Y)\ngroup by X\nlimit 10";
        CalciteAssert.that().query("select collect(Y) within group (order by Y desc) as SET_1,\n collect(Y) within group (order by Y asc) as SET_2\nfrom (values (1, 'a'), (1, 'b'), (3, 'c'), (3, 'd')) AS t(X, Y)\ngroup by X\nlimit 10").returnsUnordered("SET_1=[b, a]; SET_2=[a, b]", "SET_1=[d, c]; SET_2=[c, d]");
    }

    @Test
    public void testWithinGroupClause5() {
        CalciteAssert.that().query("select collect(array[X, Y])\n within group (order by Y desc) as \"SET\"\nfrom (values ('b', 'a'), ('a', 'b'), ('a', 'c'),\n             ('a', 'd')) AS t(X, Y)\nlimit 10").returns("SET=[[a, d], [a, c], [a, b], [b, a]]\n");
    }

    @Test
    public void testWithinGroupClause6() {
        String sql = "select collect(\"commission\") within group (order by \"commission\")\nfrom \"hr\".\"emps\"";
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR).query("select collect(\"commission\") within group (order by \"commission\")\nfrom \"hr\".\"emps\"").explainContains("EnumerableAggregate(group=[{}], EXPR$0=[COLLECT($4) WITHIN GROUP ([4])])").returns("EXPR$0=[250, 500, 1000]\n");
    }

    @Test
    public void testQueryWithParameter() throws Exception {
        String hsqldbMemUrl = "jdbc:hsqldb:mem:.";
        try (Connection baseConnection = DriverManager.getConnection(hsqldbMemUrl);
             Statement baseStmt = baseConnection.createStatement();){
            baseStmt.execute("CREATE TABLE T3 (\nID INTEGER,\nVALS DOUBLE)");
            baseStmt.execute("INSERT INTO T3 VALUES (1, 1.0)");
            baseStmt.execute("INSERT INTO T3 VALUES (2, null)");
            baseStmt.execute("INSERT INTO T3 VALUES (null, 2.0)");
            baseStmt.close();
            baseConnection.commit();
            Properties info = new Properties();
            String model = "inline:{\n  version: '1.0',\n  defaultSchema: 'BASEJDBC',\n  schemas: [\n     {\n       type: 'jdbc',\n       name: 'BASEJDBC',\n       jdbcDriver: '" + jdbcDriver.class.getName() + "',\n       jdbcUrl: '" + hsqldbMemUrl + "',\n       jdbcCatalog: null,\n       jdbcSchema: null\n     }\n  ]\n}";
            info.put("model", model);
            Connection calciteConnection = DriverManager.getConnection("jdbc:calcite:", info);
            String sql = "select * from t3 where vals = ?";
            try (PreparedStatement ps = calciteConnection.prepareStatement("select * from t3 where vals = ?");){
                ParameterMetaData pmd = ps.getParameterMetaData();
                Assert.assertThat((Object)pmd.getParameterCount(), (Matcher)CoreMatchers.is((Object)1));
                Assert.assertThat((Object)pmd.getParameterType(1), (Matcher)CoreMatchers.is((Object)8));
                ps.setDouble(1, 1.0);
                ps.executeQuery();
            }
            calciteConnection.close();
        }
    }

    private static String sums(int n, boolean c) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (c) {
                b.append(", sum(s.\"sale").append(i).append("\")");
                continue;
            }
            b.append(", sum(s.\"sale").append(i % 100).append("\"").append(" + ").append(i).append(")");
        }
        return b.toString();
    }

    public static class MySchema {
        public MyTable[] mytable = new MyTable[]{new MyTable()};
        public MyTable2[] mytable2 = new MyTable2[]{new MyTable2()};
    }

    public static class MyTable2 {
        public String mykey = "foo";
        public Integer myvalue = 2;
    }

    public static class MyTable {
        public String mykey = "foo";
        public Integer myvalue = 1;
    }

    public static class MockDdlDriver
    extends org.apache.calcite.jdbc.Driver {
        public int counter;

        protected Function0<CalcitePrepare> createPrepareFactory() {
            return new Function0<CalcitePrepare>(){

                public CalcitePrepare apply() {
                    return new CalcitePrepareImpl(){

                        protected SqlParser.ConfigBuilder createParserConfig() {
                            return super.createParserConfig().setParserFactory(stream -> new SqlParserImpl(stream){

                                public SqlNode parseSqlStmtEof() {
                                    return new SqlCall(SqlParserPos.ZERO){

                                        public SqlOperator getOperator() {
                                            return new SqlSpecialOperator("COMMIT", SqlKind.COMMIT);
                                        }

                                        public List<SqlNode> getOperandList() {
                                            return ImmutableList.of();
                                        }
                                    };
                                }
                            });
                        }

                        public void executeDdl(CalcitePrepare.Context context, SqlNode node) {
                            ++counter;
                        }
                    };
                }
            };
        }
    }

    public static class HandlerDriver
    extends org.apache.calcite.jdbc.Driver {
        private static final TryThreadLocal<Handler> HANDLERS = TryThreadLocal.of(null);

        protected Handler createHandler() {
            return (Handler)HANDLERS.get();
        }
    }

    public static class AutoTempDriver
    extends org.apache.calcite.jdbc.Driver {
        private final List<Object> results;

        AutoTempDriver(List<Object> results) {
            this.results = results;
        }

        protected Handler createHandler() {
            return new HandlerImpl(){

                public void onStatementExecute(AvaticaStatement statement, Handler.ResultSink resultSink) {
                    super.onStatementExecute(statement, resultSink);
                    results.add(resultSink);
                }
            };
        }
    }

    public static class MySchemaFactory
    implements SchemaFactory {
        public Schema create(SchemaPlus parentSchema, String name, final Map<String, Object> operand) {
            final boolean mutable = SqlFunctions.isNotFalse((Boolean)((Boolean)operand.get("mutable")));
            return new ReflectiveSchema(new HrSchema()){

                protected Map<String, Table> getTableMap() {
                    Map tableMap = super.getTableMap();
                    Table table = (Table)tableMap.get("emps");
                    String tableName = (String)operand.get("tableName");
                    return FlatLists.append((Map)tableMap, (Object)tableName, (Object)table);
                }

                public boolean isMutable() {
                    return mutable;
                }
            };
        }
    }

    public static class EmpDeptTableFactory
    implements TableFactory<Table> {
        public static final TryThreadLocal<List<Employee>> THREAD_COLLECTION = TryThreadLocal.of(null);

        public Table create(SchemaPlus schema, String name, Map<String, Object> operand, RelDataType rowType) {
            Object[] array;
            Class clazz;
            switch (name) {
                case "EMPLOYEES": {
                    clazz = Employee.class;
                    array = new HrSchema().emps;
                    break;
                }
                case "MUTABLE_EMPLOYEES": {
                    List<Employee> employees = (List<Employee>)THREAD_COLLECTION.get();
                    if (employees == null) {
                        employees = Collections.emptyList();
                    }
                    return JdbcFrontLinqBackTest.mutable(name, employees);
                }
                case "DEPARTMENTS": {
                    clazz = Department.class;
                    array = new HrSchema().depts;
                    break;
                }
                default: {
                    throw new AssertionError((Object)name);
                }
            }
            return new AbstractQueryableTable((Type)((Object)clazz)){

                public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                    return ((JavaTypeFactory)typeFactory).createType((Type)clazz);
                }

                public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                    return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                        public Enumerator<T> enumerator() {
                            List<Object> list = Arrays.asList(array);
                            return Linq4j.enumerator(list);
                        }
                    };
                }
            };
        }
    }

    public static abstract class AbstractModifiableView
    extends AbstractTable
    implements ModifiableView {
        protected AbstractModifiableView() {
        }
    }

    public static abstract class AbstractModifiableTable
    extends AbstractTable
    implements ModifiableTable {
        protected AbstractModifiableTable(String tableName) {
        }

        public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
            return LogicalTableModify.create((RelOptTable)table, (Prepare.CatalogReader)catalogReader, (RelNode)child, (TableModify.Operation)operation, updateColumnList, sourceExpressionList, (boolean)flattened);
        }
    }

    public static class SalesFact {
        public final int cust_id;
        public final int prod_id;

        public SalesFact(int cust_id, int prod_id) {
            this.cust_id = cust_id;
            this.prod_id = prod_id;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SalesFact && this.cust_id == ((SalesFact)obj).cust_id && this.prod_id == ((SalesFact)obj).prod_id;
        }
    }

    public static class Customer {
        public final int customer_id;

        public Customer(int customer_id) {
            this.customer_id = customer_id;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Customer && this.customer_id == ((Customer)obj).customer_id;
        }
    }

    public static class FoodmartJdbcSchema
    extends JdbcSchema {
        public final Table customer = this.getTable("customer");

        public FoodmartJdbcSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, String catalog, String schema) {
            super(dataSource, dialect, convention, catalog, schema);
        }
    }

    public static class LingualEmp {
        public final int EMPNO;
        public final int DEPTNO;

        public LingualEmp(int EMPNO, int DEPTNO) {
            this.EMPNO = EMPNO;
            this.DEPTNO = DEPTNO;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof LingualEmp && this.EMPNO == ((LingualEmp)obj).EMPNO;
        }
    }

    public static class LingualSchema {
        public final LingualEmp[] EMPS = new LingualEmp[]{new LingualEmp(1, 10), new LingualEmp(2, 30)};
    }

    public static class FoodmartSchema {
        public final SalesFact[] sales_fact_1997 = new SalesFact[]{new SalesFact(100, 10), new SalesFact(150, 20)};
    }

    public static class Event {
        public final int eventid;
        public final Timestamp ts;

        public Event(int eventid, Timestamp ts) {
            this.eventid = eventid;
            this.ts = ts;
        }

        public String toString() {
            return "Event [eventid: " + this.eventid + ", ts: " + this.ts + "]";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Event && this.eventid == ((Event)obj).eventid;
        }
    }

    public static class Dependent {
        public final int empid;
        public final String name;

        public Dependent(int empid, String name) {
            this.empid = empid;
            this.name = name;
        }

        public String toString() {
            return "Dependent [empid: " + this.empid + ", name: " + this.name + "]";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Dependent && this.empid == ((Dependent)obj).empid && Objects.equals(this.name, ((Dependent)obj).name);
        }
    }

    public static class Location {
        public final int x;
        public final int y;

        public Location(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "Location [x: " + this.x + ", y: " + this.y + "]";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Location && this.x == ((Location)obj).x && this.y == ((Location)obj).y;
        }
    }

    public static class Department {
        public final int deptno;
        public final String name;
        @org.apache.calcite.adapter.java.Array(component=Employee.class)
        public final List<Employee> employees;
        public final Location location;

        public Department(int deptno, String name, List<Employee> employees, Location location) {
            this.deptno = deptno;
            this.name = name;
            this.employees = employees;
            this.location = location;
        }

        public String toString() {
            return "Department [deptno: " + this.deptno + ", name: " + this.name + ", employees: " + this.employees + ", location: " + this.location + "]";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Department && this.deptno == ((Department)obj).deptno;
        }
    }

    public static class Employee {
        public final int empid;
        public final int deptno;
        public final String name;
        public final float salary;
        public final Integer commission;

        public Employee(int empid, int deptno, String name, float salary, Integer commission) {
            this.empid = empid;
            this.deptno = deptno;
            this.name = name;
            this.salary = salary;
            this.commission = commission;
        }

        public String toString() {
            return "Employee [empid: " + this.empid + ", deptno: " + this.deptno + ", name: " + this.name + "]";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Employee && this.empid == ((Employee)obj).empid;
        }
    }

    public static class HrSchema {
        public final Employee[] emps = new Employee[]{new Employee(100, 10, "Bill", 10000.0f, 1000), new Employee(200, 20, "Eric", 8000.0f, 500), new Employee(150, 10, "Sebastian", 7000.0f, null), new Employee(110, 10, "Theodore", 11500.0f, 250)};
        public final Department[] depts = new Department[]{new Department(10, "Sales", Arrays.asList(this.emps[0], this.emps[2]), new Location(-122, 38)), new Department(30, "Marketing", (List<Employee>)ImmutableList.of(), new Location(0, 52)), new Department(40, "HR", Collections.singletonList(this.emps[1]), null)};
        public final Dependent[] dependents = new Dependent[]{new Dependent(10, "Michael"), new Dependent(10, "Jane")};
        public final Dependent[] locations = new Dependent[]{new Dependent(10, "San Francisco"), new Dependent(20, "San Diego")};

        public String toString() {
            return "HrSchema";
        }

        public QueryableTable foo(int count) {
            return Smalls.generateStrings(count);
        }

        public TranslatableTable view(String s) {
            return Smalls.view(s);
        }
    }
}

