/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.generate;

import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TableFactory;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;

public class RangeTable
extends AbstractQueryableTable {
    private final String columnName;
    private final int start;
    private final int end;

    protected RangeTable(Class<?> elementType, String columnName, int start, int end) {
        super(elementType);
        this.columnName = columnName;
        this.start = start;
        this.end = end;
    }

    public static RangeTable create(Class<?> elementType, String columnName, int start, int end) {
        return new RangeTable(elementType, columnName, start, end);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return typeFactory.builder().add(this.columnName, SqlTypeName.INTEGER).build();
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                return RangeTable.this.enumerator();
            }
        };
    }

    public Enumerator<Integer> enumerator() {
        return new Enumerator<Integer>(){
            int current;
            {
                this.current = RangeTable.this.start - 1;
            }

            public Integer current() {
                if (this.current >= RangeTable.this.end) {
                    throw new NoSuchElementException();
                }
                return this.current;
            }

            public boolean moveNext() {
                ++this.current;
                return this.current < RangeTable.this.end;
            }

            public void reset() {
                this.current = RangeTable.this.start - 1;
            }

            public void close() {
            }
        };
    }

    public static class Factory
    implements TableFactory<RangeTable> {
        public RangeTable create(SchemaPlus schema, String name, Map<String, Object> operand, RelDataType rowType) {
            Class type;
            String columnName = (String)operand.get("column");
            int start = (Integer)operand.get("start");
            int end = (Integer)operand.get("end");
            String elementType = (String)operand.get("elementType");
            if ("array".equals(elementType)) {
                type = Object[].class;
            } else if ("object".equals(elementType)) {
                type = Object.class;
            } else if ("integer".equals(elementType)) {
                type = Integer.class;
            } else {
                throw new IllegalArgumentException("Illegal 'elementType' value: " + elementType);
            }
            return RangeTable.create(type, columnName, start, end);
        }
    }
}

