/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.calcite.adapter.enumerable.AggAddContext;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggResetContext;
import org.apache.calcite.adapter.enumerable.AggResultContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.StrictAggImplementor;
import org.apache.calcite.adapter.enumerable.StrictWinAggImplementor;
import org.apache.calcite.adapter.enumerable.WinAggAddContext;
import org.apache.calcite.adapter.enumerable.WinAggContext;
import org.apache.calcite.adapter.enumerable.WinAggImplementor;
import org.apache.calcite.adapter.enumerable.WinAggResultContext;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.OptimizeShuttle;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ImplementableAggFunction;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlJsonArrayAggAggFunction;
import org.apache.calcite.sql.fun.SqlJsonObjectAggAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;

public class RexImpTable {
    public static final ConstantExpression NULL_EXPR = Expressions.constant(null);
    public static final ConstantExpression FALSE_EXPR = Expressions.constant((Object)false);
    public static final ConstantExpression TRUE_EXPR = Expressions.constant((Object)true);
    public static final MemberExpression BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, (String)"FALSE");
    public static final MemberExpression BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, (String)"TRUE");
    private final Map<SqlOperator, CallImplementor> map = new HashMap<SqlOperator, CallImplementor>();
    private final Map<SqlAggFunction, Supplier<? extends AggImplementor>> aggMap = new HashMap<SqlAggFunction, Supplier<? extends AggImplementor>>();
    private final Map<SqlAggFunction, Supplier<? extends WinAggImplementor>> winAggMap = new HashMap<SqlAggFunction, Supplier<? extends WinAggImplementor>>();
    public static final RexImpTable INSTANCE = new RexImpTable();

    RexImpTable() {
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ROW, BuiltInMethod.ARRAY.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.UPPER, BuiltInMethod.UPPER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOWER, BuiltInMethod.LOWER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.INITCAP, BuiltInMethod.INITCAP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SUBSTRING, BuiltInMethod.SUBSTRING.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.REPLACE, BuiltInMethod.REPLACE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)OracleSqlOperatorTable.TRANSLATE3, BuiltInMethod.TRANSLATE3.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CONCAT, BuiltInMethod.STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.OVERLAY, BuiltInMethod.OVERLAY.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POSITION, BuiltInMethod.POSITION.method, NullPolicy.STRICT);
        TrimImplementor trimImplementor = new TrimImplementor();
        this.defineImplementor(SqlStdOperatorTable.TRIM, NullPolicy.STRICT, trimImplementor, false);
        this.defineBinary(SqlStdOperatorTable.AND, ExpressionType.AndAlso, NullPolicy.AND, null);
        this.defineBinary(SqlStdOperatorTable.OR, ExpressionType.OrElse, NullPolicy.OR, null);
        this.defineUnary(SqlStdOperatorTable.NOT, ExpressionType.Not, NullPolicy.NOT);
        this.defineBinary(SqlStdOperatorTable.LESS_THAN, ExpressionType.LessThan, NullPolicy.STRICT, "lt");
        this.defineBinary(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ExpressionType.LessThanOrEqual, NullPolicy.STRICT, "le");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN, ExpressionType.GreaterThan, NullPolicy.STRICT, "gt");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ExpressionType.GreaterThanOrEqual, NullPolicy.STRICT, "ge");
        this.defineBinary(SqlStdOperatorTable.EQUALS, ExpressionType.Equal, NullPolicy.STRICT, "eq");
        this.defineBinary(SqlStdOperatorTable.NOT_EQUALS, ExpressionType.NotEqual, NullPolicy.STRICT, "ne");
        this.defineBinary(SqlStdOperatorTable.PLUS, ExpressionType.Add, NullPolicy.STRICT, "plus");
        this.defineBinary(SqlStdOperatorTable.MINUS, ExpressionType.Subtract, NullPolicy.STRICT, "minus");
        this.defineBinary(SqlStdOperatorTable.MULTIPLY, ExpressionType.Multiply, NullPolicy.STRICT, "multiply");
        this.defineBinary(SqlStdOperatorTable.DIVIDE, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineBinary(SqlStdOperatorTable.DIVIDE_INTEGER, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineUnary(SqlStdOperatorTable.UNARY_MINUS, ExpressionType.Negate, NullPolicy.STRICT);
        this.defineUnary(SqlStdOperatorTable.UNARY_PLUS, ExpressionType.UnaryPlus, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MOD, "mod", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXP, "exp", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POWER, "power", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LN, "ln", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOG10, "log10", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ABS, "abs", NullPolicy.STRICT);
        this.defineImplementor(SqlStdOperatorTable.RAND, NullPolicy.STRICT, new NotNullImplementor(){
            final NotNullImplementor[] implementors;
            {
                this.implementors = new NotNullImplementor[]{new ReflectiveCallNotNullImplementor(BuiltInMethod.RAND.method), new ReflectiveCallNotNullImplementor(BuiltInMethod.RAND_SEED.method)};
            }

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                return this.implementors[call.getOperands().size()].implement(translator, call, translatedOperands);
            }
        }, false);
        this.defineImplementor(SqlStdOperatorTable.RAND_INTEGER, NullPolicy.STRICT, new NotNullImplementor(){
            final NotNullImplementor[] implementors;
            {
                this.implementors = new NotNullImplementor[]{null, new ReflectiveCallNotNullImplementor(BuiltInMethod.RAND_INTEGER.method), new ReflectiveCallNotNullImplementor(BuiltInMethod.RAND_INTEGER_SEED.method)};
            }

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                return this.implementors[call.getOperands().size()].implement(translator, call, translatedOperands);
            }
        }, false);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ACOS, "acos", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ASIN, "asin", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN, "atan", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN2, "atan2", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.COS, "cos", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.COT, "cot", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.DEGREES, "degrees", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.RADIANS, "radians", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ROUND, "sround", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SIGN, "sign", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SIN, "sin", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.TAN, "tan", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.TRUNCATE, "struncate", NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.PI, (translator, call, nullAs) -> Expressions.constant((Object)Math.PI));
        this.defineImplementor(SqlStdOperatorTable.DATETIME_PLUS, NullPolicy.STRICT, new DatetimeArithmeticImplementor(), false);
        this.defineImplementor(SqlStdOperatorTable.MINUS_DATE, NullPolicy.STRICT, new DatetimeArithmeticImplementor(), false);
        this.defineImplementor(SqlStdOperatorTable.EXTRACT, NullPolicy.STRICT, new ExtractImplementor(), false);
        this.defineImplementor(SqlStdOperatorTable.FLOOR, NullPolicy.STRICT, new FloorImplementor(BuiltInMethod.FLOOR.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_FLOOR.method, BuiltInMethod.UNIX_DATE_FLOOR.method), false);
        this.defineImplementor(SqlStdOperatorTable.CEIL, NullPolicy.STRICT, new FloorImplementor(BuiltInMethod.CEIL.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_CEIL.method, BuiltInMethod.UNIX_DATE_CEIL.method), false);
        this.map.put(SqlStdOperatorTable.IS_NULL, new IsXxxImplementor(null, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_NULL, new IsXxxImplementor(null, true));
        this.map.put(SqlStdOperatorTable.IS_TRUE, new IsXxxImplementor(true, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_TRUE, new IsXxxImplementor(true, true));
        this.map.put(SqlStdOperatorTable.IS_FALSE, new IsXxxImplementor(false, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_FALSE, new IsXxxImplementor(false, true));
        MethodImplementor likeImplementor = new MethodImplementor(BuiltInMethod.LIKE.method);
        this.defineImplementor(SqlStdOperatorTable.LIKE, NullPolicy.STRICT, likeImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_LIKE, NullPolicy.STRICT, NotImplementor.of(likeImplementor), false);
        MethodImplementor similarImplementor = new MethodImplementor(BuiltInMethod.SIMILAR.method);
        this.defineImplementor(SqlStdOperatorTable.SIMILAR_TO, NullPolicy.STRICT, similarImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_SIMILAR_TO, NullPolicy.STRICT, NotImplementor.of(similarImplementor), false);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CARDINALITY, BuiltInMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SLICE, BuiltInMethod.SLICE.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ELEMENT, BuiltInMethod.ELEMENT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.STRUCT_ACCESS, BuiltInMethod.STRUCT_ACCESS.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MEMBER_OF, BuiltInMethod.MEMBER_OF.method, NullPolicy.NONE);
        MethodImplementor isEmptyImplementor = new MethodImplementor(BuiltInMethod.IS_EMPTY.method);
        this.defineImplementor(SqlStdOperatorTable.IS_EMPTY, NullPolicy.NONE, isEmptyImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.IS_NOT_EMPTY, NullPolicy.NONE, NotImplementor.of(isEmptyImplementor), false);
        MethodImplementor isASetImplementor = new MethodImplementor(BuiltInMethod.IS_A_SET.method);
        this.defineImplementor(SqlStdOperatorTable.IS_A_SET, NullPolicy.NONE, isASetImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.IS_NOT_A_SET, NullPolicy.NONE, NotImplementor.of(isASetImplementor), false);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT, BuiltInMethod.MULTISET_INTERSECT_DISTINCT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT, BuiltInMethod.MULTISET_INTERSECT_ALL.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT, BuiltInMethod.MULTISET_EXCEPT_DISTINCT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT, BuiltInMethod.MULTISET_EXCEPT_ALL.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_UNION_DISTINCT, BuiltInMethod.MULTISET_UNION_DISTINCT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MULTISET_UNION, BuiltInMethod.MULTISET_UNION_ALL.method, NullPolicy.NONE);
        MethodImplementor subMultisetImplementor = new MethodImplementor(BuiltInMethod.SUBMULTISET_OF.method);
        this.defineImplementor(SqlStdOperatorTable.SUBMULTISET_OF, NullPolicy.NONE, subMultisetImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_SUBMULTISET_OF, NullPolicy.NONE, NotImplementor.of(subMultisetImplementor), false);
        this.map.put(SqlStdOperatorTable.CASE, new CaseImplementor());
        this.map.put(SqlStdOperatorTable.COALESCE, new CoalesceImplementor());
        this.map.put(SqlStdOperatorTable.CAST, new CastOptimizedImplementor());
        this.defineImplementor(SqlStdOperatorTable.REINTERPRET, NullPolicy.STRICT, new ReinterpretImplementor(), false);
        ValueConstructorImplementor value = new ValueConstructorImplementor();
        this.map.put(SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ITEM, new ItemImplementor());
        this.map.put(SqlStdOperatorTable.DEFAULT, (translator, call, nullAs) -> Expressions.constant(null));
        this.defineMethod(SqlStdOperatorTable.CURRENT_VALUE, BuiltInMethod.SEQUENCE_CURRENT_VALUE.method, NullPolicy.STRICT);
        this.defineMethod(SqlStdOperatorTable.NEXT_VALUE, BuiltInMethod.SEQUENCE_NEXT_VALUE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_VALUE_EXPRESSION, BuiltInMethod.JSON_VALUE_EXPRESSION.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_STRUCTURED_VALUE_EXPRESSION, BuiltInMethod.JSON_STRUCTURED_VALUE_EXPRESSION.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_API_COMMON_SYNTAX, BuiltInMethod.JSON_API_COMMON_SYNTAX.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_EXISTS, BuiltInMethod.JSON_EXISTS.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_VALUE_ANY, BuiltInMethod.JSON_VALUE_ANY.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_QUERY, BuiltInMethod.JSON_QUERY.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_OBJECT, BuiltInMethod.JSON_OBJECT.method, NullPolicy.NONE);
        this.aggMap.put(SqlStdOperatorTable.JSON_OBJECTAGG, JsonObjectAggImplementor.supplierFor(BuiltInMethod.JSON_OBJECTAGG_ADD.method));
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_ARRAY, BuiltInMethod.JSON_ARRAY.method, NullPolicy.NONE);
        this.aggMap.put(SqlStdOperatorTable.JSON_ARRAYAGG, JsonArrayAggImplementor.supplierFor(BuiltInMethod.JSON_ARRAYAGG_ADD.method));
        this.defineImplementor(SqlStdOperatorTable.IS_JSON_VALUE, NullPolicy.NONE, new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method), false);
        this.defineImplementor(SqlStdOperatorTable.IS_JSON_OBJECT, NullPolicy.NONE, new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method), false);
        this.defineImplementor(SqlStdOperatorTable.IS_JSON_ARRAY, NullPolicy.NONE, new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method), false);
        this.defineImplementor(SqlStdOperatorTable.IS_JSON_SCALAR, NullPolicy.NONE, new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method), false);
        this.defineImplementor(SqlStdOperatorTable.IS_NOT_JSON_VALUE, NullPolicy.NONE, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method)), false);
        this.defineImplementor(SqlStdOperatorTable.IS_NOT_JSON_OBJECT, NullPolicy.NONE, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method)), false);
        this.defineImplementor(SqlStdOperatorTable.IS_NOT_JSON_ARRAY, NullPolicy.NONE, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method)), false);
        this.defineImplementor(SqlStdOperatorTable.IS_NOT_JSON_SCALAR, NullPolicy.NONE, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method)), false);
        SystemFunctionImplementor systemFunctionImplementor = new SystemFunctionImplementor();
        this.map.put(SqlStdOperatorTable.USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SESSION_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SYSTEM_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_PATH, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_ROLE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_CATALOG, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIMESTAMP, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_DATE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIMESTAMP, systemFunctionImplementor);
        this.aggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.REGR_COUNT, this.constructorSupplier(CountImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM0, this.constructorSupplier(SumImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM, this.constructorSupplier(SumImplementor.class));
        Supplier<MinMaxImplementor> minMax = this.constructorSupplier(MinMaxImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.MIN, minMax);
        this.aggMap.put(SqlStdOperatorTable.MAX, minMax);
        this.aggMap.put(SqlStdOperatorTable.ANY_VALUE, minMax);
        Supplier<BitOpImplementor> bitop = this.constructorSupplier(BitOpImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.BIT_AND, bitop);
        this.aggMap.put(SqlStdOperatorTable.BIT_OR, bitop);
        this.aggMap.put(SqlStdOperatorTable.SINGLE_VALUE, this.constructorSupplier(SingleValueImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.COLLECT, this.constructorSupplier(CollectImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.FUSION, this.constructorSupplier(FusionImplementor.class));
        Supplier<GroupingImplementor> grouping = this.constructorSupplier(GroupingImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.GROUPING, grouping);
        this.aggMap.put(SqlStdOperatorTable.GROUP_ID, grouping);
        this.aggMap.put(SqlStdOperatorTable.GROUPING_ID, grouping);
        this.winAggMap.put(SqlStdOperatorTable.RANK, this.constructorSupplier(RankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.DENSE_RANK, this.constructorSupplier(DenseRankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.ROW_NUMBER, this.constructorSupplier(RowNumberImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.FIRST_VALUE, this.constructorSupplier(FirstValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.NTH_VALUE, this.constructorSupplier(NthValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAST_VALUE, this.constructorSupplier(LastValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LEAD, this.constructorSupplier(LeadImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAG, this.constructorSupplier(LagImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.NTILE, this.constructorSupplier(NtileImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountWinImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.REGR_COUNT, this.constructorSupplier(CountWinImplementor.class));
    }

    private <T> Supplier<T> constructorSupplier(Class<T> klass) {
        Constructor constructor;
        try {
            constructor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(klass + " should implement zero arguments constructor");
        }
        return () -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Error while creating aggregate implementor " + constructor, e);
            }
        };
    }

    private void defineImplementor(SqlOperator operator, NullPolicy nullPolicy, NotNullImplementor implementor, boolean harmonize) {
        CallImplementor callImplementor = RexImpTable.createImplementor(implementor, nullPolicy, harmonize);
        this.map.put(operator, callImplementor);
    }

    private static RexCall call2(boolean harmonize, RexToLixTranslator translator, RexCall call) {
        if (!harmonize) {
            return call;
        }
        List<RexNode> operands2 = RexImpTable.harmonize(translator, call.getOperands());
        if (operands2.equals(call.getOperands())) {
            return call;
        }
        return call.clone(call.getType(), operands2);
    }

    public static CallImplementor createImplementor(NotNullImplementor implementor, NullPolicy nullPolicy, boolean harmonize) {
        switch (nullPolicy) {
            case ANY: 
            case STRICT: 
            case SEMI_STRICT: {
                return (translator, call, nullAs) -> RexImpTable.implementNullSemantics0(translator, call, nullAs, nullPolicy, harmonize, implementor);
            }
            case AND: {
                return (translator, call, nullAs) -> {
                    assert (call.getOperator() == SqlStdOperatorTable.AND) : "AND null semantics is supported only for AND operator. Actual operator is " + String.valueOf(call.getOperator());
                    RexCall call2 = RexImpTable.call2(false, translator, call);
                    switch (nullAs) {
                        case NOT_POSSIBLE: {
                            nullAs = NullAs.TRUE;
                        }
                        case FALSE: 
                        case TRUE: {
                            List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs);
                            return Expressions.foldAnd(expressions);
                        }
                        case NULL: 
                        case IS_NOT_NULL: 
                        case IS_NULL: {
                            List<Expression> nullAsTrue = translator.translateList(call2.getOperands(), NullAs.TRUE);
                            List<Expression> nullAsIsNull = translator.translateList(call2.getOperands(), NullAs.IS_NULL);
                            UnaryExpression hasFalse = Expressions.not((Expression)Expressions.foldAnd(nullAsTrue));
                            Expression hasNull = Expressions.foldOr(nullAsIsNull);
                            return nullAs.handle(Expressions.condition((Expression)hasFalse, (Expression)BOXED_FALSE_EXPR, (Expression)Expressions.condition((Expression)hasNull, (Expression)NULL_EXPR, (Expression)BOXED_TRUE_EXPR)));
                        }
                    }
                    throw new IllegalArgumentException("Unknown nullAs when implementing AND: " + (Object)((Object)nullAs));
                };
            }
            case OR: {
                return (translator, call, nullAs) -> {
                    assert (call.getOperator() == SqlStdOperatorTable.OR) : "OR null semantics is supported only for OR operator. Actual operator is " + String.valueOf(call.getOperator());
                    RexCall call2 = RexImpTable.call2(harmonize, translator, call);
                    switch (nullAs) {
                        case NOT_POSSIBLE: {
                            nullAs = NullAs.FALSE;
                        }
                        case FALSE: 
                        case TRUE: {
                            List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs);
                            return Expressions.foldOr(expressions);
                        }
                        case NULL: 
                        case IS_NOT_NULL: 
                        case IS_NULL: {
                            List<Expression> nullAsFalse = translator.translateList(call2.getOperands(), NullAs.FALSE);
                            List<Expression> nullAsIsNull = translator.translateList(call2.getOperands(), NullAs.IS_NULL);
                            Expression hasTrue = Expressions.foldOr(nullAsFalse);
                            Expression hasNull = Expressions.foldOr(nullAsIsNull);
                            Expression result = nullAs.handle(Expressions.condition((Expression)hasTrue, (Expression)BOXED_TRUE_EXPR, (Expression)Expressions.condition((Expression)hasNull, (Expression)NULL_EXPR, (Expression)BOXED_FALSE_EXPR)));
                            return result;
                        }
                    }
                    throw new IllegalArgumentException("Unknown nullAs when implementing OR: " + (Object)((Object)nullAs));
                };
            }
            case NOT: {
                return new CallImplementor(){

                    @Override
                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        switch (nullAs) {
                            case NULL: {
                                return Expressions.call((Method)BuiltInMethod.NOT.method, translator.translateList(call.getOperands(), nullAs));
                            }
                        }
                        return Expressions.not((Expression)translator.translate(call.getOperands().get(0), this.negate(nullAs)));
                    }

                    private NullAs negate(NullAs nullAs) {
                        switch (nullAs) {
                            case FALSE: {
                                return NullAs.TRUE;
                            }
                            case TRUE: {
                                return NullAs.FALSE;
                            }
                        }
                        return nullAs;
                    }
                };
            }
            case NONE: {
                return (translator, call, nullAs) -> {
                    RexCall call2 = RexImpTable.call2(false, translator, call);
                    return RexImpTable.implementCall(translator, call2, implementor, nullAs);
                };
            }
        }
        throw new AssertionError((Object)nullPolicy);
    }

    private void defineMethod(SqlOperator operator, String functionName, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodNameImplementor(functionName), false);
    }

    private void defineMethod(SqlOperator operator, Method method, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodImplementor(method), false);
    }

    private void defineMethodReflective(SqlOperator operator, Method method, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new ReflectiveCallNotNullImplementor(method), false);
    }

    private void defineUnary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new UnaryImplementor(expressionType), false);
    }

    private void defineBinary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.defineImplementor(operator, nullPolicy, new BinaryImplementor(expressionType, backupMethodName), true);
    }

    public CallImplementor get(SqlOperator operator) {
        if (operator instanceof SqlUserDefinedFunction) {
            Function udf = ((SqlUserDefinedFunction)operator).getFunction();
            if (!(udf instanceof ImplementableFunction)) {
                throw new IllegalStateException("User defined function " + operator + " must implement ImplementableFunction");
            }
            return ((ImplementableFunction)udf).getImplementor();
        }
        return this.map.get(operator);
    }

    public AggImplementor get(SqlAggFunction aggregation, boolean forWindowAggregate) {
        Supplier<? extends WinAggImplementor> winAgg;
        if (aggregation instanceof SqlUserDefinedAggFunction) {
            SqlUserDefinedAggFunction udaf = (SqlUserDefinedAggFunction)aggregation;
            if (!(udaf.function instanceof ImplementableAggFunction)) {
                throw new IllegalStateException("User defined aggregation " + aggregation + " must implement ImplementableAggFunction");
            }
            return ((ImplementableAggFunction)udaf.function).getImplementor(forWindowAggregate);
        }
        if (forWindowAggregate && (winAgg = this.winAggMap.get(aggregation)) != null) {
            return winAgg.get();
        }
        Supplier<? extends AggImplementor> aggSupplier = this.aggMap.get(aggregation);
        if (aggSupplier == null) {
            return null;
        }
        return aggSupplier.get();
    }

    static Expression maybeNegate(boolean negate, Expression expression) {
        if (!negate) {
            return expression;
        }
        return Expressions.not((Expression)expression);
    }

    static Expression optimize(Expression expression) {
        return expression.accept((Shuttle)new OptimizeShuttle());
    }

    static Expression optimize2(Expression operand, Expression expression) {
        if (Primitive.is((Type)operand.getType())) {
            return RexImpTable.optimize(expression);
        }
        return RexImpTable.optimize(Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)NULL_EXPR), (Expression)NULL_EXPR, (Expression)expression));
    }

    private static boolean nullable(RexCall call, int i) {
        return call.getOperands().get(i).getType().isNullable();
    }

    private static List<RexNode> harmonize(RexToLixTranslator translator, List<RexNode> operands) {
        int nullCount = 0;
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        RelDataTypeFactory typeFactory = translator.builder.getTypeFactory();
        for (RexNode operand : operands) {
            RelDataType type = operand.getType();
            type = RexImpTable.toSql(typeFactory, type);
            if (translator.isNullable(operand)) {
                ++nullCount;
            } else {
                type = typeFactory.createTypeWithNullability(type, false);
            }
            types.add(type);
        }
        if (RexImpTable.allSame(types)) {
            return operands;
        }
        RelDataType type = typeFactory.leastRestrictive(types);
        if (type == null) {
            return operands;
        }
        assert (nullCount > 0 == type.isNullable());
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (RexNode operand : operands) {
            list.add(translator.builder.ensureType(type, operand, false));
        }
        return list;
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        SqlTypeName typeName;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (typeName = type.getSqlTypeName()) != null && typeName != SqlTypeName.OTHER) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), type.isNullable());
        }
        return type;
    }

    private static <E> boolean allSame(List<E> list) {
        Object prev = null;
        for (E e : list) {
            if (prev != null && !prev.equals(e)) {
                return false;
            }
            prev = e;
        }
        return true;
    }

    private static Expression implementNullSemantics0(RexToLixTranslator translator, RexCall call, NullAs nullAs, NullPolicy nullPolicy, boolean harmonize, NotNullImplementor implementor) {
        switch (nullAs) {
            case IS_NOT_NULL: {
                switch (nullPolicy) {
                    case STRICT: {
                        return Expressions.foldAnd(translator.translateList(call.getOperands(), nullAs));
                    }
                }
                break;
            }
            case IS_NULL: {
                switch (nullPolicy) {
                    case STRICT: {
                        return Expressions.foldOr(translator.translateList(call.getOperands(), nullAs));
                    }
                }
            }
        }
        RexCall call2 = RexImpTable.call2(harmonize, translator, call);
        try {
            return RexImpTable.implementNullSemantics(translator, call2, nullAs, nullPolicy, implementor);
        }
        catch (RexToLixTranslator.AlwaysNull e) {
            switch (nullAs) {
                case NOT_POSSIBLE: {
                    throw e;
                }
                case FALSE: {
                    return FALSE_EXPR;
                }
                case TRUE: {
                    return TRUE_EXPR;
                }
            }
            return NULL_EXPR;
        }
    }

    private static Expression implementNullSemantics(RexToLixTranslator translator, RexCall call, NullAs nullAs, NullPolicy nullPolicy, NotNullImplementor implementor) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        switch (nullAs) {
            case NULL: {
                for (Ord operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                Expression box = Expressions.box((Expression)RexImpTable.implementCall(translator, call, implementor, nullAs));
                return RexImpTable.optimize(Expressions.condition((Expression)Expressions.foldOr(list), (Expression)Types.castIfNecessary((Type)box.getType(), (Expression)NULL_EXPR), (Expression)box));
            }
            case FALSE: {
                for (Ord operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NOT_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                list.add(RexImpTable.implementCall(translator, call, implementor, nullAs));
                return Expressions.foldAnd(list);
            }
            case TRUE: {
                for (Ord operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                list.add(RexImpTable.implementCall(translator, call, implementor, nullAs));
                return Expressions.foldOr(list);
            }
            case NOT_POSSIBLE: {
                HashMap<RexNode, Boolean> nullable = new HashMap<RexNode, Boolean>();
                switch (nullPolicy) {
                    case STRICT: {
                        for (RexNode arg : call.getOperands()) {
                            if (!translator.isNullable(arg) || nullable.containsKey(arg)) continue;
                            nullable.put(arg, false);
                        }
                        break;
                    }
                }
                nullable.put(call, false);
                translator = translator.setNullable(nullable);
            }
        }
        return RexImpTable.implementCall(translator, call, implementor, nullAs);
    }

    private static Expression implementCall(RexToLixTranslator translator, RexCall call, NotNullImplementor implementor, NullAs nullAs) {
        List<Expression> translatedOperands = translator.translateList(call.getOperands());
        if (nullAs == NullAs.NOT_POSSIBLE) {
            List<Expression> nullHandled = translatedOperands;
            for (int i = 0; i < translatedOperands.size(); ++i) {
                RexNode arg = call.getOperands().get(i);
                Expression e = translatedOperands.get(i);
                if (!translator.isNullable(arg)) {
                    if (nullHandled == translatedOperands) {
                        nullHandled = new ArrayList<Expression>(translatedOperands.subList(0, i));
                    }
                    nullHandled.add(translator.handleNull(e, nullAs));
                    continue;
                }
                if (nullHandled == translatedOperands) continue;
                nullHandled.add(e);
            }
            translatedOperands = nullHandled;
        }
        Expression result = implementor.implement(translator, call, translatedOperands);
        return translator.handleNull(result, nullAs);
    }

    static Expression getDefaultValue(Type type) {
        if (Primitive.is((Type)type)) {
            Primitive p = Primitive.of((Type)type);
            return Expressions.constant((Object)p.defaultValue, (Type)type);
        }
        return Expressions.constant(null, (Type)type);
    }

    public static Expression multiplyDivide(Expression e, BigDecimal multiplier, BigDecimal divider) {
        if (multiplier.equals(BigDecimal.ONE)) {
            if (divider.equals(BigDecimal.ONE)) {
                return e;
            }
            return Expressions.divide((Expression)e, (Expression)Expressions.constant((Object)divider.intValueExact()));
        }
        BigDecimal x = multiplier.divide(divider, RoundingMode.UNNECESSARY);
        switch (x.compareTo(BigDecimal.ONE)) {
            case 0: {
                return e;
            }
            case 1: {
                return Expressions.multiply((Expression)e, (Expression)Expressions.constant((Object)x.intValueExact()));
            }
            case -1: {
                return RexImpTable.multiplyDivide(e, BigDecimal.ONE, x);
            }
        }
        throw new AssertionError();
    }

    private static Expression mod(Expression operand, long factor) {
        if (factor == 1L) {
            return operand;
        }
        return Expressions.modulo((Expression)operand, (Expression)Expressions.constant((Object)factor));
    }

    private static long getFactor(TimeUnit unit) {
        switch (unit) {
            case DAY: {
                return 1L;
            }
            case HOUR: {
                return TimeUnit.DAY.multiplier.longValue();
            }
            case MINUTE: {
                return TimeUnit.HOUR.multiplier.longValue();
            }
            case SECOND: {
                return TimeUnit.MINUTE.multiplier.longValue();
            }
            case MILLISECOND: {
                return TimeUnit.SECOND.multiplier.longValue();
            }
            case MONTH: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case QUARTER: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case MILLENNIUM: 
            case CENTURY: 
            case YEAR: 
            case DECADE: {
                return 1L;
            }
        }
        throw Util.unexpected(unit);
    }

    private static class DatetimeArithmeticImplementor
    implements NotNullImplementor {
        private DatetimeArithmeticImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            RexNode operand0 = call.getOperands().get(0);
            Expression trop0 = translatedOperands.get(0);
            SqlTypeName typeName1 = call.getOperands().get(1).getType().getSqlTypeName();
            Expression trop1 = translatedOperands.get(1);
            SqlTypeName typeName = call.getType().getSqlTypeName();
            block0 : switch (operand0.getType().getSqlTypeName()) {
                case DATE: {
                    switch (typeName) {
                        case TIMESTAMP: {
                            trop0 = Expressions.convert_((Expression)Expressions.multiply((Expression)trop0, (Expression)Expressions.constant((Object)86400000L)), Long.TYPE);
                            break block0;
                        }
                    }
                    switch (typeName1) {
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            trop1 = Expressions.convert_((Expression)Expressions.divide((Expression)trop1, (Expression)Expressions.constant((Object)86400000L)), Integer.TYPE);
                        }
                    }
                    break;
                }
                case TIME: {
                    trop1 = Expressions.convert_((Expression)trop1, Integer.TYPE);
                }
            }
            switch (typeName1) {
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    switch (call.getKind()) {
                        case MINUS: {
                            trop1 = Expressions.negate((Expression)trop1);
                        }
                    }
                    switch (typeName) {
                        case TIME: {
                            return Expressions.convert_((Expression)trop0, Long.TYPE);
                        }
                    }
                    BuiltInMethod method = operand0.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP ? BuiltInMethod.ADD_MONTHS : BuiltInMethod.ADD_MONTHS_INT;
                    return Expressions.call((Method)method.method, (Expression[])new Expression[]{trop0, trop1});
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    switch (call.getKind()) {
                        case MINUS: {
                            return this.normalize(typeName, (Expression)Expressions.subtract((Expression)trop0, (Expression)trop1));
                        }
                    }
                    return this.normalize(typeName, (Expression)Expressions.add((Expression)trop0, (Expression)trop1));
                }
            }
            switch (call.getKind()) {
                case MINUS: {
                    switch (typeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: {
                            return Expressions.call((Method)BuiltInMethod.SUBTRACT_MONTHS.method, (Expression[])new Expression[]{trop0, trop1});
                        }
                    }
                    TimeUnit fromUnit = typeName1 == SqlTypeName.DATE ? TimeUnit.DAY : TimeUnit.MILLISECOND;
                    TimeUnit toUnit = TimeUnit.MILLISECOND;
                    return RexImpTable.multiplyDivide((Expression)Expressions.convert_((Expression)Expressions.subtract((Expression)trop0, (Expression)trop1), Long.TYPE), fromUnit.multiplier, toUnit.multiplier);
                }
            }
            throw new AssertionError(call);
        }

        private Expression normalize(SqlTypeName typeName, Expression e) {
            switch (typeName) {
                case TIME: {
                    return Expressions.call((Method)BuiltInMethod.FLOOR_MOD.method, (Expression[])new Expression[]{e, Expressions.constant((Object)86400000L)});
                }
            }
            return e;
        }
    }

    private static class NotImplementor
    implements NotNullImplementor {
        private final NotNullImplementor implementor;

        NotImplementor(NotNullImplementor implementor) {
            this.implementor = implementor;
        }

        private static NotNullImplementor of(NotNullImplementor implementor) {
            return new NotImplementor(implementor);
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression expression = this.implementor.implement(translator, call, translatedOperands);
            return Expressions.not((Expression)expression);
        }
    }

    private static class IsXxxImplementor
    implements CallImplementor {
        private final Boolean seek;
        private final boolean negate;

        IsXxxImplementor(Boolean seek, boolean negate) {
            this.seek = seek;
            this.negate = negate;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            List<RexNode> operands = call.getOperands();
            assert (operands.size() == 1);
            switch (nullAs) {
                case IS_NOT_NULL: {
                    return BOXED_TRUE_EXPR;
                }
                case IS_NULL: {
                    return BOXED_FALSE_EXPR;
                }
            }
            if (this.seek == null) {
                return translator.translate(operands.get(0), this.negate ? NullAs.IS_NOT_NULL : NullAs.IS_NULL);
            }
            return RexImpTable.maybeNegate(this.negate == this.seek, translator.translate(operands.get(0), this.seek != false ? NullAs.FALSE : NullAs.TRUE));
        }
    }

    private static class SystemFunctionImplementor
    implements CallImplementor {
        private SystemFunctionImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            switch (nullAs) {
                case IS_NULL: {
                    return Expressions.constant((Object)false);
                }
                case IS_NOT_NULL: {
                    return Expressions.constant((Object)true);
                }
            }
            SqlOperator op = call.getOperator();
            Expression root = translator.getRoot();
            if (op == SqlStdOperatorTable.CURRENT_USER || op == SqlStdOperatorTable.SESSION_USER || op == SqlStdOperatorTable.USER) {
                return Expressions.constant((Object)"sa");
            }
            if (op == SqlStdOperatorTable.SYSTEM_USER) {
                return Expressions.constant((Object)System.getProperty("user.name"));
            }
            if (op == SqlStdOperatorTable.CURRENT_PATH || op == SqlStdOperatorTable.CURRENT_ROLE || op == SqlStdOperatorTable.CURRENT_CATALOG) {
                return Expressions.constant((Object)"");
            }
            if (op == SqlStdOperatorTable.CURRENT_TIMESTAMP) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_TIMESTAMP.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.CURRENT_TIME) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_TIME.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.CURRENT_DATE) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.LOCALTIMESTAMP) {
                return Expressions.call((Method)BuiltInMethod.LOCAL_TIMESTAMP.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.LOCALTIME) {
                return Expressions.call((Method)BuiltInMethod.LOCAL_TIME.method, (Expression[])new Expression[]{root});
            }
            throw new AssertionError((Object)("unknown function " + op));
        }
    }

    private static class ItemImplementor
    implements CallImplementor {
        private ItemImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            MethodImplementor implementor = this.getImplementor(call.getOperands().get(0).getType().getSqlTypeName());
            NullPolicy nullPolicy = NullPolicy.ANY;
            return RexImpTable.implementNullSemantics0(translator, call, nullAs, nullPolicy, false, implementor);
        }

        private MethodImplementor getImplementor(SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case ARRAY: {
                    return new MethodImplementor(BuiltInMethod.ARRAY_ITEM.method);
                }
                case MAP: {
                    return new MethodImplementor(BuiltInMethod.MAP_ITEM.method);
                }
            }
            return new MethodImplementor(BuiltInMethod.ANY_ITEM.method);
        }
    }

    private static class ValueConstructorImplementor
    implements CallImplementor {
        private ValueConstructorImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return translator.translateConstructor(call.getOperands(), call.getOperator().getKind());
        }
    }

    private static class ReinterpretImplementor
    implements NotNullImplementor {
        private ReinterpretImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            return translatedOperands.get(0);
        }
    }

    private static class CastImplementor
    implements NotNullImplementor {
        private CastImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            RelDataType sourceType = call.getOperands().get(0).getType();
            boolean nullable = translator.isNullable(call) && sourceType.isNullable() && !Primitive.is((Type)translatedOperands.get(0).getType());
            RelDataType targetType = translator.nullifyType(call.getType(), nullable);
            return translator.translateCast(sourceType, targetType, translatedOperands.get(0));
        }
    }

    private static class CastOptimizedImplementor
    implements CallImplementor {
        private final CallImplementor accurate = RexImpTable.createImplementor(new CastImplementor(), NullPolicy.STRICT, false);

        private CastOptimizedImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            RexNode arg = call.getOperands().get(0);
            if (call.getType().equals(arg.getType())) {
                return translator.translate(arg, nullAs);
            }
            if (SqlTypeUtil.equalSansNullability(translator.typeFactory, call.getType(), arg.getType()) && nullAs == NullAs.NULL && translator.deref(arg) instanceof RexLiteral) {
                return RexToLixTranslator.translateLiteral((RexLiteral)translator.deref(arg), call.getType(), translator.typeFactory, nullAs);
            }
            return this.accurate.implement(translator, call, nullAs);
        }
    }

    private static class CoalesceImplementor
    implements CallImplementor {
        private CoalesceImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return this.implementRecurse(translator, (List<RexNode>)call.operands, nullAs);
        }

        private Expression implementRecurse(RexToLixTranslator translator, List<RexNode> operands, NullAs nullAs) {
            if (operands.size() == 1) {
                return translator.translate(operands.get(0));
            }
            return Expressions.condition((Expression)translator.translate(operands.get(0), NullAs.IS_NULL), (Expression)translator.translate(operands.get(0), nullAs), (Expression)this.implementRecurse(translator, Util.skip(operands), nullAs));
        }
    }

    private static class CaseImplementor
    implements CallImplementor {
        private CaseImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return this.implementRecurse(translator, call, nullAs, 0);
        }

        private Expression implementRecurse(RexToLixTranslator translator, RexCall call, NullAs nullAs, int i) {
            Expression ifFalse;
            Expression ifTrue;
            List<RexNode> operands = call.getOperands();
            if (i == operands.size() - 1) {
                return translator.translate(translator.builder.ensureType(call.getType(), operands.get(i), false), nullAs);
            }
            try {
                ifTrue = translator.translate(translator.builder.ensureType(call.getType(), operands.get(i + 1), false), nullAs);
            }
            catch (RexToLixTranslator.AlwaysNull e) {
                ifTrue = null;
            }
            try {
                ifFalse = this.implementRecurse(translator, call, nullAs, i + 2);
            }
            catch (RexToLixTranslator.AlwaysNull e) {
                if (ifTrue == null) {
                    throw RexToLixTranslator.AlwaysNull.INSTANCE;
                }
                ifFalse = null;
            }
            Expression test = translator.translate(operands.get(i), NullAs.FALSE);
            return ifTrue == null || ifFalse == null ? Util.first(ifTrue, ifFalse) : Expressions.condition((Expression)test, (Expression)ifTrue, (Expression)ifFalse);
        }
    }

    private static class ExtractImplementor
    implements NotNullImplementor {
        private ExtractImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            TimeUnitRange timeUnitRange = (TimeUnitRange)((ConstantExpression)translatedOperands.get((int)0)).value;
            TimeUnit unit = timeUnitRange.startUnit;
            Expression operand = translatedOperands.get(1);
            SqlTypeName sqlTypeName = ((RexNode)call.operands.get(1)).getType().getSqlTypeName();
            block0 : switch (unit) {
                case MILLENNIUM: 
                case CENTURY: 
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case DAY: 
                case DOW: 
                case DECADE: 
                case DOY: 
                case ISODOW: 
                case ISOYEAR: 
                case WEEK: {
                    switch (sqlTypeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            break block0;
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                        }
                        case TIMESTAMP: {
                            operand = Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.DAY.multiplier.longValue()));
                        }
                        case DATE: {
                            return Expressions.call((Method)BuiltInMethod.UNIX_DATE_EXTRACT.method, (Expression[])new Expression[]{translatedOperands.get(0), operand});
                        }
                    }
                    throw new AssertionError((Object)("unexpected " + (Object)((Object)sqlTypeName)));
                }
                case MILLISECOND: {
                    return Expressions.modulo((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.MINUTE.multiplier.longValue()));
                }
                case MICROSECOND: {
                    operand = Expressions.modulo((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.MINUTE.multiplier.longValue()));
                    return Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                }
                case EPOCH: {
                    switch (sqlTypeName) {
                        case DATE: {
                            operand = Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.DAY.multiplier.longValue()));
                        }
                        case TIMESTAMP: {
                            return Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                            return Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            throw new AssertionError((Object)("unexpected " + (Object)((Object)sqlTypeName)));
                        }
                    }
                    break;
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    switch (sqlTypeName) {
                        case DATE: {
                            return Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)0L));
                        }
                    }
                }
            }
            operand = RexImpTable.mod(operand, RexImpTable.getFactor(unit));
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.subtract((Expression)operand, (Expression)Expressions.constant((Object)1L));
            }
            operand = Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)unit.multiplier.longValue()));
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.add((Expression)operand, (Expression)Expressions.constant((Object)1L));
            }
            return operand;
        }
    }

    private static class UnaryImplementor
    implements NotNullImplementor {
        private final ExpressionType expressionType;

        UnaryImplementor(ExpressionType expressionType) {
            this.expressionType = expressionType;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression operand = translatedOperands.get(0);
            UnaryExpression e = Expressions.makeUnary((ExpressionType)this.expressionType, (Expression)operand);
            if (e.type.equals(operand.type)) {
                return e;
            }
            return Expressions.convert_((Expression)e, (Type)operand.type);
        }
    }

    private static class BinaryImplementor
    implements NotNullImplementor {
        private static final List<Primitive> COMP_OP_TYPES = ImmutableList.of((Object)Primitive.BYTE, (Object)Primitive.CHAR, (Object)Primitive.SHORT, (Object)Primitive.INT, (Object)Primitive.LONG, (Object)Primitive.FLOAT, (Object)Primitive.DOUBLE);
        private static final List<SqlBinaryOperator> COMPARISON_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.LESS_THAN, (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.GREATER_THAN, (Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        public static final String METHOD_POSTFIX_FOR_ANY_TYPE = "Any";
        private final ExpressionType expressionType;
        private final String backupMethodName;

        BinaryImplementor(ExpressionType expressionType, String backupMethodName) {
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> expressions) {
            if (this.backupMethodName != null) {
                if (this.anyAnyOperands(call)) {
                    return this.callBackupMethodAnyType(translator, call, expressions);
                }
                Type type0 = expressions.get(0).getType();
                Type type1 = expressions.get(1).getType();
                SqlBinaryOperator op = (SqlBinaryOperator)call.getOperator();
                Primitive primitive = Primitive.ofBoxOr((Type)type0);
                if (primitive == null || type1 == BigDecimal.class || COMPARISON_OPERATORS.contains(op) && !COMP_OP_TYPES.contains(primitive)) {
                    return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, expressions);
                }
            }
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            return Types.castIfNecessary((Type)returnType, (Expression)Expressions.makeBinary((ExpressionType)this.expressionType, (Expression)expressions.get(0), (Expression)expressions.get(1)));
        }

        private boolean anyAnyOperands(RexCall call) {
            for (RexNode operand : call.operands) {
                if (operand.getType().getSqlTypeName() != SqlTypeName.ANY) continue;
                return true;
            }
            return false;
        }

        private Expression callBackupMethodAnyType(RexToLixTranslator translator, RexCall call, List<Expression> expressions) {
            String backupMethodNameForAnyType = this.backupMethodName + METHOD_POSTFIX_FOR_ANY_TYPE;
            Expression expression0 = this.maybeBox(expressions.get(0));
            Expression expression1 = this.maybeBox(expressions.get(1));
            return Expressions.call(SqlFunctions.class, (String)backupMethodNameForAnyType, (Expression[])new Expression[]{expression0, expression1});
        }

        private Expression maybeBox(Expression expression) {
            Primitive primitive = Primitive.of((Type)expression.getType());
            if (primitive != null) {
                expression = Expressions.box((Expression)expression, (Primitive)primitive);
            }
            return expression;
        }
    }

    private static class MethodNameImplementor
    implements NotNullImplementor {
        protected final String methodName;

        MethodNameImplementor(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call(SqlFunctions.class, (String)this.methodName, translatedOperands);
        }
    }

    private static class MethodImplementor
    implements NotNullImplementor {
        protected final Method method;

        MethodImplementor(Method method) {
            this.method = method;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            MethodCallExpression expression = Modifier.isStatic(this.method.getModifiers()) ? Expressions.call((Method)this.method, translatedOperands) : Expressions.call((Expression)translatedOperands.get(0), (Method)this.method, Util.skip(translatedOperands, 1));
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            return Types.castIfNecessary((Type)returnType, (Expression)expression);
        }
    }

    private static class FloorImplementor
    extends MethodNameImplementor {
        final Method timestampMethod;
        final Method dateMethod;

        FloorImplementor(String methodName, Method timestampMethod, Method dateMethod) {
            super(methodName);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            switch (call.getOperands().size()) {
                case 1: {
                    switch (call.getType().getSqlTypeName()) {
                        case BIGINT: 
                        case INTEGER: 
                        case SMALLINT: 
                        case TINYINT: {
                            return translatedOperands.get(0);
                        }
                    }
                    return super.implement(translator, call, translatedOperands);
                }
                case 2: {
                    Method floorMethod;
                    Class<Number> type;
                    Expression operand = translatedOperands.get(0);
                    switch (call.getType().getSqlTypeName()) {
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                        }
                        case TIMESTAMP: {
                            type = Long.TYPE;
                            floorMethod = this.timestampMethod;
                            break;
                        }
                        default: {
                            type = Integer.TYPE;
                            floorMethod = this.dateMethod;
                        }
                    }
                    ConstantExpression tur = (ConstantExpression)translatedOperands.get(1);
                    TimeUnitRange timeUnitRange = (TimeUnitRange)tur.value;
                    switch (timeUnitRange) {
                        case YEAR: 
                        case MONTH: {
                            return Expressions.call((Method)floorMethod, (Expression[])new Expression[]{tur, this.call(operand, type, TimeUnit.DAY)});
                        }
                    }
                    return this.call(operand, type, timeUnitRange.startUnit);
                }
            }
            throw new AssertionError();
        }

        private Expression call(Expression operand, Type type, TimeUnit timeUnit) {
            return Expressions.call(SqlFunctions.class, (String)this.methodName, (Expression[])new Expression[]{Types.castIfNecessary((Type)type, (Expression)operand), Types.castIfNecessary((Type)type, (Expression)Expressions.constant((Object)timeUnit.multiplier))});
        }
    }

    private static class TrimImplementor
    implements NotNullImplementor {
        private TrimImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            boolean strict = !translator.conformance.allowExtendedTrim();
            Object value = ((ConstantExpression)translatedOperands.get((int)0)).value;
            SqlTrimFunction.Flag flag = (SqlTrimFunction.Flag)((Object)value);
            return Expressions.call((Method)BuiltInMethod.TRIM.method, (Expression[])new Expression[]{Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.LEADING ? 1 : 0)), Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.TRAILING ? 1 : 0)), translatedOperands.get(1), translatedOperands.get(2), Expressions.constant((Object)strict)});
        }
    }

    static class JsonArrayAggImplementor
    implements AggImplementor {
        private final Method m;

        JsonArrayAggImplementor(Method m) {
            this.m = m;
        }

        static Supplier<JsonArrayAggImplementor> supplierFor(Method m) {
            return () -> new JsonArrayAggImplementor(m);
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.singletonList(List.class);
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)reset.accumulator().get(0), (Expression)Expressions.new_(ArrayList.class))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            SqlJsonArrayAggAggFunction function = (SqlJsonArrayAggAggFunction)info.aggregation();
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Method)this.m, (Iterable)Iterables.concat(Collections.singletonList(add.accumulator().get(0)), add.arguments(), Collections.singletonList(Expressions.constant((Object)((Object)function.getNullClause())))))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return Expressions.call((Method)BuiltInMethod.JSONIZE.method, (Expression[])new Expression[]{result.accumulator().get(0)});
        }
    }

    static class JsonObjectAggImplementor
    implements AggImplementor {
        private final Method m;

        JsonObjectAggImplementor(Method m) {
            this.m = m;
        }

        static Supplier<JsonObjectAggImplementor> supplierFor(Method m) {
            return () -> new JsonObjectAggImplementor(m);
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.singletonList(Map.class);
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)reset.accumulator().get(0), (Expression)Expressions.new_(HashMap.class))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            SqlJsonObjectAggAggFunction function = (SqlJsonObjectAggAggFunction)info.aggregation();
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Method)this.m, (Iterable)Iterables.concat(Collections.singletonList(add.accumulator().get(0)), add.arguments(), Collections.singletonList(Expressions.constant((Object)((Object)function.getNullClause())))))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return Expressions.call((Method)BuiltInMethod.JSONIZE.method, (Expression[])new Expression[]{result.accumulator().get(0)});
        }
    }

    static class RowNumberImplementor
    extends StrictWinAggImplementor {
        RowNumberImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            return Collections.emptyList();
        }

        @Override
        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add((Expression)Expressions.subtract((Expression)result.index(), (Expression)result.startIndex()), (Expression)Expressions.constant((Object)1));
        }
    }

    static class NtileImplementor
    implements WinAggImplementor {
        NtileImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            Expression tiles = winResult.rowTranslator(winResult.index()).translate(rexArgs.get(0), Integer.TYPE);
            BinaryExpression ntile = Expressions.add((Expression)Expressions.constant((Object)1), (Expression)Expressions.divide((Expression)Expressions.multiply((Expression)tiles, (Expression)Expressions.subtract((Expression)winResult.index(), (Expression)winResult.startIndex())), (Expression)winResult.getPartitionRowCount()));
            return ntile;
        }
    }

    public static class LagImplementor
    extends LeadLagImplementor {
        protected LagImplementor() {
            super(false);
        }
    }

    public static class LeadImplementor
    extends LeadLagImplementor {
        protected LeadImplementor() {
            super(true);
        }
    }

    static class LeadLagImplementor
    implements WinAggImplementor {
        private final boolean isLead;

        protected LeadLagImplementor(boolean isLead) {
            this.isLead = isLead;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            ParameterExpression res = Expressions.parameter((int)0, (Type)info.returnType(), (String)result.currentBlock().newName(this.isLead ? "lead" : "lag"));
            RexToLixTranslator currentRowTranslator = winResult.rowTranslator(winResult.computeIndex((Expression)Expressions.constant((Object)0), WinAggImplementor.SeekType.SET));
            Object offset = rexArgs.size() >= 2 ? currentRowTranslator.translate(rexArgs.get(1), Integer.TYPE) : Expressions.constant((Object)1);
            if (!this.isLead) {
                offset = Expressions.negate((Expression)offset);
            }
            Expression dstIndex = winResult.computeIndex((Expression)offset, WinAggImplementor.SeekType.SET);
            Expression rowInRange = winResult.rowInPartition(dstIndex);
            BlockBuilder thenBlock = result.nestBlock();
            Expression lagResult = winResult.rowTranslator(dstIndex).translate(rexArgs.get(0), res.type);
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)lagResult)));
            result.exitBlock();
            BlockStatement thenBranch = thenBlock.toBlock();
            Expression defaultValue = rexArgs.size() == 3 ? currentRowTranslator.translate(rexArgs.get(2), res.type) : RexImpTable.getDefaultValue(res.type);
            result.currentBlock().add((Statement)Expressions.declare((int)0, (ParameterExpression)res, null));
            result.currentBlock().add((Statement)Expressions.ifThenElse((Expression)rowInRange, (Node)thenBranch, (Node)Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)defaultValue))));
            return res;
        }
    }

    static class NthValueImplementor
    implements WinAggImplementor {
        NthValueImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return true;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            ParameterExpression res = Expressions.parameter((int)0, (Type)info.returnType(), (String)result.currentBlock().newName("nth"));
            RexToLixTranslator currentRowTranslator = winResult.rowTranslator(winResult.computeIndex((Expression)Expressions.constant((Object)0), WinAggImplementor.SeekType.START));
            Expression dstIndex = winResult.computeIndex((Expression)Expressions.subtract((Expression)currentRowTranslator.translate(rexArgs.get(1), Integer.TYPE), (Expression)Expressions.constant((Object)1)), WinAggImplementor.SeekType.START);
            Expression rowInRange = winResult.rowInPartition(dstIndex);
            BlockBuilder thenBlock = result.nestBlock();
            Expression nthValue = winResult.rowTranslator(dstIndex).translate(rexArgs.get(0), res.type);
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)nthValue)));
            result.exitBlock();
            BlockStatement thenBranch = thenBlock.toBlock();
            Expression defaultValue = RexImpTable.getDefaultValue(res.type);
            result.currentBlock().add((Statement)Expressions.declare((int)0, (ParameterExpression)res, null));
            result.currentBlock().add((Statement)Expressions.ifThenElse((Expression)rowInRange, (Node)thenBranch, (Node)Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)defaultValue))));
            return res;
        }
    }

    static class LastValueImplementor
    extends FirstLastValueImplementor {
        protected LastValueImplementor() {
            super(WinAggImplementor.SeekType.END);
        }
    }

    static class FirstValueImplementor
    extends FirstLastValueImplementor {
        protected FirstValueImplementor() {
            super(WinAggImplementor.SeekType.START);
        }
    }

    static class FirstLastValueImplementor
    implements WinAggImplementor {
        private final WinAggImplementor.SeekType seekType;

        protected FirstLastValueImplementor(WinAggImplementor.SeekType seekType) {
            this.seekType = seekType;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return true;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            return Expressions.condition((Expression)winResult.hasRows(), (Expression)winResult.rowTranslator(winResult.computeIndex((Expression)Expressions.constant((Object)0), this.seekType)).translate(winResult.rexArguments().get(0), info.returnType()), (Expression)RexImpTable.getDefaultValue(info.returnType()));
        }
    }

    static class DenseRankImplementor
    extends RankImplementor {
        DenseRankImplementor() {
        }

        @Override
        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            return Expressions.add((Expression)acc, (Expression)Expressions.constant((Object)1));
        }
    }

    static class RankImplementor
    extends StrictWinAggImplementor {
        RankImplementor() {
        }

        @Override
        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            Expression acc = add.accumulator().get(0);
            BlockBuilder builder = add.nestBlock();
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)Expressions.lessThan((Expression)add.compareRows((Expression)Expressions.subtract((Expression)add.currentPosition(), (Expression)Expressions.constant((Object)1)), add.currentPosition()), (Expression)Expressions.constant((Object)0)), (Node)Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)this.computeNewRank(acc, add)))));
            add.exitBlock();
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)Expressions.greaterThan((Expression)add.currentPosition(), (Expression)add.startIndex()), (Node)builder.toBlock()));
        }

        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            Expression pos = add.currentPosition();
            if (!add.startIndex().equals((Object)Expressions.constant((Object)0))) {
                pos = Expressions.subtract((Expression)pos, (Expression)add.startIndex());
            }
            return pos;
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add((Expression)super.implementNotNullResult(info, result), (Expression)Expressions.constant((Object)1));
        }
    }

    public static class UserDefinedAggReflectiveImplementor
    extends StrictAggImplementor {
        private final AggregateFunctionImpl afi;

        public UserDefinedAggReflectiveImplementor(AggregateFunctionImpl afi) {
            this.afi = afi;
        }

        @Override
        public List<Type> getNotNullState(AggContext info) {
            if (this.afi.isStatic) {
                return Collections.singletonList(this.afi.accumulatorType);
            }
            return Arrays.asList(this.afi.accumulatorType, this.afi.declaringClass);
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            if (!this.afi.isStatic) {
                reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(1), (Expression)Expressions.new_(this.afi.declaringClass))));
            }
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(0), (Expression)Expressions.call((Expression)(this.afi.isStatic ? null : acc.get(1)), (Method)this.afi.initMethod, (Expression[])new Expression[0]))));
        }

        @Override
        protected void implementNotNullAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            List<Expression> aggArgs = add.arguments();
            ArrayList<Expression> args = new ArrayList<Expression>(aggArgs.size() + 1);
            args.add(acc.get(0));
            args.addAll(aggArgs);
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(0), (Expression)Expressions.call((Expression)(this.afi.isStatic ? null : acc.get(1)), (Method)this.afi.addMethod, args))));
        }

        @Override
        protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
            List<Expression> acc = result.accumulator();
            return Expressions.call((Expression)(this.afi.isStatic ? null : acc.get(1)), (Method)this.afi.resultMethod, (Expression[])new Expression[]{acc.get(0)});
        }
    }

    static class GroupingImplementor
    implements AggImplementor {
        GroupingImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return ImmutableList.of();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            List<Integer> keys;
            switch (info.aggregation().kind) {
                case GROUPING: {
                    keys = result.call().getArgList();
                    break;
                }
                case GROUP_ID: {
                    keys = ImmutableIntList.of();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Object e = null;
            if (info.groupSets().size() > 1) {
                List<Integer> keyOrdinals = info.keyOrdinals();
                long x = 1L << keys.size() - 1;
                for (int k : keys) {
                    int i = keyOrdinals.indexOf(k);
                    assert (i >= 0);
                    Expression e2 = Expressions.condition((Expression)result.keyField(keyOrdinals.size() + i), (Expression)Expressions.constant((Object)x), (Expression)Expressions.constant((Object)0L));
                    e = e == null ? e2 : Expressions.add((Expression)e, (Expression)e2);
                    x >>= 1;
                }
            }
            return e != null ? e : Expressions.constant((Object)0, (Type)info.returnType());
        }
    }

    static class BitOpImplementor
    extends StrictAggImplementor {
        BitOpImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            Integer initValue = info.aggregation() == SqlStdOperatorTable.BIT_AND ? -1 : 0;
            ConstantExpression start = Expressions.constant((Object)initValue, (Type)info.returnType());
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)reset.accumulator().get(0), (Expression)start)));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            SqlAggFunction aggregation;
            Expression acc = add.accumulator().get(0);
            Expression arg = add.arguments().get(0);
            Method method = ((aggregation = info.aggregation()) == SqlStdOperatorTable.BIT_AND ? BuiltInMethod.BIT_AND : BuiltInMethod.BIT_OR).method;
            MethodCallExpression next = Expressions.call(method.getDeclaringClass(), (String)method.getName(), (Expression[])new Expression[]{acc, Expressions.unbox((Expression)arg)});
            this.accAdvance(add, acc, (Expression)next);
        }
    }

    static class FusionImplementor
    extends StrictAggImplementor {
        FusionImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)reset.accumulator().get(0), (Expression)Expressions.new_(ArrayList.class))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Expression)add.accumulator().get(0), (Method)BuiltInMethod.COLLECTION_ADDALL.method, (Expression[])new Expression[]{add.arguments().get(0)})));
        }
    }

    static class CollectImplementor
    extends StrictAggImplementor {
        CollectImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)reset.accumulator().get(0), (Expression)Expressions.new_(ArrayList.class))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement((Expression)Expressions.call((Expression)add.accumulator().get(0), (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{add.arguments().get(0)})));
        }
    }

    static class SingleValueImplementor
    implements AggImplementor {
        SingleValueImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Arrays.asList(Boolean.TYPE, info.returnType());
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(0), (Expression)Expressions.constant((Object)false))));
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(1), (Expression)RexImpTable.getDefaultValue(acc.get(1).getType()))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            Expression flag = acc.get(0);
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)flag, (Node)Expressions.throw_((Expression)Expressions.new_(IllegalStateException.class, (Expression[])new Expression[]{Expressions.constant((Object)("more than one value in agg " + info.aggregation()))}))));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)flag, (Expression)Expressions.constant((Object)true))));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(1), (Expression)add.arguments().get(0))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return RexToLixTranslator.convert(result.accumulator().get(1), info.returnType());
        }
    }

    static class MinMaxImplementor
    extends StrictAggImplementor {
        MinMaxImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            boolean isMin;
            Expression acc = reset.accumulator().get(0);
            Primitive p = Primitive.of((Type)acc.getType());
            boolean bl = isMin = SqlStdOperatorTable.MIN == info.aggregation();
            Object inf = p == null ? null : (isMin ? p.max : p.min);
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)Expressions.constant((Object)inf, (Type)acc.getType()))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            SqlAggFunction aggregation;
            Expression acc = add.accumulator().get(0);
            Expression arg = add.arguments().get(0);
            Method method = ((aggregation = info.aggregation()) == SqlStdOperatorTable.MIN ? BuiltInMethod.LESSER : BuiltInMethod.GREATER).method;
            MethodCallExpression next = Expressions.call(method.getDeclaringClass(), (String)method.getName(), (Expression[])new Expression[]{acc, Expressions.unbox((Expression)arg)});
            this.accAdvance(add, acc, (Expression)next);
        }
    }

    static class SumImplementor
    extends StrictAggImplementor {
        SumImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            ConstantExpression start = info.returnType() == BigDecimal.class ? Expressions.constant((Object)BigDecimal.ZERO) : Expressions.constant((Object)0);
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)reset.accumulator().get(0), (Expression)start)));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression acc = add.accumulator().get(0);
            Object next = info.returnType() == BigDecimal.class ? Expressions.call((Expression)acc, (String)"add", (Expression[])new Expression[]{add.arguments().get(0)}) : Expressions.add((Expression)acc, (Expression)Types.castIfNecessary((Type)acc.type, (Expression)add.arguments().get(0)));
            this.accAdvance(add, acc, (Expression)next);
        }

        @Override
        public Expression implementNotNullResult(AggContext info, AggResultContext result) {
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountWinImplementor
    extends StrictWinAggImplementor {
        boolean justFrameRowCount;

        CountWinImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            boolean hasNullable = false;
            for (RelDataType relDataType : info.parameterRelTypes()) {
                if (!relDataType.isNullable()) continue;
                hasNullable = true;
                break;
            }
            if (!hasNullable) {
                this.justFrameRowCount = true;
                return Collections.emptyList();
            }
            return super.getNotNullState(info);
        }

        @Override
        public void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            if (this.justFrameRowCount) {
                return;
            }
            add.currentBlock().add(Expressions.statement((Expression)Expressions.postIncrementAssign((Expression)add.accumulator().get(0))));
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            if (this.justFrameRowCount) {
                return result.getFrameRowCount();
            }
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountImplementor
    extends StrictAggImplementor {
        CountImplementor() {
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement((Expression)Expressions.postIncrementAssign((Expression)add.accumulator().get(0))));
        }
    }

    public static enum NullAs {
        NULL,
        FALSE,
        TRUE,
        NOT_POSSIBLE,
        IS_NULL,
        IS_NOT_NULL;


        public static NullAs of(boolean nullable) {
            return nullable ? NULL : NOT_POSSIBLE;
        }

        public Expression handle(Expression x) {
            switch (Primitive.flavor((Type)x.getType())) {
                case PRIMITIVE: {
                    switch (this) {
                        case NULL: 
                        case FALSE: 
                        case TRUE: 
                        case NOT_POSSIBLE: {
                            return x;
                        }
                        case IS_NULL: {
                            return FALSE_EXPR;
                        }
                        case IS_NOT_NULL: {
                            return TRUE_EXPR;
                        }
                    }
                    throw new AssertionError();
                }
                case BOX: {
                    switch (this) {
                        case NOT_POSSIBLE: {
                            return RexToLixTranslator.convert(x, Primitive.ofBox((Type)x.getType()).primitiveClass);
                        }
                    }
                }
            }
            switch (this) {
                case NULL: 
                case NOT_POSSIBLE: {
                    return x;
                }
                case FALSE: {
                    return Expressions.call((Method)BuiltInMethod.IS_TRUE.method, (Expression[])new Expression[]{x});
                }
                case TRUE: {
                    return Expressions.call((Method)BuiltInMethod.IS_NOT_FALSE.method, (Expression[])new Expression[]{x});
                }
                case IS_NULL: {
                    return Expressions.equal((Expression)x, (Expression)NULL_EXPR);
                }
                case IS_NOT_NULL: {
                    return Expressions.notEqual((Expression)x, (Expression)NULL_EXPR);
                }
            }
            throw new AssertionError();
        }
    }
}

