/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;

public abstract class RexProgramBuilderBase {
    protected static final int MAX_FIELDS = 10;
    protected JavaTypeFactory typeFactory;
    protected RexBuilder rexBuilder;
    protected RexExecutor executor;
    protected RexSimplify simplify;
    protected RexLiteral trueLiteral;
    protected RexLiteral falseLiteral;
    protected RexLiteral nullBool;
    protected RexLiteral nullInt;
    protected RexLiteral nullVarchar;
    private RelDataType nullableBool;
    private RelDataType nonNullableBool;
    private RelDataType nullableInt;
    private RelDataType nonNullableInt;
    private RelDataType nullableVarchar;
    private RelDataType nonNullableVarchar;
    private Map<RelDataType, RexDynamicParam> dynamicParams;

    public void setUp() {
        this.typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        this.executor = new RexExecutorImpl((DataContext)new DummyTestDataContext());
        this.simplify = new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, this.executor).withParanoid(true);
        this.trueLiteral = this.rexBuilder.makeLiteral(true);
        this.falseLiteral = this.rexBuilder.makeLiteral(false);
        this.nonNullableInt = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        this.nullableInt = this.typeFactory.createTypeWithNullability(this.nonNullableInt, true);
        this.nullInt = this.rexBuilder.makeNullLiteral(this.nullableInt);
        this.nonNullableBool = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        this.nullableBool = this.typeFactory.createTypeWithNullability(this.nonNullableBool, true);
        this.nullBool = this.rexBuilder.makeNullLiteral(this.nullableBool);
        this.nonNullableVarchar = this.typeFactory.createSqlType(SqlTypeName.VARCHAR);
        this.nullableVarchar = this.typeFactory.createTypeWithNullability(this.nonNullableVarchar, true);
        this.nullVarchar = this.rexBuilder.makeNullLiteral(this.nullableVarchar);
    }

    private RexDynamicParam getDynamicParam(RelDataType type, String fieldNamePrefix) {
        if (this.dynamicParams == null) {
            this.dynamicParams = new HashMap<RelDataType, RexDynamicParam>();
        }
        return this.dynamicParams.computeIfAbsent(type, k -> {
            RelDataType nullableType = this.typeFactory.createTypeWithNullability(k, true);
            RelDataTypeFactory.FieldInfoBuilder builder = this.typeFactory.builder();
            for (int i = 0; i < 10; ++i) {
                builder.add(fieldNamePrefix + i, nullableType);
            }
            String notNullPrefix = "notNull" + Character.toUpperCase(fieldNamePrefix.charAt(0)) + fieldNamePrefix.substring(1);
            for (int i = 0; i < 10; ++i) {
                builder.add(notNullPrefix + i, k);
            }
            return this.rexBuilder.makeDynamicParam(builder.build(), 0);
        });
    }

    protected RexNode isNull(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{node});
    }

    protected RexNode isUnknown(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_UNKNOWN, new RexNode[]{node});
    }

    protected RexNode isNotNull(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{node});
    }

    protected RexNode isFalse(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_FALSE, new RexNode[]{node});
    }

    protected RexNode isNotFalse(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, new RexNode[]{node});
    }

    protected RexNode isTrue(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, new RexNode[]{node});
    }

    protected RexNode isNotTrue(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, new RexNode[]{node});
    }

    protected RexNode isDistinctFrom(RexNode a, RexNode b) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_DISTINCT_FROM, new RexNode[]{a, b});
    }

    protected RexNode isNotDistinctFrom(RexNode a, RexNode b) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{a, b});
    }

    protected RexNode nullIf(RexNode node1, RexNode node2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NULLIF, new RexNode[]{node1, node2});
    }

    protected RexNode not(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{node});
    }

    protected RexNode unaryMinus(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, new RexNode[]{node});
    }

    protected RexNode unaryPlus(RexNode node) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.UNARY_PLUS, new RexNode[]{node});
    }

    protected RexNode and(RexNode ... nodes) {
        return this.and((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    protected RexNode and(Iterable<? extends RexNode> nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, (List)ImmutableList.copyOf(nodes));
    }

    protected RexNode or(RexNode ... nodes) {
        return this.or((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    protected RexNode or(Iterable<? extends RexNode> nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, (List)ImmutableList.copyOf(nodes));
    }

    protected RexNode case_(RexNode ... nodes) {
        return this.case_((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    protected RexNode case_(Iterable<? extends RexNode> nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, (List)ImmutableList.copyOf(nodes));
    }

    protected RexNode abstractCast(RexNode e, RelDataType type) {
        return this.rexBuilder.makeAbstractCast(type, e);
    }

    protected RexNode cast(RexNode e, RelDataType type) {
        return this.rexBuilder.makeCast(type, e);
    }

    protected RexNode eq(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{n1, n2});
    }

    protected RexNode ne(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{n1, n2});
    }

    protected RexNode le(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{n1, n2});
    }

    protected RexNode lt(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{n1, n2});
    }

    protected RexNode ge(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{n1, n2});
    }

    protected RexNode gt(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{n1, n2});
    }

    protected RexNode plus(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{n1, n2});
    }

    protected RexNode mul(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{n1, n2});
    }

    protected RexNode coalesce(RexNode ... nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, nodes);
    }

    protected RexNode divInt(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, new RexNode[]{n1, n2});
    }

    protected RexNode div(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{n1, n2});
    }

    protected RexNode sub(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{n1, n2});
    }

    protected RexNode add(RexNode n1, RexNode n2) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{n1, n2});
    }

    protected RexNode in(RexNode node, RexNode ... nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IN, (List)ImmutableList.builder().add((Object)node).add((Object[])nodes).build());
    }

    protected RelDataType nullable(RelDataType type) {
        if (type.isNullable()) {
            return type;
        }
        return this.typeFactory.createTypeWithNullability(type, true);
    }

    protected RelDataType tVarchar() {
        return this.nonNullableVarchar;
    }

    protected RelDataType tVarchar(boolean nullable) {
        return nullable ? this.nullableVarchar : this.nonNullableVarchar;
    }

    protected RelDataType tBoolean() {
        return this.nonNullableBool;
    }

    protected RelDataType tBoolean(boolean nullable) {
        return nullable ? this.nullableBool : this.nonNullableBool;
    }

    protected RelDataType tInt() {
        return this.nonNullableInt;
    }

    protected RelDataType tInt(boolean nullable) {
        return nullable ? this.nullableInt : this.nonNullableInt;
    }

    protected RexLiteral null_(RelDataType type) {
        return this.rexBuilder.makeNullLiteral(this.nullable(type));
    }

    protected RexNode literal(boolean value) {
        return this.rexBuilder.makeLiteral((Object)value, this.nonNullableBool, false);
    }

    protected RexNode literal(Boolean value) {
        if (value == null) {
            return this.rexBuilder.makeNullLiteral(this.nullableBool);
        }
        return this.literal((boolean)value);
    }

    protected RexNode literal(int value) {
        return this.rexBuilder.makeLiteral((Object)value, this.nonNullableInt, false);
    }

    protected RexNode literal(BigDecimal value) {
        return this.rexBuilder.makeExactLiteral(value);
    }

    protected RexNode literal(BigDecimal value, RelDataType type) {
        return this.rexBuilder.makeExactLiteral(value, type);
    }

    protected RexNode literal(Integer value) {
        if (value == null) {
            return this.rexBuilder.makeNullLiteral(this.nullableInt);
        }
        return this.literal((int)value);
    }

    protected RexNode literal(String value) {
        if (value == null) {
            return this.rexBuilder.makeNullLiteral(this.nullableVarchar);
        }
        return this.rexBuilder.makeLiteral((Object)value, this.nonNullableVarchar, false);
    }

    protected RexNode input(RelDataType type, int arg) {
        return this.rexBuilder.makeInputRef(type, arg);
    }

    private void assertArgValue(int arg) {
        assert (arg >= 0 && arg < 10) : "arg should be in 0..9 range. Actual value was " + arg;
    }

    protected RexNode vBool() {
        return this.vBool(0);
    }

    protected RexNode vBool(int arg) {
        this.assertArgValue(arg);
        return this.rexBuilder.makeFieldAccess((RexNode)this.getDynamicParam(this.nonNullableBool, "bool"), arg);
    }

    protected RexNode vBoolNotNull() {
        return this.vBoolNotNull(0);
    }

    protected RexNode vBoolNotNull(int arg) {
        this.assertArgValue(arg);
        return this.rexBuilder.makeFieldAccess((RexNode)this.getDynamicParam(this.nonNullableBool, "bool"), arg + 10);
    }

    protected RexNode vInt() {
        return this.vInt(0);
    }

    protected RexNode vInt(int arg) {
        this.assertArgValue(arg);
        return this.rexBuilder.makeFieldAccess((RexNode)this.getDynamicParam(this.nonNullableInt, "int"), arg);
    }

    protected RexNode vIntNotNull() {
        return this.vIntNotNull(0);
    }

    protected RexNode vIntNotNull(int arg) {
        this.assertArgValue(arg);
        return this.rexBuilder.makeFieldAccess((RexNode)this.getDynamicParam(this.nonNullableInt, "int"), arg + 10);
    }

    protected RexNode vVarchar() {
        return this.vVarchar(0);
    }

    protected RexNode vVarchar(int arg) {
        this.assertArgValue(arg);
        return this.rexBuilder.makeFieldAccess((RexNode)this.getDynamicParam(this.nonNullableVarchar, "varchar"), arg);
    }

    protected RexNode vVarcharNotNull() {
        return this.vVarcharNotNull(0);
    }

    protected RexNode vVarcharNotNull(int arg) {
        this.assertArgValue(arg);
        return this.rexBuilder.makeFieldAccess((RexNode)this.getDynamicParam(this.nonNullableVarchar, "varchar"), arg + 10);
    }

    private static class DummyTestDataContext
    implements DataContext {
        private final ImmutableMap<String, Object> map;

        DummyTestDataContext() {
            this.map = ImmutableMap.of((Object)DataContext.Variable.TIME_ZONE.camelName, (Object)TimeZone.getTimeZone("America/Los_Angeles"), (Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)1311120000000L);
        }

        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            return this.map.get((Object)name);
        }
    }
}

