/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.TableMacroImpl;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.util.Smalls;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ReflectiveSchemaTest {
    public static final Method LINQ4J_AS_ENUMERABLE_METHOD = Types.lookupMethod(Linq4j.class, (String)"asEnumerable", (Class[])new Class[]{Object[].class});
    private static final ReflectiveSchema CATCHALL = new ReflectiveSchema((Object)new CatchallSchema());

    @Test
    public void testQueryProvider() throws Exception {
        Connection connection = CalciteAssert.that(CalciteAssert.Config.REGULAR).connect();
        QueryProvider queryProvider = connection.unwrap(QueryProvider.class);
        ParameterExpression e = Expressions.parameter(JdbcTest.Employee.class, (String)"e");
        List list = queryProvider.createQuery((Expression)Expressions.call((Expression)Expressions.call((Type)Types.of(Enumerable.class, (Type[])new Type[]{JdbcTest.Employee.class}), null, (Method)LINQ4J_AS_ENUMERABLE_METHOD, (Expression[])new Expression[]{Expressions.constant((Object)new JdbcTest.HrSchema().emps)}), (String)"asQueryable", (Expression[])new Expression[0]), JdbcTest.Employee.class).where(Expressions.lambda((Expression)Expressions.lessThan((Expression)Expressions.field((Expression)e, (String)"empid"), (Expression)Expressions.constant((Object)160)), (ParameterExpression[])new ParameterExpression[]{e})).where(Expressions.lambda((Expression)Expressions.greaterThan((Expression)Expressions.field((Expression)e, (String)"empid"), (Expression)Expressions.constant((Object)140)), (ParameterExpression[])new ParameterExpression[]{e})).select(Expressions.lambda((Expression)Expressions.new_(Object[].class, (Expression[])new Expression[]{Expressions.field((Expression)e, (String)"empid"), Expressions.call((Expression)Expressions.field((Expression)e, (String)"name"), (String)"toUpperCase", (Expression[])new Expression[0])}), (ParameterExpression[])new ParameterExpression[]{e})).toList();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)150, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"SEBASTIAN", (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testQueryProviderSingleColumn() throws Exception {
        Connection connection = CalciteAssert.that(CalciteAssert.Config.REGULAR).connect();
        QueryProvider queryProvider = connection.unwrap(QueryProvider.class);
        ParameterExpression e = Expressions.parameter(JdbcTest.Employee.class, (String)"e");
        List list = queryProvider.createQuery((Expression)Expressions.call((Expression)Expressions.call((Type)Types.of(Enumerable.class, (Type[])new Type[]{JdbcTest.Employee.class}), null, (Method)LINQ4J_AS_ENUMERABLE_METHOD, (Expression[])new Expression[]{Expressions.constant((Object)new JdbcTest.HrSchema().emps)}), (String)"asQueryable", (Expression[])new Expression[0]), JdbcTest.Employee.class).select(Expressions.lambda((Expression)Expressions.field((Expression)e, (String)"empid"), (ParameterExpression[])new ParameterExpression[]{e})).toList();
        Assert.assertEquals(Arrays.asList(100, 200, 150, 110), (Object)list);
    }

    @Ignore
    @Test
    public void testOperator() throws SQLException, ClassNotFoundException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("GenerateStrings", (Function)TableMacroImpl.create((Method)Smalls.GENERATE_STRINGS_METHOD));
        schema.add("StringUnion", (Function)TableMacroImpl.create((Method)Smalls.STRING_UNION_METHOD));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(s.StringUnion(\n  GenerateStrings(5),\n  cursor (select name from emps)))\nwhere char_length(s) > 3");
        Assert.assertTrue((boolean)resultSet.next());
    }

    @Test
    public void testView() throws SQLException, ClassNotFoundException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("emps_view", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"hr\".\"emps\" where \"deptno\" = 10", null, Arrays.asList("s", "emps_view"), null));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom \"s\".\"emps_view\"\nwhere \"empid\" < 120");
        Assert.assertEquals((Object)"empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n", (Object)CalciteAssert.toString(resultSet));
    }

    @Test
    public void testViewPath() throws SQLException, ClassNotFoundException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\" where \"deptno\" = 10", (List)ImmutableList.of((Object)"hr"), (List)ImmutableList.of((Object)"s", (Object)"emps"), null));
        schema.add("hr_emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\"", (List)ImmutableList.of((Object)"hr"), (List)ImmutableList.of((Object)"s", (Object)"hr_emps"), null));
        schema.add("s_emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\"", (List)ImmutableList.of((Object)"s"), (List)ImmutableList.of((Object)"s", (Object)"s_emps"), null));
        schema.add("null_emps", (Function)ViewTable.viewMacro((SchemaPlus)schema, (String)"select * from \"emps\"", null, (List)ImmutableList.of((Object)"s", (Object)"null_emps"), null));
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from \"s\".\"hr_emps\"");
        Assert.assertEquals((long)4L, (long)this.count(resultSet));
        resultSet = statement.executeQuery("select * from \"s\".\"s_emps\"");
        Assert.assertEquals((long)3L, (long)this.count(resultSet));
        resultSet = statement.executeQuery("select * from \"s\".\"null_emps\"");
        Assert.assertEquals((long)3L, (long)this.count(resultSet));
        statement.close();
    }

    private int count(ResultSet resultSet) throws SQLException {
        int i = 0;
        while (resultSet.next()) {
            ++i;
        }
        resultSet.close();
        return i;
    }

    @Test
    public void testDateColumn() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)new ReflectiveSchema((Object)new DateColumnSchema())).query("select * from \"s\".\"emps\"").returns("hireDate=1970-01-01; empid=10; deptno=20; name=fred; salary=0.0; commission=null\nhireDate=1970-04-11; empid=10; deptno=20; name=bill; salary=0.0; commission=null\n");
    }

    @Test
    public void testNoPublicFields() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select 1 from \"s\".\"allPrivates\"").returns("EXPR$0=1\n");
        with.query("select \"x\" from \"s\".\"allPrivates\"").throws_("Column 'x' not found in any table");
    }

    @Test
    public void testColumnTypes() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select \"primitiveBoolean\" from \"s\".\"everyTypes\"").returns("primitiveBoolean=false\nprimitiveBoolean=true\n");
        with.query("select * from \"s\".\"everyTypes\"").returns("primitiveBoolean=false; primitiveByte=0; primitiveChar=\u0000; primitiveShort=0; primitiveInt=0; primitiveLong=0; primitiveFloat=0.0; primitiveDouble=0.0; wrapperBoolean=false; wrapperByte=0; wrapperCharacter=\u0000; wrapperShort=0; wrapperInteger=0; wrapperLong=0; wrapperFloat=0.0; wrapperDouble=0.0; sqlDate=1970-01-01; sqlTime=00:00:00; sqlTimestamp=1970-01-01 00:00:00; utilDate=1970-01-01 00:00:00; string=1\nprimitiveBoolean=true; primitiveByte=127; primitiveChar=\uffff; primitiveShort=32767; primitiveInt=2147483647; primitiveLong=9223372036854775807; primitiveFloat=3.4028235E38; primitiveDouble=1.7976931348623157E308; wrapperBoolean=null; wrapperByte=null; wrapperCharacter=null; wrapperShort=null; wrapperInteger=null; wrapperLong=null; wrapperFloat=null; wrapperDouble=null; sqlDate=null; sqlTime=null; sqlTimestamp=null; utilDate=null; string=null\n");
    }

    @Test
    public void testWhereNOT() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select \"wrapperByte\" from \"s\".\"everyTypes\" where NOT (\"wrapperByte\" is null)").returnsUnordered("wrapperByte=0");
    }

    @Test
    public void testSelectNOT() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select NOT \"wrapperBoolean\" \"value\" from \"s\".\"everyTypes\"").returnsUnordered("value=null", "value=true");
    }

    @Test
    public void testSelectWithFieldAccessOnFirstLevelRecordType() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"birthPlace\".\"city\" as city from \"bookstore\".\"authors\" au\n").returnsUnordered("CITY=Heraklion", "CITY=Besan\u00e7on", "CITY=Ionia");
    }

    @Test
    public void testSelectWithFieldAccessOnSecondLevelRecordType() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"birthPlace\".\"coords\".\"latitude\" as lat\nfrom \"bookstore\".\"authors\" au\n").returnsUnordered("LAT=47.24", "LAT=35.3387", "LAT=null");
    }

    @Test
    public void testWhereWithFieldAccessOnFirstLevelRecordType() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"aid\" as aid from \"bookstore\".\"authors\" au\nwhere au.\"birthPlace\".\"city\"='Heraklion'").returnsUnordered("AID=2");
    }

    @Test
    public void testWhereWithFieldAccessOnSecondLevelRecordType() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"aid\" as aid from \"bookstore\".\"authors\" au\nwhere au.\"birthPlace\".\"coords\".\"latitude\"=35.3387").returnsUnordered("AID=2");
    }

    @Test
    public void testSelectWithFieldAccessOnFirstLevelRecordTypeArray() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"books\"[1].\"title\" as title from \"bookstore\".\"authors\" au\n").returnsUnordered("TITLE=Les Mis\u00e9rables", "TITLE=Zorba the Greek", "TITLE=null");
    }

    @Test
    public void testSelectWithFieldAccessOnSecondLevelRecordTypeArray() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"books\"[1].\"pages\"[1].\"pageNo\" as pno\nfrom \"bookstore\".\"authors\" au\n").returnsUnordered("PNO=1", "PNO=1", "PNO=null");
    }

    @Test
    public void testWhereWithFieldAccessOnFirstLevelRecordTypeArray() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"aid\" as aid from \"bookstore\".\"authors\" au\nwhere au.\"books\"[1].\"title\"='Les Mis\u00e9rables'").returnsUnordered("AID=1");
    }

    @Test
    public void testWhereWithFieldAccessOnSecondLevelRecordTypeArray() {
        CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).query("select au.\"aid\" as aid from \"bookstore\".\"authors\" au\nwhere au.\"books\"[1].\"pages\"[2].\"contentType\"='Acknowledgements'").returnsUnordered("AID=2");
    }

    @Test
    public void testAggregateFunctions() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        this.checkAgg(with, "min");
        this.checkAgg(with, "max");
        this.checkAgg(with, "avg");
        this.checkAgg(with, "count");
    }

    private void checkAgg(CalciteAssert.AssertThat with, String fn) {
        for (Field field : fn.equals("avg") ? EveryType.numericFields() : EveryType.fields()) {
            with.query("select " + fn + "(\"" + field.getName() + "\") as c\nfrom \"s\".\"everyTypes\"").returns(input -> {
                int n = 0;
                try {
                    while (input.next()) {
                        Object o = this.get((ResultSet)input);
                        Util.discard((Object)o);
                        ++n;
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertThat((Object)n, (Matcher)CoreMatchers.equalTo((Object)1));
            });
        }
    }

    private Object get(ResultSet input) throws SQLException {
        int type = input.getMetaData().getColumnType(1);
        switch (type) {
            case 16: {
                return input.getBoolean(1);
            }
            case -6: {
                return input.getByte(1);
            }
            case 5: {
                return input.getShort(1);
            }
            case 4: {
                return input.getInt(1);
            }
            case -5: {
                return input.getLong(1);
            }
            case 7: {
                return Float.valueOf(input.getFloat(1));
            }
            case 8: {
                return input.getDouble(1);
            }
            case 1: 
            case 12: {
                return input.getString(1);
            }
            case 91: {
                return input.getDate(1);
            }
            case 92: {
                return input.getTime(1);
            }
            case 93: {
                return input.getTimestamp(1);
            }
        }
        throw new AssertionError(type);
    }

    @Test
    public void testClassNames() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select * from \"s\".\"everyTypes\"").returns(resultSet -> {
            try {
                ResultSetMetaData metaData = resultSet.getMetaData();
                this.check(metaData, "primitiveBoolean", Boolean.class);
                this.check(metaData, "primitiveByte", Byte.class);
                this.check(metaData, "primitiveChar", String.class);
                this.check(metaData, "primitiveShort", Short.class);
                this.check(metaData, "primitiveInt", Integer.class);
                this.check(metaData, "primitiveLong", Long.class);
                this.check(metaData, "primitiveFloat", Float.class);
                this.check(metaData, "primitiveDouble", Double.class);
                this.check(metaData, "wrapperBoolean", Boolean.class);
                this.check(metaData, "wrapperByte", Byte.class);
                this.check(metaData, "wrapperCharacter", String.class);
                this.check(metaData, "wrapperShort", Short.class);
                this.check(metaData, "wrapperInteger", Integer.class);
                this.check(metaData, "wrapperLong", Long.class);
                this.check(metaData, "wrapperFloat", Float.class);
                this.check(metaData, "wrapperDouble", Double.class);
                this.check(metaData, "sqlDate", Date.class);
                this.check(metaData, "sqlTime", Time.class);
                this.check(metaData, "sqlTimestamp", Timestamp.class);
                this.check(metaData, "utilDate", Timestamp.class);
                this.check(metaData, "string", String.class);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void check(ResultSetMetaData metaData, String columnName, Class expectedType) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (!metaData.getColumnName(i).equals(columnName)) continue;
            Assert.assertThat((Object)metaData.getColumnClassName(i), (Matcher)CoreMatchers.equalTo((Object)expectedType.getName()));
            return;
        }
        Assert.fail((String)("column not found: " + columnName));
    }

    @Test
    public void testJavaBoolean() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"primitiveBoolean\"").returns("C=1\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\"").returns("C=0\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\" is true").returns("C=0\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\" is not true").returns("C=2\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\" is false").returns("C=1\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\" is not false").returns("C=1\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\" is null").returns("C=1\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"wrapperBoolean\" is not null").returns("C=1\n");
        with.query("select count(*) as c from \"s\".\"everyTypes\"\nwhere \"primitiveInt\" > 0").returns("C=1\n");
    }

    @Test
    public void testCompareJavaAndSqlTypes() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select \"primitiveLong\" as c from \"s\".\"everyTypes\"\nwhere \"primitiveLong\" > 0").returns("C=9223372036854775807\n");
        with.query("select count(\"primitiveBoolean\") as p,\n  count(\"wrapperBoolean\") as w,\n  count(nullif(\"primitiveShort\" >= 0, false)) as sp,\n  count(nullif(\"wrapperShort\" >= 0, false)) as sw,\n  count(nullif(\"primitiveInt\" >= 0, false)) as ip,\n  count(nullif(\"wrapperInteger\" >= 0, false)) as iw,\n  count(nullif(\"primitiveLong\" >= 0, false)) as lp,\n  count(nullif(\"wrapperLong\" >= 0, false)) as lw\nfrom \"s\".\"everyTypes\"").returns("P=2; W=1; SP=2; SW=1; IP=2; IW=1; LP=2; LW=1\n");
    }

    @Test
    public void testDivideWraperPrimitive() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select \"wrapperLong\" / \"primitiveLong\" as c\n from \"s\".\"everyTypes\" where \"primitiveLong\" <> 0").planContains("final Long inp13_ = current.wrapperLong;").planContains("return inp13_ == null ? (Long) null : Long.valueOf(inp13_.longValue() / current.primitiveLong);").returns("C=null\n");
    }

    @Test
    public void testDivideWraperWrapper() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select \"wrapperLong\" / \"wrapperLong\" as c\n from \"s\".\"everyTypes\" where \"primitiveLong\" <> 0").planContains("final Long inp13_ = ((org.apache.calcite.test.ReflectiveSchemaTest.EveryType) inputEnumerator.current()).wrapperLong;").planContains("return inp13_ == null ? (Long) null : Long.valueOf(inp13_.longValue() / inp13_.longValue());").returns("C=null\n");
    }

    @Test
    public void testDivideWraperWrapperMultipleTimes() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select \"wrapperLong\" / \"wrapperLong\"\n+ \"wrapperLong\" / \"wrapperLong\" as c\n from \"s\".\"everyTypes\" where \"primitiveLong\" <> 0").planContains("final Long inp13_ = ((org.apache.calcite.test.ReflectiveSchemaTest.EveryType) inputEnumerator.current()).wrapperLong;").planContains("return inp13_ == null ? (Long) null : Long.valueOf(inp13_.longValue() / inp13_.longValue() + inp13_.longValue() / inp13_.longValue());").returns("C=null\n");
    }

    @Test
    public void testOp() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        this.checkOp(with, "+");
        this.checkOp(with, "-");
        this.checkOp(with, "*");
        this.checkOp(with, "/");
    }

    private void checkOp(CalciteAssert.AssertThat with, String fn) {
        for (Field field : EveryType.numericFields()) {
            for (Field field2 : EveryType.numericFields()) {
                String name = "\"" + field.getName() + "\"";
                String name2 = "\"" + field2.getName() + "\"";
                with.query("select " + name + "\n " + fn + " " + name2 + " as c\nfrom \"s\".\"everyTypes\"\nwhere " + name + " <> 0").returns(resultSet -> {});
            }
        }
    }

    @Test
    public void testCastFromString() {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select cast(\"string\" as int) as c from \"s\".\"everyTypes\"").returns("C=1\nC=null\n");
    }

    @Test
    public void testAvgInt() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).with(Lex.JAVA).query("select primitiveLong, avg(primitiveInt)\nfrom s.everyTypes\ngroup by primitiveLong order by primitiveLong").returns(input -> {
            StringBuilder buf = new StringBuilder();
            try {
                while (input.next()) {
                    buf.append(input.getInt(2)).append("\n");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"0\n2147483647\n"));
        });
    }

    private static boolean isNumeric(Class type) {
        switch (Primitive.flavor((Type)type)) {
            case BOX: {
                return Primitive.ofBox((Type)type).isNumeric();
            }
            case PRIMITIVE: {
                return Primitive.of((Type)type).isNumeric();
            }
        }
        return Number.class.isAssignableFrom(type);
    }

    @Test
    public void testTableFieldHasBadType() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select * from \"s\".\"badTypes\"").returns("integer=0; bitSet={}\n");
    }

    @Test
    public void testSchemaFieldHasBadType() throws Exception {
        CalciteAssert.AssertThat with = CalciteAssert.that().withSchema("s", (Schema)CATCHALL);
        with.query("select * from \"s\".\"bitSet\"").throws_("Object 'bitSet' not found within 's'");
        with.query("select * from \"s\".\"enumerable\"").returns("\n\n\n\n");
        with.query("select * from \"s\".\"list\"").returns("\n\n\n\n");
    }

    @Test
    public void testPrefix() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select * from \"s\".\"prefixEmps\" where \"name\" in ('Ab', 'Abd')").returns("empid=2; deptno=10; name=Ab; salary=0.0; commission=null\nempid=4; deptno=10; name=Abd; salary=0.0; commission=null\n");
    }

    @Ignore
    @Test
    public void testTableMacroIsView() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema())).query("select * from table(\"s\".\"view\"('abc'))").returns("empid=2; deptno=10; name=Ab; salary=0.0; commission=null\nempid=4; deptno=10; name=Abd; salary=0.0; commission=null\n");
    }

    @Ignore
    @Test
    public void testTableMacro() throws Exception {
        CalciteAssert.that().withSchema("s", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema())).query("select * from table(\"s\".\"foo\"(3))").returns("empid=2; deptno=10; name=Ab; salary=0.0; commission=null\nempid=4; deptno=10; name=Abd; salary=0.0; commission=null\n");
    }

    @Ignore(value="java.lang.AssertionError RelDataTypeImpl.getFieldList(RelDataTypeImpl.java:99)")
    @Test
    public void testArrayOfBoxedPrimitives() {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select * from \"s\".\"primesBoxed\"").returnsUnordered("value=1", "value=3", "value=7");
    }

    @Ignore(value="java.lang.AssertionError RelDataTypeImpl.getFieldList(RelDataTypeImpl.java:99)")
    @Test
    public void testArrayOfPrimitives() {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select * from \"s\".\"primes\"").returnsUnordered("value=1", "value=3", "value=7");
    }

    @Test
    public void testCustomBoxedScalar() {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select \"value\" from \"s\".\"primesCustomBoxed\"").returnsUnordered("value=1", "value=3", "value=5");
    }

    @Test
    public void testCustomBoxedSalarCalc() {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select \"value\"*2 \"value\" from \"s\".\"primesCustomBoxed\"").returnsUnordered("value=2", "value=6", "value=10");
    }

    @Test
    public void testDateCanCompare() {
        String sql = "select a.v\nfrom (select \"sqlDate\" v\n  from \"s\".\"everyTypes\"   group by \"sqlDate\") a,    (select \"sqlDate\" v\n  from \"s\".\"everyTypes\"\n  group by \"sqlDate\") b\nwhere a.v >= b.v\ngroup by a.v";
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select a.v\nfrom (select \"sqlDate\" v\n  from \"s\".\"everyTypes\"   group by \"sqlDate\") a,    (select \"sqlDate\" v\n  from \"s\".\"everyTypes\"\n  group by \"sqlDate\") b\nwhere a.v >= b.v\ngroup by a.v").returnsUnordered("V=1970-01-01");
    }

    @Test
    public void testReflectiveSchemaInUnnamedPackage() throws Exception {
        Driver driver = new Driver();
        try (CalciteConnection connection = (CalciteConnection)driver.connect("jdbc:calcite:", new Properties());){
            SchemaPlus rootSchema = connection.getRootSchema();
            Class<?> c = Class.forName("RootHr");
            Object o = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            rootSchema.add("hr", (Schema)new ReflectiveSchema(o));
            connection.setSchema("hr");
            Statement statement = connection.createStatement();
            String sql = "select * from \"emps\"";
            ResultSet resultSet = statement.executeQuery("select * from \"emps\"");
            String expected = "empid=100; name=Bill\nempid=200; name=Eric\nempid=150; name=Sebastian\n";
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"empid=100; name=Bill\nempid=200; name=Eric\nempid=150; name=Sebastian\n"));
        }
    }

    @Test
    public void testUnknownInOr() {
        CalciteAssert.that().withSchema("s", (Schema)CATCHALL).query("select (\"value\" = 3 and unknown) or ( \"value\"  = 3 ) from \"s\".\"primesCustomBoxed\"").returnsUnordered("EXPR$0=false\nEXPR$0=false\nEXPR$0=true");
    }

    public static class DateColumnSchema {
        public final EmployeeWithHireDate[] emps = new EmployeeWithHireDate[]{new EmployeeWithHireDate(10, 20, "fred", 0.0f, null, new Date(0L)), new EmployeeWithHireDate(10, 20, "bill", 0.0f, null, new Date(8640000000L))};
    }

    public static class IntHolder {
        public final int value;

        public IntHolder(int value) {
            this.value = value;
        }
    }

    public static class CatchallSchema {
        public final Enumerable<JdbcTest.Employee> enumerable;
        public final List<JdbcTest.Employee> list;
        public final BitSet bitSet;
        public final EveryType[] everyTypes;
        public final AllPrivate[] allPrivates;
        public final BadType[] badTypes;
        public final JdbcTest.Employee[] prefixEmps;
        public final Integer[] primesBoxed;
        public final int[] primes;
        public final IntHolder[] primesCustomBoxed;
        public final IntAndString[] nullables;
        public final IntAndString[] bools;

        public CatchallSchema() {
            this.enumerable = Linq4j.asEnumerable(Arrays.asList(new JdbcTest.HrSchema().emps));
            this.list = Arrays.asList(new JdbcTest.HrSchema().emps);
            this.bitSet = new BitSet(1);
            this.everyTypes = new EveryType[]{new EveryType(false, 0, '\u0000', 0, 0, 0L, 0.0f, 0.0, false, (byte)0, Character.valueOf('\u0000'), (short)0, 0, 0L, Float.valueOf(0.0f), 0.0, new Date(0L), new Time(0L), new Timestamp(0L), new java.util.Date(0L), "1"), new EveryType(true, 127, '\uffff', Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.MAX_VALUE, Double.MAX_VALUE, null, null, null, null, null, null, null, null, null, null, null, null, null)};
            this.allPrivates = new AllPrivate[]{new AllPrivate()};
            this.badTypes = new BadType[]{new BadType()};
            this.prefixEmps = new JdbcTest.Employee[]{new JdbcTest.Employee(1, 10, "A", 0.0f, null), new JdbcTest.Employee(2, 10, "Ab", 0.0f, null), new JdbcTest.Employee(3, 10, "Abc", 0.0f, null), new JdbcTest.Employee(4, 10, "Abd", 0.0f, null)};
            this.primesBoxed = new Integer[]{1, 3, 5};
            this.primes = new int[]{1, 3, 5};
            this.primesCustomBoxed = new IntHolder[]{new IntHolder(1), new IntHolder(3), new IntHolder(5)};
            this.nullables = new IntAndString[]{new IntAndString(1, "A"), new IntAndString(2, "B"), new IntAndString(2, "C"), new IntAndString(3, null)};
            this.bools = new IntAndString[]{new IntAndString(1, "T"), new IntAndString(2, "F"), new IntAndString(3, null)};
        }
    }

    public static class IntAndString {
        public final int id;
        public final String value;

        public IntAndString(int id, String value) {
            this.id = id;
            this.value = value;
        }
    }

    public static class BadType {
        public final int integer = 0;
        public final BitSet bitSet = new BitSet(0);
    }

    public static class AllPrivate {
        private final int x = 0;
    }

    public static class EveryType {
        public final boolean primitiveBoolean;
        public final byte primitiveByte;
        public final char primitiveChar;
        public final short primitiveShort;
        public final int primitiveInt;
        public final long primitiveLong;
        public final float primitiveFloat;
        public final double primitiveDouble;
        public final Boolean wrapperBoolean;
        public final Byte wrapperByte;
        public final Character wrapperCharacter;
        public final Short wrapperShort;
        public final Integer wrapperInteger;
        public final Long wrapperLong;
        public final Float wrapperFloat;
        public final Double wrapperDouble;
        public final Date sqlDate;
        public final Time sqlTime;
        public final Timestamp sqlTimestamp;
        public final java.util.Date utilDate;
        public final String string;

        public EveryType(boolean primitiveBoolean, byte primitiveByte, char primitiveChar, short primitiveShort, int primitiveInt, long primitiveLong, float primitiveFloat, double primitiveDouble, Boolean wrapperBoolean, Byte wrapperByte, Character wrapperCharacter, Short wrapperShort, Integer wrapperInteger, Long wrapperLong, Float wrapperFloat, Double wrapperDouble, Date sqlDate, Time sqlTime, Timestamp sqlTimestamp, java.util.Date utilDate, String string) {
            this.primitiveBoolean = primitiveBoolean;
            this.primitiveByte = primitiveByte;
            this.primitiveChar = primitiveChar;
            this.primitiveShort = primitiveShort;
            this.primitiveInt = primitiveInt;
            this.primitiveLong = primitiveLong;
            this.primitiveFloat = primitiveFloat;
            this.primitiveDouble = primitiveDouble;
            this.wrapperBoolean = wrapperBoolean;
            this.wrapperByte = wrapperByte;
            this.wrapperCharacter = wrapperCharacter;
            this.wrapperShort = wrapperShort;
            this.wrapperInteger = wrapperInteger;
            this.wrapperLong = wrapperLong;
            this.wrapperFloat = wrapperFloat;
            this.wrapperDouble = wrapperDouble;
            this.sqlDate = sqlDate;
            this.sqlTime = sqlTime;
            this.sqlTimestamp = sqlTimestamp;
            this.utilDate = utilDate;
            this.string = string;
        }

        static Enumerable<Field> fields() {
            return Linq4j.asEnumerable((Object[])EveryType.class.getFields());
        }

        static Enumerable<Field> numericFields() {
            return EveryType.fields().where(v1 -> ReflectiveSchemaTest.isNumeric(v1.getType()));
        }
    }

    public static class EmployeeWithHireDate
    extends JdbcTest.Employee {
        public final Date hireDate;

        public EmployeeWithHireDate(int empid, int deptno, String name, float salary, Integer commission, Date hireDate) {
            super(empid, deptno, name, salary, commission);
            this.hireDate = hireDate;
        }
    }
}

