/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.rules.CalcMergeRule;
import org.apache.calcite.rel.rules.CoerceInputsRule;
import org.apache.calcite.rel.rules.FilterToCalcRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.ProjectToCalcRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.UnionToDistinctRule;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.RelOptTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HepPlannerTest
extends RelOptTestBase {
    private static final String UNION_TREE = "(select name from dept union select ename from emp) union (select ename from bonus)";
    private static final String COMPLEX_UNION_TREE = "select * from (\n  select ENAME, 50011895 as cat_id, '1' as cat_name, 1 as require_free_postage, 0 as require_15return, 0 as require_48hour,1 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50011895 union all\n  select ENAME, 50013023 as cat_id, '2' as cat_name, 0 as require_free_postage, 0 as require_15return, 0 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50013023 union all\n  select ENAME, 50013032 as cat_id, '3' as cat_name, 0 as require_free_postage, 0 as require_15return, 0 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50013032 union all\n  select ENAME, 50013024 as cat_id, '4' as cat_name, 0 as require_free_postage, 0 as require_15return, 0 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50013024 union all\n  select ENAME, 50004204 as cat_id, '5' as cat_name, 0 as require_free_postage, 0 as require_15return, 0 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50004204 union all\n  select ENAME, 50013043 as cat_id, '6' as cat_name, 0 as require_free_postage, 0 as require_15return, 0 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50013043 union all\n  select ENAME, 290903 as cat_id, '7' as cat_name, 1 as require_free_postage, 0 as require_15return, 0 as require_48hour,1 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 290903 union all\n  select ENAME, 50008261 as cat_id, '8' as cat_name, 1 as require_free_postage, 0 as require_15return, 0 as require_48hour,1 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50008261 union all\n  select ENAME, 124478013 as cat_id, '9' as cat_name, 0 as require_free_postage, 0 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 124478013 union all\n  select ENAME, 124472005 as cat_id, '10' as cat_name, 0 as require_free_postage, 0 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 124472005 union all\n  select ENAME, 50013475 as cat_id, '11' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50013475 union all\n  select ENAME, 50018263 as cat_id, '12' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50018263 union all\n  select ENAME, 50013498 as cat_id, '13' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50013498 union all\n  select ENAME, 350511 as cat_id, '14' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 350511 union all\n  select ENAME, 50019790 as cat_id, '15' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50019790 union all\n  select ENAME, 50015382 as cat_id, '16' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50015382 union all\n  select ENAME, 350503 as cat_id, '17' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 350503 union all\n  select ENAME, 350401 as cat_id, '18' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 350401 union all\n  select ENAME, 50015560 as cat_id, '19' as cat_name, 0 as require_free_postage, 0 as require_15return, 0 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50015560 union all\n  select ENAME, 122658003 as cat_id, '20' as cat_name, 0 as require_free_postage, 1 as require_15return, 1 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 122658003 union all\n  select ENAME, 50022371 as cat_id, '100' as cat_name, 0 as require_free_postage, 0 as require_15return, 0 as require_48hour,0 as require_insurance from emp where EMPNO = 20171216 and MGR = 0 and ENAME = 'Y' and SAL = 50022371\n) a";

    @Override
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(HepPlannerTest.class);
    }

    @Test
    public void testRuleClass() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleClass(CoerceInputsRule.class);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addRule((RelOptRule)new CoerceInputsRule(LogicalUnion.class, false, RelFactories.LOGICAL_BUILDER));
        planner.addRule((RelOptRule)new CoerceInputsRule(LogicalIntersect.class, false, RelFactories.LOGICAL_BUILDER));
        this.checkPlanning((RelOptPlanner)planner, "(select name from dept union select ename from emp) intersect (select fname from customer.contact)");
    }

    @Test
    public void testRuleDescription() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleByDescription("FilterToCalcRule");
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addRule((RelOptRule)FilterToCalcRule.INSTANCE);
        this.checkPlanning((RelOptPlanner)planner, "select name from sales.dept where deptno=12");
    }

    @Test
    public void relDigestLength() {
        HepProgramBuilder programBuilder = HepProgram.builder();
        HepPlanner planner = new HepPlanner(programBuilder.build());
        StringBuilder sb = new StringBuilder();
        int n = 10;
        sb.append("select * from (");
        sb.append("select name from sales.dept");
        for (int i = 0; i < 10; ++i) {
            sb.append(" union all select name from sales.dept");
        }
        sb.append(")");
        RelRoot root = this.tester.convertSqlToRel(sb.toString());
        planner.setRoot(root.rel);
        RelNode best = planner.findBestExp();
        this.assertIncludesExactlyOnce("best.getDescription()", best.getDescription(), "LogicalUnion");
        this.assertIncludesExactlyOnce("best.getDigest()", best.getDigest(), "LogicalUnion");
    }

    private void assertIncludesExactlyOnce(String message, String digest, String substring) {
        int pos = 0;
        int cnt = 0;
        while (pos >= 0) {
            if ((pos = digest.indexOf(substring, pos + 1)) <= 0) continue;
            ++cnt;
        }
        Assert.assertEquals((String)(message + " should include <<" + substring + ">> exactly once, actual value is " + digest), (long)1L, (long)cnt);
    }

    @Test
    public void testMatchLimitOneTopDown() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        programBuilder.addMatchLimit(1);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testMatchLimitOneBottomUp() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchLimit(1);
        programBuilder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testMatchUntilFixpoint() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchLimit(Integer.MAX_VALUE);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testReplaceCommonSubexpression() throws Exception {
        this.checkPlanning((RelOptRule)ProjectRemoveRule.INSTANCE, "select d1.deptno from (select * from dept) d1, (select * from dept) d2");
    }

    @Test
    public void testCommonSubExpression() {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE);
        HepTestListener listener = new HepTestListener(0L);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addListener((RelOptListener)listener);
        String sql = "(select 1 from dept where abs(-1)=20)\nunion all\n(select 1 from dept where abs(-1)=20)";
        planner.setRoot(this.tester.convertSqlToRel((String)"(select 1 from dept where abs(-1)=20)\nunion all\n(select 1 from dept where abs(-1)=20)").rel);
        RelNode bestRel = planner.findBestExp();
        Assert.assertThat((Object)bestRel.getInput(0).equals(bestRel.getInput(1)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)(listener.getApplyTimes() == 1L ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSubprogram() throws Exception {
        HepProgramBuilder subprogramBuilder = HepProgram.builder();
        subprogramBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        subprogramBuilder.addMatchLimit(1);
        subprogramBuilder.addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE);
        subprogramBuilder.addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE);
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addSubprogram(subprogramBuilder.build());
        this.checkPlanning(programBuilder.build(), "select upper(ename) from (select lower(ename) as ename from emp)");
    }

    @Test
    public void testGroup() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addGroupBegin();
        programBuilder.addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE);
        programBuilder.addGroupEnd();
        this.checkPlanning(programBuilder.build(), "select upper(name) from dept where deptno=20");
    }

    @Test
    public void testGC() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        programBuilder.addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.setRoot(this.tester.convertSqlToRel((String)"select upper(name) from dept where deptno=20").rel);
        planner.findBestExp();
        planner.setRoot(this.tester.convertSqlToRel((String)"select upper(name) from dept where deptno=20").rel);
        planner.findBestExp();
    }

    @Test
    public void testRuleApplyCount() {
        long applyTimes1 = this.checkRuleApplyCount(HepMatchOrder.ARBITRARY);
        Assert.assertThat((Object)applyTimes1, (Matcher)CoreMatchers.is((Object)316L));
        long applyTimes2 = this.checkRuleApplyCount(HepMatchOrder.DEPTH_FIRST);
        Assert.assertThat((Object)applyTimes2, (Matcher)CoreMatchers.is((Object)87L));
    }

    @Test
    public void testMaterialization() throws Exception {
        RelNode tableRel;
        HepPlanner planner = new HepPlanner(HepProgram.builder().build());
        RelNode queryRel = tableRel = this.tester.convertSqlToRel((String)"select * from dept").rel;
        RelOptMaterialization mat1 = new RelOptMaterialization(tableRel, queryRel, null, (List)ImmutableList.of((Object)"default", (Object)"mv"));
        planner.addMaterialization(mat1);
        Assert.assertEquals((long)planner.getMaterializations().size(), (long)1L);
        Assert.assertEquals((Object)planner.getMaterializations().get(0), (Object)mat1);
        planner.clear();
        Assert.assertEquals((long)planner.getMaterializations().size(), (long)0L);
    }

    private long checkRuleApplyCount(HepMatchOrder matchOrder) {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchOrder(matchOrder);
        programBuilder.addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE);
        HepTestListener listener = new HepTestListener(0L);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addListener((RelOptListener)listener);
        planner.setRoot(this.tester.convertSqlToRel((String)COMPLEX_UNION_TREE).rel);
        planner.findBestExp();
        return listener.getApplyTimes();
    }

    private class HepTestListener
    implements RelOptListener {
        private long applyTimes;

        HepTestListener(long applyTimes) {
            this.applyTimes = applyTimes;
        }

        long getApplyTimes() {
            return this.applyTimes;
        }

        public void relEquivalenceFound(RelOptListener.RelEquivalenceEvent event) {
        }

        public void ruleAttempted(RelOptListener.RuleAttemptedEvent event) {
            if (event.isBefore()) {
                ++this.applyTimes;
            }
        }

        public void ruleProductionSucceeded(RelOptListener.RuleProductionEvent event) {
        }

        public void relDiscarded(RelOptListener.RelDiscardedEvent event) {
        }

        public void relChosen(RelOptListener.RelChosenEvent event) {
        }
    }
}

