/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelCompositeTrait;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.junit.Assert;
import org.junit.Test;

public class RelTraitTest {
    private static final RelCollationTraitDef COLLATION = RelCollationTraitDef.INSTANCE;

    private void assertCanonical(String message, Supplier<List<RelCollation>> collation) {
        RelTrait trait1 = RelCompositeTrait.of((RelTraitDef)COLLATION, collation.get());
        RelTrait trait2 = RelCompositeTrait.of((RelTraitDef)COLLATION, collation.get());
        Assert.assertEquals((String)("RelCompositeTrait.of should return the same instance for " + message), (Object)(trait1 + " @" + Integer.toHexString(System.identityHashCode(trait1))), (Object)(trait2 + " @" + Integer.toHexString(System.identityHashCode(trait2))));
    }

    @Test
    public void compositeEmpty() {
        this.assertCanonical("empty composite", ImmutableList::of);
    }

    @Test
    public void compositeOne() {
        this.assertCanonical("composite with one element", () -> ImmutableList.of((Object)RelCollations.of((List)ImmutableList.of())));
    }

    @Test
    public void compositeTwo() {
        this.assertCanonical("composite with two elements", () -> ImmutableList.of((Object)RelCollations.of((int)0), (Object)RelCollations.of((int)1)));
    }
}

