/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.Lattices;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.FoodMartLatticeStatisticProvider;
import org.apache.calcite.test.FoodMartQuerySet;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.test.SlowTests;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.TestUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTests.class})
public class LatticeTest {
    private static final String SALES_LATTICE = "{\n  name: 'star',\n  sql: [\n    'select 1 from \"foodmart\".\"sales_fact_1997\" as \"s\"',\n    'join \"foodmart\".\"product\" as \"p\" using (\"product_id\")',\n    'join \"foodmart\".\"time_by_day\" as \"t\" using (\"time_id\")',\n    'join \"foodmart\".\"product_class\" as \"pc\" on \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"'\n  ],\n  auto: false,\n  algorithm: true,\n  algorithmMaxMillis: 10000,\n  rowCountEstimate: 86837,\n  defaultMeasures: [ {\n    agg: 'count'\n  } ],\n  tiles: [ {\n    dimensions: [ 'the_year', ['t', 'quarter'] ],\n   measures: [ {\n      agg: 'sum',\n      args: 'unit_sales'\n    }, {\n      agg: 'sum',\n      args: 'store_sales'\n    }, {\n      agg: 'count'\n    } ]\n  } ]\n}\n";
    private static final String INVENTORY_LATTICE = "{\n  name: 'warehouse',\n  sql: [\n  'select 1 from \"foodmart\".\"inventory_fact_1997\" as \"s\"',\n  'join \"foodmart\".\"product\" as \"p\" using (\"product_id\")',\n  'join \"foodmart\".\"time_by_day\" as \"t\" using (\"time_id\")',\n  'join \"foodmart\".\"warehouse\" as \"w\" using (\"warehouse_id\")'\n  ],\n  auto: false,\n  algorithm: true,\n  algorithmMaxMillis: 10000,\n  rowCountEstimate: 4070,\n  defaultMeasures: [ {\n    agg: 'count'\n  } ],\n  tiles: [ {\n    dimensions: [ 'the_year', 'warehouse_name'],\n    measures: [ {\n      agg: 'sum',\n      args: 'store_invoice'\n    }, {\n      agg: 'sum',\n      args: 'supply_time'\n    }, {\n      agg: 'sum',\n      args: 'warehouse_cost'\n    } ]\n  } ]\n}\n";
    private static final String AUTO_LATTICE = "{\n  name: 'star',\n  sql: [\n    'select 1 from \"foodmart\".\"sales_fact_1997\" as \"s\"',\n    'join \"foodmart\".\"product\" as \"p\" using (\"product_id\")',\n    'join \"foodmart\".\"time_by_day\" as \"t\" using (\"time_id\")',\n    'join \"foodmart\".\"product_class\" as \"pc\" on \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"'\n  ],\n  auto: false,\n  algorithm: true,\n  algorithmMaxMillis: 10000,\n  rowCountEstimate: 86837,\n  defaultMeasures: [ {\n    agg: 'count'\n  } ],\n  tiles: [ {\n    dimensions: [ 'the_year', ['t', 'quarter'] ],\n   measures: [ {\n      agg: 'sum',\n      args: 'unit_sales'\n    }, {\n      agg: 'sum',\n      args: 'store_sales'\n    }, {\n      agg: 'count'\n    } ]\n  } ]\n}\n";

    private static CalciteAssert.AssertThat modelWithLattice(String name, String sql, String ... extras) {
        StringBuilder buf = new StringBuilder("{ name: '").append(name).append("', sql: ").append(TestUtil.escapeString(sql));
        for (String extra : extras) {
            buf.append(", ").append(extra);
        }
        buf.append("}");
        return LatticeTest.modelWithLattices(buf.toString());
    }

    private static CalciteAssert.AssertThat modelWithLattices(String ... lattices) {
        Class<JdbcTest.EmpDeptTableFactory> clazz = JdbcTest.EmpDeptTableFactory.class;
        return CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n" + JdbcTest.FOODMART_SCHEMA + ",\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + clazz.getName() + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       lattices: " + Arrays.toString(lattices) + "     }\n   ]\n}").withDefaultSchema("adhoc");
    }

    @Test
    public void testLatticeSql() throws Exception {
        LatticeTest.modelWithLattice("EMPLOYEES", "select * from \"foodmart\".\"days\"", new String[0]).doWithConnection(c -> {
            SchemaPlus schema = c.getRootSchema();
            SchemaPlus adhoc = schema.getSubSchema("adhoc");
            Assert.assertThat((Object)adhoc.getTableNames().contains("EMPLOYEES"), (Matcher)Is.is((Object)true));
            Map.Entry entry = ((CalciteSchema)adhoc.unwrap(CalciteSchema.class)).getLatticeMap().firstEntry();
            Lattice lattice = ((CalciteSchema.LatticeEntry)entry.getValue()).getLattice();
            String sql = "SELECT \"days\".\"day\"\nFROM \"foodmart\".\"days\" AS \"days\"\nGROUP BY \"days\".\"day\"";
            Assert.assertThat((Object)lattice.sql(ImmutableBitSet.of((int[])new int[]{0}), (List)ImmutableList.of()), (Matcher)Is.is((Object)"SELECT \"days\".\"day\"\nFROM \"foodmart\".\"days\" AS \"days\"\nGROUP BY \"days\".\"day\""));
            String sql2 = "SELECT \"days\".\"day\", \"days\".\"week_day\"\nFROM \"foodmart\".\"days\" AS \"days\"";
            Assert.assertThat((Object)lattice.sql(ImmutableBitSet.of((int[])new int[]{0, 1}), false, (List)ImmutableList.of()), (Matcher)Is.is((Object)"SELECT \"days\".\"day\", \"days\".\"week_day\"\nFROM \"foodmart\".\"days\" AS \"days\""));
        });
    }

    @Test
    public void testLattice() throws Exception {
        LatticeTest.modelWithLattice("star", "select 1 from \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"product\" as p using (\"product_id\")\njoin \"foodmart\".\"time_by_day\" as t on t.\"time_id\" = s.\"time_id\"", new String[0]).doWithConnection(c -> {
            SchemaPlus schema = c.getRootSchema();
            SchemaPlus adhoc = schema.getSubSchema("adhoc");
            Assert.assertThat((Object)adhoc.getTableNames().contains("EMPLOYEES"), (Matcher)Is.is((Object)true));
            Map.Entry entry = ((CalciteSchema)adhoc.unwrap(CalciteSchema.class)).getLatticeMap().firstEntry();
            Lattice lattice = ((CalciteSchema.LatticeEntry)entry.getValue()).getLattice();
            Assert.assertThat((Object)lattice.firstColumn("S"), (Matcher)Is.is((Object)10));
            Assert.assertThat((Object)lattice.firstColumn("P"), (Matcher)Is.is((Object)18));
            Assert.assertThat((Object)lattice.firstColumn("T"), (Matcher)Is.is((Object)0));
            Assert.assertThat((Object)lattice.firstColumn("PC"), (Matcher)Is.is((Object)-1));
            Assert.assertThat((Object)lattice.defaultMeasures.size(), (Matcher)Is.is((Object)1));
            Assert.assertThat((Object)lattice.rootNode.descendants.size(), (Matcher)Is.is((Object)3));
        });
    }

    @Test
    public void testLatticeWithSameNameAsTable() {
        LatticeTest.modelWithLattice("EMPLOYEES", "select * from \"foodmart\".\"days\"", new String[0]).query("select count(*) from EMPLOYEES").returnsValue("4");
    }

    @Test
    public void testTwoLatticesWithSameNameFails() {
        LatticeTest.modelWithLattices("{name: 'Lattice1', sql: 'select * from \"foodmart\".\"days\"'}", "{name: 'Lattice1', sql: 'select * from \"foodmart\".\"time_by_day\"'}").connectThrows("Duplicate lattice 'Lattice1'");
    }

    @Test
    public void testLatticeInvalidSqlFails() {
        LatticeTest.modelWithLattice("star", "select foo from nonexistent", new String[0]).connectThrows("Error instantiating JsonLattice(name=star, ").connectThrows("Object 'NONEXISTENT' not found");
    }

    @Test
    public void testLatticeSqlWithGroupByFails() {
        LatticeTest.modelWithLattice("star", "select 1 from \"foodmart\".\"sales_fact_1997\" as s group by \"product_id\"", new String[0]).connectThrows("Invalid node type LogicalAggregate in lattice query");
    }

    @Test
    public void testLatticeSqlWithOrderByFails() {
        LatticeTest.modelWithLattice("star", "select 1 from \"foodmart\".\"sales_fact_1997\" as s order by \"product_id\"", new String[0]).connectThrows("Invalid node type LogicalSort in lattice query");
    }

    @Test
    public void testLatticeSqlWithUnionFails() {
        LatticeTest.modelWithLattice("star", "select 1 from \"foodmart\".\"sales_fact_1997\" as s\nunion all\nselect 1 from \"foodmart\".\"sales_fact_1997\" as s", new String[0]).connectThrows("Invalid node type LogicalUnion in lattice query");
    }

    @Test
    public void testLatticeSqlWithJoin() {
        LatticeTest.foodmartModel(new String[0]).query("values 1").returnsValue("1");
    }

    @Test
    public void testLatticeInvalidSql() {
        LatticeTest.modelWithLattice("star", "select 1 from \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"product\" as p using (\"product_id\")\njoin \"foodmart\".\"time_by_day\" as t on s.\"product_id\" = 100", new String[0]).connectThrows("only equi-join of columns allowed: 100");
    }

    @Test
    public void testLatticeInvalidSql2() {
        LatticeTest.modelWithLattice("star", "select 1 from \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"product\" as p using (\"product_id\")\nleft join \"foodmart\".\"time_by_day\" as t on s.\"product_id\" = p.\"product_id\"", new String[0]).connectThrows("only inner join allowed, but got LEFT");
    }

    @Test
    public void testLatticeInvalidSql3() {
        LatticeTest.modelWithLattice("star", "select 1 from \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"product\" as p using (\"product_id\")\njoin \"foodmart\".\"time_by_day\" as t on s.\"product_id\" = p.\"product_id\"", new String[0]).connectThrows("child node must have precisely one parent");
    }

    @Test
    public void testLatticeStarTable() {
        AtomicInteger counter = new AtomicInteger();
        try {
            LatticeTest.foodmartModel(new String[0]).query("select count(*) from \"adhoc\".\"star\"").convertMatches(CalciteAssert.checkRel("LogicalAggregate(group=[{}], EXPR$0=[COUNT()])\n  LogicalProject(DUMMY=[0])\n    StarTableScan(table=[[adhoc, star]])\n", counter));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)Throwables.getStackTraceAsString((Throwable)e), (Matcher)CoreMatchers.containsString((String)"CannotPlanException"));
        }
        Assert.assertThat((Object)counter.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testLatticeRecognizeJoin() {
        AtomicInteger counter = new AtomicInteger();
        LatticeTest.foodmartModel(new String[0]).query("select s.\"unit_sales\", p.\"brand_name\"\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"product\" as p using (\"product_id\")\n").enableMaterializations(true).substitutionMatches(CalciteAssert.checkRel("LogicalProject(unit_sales=[$7], brand_name=[$10])\n  LogicalProject(product_id=[$0], time_id=[$1], customer_id=[$2], promotion_id=[$3], store_id=[$4], store_sales=[$5], store_cost=[$6], unit_sales=[$7], product_class_id=[$8], product_id0=[$9], brand_name=[$10], product_name=[$11], SKU=[$12], SRP=[$13], gross_weight=[$14], net_weight=[$15], recyclable_package=[$16], low_fat=[$17], units_per_case=[$18], cases_per_pallet=[$19], shelf_width=[$20], shelf_height=[$21], shelf_depth=[$22])\n    LogicalTableScan(table=[[adhoc, star]])\n", counter));
        Assert.assertThat((Object)counter.intValue(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testLatticeRecognizeGroupJoin() {
        AtomicInteger counter = new AtomicInteger();
        CalciteAssert.AssertQuery that = LatticeTest.foodmartModel(new String[0]).query("select distinct p.\"brand_name\", s.\"customer_id\"\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"product\" as p using (\"product_id\")\n").enableMaterializations(true).substitutionMatches(relNode -> {
            counter.incrementAndGet();
            String s = RelOptUtil.toString((RelNode)relNode);
            Assert.assertThat((Object)s, (Matcher)CoreMatchers.anyOf(Matchers.containsStringLinux("LogicalProject(brand_name=[$1], customer_id=[$0])\n  LogicalAggregate(group=[{2, 10}])\n    LogicalTableScan(table=[[adhoc, star]])\n"), Matchers.containsStringLinux("LogicalAggregate(group=[{2, 10}])\n  LogicalTableScan(table=[[adhoc, star]])\n")));
            return null;
        });
        Assert.assertThat((Object)counter.intValue(), (Matcher)CoreMatchers.equalTo((Object)2));
        that.explainContains("EnumerableCalc(expr#0..1=[{inputs}], brand_name=[$t1], customer_id=[$t0])\n  EnumerableTableScan(table=[[adhoc, m{2, 10}]])").returnsCount(69203);
        that.withHook(Hook.CREATE_MATERIALIZATION, materializationName -> counter.incrementAndGet()).returnsCount(69203);
        Assert.assertThat((Object)counter.intValue(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testLatticeWithPreDefinedTiles() {
        LatticeTest.foodmartModel(" auto: false,\n  defaultMeasures: [ {\n    agg: 'count'\n  } ],\n  tiles: [ {\n    dimensions: [ 'the_year', ['t', 'quarter'] ],\n    measures: [ ]\n  } ]\n").query("select distinct t.\"the_year\", t.\"quarter\"\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"time_by_day\" as t using (\"time_id\")\n").enableMaterializations(true).explainContains("EnumerableTableScan(table=[[adhoc, m{32, 36}").returnsCount(4);
    }

    @Test
    public void testLatticeWithPreDefinedTilesFewerMeasures() {
        this.foodmartModelWithOneTile().query("select t.\"the_year\", t.\"quarter\", count(*) as c\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"time_by_day\" as t using (\"time_id\")\ngroup by t.\"the_year\", t.\"quarter\"").enableMaterializations(true).explainContains("EnumerableCalc(expr#0..4=[{inputs}], proj#0..2=[{exprs}])\n  EnumerableTableScan(table=[[adhoc, m{32, 36}").returnsUnordered("the_year=1997; quarter=Q1; C=21588", "the_year=1997; quarter=Q2; C=20368", "the_year=1997; quarter=Q3; C=21453", "the_year=1997; quarter=Q4; C=23428").sameResultWithMaterializationsDisabled();
    }

    @Test
    public void testLatticeWithPreDefinedTilesRollUp() {
        this.foodmartModelWithOneTile().query("select t.\"the_year\",\n  count(*) as c,\n  min(\"quarter\") as q,\n  sum(\"unit_sales\") * 10 as us\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"time_by_day\" as t using (\"time_id\")\ngroup by t.\"the_year\"").enableMaterializations(true).explainContains("EnumerableCalc(expr#0..3=[{inputs}], expr#4=[10], expr#5=[*($t3, $t4)], proj#0..2=[{exprs}], US=[$t5])\n  EnumerableAggregate(group=[{0}], C=[$SUM0($2)], Q=[MIN($1)], agg#2=[$SUM0($4)])\n    EnumerableTableScan(table=[[adhoc, m{32, 36}").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.ORACLE).returnsUnordered("the_year=1997; C=86837; Q=Q1; US=2667730.0000").sameResultWithMaterializationsDisabled();
    }

    @Test
    public void testTileAlgorithm() {
        String explain = "EnumerableAggregate(group=[{2, 3}])\n  EnumerableTableScan(table=[[adhoc, m{16, 17, 32, 36, 37}]])";
        this.checkTileAlgorithm(FoodMartLatticeStatisticProvider.class.getCanonicalName() + "#FACTORY", "EnumerableAggregate(group=[{2, 3}])\n  EnumerableTableScan(table=[[adhoc, m{16, 17, 32, 36, 37}]])");
    }

    @Test
    public void testTileAlgorithm2() {
        String explain = "EnumerableAggregate(group=[{4, 5}])\n  EnumerableTableScan(table=[[adhoc, m{16, 17, 27, 31, 32, 36, 37}]";
        this.checkTileAlgorithm(Lattices.class.getCanonicalName() + "#CACHED_SQL", "EnumerableAggregate(group=[{4, 5}])\n  EnumerableTableScan(table=[[adhoc, m{16, 17, 27, 31, 32, 36, 37}]");
    }

    @Test
    public void testTileAlgorithm3() {
        Assume.assumeTrue((String)"Yahoo sketches requires JDK 8 or higher", (TestUtil.getJavaMajorVersion() >= 8 ? 1 : 0) != 0);
        String explain = "EnumerableAggregate(group=[{4, 5}])\n  EnumerableTableScan(table=[[adhoc, m{16, 17, 27, 31, 32, 36, 37}]";
        this.checkTileAlgorithm(Lattices.class.getCanonicalName() + "#PROFILER", "EnumerableAggregate(group=[{4, 5}])\n  EnumerableTableScan(table=[[adhoc, m{16, 17, 27, 31, 32, 36, 37}]");
    }

    private void checkTileAlgorithm(String statisticProvider, String expectedExplain) {
        MaterializationService.setThreadLocal();
        MaterializationService.instance().clear();
        LatticeTest.foodmartLatticeModel(statisticProvider).query("select distinct t.\"the_year\", t.\"quarter\"\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"time_by_day\" as t using (\"time_id\")\n").enableMaterializations(true).enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.MYSQL && CalciteAssert.DB != CalciteAssert.DatabaseInstance.H2).explainContains(expectedExplain).returnsUnordered("the_year=1997; quarter=Q1", "the_year=1997; quarter=Q2", "the_year=1997; quarter=Q3", "the_year=1997; quarter=Q4");
    }

    private static CalciteAssert.AssertThat foodmartLatticeModel(String statisticProvider) {
        return LatticeTest.foodmartModel(" auto: false,\n  algorithm: true,\n  algorithmMaxMillis: -1,\n  rowCountEstimate: 87000,\n  defaultMeasures: [ {\n      agg: 'sum',\n      args: 'unit_sales'\n    }, {\n      agg: 'sum',\n      args: 'store_sales'\n    }, {\n      agg: 'count'\n  } ],\n  statisticProvider: '" + statisticProvider + "',\n  tiles: [ {\n    dimensions: [ 'the_year', ['t', 'quarter'] ],\n    measures: [ ]\n  } ]\n");
    }

    @Test
    public void testJG() {
        String sql = "SELECT \"s\".\"unit_sales\", \"p\".\"recyclable_package\", \"t\".\"the_day\", \"t\".\"the_year\", \"t\".\"quarter\", \"pc\".\"product_family\", COUNT(*) AS \"m0\", SUM(\"s\".\"store_sales\") AS \"m1\", SUM(\"s\".\"unit_sales\") AS \"m2\"\nFROM \"foodmart\".\"sales_fact_1997\" AS \"s\"\nJOIN \"foodmart\".\"product\" AS \"p\" ON \"s\".\"product_id\" = \"p\".\"product_id\"\nJOIN \"foodmart\".\"time_by_day\" AS \"t\" ON \"s\".\"time_id\" = \"t\".\"time_id\"\nJOIN \"foodmart\".\"product_class\" AS \"pc\" ON \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"\nGROUP BY \"s\".\"unit_sales\", \"p\".\"recyclable_package\", \"t\".\"the_day\", \"t\".\"the_year\", \"t\".\"quarter\", \"pc\".\"product_family\"";
        String explain = "JdbcToEnumerableConverter\n  JdbcAggregate(group=[{3, 6, 8, 9, 10, 12}], m0=[COUNT()], m1=[$SUM0($2)], m2=[$SUM0($3)])\n    JdbcJoin(condition=[=($4, $11)], joinType=[inner])\n      JdbcJoin(condition=[=($1, $7)], joinType=[inner])\n        JdbcJoin(condition=[=($0, $5)], joinType=[inner])\n          JdbcProject(product_id=[$0], time_id=[$1], store_sales=[$5], unit_sales=[$7])\n            JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n          JdbcProject(product_class_id=[$0], product_id=[$1], recyclable_package=[$8])\n            JdbcTableScan(table=[[foodmart, product]])\n        JdbcProject(time_id=[$0], the_day=[$2], the_year=[$4], quarter=[$8])\n          JdbcTableScan(table=[[foodmart, time_by_day]])\n      JdbcProject(product_class_id=[$0], product_family=[$4])\n        JdbcTableScan(table=[[foodmart, product_class]])";
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("SELECT \"s\".\"unit_sales\", \"p\".\"recyclable_package\", \"t\".\"the_day\", \"t\".\"the_year\", \"t\".\"quarter\", \"pc\".\"product_family\", COUNT(*) AS \"m0\", SUM(\"s\".\"store_sales\") AS \"m1\", SUM(\"s\".\"unit_sales\") AS \"m2\"\nFROM \"foodmart\".\"sales_fact_1997\" AS \"s\"\nJOIN \"foodmart\".\"product\" AS \"p\" ON \"s\".\"product_id\" = \"p\".\"product_id\"\nJOIN \"foodmart\".\"time_by_day\" AS \"t\" ON \"s\".\"time_id\" = \"t\".\"time_id\"\nJOIN \"foodmart\".\"product_class\" AS \"pc\" ON \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"\nGROUP BY \"s\".\"unit_sales\", \"p\".\"recyclable_package\", \"t\".\"the_day\", \"t\".\"the_year\", \"t\".\"quarter\", \"pc\".\"product_family\"").explainContains("JdbcToEnumerableConverter\n  JdbcAggregate(group=[{3, 6, 8, 9, 10, 12}], m0=[COUNT()], m1=[$SUM0($2)], m2=[$SUM0($3)])\n    JdbcJoin(condition=[=($4, $11)], joinType=[inner])\n      JdbcJoin(condition=[=($1, $7)], joinType=[inner])\n        JdbcJoin(condition=[=($0, $5)], joinType=[inner])\n          JdbcProject(product_id=[$0], time_id=[$1], store_sales=[$5], unit_sales=[$7])\n            JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n          JdbcProject(product_class_id=[$0], product_id=[$1], recyclable_package=[$8])\n            JdbcTableScan(table=[[foodmart, product]])\n        JdbcProject(time_id=[$0], the_day=[$2], the_year=[$4], quarter=[$8])\n          JdbcTableScan(table=[[foodmart, time_by_day]])\n      JdbcProject(product_class_id=[$0], product_family=[$4])\n        JdbcTableScan(table=[[foodmart, product_class]])");
    }

    @Test
    public void testGroupByEmpty() {
        LatticeTest.foodmartModel(new String[0]).query("select count(*) as c from \"foodmart\".\"sales_fact_1997\"").enableMaterializations(true).returnsUnordered("C=86837");
    }

    @Test
    public void testGroupByEmptyWithPrelude() {
        this.testDistinctCount();
        this.testGroupByEmpty();
    }

    @Test
    public void testGroupByEmpty2() {
        LatticeTest.foodmartModel(new String[0]).query("select sum(\"unit_sales\") as s\nfrom \"foodmart\".\"sales_fact_1997\"").enableMaterializations(true).enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.ORACLE).returnsUnordered("S=266773.0000");
    }

    @Test
    public void testGroupByEmpty3() {
        ArrayList mats = new ArrayList();
        CalciteAssert.AssertThat that = LatticeTest.foodmartModel(new String[0]).pooled();
        that.query("select sum(\"unit_sales\") as s, count(*) as c\nfrom \"foodmart\".\"sales_fact_1997\"").withHook(Hook.CREATE_MATERIALIZATION, mats::add).enableMaterializations(true).explainContains("EnumerableTableScan(table=[[adhoc, m{}]])").enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.ORACLE).returnsUnordered("S=266773.0000; C=86837");
        Assert.assertThat((String)((Object)mats).toString(), (Object)mats.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        that.query("select sum(\"unit_sales\") as s\nfrom \"foodmart\".\"sales_fact_1997\"").withHook(Hook.CREATE_MATERIALIZATION, mats::add).enableMaterializations(true).enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.ORACLE).returnsUnordered("S=266773.0000");
        Assert.assertThat((String)((Object)mats).toString(), (Object)mats.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testSum() {
        this.foodmartModelWithOneTile().query("select sum(\"unit_sales\") as c\nfrom \"foodmart\".\"sales_fact_1997\"\ngroup by \"product_id\"\norder by 1 desc limit 1").enableMaterializations(true).enable(CalciteAssert.DB != CalciteAssert.DatabaseInstance.ORACLE).returnsUnordered("C=267.0000");
    }

    @Test
    public void testDistinctCount() {
        this.foodmartModelWithOneTile().query("select count(distinct \"quarter\") as c\nfrom \"foodmart\".\"sales_fact_1997\"\njoin \"foodmart\".\"time_by_day\" using (\"time_id\")\ngroup by \"the_year\"").enableMaterializations(true).explainContains("EnumerableCalc(expr#0..1=[{inputs}], C=[$t1])\n  EnumerableAggregate(group=[{0}], C=[COUNT($1)])\n    EnumerableTableScan(table=[[adhoc, m{32, 36}]])").returnsUnordered("C=4");
    }

    @Test
    public void testDistinctCount2() {
        this.foodmartModelWithOneTile().query("select count(distinct \"the_year\") as c\nfrom \"foodmart\".\"sales_fact_1997\"\njoin \"foodmart\".\"time_by_day\" using (\"time_id\")\ngroup by \"the_year\"").enableMaterializations(true).explainContains("EnumerableCalc(expr#0..1=[{inputs}], C=[$t1])\n  EnumerableAggregate(group=[{0}], C=[COUNT($0)])\n    EnumerableAggregate(group=[{0}])\n      EnumerableTableScan(table=[[adhoc, m{32, 36}]])").returnsUnordered("C=1");
    }

    @Ignore
    @Test
    public void testAllFoodmartQueries() throws IOException {
        ImmutableList fixed = ImmutableList.of((Object)13, (Object)24, (Object)28, (Object)30, (Object)61, (Object)76, (Object)79, (Object)81, (Object)85, (Object)98, (Object)101, (Object)107, (Object[])new Integer[]{128, 129, 130, 131});
        ImmutableList bad = ImmutableList.of((Object)382, (Object)423);
        for (int i = 1; i < 1000; ++i) {
            System.out.println("i=" + i);
            try {
                if (bad.contains(i)) continue;
                this.check(i);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("error in " + i, e);
            }
        }
    }

    private void check(int n) throws IOException {
        FoodMartQuerySet set = FoodMartQuerySet.instance();
        FoodMartQuerySet.FoodmartQuery query = set.queries.get(n);
        if (query == null) {
            return;
        }
        this.foodmartModelWithOneTile().withDefaultSchema("foodmart").query(query.sql).sameResultWithMaterializationsDisabled();
    }

    @Test
    public void testTileWithNoMeasures() {
    }

    @Test
    public void testLatticeWithNoMeasures() {
    }

    @Test
    public void testDimensionIsInvalidColumn() {
    }

    @Test
    public void testMeasureArgIsInvalidColumn() {
    }

    @Test
    public void testMeasureArgIsNotUniqueAlias() {
    }

    @Test
    public void testMeasureAggIsInvalid() {
    }

    @Test
    public void testTwoLattices() {
        AtomicInteger counter = new AtomicInteger();
        boolean enabled = CalciteAssert.DB != CalciteAssert.DatabaseInstance.MYSQL && CalciteAssert.DB != CalciteAssert.DatabaseInstance.H2;
        LatticeTest.modelWithLattices("{\n  name: 'star',\n  sql: [\n    'select 1 from \"foodmart\".\"sales_fact_1997\" as \"s\"',\n    'join \"foodmart\".\"product\" as \"p\" using (\"product_id\")',\n    'join \"foodmart\".\"time_by_day\" as \"t\" using (\"time_id\")',\n    'join \"foodmart\".\"product_class\" as \"pc\" on \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"'\n  ],\n  auto: false,\n  algorithm: true,\n  algorithmMaxMillis: 10000,\n  rowCountEstimate: 86837,\n  defaultMeasures: [ {\n    agg: 'count'\n  } ],\n  tiles: [ {\n    dimensions: [ 'the_year', ['t', 'quarter'] ],\n   measures: [ {\n      agg: 'sum',\n      args: 'unit_sales'\n    }, {\n      agg: 'sum',\n      args: 'store_sales'\n    }, {\n      agg: 'count'\n    } ]\n  } ]\n}\n", INVENTORY_LATTICE).query("select s.\"unit_sales\", p.\"brand_name\"\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"product\" as p using (\"product_id\")\n").enableMaterializations(true).enable(enabled).substitutionMatches(CalciteAssert.checkRel("LogicalProject(unit_sales=[$7], brand_name=[$10])\n  LogicalProject(product_id=[$0], time_id=[$1], customer_id=[$2], promotion_id=[$3], store_id=[$4], store_sales=[$5], store_cost=[$6], unit_sales=[$7], product_class_id=[$8], product_id0=[$9], brand_name=[$10], product_name=[$11], SKU=[$12], SRP=[$13], gross_weight=[$14], net_weight=[$15], recyclable_package=[$16], low_fat=[$17], units_per_case=[$18], cases_per_pallet=[$19], shelf_width=[$20], shelf_height=[$21], shelf_depth=[$22])\n    LogicalTableScan(table=[[adhoc, star]])\n", counter));
        if (enabled) {
            Assert.assertThat((Object)counter.intValue(), (Matcher)Is.is((Object)1));
        }
    }

    @Test
    public void testOneLatticeOneMV() {
        AtomicInteger counter = new AtomicInteger();
        Class<JdbcTest.EmpDeptTableFactory> clazz = JdbcTest.EmpDeptTableFactory.class;
        String mv = "       materializations: [\n         {\n           table: \"m0\",\n           view: \"m0v\",\n           sql: \"select * from \\\"foodmart\\\".\\\"sales_fact_1997\\\" where \\\"product_id\\\" = 10\"          }\n       ]\n";
        String model = "{\n  version: '1.0',\n   schemas: [\n" + JdbcTest.FOODMART_SCHEMA + ",\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + clazz.getName() + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       lattices: [" + INVENTORY_LATTICE + "       ]\n     },\n     {\n       name: 'mat',\n" + "       materializations: [\n         {\n           table: \"m0\",\n           view: \"m0v\",\n           sql: \"select * from \\\"foodmart\\\".\\\"sales_fact_1997\\\" where \\\"product_id\\\" = 10\"          }\n       ]\n" + "     }\n   ]\n}";
        CalciteAssert.model(model).withDefaultSchema("foodmart").query("select * from \"foodmart\".\"sales_fact_1997\" where \"product_id\" = 10").enableMaterializations(true).substitutionMatches(CalciteAssert.checkRel("EnumerableTableScan(table=[[mat, m0]])\n", counter));
        Assert.assertThat((Object)counter.intValue(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore
    @Test
    public void testLatticeWithBadRowCountEstimate() {
        String lattice = INVENTORY_LATTICE.replace("rowCountEstimate: 4070,", "rowCountEstimate: 4074070,");
        Assert.assertFalse((boolean)lattice.equals(INVENTORY_LATTICE));
        LatticeTest.modelWithLattices(lattice).query("values 1\n").returns("EXPR$0=1\n");
    }

    @Test
    public void testSuggester() {
        Class<JdbcTest.EmpDeptTableFactory> clazz = JdbcTest.EmpDeptTableFactory.class;
        String model = "{\n  version: '1.0',\n   schemas: [\n" + JdbcTest.FOODMART_SCHEMA + ",\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + clazz.getName() + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       \"autoLattice\": true     }\n   ]\n}";
        String sql = "select count(*)\nfrom \"sales_fact_1997\"\njoin \"time_by_day\" using (\"time_id\")\n";
        String explain = "PLAN=JdbcToEnumerableConverter\n  JdbcAggregate(group=[{}], EXPR$0=[COUNT()])\n    JdbcJoin(condition=[=($1, $0)], joinType=[inner])\n      JdbcProject(time_id=[$0])\n        JdbcTableScan(table=[[foodmart, time_by_day]])\n      JdbcProject(time_id=[$1])\n        JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n";
        CalciteAssert.model(model).withDefaultSchema("foodmart").query("select count(*)\nfrom \"sales_fact_1997\"\njoin \"time_by_day\" using (\"time_id\")\n").returns("EXPR$0=86837\n").explainContains("PLAN=JdbcToEnumerableConverter\n  JdbcAggregate(group=[{}], EXPR$0=[COUNT()])\n    JdbcJoin(condition=[=($1, $0)], joinType=[inner])\n      JdbcProject(time_id=[$0])\n        JdbcTableScan(table=[[foodmart, time_by_day]])\n      JdbcProject(time_id=[$1])\n        JdbcTableScan(table=[[foodmart, sales_fact_1997]])\n");
    }

    private static CalciteAssert.AssertThat foodmartModel(String ... extras) {
        String sql = "select 1\nfrom \"foodmart\".\"sales_fact_1997\" as \"s\"\njoin \"foodmart\".\"product\" as \"p\" using (\"product_id\")\njoin \"foodmart\".\"time_by_day\" as \"t\" using (\"time_id\")\njoin \"foodmart\".\"product_class\" as \"pc\"\n  on \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"";
        return LatticeTest.modelWithLattice("star", "select 1\nfrom \"foodmart\".\"sales_fact_1997\" as \"s\"\njoin \"foodmart\".\"product\" as \"p\" using (\"product_id\")\njoin \"foodmart\".\"time_by_day\" as \"t\" using (\"time_id\")\njoin \"foodmart\".\"product_class\" as \"pc\"\n  on \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"", extras);
    }

    private CalciteAssert.AssertThat foodmartModelWithOneTile() {
        return LatticeTest.foodmartModel(" auto: false,\n  defaultMeasures: [ {\n    agg: 'count'\n  } ],\n  tiles: [ {\n    dimensions: [ 'the_year', ['t', 'quarter'] ],\n    measures: [ {\n      agg: 'sum',\n      args: 'unit_sales'\n    }, {\n      agg: 'sum',\n      args: 'store_sales'\n    }, {\n      agg: 'count'\n    } ]\n  } ]\n");
    }

    private static void runJdbc() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:model=core/src/test/resources/mysql-foodmart-lattice-model.json");
        ResultSet resultSet = connection.createStatement().executeQuery("select * from \"adhoc\".\"m{32, 36}\"");
        System.out.println(CalciteAssert.toString(resultSet));
        connection.close();
    }

    @Test
    public void testColumnCount() {
        Assert.assertThat((Object)Lattice.getRowCount((double)10.0, (double[])new double[]{2.0, 3.0}), Matchers.within(5.03, 0.01));
        Assert.assertThat((Object)Lattice.getRowCount((double)10.0, (double[])new double[]{9.0, 8.0}), Matchers.within(9.4, 0.01));
        Assert.assertThat((Object)Lattice.getRowCount((double)100.0, (double[])new double[]{9.0, 8.0}), Matchers.within(54.2, 0.1));
        Assert.assertThat((Object)Lattice.getRowCount((double)1000.0, (double[])new double[]{9.0, 8.0}), Matchers.within(72.0, 0.01));
        Assert.assertThat((Object)Lattice.getRowCount((double)1000.0, (double[])new double[]{1.0, 1.0}), (Matcher)Is.is((Object)1.0));
        Assert.assertThat((Object)Lattice.getRowCount((double)1.0, (double[])new double[]{3.0, 5.0}), Matchers.within(1.0, 0.01));
        Assert.assertThat((Object)Lattice.getRowCount((double)1.0, (double[])new double[]{3.0, 5.0, 13.0, 4831.0}), Matchers.within(1.0, 0.01));
    }
}

