/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.fuzzer;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.RexProgramBuilderBase;

public class RexFuzzer
extends RexProgramBuilderBase {
    private static final int MAX_VARS = 2;
    private static final SqlOperator[] BOOL_TO_BOOL = new SqlOperator[]{SqlStdOperatorTable.NOT, SqlStdOperatorTable.IS_TRUE, SqlStdOperatorTable.IS_FALSE, SqlStdOperatorTable.IS_NOT_TRUE, SqlStdOperatorTable.IS_NOT_FALSE};
    private static final SqlOperator[] ANY_TO_BOOL = new SqlOperator[]{SqlStdOperatorTable.IS_NULL, SqlStdOperatorTable.IS_NOT_NULL, SqlStdOperatorTable.IS_UNKNOWN, SqlStdOperatorTable.IS_NOT_UNKNOWN};
    private static final SqlOperator[] COMPARABLE_TO_BOOL = new SqlOperator[]{SqlStdOperatorTable.EQUALS, SqlStdOperatorTable.NOT_EQUALS, SqlStdOperatorTable.GREATER_THAN, SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, SqlStdOperatorTable.LESS_THAN, SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlStdOperatorTable.IS_DISTINCT_FROM, SqlStdOperatorTable.IS_NOT_DISTINCT_FROM};
    private static final SqlOperator[] BOOL_TO_BOOL_MULTI_ARG = new SqlOperator[]{SqlStdOperatorTable.OR, SqlStdOperatorTable.AND, SqlStdOperatorTable.COALESCE};
    private static final SqlOperator[] ANY_SAME_TYPE_MULTI_ARG = new SqlOperator[]{SqlStdOperatorTable.COALESCE};
    private static final SqlOperator[] NUMERIC_TO_NUMERIC = new SqlOperator[]{SqlStdOperatorTable.PLUS, SqlStdOperatorTable.MINUS, SqlStdOperatorTable.MULTIPLY};
    private static final SqlOperator[] UNARY_NUMERIC = new SqlOperator[]{SqlStdOperatorTable.UNARY_MINUS, SqlStdOperatorTable.UNARY_PLUS};
    private static final int[] INT_VALUES = new int[]{-1, 0, 1, 100500};
    private final RelDataType intType;
    private final RelDataType nullableIntType;

    public RexFuzzer(RexBuilder rexBuilder, JavaTypeFactory typeFactory) {
        this.setUp();
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.intType = typeFactory.createSqlType(SqlTypeName.INTEGER);
        this.nullableIntType = typeFactory.createTypeWithNullability(this.intType, true);
    }

    public RexNode getExpression(Random r, int depth) {
        return this.getComparableExpression(r, depth);
    }

    private RexNode fuzzOperator(Random r, SqlOperator[] operators, RexNode ... args) {
        return this.rexBuilder.makeCall(operators[r.nextInt(operators.length)], args);
    }

    private RexNode fuzzOperator(Random r, SqlOperator[] operators, int length, Function<Random, RexNode> factory) {
        ArrayList<RexNode> args = new ArrayList<RexNode>(length);
        for (int i = 0; i < length; ++i) {
            args.add(factory.apply(r));
        }
        return this.rexBuilder.makeCall(operators[r.nextInt(operators.length)], args);
    }

    public RexNode getComparableExpression(Random r, int depth) {
        int v = r.nextInt(2);
        switch (v) {
            case 0: {
                return this.getBoolExpression(r, depth);
            }
            case 1: {
                return this.getIntExpression(r, depth);
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public RexNode getSimpleBool(Random r) {
        int v = r.nextInt(2);
        switch (v) {
            case 0: {
                boolean nullable = r.nextBoolean();
                int field = r.nextInt(2);
                return nullable ? this.vBool(field) : this.vBoolNotNull(field);
            }
            case 1: {
                return r.nextBoolean() ? this.trueLiteral : this.falseLiteral;
            }
            case 2: {
                return this.nullBool;
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public RexNode getBoolExpression(Random r, int depth) {
        int v = depth <= 0 ? 0 : r.nextInt(7);
        switch (v) {
            case 0: {
                return this.getSimpleBool(r);
            }
            case 1: {
                return this.fuzzOperator(r, ANY_TO_BOOL, this.getExpression(r, depth - 1));
            }
            case 2: {
                return this.fuzzOperator(r, BOOL_TO_BOOL, this.getBoolExpression(r, depth - 1));
            }
            case 3: {
                return this.fuzzOperator(r, COMPARABLE_TO_BOOL, this.getBoolExpression(r, depth - 1), this.getBoolExpression(r, depth - 1));
            }
            case 4: {
                return this.fuzzOperator(r, COMPARABLE_TO_BOOL, this.getIntExpression(r, depth - 1), this.getIntExpression(r, depth - 1));
            }
            case 5: {
                return this.fuzzOperator(r, BOOL_TO_BOOL_MULTI_ARG, r.nextInt(3) + 2, (Random x) -> this.getBoolExpression((Random)x, depth - 1));
            }
            case 6: {
                return this.fuzzCase(r, depth - 1, x -> this.getBoolExpression((Random)x, depth - 1));
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public RexNode getSimpleInt(Random r) {
        int v = r.nextInt(3);
        switch (v) {
            case 0: {
                boolean nullable = r.nextBoolean();
                int field = r.nextInt(2);
                return nullable ? this.vInt(field) : this.vIntNotNull(field);
            }
            case 1: {
                int i = r.nextInt(INT_VALUES.length + 1);
                int val = i < INT_VALUES.length ? INT_VALUES[i] : r.nextInt();
                return this.rexBuilder.makeLiteral((Object)val, r.nextBoolean() ? this.intType : this.nullableIntType, false);
            }
            case 2: {
                return this.nullInt;
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public RexNode getIntExpression(Random r, int depth) {
        int v = depth <= 0 ? 0 : r.nextInt(5);
        switch (v) {
            case 0: {
                return this.getSimpleInt(r);
            }
            case 1: {
                return this.fuzzOperator(r, UNARY_NUMERIC, this.getIntExpression(r, depth - 1));
            }
            case 2: {
                return this.fuzzOperator(r, NUMERIC_TO_NUMERIC, this.getIntExpression(r, depth - 1), this.getIntExpression(r, depth - 1));
            }
            case 3: {
                return this.fuzzOperator(r, ANY_SAME_TYPE_MULTI_ARG, r.nextInt(3) + 2, (Random x) -> this.getIntExpression((Random)x, depth - 1));
            }
            case 4: {
                return this.fuzzCase(r, depth - 1, x -> this.getIntExpression((Random)x, depth - 1));
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public RexNode fuzzCase(Random r, int depth, Function<Random, RexNode> resultFactory) {
        Function<Random, RexNode> exprFactory;
        boolean caseArgWhen = r.nextBoolean();
        int caseBranches = 1 + (depth <= 0 ? 0 : r.nextInt(3));
        ArrayList<RexNode> args = new ArrayList<RexNode>(caseBranches + 1);
        if (!caseArgWhen) {
            exprFactory = x -> this.getBoolExpression((Random)x, depth - 1);
        } else {
            Function<Random, RexNode> baseExprFactory;
            int type = r.nextInt(2);
            switch (type) {
                case 0: {
                    baseExprFactory = x -> this.getBoolExpression((Random)x, depth - 1);
                    break;
                }
                case 1: {
                    baseExprFactory = x -> this.getIntExpression((Random)x, depth - 1);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("should not reach here: " + type));
                }
            }
            RexNode arg = baseExprFactory.apply(r);
            exprFactory = x -> this.eq(arg, (RexNode)baseExprFactory.apply((Random)x));
        }
        for (int i = 0; i < caseBranches; ++i) {
            args.add(exprFactory.apply(r));
            args.add(resultFactory.apply(r));
        }
        args.add(resultFactory.apply(r));
        return this.case_(args);
    }
}

