/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.test.catalog.CompoundNameColumn;
import org.apache.calcite.test.catalog.CompoundNameColumnResolver;
import org.apache.calcite.test.catalog.Fixture;
import org.apache.calcite.test.catalog.MockCatalogReader;
import org.apache.calcite.test.catalog.MockCatalogReaderSimple;

public class MockCatalogReaderExtended
extends MockCatalogReaderSimple {
    public MockCatalogReaderExtended(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(typeFactory, caseSensitive);
    }

    @Override
    public MockCatalogReader init() {
        super.init();
        MockCatalogReader.MockSchema salesSchema = new MockCatalogReader.MockSchema("SALES");
        ImmutableList empModifiableViewNames = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"EMP_MODIFIABLEVIEW");
        MockCatalogReader.MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro = MockCatalogReader.MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, SLACKER from EMPDEFAULTS where DEPTNO = 20", empModifiableViewNames.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames.get(2)), true);
        TranslatableTable empModifiableView = empModifiableViewMacro.apply((List)ImmutableList.of());
        MockCatalogReader.MockModifiableViewRelOptTable mockEmpViewTable = MockCatalogReader.MockModifiableViewRelOptTable.create((MockCatalogReader.MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView, this, (String)empModifiableViewNames.get(0), (String)empModifiableViewNames.get(1), (String)empModifiableViewNames.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable);
        ImmutableList empModifiableViewNames2 = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"EMP_MODIFIABLEVIEW2");
        MockCatalogReader.MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro2 = MockCatalogReader.MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select ENAME, EMPNO, JOB, DEPTNO, SLACKER, SAL, EXTRA, HIREDATE, MGR, COMM from EMPDEFAULTS extend (EXTRA boolean) where DEPTNO = 20", empModifiableViewNames2.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames.get(2)), true);
        TranslatableTable empModifiableView2 = empModifiableViewMacro2.apply((List)ImmutableList.of());
        MockCatalogReader.MockModifiableViewRelOptTable mockEmpViewTable2 = MockCatalogReader.MockModifiableViewRelOptTable.create((MockCatalogReader.MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView2, this, (String)empModifiableViewNames2.get(0), (String)empModifiableViewNames2.get(1), (String)empModifiableViewNames2.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable2);
        ImmutableList empModifiableViewNames3 = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"EMP_MODIFIABLEVIEW3");
        MockCatalogReader.MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro3 = MockCatalogReader.MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, SLACKER from EMPDEFAULTS where DEPTNO = 20", empModifiableViewNames3.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames3.get(2)), true);
        TranslatableTable empModifiableView3 = empModifiableViewMacro3.apply((List)ImmutableList.of());
        MockCatalogReader.MockModifiableViewRelOptTable mockEmpViewTable3 = MockCatalogReader.MockModifiableViewRelOptTable.create((MockCatalogReader.MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView3, this, (String)empModifiableViewNames3.get(0), (String)empModifiableViewNames3.get(1), (String)empModifiableViewNames3.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable3);
        MockCatalogReader.MockSchema structTypeSchema = new MockCatalogReader.MockSchema("STRUCT");
        this.registerSchema(structTypeSchema);
        Fixture f = new Fixture(this.typeFactory);
        List<CompoundNameColumn> columnsExtended = Arrays.asList(new CompoundNameColumn("", "K0", f.varchar20TypeNull), new CompoundNameColumn("", "C1", f.varchar20TypeNull), new CompoundNameColumn("F0", "C0", f.intType), new CompoundNameColumn("F1", "C1", f.intTypeNull));
        ArrayList<CompoundNameColumn> extendedColumns = new ArrayList<CompoundNameColumn>(columnsExtended);
        extendedColumns.add(new CompoundNameColumn("F2", "C2", f.varchar20Type));
        CompoundNameColumnResolver structExtendedTableResolver = new CompoundNameColumnResolver(extendedColumns, "F0");
        MockCatalogReader.MockTable structExtendedTypeTable = MockCatalogReader.MockTable.create(this, structTypeSchema, "T_EXTEND", false, 100.0, structExtendedTableResolver);
        for (CompoundNameColumn column : columnsExtended) {
            structExtendedTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structExtendedTypeTable);
        return this;
    }
}

