/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.catalog.MockCatalogReader;

public class MockCatalogReaderDynamic
extends MockCatalogReader {
    public MockCatalogReaderDynamic(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(typeFactory, caseSensitive);
    }

    @Override
    public MockCatalogReader init() {
        MockCatalogReader.MockSchema schema = new MockCatalogReader.MockSchema("SALES");
        this.registerSchema(schema);
        MockCatalogReader.MockDynamicTable nationTable = new MockCatalogReader.MockDynamicTable(this, schema.getCatalogName(), schema.getName(), "NATION", false, 100.0);
        this.registerTable(nationTable);
        MockCatalogReader.MockDynamicTable customerTable = new MockCatalogReader.MockDynamicTable(this, schema.getCatalogName(), schema.getName(), "CUSTOMER", false, 100.0);
        this.registerTable(customerTable);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType varcharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR);
        MockCatalogReader.MockTable regionTable = MockCatalogReader.MockTable.create(this, schema, "REGION", false, 100.0);
        regionTable.addColumn("R_REGIONKEY", intType);
        regionTable.addColumn("R_NAME", varcharType);
        regionTable.addColumn("R_COMMENT", varcharType);
        this.registerTable(regionTable);
        return this;
    }
}

