/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlOperatorBindingTest {
    private RexBuilder rexBuilder;
    private RelDataType integerDataType;
    private SqlDataTypeSpec integerType;

    @Before
    public void setUp() {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.integerDataType = typeFactory.createSqlType(SqlTypeName.INTEGER);
        this.integerType = SqlTypeUtil.convertTypeToSpec((RelDataType)this.integerDataType);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
    }

    @Test
    public void testSqlNodeLiteral() {
        SqlNumericLiteral literal = SqlLiteral.createExactNumeric((String)"0", (SqlParserPos)SqlParserPos.ZERO);
        SqlCall castLiteral = SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{literal, this.integerType});
        SqlCall castCastLiteral = SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{castLiteral, this.integerType});
        Assert.assertSame((Object)true, (Object)SqlUtil.isLiteral((SqlNode)literal, (boolean)true));
        Assert.assertSame((Object)true, (Object)SqlUtil.isLiteral((SqlNode)castLiteral, (boolean)true));
        Assert.assertSame((Object)false, (Object)SqlUtil.isLiteral((SqlNode)castCastLiteral, (boolean)true));
    }

    @Test
    public void testRexNodeLiteral() {
        RexNode literal = this.rexBuilder.makeZeroLiteral(this.integerDataType);
        RexNode castLiteral = this.rexBuilder.makeCall(this.integerDataType, (SqlOperator)SqlStdOperatorTable.CAST, (List)Lists.newArrayList((Object[])new RexNode[]{literal}));
        RexNode castCastLiteral = this.rexBuilder.makeCall(this.integerDataType, (SqlOperator)SqlStdOperatorTable.CAST, (List)Lists.newArrayList((Object[])new RexNode[]{castLiteral}));
        Assert.assertSame((Object)true, (Object)RexUtil.isLiteral((RexNode)literal, (boolean)true));
        Assert.assertSame((Object)true, (Object)RexUtil.isLiteral((RexNode)castLiteral, (boolean)true));
        Assert.assertSame((Object)false, (Object)RexUtil.isLiteral((RexNode)castCastLiteral, (boolean)true));
    }
}

