/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.advise.SqlAdvisorGetHintsFunction;
import org.apache.calcite.sql.advise.SqlAdvisorGetHintsFunction2;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.junit.Test;

public class SqlAdvisorJdbcTest {
    private void adviseSql(int apiVersion, String sql, Consumer<ResultSet> checker) throws SQLException {
        Properties info = new Properties();
        if (apiVersion == 1) {
            info.put("lex", "JAVA");
            info.put("quoting", "DOUBLE_QUOTE");
        } else if (apiVersion == 2) {
            info.put("lex", "SQL_SERVER");
            info.put("quoting", "BRACKET");
        }
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        calciteConnection.setSchema("hr");
        SqlAdvisorGetHintsFunction getHints = apiVersion == 1 ? new SqlAdvisorGetHintsFunction() : new SqlAdvisorGetHintsFunction2();
        schema.add("get_hints", (Function)getHints);
        String getHintsSql = apiVersion == 1 ? "select id, names, type from table(\"s\".\"get_hints\"(?, ?)) as t" : "select id, names, type, replacement from table([s].[get_hints](?, ?)) as t";
        PreparedStatement ps = connection.prepareStatement(getHintsSql);
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        ps.setString(1, sap.sql);
        ps.setInt(2, sap.cursor);
        ResultSet resultSet = ps.executeQuery();
        checker.accept(resultSet);
        resultSet.close();
        connection.close();
    }

    @Test
    public void testSqlAdvisorGetHintsFunction() throws SQLException, ClassNotFoundException {
        this.adviseSql(1, "select e.e^ from \"emps\" e", CalciteAssert.checkResultUnordered("id=e; names=null; type=MATCH", "id=empid; names=[empid]; type=COLUMN"));
    }

    @Test
    public void testSqlAdvisorGetHintsFunction2() throws SQLException, ClassNotFoundException {
        this.adviseSql(2, "select [e].e^ from [emps] e", CalciteAssert.checkResultUnordered("id=e; names=null; type=MATCH; replacement=null", "id=empid; names=[empid]; type=COLUMN; replacement=empid"));
    }

    @Test
    public void testSqlAdvisorNonExistingColumn() throws SQLException, ClassNotFoundException {
        this.adviseSql(1, "select e.empdid_wrong_name.^ from \"hr\".\"emps\" e", CalciteAssert.checkResultUnordered("id=*; names=[*]; type=KEYWORD", "id=; names=null; type=MATCH"));
    }

    @Test
    public void testSqlAdvisorNonStructColumn() throws SQLException, ClassNotFoundException {
        this.adviseSql(1, "select e.\"empid\".^ from \"hr\".\"emps\" e", CalciteAssert.checkResultUnordered("id=*; names=[*]; type=KEYWORD", "id=; names=null; type=MATCH"));
    }

    @Test
    public void testSqlAdvisorSubSchema() throws SQLException, ClassNotFoundException {
        this.adviseSql(1, "select * from \"hr\".^.test_test_test", CalciteAssert.checkResultUnordered("id=; names=null; type=MATCH", "id=hr.dependents; names=[hr, dependents]; type=TABLE", "id=hr.depts; names=[hr, depts]; type=TABLE", "id=hr.emps; names=[hr, emps]; type=TABLE", "id=hr.locations; names=[hr, locations]; type=TABLE", "id=hr; names=[hr]; type=SCHEMA"));
    }

    @Test
    public void testSqlAdvisorSubSchema2() throws SQLException, ClassNotFoundException {
        this.adviseSql(2, "select * from [hr].^.test_test_test", CalciteAssert.checkResultUnordered("id=; names=null; type=MATCH; replacement=null", "id=hr.dependents; names=[hr, dependents]; type=TABLE; replacement=dependents", "id=hr.depts; names=[hr, depts]; type=TABLE; replacement=depts", "id=hr.emps; names=[hr, emps]; type=TABLE; replacement=emps", "id=hr.locations; names=[hr, locations]; type=TABLE; replacement=locations", "id=hr; names=[hr]; type=SCHEMA; replacement=hr"));
    }

    @Test
    public void testSqlAdvisorTableInSchema() throws SQLException, ClassNotFoundException {
        this.adviseSql(1, "select * from \"hr\".^", CalciteAssert.checkResultUnordered("id=; names=null; type=MATCH", "id=hr.dependents; names=[hr, dependents]; type=TABLE", "id=hr.depts; names=[hr, depts]; type=TABLE", "id=hr.emps; names=[hr, emps]; type=TABLE", "id=hr.locations; names=[hr, locations]; type=TABLE", "id=hr; names=[hr]; type=SCHEMA"));
    }

    @Test
    public void testSqlAdvisorSchemaNames() throws SQLException, ClassNotFoundException {
        this.adviseSql(1, "select empid from \"emps\" e, ^", CalciteAssert.checkResultUnordered("id=; names=null; type=MATCH", "id=(; names=[(]; type=KEYWORD", "id=LATERAL; names=[LATERAL]; type=KEYWORD", "id=TABLE; names=[TABLE]; type=KEYWORD", "id=UNNEST; names=[UNNEST]; type=KEYWORD", "id=hr; names=[hr]; type=SCHEMA", "id=metadata; names=[metadata]; type=SCHEMA", "id=s; names=[s]; type=SCHEMA", "id=hr.dependents; names=[hr, dependents]; type=TABLE", "id=hr.depts; names=[hr, depts]; type=TABLE", "id=hr.emps; names=[hr, emps]; type=TABLE", "id=hr.locations; names=[hr, locations]; type=TABLE"));
    }
}

