/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlValidatorTester;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SqlValidatorUtilTest {
    private static void checkChangedFieldList(List<String> nameList, List<String> resultList, boolean caseSensitive) {
        int i = 0;
        for (String name : nameList) {
            String newName = resultList.get(i);
            Assert.assertThat((Object)newName, (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)name), (Matcher)CoreMatchers.is((Object)(name + "0"))));
            ++i;
        }
        ArrayList<String> copyResultList = new ArrayList<String>(resultList.size());
        for (String result : resultList) {
            copyResultList.add(result.toLowerCase(Locale.ROOT));
        }
        for (String result : resultList) {
            String lowerResult = result.toLowerCase(Locale.ROOT);
            Assert.assertThat((Object)copyResultList.contains(lowerResult), (Matcher)CoreMatchers.is((Object)true));
            copyResultList.remove(lowerResult);
            if (caseSensitive) continue;
            Assert.assertThat((Object)copyResultList.contains(lowerResult), (Matcher)CoreMatchers.is((Object)false));
        }
        Assert.assertThat((Object)copyResultList.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testUniquifyCaseSensitive() {
        ArrayList nameList = Lists.newArrayList((Object[])new String[]{"col1", "COL1", "col_ABC", "col_abC"});
        List resultList = SqlValidatorUtil.uniquify((List)nameList, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
        Assert.assertThat((Object)nameList, (Matcher)CoreMatchers.sameInstance((Object)resultList));
    }

    @Test
    public void testUniquifyNotCaseSensitive() {
        ArrayList nameList = Lists.newArrayList((Object[])new String[]{"col1", "COL1", "col_ABC", "col_abC"});
        List resultList = SqlValidatorUtil.uniquify((List)nameList, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)false);
        Assert.assertThat((Object)resultList, (Matcher)CoreMatchers.not((Object)nameList));
        SqlValidatorUtilTest.checkChangedFieldList(nameList, resultList, false);
    }

    @Test
    public void testUniquifyOrderingCaseSensitive() {
        ArrayList nameList = Lists.newArrayList((Object[])new String[]{"k68s", "def", "col1", "COL1", "abc", "123"});
        List resultList = SqlValidatorUtil.uniquify((List)nameList, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
        Assert.assertThat((Object)nameList, (Matcher)CoreMatchers.sameInstance((Object)resultList));
    }

    @Test
    public void testUniquifyOrderingRepeatedCaseSensitive() {
        ArrayList nameList = Lists.newArrayList((Object[])new String[]{"k68s", "def", "col1", "COL1", "def", "123"});
        List resultList = SqlValidatorUtil.uniquify((List)nameList, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
        Assert.assertThat((Object)nameList, (Matcher)CoreMatchers.not((Object)resultList));
        SqlValidatorUtilTest.checkChangedFieldList(nameList, resultList, true);
    }

    @Test
    public void testUniquifyOrderingNotCaseSensitive() {
        ArrayList nameList = Lists.newArrayList((Object[])new String[]{"k68s", "def", "col1", "COL1", "abc", "123"});
        List resultList = SqlValidatorUtil.uniquify((List)nameList, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)false);
        Assert.assertThat((Object)resultList, (Matcher)CoreMatchers.not((Object)nameList));
        SqlValidatorUtilTest.checkChangedFieldList(nameList, resultList, false);
    }

    @Test
    public void testUniquifyOrderingRepeatedNotCaseSensitive() {
        ArrayList nameList = Lists.newArrayList((Object[])new String[]{"k68s", "def", "col1", "COL1", "def", "123"});
        List resultList = SqlValidatorUtil.uniquify((List)nameList, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)false);
        Assert.assertThat((Object)resultList, (Matcher)CoreMatchers.not((Object)nameList));
        SqlValidatorUtilTest.checkChangedFieldList(nameList, resultList, false);
    }

    @Test
    public void testCheckingDuplicatesWithCompoundIdentifiers() {
        ArrayList<SqlIdentifier> newList = new ArrayList<SqlIdentifier>(2);
        newList.add(new SqlIdentifier(Arrays.asList("f0", "c0"), SqlParserPos.ZERO));
        newList.add(new SqlIdentifier(Arrays.asList("f0", "c0"), SqlParserPos.ZERO));
        SqlValidatorTester tester = new SqlValidatorTester(SqlTestFactory.INSTANCE);
        SqlValidatorImpl validator = (SqlValidatorImpl)tester.getValidator();
        try {
            SqlValidatorUtil.checkIdentifierListForDuplicates(newList, (SqlValidatorImpl.ValidationErrorFunction)validator.getValidationErrorFunction());
            Assert.fail((String)"expected exception");
        }
        catch (CalciteContextException calciteContextException) {
            // empty catch block
        }
        newList.set(1, new SqlIdentifier(Arrays.asList("f0", "c1"), SqlParserPos.ZERO));
        SqlValidatorUtil.checkIdentifierListForDuplicates(newList, null);
    }

    @Test
    public void testNameMatcher() {
        ImmutableList beatles = ImmutableList.of((Object)"john", (Object)"paul", (Object)"ringo", (Object)"rinGo");
        SqlNameMatcher insensitiveMatcher = SqlNameMatchers.withCaseSensitive((boolean)false);
        Assert.assertThat((Object)insensitiveMatcher.frequency((Iterable)beatles, "ringo"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)insensitiveMatcher.frequency((Iterable)beatles, "rinGo"), (Matcher)CoreMatchers.is((Object)2));
        SqlNameMatcher sensitiveMatcher = SqlNameMatchers.withCaseSensitive((boolean)true);
        Assert.assertThat((Object)sensitiveMatcher.frequency((Iterable)beatles, "ringo"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)sensitiveMatcher.frequency((Iterable)beatles, "rinGo"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)sensitiveMatcher.frequency((Iterable)beatles, "Ringo"), (Matcher)CoreMatchers.is((Object)0));
    }
}

