/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.util.Litmus;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SqlPrettyWriterTest {
    public static final String NL = System.getProperty("line.separator");

    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(SqlPrettyWriterTest.class);
    }

    protected SqlNode parseQuery(String sql) {
        SqlNode node;
        try {
            node = SqlParser.create((String)sql).parseQuery();
        }
        catch (SqlParseException e) {
            String message = "Received error while parsing SQL '" + sql + "'; error is:" + NL + e.toString();
            throw new AssertionError((Object)message);
        }
        return node;
    }

    protected void assertPrintsTo(boolean newlines, String sql, String expected) {
        SqlNode node = this.parseQuery(sql);
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setAlwaysUseParentheses(false);
        if (newlines) {
            prettyWriter.setCaseClausesOnNewLines(true);
        }
        String actual = prettyWriter.format(node);
        this.getDiffRepos().assertEquals("formatted", expected, actual);
        String actual2 = actual.replaceAll("`", "\"");
        SqlNode node2 = this.parseQuery(actual2);
        Assert.assertTrue((boolean)node.equalsDeep(node2, Litmus.THROW));
    }

    protected void assertExprPrintsTo(boolean newlines, String sql, String expected) {
        SqlCall valuesCall = (SqlCall)this.parseQuery("VALUES (" + sql + ")");
        SqlCall rowCall = (SqlCall)valuesCall.operand(0);
        SqlNode node = rowCall.operand(0);
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setAlwaysUseParentheses(false);
        if (newlines) {
            prettyWriter.setCaseClausesOnNewLines(true);
        }
        String actual = prettyWriter.format(node);
        this.getDiffRepos().assertEquals("formatted", expected, actual);
        String actual2 = actual.replaceAll("`", "\"");
        SqlNode valuesCall2 = this.parseQuery("VALUES (" + actual2 + ")");
        Assert.assertTrue((boolean)valuesCall.equalsDeep(valuesCall2, Litmus.THROW));
    }

    protected void checkSimple(SqlPrettyWriter prettyWriter, String expectedDesc, String expected) throws Exception {
        SqlNode node = this.parseQuery("select x as a, b as b, c as c, d, 'mixed-Case string', unquotedCamelCaseId, \"quoted id\" from (select * from t where x = y and a > 5 group by z, zz window w as (partition by c),  w1 as (partition by c,d order by a, b   range between interval '2:2' hour to minute preceding    and interval '1' day following)) order by gg");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        prettyWriter.describe(pw, true);
        pw.flush();
        String desc = sw.toString();
        this.getDiffRepos().assertEquals("desc", expectedDesc, desc);
        String actual = prettyWriter.format(node);
        this.getDiffRepos().assertEquals("formatted", expected, actual);
    }

    @Test
    public void testDefault() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testIndent8() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setIndentation(8);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testClausesNotOnNewLine() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setClauseStartsLine(false);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testSelectListItemsOnSeparateLines() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setSelectListItemsOnSeparateLines(true);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testSelectListExtraIndentFlag() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setSelectListItemsOnSeparateLines(true);
        prettyWriter.setSelectListExtraIndentFlag(false);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testKeywordsLowerCase() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setKeywordsLowerCase(true);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testParenthesizeAllExprs() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setAlwaysUseParentheses(true);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testOnlyQuoteIdentifiersWhichNeedIt() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setQuoteAllIdentifiers(false);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Test
    public void testDamiansSubQueryStyle() throws Exception {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setSubQueryStyle(SqlWriter.SubQueryStyle.BLACK);
        this.checkSimple(prettyWriter, "${desc}", "${formatted}");
    }

    @Ignore(value="default SQL parser cannot parse DDL")
    @Test
    public void testExplain() {
        this.assertPrintsTo(false, "explain select * from t", "foo");
    }

    @Test
    public void testCase() {
        this.assertExprPrintsTo(true, "case 1 when 2 + 3 then 4 when case a when b then c else d end then 6 else 7 end", "CASE" + NL + "WHEN 1 = 2 + 3" + NL + "THEN 4" + NL + "WHEN 1 = CASE" + NL + "        WHEN `A` = `B`" + NL + "        THEN `C`" + NL + "        ELSE `D`" + NL + "        END" + NL + "THEN 6" + NL + "ELSE 7" + NL + "END");
    }

    @Test
    public void testCase2() {
        this.assertExprPrintsTo(false, "case 1 when 2 + 3 then 4 when case a when b then c else d end then 6 else 7 end", "CASE WHEN 1 = 2 + 3 THEN 4 WHEN 1 = CASE WHEN `A` = `B` THEN `C` ELSE `D` END THEN 6 ELSE 7 END");
    }

    @Test
    public void testBetween() {
        this.assertExprPrintsTo(true, "x not between symmetric y and z", "`X` NOT BETWEEN SYMMETRIC `Y` AND `Z`");
    }

    @Test
    public void testCast() {
        this.assertExprPrintsTo(true, "cast(x + y as decimal(5, 10))", "CAST(`X` + `Y` AS DECIMAL(5, 10))");
    }

    @Test
    public void testLiteralChain() {
        this.assertExprPrintsTo(true, "'x' /* comment */ 'y'" + NL + "  'z' ", "'x'" + NL + "'y'" + NL + "'z'");
    }

    @Test
    public void testOverlaps() {
        this.assertExprPrintsTo(true, "(x,xx) overlaps (y,yy) or x is not null", "PERIOD (`X`, `XX`) OVERLAPS PERIOD (`Y`, `YY`) OR `X` IS NOT NULL");
    }

    @Test
    public void testUnion() {
        this.assertPrintsTo(true, "select * from t union select * from (  select * from u   union select * from v) union select * from w order by a, b", "${formatted}");
    }

    @Test
    public void testMultiset() {
        this.assertPrintsTo(false, "values (multiset (select * from t))", "${formatted}");
    }

    @Test
    public void testInnerJoin() {
        this.assertPrintsTo(true, "select * from x inner join y on x.k=y.k", "${formatted}");
    }

    @Test
    public void testWhereListItemsOnSeparateLinesOr() throws Exception {
        this.checkPrettySeparateLines("select x from y where h is not null and i < j or ((a or b) is true) and d not in (f,g) or x <> z");
    }

    @Test
    public void testWhereListItemsOnSeparateLinesAnd() throws Exception {
        this.checkPrettySeparateLines("select x from y where h is not null and (i < j or ((a or b) is true)) and (d not in (f,g) or v <> ((w * x) + y) * z)");
    }

    private void checkPrettySeparateLines(String sql) {
        SqlPrettyWriter prettyWriter = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        prettyWriter.setSelectListItemsOnSeparateLines(true);
        prettyWriter.setSelectListExtraIndentFlag(false);
        SqlNode node = this.parseQuery(sql);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        prettyWriter.describe(pw, true);
        pw.flush();
        String desc = sw.toString();
        this.getDiffRepos().assertEquals("desc", "${desc}", desc);
        prettyWriter.setWhereListItemsOnSeparateLines(true);
        String actual = prettyWriter.format(node);
        this.getDiffRepos().assertEquals("formatted", "${formatted}", actual);
    }
}

