/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableIntList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BitSetsTest {
    @Test
    public void testToIterBitSet() {
        BitSet bitSet = new BitSet();
        this.assertToIterBitSet("", bitSet);
        bitSet.set(0);
        this.assertToIterBitSet("0", bitSet);
        bitSet.set(1);
        this.assertToIterBitSet("0, 1", bitSet);
        bitSet.clear();
        bitSet.set(10);
        this.assertToIterBitSet("10", bitSet);
    }

    private void assertToIterBitSet(String expected, BitSet bitSet) {
        StringBuilder buf = new StringBuilder();
        Iterator iterator = BitSets.toIter((BitSet)bitSet).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(i));
        }
        Assert.assertEquals((Object)expected, (Object)buf.toString());
    }

    @Test
    public void testToListBitSet() {
        BitSet bitSet = new BitSet(10);
        Assert.assertEquals((Object)BitSets.toList((BitSet)bitSet), Collections.emptyList());
        bitSet.set(5);
        Assert.assertEquals((Object)BitSets.toList((BitSet)bitSet), Arrays.asList(5));
        bitSet.set(3);
        Assert.assertEquals((Object)BitSets.toList((BitSet)bitSet), Arrays.asList(3, 5));
    }

    @Test
    public void testBitSetOf() {
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.of((int[])new int[]{0, 4, 2})), Arrays.asList(0, 2, 4));
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.of((int[])new int[0])), Collections.emptyList());
    }

    @Test
    public void testBitSetsRange() {
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.range((int)0, (int)4)), Arrays.asList(0, 1, 2, 3));
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.range((int)1, (int)4)), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)BitSets.toList((BitSet)BitSets.range((int)2, (int)2)), Collections.emptyList());
    }

    @Test
    public void testBitSetsToArray() {
        int[][] arrays;
        for (int[] array : arrays = new int[][]{new int[0], {0}, {0, 2}, {1, 65}, {100}}) {
            Assert.assertThat((Object)BitSets.toArray((BitSet)BitSets.of((int[])array)), (Matcher)CoreMatchers.equalTo((Object)array));
        }
    }

    @Test
    public void testBitSetsUnion() {
        Assert.assertThat((Object)BitSets.union((BitSet)BitSets.of((int[])new int[]{1}), (BitSet[])new BitSet[]{BitSets.of((int[])new int[]{3})}).toString(), (Matcher)CoreMatchers.equalTo((Object)"{1, 3}"));
        Assert.assertThat((Object)BitSets.union((BitSet)BitSets.of((int[])new int[]{1}), (BitSet[])new BitSet[]{BitSets.of((int[])new int[]{3, 100})}).toString(), (Matcher)CoreMatchers.equalTo((Object)"{1, 3, 100}"));
        Assert.assertThat((Object)BitSets.union((BitSet)BitSets.of((int[])new int[]{1}), (BitSet[])new BitSet[]{BitSets.of((int[])new int[]{2}), BitSets.of((int[])new int[0]), BitSets.of((int[])new int[]{3})}).toString(), (Matcher)CoreMatchers.equalTo((Object)"{1, 2, 3}"));
    }

    @Test
    public void testBitSetsContains() {
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.range((int)0, (int)5), (BitSet)BitSets.range((int)2, (int)4)));
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.range((int)0, (int)5), (BitSet)BitSets.of((int[])new int[]{4})));
        Assert.assertFalse((boolean)BitSets.contains((BitSet)BitSets.range((int)0, (int)5), (BitSet)BitSets.of((int[])new int[]{14})));
        Assert.assertFalse((boolean)BitSets.contains((BitSet)BitSets.range((int)20, (int)25), (BitSet)BitSets.of((int[])new int[]{14})));
        BitSet empty = BitSets.of((int[])new int[0]);
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.range((int)20, (int)25), (BitSet)empty));
        Assert.assertTrue((boolean)BitSets.contains((BitSet)empty, (BitSet)empty));
        Assert.assertFalse((boolean)BitSets.contains((BitSet)empty, (BitSet)BitSets.of((int[])new int[]{0})));
        Assert.assertFalse((boolean)BitSets.contains((BitSet)empty, (BitSet)BitSets.of((int[])new int[]{1})));
        Assert.assertFalse((boolean)BitSets.contains((BitSet)empty, (BitSet)BitSets.of((int[])new int[]{1000})));
        Assert.assertTrue((boolean)BitSets.contains((BitSet)BitSets.of((int[])new int[]{1, 4, 7}), (BitSet)BitSets.of((int[])new int[]{1, 4, 7})));
    }

    @Test
    public void testBitSetOfImmutableIntList() {
        ImmutableIntList list = ImmutableIntList.of();
        Assert.assertThat((Object)BitSets.of((ImmutableIntList)list), (Matcher)CoreMatchers.equalTo((Object)new BitSet()));
        list = ImmutableIntList.of((int[])new int[]{2, 70, 5, 0});
        Assert.assertThat((Object)BitSets.of((ImmutableIntList)list), (Matcher)CoreMatchers.equalTo((Object)BitSets.of((int[])new int[]{0, 2, 5, 70})));
    }

    @Test
    public void testPreviousClearBit() {
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[0]), (int)10), (Matcher)CoreMatchers.equalTo((Object)10));
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[0]), (int)0), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[0]), (int)-1), (Matcher)CoreMatchers.equalTo((Object)-1));
        try {
            int actual = BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[0]), (int)-2);
            Assert.fail((String)("expected exception, got " + actual));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[]{0, 1, 3, 4}), (int)4), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[]{0, 1, 3, 4}), (int)3), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[]{0, 1, 3, 4}), (int)2), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[]{0, 1, 3, 4}), (int)1), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)BitSets.previousClearBit((BitSet)BitSets.of((int[])new int[]{1, 3, 4}), (int)1), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testClosure() {
        TreeMap empty = new TreeMap();
        Assert.assertThat((Object)BitSets.closure(empty), (Matcher)CoreMatchers.equalTo(empty));
        TreeMap<Integer, BitSet> map = new TreeMap<Integer, BitSet>();
        map.put(0, BitSets.of((int[])new int[]{3}));
        map.put(1, BitSets.of((int[])new int[0]));
        map.put(2, BitSets.of((int[])new int[]{7}));
        map.put(3, BitSets.of((int[])new int[]{4, 12}));
        map.put(4, BitSets.of((int[])new int[0]));
        map.put(5, BitSets.of((int[])new int[0]));
        map.put(6, BitSets.of((int[])new int[0]));
        map.put(7, BitSets.of((int[])new int[0]));
        map.put(8, BitSets.of((int[])new int[0]));
        map.put(9, BitSets.of((int[])new int[0]));
        map.put(10, BitSets.of((int[])new int[0]));
        map.put(11, BitSets.of((int[])new int[0]));
        map.put(12, BitSets.of((int[])new int[0]));
        String original = ((Object)map).toString();
        String expected = "{0={3, 4, 12}, 1={}, 2={7}, 3={3, 4, 12}, 4={4, 12}, 5={}, 6={}, 7={7}, 8={}, 9={}, 10={}, 11={}, 12={4, 12}}";
        Assert.assertThat((Object)BitSets.closure(map).toString(), (Matcher)CoreMatchers.equalTo((Object)"{0={3, 4, 12}, 1={}, 2={7}, 3={3, 4, 12}, 4={4, 12}, 5={}, 6={}, 7={7}, 8={}, 9={}, 10={}, 11={}, 12={4, 12}}"));
        Assert.assertThat((String)"argument modified", (Object)((Object)map).toString(), (Matcher)CoreMatchers.equalTo((Object)original));
        TreeMap<Integer, BitSet> map2 = new TreeMap<Integer, BitSet>();
        map2.put(0, BitSets.of((int[])new int[]{3}));
        map2.put(2, BitSets.of((int[])new int[]{7}));
        map2.put(3, BitSets.of((int[])new int[]{4, 12}));
        map2.put(9, BitSets.of((int[])new int[0]));
        String original2 = ((Object)map2).toString();
        Assert.assertThat((Object)BitSets.closure(map2).toString(), (Matcher)CoreMatchers.equalTo((Object)"{0={3, 4, 12}, 1={}, 2={7}, 3={3, 4, 12}, 4={4, 12}, 5={}, 6={}, 7={7}, 8={}, 9={}, 10={}, 11={}, 12={4, 12}}"));
        Assert.assertThat((String)"argument modified", (Object)((Object)map2).toString(), (Matcher)CoreMatchers.equalTo((Object)original2));
    }
}

