/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.util.Smalls;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class UdfTest {
    private CalciteAssert.AssertThat withUdf() {
        String model = "{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + JdbcTest.EmpDeptTableFactory.class.getName() + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       functions: [\n         {\n           name: 'MY_PLUS',\n           className: '" + Smalls.MyPlusFunction.class.getName() + "'\n         },\n         {\n           name: 'MY_DET_PLUS',\n           className: '" + Smalls.MyDeterministicPlusFunction.class.getName() + "'\n         },\n         {\n           name: 'MY_LEFT',\n           className: '" + Smalls.MyLeftFunction.class.getName() + "'\n         },\n         {\n           name: 'ABCDE',\n           className: '" + Smalls.MyAbcdeFunction.class.getName() + "'\n         },\n         {\n           name: 'MY_STR',\n           className: '" + Smalls.MyToStringFunction.class.getName() + "'\n         },\n         {\n           name: 'MY_DOUBLE',\n           className: '" + Smalls.MyDoubleFunction.class.getName() + "'\n         },\n         {\n           name: 'COUNT_ARGS',\n           className: '" + Smalls.CountArgs0Function.class.getName() + "'\n         },\n         {\n           name: 'COUNT_ARGS',\n           className: '" + Smalls.CountArgs1Function.class.getName() + "'\n         },\n         {\n           name: 'COUNT_ARGS',\n           className: '" + Smalls.CountArgs1NullableFunction.class.getName() + "'\n         },\n         {\n           name: 'COUNT_ARGS',\n           className: '" + Smalls.CountArgs2Function.class.getName() + "'\n         },\n         {\n           name: 'MY_ABS',\n           className: '" + Math.class.getName() + "',\n           methodName: 'abs'\n         },\n         {\n           name: 'NULL4',\n           className: '" + Smalls.Null4Function.class.getName() + "'\n         },\n         {\n           name: 'NULL8',\n           className: '" + Smalls.Null8Function.class.getName() + "'\n         },\n         {\n           className: '" + Smalls.MultipleFunction.class.getName() + "',\n           methodName: '*'\n         },\n         {\n           className: '" + Smalls.AllTypesFunction.class.getName() + "',\n           methodName: '*'\n         }\n       ]\n     }\n   ]\n}";
        return CalciteAssert.model(model);
    }

    @Ignore(value="[CALCITE-1561] Intermittent test failures")
    @Test
    public void testUserDefinedFunction() throws Exception {
        String sql = "select \"adhoc\".my_plus(\"deptno\", 100) as p\nfrom \"adhoc\".EMPLOYEES";
        AtomicInteger c = Smalls.MyPlusFunction.INSTANCE_COUNT;
        int before = c.get();
        this.withUdf().query("select \"adhoc\".my_plus(\"deptno\", 100) as p\nfrom \"adhoc\".EMPLOYEES").returnsUnordered("P=110", "P=120", "P=110", "P=110");
        int after = c.get();
        Assert.assertThat((Object)after, (Matcher)CoreMatchers.is((Object)(before + 4)));
    }

    @Test
    public void testUserDefinedFunctionInstanceCount() throws Exception {
        String sql = "select \"adhoc\".my_det_plus(\"deptno\", 100) as p\nfrom \"adhoc\".EMPLOYEES";
        AtomicInteger c = Smalls.MyDeterministicPlusFunction.INSTANCE_COUNT;
        int before = c.get();
        this.withUdf().query("select \"adhoc\".my_det_plus(\"deptno\", 100) as p\nfrom \"adhoc\".EMPLOYEES").returnsUnordered("P=110", "P=120", "P=110", "P=110");
        int after = c.get();
        Assert.assertThat((Object)after, (Matcher)CoreMatchers.is((Object)(before + 1)));
    }

    @Test
    public void testUserDefinedFunctionB() throws Exception {
        String sql = "select \"adhoc\".my_double(\"deptno\") as p\nfrom \"adhoc\".EMPLOYEES";
        String expected = "P=20\nP=40\nP=20\nP=20\n";
        this.withUdf().query("select \"adhoc\".my_double(\"deptno\") as p\nfrom \"adhoc\".EMPLOYEES").returns("P=20\nP=40\nP=20\nP=20\n");
    }

    @Test
    public void testUserDefinedFunctionInView() throws Exception {
        Class.forName("org.apache.calcite.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        SchemaPlus post = rootSchema.add("POST", (Schema)new AbstractSchema());
        post.add("MY_INCREMENT", (Function)ScalarFunctionImpl.create(Smalls.MyIncrement.class, (String)"eval"));
        String viewSql = "select \"empid\" as EMPLOYEE_ID,\n  \"name\" || ' ' || \"name\" as EMPLOYEE_NAME,\n  \"salary\" as EMPLOYEE_SALARY,\n  POST.MY_INCREMENT(\"empid\", 10) as INCREMENTED_SALARY\nfrom \"hr\".\"emps\"";
        post.add("V_EMP", (Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select \"empid\" as EMPLOYEE_ID,\n  \"name\" || ' ' || \"name\" as EMPLOYEE_NAME,\n  \"salary\" as EMPLOYEE_SALARY,\n  POST.MY_INCREMENT(\"empid\", 10) as INCREMENTED_SALARY\nfrom \"hr\".\"emps\"", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"V_EMP"), null));
        String result = "EMPLOYEE_ID=100; EMPLOYEE_NAME=Bill Bill; EMPLOYEE_SALARY=10000.0; INCREMENTED_SALARY=110.0\nEMPLOYEE_ID=200; EMPLOYEE_NAME=Eric Eric; EMPLOYEE_SALARY=8000.0; INCREMENTED_SALARY=220.0\nEMPLOYEE_ID=150; EMPLOYEE_NAME=Sebastian Sebastian; EMPLOYEE_SALARY=7000.0; INCREMENTED_SALARY=165.0\nEMPLOYEE_ID=110; EMPLOYEE_NAME=Theodore Theodore; EMPLOYEE_SALARY=11500.0; INCREMENTED_SALARY=121.0\n";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select \"empid\" as EMPLOYEE_ID,\n  \"name\" || ' ' || \"name\" as EMPLOYEE_NAME,\n  \"salary\" as EMPLOYEE_SALARY,\n  POST.MY_INCREMENT(\"empid\", 10) as INCREMENTED_SALARY\nfrom \"hr\".\"emps\"");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"EMPLOYEE_ID=100; EMPLOYEE_NAME=Bill Bill; EMPLOYEE_SALARY=10000.0; INCREMENTED_SALARY=110.0\nEMPLOYEE_ID=200; EMPLOYEE_NAME=Eric Eric; EMPLOYEE_SALARY=8000.0; INCREMENTED_SALARY=220.0\nEMPLOYEE_ID=150; EMPLOYEE_NAME=Sebastian Sebastian; EMPLOYEE_SALARY=7000.0; INCREMENTED_SALARY=165.0\nEMPLOYEE_ID=110; EMPLOYEE_NAME=Theodore Theodore; EMPLOYEE_SALARY=11500.0; INCREMENTED_SALARY=121.0\n"));
        resultSet.close();
        ResultSet viewResultSet = statement.executeQuery("select * from \"POST\".\"V_EMP\"");
        Assert.assertThat((Object)CalciteAssert.toString(viewResultSet), (Matcher)CoreMatchers.is((Object)"EMPLOYEE_ID=100; EMPLOYEE_NAME=Bill Bill; EMPLOYEE_SALARY=10000.0; INCREMENTED_SALARY=110.0\nEMPLOYEE_ID=200; EMPLOYEE_NAME=Eric Eric; EMPLOYEE_SALARY=8000.0; INCREMENTED_SALARY=220.0\nEMPLOYEE_ID=150; EMPLOYEE_NAME=Sebastian Sebastian; EMPLOYEE_SALARY=7000.0; INCREMENTED_SALARY=165.0\nEMPLOYEE_ID=110; EMPLOYEE_NAME=Theodore Theodore; EMPLOYEE_SALARY=11500.0; INCREMENTED_SALARY=121.0\n"));
        statement.close();
        connection.close();
    }

    @Test
    public void testNotNullImplementor() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("select upper(\"adhoc\".my_str(\"name\")) as p from \"adhoc\".EMPLOYEES").returns("P=<BILL>\nP=<ERIC>\nP=<SEBASTIAN>\nP=<THEODORE>\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(\"name\") is not null").returns("P=Bill\nP=Eric\nP=Sebastian\nP=Theodore\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(upper(\"name\")) is not null").returns("P=Bill\nP=Eric\nP=Sebastian\nP=Theodore\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere upper(\"adhoc\".my_str(\"name\")) is not null").returns("P=Bill\nP=Eric\nP=Sebastian\nP=Theodore\n");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(\"name\") is null").returns("");
        with.query("select \"name\" as p from \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(upper(\"adhoc\".my_str(\"name\"))) ='8'").returns("");
    }

    @Test
    public void testSemiStrict() {
        CalciteAssert.AssertThat with = this.withUdf();
        String sql = "select\n  \"adhoc\".null4(upper(\"name\")) as p\n from \"adhoc\".EMPLOYEES";
        with.query("select\n  \"adhoc\".null4(upper(\"name\")) as p\n from \"adhoc\".EMPLOYEES").returnsUnordered("P=null", "P=null", "P=SEBASTIAN", "P=THEODORE");
        String sql2 = "select\n  \"adhoc\".my_str(upper(\"adhoc\".null4(\"name\"))) as p\n from \"adhoc\".EMPLOYEES";
        with.query("select\n  \"adhoc\".my_str(upper(\"adhoc\".null4(\"name\"))) as p\n from \"adhoc\".EMPLOYEES").returnsUnordered("P=<null>", "P=<null>", "P=<SEBASTIAN>", "P=<THEODORE>");
        String sql3 = "select\n  \"adhoc\".null8(\"adhoc\".null4(\"name\")) as p\n from \"adhoc\".EMPLOYEES";
        with.query("select\n  \"adhoc\".null8(\"adhoc\".null4(\"name\")) as p\n from \"adhoc\".EMPLOYEES").returnsUnordered("P=null", "P=null", "P=Sebastian", "P=null");
    }

    @Test
    public void testUdfDerivedReturnType() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("select max(\"adhoc\".my_double(\"deptno\")) as p from \"adhoc\".EMPLOYEES").returns("P=40\n");
        with.query("select max(\"adhoc\".my_str(\"name\")) as p\nfrom \"adhoc\".EMPLOYEES\nwhere \"adhoc\".my_str(\"name\") is null").returns("P=null\n");
    }

    @Test
    public void testUdfOverloaded() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values (\"adhoc\".count_args(),\n \"adhoc\".count_args(0),\n \"adhoc\".count_args(0, 0))").returns("EXPR$0=0; EXPR$1=1; EXPR$2=2\n");
        with.query("select max(\"adhoc\".count_args()) as p0,\n min(\"adhoc\".count_args(0)) as p1,\n max(\"adhoc\".count_args(0, 0)) as p2\nfrom \"adhoc\".EMPLOYEES limit 1").returns("P0=0; P1=1; P2=2\n");
    }

    @Test
    public void testUdfOverloadedNullable() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values (\"adhoc\".count_args(),\n \"adhoc\".count_args(cast(null as smallint)),\n \"adhoc\".count_args(0, 0))").returns("EXPR$0=0; EXPR$1=-1; EXPR$2=2\n");
    }

    @Test
    public void testUdfArgumentName() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values (\"adhoc\".my_left(\"s\" => 'hello', \"n\" => 3))").returns("EXPR$0=hel\n");
        with.query("values (\"adhoc\".my_left(\"n\" => 3, \"s\" => 'hello'))").returns("EXPR$0=hel\n");
        with.query("values (\"adhoc\".my_left(\"n\" => 1 + 2, \"s\" => 'hello'))").returns("EXPR$0=hel\n");
        with.query("values (\"adhoc\".my_left(\"n\" => 3, \"n\" => 2, \"s\" => 'hello'))").throws_("Duplicate argument name 'n'");
        with.query("values (\"adhoc\".my_left(\"n\" => 3, \"m\" => 2, \"s\" => 'h'))").throws_("No match found for function signature MY_LEFT(n => <NUMERIC>, m => <NUMERIC>, s => <CHARACTER>)");
        with.query("values (\"adhoc\".my_left(\"n\" => 3))").throws_("No match found for function signature MY_LEFT(n => <NUMERIC>)");
        with.query("values (\"adhoc\".my_left(\"s\" => 'hello'))").throws_("No match found for function signature MY_LEFT(s => <CHARACTER>)");
        with.query("values (\"adhoc\".my_left(\"n\" => 'hello', \"s\" => 'x'))").throws_("No match found for function signature MY_LEFT(n => <CHARACTER>, s => <CHARACTER>)");
        with.query("values (\"adhoc\".my_left(\"n\" => 1, \"s\" => 0))").throws_("No match found for function signature MY_LEFT(n => <NUMERIC>, s => <NUMERIC>)");
    }

    @Test
    public void testUdfArgumentOptional() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values (\"adhoc\".abcde(a=>1,b=>2,c=>3,d=>4,e=>5))").returns("EXPR$0={a: 1, b: 2, c: 3, d: 4, e: 5}\n");
        with.query("values (\"adhoc\".abcde(1,2,3,4,CAST(NULL AS INTEGER)))").returns("EXPR$0={a: 1, b: 2, c: 3, d: 4, e: null}\n");
        with.query("values (\"adhoc\".abcde(a=>1,b=>2,c=>3,d=>4))").returns("EXPR$0={a: 1, b: 2, c: 3, d: 4, e: null}\n");
        with.query("values (\"adhoc\".abcde(a=>1,b=>2,c=>3))").returns("EXPR$0={a: 1, b: 2, c: 3, d: null, e: null}\n");
        with.query("values (\"adhoc\".abcde(a=>1,e=>5,c=>3))").returns("EXPR$0={a: 1, b: null, c: 3, d: null, e: 5}\n");
        with.query("values (\"adhoc\".abcde(1,2,3))").returns("EXPR$0={a: 1, b: 2, c: 3, d: null, e: null}\n");
        with.query("values (\"adhoc\".abcde(1,2,3,4))").returns("EXPR$0={a: 1, b: 2, c: 3, d: 4, e: null}\n");
        with.query("values (\"adhoc\".abcde(1,2,3,4,5))").returns("EXPR$0={a: 1, b: 2, c: 3, d: 4, e: 5}\n");
        with.query("values (\"adhoc\".abcde(1,2))").throws_("No match found for function signature ABCDE(<NUMERIC>, <NUMERIC>)");
        with.query("values (\"adhoc\".abcde(1,DEFAULT,3))").returns("EXPR$0={a: 1, b: null, c: 3, d: null, e: null}\n");
        with.query("values (\"adhoc\".abcde(1,DEFAULT,'abcde'))").throws_("No match found for function signature ABCDE(<NUMERIC>, <ANY>, <CHARACTER>)");
        with.query("values (\"adhoc\".abcde(true))").throws_("No match found for function signature ABCDE(<BOOLEAN>)");
        with.query("values (\"adhoc\".abcde(true,DEFAULT))").throws_("No match found for function signature ABCDE(<BOOLEAN>, <ANY>)");
        with.query("values (\"adhoc\".abcde(1,DEFAULT,3,DEFAULT))").returns("EXPR$0={a: 1, b: null, c: 3, d: null, e: null}\n");
        with.query("values (\"adhoc\".abcde(1,2,DEFAULT))").throws_("DEFAULT is only allowed for optional parameters");
        with.query("values (\"adhoc\".abcde(a=>1,b=>2,c=>DEFAULT))").throws_("DEFAULT is only allowed for optional parameters");
        with.query("values (\"adhoc\".abcde(a=>1,b=>DEFAULT,c=>3))").returns("EXPR$0={a: 1, b: null, c: 3, d: null, e: null}\n");
    }

    @Test
    public void testUserDefinedFunction2() throws Exception {
        UdfTest.withBadUdf(Smalls.AwkwardFunction.class).connectThrows("Declaring class 'org.apache.calcite.util.Smalls$AwkwardFunction' of non-static user-defined function must have a public constructor with zero parameters");
    }

    @Test
    public void testUserDefinedFunctionWithMethodName() throws Exception {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values abs(-4)").returnsValue("4");
        with.query("values abs(-4.5)").returnsValue("4.5");
        with.query("values \"adhoc\".\"fun1\"(2)").returnsValue("4");
        with.query("values \"adhoc\".\"fun1\"(2, 3)").returnsValue("5");
        with.query("values \"adhoc\".\"fun1\"('Foo Bar')").returnsValue("foo bar");
        with.query("values \"adhoc\".\"fun2\"(10)").returnsValue("30");
        with.query("values \"adhoc\".\"nonStatic\"(2)").throws_("No match found for function signature nonStatic(<NUMERIC>)");
    }

    @Test
    public void testUserDefinedAggregateFunction() throws Exception {
        String empDept = JdbcTest.EmpDeptTableFactory.class.getName();
        String sum = Smalls.MyStaticSumFunction.class.getName();
        String sum2 = Smalls.MySumFunction.class.getName();
        CalciteAssert.AssertThat with = CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + empDept + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       functions: [\n         {\n           name: 'MY_SUM',\n           className: '" + sum + "'\n         },\n         {\n           name: 'MY_SUM2',\n           className: '" + sum2 + "'\n         }\n       ]\n     }\n   ]\n}").withDefaultSchema("adhoc");
        with.withDefaultSchema(null).query("select \"adhoc\".my_sum(\"deptno\") as p from \"adhoc\".EMPLOYEES\n").returns("P=50\n");
        with.query("select my_sum(\"empid\"), \"deptno\" as p from EMPLOYEES\n").throws_("Expression 'deptno' is not being grouped");
        with.query("select my_sum(\"deptno\") as p from EMPLOYEES\n").returns("P=50\n");
        with.query("select my_sum(\"name\") as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM(<CHARACTER>)");
        with.query("select my_sum(\"deptno\", 1) as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM(<NUMERIC>, <NUMERIC>)");
        with.query("select my_sum() as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM()");
        with.query("select \"deptno\", my_sum(\"deptno\") as p from EMPLOYEES\ngroup by \"deptno\"").returnsUnordered("deptno=20; P=20", "deptno=10; P=30");
        with.query("select \"deptno\", my_sum2(\"deptno\") as p from EMPLOYEES\ngroup by \"deptno\"").returnsUnordered("deptno=20; P=20", "deptno=10; P=30");
    }

    @Test
    public void testUserDefinedAggregateFunctionWithMultipleParameters() throws Exception {
        String empDept = JdbcTest.EmpDeptTableFactory.class.getName();
        String sum21 = Smalls.MyTwoParamsSumFunctionFilter1.class.getName();
        String sum22 = Smalls.MyTwoParamsSumFunctionFilter2.class.getName();
        String sum31 = Smalls.MyThreeParamsSumFunctionWithFilter1.class.getName();
        String sum32 = Smalls.MyThreeParamsSumFunctionWithFilter2.class.getName();
        CalciteAssert.AssertThat with = CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + empDept + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       functions: [\n         {\n           name: 'MY_SUM2',\n           className: '" + sum21 + "'\n         },\n         {\n           name: 'MY_SUM2',\n           className: '" + sum22 + "'\n         },\n         {\n           name: 'MY_SUM3',\n           className: '" + sum31 + "'\n         },\n         {\n           name: 'MY_SUM3',\n           className: '" + sum32 + "'\n         }\n       ]\n     }\n   ]\n}").withDefaultSchema("adhoc");
        with.withDefaultSchema(null).query("select \"adhoc\".my_sum3(\"deptno\",\"name\",'Eric') as p from \"adhoc\".EMPLOYEES\n").returns("P=20\n");
        with.query("select \"adhoc\".my_sum3(\"empid\",\"deptno\",\"commission\") as p from \"adhoc\".EMPLOYEES\n").returns("P=330\n");
        with.query("select \"adhoc\".my_sum3(\"empid\",\"deptno\",\"commission\"),\"name\" as p from \"adhoc\".EMPLOYEES\n").throws_("Expression 'name' is not being grouped");
        with.query("select \"name\",\"adhoc\".my_sum3(\"empid\",\"deptno\",\"commission\") as p from \"adhoc\".EMPLOYEES\ngroup by \"name\"").returnsUnordered("name=Theodore; P=0", "name=Eric; P=220", "name=Bill; P=110", "name=Sebastian; P=0");
        with.query("select \"adhoc\".my_sum3(\"empid\",\"deptno\",\"salary\") as p from \"adhoc\".EMPLOYEES\n").throws_("No match found for function signature MY_SUM3(<NUMERIC>, <NUMERIC>, <APPROXIMATE_NUMERIC>)");
        with.query("select \"adhoc\".my_sum3(\"empid\",\"deptno\",\"name\") as p from \"adhoc\".EMPLOYEES\n").throws_("No match found for function signature MY_SUM3(<NUMERIC>, <NUMERIC>, <CHARACTER>)");
        with.query("select \"adhoc\".my_sum2(\"commission\",250) as p from \"adhoc\".EMPLOYEES\n").returns("P=1500\n");
        with.query("select \"adhoc\".my_sum2(\"name\",250) as p from \"adhoc\".EMPLOYEES\n").throws_("No match found for function signature MY_SUM2(<CHARACTER>, <NUMERIC>)");
        with.query("select \"adhoc\".my_sum2(\"empid\",0.0) as p from \"adhoc\".EMPLOYEES\n").throws_("No match found for function signature MY_SUM2(<NUMERIC>, <NUMERIC>)");
    }

    @Test
    public void testUserDefinedAggregateFunction3() throws Exception {
        UdfTest.withBadUdf(Smalls.SumFunctionBadIAdd.class).connectThrows("Caused by: java.lang.RuntimeException: In user-defined aggregate class 'org.apache.calcite.util.Smalls$SumFunctionBadIAdd', first parameter to 'add' method must be the accumulator (the return type of the 'init' method)");
    }

    @Test
    public void testUserDefinedAggregateFunctionImplementsInterface() {
        String empDept = JdbcTest.EmpDeptTableFactory.class.getName();
        String mySum3 = Smalls.MySum3.class.getName();
        String model = "{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + empDept + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       functions: [\n         {\n           name: 'MY_SUM3',\n           className: '" + mySum3 + "'\n         }\n       ]\n     }\n   ]\n}";
        CalciteAssert.AssertThat with = CalciteAssert.model(model).withDefaultSchema("adhoc");
        with.query("select my_sum3(\"deptno\") as p from EMPLOYEES\n").returns("P=50\n");
        with.withDefaultSchema(null).query("select \"adhoc\".my_sum3(\"deptno\") as p\nfrom \"adhoc\".EMPLOYEES\n").returns("P=50\n");
        with.query("select my_sum3(\"empid\"), \"deptno\" as p from EMPLOYEES\n").throws_("Expression 'deptno' is not being grouped");
        with.query("select my_sum3(\"deptno\") as p from EMPLOYEES\n").returns("P=50\n");
        with.query("select my_sum3(\"name\") as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM3(<CHARACTER>)");
        with.query("select my_sum3(\"deptno\", 1) as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM3(<NUMERIC>, <NUMERIC>)");
        with.query("select my_sum3() as p from EMPLOYEES\n").throws_("No match found for function signature MY_SUM3()");
        with.query("select \"deptno\", my_sum3(\"deptno\") as p from EMPLOYEES\ngroup by \"deptno\"").returnsUnordered("deptno=20; P=20", "deptno=10; P=30");
    }

    private static CalciteAssert.AssertThat withBadUdf(Class clazz) {
        String empDept = JdbcTest.EmpDeptTableFactory.class.getName();
        String className = clazz.getName();
        return CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       tables: [\n         {\n           name: 'EMPLOYEES',\n           type: 'custom',\n           factory: '" + empDept + "',\n           operand: {'foo': true, 'bar': 345}\n         }\n       ],\n       functions: [\n         {\n           name: 'AWKWARD',\n           className: '" + className + "'\n         }\n       ]\n     }\n   ]\n}").withDefaultSchema("adhoc");
    }

    @Test
    public void testUserDefinedAggregateFunctionWithFilter() throws Exception {
        String sum = Smalls.MyStaticSumFunction.class.getName();
        String sum2 = Smalls.MySumFunction.class.getName();
        CalciteAssert.AssertThat with = CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n" + JdbcTest.SCOTT_SCHEMA + ",\n     {\n       name: 'adhoc',\n       functions: [\n         {\n           name: 'MY_SUM',\n           className: '" + sum + "'\n         },\n         {\n           name: 'MY_SUM2',\n           className: '" + sum2 + "'\n         }\n       ]\n     }\n   ]\n}").withDefaultSchema("adhoc");
        with.query("select deptno, \"adhoc\".my_sum(deptno) as p\nfrom scott.emp\ngroup by deptno\n").returns("DEPTNO=20; P=100\nDEPTNO=10; P=30\nDEPTNO=30; P=180\n");
        with.query("select deptno,\n  \"adhoc\".my_sum(deptno) filter (where job = 'CLERK') as c,\n  \"adhoc\".my_sum(deptno) filter (where job = 'XXX') as x\nfrom scott.emp\ngroup by deptno\n").returns("DEPTNO=20; C=40; X=0\nDEPTNO=10; C=10; X=0\nDEPTNO=30; C=30; X=0\n");
    }

    @Test
    public void testPath() throws Exception {
        String name = Smalls.MyPlusFunction.class.getName();
        CalciteAssert.AssertThat with = CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       functions: [\n         {\n           name: 'MY_PLUS',\n           className: '" + name + "'\n         }\n       ]\n     },\n     {\n       name: 'adhoc2',\n       functions: [\n         {\n           name: 'MY_PLUS2',\n           className: '" + name + "'\n         }\n       ]\n     },\n     {\n       name: 'adhoc3',\n       path: ['adhoc2','adhoc3'],\n       functions: [\n         {\n           name: 'MY_PLUS3',\n           className: '" + name + "'\n         }\n       ]\n     }\n   ]\n}");
        String err = "No match found for function signature";
        String res = "EXPR$0=2\n";
        CalciteAssert.AssertThat adhoc = with.withDefaultSchema("adhoc");
        adhoc.query("values MY_PLUS(1, 1)").returns("EXPR$0=2\n");
        adhoc.query("values MY_PLUS2(1, 1)").throws_("No match found for function signature");
        adhoc.query("values \"adhoc2\".MY_PLUS(1, 1)").throws_("No match found for function signature");
        adhoc.query("values \"adhoc2\".MY_PLUS2(1, 1)").returns("EXPR$0=2\n");
        CalciteAssert.AssertThat adhoc2 = with.withDefaultSchema("adhoc2");
        adhoc2.query("values MY_PLUS2(1, 1)").returns("EXPR$0=2\n");
        adhoc2.query("values MY_PLUS(1, 1)").throws_("No match found for function signature");
        adhoc2.query("values \"adhoc\".MY_PLUS(1, 1)").returns("EXPR$0=2\n");
        CalciteAssert.AssertThat adhoc3 = with.withDefaultSchema("adhoc3");
        adhoc3.query("values MY_PLUS2(1, 1)").returns("EXPR$0=2\n");
        adhoc3.query("values MY_PLUS(1, 1)").throws_("No match found for function signature");
        adhoc3.query("values \"adhoc\".MY_PLUS(1, 1)").returns("EXPR$0=2\n");
    }

    @Test
    public void testDate() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values \"adhoc\".\"dateFun\"(DATE '1970-01-01')").returnsValue("0");
        with.query("values \"adhoc\".\"dateFun\"(DATE '1970-01-02')").returnsValue("86400000");
        with.query("values \"adhoc\".\"dateFun\"(cast(null as date))").returnsValue("-1");
        with.query("values \"adhoc\".\"timeFun\"(TIME '00:00:00')").returnsValue("0");
        with.query("values \"adhoc\".\"timeFun\"(TIME '00:01:30')").returnsValue("90000");
        with.query("values \"adhoc\".\"timeFun\"(cast(null as time))").returnsValue("-1");
        with.query("values \"adhoc\".\"timestampFun\"(TIMESTAMP '1970-01-01 00:00:00')").returnsValue("0");
        with.query("values \"adhoc\".\"timestampFun\"(TIMESTAMP '1970-01-02 00:01:30')").returnsValue("86490000");
        with.query("values \"adhoc\".\"timestampFun\"(cast(null as timestamp))").returnsValue("-1");
    }

    @Test
    public void testReturnDate() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values \"adhoc\".\"toDateFun\"(0)").returnsValue("1970-01-01");
        with.query("values \"adhoc\".\"toDateFun\"(1)").returnsValue("1970-01-02");
        with.query("values \"adhoc\".\"toDateFun\"(cast(null as bigint))").returnsValue(null);
        with.query("values \"adhoc\".\"toTimeFun\"(0)").returnsValue("00:00:00");
        with.query("values \"adhoc\".\"toTimeFun\"(90000)").returnsValue("00:01:30");
        with.query("values \"adhoc\".\"toTimeFun\"(cast(null as bigint))").returnsValue(null);
        with.query("values \"adhoc\".\"toTimestampFun\"(0)").returnsValue("1970-01-01 00:00:00");
        with.query("values \"adhoc\".\"toTimestampFun\"(86490000)").returnsValue("1970-01-02 00:01:30");
        with.query("values \"adhoc\".\"toTimestampFun\"(cast(null as bigint))").returnsValue(null);
    }

    @Test
    public void testDateAndTimestamp() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values \"adhoc\".\"toLong\"(DATE '1970-01-15')").returns("EXPR$0=1209600000\n");
        with.query("values \"adhoc\".\"toLong\"(DATE '2002-08-11')").returns("EXPR$0=1029024000000\n");
        with.query("values \"adhoc\".\"toLong\"(DATE '2003-04-11')").returns("EXPR$0=1050019200000\n");
        with.query("values \"adhoc\".\"toLong\"(TIMESTAMP '2003-04-11 00:00:00')").returns("EXPR$0=1050019200000\n");
        with.query("values \"adhoc\".\"toLong\"(TIMESTAMP '2003-04-11 00:00:06')").returns("EXPR$0=1050019206000\n");
        with.query("values \"adhoc\".\"toLong\"(TIMESTAMP '2003-04-18 01:20:00')").returns("EXPR$0=1050628800000\n");
        with.query("values \"adhoc\".\"toLong\"(TIME '00:20:00')").returns("EXPR$0=1200000\n");
        with.query("values \"adhoc\".\"toLong\"(TIME '00:20:10')").returns("EXPR$0=1210000\n");
        with.query("values \"adhoc\".\"toLong\"(TIME '01:20:00')").returns("EXPR$0=4800000\n");
    }

    @Test
    public void testBigDecimalAndLong() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("values \"adhoc\".\"toDouble\"(cast(1.0 as double))").returns("EXPR$0=1.0\n");
        with.query("values \"adhoc\".\"toDouble\"(cast(1.0 as decimal))").returns("EXPR$0=1.0\n");
        with.query("values \"adhoc\".\"toDouble\"(cast(1 as double))").returns("EXPR$0=1.0\n");
        with.query("values \"adhoc\".\"toDouble\"(cast(1 as decimal))").returns("EXPR$0=1.0\n");
        with.query("values \"adhoc\".\"toDouble\"(cast(1 as float))").returns("EXPR$0=1.0\n");
        with.query("values \"adhoc\".\"toDouble\"(cast(1.0 as float))").returns("EXPR$0=1.0\n");
    }

    @Test
    public void testReturnDate2() {
        CalciteAssert.AssertThat with = this.withUdf();
        with.query("select * from (values 0) as t(c)\nwhere \"adhoc\".\"toTimestampFun\"(c) in (\n  cast('1970-01-01 00:00:00' as timestamp),\n  cast('1997-02-01 00:00:00' as timestamp))").returnsValue("0");
        with.query("select * from (values 0) as t(c)\nwhere \"adhoc\".\"toTimestampFun\"(c) in (\n  timestamp '1970-01-01 00:00:00',\n  timestamp '1997-02-01 00:00:00')").returnsValue("0");
        with.query("select * from (values 0) as t(c)\nwhere \"adhoc\".\"toTimestampFun\"(c) in (\n  '1970-01-01 00:00:00',\n  '1997-02-01 00:00:00')").returnsValue("0");
    }

    @Test
    public void testArrayUserDefinedFunction() throws Exception {
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            SchemaPlus post = rootSchema.add("POST", (Schema)new AbstractSchema());
            post.add("ARRAY_APPEND", (Function)new ArrayAppendDoubleFunction());
            post.add("ARRAY_APPEND", (Function)new ArrayAppendIntegerFunction());
            String sql = "select \"empid\" as EMPLOYEE_ID,\n  \"name\" || ' ' || \"name\" as EMPLOYEE_NAME,\n  \"salary\" as EMPLOYEE_SALARY,\n  POST.ARRAY_APPEND(ARRAY[1,2,3], \"deptno\") as DEPARTMENTS\nfrom \"hr\".\"emps\"";
            String result = "EMPLOYEE_ID=100; EMPLOYEE_NAME=Bill Bill; EMPLOYEE_SALARY=10000.0; DEPARTMENTS=[1, 2, 3, 10]\nEMPLOYEE_ID=200; EMPLOYEE_NAME=Eric Eric; EMPLOYEE_SALARY=8000.0; DEPARTMENTS=[1, 2, 3, 20]\nEMPLOYEE_ID=150; EMPLOYEE_NAME=Sebastian Sebastian; EMPLOYEE_SALARY=7000.0; DEPARTMENTS=[1, 2, 3, 10]\nEMPLOYEE_ID=110; EMPLOYEE_NAME=Theodore Theodore; EMPLOYEE_SALARY=11500.0; DEPARTMENTS=[1, 2, 3, 10]\n";
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("select \"empid\" as EMPLOYEE_ID,\n  \"name\" || ' ' || \"name\" as EMPLOYEE_NAME,\n  \"salary\" as EMPLOYEE_SALARY,\n  POST.ARRAY_APPEND(ARRAY[1,2,3], \"deptno\") as DEPARTMENTS\nfrom \"hr\".\"emps\"");){
                Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"EMPLOYEE_ID=100; EMPLOYEE_NAME=Bill Bill; EMPLOYEE_SALARY=10000.0; DEPARTMENTS=[1, 2, 3, 10]\nEMPLOYEE_ID=200; EMPLOYEE_NAME=Eric Eric; EMPLOYEE_SALARY=8000.0; DEPARTMENTS=[1, 2, 3, 20]\nEMPLOYEE_ID=150; EMPLOYEE_NAME=Sebastian Sebastian; EMPLOYEE_SALARY=7000.0; DEPARTMENTS=[1, 2, 3, 10]\nEMPLOYEE_ID=110; EMPLOYEE_NAME=Theodore Theodore; EMPLOYEE_SALARY=11500.0; DEPARTMENTS=[1, 2, 3, 10]\n"));
            }
            connection.close();
        }
    }

    private class ArrayAppendDoubleFunction
    extends ArrayAppendScalarFunction {
        private ArrayAppendDoubleFunction() {
        }

        public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
            return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.DOUBLE), -1L);
        }

        @Override
        public List<RelProtoDataType> getParams() {
            return ImmutableList.of(typeFactory -> typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.DOUBLE), -1L), typeFactory -> typeFactory.createSqlType(SqlTypeName.INTEGER));
        }
    }

    private class ArrayAppendIntegerFunction
    extends ArrayAppendScalarFunction {
        private ArrayAppendIntegerFunction() {
        }

        public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
            return typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.INTEGER), -1L);
        }

        @Override
        public List<RelProtoDataType> getParams() {
            return ImmutableList.of(typeFactory -> typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.INTEGER), -1L), typeFactory -> typeFactory.createSqlType(SqlTypeName.INTEGER));
        }
    }

    private static abstract class ArrayAppendScalarFunction
    implements ScalarFunction,
    ImplementableFunction {
        private ArrayAppendScalarFunction() {
        }

        public List<FunctionParameter> getParameters() {
            ArrayList<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
            for (final Ord type : Ord.zip(this.getParams())) {
                parameters.add(new FunctionParameter(){

                    public int getOrdinal() {
                        return type.i;
                    }

                    public String getName() {
                        return "arg" + type.i;
                    }

                    public RelDataType getType(RelDataTypeFactory typeFactory) {
                        return (RelDataType)((RelProtoDataType)type.e).apply((Object)typeFactory);
                    }

                    public boolean isOptional() {
                        return false;
                    }
                });
            }
            return parameters;
        }

        protected abstract List<RelProtoDataType> getParams();

        public CallImplementor getImplementor() {
            return (translator, call, nullAs) -> {
                Method lookupMethod = Types.lookupMethod(Smalls.AllTypesFunction.class, (String)"arrayAppendFun", (Class[])new Class[]{List.class, Integer.class});
                return Expressions.call((Method)lookupMethod, (Iterable)translator.translateList(call.getOperands(), nullAs));
            };
        }
    }
}

