/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRels;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterToCalcRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectToWindowRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Litmus;
import org.junit.Assert;
import org.junit.Test;

public class MutableRelTest {
    @Test
    public void testConvertAggregate() {
        MutableRelTest.checkConvertMutableRel("Aggregate", "select empno, sum(sal) from emp group by empno");
    }

    @Test
    public void testConvertFilter() {
        MutableRelTest.checkConvertMutableRel("Filter", "select * from emp where ename = 'DUMMY'");
    }

    @Test
    public void testConvertProject() {
        MutableRelTest.checkConvertMutableRel("Project", "select ename from emp");
    }

    @Test
    public void testConvertSort() {
        MutableRelTest.checkConvertMutableRel("Sort", "select * from emp order by ename");
    }

    @Test
    public void testConvertCalc() {
        MutableRelTest.checkConvertMutableRel("Calc", "select * from emp where ename = 'DUMMY'", false, (List<RelOptRule>)ImmutableList.of((Object)FilterToCalcRule.INSTANCE));
    }

    @Test
    public void testConvertWindow() {
        MutableRelTest.checkConvertMutableRel("Window", "select sal, avg(sal) over (partition by deptno) from emp", false, (List<RelOptRule>)ImmutableList.of((Object)ProjectToWindowRule.PROJECT));
    }

    @Test
    public void testConvertCollect() {
        MutableRelTest.checkConvertMutableRel("Collect", "select multiset(select deptno from dept) from (values(true))");
    }

    @Test
    public void testConvertUncollect() {
        MutableRelTest.checkConvertMutableRel("Uncollect", "select * from unnest(multiset[1,2])");
    }

    @Test
    public void testConvertTableModify() {
        MutableRelTest.checkConvertMutableRel("TableModify", "insert into dept select empno, ename from emp");
    }

    @Test
    public void testConvertSample() {
        MutableRelTest.checkConvertMutableRel("Sample", "select * from emp tablesample system(50) where empno > 5");
    }

    @Test
    public void testConvertTableFunctionScan() {
        MutableRelTest.checkConvertMutableRel("TableFunctionScan", "select * from table(ramp(3))");
    }

    @Test
    public void testConvertValues() {
        MutableRelTest.checkConvertMutableRel("Values", "select * from (values (1, 2))");
    }

    @Test
    public void testConvertJoin() {
        MutableRelTest.checkConvertMutableRel("Join", "select * from emp join dept using (deptno)");
    }

    @Test
    public void testConvertSemiJoin() {
        String sql = "select * from dept where exists (\n  select * from emp\n  where emp.deptno = dept.deptno\n  and emp.sal > 100)";
        MutableRelTest.checkConvertMutableRel("SemiJoin", "select * from dept where exists (\n  select * from emp\n  where emp.deptno = dept.deptno\n  and emp.sal > 100)", true, (List<RelOptRule>)ImmutableList.of((Object)FilterProjectTransposeRule.INSTANCE, (Object)FilterJoinRule.FILTER_ON_JOIN, (Object)ProjectMergeRule.INSTANCE, (Object)SemiJoinRule.PROJECT));
    }

    @Test
    public void testConvertCorrelate() {
        String sql = "select * from dept where exists (\n  select * from emp\n  where emp.deptno = dept.deptno\n  and emp.sal > 100)";
        MutableRelTest.checkConvertMutableRel("Correlate", "select * from dept where exists (\n  select * from emp\n  where emp.deptno = dept.deptno\n  and emp.sal > 100)");
    }

    @Test
    public void testConvertUnion() {
        MutableRelTest.checkConvertMutableRel("Union", "select * from emp where deptno = 10union select * from emp where ename like 'John%'");
    }

    @Test
    public void testConvertMinus() {
        MutableRelTest.checkConvertMutableRel("Minus", "select * from emp where deptno = 10except select * from emp where ename like 'John%'");
    }

    @Test
    public void testConvertIntersect() {
        MutableRelTest.checkConvertMutableRel("Intersect", "select * from emp where deptno = 10intersect select * from emp where ename like 'John%'");
    }

    private static void checkConvertMutableRel(String rel, String sql) {
        MutableRelTest.checkConvertMutableRel(rel, sql, false, null);
    }

    private static void checkConvertMutableRel(String rel, String sql, boolean decorrelate, List<RelOptRule> rules) {
        SqlToRelTestBase test = new SqlToRelTestBase(){};
        RelNode origRel = test.createTester().convertSqlToRel((String)sql).rel;
        if (decorrelate) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(origRel.getCluster(), null);
            origRel = RelDecorrelator.decorrelateQuery((RelNode)origRel, (RelBuilder)relBuilder);
        }
        if (rules != null) {
            HepProgram hepProgram = new HepProgramBuilder().addRuleCollection(rules).build();
            HepPlanner hepPlanner = new HepPlanner(hepProgram);
            hepPlanner.setRoot(origRel);
            origRel = hepPlanner.findBestExp();
        }
        MutableRel mutableRel = MutableRels.toMutable((RelNode)origRel);
        RelNode newRel = MutableRels.fromMutable((MutableRel)mutableRel);
        String mutableRelStr = mutableRel.deep();
        String msg1 = "Mutable rel: " + mutableRelStr + " does not contain target rel: " + rel;
        Assert.assertTrue((String)msg1, (boolean)mutableRelStr.contains(rel));
        RelDataType origRelType = origRel.getRowType();
        RelDataType mutableRelType = mutableRel.rowType;
        String msg2 = "Mutable rel's row type does not match with the original rel.\nOriginal rel type: " + origRelType + ";\nMutable rel type: " + mutableRelType;
        Assert.assertTrue((String)msg2, (boolean)RelOptUtil.equal((String)"origRelType", (RelDataType)origRelType, (String)"mutableRelType", (RelDataType)mutableRelType, (Litmus)Litmus.IGNORE));
        String origRelStr = RelOptUtil.toString((RelNode)origRel);
        String newRelStr = RelOptUtil.toString((RelNode)newRel);
        String msg3 = "The converted new rel is different from the original rel.\nOriginal rel: " + origRelStr + ";\nNew rel: " + newRelStr;
        Assert.assertEquals((String)msg3, (Object)origRelStr, (Object)newRelStr);
    }
}

