/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.base.Throwables;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.SqlOperatorTest;
import org.apache.calcite.sql.test.SqlRuntimeTester;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.SqlLimitsTest;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class SqlOperatorBaseTest {
    public static final String INVALID_CHAR_MESSAGE = "(?s).*";
    public static final String OUT_OF_RANGE_MESSAGE = "(?s).*";
    public static final String DIVISION_BY_ZERO_MESSAGE = "(?s).*";
    public static final String STRING_TRUNC_MESSAGE = "(?s).*";
    public static final String BAD_DATETIME_MESSAGE = "(?s).*";
    public static final String INVALID_EXTRACT_UNIT_CONVERTLET_ERROR = "Extract.*from.*type data is not supported";
    public static final String INVALID_EXTRACT_UNIT_VALIDATION_ERROR = "Cannot apply 'EXTRACT' to arguments of type .*'\n.*";
    public static final String LITERAL_OUT_OF_RANGE_MESSAGE = "(?s).*Numeric literal.*out of range.*";
    public static final boolean TODO = false;
    public static final Pattern TIME_PATTERN = Pattern.compile("[0-9][0-9]:[0-9][0-9]:[0-9][0-9]");
    public static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]");
    public static final Pattern DATE_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]");
    public static final String[] NUMERIC_TYPE_NAMES = new String[]{"TINYINT", "SMALLINT", "INTEGER", "BIGINT", "DECIMAL(5, 2)", "REAL", "FLOAT", "DOUBLE"};
    public static final String[] MIN_NUMERIC_STRINGS = new String[]{Long.toString(-128L), Long.toString(-32768L), Long.toString(Integer.MIN_VALUE), Long.toString(Long.MIN_VALUE), "-999.99", "1E-37", "2E-307", "2E-307"};
    public static final String[] MIN_OVERFLOW_NUMERIC_STRINGS = new String[]{Long.toString(-129L), Long.toString(-32769L), Long.toString(-2147483649L), new BigDecimal(Long.MIN_VALUE).subtract(BigDecimal.ONE).toString(), "-1000.00", "1e-46", "1e-324", "1e-324"};
    public static final String[] MAX_NUMERIC_STRINGS = new String[]{Long.toString(127L), Long.toString(32767L), Long.toString(Integer.MAX_VALUE), Long.toString(Long.MAX_VALUE), "999.99", "3.4028234E38", "1.79769313486231E308", "1.79769313486231E308"};
    public static final String[] MAX_OVERFLOW_NUMERIC_STRINGS = new String[]{Long.toString(128L), Long.toString(32768L), Long.toString(0x80000000L), new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE).toString(), "1000.00", "1e39", "-1e309", "1e309"};
    private static final boolean[] FALSE_TRUE = new boolean[]{false, true};
    private static final SqlTester.VmName VM_FENNEL = SqlTester.VmName.FENNEL;
    private static final SqlTester.VmName VM_JAVA = SqlTester.VmName.JAVA;
    private static final SqlTester.VmName VM_EXPAND = SqlTester.VmName.EXPAND;
    protected static final TimeZone UTC_TZ = TimeZone.getTimeZone("GMT");
    protected static final TimeZone LOCAL_TZ;
    protected static final TimeZone CURRENT_TZ;
    private static final Pattern INVALID_ARG_FOR_POWER;
    private static final Pattern CODE_2201F;
    public static final boolean DECIMAL = false;
    private final boolean enable;
    protected final SqlTester tester;

    protected SqlOperatorBaseTest(boolean enable, SqlTester tester) {
        this.enable = enable;
        this.tester = tester;
        assert (tester != null);
    }

    @Before
    public void setUp() throws Exception {
        this.tester.setFor(null, new SqlTester.VmName[0]);
    }

    protected SqlTester oracleTester() {
        return this.tester.withOperatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{OracleSqlOperatorTable.instance(), SqlStdOperatorTable.instance()})).withConnectionFactory(CalciteAssert.EMPTY_CONNECTION_FACTORY.with(new CalciteAssert.AddSchemaSpecPostProcessor(CalciteAssert.SchemaSpec.HR)).with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"oracle"));
    }

    protected SqlTester oracleTester(SqlConformance conformance) {
        if (conformance == null) {
            conformance = SqlConformanceEnum.DEFAULT;
        }
        return this.tester.withConformance(conformance).withOperatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{OracleSqlOperatorTable.instance(), SqlStdOperatorTable.instance()})).withConnectionFactory(CalciteAssert.EMPTY_CONNECTION_FACTORY.with(new CalciteAssert.AddSchemaSpecPostProcessor(CalciteAssert.SchemaSpec.HR)).with("fun", (Object)"oracle").with("conformance", (Object)conformance));
    }

    @Test
    public void testDummy() {
    }

    @Test
    public void testSqlOperatorOverloading() {
        SqlStdOperatorTable operatorTable = SqlStdOperatorTable.instance();
        for (SqlOperator sqlOperator : operatorTable.getOperatorList()) {
            String operatorName = sqlOperator.getName();
            ArrayList routines = new ArrayList();
            operatorTable.lookupOperatorOverloads(new SqlIdentifier(operatorName, SqlParserPos.ZERO), null, sqlOperator.getSyntax(), routines);
            Iterator iter = routines.iterator();
            while (iter.hasNext()) {
                SqlOperator operator = (SqlOperator)iter.next();
                if (sqlOperator.getClass().isInstance(operator)) continue;
                iter.remove();
            }
            Assert.assertThat((Object)routines.size(), (Matcher)CoreMatchers.equalTo((Object)1));
            Assert.assertThat((Object)sqlOperator, (Matcher)CoreMatchers.equalTo(routines.get(0)));
        }
    }

    @Test
    public void testBetween() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.BETWEEN, SqlTester.VmName.EXPAND);
        this.tester.checkBoolean("2 between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("2 between 3 and 2", Boolean.FALSE);
        this.tester.checkBoolean("2 between symmetric 3 and 2", Boolean.TRUE);
        this.tester.checkBoolean("3 between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("4 between 1 and 3", Boolean.FALSE);
        this.tester.checkBoolean("1 between 4 and -3", Boolean.FALSE);
        this.tester.checkBoolean("1 between -1 and -3", Boolean.FALSE);
        this.tester.checkBoolean("1 between -1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1 between 1 and 1", Boolean.TRUE);
        this.tester.checkBoolean("1.5 between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1.2 between 1.1 and 1.3", Boolean.TRUE);
        this.tester.checkBoolean("1.5 between 2 and 3", Boolean.FALSE);
        this.tester.checkBoolean("1.5 between 1.6 and 1.7", Boolean.FALSE);
        this.tester.checkBoolean("1.2e1 between 1.1 and 1.3", Boolean.FALSE);
        this.tester.checkBoolean("1.2e0 between 1.1 and 1.3", Boolean.TRUE);
        this.tester.checkBoolean("1.5e0 between 2 and 3", Boolean.FALSE);
        this.tester.checkBoolean("1.5e0 between 2e0 and 3e0", Boolean.FALSE);
        this.tester.checkBoolean("1.5e1 between 1.6e1 and 1.7e1", Boolean.FALSE);
        this.tester.checkBoolean("x'' between x'' and x''", Boolean.TRUE);
        this.tester.checkNull("cast(null as integer) between -1 and 2");
        this.tester.checkNull("1 between -1 and cast(null as integer)");
        this.tester.checkNull("1 between cast(null as integer) and cast(null as integer)");
        this.tester.checkNull("1 between cast(null as integer) and 1");
        this.tester.checkBoolean("x'0A00015A' between x'0A000130' and x'0A0001B0'", Boolean.TRUE);
        this.tester.checkBoolean("x'0A00015A' between x'0A0001A0' and x'0A0001B0'", Boolean.FALSE);
    }

    @Test
    public void testNotBetween() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_BETWEEN, VM_EXPAND);
        this.tester.checkBoolean("2 not between 1 and 3", Boolean.FALSE);
        this.tester.checkBoolean("3 not between 1 and 3", Boolean.FALSE);
        this.tester.checkBoolean("4 not between 1 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1.2e0 not between 1.1 and 1.3", Boolean.FALSE);
        this.tester.checkBoolean("1.2e1 not between 1.1 and 1.3", Boolean.TRUE);
        this.tester.checkBoolean("1.5e0 not between 2 and 3", Boolean.TRUE);
        this.tester.checkBoolean("1.5e0 not between 2e0 and 3e0", Boolean.TRUE);
        this.tester.checkBoolean("x'0A00015A' not between x'0A000130' and x'0A0001B0'", Boolean.FALSE);
        this.tester.checkBoolean("x'0A00015A' not between x'0A0001A0' and x'0A0001B0'", Boolean.TRUE);
    }

    private String getCastString(String value, String targetType, boolean errorLoc) {
        if (errorLoc) {
            value = "^" + value + "^";
        }
        return "cast(" + value + " as " + targetType + ")";
    }

    private void checkCastToApproxOkay(String value, String targetType, double expected, double delta) {
        this.tester.checkScalarApprox(this.getCastString(value, targetType, false), targetType + " NOT NULL", expected, delta);
    }

    private void checkCastToStringOkay(String value, String targetType, String expected) {
        this.tester.checkString(this.getCastString(value, targetType, false), expected, targetType + " NOT NULL");
    }

    private void checkCastToScalarOkay(String value, String targetType, String expected) {
        this.tester.checkScalarExact(this.getCastString(value, targetType, false), targetType + " NOT NULL", expected);
    }

    private void checkCastToScalarOkay(String value, String targetType) {
        this.checkCastToScalarOkay(value, targetType, value);
    }

    private void checkCastFails(String value, String targetType, String expectedError, boolean runtime) {
        this.tester.checkFails(this.getCastString(value, targetType, !runtime), expectedError, runtime);
    }

    private void checkCastToString(String value, String type, String expected) {
        String spaces = "     ";
        if (expected == null) {
            expected = value.trim();
        }
        int len = expected.length();
        if (type != null) {
            value = this.getCastString(value, type, false);
        }
        this.checkCastToStringOkay(value, "VARCHAR(" + len + ")", expected);
        this.checkCastToStringOkay(value, "VARCHAR(" + (len + 5) + ")", expected);
        this.checkCastToStringOkay(value, "CHAR(" + len + ")", expected);
        this.checkCastToStringOkay(value, "CHAR(" + (len + 5) + ")", expected + spaces);
    }

    @Test
    public void testCastToString() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToString("cast(cast('abc' as char(4)) as varchar(6))", null, "abc ");
        this.checkCastToString("123", "CHAR(3)", "123");
        this.checkCastToString("0", "CHAR", "0");
        this.checkCastToString("-123", "CHAR(4)", "-123");
        this.checkCastToString("123.4", "CHAR(5)", "123.4");
        this.checkCastToString("-0.0", "CHAR(2)", ".0");
        this.checkCastToString("-123.4", "CHAR(6)", "-123.4");
        this.tester.checkString("cast(1.29 as varchar(10))", "1.29", "VARCHAR(10) NOT NULL");
        this.tester.checkString("cast(.48 as varchar(10))", ".48", "VARCHAR(10) NOT NULL");
        this.tester.checkString("cast(-0.29 as varchar(10))", "-.29", "VARCHAR(10) NOT NULL");
        this.tester.checkString("cast(-1.29 as varchar(10))", "-1.29", "VARCHAR(10) NOT NULL");
        this.checkCastToString("1.23E45", "CHAR(7)", "1.23E45");
        this.checkCastToString("CAST(0 AS DOUBLE)", "CHAR(3)", "0E0");
        this.checkCastToString("-1.20e-07", "CHAR(7)", "-1.2E-7");
        this.checkCastToString("cast(0e0 as varchar(5))", "CHAR(3)", "0E0");
        this.checkCastToString("'abc'", "CHAR(1)", "a");
        this.checkCastToString("'abc'", "CHAR(3)", "abc");
        this.checkCastToString("cast('abc' as varchar(6))", "CHAR(3)", "abc");
        this.checkCastToString("cast(' abc  ' as varchar(10))", null, " abc  ");
        this.checkCastToString("cast(cast('abc' as char(4)) as varchar(6))", null, "abc ");
        this.tester.checkString("cast(cast('a' as char(2)) as varchar(3)) || 'x' ", "a x", "VARCHAR(4) NOT NULL");
        this.tester.checkString("cast(cast('a' as char(3)) as varchar(5)) || 'x' ", "a  x", "VARCHAR(6) NOT NULL");
        this.tester.checkString("cast('a' as char(3)) || 'x'", "a  x", "CHAR(4) NOT NULL");
        this.tester.checkScalar("char_length(cast(' x ' as char(4)))", 4, "INTEGER NOT NULL");
        this.tester.checkScalar("char_length(cast(' x ' as varchar(3)))", 3, "INTEGER NOT NULL");
        this.tester.checkScalar("char_length(cast(' x ' as varchar(4)))", 3, "INTEGER NOT NULL");
        this.tester.checkScalar("char_length(cast(cast(' x ' as char(4)) as varchar(5)))", 4, "INTEGER NOT NULL");
        this.tester.checkScalar("char_length(cast(' x ' as varchar(3)))", 3, "INTEGER NOT NULL");
        this.checkCastToString("date '2008-01-01'", "CHAR(10)", "2008-01-01");
        this.checkCastToString("time '1:2:3'", "CHAR(8)", "01:02:03");
        this.checkCastToString("timestamp '2008-1-1 1:2:3'", "CHAR(19)", "2008-01-01 01:02:03");
        this.checkCastToString("timestamp '2008-1-1 1:2:3'", "VARCHAR(30)", "2008-01-01 01:02:03");
        this.checkCastToString("interval '3-2' year to month", "CHAR(5)", "+3-02");
        this.checkCastToString("interval '32' month", "CHAR(3)", "+32");
        this.checkCastToString("interval '1 2:3:4' day to second", "CHAR(11)", "+1 02:03:04");
        this.checkCastToString("interval '1234.56' second(4,2)", "CHAR(8)", "+1234.56");
        this.checkCastToString("interval '60' day", "CHAR(8)", "+60     ");
        this.checkCastToString("True", "CHAR(4)", "TRUE");
        this.checkCastToString("True", "CHAR(6)", "TRUE  ");
        this.checkCastToString("True", "VARCHAR(6)", "TRUE");
        this.checkCastToString("False", "CHAR(5)", "FALSE");
    }

    @Test
    public void testCastExactNumericLimits() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        for (int i = 0; i < NUMERIC_TYPE_NAMES.length; ++i) {
            String type = NUMERIC_TYPE_NAMES[i];
            if (type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("FLOAT") || type.equalsIgnoreCase("REAL")) continue;
            this.checkCastToScalarOkay(MAX_NUMERIC_STRINGS[i], type);
            this.checkCastToScalarOkay(MIN_NUMERIC_STRINGS[i], type);
            if (type.equalsIgnoreCase("BIGINT")) {
                this.checkCastFails(MAX_OVERFLOW_NUMERIC_STRINGS[i], type, LITERAL_OUT_OF_RANGE_MESSAGE, false);
                this.checkCastFails(MIN_OVERFLOW_NUMERIC_STRINGS[i], type, LITERAL_OUT_OF_RANGE_MESSAGE, false);
            }
            this.checkCastToScalarOkay("'" + MAX_NUMERIC_STRINGS[i] + "'", type, MAX_NUMERIC_STRINGS[i]);
            this.checkCastToScalarOkay("'" + MIN_NUMERIC_STRINGS[i] + "'", type, MIN_NUMERIC_STRINGS[i]);
            this.checkCastToString(MAX_NUMERIC_STRINGS[i], null, null);
            this.checkCastToString(MAX_NUMERIC_STRINGS[i], type, null);
            this.checkCastToString(MIN_NUMERIC_STRINGS[i], null, null);
            this.checkCastToString(MIN_NUMERIC_STRINGS[i], type, null);
        }
    }

    @Test
    public void testCastToExactNumeric() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToScalarOkay("1", "BIGINT");
        this.checkCastToScalarOkay("1", "INTEGER");
        this.checkCastToScalarOkay("1", "SMALLINT");
        this.checkCastToScalarOkay("1", "TINYINT");
        this.checkCastToScalarOkay("1", "DECIMAL(4, 0)");
        this.checkCastToScalarOkay("-1", "BIGINT");
        this.checkCastToScalarOkay("-1", "INTEGER");
        this.checkCastToScalarOkay("-1", "SMALLINT");
        this.checkCastToScalarOkay("-1", "TINYINT");
        this.checkCastToScalarOkay("-1", "DECIMAL(4, 0)");
        this.checkCastToScalarOkay("1.234E3", "INTEGER", "1234");
        this.checkCastToScalarOkay("-9.99E2", "INTEGER", "-999");
        this.checkCastToScalarOkay("'1'", "INTEGER", "1");
        this.checkCastToScalarOkay("' 01 '", "INTEGER", "1");
        this.checkCastToScalarOkay("'-1'", "INTEGER", "-1");
        this.checkCastToScalarOkay("' -00 '", "INTEGER", "0");
        this.tester.checkScalarExact("cast('6543' as integer)", "6543");
        this.tester.checkScalarExact("cast(' -123 ' as int)", "-123");
        this.tester.checkScalarExact("cast('654342432412312' as bigint)", "BIGINT NOT NULL", "654342432412312");
    }

    @Test
    public void testCastStringToDecimal() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
    }

    @Test
    public void testCastIntervalToNumeric() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("cast(INTERVAL '1.25' second as bigint)", "BIGINT NOT NULL", "1");
        this.tester.checkScalarExact("cast(INTERVAL '-1.29' second(1,2) as bigint)", "BIGINT NOT NULL", "-1");
        this.tester.checkScalarExact("cast(INTERVAL '5' day as bigint)", "BIGINT NOT NULL", "5");
        this.tester.checkScalarExact("cast(INTERVAL '1.25' second as integer)", "INTEGER NOT NULL", "1");
        this.tester.checkScalarExact("cast(INTERVAL '-1.29' second(1,2) as integer)", "INTEGER NOT NULL", "-1");
        this.tester.checkScalarExact("cast(INTERVAL '5' day as integer)", "INTEGER NOT NULL", "5");
        this.tester.checkScalarExact("cast(INTERVAL '1' year as integer)", "INTEGER NOT NULL", "1");
        this.tester.checkScalarExact("cast((INTERVAL '1' year - INTERVAL '2' year) as integer)", "INTEGER NOT NULL", "-1");
        this.tester.checkScalarExact("cast(INTERVAL '1' month as integer)", "INTEGER NOT NULL", "1");
        this.tester.checkScalarExact("cast((INTERVAL '1' month - INTERVAL '2' month) as integer)", "INTEGER NOT NULL", "-1");
        this.tester.checkScalarExact("cast(INTERVAL '1' day as integer)", "INTEGER NOT NULL", "1");
        this.tester.checkScalarExact("cast((INTERVAL '1' day - INTERVAL '2' day) as integer)", "INTEGER NOT NULL", "-1");
        this.tester.checkScalarExact("cast(INTERVAL '1' hour as integer)", "INTEGER NOT NULL", "1");
        this.tester.checkScalarExact("cast((INTERVAL '1' hour - INTERVAL '2' hour) as integer)", "INTEGER NOT NULL", "-1");
        this.tester.checkScalarExact("cast(INTERVAL '1' hour as integer)", "INTEGER NOT NULL", "1");
        this.tester.checkScalarExact("cast((INTERVAL '1' minute - INTERVAL '2' minute) as integer)", "INTEGER NOT NULL", "-1");
        this.tester.checkScalarExact("cast(INTERVAL '1' minute as integer)", "INTEGER NOT NULL", "1");
        this.tester.checkScalarExact("cast((INTERVAL '1' second - INTERVAL '2' second) as integer)", "INTEGER NOT NULL", "-1");
    }

    @Test
    public void testCastToInterval() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalar("cast(5 as interval second)", "+5.000000", "INTERVAL SECOND NOT NULL");
        this.tester.checkScalar("cast(5 as interval minute)", "+5", "INTERVAL MINUTE NOT NULL");
        this.tester.checkScalar("cast(5 as interval hour)", "+5", "INTERVAL HOUR NOT NULL");
        this.tester.checkScalar("cast(5 as interval day)", "+5", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("cast(5 as interval month)", "+5", "INTERVAL MONTH NOT NULL");
        this.tester.checkScalar("cast(5 as interval year)", "+5", "INTERVAL YEAR NOT NULL");
        this.tester.checkScalar("cast(6.2 as interval day)", "+6", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("cast(3456 as interval month(4))", "+3456", "INTERVAL MONTH(4) NOT NULL");
        this.tester.checkScalar("cast(-5723 as interval minute(4))", "-5723", "INTERVAL MINUTE(4) NOT NULL");
    }

    @Test
    public void testCastIntervalToInterval() {
        this.tester.checkScalar("cast(interval '2 5' day to hour as interval hour to minute)", "+53:00", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.tester.checkScalar("cast(interval '2 5' day to hour as interval day to minute)", "+2 05:00", "INTERVAL DAY TO MINUTE NOT NULL");
        this.tester.checkScalar("cast(interval '2 5' day to hour as interval hour to second)", "+53:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("cast(interval '2 5' day to hour as interval hour)", "+53", "INTERVAL HOUR NOT NULL");
        this.tester.checkScalar("cast(interval '-29:15' hour to minute as interval day to hour)", "-1 05", "INTERVAL DAY TO HOUR NOT NULL");
    }

    @Test
    public void testCastWithRoundingToScalar() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToScalarOkay("1.25", "INTEGER", "1");
        this.checkCastToScalarOkay("1.25E0", "INTEGER", "1");
        if (!this.enable) {
            return;
        }
        this.checkCastToScalarOkay("1.5", "INTEGER", "2");
        this.checkCastToScalarOkay("5E-1", "INTEGER", "1");
        this.checkCastToScalarOkay("1.75", "INTEGER", "2");
        this.checkCastToScalarOkay("1.75E0", "INTEGER", "2");
        this.checkCastToScalarOkay("-1.25", "INTEGER", "-1");
        this.checkCastToScalarOkay("-1.25E0", "INTEGER", "-1");
        this.checkCastToScalarOkay("-1.5", "INTEGER", "-2");
        this.checkCastToScalarOkay("-5E-1", "INTEGER", "-1");
        this.checkCastToScalarOkay("-1.75", "INTEGER", "-2");
        this.checkCastToScalarOkay("-1.75E0", "INTEGER", "-2");
        this.checkCastToScalarOkay("1.23454", "DECIMAL(8, 4)", "1.2345");
        this.checkCastToScalarOkay("1.23454E0", "DECIMAL(8, 4)", "1.2345");
        this.checkCastToScalarOkay("1.23455", "DECIMAL(8, 4)", "1.2346");
        this.checkCastToScalarOkay("5E-5", "DECIMAL(8, 4)", "0.0001");
        this.checkCastToScalarOkay("1.99995", "DECIMAL(8, 4)", "2.0000");
        this.checkCastToScalarOkay("1.99995E0", "DECIMAL(8, 4)", "2.0000");
        this.checkCastToScalarOkay("-1.23454", "DECIMAL(8, 4)", "-1.2345");
        this.checkCastToScalarOkay("-1.23454E0", "DECIMAL(8, 4)", "-1.2345");
        this.checkCastToScalarOkay("-1.23455", "DECIMAL(8, 4)", "-1.2346");
        this.checkCastToScalarOkay("-5E-5", "DECIMAL(8, 4)", "-0.0001");
        this.checkCastToScalarOkay("-1.99995", "DECIMAL(8, 4)", "-2.0000");
        this.checkCastToScalarOkay("-1.99995E0", "DECIMAL(8, 4)", "-2.0000");
        this.tester.checkFails("cast(9.99 as decimal(2,1))", OUT_OF_RANGE_MESSAGE, true);
    }

    @Test
    public void testCastDecimalToDoubleToInteger() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("cast( cast(1.25 as double) as integer)", "1");
        this.tester.checkScalarExact("cast( cast(-1.25 as double) as integer)", "-1");
        if (!this.enable) {
            return;
        }
        this.tester.checkScalarExact("cast( cast(1.75 as double) as integer)", "2");
        this.tester.checkScalarExact("cast( cast(-1.75 as double) as integer)", "-2");
        this.tester.checkScalarExact("cast( cast(1.5 as double) as integer)", "2");
        this.tester.checkScalarExact("cast( cast(-1.5 as double) as integer)", "-2");
    }

    @Test
    public void testCastApproxNumericLimits() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        for (int i = 0; i < NUMERIC_TYPE_NAMES.length; ++i) {
            boolean isFloat;
            String type = NUMERIC_TYPE_NAMES[i];
            if (type.equalsIgnoreCase("DOUBLE") || type.equalsIgnoreCase("FLOAT")) {
                isFloat = false;
            } else {
                if (!type.equalsIgnoreCase("REAL")) continue;
                isFloat = true;
            }
            if (!this.enable) {
                return;
            }
            this.checkCastToApproxOkay(MAX_NUMERIC_STRINGS[i], type, Double.parseDouble(MAX_NUMERIC_STRINGS[i]), isFloat ? 1.0E32 : 0.0);
            this.checkCastToApproxOkay(MIN_NUMERIC_STRINGS[i], type, Double.parseDouble(MIN_NUMERIC_STRINGS[i]), 0.0);
            if (isFloat) {
                this.checkCastFails(MAX_OVERFLOW_NUMERIC_STRINGS[i], type, OUT_OF_RANGE_MESSAGE, true);
            } else {
                this.checkCastFails(MAX_OVERFLOW_NUMERIC_STRINGS[i], type, LITERAL_OUT_OF_RANGE_MESSAGE, false);
            }
            this.checkCastToApproxOkay(MIN_OVERFLOW_NUMERIC_STRINGS[i], type, 0.0, 0.0);
            this.checkCastToApproxOkay("'" + MAX_NUMERIC_STRINGS[i] + "'", type, Double.parseDouble(MAX_NUMERIC_STRINGS[i]), isFloat ? 1.0E32 : 0.0);
            this.checkCastToApproxOkay("'" + MIN_NUMERIC_STRINGS[i] + "'", type, Double.parseDouble(MIN_NUMERIC_STRINGS[i]), 0.0);
            this.checkCastFails("'" + MAX_OVERFLOW_NUMERIC_STRINGS[i] + "'", type, OUT_OF_RANGE_MESSAGE, true);
            this.checkCastToApproxOkay("'" + MIN_OVERFLOW_NUMERIC_STRINGS[i] + "'", type, 0.0, 0.0);
            this.checkCastToString(MAX_NUMERIC_STRINGS[i], null, isFloat ? null : "1.79769313486231E308");
            this.checkCastFails("'notnumeric'", type, INVALID_CHAR_MESSAGE, true);
        }
    }

    @Test
    public void testCastToApproxNumeric() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.checkCastToApproxOkay("1", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("1.0", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("-2.3", "FLOAT", -2.3, 1.0E-6);
        this.checkCastToApproxOkay("'1'", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("'  -1e-37  '", "DOUBLE", -1.0E-37, 0.0);
        this.checkCastToApproxOkay("1e0", "DOUBLE", 1.0, 0.0);
        this.checkCastToApproxOkay("0e0", "REAL", 0.0, 0.0);
    }

    @Test
    public void testCastNull() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkNull("cast(null as integer)");
        this.tester.checkNull("cast(null as double)");
        this.tester.checkNull("cast(null as varchar(10))");
        this.tester.checkNull("cast(null as char(10))");
        this.tester.checkNull("cast(null as date)");
        this.tester.checkNull("cast(null as time)");
        this.tester.checkNull("cast(null as timestamp)");
        this.tester.checkNull("cast(null as interval year to month)");
        this.tester.checkNull("cast(null as interval day to second(3))");
        this.tester.checkNull("cast(null as boolean)");
    }

    @Test
    public void testCastInvalid() {
        this.tester.checkScalarExact("cast('15' as integer)", "INTEGER NOT NULL", "15");
    }

    @Test
    public void testCastDateTime() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast(TIME '12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        if (this.enable) {
            this.tester.checkScalar("cast(TIME '12:42:25.9' as TIME)", "12:42:26", "TIME(0) NOT NULL");
        }
        this.tester.checkScalar("cast(DATE '1945-02-24' as DATE)", "1945-02-24", "DATE NOT NULL");
        this.tester.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        this.checkCastToString("TIME '12:42:25'", null, "12:42:25");
        String today = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT).format(SqlOperatorBaseTest.getCalendarNotTooNear(5).getTime());
        this.tester.checkScalar("cast(DATE '1945-02-24' as TIMESTAMP)", "1945-02-24 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast(cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIME) as TIMESTAMP)", today + " 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast(TIME '12:42:25.34' as TIMESTAMP)", today + " 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as DATE)", "1945-02-24", "DATE NOT NULL");
        this.tester.checkScalar("cast(cast(TIMESTAMP '1945-02-24 12:42:25.34' as DATE) as TIMESTAMP)", "1945-02-24 00:00:00", "TIMESTAMP(0) NOT NULL");
    }

    @Test
    public void testCastStringToDateTime() {
        this.tester.checkScalar("cast('12:42:25' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('1:42:25' as TIME)", "01:42:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('1:2:25' as TIME)", "01:02:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('  12:42:25  ' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        this.tester.checkScalar("cast('12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        this.tester.checkFails("cast('nottime' as TIME)", BAD_DATETIME_MESSAGE, true);
        this.checkCastToString("TIMESTAMP '1945-02-24 12:42:25'", null, "1945-02-24 12:42:25");
        this.tester.checkScalar("cast('1945-02-24 12:42:25' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('1945-2-2 12:2:5' as TIMESTAMP)", "1945-02-02 12:02:05", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('  1945-02-24 12:42:25  ' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('1945-02-24 12:42:25.34' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('1945-12-31' as TIMESTAMP)", "1945-12-31 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("cast('2004-02-29' as TIMESTAMP)", "2004-02-29 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkFails("cast('nottime' as TIMESTAMP)", BAD_DATETIME_MESSAGE, true);
        this.checkCastToString("DATE '1945-02-24'", null, "1945-02-24");
        this.checkCastToString("DATE '1945-2-24'", null, "1945-02-24");
        this.tester.checkScalar("cast('1945-02-24' as DATE)", "1945-02-24", "DATE NOT NULL");
        this.tester.checkScalar("cast(' 1945-2-4 ' as DATE)", "1945-02-04", "DATE NOT NULL");
        this.tester.checkScalar("cast('  1945-02-24  ' as DATE)", "1945-02-24", "DATE NOT NULL");
        this.tester.checkFails("cast('notdate' as DATE)", BAD_DATETIME_MESSAGE, true);
        this.tester.checkNull("cast(null as date)");
        this.tester.checkNull("cast(null as timestamp)");
        this.tester.checkNull("cast(null as time)");
        this.tester.checkNull("cast(cast(null as varchar(10)) as time)");
        this.tester.checkNull("cast(cast(null as varchar(10)) as date)");
        this.tester.checkNull("cast(cast(null as varchar(10)) as timestamp)");
        this.tester.checkNull("cast(cast(null as date) as timestamp)");
        this.tester.checkNull("cast(cast(null as time) as timestamp)");
        this.tester.checkNull("cast(cast(null as timestamp) as date)");
        this.tester.checkNull("cast(cast(null as timestamp) as time)");
    }

    /*
     * Exception decompiling
     */
    protected static Calendar getCalendarNotTooNear(int timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testCastToBoolean() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkBoolean("cast('true' as boolean)", Boolean.TRUE);
        this.tester.checkBoolean("cast('false' as boolean)", Boolean.FALSE);
        this.tester.checkBoolean("cast('  trUe' as boolean)", Boolean.TRUE);
        this.tester.checkBoolean("cast('  tr' || 'Ue' as boolean)", Boolean.TRUE);
        this.tester.checkBoolean("cast('  fALse' as boolean)", Boolean.FALSE);
        this.tester.checkFails("cast('unknown' as boolean)", INVALID_CHAR_MESSAGE, true);
        this.tester.checkBoolean("cast(cast('true' as varchar(10))  as boolean)", Boolean.TRUE);
        this.tester.checkBoolean("cast(cast('false' as varchar(10)) as boolean)", Boolean.FALSE);
        this.tester.checkFails("cast(cast('blah' as varchar(10)) as boolean)", INVALID_CHAR_MESSAGE, true);
    }

    @Test
    public void testCase() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CASE, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("case when 'a'='a' then 1 end", "1");
        this.tester.checkString("case 2 when 1 then 'a' when 2 then 'bcd' end", "bcd", "CHAR(3)");
        this.tester.checkString("case 1 when 1 then 'a' when 2 then 'bcd' end", "a  ", "CHAR(3)");
        this.tester.checkString("case 1 when 1 then cast('a' as varchar(1)) when 2 then cast('bcd' as varchar(3)) end", "a", "VARCHAR(3)");
        this.tester.checkScalarExact("case 'a' when 'a' then 1 end", "1");
        this.tester.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then cast(4 as bigint) else 3 end", "DOUBLE NOT NULL", 11.2, 0.0);
        this.tester.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then 4 else null end", "DOUBLE", 11.2, 0.0);
        this.tester.checkScalarApprox("case 2 when 1 then 11.2e0 when 2 then 4 else null end", "DOUBLE", 4.0, 0.0);
        this.tester.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then 4.543 else null end", "DOUBLE", 11.2, 0.0);
        this.tester.checkScalarApprox("case 2 when 1 then 11.2e0 when 2 then 4.543 else null end", "DOUBLE", 4.543, 0.0);
        this.tester.checkNull("case 'a' when 'b' then 1 end");
        this.tester.checkString("case cast(null as int) when cast(null as int) then 'nulls match' else 'nulls do not match' end", "nulls do not match", "CHAR(18) NOT NULL");
        this.tester.checkScalarExact("case when 'a'=cast(null as varchar(1)) then 1 else 2 end", "2");
        this.tester.checkString("case when 'a' = cast(null as varchar(1)) then null else 'a' end", "a", "CHAR(1)");
        this.tester.checkString("case 1 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2           ", "CHAR(17) NOT NULL");
        this.tester.checkString("case 2 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2           ", "CHAR(17) NOT NULL");
        this.tester.checkString("case 3 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "3                ", "CHAR(17) NOT NULL");
        this.tester.checkString("case 4 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "none of the above", "CHAR(17) NOT NULL");
        SqlTester tester2 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        tester2.checkString("case 2 when 1 then 'a' when 2 then 'bcd' end", "bcd", "VARCHAR(3)");
        tester2.checkString("case 1 when 1 then 'a' when 2 then 'bcd' end", "a", "VARCHAR(3)");
        tester2.checkString("case 1 when 1 then cast('a' as varchar(1)) when 2 then cast('bcd' as varchar(3)) end", "a", "VARCHAR(3)");
        tester2.checkString("case cast(null as int) when cast(null as int) then 'nulls match' else 'nulls do not match' end", "nulls do not match", "VARCHAR(18) NOT NULL");
        tester2.checkScalarExact("case when 'a'=cast(null as varchar(1)) then 1 else 2 end", "2");
        tester2.checkString("case when 'a' = cast(null as varchar(1)) then null else 'a' end", "a", "CHAR(1)");
        tester2.checkString("case 1 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2", "VARCHAR(17) NOT NULL");
        tester2.checkString("case 2 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2", "VARCHAR(17) NOT NULL");
        tester2.checkString("case 3 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "3", "VARCHAR(17) NOT NULL");
        tester2.checkString("case 4 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "none of the above", "VARCHAR(17) NOT NULL");
    }

    @Test
    public void testCaseNull() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CASE, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("case when 1 = 1 then 10 else null end", "10");
        this.tester.checkNull("case when 1 = 2 then 10 else null end");
    }

    @Test
    public void testCaseType() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CASE, new SqlTester.VmName[0]);
        this.tester.checkType("case 1 when 1 then current_timestamp else null end", "TIMESTAMP(0)");
        this.tester.checkType("case 1 when 1 then current_timestamp else current_timestamp end", "TIMESTAMP(0) NOT NULL");
        this.tester.checkType("case when true then current_timestamp else null end", "TIMESTAMP(0)");
        this.tester.checkType("case when true then current_timestamp end", "TIMESTAMP(0)");
        this.tester.checkType("case 'x' when 'a' then 3 when 'b' then null else 4.5 end", "DECIMAL(11, 1)");
    }

    @Test
    public void testJdbcFn() {
        this.tester.setFor((SqlOperator)new SqlJdbcFunctionCall("dummy"), new SqlTester.VmName[0]);
        this.tester.checkScalar("{fn ABS(-3)}", 3, "INTEGER NOT NULL");
        this.tester.checkScalarApprox("{fn ACOS(0.2)}", "DOUBLE NOT NULL", 1.36943, 0.001);
        this.tester.checkScalarApprox("{fn ASIN(0.2)}", "DOUBLE NOT NULL", 0.20135, 0.001);
        this.tester.checkScalarApprox("{fn ATAN(0.2)}", "DOUBLE NOT NULL", 0.19739, 0.001);
        this.tester.checkScalarApprox("{fn ATAN2(-2, 2)}", "DOUBLE NOT NULL", -0.78539, 0.001);
        this.tester.checkScalar("{fn CEILING(-2.6)}", -2, "DECIMAL(2, 0) NOT NULL");
        this.tester.checkScalarApprox("{fn COS(0.2)}", "DOUBLE NOT NULL", 0.98007, 0.001);
        this.tester.checkScalarApprox("{fn COT(0.2)}", "DOUBLE NOT NULL", 4.93315, 0.001);
        this.tester.checkScalarApprox("{fn DEGREES(-1)}", "DOUBLE NOT NULL", -57.29578, 0.001);
        this.tester.checkScalarApprox("{fn EXP(2)}", "DOUBLE NOT NULL", 7.389, 0.001);
        this.tester.checkScalar("{fn FLOOR(2.6)}", 2, "DECIMAL(2, 0) NOT NULL");
        this.tester.checkScalarApprox("{fn LOG(10)}", "DOUBLE NOT NULL", 2.30258, 0.001);
        this.tester.checkScalarApprox("{fn LOG10(100)}", "DOUBLE NOT NULL", 2.0, 0.0);
        this.tester.checkScalar("{fn MOD(19, 4)}", 3, "INTEGER NOT NULL");
        this.tester.checkScalarApprox("{fn PI()}", "DOUBLE NOT NULL", 3.14159, 1.0E-4);
        this.tester.checkScalarApprox("{fn POWER(2, 3)}", "DOUBLE NOT NULL", 8.0, 0.001);
        this.tester.checkScalarApprox("{fn RADIANS(90)}", "DOUBLE NOT NULL", 1.5708, 0.001);
        this.tester.checkScalarApprox("{fn RAND(42)}", "DOUBLE NOT NULL", 0.63708, 0.001);
        this.tester.checkScalar("{fn ROUND(1251, -2)}", 1300, "INTEGER NOT NULL");
        this.tester.checkFails("^{fn ROUND(1251)}^", "Cannot apply '\\{fn ROUND\\}' to arguments of type '\\{fn ROUND\\}\\(<INTEGER>\\)'.*", false);
        this.tester.checkScalar("{fn SIGN(-1)}", -1, "INTEGER NOT NULL");
        this.tester.checkScalarApprox("{fn SIN(0.2)}", "DOUBLE NOT NULL", 0.19867, 0.001);
        this.tester.checkScalarApprox("{fn SQRT(4.2)}", "DOUBLE NOT NULL", 2.04939, 0.001);
        this.tester.checkScalarApprox("{fn TAN(0.2)}", "DOUBLE NOT NULL", 0.20271, 0.001);
        this.tester.checkScalar("{fn TRUNCATE(12.34, 1)}", 12.3, "DECIMAL(4, 2) NOT NULL");
        this.tester.checkScalar("{fn TRUNCATE(-12.34, -1)}", -10, "DECIMAL(4, 2) NOT NULL");
        this.tester.checkScalar("{fn CONCAT('foo', 'bar')}", "foobar", "CHAR(6) NOT NULL");
        this.tester.checkScalar("{fn INSERT('abc', 1, 2, 'ABCdef')}", "ABCdefc", "VARCHAR(9) NOT NULL");
        this.tester.checkScalar("{fn LCASE('foo' || 'bar')}", "foobar", "CHAR(6) NOT NULL");
        this.tester.checkScalar("{fn LOCATE('ha', 'alphabet')}", 4, "INTEGER NOT NULL");
        this.tester.checkScalar("{fn LOCATE('ha', 'alphabet', 6)}", 0, "INTEGER NOT NULL");
        this.tester.checkScalar("{fn LTRIM(' xxx  ')}", "xxx  ", "VARCHAR(6) NOT NULL");
        this.tester.checkString("{fn REPLACE('JACK and JUE','J','BL')}", "BLACK and BLUE", "VARCHAR(12) NOT NULL");
        this.tester.checkString("{fn REPLACE('ciao', 'ciao', '')}", "", "VARCHAR(4) NOT NULL");
        this.tester.checkString("{fn REPLACE('hello world', 'o', '')}", "hell wrld", "VARCHAR(11) NOT NULL");
        this.tester.checkNull("{fn REPLACE(cast(null as varchar(5)), 'ciao', '')}");
        this.tester.checkNull("{fn REPLACE('ciao', cast(null as varchar(3)), 'zz')}");
        this.tester.checkNull("{fn REPLACE('ciao', 'bella', cast(null as varchar(3)))}");
        this.tester.checkScalar("{fn RTRIM(' xxx  ')}", " xxx", "VARCHAR(6) NOT NULL");
        this.tester.checkScalar("{fn SUBSTRING('abcdef', 2, 3)}", "bcd", "VARCHAR(6) NOT NULL");
        this.tester.checkScalar("{fn UCASE('xxx')}", "XXX", "CHAR(3) NOT NULL");
        this.tester.checkType("{fn CURDATE()}", "DATE NOT NULL");
        this.tester.checkType("{fn CURTIME()}", "TIME(0) NOT NULL");
        this.tester.checkScalar("{fn DAYOFMONTH(DATE '2014-12-10')}", 10, "BIGINT NOT NULL");
        this.tester.checkScalar("{fn HOUR(TIMESTAMP '2014-12-10 12:34:56')}", 12, "BIGINT NOT NULL");
        this.tester.checkScalar("{fn MINUTE(TIMESTAMP '2014-12-10 12:34:56')}", 34, "BIGINT NOT NULL");
        this.tester.checkScalar("{fn MONTH(DATE '2014-12-10')}", 12, "BIGINT NOT NULL");
        this.tester.checkType("{fn NOW()}", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("{fn QUARTER(DATE '2014-12-10')}", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("{fn SECOND(TIMESTAMP '2014-12-10 12:34:56')}", 56, "BIGINT NOT NULL");
        this.tester.checkScalar("{fn TIMESTAMPADD(HOUR, 5, TIMESTAMP '2014-03-29 12:34:56')}", "2014-03-29 17:34:56", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("{fn TIMESTAMPDIFF(HOUR, TIMESTAMP '2014-03-29 12:34:56', TIMESTAMP '2014-03-29 12:34:56')}", "0", "INTEGER NOT NULL");
        this.tester.checkScalar("{fn YEAR(DATE '2014-12-10')}", 2014, "BIGINT NOT NULL");
        this.tester.checkType("{fn DATABASE()}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("{fn IFNULL('a', 'b')}", "a", "CHAR(1) NOT NULL");
        this.tester.checkString("{fn USER()}", "sa", "VARCHAR(2000) NOT NULL");
        this.tester.checkScalar("{fn CONVERT('123', INTEGER)}", 123, "INTEGER NOT NULL");
        this.tester.checkScalar("{fn CONVERT('123', SQL_INTEGER)}", 123, "INTEGER NOT NULL");
        this.tester.checkScalar("{fn CONVERT(INTERVAL '1' DAY, SQL_INTERVAL_DAY_TO_SECOND)}", "+1 00:00:00.000000", "INTERVAL DAY TO SECOND NOT NULL");
    }

    @Test
    public void testSelect() {
        this.tester.check("select * from (values(1))", SqlTests.INTEGER_TYPE_CHECKER, "1", 0.0);
        if (this.getClass() != SqlOperatorTest.class) {
            // empty if block
        }
    }

    @Test
    public void testLiteralChain() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LITERAL_CHAIN, VM_EXPAND);
        this.tester.checkString("'buttered'\n' toast'", "buttered toast", "CHAR(14) NOT NULL");
        this.tester.checkString("'corned'\n' beef'\n' on'\n' rye'", "corned beef on rye", "CHAR(18) NOT NULL");
        this.tester.checkString("_latin1'Spaghetti'\n' all''Amatriciana'", "Spaghetti all'Amatriciana", "CHAR(25) NOT NULL");
        this.tester.checkBoolean("x'1234'\n'abcd' = x'1234abcd'", Boolean.TRUE);
        this.tester.checkBoolean("x'1234'\n'' = x'1234'", Boolean.TRUE);
        this.tester.checkBoolean("x''\n'ab' = x'ab'", Boolean.TRUE);
    }

    @Test
    public void testComplexLiteral() {
        this.tester.check("select 2 * 2 * x from (select 2 as x)", (SqlTester.TypeChecker)new SqlTests.StringTypeChecker("INTEGER NOT NULL"), "8", 0.0);
        this.tester.check("select 1 * 2 * 3 * x from (select 2 as x)", (SqlTester.TypeChecker)new SqlTests.StringTypeChecker("INTEGER NOT NULL"), "12", 0.0);
        this.tester.check("select 1 + 2 + 3 + 4 + x from (select 2 as x)", (SqlTester.TypeChecker)new SqlTests.StringTypeChecker("INTEGER NOT NULL"), "12", 0.0);
    }

    @Test
    public void testRow() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ROW, VM_FENNEL);
    }

    @Test
    public void testAndOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.AND, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true and false", Boolean.FALSE);
        this.tester.checkBoolean("true and true", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) and false", Boolean.FALSE);
        this.tester.checkBoolean("false and cast(null as boolean)", Boolean.FALSE);
        this.tester.checkNull("cast(null as boolean) and true");
        this.tester.checkBoolean("true and (not false)", Boolean.TRUE);
    }

    @Test
    public void testAndOperator2() {
        this.tester.checkBoolean("case when false then unknown else true end and true", Boolean.TRUE);
        this.tester.checkBoolean("case when false then cast(null as boolean) else true end and true", Boolean.TRUE);
        this.tester.checkBoolean("case when false then null else true end and true", Boolean.TRUE);
    }

    @Test
    public void testAndOperatorLazy() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.AND, new SqlTester.VmName[0]);
        this.tester.check("values 1 > 2 and sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(Boolean.FALSE, INVALID_ARG_FOR_POWER, CODE_2201F));
    }

    @Test
    public void testConcatOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CONCAT, new SqlTester.VmName[0]);
        this.tester.checkString(" 'a'||'b' ", "ab", "CHAR(2) NOT NULL");
        this.tester.checkNull(" 'a' || cast(null as char(2)) ");
        this.tester.checkNull(" cast(null as char(2)) || 'b' ");
        this.tester.checkNull(" cast(null as char(1)) || cast(null as char(2)) ");
        this.tester.checkString(" x'fe'||x'df' ", "fedf", "BINARY(2) NOT NULL");
        this.tester.checkString(" cast('fe' as char(2)) || cast('df' as varchar)", "fedf", "VARCHAR NOT NULL");
        this.tester.checkString(" cast('fe' as char(2)) || cast('df' as varchar(65535))", "fedf", "VARCHAR NOT NULL");
        this.tester.checkString(" cast('fe' as char(2)) || cast('df' as varchar(33333))", "fedf", "VARCHAR(33335) NOT NULL");
        this.tester.checkNull("x'ff' || cast(null as varbinary)");
        this.tester.checkNull(" cast(null as ANY) || cast(null as ANY) ");
    }

    @Test
    public void testModOperator() {
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5);
        tester1.setFor((SqlOperator)SqlStdOperatorTable.PERCENT_REMAINDER, new SqlTester.VmName[0]);
        tester1.checkScalarExact("4%2", "0");
        tester1.checkScalarExact("8%5", "3");
        tester1.checkScalarExact("-12%7", "-5");
        tester1.checkScalarExact("-12%-7", "-5");
        tester1.checkScalarExact("12%-7", "5");
        tester1.checkScalarExact("cast(12 as tinyint) % cast(-7 as tinyint)", "TINYINT NOT NULL", "5");
    }

    @Test
    public void testModPrecedence() {
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5);
        tester1.setFor((SqlOperator)SqlStdOperatorTable.PERCENT_REMAINDER, new SqlTester.VmName[0]);
        tester1.checkScalarExact("1 + 5 % 3 % 4 * 14 % 17", "12");
        tester1.checkScalarExact("(1 + 5 % 3) % 4 + 14 % 17", "17");
    }

    @Test
    public void testModOperatorNull() {
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5);
        tester1.checkNull("cast(null as integer) % 2");
        tester1.checkNull("4 % cast(null as tinyint)");
    }

    @Test
    public void testModOperatorDivByZero() {
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5);
        tester1.checkFails("3 % case 'a' when 'a' then 0 end", DIVISION_BY_ZERO_MESSAGE, true);
    }

    @Test
    public void testDivideOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DIVIDE, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("10 / 5", "2");
        this.tester.checkScalarExact("-10 / 5", "-2");
        this.tester.checkScalarExact("1 / 3", "0");
        this.tester.checkScalarApprox(" cast(10.0 as double) / 5", "DOUBLE NOT NULL", 2.0, 0.0);
        this.tester.checkScalarApprox(" cast(10.0 as real) / 5", "REAL NOT NULL", 2.0, 0.0);
        this.tester.checkScalarApprox(" 6.0 / cast(10.0 as real) ", "DOUBLE NOT NULL", 0.6, 0.0);
        this.tester.checkScalarExact("10.0 / 5.0", "DECIMAL(9, 6) NOT NULL", "2");
        this.tester.checkNull("1e1 / cast(null as float)");
    }

    @Test
    public void testDivideOperatorIntervals() {
        this.tester.checkScalar("interval '-2:2' hour to minute / 3", "-0:41", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.tester.checkScalar("interval '2:5:12' hour to second / 2 / -3", "-0:20:52.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkNull("interval '2' day / cast(null as bigint)");
        this.tester.checkNull("cast(null as interval month) / 2");
        this.tester.checkScalar("interval '3-3' year to month / 15e-1", "+2-02", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("interval '3-4' year to month / 4.5", "+0-09", "INTERVAL YEAR TO MONTH NOT NULL");
    }

    @Test
    public void testEqualsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EQUALS, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1=1", Boolean.TRUE);
        this.tester.checkBoolean("1=1.0", Boolean.TRUE);
        this.tester.checkBoolean("1.34=1.34", Boolean.TRUE);
        this.tester.checkBoolean("1=1.34", Boolean.FALSE);
        this.tester.checkBoolean("1e2=100e0", Boolean.TRUE);
        this.tester.checkBoolean("1e2=101", Boolean.FALSE);
        this.tester.checkBoolean("cast(1e2 as real)=cast(101 as bigint)", Boolean.FALSE);
        this.tester.checkBoolean("'a'='b'", Boolean.FALSE);
        this.tester.checkBoolean("true = true", Boolean.TRUE);
        this.tester.checkBoolean("true = false", Boolean.FALSE);
        this.tester.checkBoolean("false = true", Boolean.FALSE);
        this.tester.checkBoolean("false = false", Boolean.TRUE);
        this.tester.checkBoolean("cast('a' as varchar(30))=cast('a' as varchar(30))", Boolean.TRUE);
        this.tester.checkBoolean("cast('a ' as varchar(30))=cast('a' as varchar(30))", Boolean.FALSE);
        this.tester.checkBoolean("cast(' a' as varchar(30))=cast(' a' as varchar(30))", Boolean.TRUE);
        this.tester.checkBoolean("cast('a ' as varchar(15))=cast('a ' as varchar(30))", Boolean.TRUE);
        this.tester.checkBoolean("cast(' ' as varchar(3))=cast(' ' as varchar(2))", Boolean.TRUE);
        this.tester.checkBoolean("cast('abcd' as varchar(2))='ab'", Boolean.TRUE);
        this.tester.checkBoolean("cast('a' as varchar(30))=cast('b' as varchar(30))", Boolean.FALSE);
        this.tester.checkBoolean("cast('a' as varchar(30))=cast('a' as varchar(15))", Boolean.TRUE);
        this.tester.checkNull("cast(null as boolean)=cast(null as boolean)");
        this.tester.checkNull("cast(null as integer)=1");
        this.tester.checkNull("cast(null as varchar(10))='a'");
    }

    @Test
    public void testEqualsOperatorInterval() {
        this.tester.checkBoolean("interval '2' day = interval '1' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day = interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2:2:2' hour to second = interval '2' hour", Boolean.FALSE);
        this.tester.checkNull("cast(null as interval hour) = interval '2' minute");
    }

    @Test
    public void testGreaterThanOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1>2", Boolean.FALSE);
        this.tester.checkBoolean("cast(-1 as TINYINT)>cast(1 as TINYINT)", Boolean.FALSE);
        this.tester.checkBoolean("cast(1 as SMALLINT)>cast(1 as SMALLINT)", Boolean.FALSE);
        this.tester.checkBoolean("2>1", Boolean.TRUE);
        this.tester.checkBoolean("1.1>1.2", Boolean.FALSE);
        this.tester.checkBoolean("-1.1>-1.2", Boolean.TRUE);
        this.tester.checkBoolean("1.1>1.1", Boolean.FALSE);
        this.tester.checkBoolean("1.2>1", Boolean.TRUE);
        this.tester.checkBoolean("1.1e1>1.2e1", Boolean.FALSE);
        this.tester.checkBoolean("cast(-1.1 as real) > cast(-1.2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("1.1e2>1.1e2", Boolean.FALSE);
        this.tester.checkBoolean("1.2e0>1", Boolean.TRUE);
        this.tester.checkBoolean("cast(1.2e0 as real)>1", Boolean.TRUE);
        this.tester.checkBoolean("true>false", Boolean.TRUE);
        this.tester.checkBoolean("true>true", Boolean.FALSE);
        this.tester.checkBoolean("false>false", Boolean.FALSE);
        this.tester.checkBoolean("false>true", Boolean.FALSE);
        this.tester.checkNull("3.0>cast(null as double)");
        this.tester.checkBoolean("DATE '2013-02-23' > DATE '1945-02-24'", Boolean.TRUE);
        this.tester.checkBoolean("DATE '2013-02-23' > CAST(NULL AS DATE)", null);
        this.tester.checkBoolean("x'0A000130'>x'0A0001B0'", Boolean.FALSE);
    }

    @Test
    public void testGreaterThanOperatorIntervals() {
        this.tester.checkBoolean("interval '2' day > interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day > interval '5' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2 2:2:2' day to second > interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day > interval '2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day > interval '-2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day > interval '2' hour", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' minute > interval '2' hour", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' second > interval '2' minute", Boolean.FALSE);
        this.tester.checkNull("cast(null as interval hour) > interval '2' minute");
        this.tester.checkNull("interval '2:2' hour to minute > cast(null as interval second)");
    }

    @Test
    public void testIsDistinctFromOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_DISTINCT_FROM, VM_EXPAND);
        this.tester.checkBoolean("1 is distinct from 1", Boolean.FALSE);
        this.tester.checkBoolean("1 is distinct from 1.0", Boolean.FALSE);
        this.tester.checkBoolean("1 is distinct from 2", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as integer) is distinct from 2", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as integer) is distinct from cast(null as integer)", Boolean.FALSE);
        this.tester.checkBoolean("1.23 is distinct from 1.23", Boolean.FALSE);
        this.tester.checkBoolean("1.23 is distinct from 5.23", Boolean.TRUE);
        this.tester.checkBoolean("-23e0 is distinct from -2.3e1", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day is distinct from interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '10' hour is distinct from interval '10' hour", Boolean.FALSE);
    }

    @Test
    public void testIsNotDistinctFromOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, VM_EXPAND);
        this.tester.checkBoolean("1 is not distinct from 1", Boolean.TRUE);
        this.tester.checkBoolean("1 is not distinct from 1.0", Boolean.TRUE);
        this.tester.checkBoolean("1 is not distinct from 2", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as integer) is not distinct from 2", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as integer) is not distinct from cast(null as integer)", Boolean.TRUE);
        this.tester.checkBoolean("1.23 is not distinct from 1.23", Boolean.TRUE);
        this.tester.checkBoolean("1.23 is not distinct from 5.23", Boolean.FALSE);
        this.tester.checkBoolean("-23e0 is not distinct from -2.3e1", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day is not distinct from interval '1' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '10' hour is not distinct from interval '10' hour", Boolean.TRUE);
    }

    @Test
    public void testGreaterThanOrEqualOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1>=2", Boolean.FALSE);
        this.tester.checkBoolean("-1>=1", Boolean.FALSE);
        this.tester.checkBoolean("1>=1", Boolean.TRUE);
        this.tester.checkBoolean("2>=1", Boolean.TRUE);
        this.tester.checkBoolean("1.1>=1.2", Boolean.FALSE);
        this.tester.checkBoolean("-1.1>=-1.2", Boolean.TRUE);
        this.tester.checkBoolean("1.1>=1.1", Boolean.TRUE);
        this.tester.checkBoolean("1.2>=1", Boolean.TRUE);
        this.tester.checkBoolean("1.2e4>=1e5", Boolean.FALSE);
        this.tester.checkBoolean("1.2e4>=cast(1e5 as real)", Boolean.FALSE);
        this.tester.checkBoolean("1.2>=cast(1e5 as double)", Boolean.FALSE);
        this.tester.checkBoolean("120000>=cast(1e5 as real)", Boolean.TRUE);
        this.tester.checkBoolean("true>=false", Boolean.TRUE);
        this.tester.checkBoolean("true>=true", Boolean.TRUE);
        this.tester.checkBoolean("false>=false", Boolean.TRUE);
        this.tester.checkBoolean("false>=true", Boolean.FALSE);
        this.tester.checkNull("cast(null as real)>=999");
        this.tester.checkBoolean("x'0A000130'>=x'0A0001B0'", Boolean.FALSE);
        this.tester.checkBoolean("x'0A0001B0'>=x'0A0001B0'", Boolean.TRUE);
    }

    @Test
    public void testGreaterThanOrEqualOperatorIntervals() {
        this.tester.checkBoolean("interval '2' day >= interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '5' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2 2:2:2' day to second >= interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '-2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day >= interval '2' hour", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' minute >= interval '2' hour", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' second >= interval '2' minute", Boolean.FALSE);
        this.tester.checkNull("cast(null as interval hour) >= interval '2' minute");
        this.tester.checkNull("interval '2:2' hour to minute >= cast(null as interval second)");
    }

    @Test
    public void testInOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IN, VM_EXPAND);
        this.tester.checkBoolean("1 in (0, 1, 2)", true);
        this.tester.checkBoolean("3 in (0, 1, 2)", false);
        this.tester.checkBoolean("cast(null as integer) in (0, 1, 2)", null);
        this.tester.checkBoolean("cast(null as integer) in (0, cast(null as integer), 2)", null);
        if (!this.enable) {
            return;
        }
        this.tester.checkBoolean("false and true in (false, false)", false);
    }

    @Test
    public void testNotInOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_IN, VM_EXPAND);
        this.tester.checkBoolean("1 not in (0, 1, 2)", false);
        this.tester.checkBoolean("3 not in (0, 1, 2)", true);
        if (!this.enable) {
            return;
        }
        this.tester.checkBoolean("cast(null as integer) not in (0, 1, 2)", null);
        this.tester.checkBoolean("cast(null as integer) not in (0, cast(null as integer), 2)", null);
        this.tester.checkBoolean("true and false not in (true, true)", true);
    }

    @Test
    public void testOverlapsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OVERLAPS, VM_EXPAND);
        this.tester.checkBoolean("(date '1-2-3', date '1-2-3') overlaps (date '1-2-3', interval '1' year)", Boolean.TRUE);
        this.tester.checkBoolean("(date '1-2-3', date '1-2-3') overlaps (date '4-5-6', interval '1' year)", Boolean.FALSE);
        this.tester.checkBoolean("(date '1-2-3', date '4-5-6') overlaps (date '2-2-3', date '3-4-5')", Boolean.TRUE);
        this.tester.checkNull("(cast(null as date), date '1-2-3') overlaps (date '1-2-3', interval '1' year)");
        this.tester.checkNull("(date '1-2-3', date '1-2-3') overlaps (date '1-2-3', cast(null as date))");
        this.tester.checkBoolean("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', time '1:2:3')", Boolean.TRUE);
        this.tester.checkBoolean("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', time '1:2:2')", Boolean.TRUE);
        this.tester.checkBoolean("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', interval '2' hour)", Boolean.FALSE);
        this.tester.checkNull("(time '1:2:3', cast(null as time)) overlaps (time '23:59:59', time '1:2:3')");
        this.tester.checkNull("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', cast(null as interval hour))");
        this.tester.checkBoolean("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (timestamp '1-2-3 4:5:6', interval '1 2:3:4.5' day to second)", Boolean.TRUE);
        this.tester.checkBoolean("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (timestamp '2-2-3 4:5:6', interval '1 2:3:4.5' day to second)", Boolean.FALSE);
        this.tester.checkNull("(timestamp '1-2-3 4:5:6', cast(null as interval day) ) overlaps (timestamp '1-2-3 4:5:6', interval '1 2:3:4.5' day to second)");
        this.tester.checkNull("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (cast(null as timestamp), interval '1 2:3:4.5' day to second)");
    }

    @Test
    public void testPeriodOperators() {
        String[] times = new String[]{"TIME '01:00:00'", "TIME '02:00:00'", "TIME '03:00:00'", "TIME '04:00:00'"};
        String[] dates = new String[]{"DATE '1970-01-01'", "DATE '1970-02-01'", "DATE '1970-03-01'", "DATE '1970-04-01'"};
        String[] timestamps = new String[]{"TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-02-01 00:00:00'", "TIMESTAMP '1970-03-01 00:00:00'", "TIMESTAMP '1970-04-01 00:00:00'"};
        this.checkOverlaps(new OverlapChecker(times));
        this.checkOverlaps(new OverlapChecker(dates));
        this.checkOverlaps(new OverlapChecker(timestamps));
    }

    private void checkOverlaps(OverlapChecker c) {
        c.isTrue("($0,$0) OVERLAPS ($0,$0)");
        c.isFalse("($0,$1) OVERLAPS ($2,$3)");
        c.isTrue("($0,$1) OVERLAPS ($1,$2)");
        c.isTrue("($0,$2) OVERLAPS ($1,$3)");
        c.isTrue("($0,$2) OVERLAPS ($3,$1)");
        c.isTrue("($2,$0) OVERLAPS ($3,$1)");
        c.isFalse("($3,$2) OVERLAPS ($1,$0)");
        c.isTrue("($2,$3) OVERLAPS ($0,$2)");
        c.isTrue("($2,$3) OVERLAPS ($2,$0)");
        c.isTrue("($3,$2) OVERLAPS ($2,$0)");
        c.isTrue("($0,$2) OVERLAPS ($2,$0)");
        c.isTrue("($0,$3) OVERLAPS ($1,$3)");
        c.isTrue("($0,$3) OVERLAPS ($3,$3)");
        c.isTrue("($0,$0) CONTAINS ($0,$0)");
        c.isFalse("($0,$1) CONTAINS ($2,$3)");
        c.isFalse("($0,$1) CONTAINS ($1,$2)");
        c.isFalse("($0,$2) CONTAINS ($1,$3)");
        c.isFalse("($0,$2) CONTAINS ($3,$1)");
        c.isFalse("($2,$0) CONTAINS ($3,$1)");
        c.isFalse("($3,$2) CONTAINS ($1,$0)");
        c.isFalse("($2,$3) CONTAINS ($0,$2)");
        c.isFalse("($2,$3) CONTAINS ($2,$0)");
        c.isFalse("($3,$2) CONTAINS ($2,$0)");
        c.isTrue("($0,$2) CONTAINS ($2,$0)");
        c.isTrue("($0,$3) CONTAINS ($1,$3)");
        c.isTrue("($0,$3) CONTAINS ($3,$3)");
        c.isTrue("($3,$0) CONTAINS ($3,$3)");
        c.isTrue("($3,$0) CONTAINS ($0,$0)");
        c.isTrue("($0,$0) CONTAINS $0");
        c.isTrue("($3,$0) CONTAINS $0");
        c.isTrue("($3,$0) CONTAINS $1");
        c.isTrue("($3,$0) CONTAINS $2");
        c.isTrue("($3,$0) CONTAINS $3");
        c.isTrue("($0,$3) CONTAINS $0");
        c.isTrue("($0,$3) CONTAINS $1");
        c.isTrue("($0,$3) CONTAINS $2");
        c.isTrue("($0,$3) CONTAINS $3");
        c.isFalse("($1,$3) CONTAINS $0");
        c.isFalse("($1,$2) CONTAINS $3");
        c.isTrue("($0,$0) EQUALS ($0,$0)");
        c.isFalse("($0,$1) EQUALS ($2,$3)");
        c.isFalse("($0,$1) EQUALS ($1,$2)");
        c.isFalse("($0,$2) EQUALS ($1,$3)");
        c.isFalse("($0,$2) EQUALS ($3,$1)");
        c.isFalse("($2,$0) EQUALS ($3,$1)");
        c.isFalse("($3,$2) EQUALS ($1,$0)");
        c.isFalse("($2,$3) EQUALS ($0,$2)");
        c.isFalse("($2,$3) EQUALS ($2,$0)");
        c.isFalse("($3,$2) EQUALS ($2,$0)");
        c.isTrue("($0,$2) EQUALS ($2,$0)");
        c.isFalse("($0,$3) EQUALS ($1,$3)");
        c.isFalse("($0,$3) EQUALS ($3,$3)");
        c.isFalse("($3,$0) EQUALS ($3,$3)");
        c.isFalse("($3,$0) EQUALS ($0,$0)");
        c.isTrue("($0,$0) PRECEDES ($0,$0)");
        c.isTrue("($0,$1) PRECEDES ($2,$3)");
        c.isTrue("($0,$1) PRECEDES ($1,$2)");
        c.isFalse("($0,$2) PRECEDES ($1,$3)");
        c.isFalse("($0,$2) PRECEDES ($3,$1)");
        c.isFalse("($2,$0) PRECEDES ($3,$1)");
        c.isFalse("($3,$2) PRECEDES ($1,$0)");
        c.isFalse("($2,$3) PRECEDES ($0,$2)");
        c.isFalse("($2,$3) PRECEDES ($2,$0)");
        c.isFalse("($3,$2) PRECEDES ($2,$0)");
        c.isFalse("($0,$2) PRECEDES ($2,$0)");
        c.isFalse("($0,$3) PRECEDES ($1,$3)");
        c.isTrue("($0,$3) PRECEDES ($3,$3)");
        c.isTrue("($3,$0) PRECEDES ($3,$3)");
        c.isFalse("($3,$0) PRECEDES ($0,$0)");
        c.isTrue("($0,$0) SUCCEEDS ($0,$0)");
        c.isFalse("($0,$1) SUCCEEDS ($2,$3)");
        c.isFalse("($0,$1) SUCCEEDS ($1,$2)");
        c.isFalse("($0,$2) SUCCEEDS ($1,$3)");
        c.isFalse("($0,$2) SUCCEEDS ($3,$1)");
        c.isFalse("($2,$0) SUCCEEDS ($3,$1)");
        c.isTrue("($3,$2) SUCCEEDS ($1,$0)");
        c.isTrue("($2,$3) SUCCEEDS ($0,$2)");
        c.isTrue("($2,$3) SUCCEEDS ($2,$0)");
        c.isTrue("($3,$2) SUCCEEDS ($2,$0)");
        c.isFalse("($0,$2) SUCCEEDS ($2,$0)");
        c.isFalse("($0,$3) SUCCEEDS ($1,$3)");
        c.isFalse("($0,$3) SUCCEEDS ($3,$3)");
        c.isFalse("($3,$0) SUCCEEDS ($3,$3)");
        c.isTrue("($3,$0) SUCCEEDS ($0,$0)");
        c.isTrue("($0,$0) IMMEDIATELY PRECEDES ($0,$0)");
        c.isFalse("($0,$1) IMMEDIATELY PRECEDES ($2,$3)");
        c.isTrue("($0,$1) IMMEDIATELY PRECEDES ($1,$2)");
        c.isFalse("($0,$2) IMMEDIATELY PRECEDES ($1,$3)");
        c.isFalse("($0,$2) IMMEDIATELY PRECEDES ($3,$1)");
        c.isFalse("($2,$0) IMMEDIATELY PRECEDES ($3,$1)");
        c.isFalse("($3,$2) IMMEDIATELY PRECEDES ($1,$0)");
        c.isFalse("($2,$3) IMMEDIATELY PRECEDES ($0,$2)");
        c.isFalse("($2,$3) IMMEDIATELY PRECEDES ($2,$0)");
        c.isFalse("($3,$2) IMMEDIATELY PRECEDES ($2,$0)");
        c.isFalse("($0,$2) IMMEDIATELY PRECEDES ($2,$0)");
        c.isFalse("($0,$3) IMMEDIATELY PRECEDES ($1,$3)");
        c.isTrue("($0,$3) IMMEDIATELY PRECEDES ($3,$3)");
        c.isTrue("($3,$0) IMMEDIATELY PRECEDES ($3,$3)");
        c.isFalse("($3,$0) IMMEDIATELY PRECEDES ($0,$0)");
        c.isTrue("($0,$0) IMMEDIATELY SUCCEEDS ($0,$0)");
        c.isFalse("($0,$1) IMMEDIATELY SUCCEEDS ($2,$3)");
        c.isFalse("($0,$1) IMMEDIATELY SUCCEEDS ($1,$2)");
        c.isFalse("($0,$2) IMMEDIATELY SUCCEEDS ($1,$3)");
        c.isFalse("($0,$2) IMMEDIATELY SUCCEEDS ($3,$1)");
        c.isFalse("($2,$0) IMMEDIATELY SUCCEEDS ($3,$1)");
        c.isFalse("($3,$2) IMMEDIATELY SUCCEEDS ($1,$0)");
        c.isTrue("($2,$3) IMMEDIATELY SUCCEEDS ($0,$2)");
        c.isTrue("($2,$3) IMMEDIATELY SUCCEEDS ($2,$0)");
        c.isTrue("($3,$2) IMMEDIATELY SUCCEEDS ($2,$0)");
        c.isFalse("($0,$2) IMMEDIATELY SUCCEEDS ($2,$0)");
        c.isFalse("($0,$3) IMMEDIATELY SUCCEEDS ($1,$3)");
        c.isFalse("($0,$3) IMMEDIATELY SUCCEEDS ($3,$3)");
        c.isFalse("($3,$0) IMMEDIATELY SUCCEEDS ($3,$3)");
        c.isTrue("($3,$0) IMMEDIATELY SUCCEEDS ($0,$0)");
    }

    @Test
    public void testLessThanOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LESS_THAN, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1<2", Boolean.TRUE);
        this.tester.checkBoolean("-1<1", Boolean.TRUE);
        this.tester.checkBoolean("1<1", Boolean.FALSE);
        this.tester.checkBoolean("2<1", Boolean.FALSE);
        this.tester.checkBoolean("1.1<1.2", Boolean.TRUE);
        this.tester.checkBoolean("-1.1<-1.2", Boolean.FALSE);
        this.tester.checkBoolean("1.1<1.1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<1.1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<cast(1.2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("-1.1e-1<-1.2e-1", Boolean.FALSE);
        this.tester.checkBoolean("cast(1.1 as real)<cast(1.1 as double)", Boolean.FALSE);
        this.tester.checkBoolean("true<false", Boolean.FALSE);
        this.tester.checkBoolean("true<true", Boolean.FALSE);
        this.tester.checkBoolean("false<false", Boolean.FALSE);
        this.tester.checkBoolean("false<true", Boolean.TRUE);
        this.tester.checkNull("123<cast(null as bigint)");
        this.tester.checkNull("cast(null as tinyint)<123");
        this.tester.checkNull("cast(null as integer)<1.32");
        this.tester.checkBoolean("x'0A000130'<x'0A0001B0'", Boolean.TRUE);
    }

    @Test
    public void testLessThanOperatorInterval() {
    }

    @Test
    public void testLessThanOrEqualOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1<=2", Boolean.TRUE);
        this.tester.checkBoolean("1<=1", Boolean.TRUE);
        this.tester.checkBoolean("-1<=1", Boolean.TRUE);
        this.tester.checkBoolean("2<=1", Boolean.FALSE);
        this.tester.checkBoolean("1.1<=1.2", Boolean.TRUE);
        this.tester.checkBoolean("-1.1<=-1.2", Boolean.FALSE);
        this.tester.checkBoolean("1.1<=1.1", Boolean.TRUE);
        this.tester.checkBoolean("1.2<=1", Boolean.FALSE);
        this.tester.checkBoolean("1<=cast(1e2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("1000<=cast(1e2 as real)", Boolean.FALSE);
        this.tester.checkBoolean("1.2e1<=1e2", Boolean.TRUE);
        this.tester.checkBoolean("1.2e1<=cast(1e2 as real)", Boolean.TRUE);
        this.tester.checkBoolean("true<=false", Boolean.FALSE);
        this.tester.checkBoolean("true<=true", Boolean.TRUE);
        this.tester.checkBoolean("false<=false", Boolean.TRUE);
        this.tester.checkBoolean("false<=true", Boolean.TRUE);
        this.tester.checkNull("cast(null as real)<=cast(1 as real)");
        this.tester.checkNull("cast(null as integer)<=3");
        this.tester.checkNull("3<=cast(null as smallint)");
        this.tester.checkNull("cast(null as integer)<=1.32");
        this.tester.checkBoolean("x'0A000130'<=x'0A0001B0'", Boolean.TRUE);
        this.tester.checkBoolean("x'0A0001B0'<=x'0A0001B0'", Boolean.TRUE);
    }

    @Test
    public void testLessThanOrEqualOperatorInterval() {
        this.tester.checkBoolean("interval '2' day <= interval '1' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day <= interval '5' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2 2:2:2' day to second <= interval '2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day <= interval '2' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day <= interval '-2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' day <= interval '2' hour", Boolean.FALSE);
        this.tester.checkBoolean("interval '2' minute <= interval '2' hour", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' second <= interval '2' minute", Boolean.TRUE);
        this.tester.checkNull("cast(null as interval hour) <= interval '2' minute");
        this.tester.checkNull("interval '2:2' hour to minute <= cast(null as interval second)");
    }

    @Test
    public void testMinusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MINUS, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("-2-1", "-3");
        this.tester.checkScalarExact("-2-1-5", "-8");
        this.tester.checkScalarExact("2-1", "1");
        this.tester.checkScalarApprox("cast(2.0 as double) -1", "DOUBLE NOT NULL", 1.0, 0.0);
        this.tester.checkScalarApprox("cast(1 as smallint)-cast(2.0 as real)", "REAL NOT NULL", -1.0, 0.0);
        this.tester.checkScalarApprox("2.4-cast(2.0 as real)", "DOUBLE NOT NULL", 0.4, 1.0E-8);
        this.tester.checkScalarExact("1-2", "-1");
        this.tester.checkScalarExact("10.0 - 5.0", "DECIMAL(4, 1) NOT NULL", "5.0");
        this.tester.checkScalarExact("19.68 - 4.2", "DECIMAL(5, 2) NOT NULL", "15.48");
        this.tester.checkNull("1e1-cast(null as double)");
        this.tester.checkNull("cast(null as tinyint) - cast(null as smallint)");
    }

    @Test
    public void testMinusIntervalOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MINUS, new SqlTester.VmName[0]);
        this.tester.checkScalar("interval '2' day - interval '1' day", "+1", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("interval '2' day - interval '1' minute", "+1 23:59", "INTERVAL DAY TO MINUTE NOT NULL");
        this.tester.checkScalar("interval '2' year - interval '1' month", "+1-11", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("interval '2' year - interval '1' month - interval '3' year", "-1-01", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("cast(null as interval day) + interval '2' hour");
        this.tester.checkScalar("time '12:03:01' - interval '1:1' hour to minute", "11:02:01", "TIME(0) NOT NULL");
        this.tester.checkScalar("time '12:03:01' - interval '1' day", "12:03:01", "TIME(0) NOT NULL");
        this.tester.checkScalar("time '12:03:01' - interval '25' hour", "11:03:01", "TIME(0) NOT NULL");
        this.tester.checkScalar("time '12:03:03' - interval '25:0:1' hour to second", "11:03:02", "TIME(0) NOT NULL");
        this.tester.checkScalar("date '2005-03-02' - interval '5' day", "2005-02-25", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' - interval '5' day", "2005-02-25", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' - interval '5' hour", "2005-03-02", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' - interval '25' hour", "2005-03-01", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' - interval '25:45' hour to minute", "2005-03-01", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' - interval '25:45:54' hour to second", "2005-03-01", "DATE NOT NULL");
        this.tester.checkScalar("timestamp '2003-08-02 12:54:01' - interval '-4 2:4' day to minute", "2003-08-06 14:58:01", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestamp '2003-08-02 12:54:01' - interval '12' year", "1991-08-02 12:54:01", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("date '2003-08-02' - interval '12' year", "1991-08-02", "DATE NOT NULL");
        this.tester.checkScalar("date '2003-08-02' - interval '12-3' year to month", "1991-05-02", "DATE NOT NULL");
    }

    @Test
    public void testMinusDateOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MINUS_DATE, new SqlTester.VmName[0]);
        this.tester.checkScalar("(time '12:03:34' - time '11:57:23') minute to second", "+6:11.000000", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.tester.checkScalar("(time '12:03:23' - time '11:57:23') minute", "+6", "INTERVAL MINUTE NOT NULL");
        this.tester.checkScalar("(time '12:03:34' - time '11:57:23') minute", "+6", "INTERVAL MINUTE NOT NULL");
        this.tester.checkScalar("(timestamp '2004-05-01 12:03:34' - timestamp '2004-04-29 11:57:23') day to second", "+2 00:06:11.000000", "INTERVAL DAY TO SECOND NOT NULL");
        this.tester.checkScalar("(timestamp '2004-05-01 12:03:34' - timestamp '2004-04-29 11:57:23') day to hour", "+2 00", "INTERVAL DAY TO HOUR NOT NULL");
        this.tester.checkScalar("(date '2004-12-02' - date '2003-12-01') day", "+367", "INTERVAL DAY NOT NULL");
        this.tester.checkNull("(cast(null as date) - date '2003-12-01') day");
        this.tester.checkScalar("timestamp '1969-04-29 0:0:0' + (timestamp '2008-07-15 15:28:00' -   timestamp '1969-04-29 0:0:0') day to second / 2", "1988-12-06 07:44:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("date '1969-04-29' + (date '2008-07-15' -   date '1969-04-29') day / 2", "1988-12-06", "DATE NOT NULL");
        this.tester.checkScalar("time '01:23:44' + (time '15:28:00' -   time '01:23:44') hour to second / 2", "08:25:52", "TIME(0) NOT NULL");
    }

    @Test
    public void testMultiplyOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MULTIPLY, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("2*3", "6");
        this.tester.checkScalarExact("2*-3", "-6");
        this.tester.checkScalarExact("+2*3", "6");
        this.tester.checkScalarExact("2*0", "0");
        this.tester.checkScalarApprox("cast(2.0 as float)*3", "FLOAT NOT NULL", 6.0, 0.0);
        this.tester.checkScalarApprox("3*cast(2.0 as real)", "REAL NOT NULL", 6.0, 0.0);
        this.tester.checkScalarApprox("cast(2.0 as real)*3.2", "DOUBLE NOT NULL", 6.4, 0.0);
        this.tester.checkScalarExact("10.0 * 5.0", "DECIMAL(5, 2) NOT NULL", "50.00");
        this.tester.checkScalarExact("19.68 * 4.2", "DECIMAL(6, 3) NOT NULL", "82.656");
        this.tester.checkNull("cast(1 as real)*cast(null as real)");
        this.tester.checkNull("2e-3*cast(null as integer)");
        this.tester.checkNull("cast(null as tinyint) * cast(4 as smallint)");
    }

    @Test
    public void testMultiplyIntervals() {
        this.tester.checkScalar("interval '2:2' hour to minute * 3", "+6:06", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.tester.checkScalar("3 * 2 * interval '2:5:12' hour to second", "+12:31:12.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkNull("interval '2' day * cast(null as bigint)");
        this.tester.checkNull("cast(null as interval month) * 2");
    }

    @Test
    public void testDatePlusInterval() {
        this.tester.checkScalar("date '2014-02-11' + interval '2' day", "2014-02-13", "DATE NOT NULL");
        this.tester.checkScalar("date '2014-02-11' + interval '60' day", "2014-04-12", "DATE NOT NULL");
    }

    @Test
    public void testNullOperand() {
        this.checkNullOperand(this.tester, "=");
        this.checkNullOperand(this.tester, ">");
        this.checkNullOperand(this.tester, "<");
        this.checkNullOperand(this.tester, "<=");
        this.checkNullOperand(this.tester, ">=");
        this.checkNullOperand(this.tester, "<>");
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10);
        this.checkNullOperand(tester1, "<>");
    }

    private void checkNullOperand(SqlTester tester, String op) {
        tester.checkBoolean("1 " + op + " null", null);
        tester.checkBoolean("null " + op + " -3", null);
        tester.checkBoolean("null " + op + " null", null);
    }

    @Test
    public void testNotEqualsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new SqlTester.VmName[0]);
        this.tester.checkBoolean("1<>1", Boolean.FALSE);
        this.tester.checkBoolean("'a'<>'A'", Boolean.TRUE);
        this.tester.checkBoolean("1e0<>1e1", Boolean.TRUE);
        this.tester.checkNull("'a'<>cast(null as varchar(1))");
        this.tester.checkFails("1 != 1", "Bang equal '!=' is not allowed under the current SQL conformance level", false);
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10);
        tester1.checkBoolean("1 <> 1", Boolean.FALSE);
        tester1.checkBoolean("1 != 1", Boolean.FALSE);
        tester1.checkBoolean("1 != null", null);
    }

    @Test
    public void testNotEqualsOperatorIntervals() {
        this.tester.checkBoolean("interval '2' day <> interval '1' day", Boolean.TRUE);
        this.tester.checkBoolean("interval '2' day <> interval '2' day", Boolean.FALSE);
        this.tester.checkBoolean("interval '2:2:2' hour to second <> interval '2' hour", Boolean.TRUE);
        this.tester.checkNull("cast(null as interval hour) <> interval '2' minute");
    }

    @Test
    public void testOrOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OR, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true or false", Boolean.TRUE);
        this.tester.checkBoolean("false or false", Boolean.FALSE);
        this.tester.checkBoolean("true or cast(null as boolean)", Boolean.TRUE);
        this.tester.checkNull("false or cast(null as boolean)");
    }

    @Test
    public void testOrOperatorLazy() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OR, new SqlTester.VmName[0]);
        this.tester.check("values 1 < cast(null as integer) or sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(null, INVALID_ARG_FOR_POWER, CODE_2201F));
        this.tester.check("values 1 < 2 or sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(Boolean.TRUE, INVALID_ARG_FOR_POWER, CODE_2201F));
        this.tester.check("values 1 < cast(null as integer) or sqrt(4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(null, INVALID_ARG_FOR_POWER, CODE_2201F));
        this.tester.checkBoolean("1 < cast(null as integer) or sqrt(4) = 2", Boolean.TRUE);
    }

    @Test
    public void testPlusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PLUS, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("1+2", "3");
        this.tester.checkScalarExact("-1+2", "1");
        this.tester.checkScalarExact("1+2+3", "6");
        this.tester.checkScalarApprox("1+cast(2.0 as double)", "DOUBLE NOT NULL", 3.0, 0.0);
        this.tester.checkScalarApprox("1+cast(2.0 as double)+cast(6.0 as float)", "DOUBLE NOT NULL", 9.0, 0.0);
        this.tester.checkScalarExact("10.0 + 5.0", "DECIMAL(4, 1) NOT NULL", "15.0");
        this.tester.checkScalarExact("19.68 + 4.2", "DECIMAL(5, 2) NOT NULL", "23.88");
        this.tester.checkScalarExact("19.68 + 4.2 + 6", "DECIMAL(13, 2) NOT NULL", "29.88");
        this.tester.checkScalarApprox("19.68 + cast(4.2 as float)", "DOUBLE NOT NULL", 23.88, 0.02);
        this.tester.checkNull("cast(null as tinyint)+1");
        this.tester.checkNull("1e-2+cast(null as double)");
    }

    @Test
    public void testPlusOperatorAny() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PLUS, new SqlTester.VmName[0]);
        this.tester.checkScalar("1+CAST(2 AS ANY)", "3", "ANY NOT NULL");
    }

    @Test
    public void testPlusIntervalOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PLUS, new SqlTester.VmName[0]);
        this.tester.checkScalar("interval '2' day + interval '1' day", "+3", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("interval '2' day + interval '1' minute", "+2 00:01", "INTERVAL DAY TO MINUTE NOT NULL");
        this.tester.checkScalar("interval '2' day + interval '5' minute + interval '-3' second", "+2 00:04:57.000000", "INTERVAL DAY TO SECOND NOT NULL");
        this.tester.checkScalar("interval '2' year + interval '1' month", "+2-01", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("interval '2' year + cast(null as interval month)");
        this.tester.checkScalar("time '12:03:01' + interval '1:1' hour to minute", "13:04:01", "TIME(0) NOT NULL");
        this.tester.checkScalar("time '12:03:01' + interval '1' day", "12:03:01", "TIME(0) NOT NULL");
        this.tester.checkScalar("time '12:03:01' + interval '25' hour", "13:03:01", "TIME(0) NOT NULL");
        this.tester.checkScalar("time '12:03:01' + interval '25:0:1' hour to second", "13:03:02", "TIME(0) NOT NULL");
        this.tester.checkScalar("interval '5' day + date '2005-03-02'", "2005-03-07", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' + interval '5' day", "2005-03-07", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' + interval '5' hour", "2005-03-02", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' + interval '25' hour", "2005-03-03", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' + interval '25:45' hour to minute", "2005-03-03", "DATE NOT NULL");
        this.tester.checkScalar("date '2005-03-02' + interval '25:45:54' hour to second", "2005-03-03", "DATE NOT NULL");
        this.tester.checkScalar("timestamp '2003-08-02 12:54:01' + interval '-4 2:4' day to minute", "2003-07-29 10:50:01", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("interval '5-3' year to month + date '2005-03-02'", "2010-06-02", "DATE NOT NULL");
        this.tester.checkScalar("timestamp '2003-08-02 12:54:01' + interval '5-3' year to month", "2008-11-02 12:54:01", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("interval '5-3' year to month + timestamp '2003-08-02 12:54:01'", "2008-11-02 12:54:01", "TIMESTAMP(0) NOT NULL");
    }

    @Test
    public void testDescendingOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DESC, VM_EXPAND);
    }

    @Test
    public void testIsNotNullOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is not null", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not null", Boolean.FALSE);
    }

    @Test
    public void testIsNullOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NULL, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is null", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is null", Boolean.TRUE);
    }

    @Test
    public void testIsNotTrueOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is not true", Boolean.FALSE);
        this.tester.checkBoolean("false is not true", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not true", Boolean.TRUE);
        this.tester.checkFails("select ^'a string' is not true^ from (values (1))", "(?s)Cannot apply 'IS NOT TRUE' to arguments of type '<CHAR\\(8\\)> IS NOT TRUE'. Supported form\\(s\\): '<BOOLEAN> IS NOT TRUE'.*", false);
    }

    @Test
    public void testIsTrueOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_TRUE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("true is true", Boolean.TRUE);
        this.tester.checkBoolean("false is true", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is true", Boolean.FALSE);
    }

    @Test
    public void testIsNotFalseOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("false is not false", Boolean.FALSE);
        this.tester.checkBoolean("true is not false", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not false", Boolean.TRUE);
    }

    @Test
    public void testIsFalseOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_FALSE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("false is false", Boolean.TRUE);
        this.tester.checkBoolean("true is false", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is false", Boolean.FALSE);
    }

    @Test
    public void testIsNotUnknownOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_UNKNOWN, VM_EXPAND);
        this.tester.checkBoolean("false is not unknown", Boolean.TRUE);
        this.tester.checkBoolean("true is not unknown", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as boolean) is not unknown", Boolean.FALSE);
        this.tester.checkBoolean("unknown is not unknown", Boolean.FALSE);
        this.tester.checkFails("^'abc' IS NOT UNKNOWN^", "(?s).*Cannot apply 'IS NOT UNKNOWN'.*", false);
    }

    @Test
    public void testIsUnknownOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_UNKNOWN, VM_EXPAND);
        this.tester.checkBoolean("false is unknown", Boolean.FALSE);
        this.tester.checkBoolean("true is unknown", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as boolean) is unknown", Boolean.TRUE);
        this.tester.checkBoolean("unknown is unknown", Boolean.TRUE);
        this.tester.checkFails("0 = 1 AND ^2 IS UNKNOWN^ AND 3 > 4", "(?s).*Cannot apply 'IS UNKNOWN'.*", false);
    }

    @Test
    public void testIsASetOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_A_SET, VM_EXPAND);
        this.tester.checkBoolean("multiset[1] is a set", Boolean.TRUE);
        this.tester.checkBoolean("multiset[1, 1] is a set", Boolean.FALSE);
        this.tester.checkBoolean("multiset[cast(null as boolean), cast(null as boolean)] is a set", Boolean.FALSE);
        this.tester.checkBoolean("multiset[cast(null as boolean)] is a set", Boolean.TRUE);
        this.tester.checkBoolean("multiset['a'] is a set", Boolean.TRUE);
        this.tester.checkBoolean("multiset['a', 'b'] is a set", Boolean.TRUE);
        this.tester.checkBoolean("multiset['a', 'b', 'a'] is a set", Boolean.FALSE);
    }

    @Test
    public void testIsNotASetOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_A_SET, VM_EXPAND);
        this.tester.checkBoolean("multiset[1] is not a set", Boolean.FALSE);
        this.tester.checkBoolean("multiset[1, 1] is not a set", Boolean.TRUE);
        this.tester.checkBoolean("multiset[cast(null as boolean), cast(null as boolean)] is not a set", Boolean.TRUE);
        this.tester.checkBoolean("multiset[cast(null as boolean)] is not a set", Boolean.FALSE);
        this.tester.checkBoolean("multiset['a'] is not a set", Boolean.FALSE);
        this.tester.checkBoolean("multiset['a', 'b'] is not a set", Boolean.FALSE);
        this.tester.checkBoolean("multiset['a', 'b', 'a'] is not a set", Boolean.TRUE);
    }

    @Test
    public void testIntersectOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT, VM_EXPAND);
        this.tester.checkScalar("multiset[1] multiset intersect multiset[1]", "[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[2] multiset intersect all multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[2] multiset intersect distinct multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[1, 1] multiset intersect distinct multiset[1, 1]", "[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[1, 1] multiset intersect all multiset[1, 1]", "[1, 1]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[1, 1] multiset intersect distinct multiset[1, 1]", "[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[cast(null as integer), cast(null as integer)] multiset intersect distinct multiset[cast(null as integer)]", "[null]", "INTEGER MULTISET NOT NULL");
        this.tester.checkScalar("multiset[cast(null as integer), cast(null as integer)] multiset intersect all multiset[cast(null as integer)]", "[null]", "INTEGER MULTISET NOT NULL");
        this.tester.checkScalar("multiset[cast(null as integer), cast(null as integer)] multiset intersect distinct multiset[cast(null as integer)]", "[null]", "INTEGER MULTISET NOT NULL");
    }

    @Test
    public void testExceptOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT, VM_EXPAND);
        this.tester.checkScalar("multiset[1] multiset except multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[1] multiset except distinct multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[2] multiset except multiset[1]", "[2]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("multiset[1,2,3] multiset except multiset[1]", "[2, 3]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.tester.checkScalar("cardinality(multiset[1,2,3,2] multiset except distinct multiset[1])", "2", "INTEGER NOT NULL");
        this.tester.checkScalar("cardinality(multiset[1,2,3,2] multiset except all multiset[1])", "3", "INTEGER NOT NULL");
        this.tester.checkBoolean("(multiset[1,2,3,2] multiset except distinct multiset[1]) submultiset of multiset[2, 3]", Boolean.TRUE);
        this.tester.checkBoolean("(multiset[1,2,3,2] multiset except distinct multiset[1]) submultiset of multiset[2, 3]", Boolean.TRUE);
        this.tester.checkBoolean("(multiset[1,2,3,2] multiset except all multiset[1]) submultiset of multiset[2, 2, 3]", Boolean.TRUE);
        this.tester.checkBoolean("(multiset[1,2,3] multiset except multiset[1]) is empty", Boolean.FALSE);
        this.tester.checkBoolean("(multiset[1] multiset except multiset[1]) is empty", Boolean.TRUE);
    }

    @Test
    public void testIsEmptyOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_EMPTY, VM_EXPAND);
        this.tester.checkBoolean("multiset[1] is empty", Boolean.FALSE);
    }

    @Test
    public void testIsNotEmptyOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_EMPTY, VM_EXPAND);
        this.tester.checkBoolean("multiset[1] is not empty", Boolean.TRUE);
    }

    @Test
    public void testExistsOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXISTS, VM_EXPAND);
    }

    @Test
    public void testNotOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT, new SqlTester.VmName[0]);
        this.tester.checkBoolean("not true", Boolean.FALSE);
        this.tester.checkBoolean("not false", Boolean.TRUE);
        this.tester.checkBoolean("not unknown", null);
        this.tester.checkNull("not cast(null as boolean)");
    }

    @Test
    public void testPrefixMinusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, new SqlTester.VmName[0]);
        this.tester.checkFails("'a' + ^- 'b'^ + 'c'", "(?s)Cannot apply '-' to arguments of type '-<CHAR\\(1\\)>'.*", false);
        this.tester.checkScalarExact("-1", "-1");
        this.tester.checkScalarExact("-1.23", "DECIMAL(3, 2) NOT NULL", "-1.23");
        this.tester.checkScalarApprox("-1.0e0", "DOUBLE NOT NULL", -1.0, 0.0);
        this.tester.checkNull("-cast(null as integer)");
        this.tester.checkNull("-cast(null as tinyint)");
    }

    @Test
    public void testPrefixMinusOperatorIntervals() {
        this.tester.checkScalar("-interval '-6:2:8' hour to second", "+6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("- -interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("-interval '5' month", "-5", "INTERVAL MONTH NOT NULL");
        this.tester.checkNull("-cast(null as interval day to minute)");
    }

    @Test
    public void testPrefixPlusOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.UNARY_PLUS, VM_EXPAND);
        this.tester.checkScalarExact("+1", "1");
        this.tester.checkScalarExact("+1.23", "DECIMAL(3, 2) NOT NULL", "1.23");
        this.tester.checkScalarApprox("+1.0e0", "DOUBLE NOT NULL", 1.0, 0.0);
        this.tester.checkNull("+cast(null as integer)");
        this.tester.checkNull("+cast(null as tinyint)");
    }

    @Test
    public void testPrefixPlusOperatorIntervals() {
        this.tester.checkScalar("+interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("++interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("+interval '5' month", "+5", "INTERVAL MONTH NOT NULL");
        this.tester.checkNull("+cast(null as interval day to minute)");
    }

    @Test
    public void testExplicitTableOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXPLICIT_TABLE, VM_EXPAND);
    }

    @Test
    public void testValuesOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.VALUES, VM_EXPAND);
        this.tester.check("select 'abc' from (values(true))", (SqlTester.TypeChecker)new SqlTests.StringTypeChecker("CHAR(3) NOT NULL"), "abc", 0.0);
    }

    @Test
    public void testNotLikeOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_LIKE, VM_EXPAND);
        this.tester.checkBoolean("'abc' not like '_b_'", Boolean.FALSE);
        this.tester.checkBoolean("'ab\ncd' not like 'ab%'", Boolean.FALSE);
        this.tester.checkBoolean("'123\n\n45\n' not like '%'", Boolean.FALSE);
        this.tester.checkBoolean("'ab\ncd\nef' not like '%cd%'", Boolean.FALSE);
        this.tester.checkBoolean("'ab\ncd\nef' not like '%cde%'", Boolean.TRUE);
    }

    @Test
    public void testLikeEscape() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LIKE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("'a_c' like 'a#_c' escape '#'", Boolean.TRUE);
        this.tester.checkBoolean("'axc' like 'a#_c' escape '#'", Boolean.FALSE);
        this.tester.checkBoolean("'a_c' like 'a\\_c' escape '\\'", Boolean.TRUE);
        this.tester.checkBoolean("'axc' like 'a\\_c' escape '\\'", Boolean.FALSE);
        this.tester.checkBoolean("'a%c' like 'a\\%c' escape '\\'", Boolean.TRUE);
        this.tester.checkBoolean("'a%cde' like 'a\\%c_e' escape '\\'", Boolean.TRUE);
        this.tester.checkBoolean("'abbc' like 'a%c' escape '\\'", Boolean.TRUE);
        this.tester.checkBoolean("'abbc' like 'a\\%c' escape '\\'", Boolean.FALSE);
    }

    @Ignore(value="[CALCITE-525] Exception-handling in built-in functions")
    @Test
    public void testLikeEscape2() {
        this.tester.checkBoolean("'x' not like 'x' escape 'x'", Boolean.TRUE);
        this.tester.checkBoolean("'xyz' not like 'xyz' escape 'xyz'", Boolean.TRUE);
    }

    @Test
    public void testLikeOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LIKE, new SqlTester.VmName[0]);
        this.tester.checkBoolean("''  like ''", Boolean.TRUE);
        this.tester.checkBoolean("'a' like 'a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' like 'b'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like 'A'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like '_a'", Boolean.FALSE);
        this.tester.checkBoolean("'a' like '%a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' like '%a%'", Boolean.TRUE);
        this.tester.checkBoolean("'a' like 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   like 'a_'", Boolean.TRUE);
        this.tester.checkBoolean("'abc'  like 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' like 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   like '_b'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' like '_d'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' like '%d'", Boolean.TRUE);
        this.tester.checkBoolean("'ab\ncd' like 'ab%'", Boolean.TRUE);
        this.tester.checkBoolean("'abc\ncd' like 'ab%'", Boolean.TRUE);
        this.tester.checkBoolean("'123\n\n45\n' like '%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab\ncd\nef' like '%cd%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab\ncd\nef' like '%cde%'", Boolean.FALSE);
    }

    @Test
    public void testLikeDot() {
        this.tester.checkBoolean("'abc' like 'a.c'", Boolean.FALSE);
        this.tester.checkBoolean("'abcde' like '%c.e'", Boolean.FALSE);
        this.tester.checkBoolean("'abc.e' like '%c.e'", Boolean.TRUE);
    }

    @Test
    public void testNotSimilarToOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_SIMILAR_TO, VM_EXPAND);
        this.tester.checkBoolean("'ab' not similar to 'a_'", false);
        this.tester.checkBoolean("'aabc' not similar to 'ab*c+d'", true);
        this.tester.checkBoolean("'ab' not similar to 'a' || '_'", false);
        this.tester.checkBoolean("'ab' not similar to 'ba_'", true);
        this.tester.checkBoolean("cast(null as varchar(2)) not similar to 'a_'", null);
        this.tester.checkBoolean("cast(null as varchar(3)) not similar to cast(null as char(2))", null);
    }

    @Test
    public void testSimilarToOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SIMILAR_TO, new SqlTester.VmName[0]);
        this.tester.checkBoolean("''  similar to ''", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'b'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to 'A'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to '_a'", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to '%a'", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to '%a%'", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   similar to 'a_'", Boolean.TRUE);
        this.tester.checkBoolean("'abc'  similar to 'a_'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' similar to 'a%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab'   similar to '_b'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' similar to '_d'", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' similar to '%d'", Boolean.TRUE);
        this.tester.checkBoolean("'ab\ncd' similar to 'ab%'", Boolean.TRUE);
        this.tester.checkBoolean("'abc\ncd' similar to 'ab%'", Boolean.TRUE);
        this.tester.checkBoolean("'123\n\n45\n' similar to '%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab\ncd\nef' similar to '%cd%'", Boolean.TRUE);
        this.tester.checkBoolean("'ab\ncd\nef' similar to '%cde%'", Boolean.FALSE);
        this.tester.checkBoolean("'acd'    similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd'   similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'acccd'  similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'abcccd' similar to 'ab*c+d'", Boolean.TRUE);
        this.tester.checkBoolean("'abd'    similar to 'ab*c+d'", Boolean.FALSE);
        this.tester.checkBoolean("'aabc'   similar to 'ab*c+d'", Boolean.FALSE);
        this.tester.checkBoolean("'xy'      similar to 'x(ab|c)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'xccy'    similar to 'x(ab|c)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'xababcy' similar to 'x(ab|c)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'xbcy'    similar to 'x(ab|c)*y'", Boolean.FALSE);
        this.tester.checkBoolean("'xy'      similar to 'x(ab|c)+y'", Boolean.FALSE);
        this.tester.checkBoolean("'xccy'    similar to 'x(ab|c)+y'", Boolean.TRUE);
        this.tester.checkBoolean("'xababcy' similar to 'x(ab|c)+y'", Boolean.TRUE);
        this.tester.checkBoolean("'xbcy'    similar to 'x(ab|c)+y'", Boolean.FALSE);
        this.tester.checkBoolean("'ab' similar to 'a%' ", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a%' ", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' similar to 'a_' ", Boolean.FALSE);
        this.tester.checkBoolean("'abcd' similar to 'a%' ", Boolean.TRUE);
        this.tester.checkBoolean("'1a' similar to '_a' ", Boolean.TRUE);
        this.tester.checkBoolean("'123aXYZ' similar to '%a%'", Boolean.TRUE);
        this.tester.checkBoolean("'123aXYZ' similar to '_%_a%_' ", Boolean.TRUE);
        this.tester.checkBoolean("'xy' similar to '(xy)' ", Boolean.TRUE);
        this.tester.checkBoolean("'abd' similar to '[ab][bcde]d' ", Boolean.TRUE);
        this.tester.checkBoolean("'bdd' similar to '[ab][bcde]d' ", Boolean.TRUE);
        this.tester.checkBoolean("'abd' similar to '[ab]d' ", Boolean.FALSE);
        this.tester.checkBoolean("'cd' similar to '[a-e]d' ", Boolean.TRUE);
        this.tester.checkBoolean("'amy' similar to 'amy|fred' ", Boolean.TRUE);
        this.tester.checkBoolean("'fred' similar to 'amy|fred' ", Boolean.TRUE);
        this.tester.checkBoolean("'mike' similar to 'amy|fred' ", Boolean.FALSE);
        this.tester.checkBoolean("'acd' similar to 'ab*c+d' ", Boolean.TRUE);
        this.tester.checkBoolean("'accccd' similar to 'ab*c+d' ", Boolean.TRUE);
        this.tester.checkBoolean("'abd' similar to 'ab*c+d' ", Boolean.FALSE);
        this.tester.checkBoolean("'aabc' similar to 'ab*c+d' ", Boolean.FALSE);
        this.tester.checkBoolean("'abb' similar to 'a(b{3})' ", Boolean.FALSE);
        this.tester.checkBoolean("'abbb' similar to 'a(b{3})' ", Boolean.TRUE);
        this.tester.checkBoolean("'abbbbb' similar to 'a(b{3})' ", Boolean.FALSE);
        this.tester.checkBoolean("'abbbbb' similar to 'ab{3,6}' ", Boolean.TRUE);
        this.tester.checkBoolean("'abbbbbbbb' similar to 'ab{3,6}' ", Boolean.FALSE);
        this.tester.checkBoolean("'' similar to 'ab?' ", Boolean.FALSE);
        this.tester.checkBoolean("'a' similar to 'ab?' ", Boolean.TRUE);
        this.tester.checkBoolean("'a' similar to 'a(b?)' ", Boolean.TRUE);
        this.tester.checkBoolean("'ab' similar to 'ab?' ", Boolean.TRUE);
        this.tester.checkBoolean("'ab' similar to 'a(b?)' ", Boolean.TRUE);
        this.tester.checkBoolean("'abb' similar to 'ab?' ", Boolean.FALSE);
        this.tester.checkBoolean("'ab' similar to 'a\\_' ESCAPE '\\' ", Boolean.FALSE);
        this.tester.checkBoolean("'ab' similar to 'a\\%' ESCAPE '\\' ", Boolean.FALSE);
        this.tester.checkBoolean("'a_' similar to 'a\\_' ESCAPE '\\' ", Boolean.TRUE);
        this.tester.checkBoolean("'a%' similar to 'a\\%' ESCAPE '\\' ", Boolean.TRUE);
        this.tester.checkBoolean("'a(b{3})' similar to 'a(b{3})' ", Boolean.FALSE);
        this.tester.checkBoolean("'a(b{3})' similar to 'a\\(b\\{3\\}\\)' ESCAPE '\\' ", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[a-ey]d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[^a-ey]d'", Boolean.FALSE);
        this.tester.checkBoolean("'yd' similar to '[^a-ex-z]d'", Boolean.FALSE);
        this.tester.checkBoolean("'yd' similar to '[a-ex-z]d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[x-za-e]d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to '[^a-ey]?d'", Boolean.FALSE);
        this.tester.checkBoolean("'yyyd' similar to '[a-ey]*d'", Boolean.TRUE);
        this.tester.checkBoolean("'yd' similar to 'x-zd'", Boolean.FALSE);
        this.tester.checkBoolean("'y' similar to 'x-z'", Boolean.FALSE);
        this.tester.checkBoolean("'cd' similar to '([a-e])d'", Boolean.TRUE);
        this.tester.checkBoolean("'xy' similar to 'x*?y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to 'x*?y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to '(x?)*y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to 'x+?y'", Boolean.FALSE);
        this.tester.checkBoolean("'y' similar to 'x?+y'", Boolean.TRUE);
        this.tester.checkBoolean("'y' similar to 'x*+y'", Boolean.TRUE);
        this.tester.checkBoolean("'abc' similar to 'a.c'", Boolean.TRUE);
        this.tester.checkBoolean("'a.c' similar to 'a.c'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' similar to 'a.*d'", Boolean.TRUE);
        this.tester.checkBoolean("'abc' like 'a.c'", Boolean.FALSE);
        this.tester.checkBoolean("'a.c' like 'a.c'", Boolean.TRUE);
        this.tester.checkBoolean("'abcd' like 'a.*d'", Boolean.FALSE);
        if (this.enable) {
            this.tester.checkBoolean("'y' similar to 'x+*y'", Boolean.TRUE);
            this.tester.checkBoolean("'y' similar to 'x?*y'", Boolean.TRUE);
        }
        this.tester.checkFails("'yd' similar to '[x-ze-a]d'", "Illegal character range near index 6\n\\[x-ze-a\\]d\n      \\^", true);
        this.tester.checkFails("'yd3223' similar to '[:LOWER:]{2}[:DIGIT:]{,5}'", "Illegal repetition near index 20\n\\[\\:LOWER\\:\\]\\{2\\}\\[\\:DIGIT\\:\\]\\{,5\\}\n                    \\^", true);
    }

    @Test
    public void testEscapeOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ESCAPE, VM_EXPAND);
    }

    @Test
    public void testConvertFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CONVERT, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testTranslateFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TRANSLATE, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testTranslate3Func() {
        SqlTester tester1 = this.oracleTester();
        tester1.setFor((SqlOperator)OracleSqlOperatorTable.TRANSLATE3, new SqlTester.VmName[0]);
        tester1.checkString("translate('aabbcc', 'ab', '+-')", "++--cc", "VARCHAR(6) NOT NULL");
        tester1.checkString("translate('aabbcc', 'ab', 'ba')", "bbaacc", "VARCHAR(6) NOT NULL");
        tester1.checkString("translate('aabbcc', 'ab', '')", "cc", "VARCHAR(6) NOT NULL");
        tester1.checkString("translate('aabbcc', '', '+-')", "aabbcc", "VARCHAR(6) NOT NULL");
        tester1.checkString("translate(cast('aabbcc' as varchar(10)), 'ab', '+-')", "++--cc", "VARCHAR(10) NOT NULL");
        tester1.checkNull("translate(cast(null as varchar(7)), 'ab', '+-')");
        tester1.checkNull("translate('aabbcc', cast(null as varchar(2)), '+-')");
        tester1.checkNull("translate('aabbcc', 'ab', cast(null as varchar(2)))");
    }

    @Test
    public void testOverlayFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.OVERLAY, new SqlTester.VmName[0]);
        this.tester.checkString("overlay('ABCdef' placing 'abc' from 1)", "abcdef", "VARCHAR(9) NOT NULL");
        this.tester.checkString("overlay('ABCdef' placing 'abc' from 1 for 2)", "abcCdef", "VARCHAR(9) NOT NULL");
        if (this.enable) {
            this.tester.checkString("overlay(cast('ABCdef' as varchar(10)) placing cast('abc' as char(5)) from 1 for 2)", "abc  Cdef", "VARCHAR(15) NOT NULL");
        }
        if (this.enable) {
            this.tester.checkString("overlay(cast('ABCdef' as char(10)) placing cast('abc' as char(5)) from 1 for 2)", "abc  Cdef    ", "VARCHAR(15) NOT NULL");
        }
        this.tester.checkNull("overlay('ABCdef' placing 'abc' from 1 for cast(null as integer))");
        this.tester.checkNull("overlay(cast(null as varchar(1)) placing 'abc' from 1)");
        this.tester.checkString("overlay(x'ABCdef' placing x'abcd' from 1)", "abcdef", "VARBINARY(5) NOT NULL");
        this.tester.checkString("overlay(x'ABCDEF1234' placing x'2345' from 1 for 2)", "2345ef1234", "VARBINARY(7) NOT NULL");
        if (this.enable) {
            this.tester.checkString("overlay(cast(x'ABCdef' as varbinary(5)) placing cast(x'abcd' as binary(3)) from 1 for 2)", "abc  Cdef", "VARBINARY(8) NOT NULL");
        }
        if (this.enable) {
            this.tester.checkString("overlay(cast(x'ABCdef' as binary(5)) placing cast(x'abcd' as binary(3)) from 1 for 2)", "abc  Cdef    ", "VARBINARY(8) NOT NULL");
        }
        this.tester.checkNull("overlay(x'ABCdef' placing x'abcd' from 1 for cast(null as integer))");
        this.tester.checkNull("overlay(cast(null as varbinary(1)) placing x'abcd' from 1)");
        this.tester.checkNull("overlay(x'abcd' placing x'abcd' from cast(null as integer))");
    }

    @Test
    public void testPositionFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.POSITION, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("position('b' in 'abc')", "2");
        this.tester.checkScalarExact("position('' in 'abc')", "1");
        this.tester.checkScalarExact("position('b' in 'abcabc' FROM 3)", "5");
        this.tester.checkScalarExact("position('b' in 'abcabc' FROM 5)", "5");
        this.tester.checkScalarExact("position('b' in 'abcabc' FROM 6)", "0");
        this.tester.checkScalarExact("position('b' in 'abcabc' FROM -5)", "0");
        this.tester.checkScalarExact("position('' in 'abc' FROM 3)", "3");
        this.tester.checkScalarExact("position('' in 'abc' FROM 10)", "0");
        this.tester.checkScalarExact("position(x'bb' in x'aabbcc')", "2");
        this.tester.checkScalarExact("position(x'' in x'aabbcc')", "1");
        this.tester.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM 3)", "5");
        this.tester.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM 5)", "5");
        this.tester.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM 6)", "0");
        this.tester.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM -5)", "0");
        this.tester.checkScalarExact("position(x'cc' in x'aabbccdd' FROM 2)", "3");
        this.tester.checkScalarExact("position(x'' in x'aabbcc' FROM 3)", "3");
        this.tester.checkScalarExact("position(x'' in x'aabbcc' FROM 10)", "0");
        this.tester.checkScalarExact("position('tra' in 'fdgjklewrtra')", "10");
        this.tester.checkNull("position(cast(null as varchar(1)) in '0010')");
        this.tester.checkNull("position('a' in cast(null as varchar(1)))");
        this.tester.checkScalar("position(cast('a' as char) in cast('bca' as varchar))", 3, "INTEGER NOT NULL");
    }

    @Test
    public void testReplaceFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.REPLACE, new SqlTester.VmName[0]);
        this.tester.checkString("REPLACE('ciao', 'ciao', '')", "", "VARCHAR(4) NOT NULL");
        this.tester.checkString("REPLACE('hello world', 'o', '')", "hell wrld", "VARCHAR(11) NOT NULL");
        this.tester.checkNull("REPLACE(cast(null as varchar(5)), 'ciao', '')");
        this.tester.checkNull("REPLACE('ciao', cast(null as varchar(3)), 'zz')");
        this.tester.checkNull("REPLACE('ciao', 'bella', cast(null as varchar(3)))");
    }

    @Test
    public void testCharLengthFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("char_length('abc')", "3");
        this.tester.checkNull("char_length(cast(null as varchar(1)))");
    }

    @Test
    public void testCharacterLengthFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("CHARACTER_LENGTH('abc')", "3");
        this.tester.checkNull("CHARACTER_LENGTH(cast(null as varchar(1)))");
    }

    @Test
    public void testUpperFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.UPPER, new SqlTester.VmName[0]);
        this.tester.checkString("upper('a')", "A", "CHAR(1) NOT NULL");
        this.tester.checkString("upper('A')", "A", "CHAR(1) NOT NULL");
        this.tester.checkString("upper('1')", "1", "CHAR(1) NOT NULL");
        this.tester.checkString("upper('aa')", "AA", "CHAR(2) NOT NULL");
        this.tester.checkNull("upper(cast(null as varchar(1)))");
    }

    @Test
    public void testJsonExists() {
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo' false on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo' true on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo' unknown on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo' false on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo' true on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo' unknown on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{}', 'invalid $.foo' false on error)", Boolean.FALSE);
        this.tester.checkBoolean("json_exists('{}', 'invalid $.foo' true on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{}', 'invalid $.foo' unknown on error)", null);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo1' false on error)", Boolean.FALSE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo1' true on error)", Boolean.TRUE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo1' unknown on error)", null);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' true on error)", Boolean.FALSE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' false on error)", Boolean.FALSE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' error on error)", Boolean.FALSE);
        this.tester.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' unknown on error)", Boolean.FALSE);
    }

    @Test
    public void testJsonValue() {
        this.tester.checkString("json_value('{\"foo\":100}', 'strict $.foo')", "100", "VARCHAR(2000)");
        this.tester.checkScalar("json_value('{\"foo\":100}', 'strict $.foo' returning integer)", 100, "INTEGER");
        this.tester.checkFails("json_value('{\"foo\":\"100\"}', 'strict $.foo' returning boolean)", INVALID_CHAR_MESSAGE, true);
        this.tester.checkScalar("json_value('{\"foo\":100}', 'lax $.foo1' returning integer null on empty)", null, "INTEGER");
        this.tester.checkScalar("json_value('{\"foo\":\"100\"}', 'strict $.foo1' returning boolean null on error)", null, "BOOLEAN");
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo' null on empty)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo' error on empty)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo' default 'empty' on empty)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo1' null on empty)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_value('{\"foo\":100}', 'lax $.foo1' error on empty)", "(?s).*Empty result of JSON_VALUE function is not allowed.*", true);
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo1' default 'empty' on empty)", "empty", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":{}}', 'lax $.foo' null on empty)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_value('{\"foo\":{}}', 'lax $.foo' error on empty)", "(?s).*Empty result of JSON_VALUE function is not allowed.*", true);
        this.tester.checkString("json_value('{\"foo\":{}}', 'lax $.foo' default 'empty' on empty)", "empty", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo' null on error)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo' error on error)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'lax $.foo' default 'empty' on error)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'invalid $.foo' null on error)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_value('{\"foo\":100}', 'invalid $.foo' error on error)", "(?s).*Illegal jsonpath spec.*", true);
        this.tester.checkString("json_value('{\"foo\":100}', 'invalid $.foo' default 'empty' on error)", "empty", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'strict $.foo' null on empty)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'strict $.foo' error on empty)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'strict $.foo' default 'empty' on empty)", "100", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":100}', 'strict $.foo1' null on error)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_value('{\"foo\":100}', 'strict $.foo1' error on error)", "(?s).*No results for path: \\$\\['foo1'\\].*", true);
        this.tester.checkString("json_value('{\"foo\":100}', 'strict $.foo1' default 'empty' on error)", "empty", "VARCHAR(2000)");
        this.tester.checkString("json_value('{\"foo\":{}}', 'strict $.foo' null on error)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_value('{\"foo\":{}}', 'strict $.foo' error on error)", "(?s).*Strict jsonpath mode requires scalar value, and the actual value is: '\\{\\}'.*", true);
        this.tester.checkString("json_value('{\"foo\":{}}', 'strict $.foo' default 'empty' on error)", "empty", "VARCHAR(2000)");
    }

    @Test
    public void testJsonQuery() {
        this.tester.checkString("json_query('{\"foo\":100}', 'lax $' null on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'lax $' error on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'lax $' empty array on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'lax $' empty object on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'lax $.foo' null on empty)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_query('{\"foo\":100}', 'lax $.foo' error on empty)", "(?s).*Empty result of JSON_QUERY function is not allowed.*", true);
        this.tester.checkString("json_query('{\"foo\":100}', 'lax $.foo' empty array on empty)", "[]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'lax $.foo' empty object on empty)", "{}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'invalid $.foo' null on error)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_query('{\"foo\":100}', 'invalid $.foo' error on error)", "(?s).*Illegal jsonpath spec.*", true);
        this.tester.checkString("json_query('{\"foo\":100}', 'invalid $.foo' empty array on error)", "[]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'invalid $.foo' empty object on error)", "{}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $' null on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $' error on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $' empty array on error)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $' empty object on error)", "{\"foo\":100}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo1' null on error)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_query('{\"foo\":100}', 'strict $.foo1' error on error)", "(?s).*No results for path: \\$\\['foo1'\\].*", true);
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo1' empty array on error)", "[]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo1' empty object on error)", "{}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' null on error)", null, "VARCHAR(2000)");
        this.tester.checkFails("json_query('{\"foo\":100}', 'strict $.foo' error on error)", "(?s).*Strict jsonpath mode requires array or object value, and the actual value is: '100'.*", true);
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' empty array on error)", "[]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' empty object on error)", "{}", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' without wrapper)", null, "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' without array wrapper)", null, "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' with wrapper)", "[100]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' with unconditional wrapper)", "[100]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":100}', 'strict $.foo' with conditional wrapper)", "[100]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' without wrapper)", "[100]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' without array wrapper)", "[100]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' with wrapper)", "[[100]]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' with unconditional wrapper)", "[[100]]", "VARCHAR(2000)");
        this.tester.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' with conditional wrapper)", "[100]", "VARCHAR(2000)");
    }

    @Test
    public void testJsonObject() {
        this.tester.checkString("json_object()", "{}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': 'bar')", "{\"foo\":\"bar\"}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': 'bar', 'foo2': 'bar2')", "{\"foo\":\"bar\",\"foo2\":\"bar2\"}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': null)", "{\"foo\":null}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': null null on null)", "{\"foo\":null}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': null absent on null)", "{}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': 100)", "{\"foo\":100}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': json_object('foo': 'bar'))", "{\"foo\":\"{\\\"foo\\\":\\\"bar\\\"}\"}", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_object('foo': json_object('foo': 'bar') format json)", "{\"foo\":{\"foo\":\"bar\"}}", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testJsonObjectAgg() {
        this.checkAggType(this.tester, "json_objectagg('foo': 'bar')", "VARCHAR(2000) NOT NULL");
        this.tester.checkFails("^json_objectagg(100: 'bar')^", "(?s).*Cannot apply.*", false);
        String[][] values = new String[][]{{"'foo'", "'bar'"}, {"'foo2'", "cast(null as varchar(2000))"}, {"'foo3'", "'bar3'"}};
        this.tester.checkAggWithMultipleArgs("json_objectagg(x: x2)", values, "{\"foo\":\"bar\",\"foo2\":null,\"foo3\":\"bar3\"}", 0.0);
        this.tester.checkAggWithMultipleArgs("json_objectagg(x: x2 null on null)", values, "{\"foo\":\"bar\",\"foo2\":null,\"foo3\":\"bar3\"}", 0.0);
        this.tester.checkAggWithMultipleArgs("json_objectagg(x: x2 absent on null)", values, "{\"foo\":\"bar\",\"foo3\":\"bar3\"}", 0.0);
    }

    @Test
    public void testJsonArray() {
        this.tester.checkString("json_array()", "[]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array('foo')", "[\"foo\"]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array('foo', 'bar')", "[\"foo\",\"bar\"]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array(null)", "[]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array(null null on null)", "[null]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array(null absent on null)", "[]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array(100)", "[100]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array(json_array('foo'))", "[\"[\\\"foo\\\"]\"]", "VARCHAR(2000) NOT NULL");
        this.tester.checkString("json_array(json_array('foo') format json)", "[[\"foo\"]]", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testJsonArrayAgg() {
        this.checkAggType(this.tester, "json_arrayagg('foo')", "VARCHAR(2000) NOT NULL");
        String[] values = new String[]{"'foo'", "cast(null as varchar(2000))", "'foo3'"};
        this.tester.checkAgg("json_arrayagg(x)", values, "[\"foo\",\"foo3\"]", 0.0);
        this.tester.checkAgg("json_arrayagg(x null on null)", values, "[\"foo\",null,\"foo3\"]", 0.0);
        this.tester.checkAgg("json_arrayagg(x absent on null)", values, "[\"foo\",\"foo3\"]", 0.0);
    }

    @Test
    public void testJsonPredicate() {
        this.tester.checkBoolean("'{}' is json value", true);
        this.tester.checkBoolean("'{]' is json value", false);
        this.tester.checkBoolean("'{}' is json object", true);
        this.tester.checkBoolean("'[]' is json object", false);
        this.tester.checkBoolean("'{}' is json array", false);
        this.tester.checkBoolean("'[]' is json array", true);
        this.tester.checkBoolean("'100' is json scalar", true);
        this.tester.checkBoolean("'[]' is json scalar", false);
        this.tester.checkBoolean("'{}' is not json value", false);
        this.tester.checkBoolean("'{]' is not json value", true);
        this.tester.checkBoolean("'{}' is not json object", false);
        this.tester.checkBoolean("'[]' is not json object", true);
        this.tester.checkBoolean("'{}' is not json array", true);
        this.tester.checkBoolean("'[]' is not json array", false);
        this.tester.checkBoolean("'100' is not json scalar", false);
        this.tester.checkBoolean("'[]' is not json scalar", true);
    }

    @Test
    public void testLowerFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOWER, new SqlTester.VmName[0]);
        this.tester.checkString("lower('A')", "a", "CHAR(1) NOT NULL");
        this.tester.checkString("lower('a')", "a", "CHAR(1) NOT NULL");
        this.tester.checkString("lower('1')", "1", "CHAR(1) NOT NULL");
        this.tester.checkString("lower('AA')", "aa", "CHAR(2) NOT NULL");
        this.tester.checkNull("lower(cast(null as varchar(1)))");
    }

    @Test
    public void testInitcapFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.INITCAP, VM_FENNEL);
        this.tester.checkString("initcap('aA')", "Aa", "CHAR(2) NOT NULL");
        this.tester.checkString("initcap('Aa')", "Aa", "CHAR(2) NOT NULL");
        this.tester.checkString("initcap('1a')", "1a", "CHAR(2) NOT NULL");
        this.tester.checkString("initcap('ab cd Ef 12')", "Ab Cd Ef 12", "CHAR(11) NOT NULL");
        this.tester.checkNull("initcap(cast(null as varchar(1)))");
        this.tester.checkFails("^initcap(cast(null as date))^", "Cannot apply 'INITCAP' to arguments of type 'INITCAP\\(<DATE>\\)'\\. Supported form\\(s\\): 'INITCAP\\(<CHARACTER>\\)'", false);
    }

    @Test
    public void testPowerFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.POWER, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("power(2,-2)", "DOUBLE NOT NULL", 0.25, 0.0);
        this.tester.checkNull("power(cast(null as integer),2)");
        this.tester.checkNull("power(2,cast(null as double))");
        this.tester.checkFails("^pow(2,-2)^", "No match found for function signature POW\\(<NUMERIC>, <NUMERIC>\\)", false);
    }

    @Test
    public void testSqrtFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SQRT, SqlTester.VmName.EXPAND);
        this.tester.checkType("sqrt(2)", "DOUBLE NOT NULL");
        this.tester.checkType("sqrt(cast(2 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("sqrt(case when false then 2 else null end)", "DOUBLE");
        this.tester.checkFails("^sqrt('abc')^", "Cannot apply 'SQRT' to arguments of type 'SQRT\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'SQRT\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("sqrt(2)", "DOUBLE NOT NULL", 1.4142, 1.0E-4);
        this.tester.checkScalarApprox("sqrt(cast(2 as decimal(2, 0)))", "DOUBLE NOT NULL", 1.4142, 1.0E-4);
        this.tester.checkNull("sqrt(cast(null as integer))");
        this.tester.checkNull("sqrt(cast(null as double))");
    }

    @Test
    public void testExpFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXP, VM_FENNEL);
        this.tester.checkScalarApprox("exp(2)", "DOUBLE NOT NULL", 7.389056, 1.0E-6);
        this.tester.checkScalarApprox("exp(-2)", "DOUBLE NOT NULL", 0.1353, 1.0E-4);
        this.tester.checkNull("exp(cast(null as integer))");
        this.tester.checkNull("exp(cast(null as double))");
    }

    @Test
    public void testModFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MOD, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("mod(4,2)", "0");
        this.tester.checkScalarExact("mod(8,5)", "3");
        this.tester.checkScalarExact("mod(-12,7)", "-5");
        this.tester.checkScalarExact("mod(-12,-7)", "-5");
        this.tester.checkScalarExact("mod(12,-7)", "5");
        this.tester.checkScalarExact("mod(cast(12 as tinyint), cast(-7 as tinyint))", "TINYINT NOT NULL", "5");
    }

    @Test
    public void testModFuncNull() {
        this.tester.checkNull("mod(cast(null as integer),2)");
        this.tester.checkNull("mod(4,cast(null as tinyint))");
    }

    @Test
    public void testModFuncDivByZero() {
        this.tester.checkFails("mod(3,case 'a' when 'a' then 0 end)", DIVISION_BY_ZERO_MESSAGE, true);
    }

    @Test
    public void testLnFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LN, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("ln(2.71828)", "DOUBLE NOT NULL", 1.0, 1.0E-6);
        this.tester.checkScalarApprox("ln(2.71828)", "DOUBLE NOT NULL", 0.999999327, 1.0E-7);
        this.tester.checkNull("ln(cast(null as tinyint))");
    }

    @Test
    public void testLogFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOG10, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("log10(10)", "DOUBLE NOT NULL", 1.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(100.0)", "DOUBLE NOT NULL", 2.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(cast(10e8 as double))", "DOUBLE NOT NULL", 9.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(cast(10e2 as float))", "DOUBLE NOT NULL", 3.0, 1.0E-6);
        this.tester.checkScalarApprox("log10(cast(10e-3 as real))", "DOUBLE NOT NULL", -2.0, 1.0E-6);
        this.tester.checkNull("log10(cast(null as real))");
    }

    @Test
    public void testRandFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.RAND, new SqlTester.VmName[0]);
        this.tester.checkFails("^rand^", "Column 'RAND' not found in any table", false);
        for (int i = 0; i < 100; ++i) {
            this.tester.checkScalarApprox("rand()", "DOUBLE NOT NULL", 0.5, 0.5);
        }
    }

    @Test
    public void testRandSeedFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.RAND, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("rand(1)", "DOUBLE NOT NULL", 0.6016, 1.0E-4);
        this.tester.checkScalarApprox("rand(2)", "DOUBLE NOT NULL", 0.4728, 1.0E-4);
    }

    @Test
    public void testRandIntegerFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.RAND_INTEGER, new SqlTester.VmName[0]);
        for (int i = 0; i < 100; ++i) {
            this.tester.checkScalarApprox("rand_integer(11)", "INTEGER NOT NULL", 5.0, 5.0);
        }
    }

    @Test
    public void testRandIntegerSeedFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.RAND_INTEGER, new SqlTester.VmName[0]);
        this.tester.checkScalar("rand_integer(1, 11)", 4, "INTEGER NOT NULL");
        this.tester.checkScalar("rand_integer(2, 11)", 1, "INTEGER NOT NULL");
    }

    @Test
    public void testAbsFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ABS, new SqlTester.VmName[0]);
        this.tester.checkScalarExact("abs(-1)", "1");
        this.tester.checkScalarExact("abs(cast(10 as TINYINT))", "TINYINT NOT NULL", "10");
        this.tester.checkScalarExact("abs(cast(-20 as SMALLINT))", "SMALLINT NOT NULL", "20");
        this.tester.checkScalarExact("abs(cast(-100 as INT))", "INTEGER NOT NULL", "100");
        this.tester.checkScalarExact("abs(cast(1000 as BIGINT))", "BIGINT NOT NULL", "1000");
        this.tester.checkScalarExact("abs(54.4)", "DECIMAL(3, 1) NOT NULL", "54.4");
        this.tester.checkScalarExact("abs(-54.4)", "DECIMAL(3, 1) NOT NULL", "54.4");
        this.tester.checkScalarApprox("abs(-9.32E-2)", "DOUBLE NOT NULL", 0.0932, 0.0);
        this.tester.checkScalarApprox("abs(cast(-3.5 as double))", "DOUBLE NOT NULL", 3.5, 0.0);
        this.tester.checkScalarApprox("abs(cast(-3.5 as float))", "FLOAT NOT NULL", 3.5, 0.0);
        this.tester.checkScalarApprox("abs(cast(3.5 as real))", "REAL NOT NULL", 3.5, 0.0);
        this.tester.checkNull("abs(cast(null as double))");
    }

    @Test
    public void testAbsFuncIntervals() {
        this.tester.checkScalar("abs(interval '-2' day)", "+2", "INTERVAL DAY NOT NULL");
        this.tester.checkScalar("abs(interval '-5-03' year to month)", "+5-03", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("abs(cast(null as interval hour))");
    }

    @Test
    public void testAcosFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ACOS, new SqlTester.VmName[0]);
        this.tester.checkType("acos(0)", "DOUBLE NOT NULL");
        this.tester.checkType("acos(cast(1 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("acos(case when false then 0.5 else null end)", "DOUBLE");
        this.tester.checkFails("^acos('abc')^", "Cannot apply 'ACOS' to arguments of type 'ACOS\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ACOS\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("acos(0.5)", "DOUBLE NOT NULL", 1.0472, 1.0E-4);
        this.tester.checkScalarApprox("acos(cast(0.5 as decimal(1, 1)))", "DOUBLE NOT NULL", 1.0472, 1.0E-4);
        this.tester.checkNull("acos(cast(null as integer))");
        this.tester.checkNull("acos(cast(null as double))");
    }

    @Test
    public void testAsinFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ASIN, new SqlTester.VmName[0]);
        this.tester.checkType("asin(0)", "DOUBLE NOT NULL");
        this.tester.checkType("asin(cast(1 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("asin(case when false then 0.5 else null end)", "DOUBLE");
        this.tester.checkFails("^asin('abc')^", "Cannot apply 'ASIN' to arguments of type 'ASIN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ASIN\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("asin(0.5)", "DOUBLE NOT NULL", 0.5236, 1.0E-4);
        this.tester.checkScalarApprox("asin(cast(0.5 as decimal(1, 1)))", "DOUBLE NOT NULL", 0.5236, 1.0E-4);
        this.tester.checkNull("asin(cast(null as integer))");
        this.tester.checkNull("asin(cast(null as double))");
    }

    @Test
    public void testAtanFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ATAN, new SqlTester.VmName[0]);
        this.tester.checkType("atan(2)", "DOUBLE NOT NULL");
        this.tester.checkType("atan(cast(2 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("atan(case when false then 2 else null end)", "DOUBLE");
        this.tester.checkFails("^atan('abc')^", "Cannot apply 'ATAN' to arguments of type 'ATAN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ATAN\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("atan(2)", "DOUBLE NOT NULL", 1.1071, 1.0E-4);
        this.tester.checkScalarApprox("atan(cast(2 as decimal(1, 0)))", "DOUBLE NOT NULL", 1.1071, 1.0E-4);
        this.tester.checkNull("atan(cast(null as integer))");
        this.tester.checkNull("atan(cast(null as double))");
    }

    @Test
    public void testAtan2Func() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ATAN2, new SqlTester.VmName[0]);
        this.tester.checkType("atan2(2, -2)", "DOUBLE NOT NULL");
        this.tester.checkScalarApprox("atan2(cast(1 as float), -1)", "DOUBLE NOT NULL", 2.3562, 1.0E-4);
        this.tester.checkType("atan2(case when false then 0.5 else null end, -1)", "DOUBLE");
        this.tester.checkFails("^atan2('abc', 'def')^", "Cannot apply 'ATAN2' to arguments of type 'ATAN2\\(<CHAR\\(3\\)>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ATAN2\\(<NUMERIC>, <NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("atan2(0.5, -0.5)", "DOUBLE NOT NULL", 2.3562, 1.0E-4);
        this.tester.checkScalarApprox("atan2(cast(0.5 as decimal(1, 1)), cast(-0.5 as decimal(1, 1)))", "DOUBLE NOT NULL", 2.3562, 1.0E-4);
        this.tester.checkNull("atan2(cast(null as integer), -1)");
        this.tester.checkNull("atan2(1, cast(null as double))");
    }

    @Test
    public void testCosFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COS, new SqlTester.VmName[0]);
        this.tester.checkType("cos(1)", "DOUBLE NOT NULL");
        this.tester.checkType("cos(cast(1 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("cos(case when false then 1 else null end)", "DOUBLE");
        this.tester.checkFails("^cos('abc')^", "Cannot apply 'COS' to arguments of type 'COS\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'COS\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("cos(1)", "DOUBLE NOT NULL", 0.5403, 1.0E-4);
        this.tester.checkScalarApprox("cos(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", 0.5403, 1.0E-4);
        this.tester.checkNull("cos(cast(null as integer))");
        this.tester.checkNull("cos(cast(null as double))");
    }

    @Test
    public void testCotFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COT, new SqlTester.VmName[0]);
        this.tester.checkType("cot(1)", "DOUBLE NOT NULL");
        this.tester.checkType("cot(cast(1 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("cot(case when false then 1 else null end)", "DOUBLE");
        this.tester.checkFails("^cot('abc')^", "Cannot apply 'COT' to arguments of type 'COT\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'COT\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("cot(1)", "DOUBLE NOT NULL", 0.6421, 1.0E-4);
        this.tester.checkScalarApprox("cot(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", 0.6421, 1.0E-4);
        this.tester.checkNull("cot(cast(null as integer))");
        this.tester.checkNull("cot(cast(null as double))");
    }

    @Test
    public void testDegreesFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DEGREES, new SqlTester.VmName[0]);
        this.tester.checkType("degrees(1)", "DOUBLE NOT NULL");
        this.tester.checkType("degrees(cast(1 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("degrees(case when false then 1 else null end)", "DOUBLE");
        this.tester.checkFails("^degrees('abc')^", "Cannot apply 'DEGREES' to arguments of type 'DEGREES\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'DEGREES\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("degrees(1)", "DOUBLE NOT NULL", 57.2958, 1.0E-4);
        this.tester.checkScalarApprox("degrees(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", 57.2958, 1.0E-4);
        this.tester.checkNull("degrees(cast(null as integer))");
        this.tester.checkNull("degrees(cast(null as double))");
    }

    @Test
    public void testPiFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PI, new SqlTester.VmName[0]);
        this.tester.checkScalarApprox("PI", "DOUBLE NOT NULL", 3.1415, 1.0E-4);
        this.tester.checkFails("^PI()^", "No match found for function signature PI\\(\\)", false);
    }

    @Test
    public void testRadiansFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.RADIANS, new SqlTester.VmName[0]);
        this.tester.checkType("radians(42)", "DOUBLE NOT NULL");
        this.tester.checkType("radians(cast(42 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("radians(case when false then 42 else null end)", "DOUBLE");
        this.tester.checkFails("^radians('abc')^", "Cannot apply 'RADIANS' to arguments of type 'RADIANS\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'RADIANS\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("radians(42)", "DOUBLE NOT NULL", 0.733, 1.0E-4);
        this.tester.checkScalarApprox("radians(cast(42 as decimal(2, 0)))", "DOUBLE NOT NULL", 0.733, 1.0E-4);
        this.tester.checkNull("radians(cast(null as integer))");
        this.tester.checkNull("radians(cast(null as double))");
    }

    @Test
    public void testRoundFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ROUND, new SqlTester.VmName[0]);
        this.tester.checkType("round(42, -1)", "INTEGER NOT NULL");
        this.tester.checkType("round(cast(42 as float), 1)", "FLOAT NOT NULL");
        this.tester.checkType("round(case when false then 42 else null end, -1)", "INTEGER");
        this.tester.checkFails("^round('abc', 'def')^", "Cannot apply 'ROUND' to arguments of type 'ROUND\\(<CHAR\\(3\\)>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ROUND\\(<NUMERIC>, <INTEGER>\\)'", false);
        this.tester.checkScalar("round(42, -1)", 40, "INTEGER NOT NULL");
        this.tester.checkScalar("round(cast(42.346 as decimal(2, 3)), 2)", BigDecimal.valueOf(4235L, 2), "DECIMAL(2, 3) NOT NULL");
        this.tester.checkScalar("round(cast(-42.346 as decimal(2, 3)), 2)", BigDecimal.valueOf(-4235L, 2), "DECIMAL(2, 3) NOT NULL");
        this.tester.checkNull("round(cast(null as integer), 1)");
        this.tester.checkNull("round(cast(null as double), 1)");
        this.tester.checkNull("round(43.21, cast(null as integer))");
        this.tester.checkNull("round(cast(null as double))");
        this.tester.checkScalar("round(42)", 42, "INTEGER NOT NULL");
        this.tester.checkScalar("round(cast(42.346 as decimal(2, 3)))", BigDecimal.valueOf(42L, 0), "DECIMAL(2, 3) NOT NULL");
        this.tester.checkScalar("round(42.324)", BigDecimal.valueOf(42L, 0), "DECIMAL(5, 3) NOT NULL");
        this.tester.checkScalar("round(42.724)", BigDecimal.valueOf(43L, 0), "DECIMAL(5, 3) NOT NULL");
    }

    @Test
    public void testSignFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SIGN, new SqlTester.VmName[0]);
        this.tester.checkType("sign(1)", "INTEGER NOT NULL");
        this.tester.checkType("sign(cast(1 as float))", "FLOAT NOT NULL");
        this.tester.checkType("sign(case when false then 1 else null end)", "INTEGER");
        this.tester.checkFails("^sign('abc')^", "Cannot apply 'SIGN' to arguments of type 'SIGN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'SIGN\\(<NUMERIC>\\)'", false);
        this.tester.checkScalar("sign(1)", 1, "INTEGER NOT NULL");
        this.tester.checkScalar("sign(cast(-1 as decimal(1, 0)))", BigDecimal.valueOf(-1L), "DECIMAL(1, 0) NOT NULL");
        this.tester.checkScalar("sign(cast(0 as float))", 0.0, "FLOAT NOT NULL");
        this.tester.checkNull("sign(cast(null as integer))");
        this.tester.checkNull("sign(cast(null as double))");
    }

    @Test
    public void testSinFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SIN, new SqlTester.VmName[0]);
        this.tester.checkType("sin(1)", "DOUBLE NOT NULL");
        this.tester.checkType("sin(cast(1 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("sin(case when false then 1 else null end)", "DOUBLE");
        this.tester.checkFails("^sin('abc')^", "Cannot apply 'SIN' to arguments of type 'SIN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'SIN\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("sin(1)", "DOUBLE NOT NULL", 0.8415, 1.0E-4);
        this.tester.checkScalarApprox("sin(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", 0.8415, 1.0E-4);
        this.tester.checkNull("sin(cast(null as integer))");
        this.tester.checkNull("sin(cast(null as double))");
    }

    @Test
    public void testTanFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TAN, new SqlTester.VmName[0]);
        this.tester.checkType("tan(1)", "DOUBLE NOT NULL");
        this.tester.checkType("tan(cast(1 as float))", "DOUBLE NOT NULL");
        this.tester.checkType("tan(case when false then 1 else null end)", "DOUBLE");
        this.tester.checkFails("^tan('abc')^", "Cannot apply 'TAN' to arguments of type 'TAN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'TAN\\(<NUMERIC>\\)'", false);
        this.tester.checkScalarApprox("tan(1)", "DOUBLE NOT NULL", 1.5574, 1.0E-4);
        this.tester.checkScalarApprox("tan(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", 1.5574, 1.0E-4);
        this.tester.checkNull("tan(cast(null as integer))");
        this.tester.checkNull("tan(cast(null as double))");
    }

    @Test
    public void testTruncateFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TRUNCATE, new SqlTester.VmName[0]);
        this.tester.checkType("truncate(42, -1)", "INTEGER NOT NULL");
        this.tester.checkType("truncate(cast(42 as float), 1)", "FLOAT NOT NULL");
        this.tester.checkType("truncate(case when false then 42 else null end, -1)", "INTEGER");
        this.tester.checkFails("^truncate('abc', 'def')^", "Cannot apply 'TRUNCATE' to arguments of type 'TRUNCATE\\(<CHAR\\(3\\)>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'TRUNCATE\\(<NUMERIC>, <INTEGER>\\)'", false);
        this.tester.checkScalar("truncate(42, -1)", 40, "INTEGER NOT NULL");
        this.tester.checkScalar("truncate(cast(42.345 as decimal(2, 3)), 2)", BigDecimal.valueOf(4234L, 2), "DECIMAL(2, 3) NOT NULL");
        this.tester.checkScalar("truncate(cast(-42.345 as decimal(2, 3)), 2)", BigDecimal.valueOf(-4234L, 2), "DECIMAL(2, 3) NOT NULL");
        this.tester.checkNull("truncate(cast(null as integer), 1)");
        this.tester.checkNull("truncate(cast(null as double), 1)");
        this.tester.checkNull("truncate(43.21, cast(null as integer))");
        this.tester.checkScalar("truncate(42)", 42, "INTEGER NOT NULL");
        this.tester.checkScalar("truncate(42.324)", BigDecimal.valueOf(42L, 0), "DECIMAL(5, 3) NOT NULL");
        this.tester.checkScalar("truncate(cast(42.324 as float))", Float.valueOf(42.0f), "FLOAT NOT NULL");
        this.tester.checkScalar("truncate(cast(42.345 as decimal(2, 3)))", BigDecimal.valueOf(42L, 0), "DECIMAL(2, 3) NOT NULL");
        this.tester.checkNull("truncate(cast(null as integer))");
        this.tester.checkNull("truncate(cast(null as double))");
    }

    @Test
    public void testNullifFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NULLIF, VM_EXPAND);
        this.tester.checkNull("nullif(1,1)");
        this.tester.checkScalarExact("nullif(1.5, 13.56)", "DECIMAL(2, 1)", "1.5");
        this.tester.checkScalarExact("nullif(13.56, 1.5)", "DECIMAL(4, 2)", "13.56");
        this.tester.checkScalarExact("nullif(1.5, 3)", "DECIMAL(2, 1)", "1.5");
        this.tester.checkScalarExact("nullif(3, 1.5)", "INTEGER", "3");
        this.tester.checkScalarApprox("nullif(1.5e0, 3e0)", "DOUBLE", 1.5, 0.0);
        this.tester.checkScalarApprox("nullif(1.5, cast(3e0 as REAL))", "DECIMAL(2, 1)", 1.5, 0.0);
        this.tester.checkScalarExact("nullif(3, 1.5e0)", "INTEGER", "3");
        this.tester.checkScalarExact("nullif(3, cast(1.5e0 as REAL))", "INTEGER", "3");
        this.tester.checkScalarApprox("nullif(1.5e0, 3.4)", "DOUBLE", 1.5, 0.0);
        this.tester.checkScalarExact("nullif(3.4, 1.5e0)", "DECIMAL(2, 1)", "3.4");
        this.tester.checkString("nullif('a','bc')", "a", "CHAR(1)");
        this.tester.checkString("nullif('a',cast(null as varchar(1)))", "a", "CHAR(1)");
        this.tester.checkNull("nullif(cast(null as varchar(1)),'a')");
        this.tester.checkNull("nullif(cast(null as numeric(4,3)), 4.3)");
        this.tester.checkFails("1 + ^nullif(1, date '2005-8-4')^ + 2", "(?s)Cannot apply '=' to arguments of type '<INTEGER> = <DATE>'\\..*", false);
        this.tester.checkFails("1 + ^nullif(1, 2, 3)^ + 2", "Invalid number of arguments to function 'NULLIF'\\. Was expecting 2 arguments", false);
    }

    @Test
    public void testNullIfOperatorIntervals() {
        this.tester.checkScalar("nullif(interval '2' month, interval '3' year)", "+2", "INTERVAL MONTH");
        this.tester.checkScalar("nullif(interval '2 5' day to hour, interval '5' second)", "+2 05", "INTERVAL DAY TO HOUR");
        this.tester.checkNull("nullif(interval '3' day, interval '3' day)");
    }

    @Test
    public void testCoalesceFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COALESCE, VM_EXPAND);
        this.tester.checkString("coalesce('a','b')", "a", "CHAR(1) NOT NULL");
        this.tester.checkScalarExact("coalesce(null,null,3)", "3");
        this.tester.checkFails("1 + ^coalesce('a', 'b', 1, null)^ + 2", "Illegal mixing of types in CASE or COALESCE statement", false);
    }

    @Test
    public void testUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.USER, VM_FENNEL);
        this.tester.checkString("USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testCurrentUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_USER, VM_FENNEL);
        this.tester.checkString("CURRENT_USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testSessionUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SESSION_USER, VM_FENNEL);
        this.tester.checkString("SESSION_USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testSystemUserFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SYSTEM_USER, VM_FENNEL);
        String user = System.getProperty("user.name");
        this.tester.checkString("SYSTEM_USER", user, "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testCurrentPathFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_PATH, VM_FENNEL);
        this.tester.checkString("CURRENT_PATH", "", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testCurrentRoleFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_ROLE, VM_FENNEL);
        this.tester.checkString("CURRENT_ROLE", "", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testCurrentCatalogFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_CATALOG, VM_FENNEL);
        this.tester.checkString("CURRENT_CATALOG", "", "VARCHAR(2000) NOT NULL");
    }

    @Test
    public void testLocalTimeFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOCALTIME, new SqlTester.VmName[0]);
        this.tester.checkScalar("LOCALTIME", TIME_PATTERN, "TIME(0) NOT NULL");
        this.tester.checkFails("^LOCALTIME()^", "No match found for function signature LOCALTIME\\(\\)", false);
        this.tester.checkScalar("LOCALTIME(1)", TIME_PATTERN, "TIME(1) NOT NULL");
        Pair<String, Hook.Closeable> pair = SqlOperatorBaseTest.currentTimeString(LOCAL_TZ);
        this.tester.checkScalar("CAST(LOCALTIME AS VARCHAR(30))", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("LOCALTIME", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "TIME(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    @Test
    public void testLocalTimestampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, new SqlTester.VmName[0]);
        this.tester.checkScalar("LOCALTIMESTAMP", TIMESTAMP_PATTERN, "TIMESTAMP(0) NOT NULL");
        this.tester.checkFails("^LOCALTIMESTAMP()^", "No match found for function signature LOCALTIMESTAMP\\(\\)", false);
        this.tester.checkFails("^LOCALTIMESTAMP(4000000000)^", LITERAL_OUT_OF_RANGE_MESSAGE, false);
        this.tester.checkFails("^LOCALTIMESTAMP(9223372036854775807)^", LITERAL_OUT_OF_RANGE_MESSAGE, false);
        this.tester.checkScalar("LOCALTIMESTAMP(1)", TIMESTAMP_PATTERN, "TIMESTAMP(1) NOT NULL");
        Pair<String, Hook.Closeable> pair = SqlOperatorBaseTest.currentTimeString(LOCAL_TZ);
        this.tester.checkScalar("CAST(LOCALTIMESTAMP AS VARCHAR(30))", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("LOCALTIMESTAMP", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "TIMESTAMP(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    @Test
    public void testCurrentTimeFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, new SqlTester.VmName[0]);
        this.tester.checkScalar("CURRENT_TIME", TIME_PATTERN, "TIME(0) NOT NULL");
        this.tester.checkFails("^CURRENT_TIME()^", "No match found for function signature CURRENT_TIME\\(\\)", false);
        this.tester.checkScalar("CURRENT_TIME(1)", TIME_PATTERN, "TIME(1) NOT NULL");
        Pair<String, Hook.Closeable> pair = SqlOperatorBaseTest.currentTimeString(CURRENT_TZ);
        this.tester.checkScalar("CAST(CURRENT_TIME AS VARCHAR(30))", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("CURRENT_TIME", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "TIME(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    @Test
    public void testCurrentTimestampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, new SqlTester.VmName[0]);
        this.tester.checkScalar("CURRENT_TIMESTAMP", TIMESTAMP_PATTERN, "TIMESTAMP(0) NOT NULL");
        this.tester.checkFails("^CURRENT_TIMESTAMP()^", "No match found for function signature CURRENT_TIMESTAMP\\(\\)", false);
        this.tester.checkFails("^CURRENT_TIMESTAMP(4000000000)^", LITERAL_OUT_OF_RANGE_MESSAGE, false);
        this.tester.checkScalar("CURRENT_TIMESTAMP(1)", TIMESTAMP_PATTERN, "TIMESTAMP(1) NOT NULL");
        Pair<String, Hook.Closeable> pair = SqlOperatorBaseTest.currentTimeString(CURRENT_TZ);
        this.tester.checkScalar("CAST(CURRENT_TIMESTAMP AS VARCHAR(30))", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        this.tester.checkScalar("CURRENT_TIMESTAMP", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "TIMESTAMP(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    protected static Pair<String, Hook.Closeable> currentTimeString(TimeZone tz) {
        Hook.Closeable closeable;
        Calendar calendar;
        if (CalciteAssert.ENABLE_SLOW) {
            calendar = SqlOperatorBaseTest.getCalendarNotTooNear(11);
            closeable = () -> {};
        } else {
            calendar = Util.calendar();
            calendar.set(1, 2014);
            calendar.set(2, 8);
            calendar.set(5, 7);
            calendar.set(11, 17);
            calendar.set(12, 8);
            calendar.set(13, 48);
            calendar.set(14, 15);
            long timeInMillis = calendar.getTimeInMillis();
            closeable = Hook.CURRENT_TIME.addThread(o -> o.set((Object)timeInMillis));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:", Locale.ROOT);
        sdf.setTimeZone(tz);
        return Pair.of((Object)sdf.format(calendar.getTime()), (Object)closeable);
    }

    @Test
    public void testCurrentDateFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, VM_FENNEL);
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
        this.tester.checkScalar("CURRENT_DATE", DATE_PATTERN, "DATE NOT NULL");
        this.tester.checkScalar("(CURRENT_DATE - CURRENT_DATE) DAY", "+0", "INTERVAL DAY NOT NULL");
        this.tester.checkBoolean("CURRENT_DATE IS NULL", false);
        this.tester.checkBoolean("CURRENT_DATE IS NOT NULL", true);
        this.tester.checkBoolean("NOT (CURRENT_DATE IS NULL)", true);
        this.tester.checkFails("^CURRENT_DATE()^", "No match found for function signature CURRENT_DATE\\(\\)", false);
        tester1.checkBoolean("CURRENT_DATE() IS NULL", false);
        tester1.checkBoolean("CURRENT_DATE IS NOT NULL", true);
        tester1.checkBoolean("NOT (CURRENT_DATE() IS NULL)", true);
        tester1.checkType("CURRENT_DATE", "DATE NOT NULL");
        tester1.checkType("CURRENT_DATE()", "DATE NOT NULL");
        tester1.checkType("CURRENT_TIMESTAMP()", "TIMESTAMP(0) NOT NULL");
        tester1.checkType("CURRENT_TIME()", "TIME(0) NOT NULL");
        Pair<String, Hook.Closeable> pair = SqlOperatorBaseTest.currentTimeString(LOCAL_TZ);
        String dateString = (String)pair.left;
        try (Hook.Closeable ignore = (Hook.Closeable)pair.right;){
            this.tester.checkScalar("CAST(CURRENT_DATE AS VARCHAR(30))", dateString.substring(0, 10), "VARCHAR(30) NOT NULL");
            this.tester.checkScalar("CURRENT_DATE", dateString.substring(0, 10), "DATE NOT NULL");
            tester1.checkScalar("CAST(CURRENT_DATE AS VARCHAR(30))", dateString.substring(0, 10), "VARCHAR(30) NOT NULL");
            tester1.checkScalar("CAST(CURRENT_DATE() AS VARCHAR(30))", dateString.substring(0, 10), "VARCHAR(30) NOT NULL");
            tester1.checkScalar("CURRENT_DATE", dateString.substring(0, 10), "DATE NOT NULL");
            tester1.checkScalar("CURRENT_DATE()", dateString.substring(0, 10), "DATE NOT NULL");
        }
    }

    @Test
    public void testSubstringFunction() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SUBSTRING, new SqlTester.VmName[0]);
        this.tester.checkString("substring('abc' from 1 for 2)", "ab", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from 2 for 8)", "bc", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from 0 for 2)", "a", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from 0 for 0)", "", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from 8 for 2)", "", "VARCHAR(3) NOT NULL");
        this.tester.checkFails("substring('abc' from 1 for -1)", "Substring error: negative substring length not allowed", true);
        this.tester.checkString("substring('abc' from 2)", "bc", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from 0)", "abc", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from 8)", "", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring('abc' from -2)", "bc", "VARCHAR(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from 1 for 2)", "aabb", "VARBINARY(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from 2 for 8)", "bbcc", "VARBINARY(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from 0 for 2)", "aa", "VARBINARY(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from 0 for 0)", "", "VARBINARY(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from 8 for 2)", "", "VARBINARY(3) NOT NULL");
        this.tester.checkFails("substring(x'aabbcc' from 1 for -1)", "Substring error: negative substring length not allowed", true);
        this.tester.checkString("substring(x'aabbcc' from 2)", "bbcc", "VARBINARY(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from 0)", "aabbcc", "VARBINARY(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from 8)", "", "VARBINARY(3) NOT NULL");
        this.tester.checkString("substring(x'aabbcc' from -2)", "bbcc", "VARBINARY(3) NOT NULL");
        this.tester.checkNull("substring(cast(null as varchar(1)),1,2)");
    }

    @Test
    public void testTrimFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TRIM, new SqlTester.VmName[0]);
        this.tester.checkString("trim('a' from 'aAa')", "A", "VARCHAR(3) NOT NULL");
        this.tester.checkString("trim(both 'a' from 'aAa')", "A", "VARCHAR(3) NOT NULL");
        this.tester.checkString("trim(leading 'a' from 'aAa')", "Aa", "VARCHAR(3) NOT NULL");
        this.tester.checkString("trim(trailing 'a' from 'aAa')", "aA", "VARCHAR(3) NOT NULL");
        this.tester.checkNull("trim(cast(null as varchar(1)) from 'a')");
        this.tester.checkNull("trim('a' from cast(null as varchar(1)))");
        this.tester.checkFails("trim('xy' from 'abcde')", "Trim error: trim character must be exactly 1 character", true);
        this.tester.checkFails("trim('' from 'abcde')", "Trim error: trim character must be exactly 1 character", true);
        SqlTester tester1 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5);
        tester1.checkString("trim(leading 'eh' from 'hehe__hehe')", "__hehe", "VARCHAR(10) NOT NULL");
        tester1.checkString("trim(trailing 'eh' from 'hehe__hehe')", "hehe__", "VARCHAR(10) NOT NULL");
        tester1.checkString("trim('eh' from 'hehe__hehe')", "__", "VARCHAR(10) NOT NULL");
    }

    @Test
    public void testRtrimFunc() {
        this.tester.setFor((SqlOperator)OracleSqlOperatorTable.RTRIM, new SqlTester.VmName[0]);
        SqlTester tester1 = this.oracleTester();
        tester1.checkString("rtrim(' aAa  ')", " aAa", "VARCHAR(6) NOT NULL");
        tester1.checkNull("rtrim(CAST(NULL AS VARCHAR(6)))");
    }

    @Test
    public void testLtrimFunc() {
        this.tester.setFor((SqlOperator)OracleSqlOperatorTable.LTRIM, new SqlTester.VmName[0]);
        SqlTester tester1 = this.oracleTester();
        tester1.checkString("ltrim(' aAa  ')", "aAa  ", "VARCHAR(6) NOT NULL");
        tester1.checkNull("ltrim(CAST(NULL AS VARCHAR(6)))");
    }

    @Test
    public void testGreatestFunc() {
        this.tester.setFor((SqlOperator)OracleSqlOperatorTable.GREATEST, new SqlTester.VmName[0]);
        SqlTester tester1 = this.oracleTester();
        tester1.checkString("greatest('on', 'earth')", "on   ", "CHAR(5) NOT NULL");
        tester1.checkString("greatest('show', 'on', 'earth')", "show ", "CHAR(5) NOT NULL");
        tester1.checkScalar("greatest(12, CAST(NULL AS INTEGER), 3)", null, "INTEGER");
        tester1.checkScalar("greatest(false, true)", true, "BOOLEAN NOT NULL");
        SqlTester tester2 = this.oracleTester((SqlConformance)SqlConformanceEnum.ORACLE_12);
        tester2.checkString("greatest('on', 'earth')", "on", "VARCHAR(5) NOT NULL");
        tester2.checkString("greatest('show', 'on', 'earth')", "show", "VARCHAR(5) NOT NULL");
    }

    @Test
    public void testLeastFunc() {
        this.tester.setFor((SqlOperator)OracleSqlOperatorTable.LEAST, new SqlTester.VmName[0]);
        SqlTester tester1 = this.oracleTester();
        tester1.checkString("least('on', 'earth')", "earth", "CHAR(5) NOT NULL");
        tester1.checkString("least('show', 'on', 'earth')", "earth", "CHAR(5) NOT NULL");
        tester1.checkScalar("least(12, CAST(NULL AS INTEGER), 3)", null, "INTEGER");
        tester1.checkScalar("least(false, true)", false, "BOOLEAN NOT NULL");
        SqlTester tester2 = this.oracleTester((SqlConformance)SqlConformanceEnum.ORACLE_12);
        tester2.checkString("least('on', 'earth')", "earth", "VARCHAR(5) NOT NULL");
        tester2.checkString("least('show', 'on', 'earth')", "earth", "VARCHAR(5) NOT NULL");
    }

    @Test
    public void testNvlFunc() {
        this.tester.setFor((SqlOperator)OracleSqlOperatorTable.NVL, new SqlTester.VmName[0]);
        SqlTester tester1 = this.oracleTester();
        tester1.checkScalar("nvl(1, 2)", "1", "INTEGER NOT NULL");
        tester1.checkFails("^nvl(1, true)^", "Parameters must be of the same type", false);
        tester1.checkScalar("nvl(true, false)", true, "BOOLEAN NOT NULL");
        tester1.checkScalar("nvl(false, true)", false, "BOOLEAN NOT NULL");
        tester1.checkString("nvl('abc', 'de')", "abc", "CHAR(3) NOT NULL");
        tester1.checkString("nvl('abc', 'defg')", "abc ", "CHAR(4) NOT NULL");
        tester1.checkString("nvl('abc', CAST(NULL AS VARCHAR(20)))", "abc", "VARCHAR(20) NOT NULL");
        tester1.checkString("nvl(CAST(NULL AS VARCHAR(20)), 'abc')", "abc", "VARCHAR(20) NOT NULL");
        tester1.checkNull("nvl(CAST(NULL AS VARCHAR(6)), cast(NULL AS VARCHAR(4)))");
        SqlTester tester2 = this.oracleTester((SqlConformance)SqlConformanceEnum.ORACLE_12);
        tester2.checkString("nvl('abc', 'de')", "abc", "VARCHAR(3) NOT NULL");
        tester2.checkString("nvl('abc', 'defg')", "abc", "VARCHAR(4) NOT NULL");
        tester2.checkString("nvl('abc', CAST(NULL AS VARCHAR(20)))", "abc", "VARCHAR(20) NOT NULL");
        tester2.checkString("nvl(CAST(NULL AS VARCHAR(20)), 'abc')", "abc", "VARCHAR(20) NOT NULL");
        tester2.checkNull("nvl(CAST(NULL AS VARCHAR(6)), cast(NULL AS VARCHAR(4)))");
    }

    @Test
    public void testDecodeFunc() {
        this.tester.setFor((SqlOperator)OracleSqlOperatorTable.DECODE, new SqlTester.VmName[0]);
        SqlTester tester1 = this.oracleTester();
        tester1.checkScalar("decode(0, 0, 'a', 1, 'b', 2, 'c')", "a", "CHAR(1)");
        tester1.checkScalar("decode(1, 0, 'a', 1, 'b', 2, 'c')", "b", "CHAR(1)");
        tester1.checkScalar("decode(1, 0, 'a', 1, 'b', 1, 'z', 2, 'c')", "b", "CHAR(1)");
        tester1.checkScalar("decode(3, 0, 'a', 1, 'b', 2, 'c')", null, "CHAR(1)");
        tester1.checkScalar("decode(3, 0, 'a', 1, 'b', 2, 'c', 'd')", "d", "CHAR(1) NOT NULL");
        tester1.checkScalar("decode(1, 0, 'a', 1, 'b', 2, 'c', 'd')", "b", "CHAR(1) NOT NULL");
        tester1.checkScalar("decode(cast(null as integer), 0, 'a',\n cast(null as integer), 'b', 2, 'c', 'd')", "b", "CHAR(1) NOT NULL");
    }

    @Test
    public void testWindow() {
        if (!this.enable) {
            return;
        }
        this.tester.check("select sum(1) over (order by x) from (select 1 as x, 2 as y from (values (true)))", (SqlTester.TypeChecker)new SqlTests.StringTypeChecker("INTEGER"), "1", 0.0);
    }

    @Test
    public void testElementFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ELEMENT, VM_FENNEL, VM_JAVA);
        this.tester.checkString("element(multiset['abc'])", "abc", "CHAR(3) NOT NULL");
        this.tester.checkNull("element(multiset[cast(null as integer)])");
    }

    @Test
    public void testCardinalityFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CARDINALITY, VM_FENNEL, VM_JAVA);
        this.tester.checkScalarExact("cardinality(multiset[cast(null as integer),2])", "2");
        if (!this.enable) {
            return;
        }
        this.tester.checkScalarExact("cardinality(array['foo', 'bar'])", "2");
        this.tester.checkScalarExact("cardinality(map['foo', 1, 'bar', 2])", "2");
    }

    @Test
    public void testMemberOfOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MEMBER_OF, VM_FENNEL, VM_JAVA);
        this.tester.checkBoolean("1 member of multiset[1]", Boolean.TRUE);
        this.tester.checkBoolean("'2' member of multiset['1']", Boolean.FALSE);
        this.tester.checkBoolean("cast(null as double) member of multiset[cast(null as double)]", Boolean.TRUE);
        this.tester.checkBoolean("cast(null as double) member of multiset[1.1]", Boolean.FALSE);
        this.tester.checkBoolean("1.1 member of multiset[cast(null as double)]", Boolean.FALSE);
    }

    @Test
    public void testMultisetUnionOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_UNION_DISTINCT, VM_FENNEL, VM_JAVA);
        this.tester.checkBoolean("multiset[1,2] submultiset of (multiset[2] multiset union multiset[1])", Boolean.TRUE);
        this.tester.checkScalar("cardinality(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8])", "7", "INTEGER NOT NULL");
        this.tester.checkScalar("cardinality(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8])", "7", "INTEGER NOT NULL");
        this.tester.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 2, 3, 4, 5, 7, 8]", Boolean.TRUE);
        this.tester.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 2, 3, 4, 5, 7, 8]", Boolean.TRUE);
        this.tester.checkScalar("cardinality(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e'])", "5", "INTEGER NOT NULL");
        this.tester.checkScalar("cardinality(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e'])", "5", "INTEGER NOT NULL");
        this.tester.checkBoolean("(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e']", Boolean.TRUE);
        this.tester.checkBoolean("(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e']", Boolean.TRUE);
        this.tester.checkScalar("multiset[cast(null as double)] multiset union multiset[cast(null as double)]", "[null, null]", "DOUBLE MULTISET NOT NULL");
        this.tester.checkScalar("multiset[cast(null as boolean)] multiset union multiset[cast(null as boolean)]", "[null, null]", "BOOLEAN MULTISET NOT NULL");
    }

    @Test
    public void testMultisetUnionAllOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_UNION, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("cardinality(multiset[1, 2, 3, 4, 2] multiset union all multiset[1, 4, 5, 7, 8])", "10", "INTEGER NOT NULL");
        this.tester.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union all multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 2, 3, 4, 5, 7, 8]", Boolean.FALSE);
        this.tester.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union all multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 1, 2, 2, 3, 4, 4, 5, 7, 8]", Boolean.TRUE);
        this.tester.checkScalar("cardinality(multiset['a', 'b', 'c'] multiset union all multiset['c', 'd', 'e'])", "6", "INTEGER NOT NULL");
        this.tester.checkBoolean("(multiset['a', 'b', 'c'] multiset union all multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e']", Boolean.FALSE);
        this.tester.checkBoolean("(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e', 'c']", Boolean.TRUE);
        this.tester.checkScalar("multiset[cast(null as double)] multiset union all multiset[cast(null as double)]", "[null, null]", "DOUBLE MULTISET NOT NULL");
        this.tester.checkScalar("multiset[cast(null as boolean)] multiset union all multiset[cast(null as boolean)]", "[null, null]", "BOOLEAN MULTISET NOT NULL");
    }

    @Test
    public void testSubMultisetOfOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SUBMULTISET_OF, VM_FENNEL, VM_JAVA);
        this.tester.checkBoolean("multiset[2] submultiset of multiset[1]", Boolean.FALSE);
        this.tester.checkBoolean("multiset[1] submultiset of multiset[1]", Boolean.TRUE);
        this.tester.checkBoolean("multiset[1, 2] submultiset of multiset[1]", Boolean.FALSE);
        this.tester.checkBoolean("multiset[1] submultiset of multiset[1, 2]", Boolean.TRUE);
        this.tester.checkBoolean("multiset[1, 2] submultiset of multiset[1, 2]", Boolean.TRUE);
        this.tester.checkBoolean("multiset['a', 'b'] submultiset of multiset['c', 'd', 's', 'a']", Boolean.FALSE);
        this.tester.checkBoolean("multiset['a', 'd'] submultiset of multiset['c', 's', 'a', 'w', 'd']", Boolean.TRUE);
        this.tester.checkBoolean("multiset['q', 'a'] submultiset of multiset['a', 'q']", Boolean.TRUE);
    }

    @Test
    public void testNotSubMultisetOfOperator() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.NOT_SUBMULTISET_OF, VM_FENNEL, VM_JAVA);
        this.tester.checkBoolean("multiset[2] not submultiset of multiset[1]", Boolean.TRUE);
        this.tester.checkBoolean("multiset[1] not submultiset of multiset[1]", Boolean.FALSE);
        this.tester.checkBoolean("multiset[1, 2] not submultiset of multiset[1]", Boolean.TRUE);
        this.tester.checkBoolean("multiset[1] not submultiset of multiset[1, 2]", Boolean.FALSE);
        this.tester.checkBoolean("multiset[1, 2] not submultiset of multiset[1, 2]", Boolean.FALSE);
        this.tester.checkBoolean("multiset['a', 'b'] not submultiset of multiset['c', 'd', 's', 'a']", Boolean.TRUE);
        this.tester.checkBoolean("multiset['a', 'd'] not submultiset of multiset['c', 's', 'a', 'w', 'd']", Boolean.FALSE);
        this.tester.checkBoolean("multiset['q', 'a'] not submultiset of multiset['a', 'q']", Boolean.FALSE);
    }

    @Test
    public void testCollectFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COLLECT, VM_FENNEL, VM_JAVA);
        this.tester.checkFails("collect(^*^)", "Unknown identifier '\\*'", false);
        this.checkAggType(this.tester, "collect(1)", "INTEGER NOT NULL MULTISET NOT NULL");
        this.checkAggType(this.tester, "collect(1.2)", "DECIMAL(2, 1) NOT NULL MULTISET NOT NULL");
        this.checkAggType(this.tester, "collect(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL MULTISET NOT NULL");
        this.tester.checkFails("^collect()^", "Invalid number of arguments to function 'COLLECT'. Was expecting 1 arguments", false);
        this.tester.checkFails("^collect(1, 2)^", "Invalid number of arguments to function 'COLLECT'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        this.tester.checkAgg("collect(x)", values, Collections.singletonList("[0, 2, 2]"), 0.0);
        this.tester.checkAgg("collect(x) within group(order by x desc)", values, Collections.singletonList("[2, 2, 0]"), 0.0);
        Integer result1 = -3;
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("collect(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result1, 0.0);
        Integer result = -1;
        this.tester.checkAgg("collect(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result, 0.0);
        this.tester.checkAgg("collect(DISTINCT x)", values, 2, 0.0);
    }

    @Test
    public void testFusionFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.FUSION, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testYear() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.YEAR, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("year(date '2008-1-23')", "2008", "BIGINT NOT NULL");
        this.tester.checkNull("year(cast(null as date))");
    }

    @Test
    public void testQuarter() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.QUARTER, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("quarter(date '2008-1-23')", "1", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-2-23')", "1", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-3-23')", "1", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-4-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-5-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-6-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-7-23')", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-8-23')", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-9-23')", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-10-23')", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-11-23')", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("quarter(date '2008-12-23')", "4", "BIGINT NOT NULL");
        this.tester.checkNull("quarter(cast(null as date))");
    }

    @Test
    public void testMonth() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MONTH, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("month(date '2008-1-23')", "1", "BIGINT NOT NULL");
        this.tester.checkNull("month(cast(null as date))");
    }

    @Test
    public void testWeek() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.WEEK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testDayOfYear() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DAYOFYEAR, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testDayOfMonth() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DAYOFMONTH, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("dayofmonth(date '2008-1-23')", "23", "BIGINT NOT NULL");
        this.tester.checkNull("dayofmonth(cast(null as date))");
    }

    @Test
    public void testDayOfWeek() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DAYOFWEEK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testHour() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.HOUR, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("hour(timestamp '2008-1-23 12:34:56')", "12", "BIGINT NOT NULL");
        this.tester.checkNull("hour(cast(null as timestamp))");
    }

    @Test
    public void testMinute() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MINUTE, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("minute(timestamp '2008-1-23 12:34:56')", "34", "BIGINT NOT NULL");
        this.tester.checkNull("minute(cast(null as timestamp))");
    }

    @Test
    public void testSecond() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SECOND, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("second(timestamp '2008-1-23 12:34:56')", "56", "BIGINT NOT NULL");
        this.tester.checkNull("second(cast(null as timestamp))");
    }

    @Test
    public void testExtractIntervalYearMonth() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkFails("^extract(doy from interval '4-2' year to month)^", INVALID_EXTRACT_UNIT_VALIDATION_ERROR, false);
        this.tester.checkFails("^extract(dow from interval '4-2' year to month)^", INVALID_EXTRACT_UNIT_VALIDATION_ERROR, false);
        this.tester.checkFails("^extract(week from interval '4-2' year to month)^", INVALID_EXTRACT_UNIT_VALIDATION_ERROR, false);
        this.tester.checkFails("^extract(isodow from interval '4-2' year to month)^", INVALID_EXTRACT_UNIT_VALIDATION_ERROR, false);
        this.tester.checkScalar("extract(month from interval '4-2' year to month)", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(quarter from interval '4-2' year to month)", "1", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(year from interval '4-2' year to month)", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(decade from interval '426-3' year(3) to month)", "42", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from interval '426-3' year(3) to month)", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millennium from interval '2005-3' year(4) to month)", "2", "BIGINT NOT NULL");
    }

    @Test
    public void testExtractIntervalDayTime() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("extract(millisecond from interval '2 3:4:5.678' day to second)", "5678", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(microsecond from interval '2 3:4:5.678' day to second)", "5678000", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(second from interval '2 3:4:5.678' day to second)", "5", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from interval '2 3:4:5.678' day to second)", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(hour from interval '2 3:4:5.678' day to second)", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(day from interval '2 3:4:5.678' day to second)", "2", "BIGINT NOT NULL");
        this.tester.checkFails("^extract(month from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL MONTH> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        this.tester.checkFails("^extract(quarter from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL QUARTER> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        this.tester.checkFails("^extract(year from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL YEAR> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        this.tester.checkFails("^extract(isoyear from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL ISOYEAR> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        this.tester.checkFails("^extract(century from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL CENTURY> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
    }

    @Test
    public void testExtractDate() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("extract(epoch from date '2008-2-23')", "1203724800", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(second from date '2008-2-23')", "0", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from date '9999-2-23')", "0", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from date '0001-1-1')", "0", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from date '2008-2-23')", "0", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(hour from date '2008-2-23')", "0", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(day from date '2008-2-23')", "23", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(month from date '2008-2-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(quarter from date '2008-4-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(year from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(isoyear from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(doy from date '2008-2-23')", "54", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(dow from date '2008-2-23')", "7", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(dow from date '2008-2-24')", "1", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(isodow from date '2008-2-23')", "6", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(isodow from date '2008-2-24')", "7", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(week from date '2008-2-23')", "8", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(week from timestamp '2008-2-23 01:23:45')", "8", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(week from cast(null as date))", null, "BIGINT");
        this.tester.checkScalar("extract(decade from date '2008-2-23')", "200", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from date '2008-2-23')", "21", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from date '2001-01-01')", "21", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from date '2000-12-31')", "20", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from date '1852-06-07')", "19", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from date '0001-02-01')", "1", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millennium from date '2000-2-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millennium from date '1969-2-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millennium from date '2000-12-31')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millennium from date '2001-01-01')", "3", "BIGINT NOT NULL");
    }

    @Test
    public void testExtractTimestamp() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("extract(epoch from timestamp '2008-2-23 12:34:56')", "1203770096", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(second from timestamp '2008-2-23 12:34:56')", "56", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millisecond from timestamp '2008-2-23 12:34:56')", "56000", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(microsecond from timestamp '2008-2-23 12:34:56')", "56000000", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from timestamp '2008-2-23 12:34:56')", "34", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(hour from timestamp '2008-2-23 12:34:56')", "12", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(day from timestamp '2008-2-23 12:34:56')", "23", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(month from timestamp '2008-2-23 12:34:56')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(quarter from timestamp '2008-7-23 12:34:56')", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(year from timestamp '2008-2-23 12:34:56')", "2008", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(isoyear from timestamp '2008-2-23 12:34:56')", "2008", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(decade from timestamp '2008-2-23 12:34:56')", "200", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from timestamp '2008-2-23 12:34:56')", "21", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from timestamp '2001-01-01 12:34:56')", "21", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(century from timestamp '2000-12-31 12:34:56')", "20", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millennium from timestamp '2008-2-23 12:34:56')", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millennium from timestamp '2000-2-23 12:34:56')", "2", "BIGINT NOT NULL");
    }

    @Test
    public void testExtractFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("extract(day from interval '2 3:4:5.678' day to second)", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(day from interval '23456 3:4:5.678' day(5) to second)", "23456", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(hour from interval '2 3:4:5.678' day to second)", "3", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from interval '2 3:4:5.678' day to second)", "4", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(second from interval '2 3:4:5.678' day to second)", "5", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(millisecond from interval '2 3:4:5.678' day to second)", "5678", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(microsecond from interval '2 3:4:5.678' day to second)", "5678000", "BIGINT NOT NULL");
        this.tester.checkNull("extract(month from cast(null as interval year))");
    }

    @Test
    public void testExtractFuncFromDateTime() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        this.tester.checkScalar("extract(year from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(isoyear from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(month from date '2008-2-23')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(month from timestamp '2008-2-23 12:34:56')", "2", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from timestamp '2008-2-23 12:34:56')", "34", "BIGINT NOT NULL");
        this.tester.checkScalar("extract(minute from time '12:23:34')", "23", "BIGINT NOT NULL");
        this.tester.checkNull("extract(month from cast(null as timestamp))");
        this.tester.checkNull("extract(month from cast(null as date))");
        this.tester.checkNull("extract(second from cast(null as time))");
        this.tester.checkNull("extract(millisecond from cast(null as time))");
        this.tester.checkNull("extract(microsecond from cast(null as time))");
    }

    @Test
    public void testArrayValueConstructor() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, new SqlTester.VmName[0]);
        this.tester.checkScalar("Array['foo', 'bar']", "[foo, bar]", "CHAR(3) NOT NULL ARRAY NOT NULL");
        this.tester.checkFails("^Array[]^", "Require at least 1 argument", false);
    }

    @Test
    public void testItemOp() {
        this.tester.setFor(SqlStdOperatorTable.ITEM, new SqlTester.VmName[0]);
        this.tester.checkScalar("ARRAY ['foo', 'bar'][1]", "foo", "CHAR(3)");
        this.tester.checkScalar("ARRAY ['foo', 'bar'][0]", null, "CHAR(3)");
        this.tester.checkScalar("ARRAY ['foo', 'bar'][2]", "bar", "CHAR(3)");
        this.tester.checkScalar("ARRAY ['foo', 'bar'][3]", null, "CHAR(3)");
        this.tester.checkNull("ARRAY ['foo', 'bar'][1 + CAST(NULL AS INTEGER)]");
        this.tester.checkFails("^ARRAY ['foo', 'bar']['baz']^", "Cannot apply 'ITEM' to arguments of type 'ITEM\\(<CHAR\\(3\\) ARRAY>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): <ARRAY>\\[<INTEGER>\\]\n<MAP>\\[<VALUE>\\]", false);
        this.tester.checkScalar("ARRAY [2, 4, 6][2]", "4", "INTEGER");
        this.tester.checkScalar("ARRAY [2, 4, 6][4]", null, "INTEGER");
        this.tester.checkScalarExact("map['foo', 3, 'bar', 7]['bar']", "INTEGER", "7");
        this.tester.checkScalarExact("map['foo', CAST(NULL AS INTEGER), 'bar', 7]['bar']", "INTEGER", "7");
        this.tester.checkScalarExact("map['foo', CAST(NULL AS INTEGER), 'bar', 7]['baz']", "INTEGER", null);
        this.tester.checkColumnType("select cast(null as any)['x'] from (values(1))", "ANY");
    }

    @Test
    public void testMapValueConstructor() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, VM_JAVA);
        this.tester.checkFails("^Map[]^", "Map requires at least 2 arguments", false);
        this.tester.checkFails("^Map[1, 'x', 2]^", "Map requires an even number of arguments", false);
        this.tester.checkFails("^map[1, 1, 2, 'x']^", "Parameters must be of the same type", false);
        this.tester.checkScalarExact("map['washington', 1, 'obama', 44]", "(CHAR(10) NOT NULL, INTEGER NOT NULL) MAP NOT NULL", "{washington=1, obama=44}");
        SqlTester tester2 = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        tester2.checkScalarExact("map['washington', 1, 'obama', 44]", "(VARCHAR(10) NOT NULL, INTEGER NOT NULL) MAP NOT NULL", "{washington=1, obama=44}");
    }

    @Test
    public void testCeilFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CEIL, VM_FENNEL);
        this.tester.checkScalarApprox("ceil(10.1e0)", "DOUBLE NOT NULL", 11.0, 0.0);
        this.tester.checkScalarApprox("ceil(cast(-11.2e0 as real))", "REAL NOT NULL", -11.0, 0.0);
        this.tester.checkScalarExact("ceil(100)", "INTEGER NOT NULL", "100");
        this.tester.checkScalarExact("ceil(1.3)", "DECIMAL(2, 0) NOT NULL", "2");
        this.tester.checkScalarExact("ceil(-1.7)", "DECIMAL(2, 0) NOT NULL", "-1");
        this.tester.checkNull("ceiling(cast(null as decimal(2,0)))");
        this.tester.checkNull("ceiling(cast(null as double))");
    }

    @Test
    public void testCeilFuncInterval() {
        if (!this.enable) {
            return;
        }
        this.tester.checkScalar("ceil(interval '3:4:5' hour to second)", "+4:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("ceil(interval '-6.3' second)", "-6.000000", "INTERVAL SECOND NOT NULL");
        this.tester.checkScalar("ceil(interval '5-1' year to month)", "+6-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("ceil(interval '-5-1' year to month)", "-5-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("ceil(cast(null as interval year))");
    }

    @Test
    public void testFloorFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.FLOOR, VM_FENNEL);
        this.tester.checkScalarApprox("floor(2.5e0)", "DOUBLE NOT NULL", 2.0, 0.0);
        this.tester.checkScalarApprox("floor(cast(-1.2e0 as real))", "REAL NOT NULL", -2.0, 0.0);
        this.tester.checkScalarExact("floor(100)", "INTEGER NOT NULL", "100");
        this.tester.checkScalarExact("floor(1.7)", "DECIMAL(2, 0) NOT NULL", "1");
        this.tester.checkScalarExact("floor(-1.7)", "DECIMAL(2, 0) NOT NULL", "-2");
        this.tester.checkNull("floor(cast(null as decimal(2,0)))");
        this.tester.checkNull("floor(cast(null as real))");
    }

    @Test
    public void testFloorFuncDateTime() {
        this.tester.checkFails("^floor('12:34:56')^", "Cannot apply 'FLOOR' to arguments of type 'FLOOR\\(<CHAR\\(8\\)>\\)'\\. Supported form\\(s\\): 'FLOOR\\(<NUMERIC>\\)'\n'FLOOR\\(<DATETIME_INTERVAL>\\)'\n'FLOOR\\(<DATE> TO <TIME_UNIT>\\)'\n'FLOOR\\(<TIME> TO <TIME_UNIT>\\)'\n'FLOOR\\(<TIMESTAMP> TO <TIME_UNIT>\\)'", false);
        this.tester.checkFails("^floor(time '12:34:56')^", "(?s)Cannot apply 'FLOOR' to arguments .*", false);
        this.tester.checkFails("^floor(123.45 to minute)^", "(?s)Cannot apply 'FLOOR' to arguments .*", false);
        this.tester.checkFails("^floor('abcde' to minute)^", "(?s)Cannot apply 'FLOOR' to arguments .*", false);
        this.tester.checkScalar("floor(time '12:34:56' to minute)", "12:34:00", "TIME(0) NOT NULL");
        this.tester.checkScalar("floor(timestamp '2015-02-19 12:34:56.78' to second)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        this.tester.checkScalar("floor(timestamp '2015-02-19 12:34:56' to minute)", "2015-02-19 12:34:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("floor(timestamp '2015-02-19 12:34:56' to year)", "2015-01-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("floor(timestamp '2015-02-19 12:34:56' to month)", "2015-02-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkNull("floor(cast(null as timestamp) to month)");
    }

    @Test
    public void testCeilFuncDateTime() {
        this.tester.checkFails("^ceil('12:34:56')^", "Cannot apply 'CEIL' to arguments of type 'CEIL\\(<CHAR\\(8\\)>\\)'\\. Supported form\\(s\\): 'CEIL\\(<NUMERIC>\\)'\n'CEIL\\(<DATETIME_INTERVAL>\\)'\n'CEIL\\(<DATE> TO <TIME_UNIT>\\)'\n'CEIL\\(<TIME> TO <TIME_UNIT>\\)'\n'CEIL\\(<TIMESTAMP> TO <TIME_UNIT>\\)'", false);
        this.tester.checkFails("^ceil(time '12:34:56')^", "(?s)Cannot apply 'CEIL' to arguments .*", false);
        this.tester.checkFails("^ceil(123.45 to minute)^", "(?s)Cannot apply 'CEIL' to arguments .*", false);
        this.tester.checkFails("^ceil('abcde' to minute)^", "(?s)Cannot apply 'CEIL' to arguments .*", false);
        this.tester.checkScalar("ceil(time '12:34:56' to minute)", "12:35:00", "TIME(0) NOT NULL");
        this.tester.checkScalar("ceil(time '12:59:56' to minute)", "13:00:00", "TIME(0) NOT NULL");
        this.tester.checkScalar("ceil(timestamp '2015-02-19 12:34:56.78' to second)", "2015-02-19 12:34:57", "TIMESTAMP(2) NOT NULL");
        this.tester.checkScalar("ceil(timestamp '2015-02-19 12:34:56.00' to second)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        this.tester.checkScalar("ceil(timestamp '2015-02-19 12:34:56' to minute)", "2015-02-19 12:35:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("ceil(timestamp '2015-02-19 12:34:56' to year)", "2016-01-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("ceil(timestamp '2015-02-19 12:34:56' to month)", "2015-03-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkNull("ceil(cast(null as timestamp) to month)");
        this.tester.checkScalar("ceiling(timestamp '2015-02-19 12:34:56' to month)", "2015-03-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkNull("ceiling(cast(null as timestamp) to month)");
    }

    @Test
    public void testFloorFuncInterval() {
        if (!this.enable) {
            return;
        }
        this.tester.checkScalar("floor(interval '3:4:5' hour to second)", "+3:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        this.tester.checkScalar("floor(interval '-6.3' second)", "-7.000000", "INTERVAL SECOND NOT NULL");
        this.tester.checkScalar("floor(interval '5-1' year to month)", "+5-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("floor(interval '-5-1' year to month)", "-6-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("floor(interval '-6.3' second to second)", "-7.000000", "INTERVAL SECOND NOT NULL");
        this.tester.checkScalar("floor(interval '6-3' minute to second to minute)", "-7-0", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.tester.checkScalar("floor(interval '6-3' hour to minute to hour)", "7-0", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.tester.checkScalar("floor(interval '6 3' day to hour to day)", "7 00", "INTERVAL DAY TO HOUR NOT NULL");
        this.tester.checkScalar("floor(interval '102-7' year to month to month)", "102-07", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("floor(interval '102-7' year to month to quarter)", "102-10", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("floor(interval '102-1' year to month to century)", "201", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkScalar("floor(interval '1004-1' year to month to millennium)", "2001-00", "INTERVAL YEAR TO MONTH NOT NULL");
        this.tester.checkNull("floor(cast(null as interval year))");
    }

    @Test
    public void testTimestampAdd() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TIMESTAMP_ADD, new SqlTester.VmName[0]);
        this.tester.checkScalar("timestampadd(MICROSECOND, 2000000, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:27", "TIMESTAMP(3) NOT NULL");
        this.tester.checkScalar("timestampadd(SQL_TSI_SECOND, 2, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:27", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(NANOSECOND, 3000000000, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:28", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(SQL_TSI_FRAC_SECOND, 2000000000, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:27", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MINUTE, 2, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:44:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(HOUR, -2000, timestamp '2016-02-24 12:42:25')", "2015-12-03 04:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkNull("timestampadd(HOUR, CAST(NULL AS INTEGER), timestamp '2016-02-24 12:42:25')");
        this.tester.checkNull("timestampadd(HOUR, -200, CAST(NULL AS TIMESTAMP))");
        this.tester.checkScalar("timestampadd(MONTH, 3, timestamp '2016-02-24 12:42:25')", "2016-05-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MONTH, 3, cast(null as timestamp))", null, "TIMESTAMP(0)");
        this.tester.checkScalar("timestampadd(MONTH, 1, date '2016-06-15')", "2016-07-15", "DATE NOT NULL");
        this.tester.checkScalar("timestampadd(DAY, 1, date '2016-06-15')", "2016-06-16", "DATE NOT NULL");
        this.tester.checkScalar("timestampadd(HOUR, -1, date '2016-06-15')", "2016-06-14 23:00:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MINUTE, 1, date '2016-06-15')", "2016-06-15 00:01:00", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(SQL_TSI_SECOND, -1, date '2016-06-15')", "2016-06-14 23:59:59", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(SECOND, 1, date '2016-06-15')", "2016-06-15 00:00:01", "TIMESTAMP(0) NOT NULL");
        this.tester.checkScalar("timestampadd(SECOND, 1, cast(null as date))", null, "TIMESTAMP(0)");
        this.tester.checkScalar("timestampadd(DAY, 1, cast(null as date))", null, "DATE");
        this.tester.checkScalar("timestampadd(MONTH, 1, date '2016-05-31')", "2016-06-30", "DATE NOT NULL");
        this.tester.checkScalar("timestampadd(MONTH, 5, date '2016-01-31')", "2016-06-30", "DATE NOT NULL");
        this.tester.checkScalar("timestampadd(MONTH, -1, date '2016-03-31')", "2016-02-29", "DATE NOT NULL");
        this.tester.checkScalar("timestampadd(SECOND, 1, time '23:59:59')", "00:00:00", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MINUTE, 1, time '00:00:00')", "00:01:00", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MINUTE, 1, time '23:59:59')", "00:00:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(HOUR, 1, time '23:59:59')", "00:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(DAY, 15, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(WEEK, 3, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MONTH, 6, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(QUARTER, 1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(YEAR, 10, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(SECOND, -1, time '00:00:00')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MINUTE, -1, time '00:00:00')", "23:59:00", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(HOUR, -1, time '00:00:00')", "23:00:00", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(DAY, -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(WEEK, -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(MONTH, -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(QUARTER, -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
        this.tester.checkScalar("timestampadd(YEAR, -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL");
    }

    @Test
    public void testTimestampAddFractionalSeconds() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TIMESTAMP_ADD, new SqlTester.VmName[0]);
        this.tester.checkType("timestampadd(SQL_TSI_FRAC_SECOND, 2, timestamp '2016-02-24 12:42:25.000000')", "TIMESTAMP(3) NOT NULL");
        Assume.assumeTrue((this.tester.getValidator().getTypeFactory().getTypeSystem().getMaxPrecision(SqlTypeName.TIMESTAMP) == 3 ? 1 : 0) != 0);
        this.tester.checkType("timestampadd(MICROSECOND, 2, timestamp '2016-02-24 12:42:25.000000')", "TIMESTAMP(3) NOT NULL");
    }

    @Test
    public void testTimestampDiff() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.TIMESTAMP_DIFF, new SqlTester.VmName[0]);
        this.tester.checkScalar("timestampdiff(HOUR, timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 15:42:25')", "3", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(MICROSECOND, timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 12:42:20')", "-5000000", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(SQL_TSI_FRAC_SECOND, timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 12:42:20')", "-5000000000", "BIGINT NOT NULL");
        this.tester.checkScalar("timestampdiff(NANOSECOND, timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 12:42:20')", "-5000000000", "BIGINT NOT NULL");
        this.tester.checkScalar("timestampdiff(YEAR, timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "2", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(WEEK, timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "104", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(WEEK, timestamp '2014-02-19 12:42:25', timestamp '2016-02-24 12:42:25')", "105", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(MONTH, timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "24", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(QUARTER, timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "8", "INTEGER NOT NULL");
        this.tester.checkFails("timestampdiff(CENTURY, timestamp '2014-02-24 12:42:25', timestamp '2614-02-24 12:42:25')", "(?s)Encountered \"CENTURY\" at .*", false);
        this.tester.checkScalar("timestampdiff(QUARTER, timestamp '2014-02-24 12:42:25', cast(null as timestamp))", null, "INTEGER");
        this.tester.checkScalar("timestampdiff(QUARTER, cast(null as timestamp), timestamp '2014-02-24 12:42:25')", null, "INTEGER");
        this.tester.checkScalar("timestampdiff(MONTH, date '2016-03-15', date '2016-06-14')", "2", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(DAY, date '2016-06-15', date '2016-06-14')", "-1", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(HOUR, date '2016-06-15', date '2016-06-14')", "-24", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(MINUTE, date '2016-06-15',  date '2016-06-15')", "0", "INTEGER NOT NULL");
        this.tester.checkScalar("timestampdiff(SECOND, cast(null as date), date '2016-06-15')", null, "INTEGER");
        this.tester.checkScalar("timestampdiff(DAY, date '2016-06-15', cast(null as date))", null, "INTEGER");
    }

    @Test
    public void testDenseRankFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.DENSE_RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testPercentRankFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.PERCENT_RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testRankFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testCumeDistFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CUME_DIST, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testRowNumberFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ROW_NUMBER, VM_FENNEL, VM_JAVA);
    }

    @Test
    public void testCountFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COUNT, VM_EXPAND);
        this.tester.checkType("count(*)", "BIGINT NOT NULL");
        this.tester.checkType("count('name')", "BIGINT NOT NULL");
        this.tester.checkType("count(1)", "BIGINT NOT NULL");
        this.tester.checkType("count(1.2)", "BIGINT NOT NULL");
        this.tester.checkType("COUNT(DISTINCT 'x')", "BIGINT NOT NULL");
        this.tester.checkFails("^COUNT()^", "Invalid number of arguments to function 'COUNT'. Was expecting 1 arguments", false);
        this.tester.checkType("count(1, 2)", "BIGINT NOT NULL");
        this.tester.checkType("count(1, 2, 'x', 'y')", "BIGINT NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "1", "0"};
        this.tester.checkAgg("COUNT(x)", values, 3, 0.0);
        this.tester.checkAgg("COUNT(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, 2, 0.0);
        this.tester.checkAgg("COUNT(DISTINCT x)", values, 2, 0.0);
        String[] stringValues = new String[]{"'a'", "CAST(NULL AS VARCHAR(1))", "''"};
        this.tester.checkAgg("COUNT(*)", stringValues, 3, 0.0);
        this.tester.checkAgg("COUNT(x)", stringValues, 2, 0.0);
        this.tester.checkAgg("COUNT(DISTINCT x)", stringValues, 2, 0.0);
        this.tester.checkAgg("COUNT(DISTINCT 123)", stringValues, 1, 0.0);
    }

    @Test
    public void testApproxCountDistinctFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COUNT, VM_EXPAND);
        this.tester.checkFails("approx_count_distinct(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("approx_count_distinct('name')", "BIGINT NOT NULL");
        this.tester.checkType("approx_count_distinct(1)", "BIGINT NOT NULL");
        this.tester.checkType("approx_count_distinct(1.2)", "BIGINT NOT NULL");
        this.tester.checkType("APPROX_COUNT_DISTINCT(DISTINCT 'x')", "BIGINT NOT NULL");
        this.tester.checkFails("^APPROX_COUNT_DISTINCT()^", "Invalid number of arguments to function 'APPROX_COUNT_DISTINCT'. Was expecting 1 arguments", false);
        this.tester.checkType("approx_count_distinct(1, 2)", "BIGINT NOT NULL");
        this.tester.checkType("approx_count_distinct(1, 2, 'x', 'y')", "BIGINT NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "1", "0"};
        this.tester.checkAgg("APPROX_COUNT_DISTINCT(x)", values, 2, 0.0);
        this.tester.checkAgg("APPROX_COUNT_DISTINCT(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, 1, 0.0);
        this.tester.checkAgg("APPROX_COUNT_DISTINCT(DISTINCT x)", values, 2, 0.0);
        String[] stringValues = new String[]{"'a'", "CAST(NULL AS VARCHAR(1))", "''"};
        this.tester.checkAgg("APPROX_COUNT_DISTINCT(x)", stringValues, 2, 0.0);
        this.tester.checkAgg("APPROX_COUNT_DISTINCT(DISTINCT x)", stringValues, 2, 0.0);
        this.tester.checkAgg("APPROX_COUNT_DISTINCT(DISTINCT 123)", stringValues, 1, 0.0);
    }

    @Test
    public void testSumFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.SUM, VM_EXPAND);
        this.tester.checkFails("sum(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^sum('name')^", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<CHAR\\(4\\)>\\)'\\. Supported form\\(s\\): 'SUM\\(<NUMERIC>\\)'.*", false);
        this.checkAggType(this.tester, "sum(1)", "INTEGER NOT NULL");
        this.checkAggType(this.tester, "sum(1.2)", "DECIMAL(2, 1) NOT NULL");
        this.checkAggType(this.tester, "sum(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        this.tester.checkFails("^sum()^", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments", false);
        this.tester.checkFails("^sum(1, 2)^", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments", false);
        this.tester.checkFails("^sum(cast(null as varchar(2)))^", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'SUM\\(<NUMERIC>\\)'.*", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        this.tester.checkAgg("sum(x)", values, 4, 0.0);
        Integer result1 = -3;
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("sum(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result1, 0.0);
        Integer result = -1;
        this.tester.checkAgg("sum(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result, 0.0);
        this.tester.checkAgg("sum(DISTINCT x)", values, 2, 0.0);
    }

    protected void checkAggType(SqlTester tester, String expr, String type) {
        tester.checkColumnType(AbstractSqlTester.buildQueryAgg(expr), type);
    }

    @Test
    public void testAvgFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.AVG, VM_EXPAND);
        this.tester.checkFails("avg(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^avg(cast(null as varchar(2)))^", "(?s)Cannot apply 'AVG' to arguments of type 'AVG\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'AVG\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("AVG(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "AVG(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        this.checkAggType(this.tester, "avg(1)", "INTEGER NOT NULL");
        this.checkAggType(this.tester, "avg(1.2)", "DECIMAL(2, 1) NOT NULL");
        this.checkAggType(this.tester, "avg(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        if (!this.enable) {
            return;
        }
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        this.tester.checkAgg("AVG(x)", values, 2.0, 0.0);
        this.tester.checkAgg("AVG(DISTINCT x)", values, 1.5, 0.0);
        Integer result = -1;
        this.tester.checkAgg("avg(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, result, 0.0);
    }

    @Test
    public void testCovarPopFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COVAR_POP, VM_EXPAND);
        this.tester.checkFails("covar_pop(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^covar_pop(cast(null as varchar(2)),cast(null as varchar(2)))^", "(?s)Cannot apply 'COVAR_POP' to arguments of type 'COVAR_POP\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'COVAR_POP\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        this.tester.checkType("covar_pop(CAST(NULL AS INTEGER),CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "covar_pop(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("covar_pop(x)", new String[0], null, 0.0);
    }

    @Test
    public void testCovarSampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.COVAR_SAMP, VM_EXPAND);
        this.tester.checkFails("covar_samp(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^covar_samp(cast(null as varchar(2)),cast(null as varchar(2)))^", "(?s)Cannot apply 'COVAR_SAMP' to arguments of type 'COVAR_SAMP\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'COVAR_SAMP\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        this.tester.checkType("covar_samp(CAST(NULL AS INTEGER),CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "covar_samp(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("covar_samp(x)", new String[0], null, 0.0);
    }

    @Test
    public void testRegrSxxFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.REGR_SXX, VM_EXPAND);
        this.tester.checkFails("regr_sxx(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^regr_sxx(cast(null as varchar(2)), cast(null as varchar(2)))^", "(?s)Cannot apply 'REGR_SXX' to arguments of type 'REGR_SXX\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'REGR_SXX\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        this.tester.checkType("regr_sxx(CAST(NULL AS INTEGER), CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "regr_sxx(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("regr_sxx(x)", new String[0], null, 0.0);
    }

    @Test
    public void testRegrSyyFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.REGR_SYY, VM_EXPAND);
        this.tester.checkFails("regr_syy(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^regr_syy(cast(null as varchar(2)), cast(null as varchar(2)))^", "(?s)Cannot apply 'REGR_SYY' to arguments of type 'REGR_SYY\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'REGR_SYY\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        this.tester.checkType("regr_syy(CAST(NULL AS INTEGER), CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "regr_syy(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("regr_syy(x)", new String[0], null, 0.0);
    }

    @Test
    public void testStddevPopFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.STDDEV_POP, VM_EXPAND);
        this.tester.checkFails("stddev_pop(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^stddev_pop(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV_POP' to arguments of type 'STDDEV_POP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV_POP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("stddev_pop(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "stddev_pop(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (this.enable) {
            this.tester.checkAgg("stddev_pop(x)", values, 1.414213562373095, 1.0E-15);
            this.tester.checkAgg("stddev_pop(DISTINCT x)", values, 1.5, 0.0);
            this.tester.checkAgg("stddev_pop(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, 0, 0.0);
        }
        this.tester.checkAgg("stddev_pop(x)", new String[]{"5"}, 0, 0.0);
        this.tester.checkAgg("stddev_pop(x)", new String[0], null, 0.0);
    }

    @Test
    public void testStddevSampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.STDDEV_SAMP, VM_EXPAND);
        this.tester.checkFails("stddev_samp(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^stddev_samp(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV_SAMP' to arguments of type 'STDDEV_SAMP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV_SAMP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("stddev_samp(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "stddev_samp(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (this.enable) {
            this.tester.checkAgg("stddev_samp(x)", values, 1.732050807568877, 1.0E-15);
            this.tester.checkAgg("stddev_samp(DISTINCT x)", values, 2.121320343559642, 1.0E-15);
            this.tester.checkAgg("stddev_samp(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, null, 0.0);
        }
        this.tester.checkAgg("stddev_samp(x)", new String[]{"5"}, null, 0.0);
        this.tester.checkAgg("stddev_samp(x)", new String[0], null, 0.0);
    }

    @Test
    public void testStddevFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.STDDEV, VM_EXPAND);
        this.tester.checkFails("stddev(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^stddev(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV' to arguments of type 'STDDEV\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("stddev(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "stddev(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        this.tester.checkAgg("stddev(x)", new String[]{"5"}, null, 0.0);
        this.tester.checkAgg("stddev(x)", new String[0], null, 0.0);
    }

    @Test
    public void testVarPopFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.VAR_POP, VM_EXPAND);
        this.tester.checkFails("var_pop(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^var_pop(cast(null as varchar(2)))^", "(?s)Cannot apply 'VAR_POP' to arguments of type 'VAR_POP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VAR_POP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("var_pop(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "var_pop(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("var_pop(x)", values, 2.0, 0.0);
        this.tester.checkAgg("var_pop(DISTINCT x)", values, 2.25, 1.0E-4);
        this.tester.checkAgg("var_pop(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, 0, 0.0);
        this.tester.checkAgg("var_pop(x)", new String[]{"5"}, 0, 0.0);
        this.tester.checkAgg("var_pop(x)", new String[0], null, 0.0);
    }

    @Test
    public void testVarSampFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.VAR_SAMP, VM_EXPAND);
        this.tester.checkFails("var_samp(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^var_samp(cast(null as varchar(2)))^", "(?s)Cannot apply 'VAR_SAMP' to arguments of type 'VAR_SAMP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VAR_SAMP\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("var_samp(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "var_samp(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("var_samp(x)", values, 3.0, 0.0);
        this.tester.checkAgg("var_samp(DISTINCT x)", values, 4.5, 1.0E-4);
        this.tester.checkAgg("var_samp(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, null, 0.0);
        this.tester.checkAgg("var_samp(x)", new String[]{"5"}, null, 0.0);
        this.tester.checkAgg("var_samp(x)", new String[0], null, 0.0);
    }

    @Test
    public void testVarFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.VARIANCE, VM_EXPAND);
        this.tester.checkFails("variance(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkFails("^variance(cast(null as varchar(2)))^", "(?s)Cannot apply 'VARIANCE' to arguments of type 'VARIANCE\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VARIANCE\\(<NUMERIC>\\)'.*", false);
        this.tester.checkType("variance(CAST(NULL AS INTEGER))", "INTEGER");
        this.checkAggType(this.tester, "variance(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("variance(x)", values, 3.0, 0.0);
        this.tester.checkAgg("variance(DISTINCT x)", values, 4.5, 1.0E-4);
        this.tester.checkAgg("variance(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, null, 0.0);
        this.tester.checkAgg("variance(x)", new String[]{"5"}, null, 0.0);
        this.tester.checkAgg("variance(x)", new String[0], null, 0.0);
    }

    @Test
    public void testMinFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MIN, VM_EXPAND);
        this.tester.checkFails("min(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("min(1)", "INTEGER");
        this.tester.checkType("min(1.2)", "DECIMAL(2, 1)");
        this.tester.checkType("min(DISTINCT 1.5)", "DECIMAL(2, 1)");
        this.tester.checkFails("^min()^", "Invalid number of arguments to function 'MIN'. Was expecting 1 arguments", false);
        this.tester.checkFails("^min(1, 2)^", "Invalid number of arguments to function 'MIN'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("min(x)", values, "0", 0.0);
        this.tester.checkAgg("min(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("min(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("min(DISTINCT x)", values, "0", 0.0);
    }

    @Test
    public void testMaxFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.MAX, VM_EXPAND);
        this.tester.checkFails("max(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("max(1)", "INTEGER");
        this.tester.checkType("max(1.2)", "DECIMAL(2, 1)");
        this.tester.checkType("max(DISTINCT 1.5)", "DECIMAL(2, 1)");
        this.tester.checkFails("^max()^", "Invalid number of arguments to function 'MAX'. Was expecting 1 arguments", false);
        this.tester.checkFails("^max(1, 2)^", "Invalid number of arguments to function 'MAX'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("max(x)", values, "2", 0.0);
        this.tester.checkAgg("max(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("max(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("max(DISTINCT x)", values, "2", 0.0);
    }

    @Test
    public void testLastValueFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.LAST_VALUE, VM_EXPAND);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkWinAgg("last_value(x)", values, "ROWS 3 PRECEDING", "INTEGER", Arrays.asList("3", "0"), 0.0);
        String[] values2 = new String[]{"1.6", "1.2"};
        this.tester.checkWinAgg("last_value(x)", values2, "ROWS 3 PRECEDING", "DECIMAL(2, 1) NOT NULL", Arrays.asList("1.6", "1.2"), 0.0);
        String[] values3 = new String[]{"'foo'", "'bar'", "'name'"};
        this.tester.checkWinAgg("last_value(x)", values3, "ROWS 3 PRECEDING", "CHAR(4) NOT NULL", Arrays.asList("foo ", "bar ", "name"), 0.0);
    }

    @Test
    public void testFirstValueFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.FIRST_VALUE, VM_EXPAND);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "3", "3"};
        if (!this.enable) {
            return;
        }
        this.tester.checkWinAgg("first_value(x)", values, "ROWS 3 PRECEDING", "INTEGER", Arrays.asList("0"), 0.0);
        String[] values2 = new String[]{"1.6", "1.2"};
        this.tester.checkWinAgg("first_value(x)", values2, "ROWS 3 PRECEDING", "DECIMAL(2, 1) NOT NULL", Arrays.asList("1.6"), 0.0);
        String[] values3 = new String[]{"'foo'", "'bar'", "'name'"};
        this.tester.checkWinAgg("first_value(x)", values3, "ROWS 3 PRECEDING", "CHAR(4) NOT NULL", Arrays.asList("foo "), 0.0);
    }

    @Test
    public void testAnyValueFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.ANY_VALUE, VM_EXPAND);
        this.tester.checkFails("any_value(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("any_value(1)", "INTEGER");
        this.tester.checkType("any_value(1.2)", "DECIMAL(2, 1)");
        this.tester.checkType("any_value(DISTINCT 1.5)", "DECIMAL(2, 1)");
        this.tester.checkFails("^any_value()^", "Invalid number of arguments to function 'ANY_VALUE'. Was expecting 1 arguments", false);
        this.tester.checkFails("^any_value(1, 2)^", "Invalid number of arguments to function 'ANY_VALUE'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!this.enable) {
            return;
        }
        this.tester.checkAgg("any_value(x)", values, "0", 0.0);
        this.tester.checkAgg("any_value(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("any_value(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, "-1", 0.0);
        this.tester.checkAgg("any_value(DISTINCT x)", values, "0", 0.0);
    }

    @Test
    public void testBitAndFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.BIT_AND, VM_FENNEL, VM_JAVA);
        this.tester.checkFails("bit_and(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("bit_and(1)", "INTEGER");
        this.tester.checkType("bit_and(CAST(2 AS TINYINT))", "TINYINT");
        this.tester.checkType("bit_and(CAST(2 AS SMALLINT))", "SMALLINT");
        this.tester.checkType("bit_and(distinct CAST(2 AS BIGINT))", "BIGINT");
        this.tester.checkFails("^bit_and(1.2)^", "Cannot apply 'BIT_AND' to arguments of type 'BIT_AND\\(<DECIMAL\\(2, 1\\)>\\)'\\. Supported form\\(s\\): 'BIT_AND\\(<INTEGER>\\)'", false);
        this.tester.checkFails("^bit_and()^", "Invalid number of arguments to function 'BIT_AND'. Was expecting 1 arguments", false);
        this.tester.checkFails("^bit_and(1, 2)^", "Invalid number of arguments to function 'BIT_AND'. Was expecting 1 arguments", false);
        String[] values = new String[]{"3", "2", "2"};
        this.tester.checkAgg("bit_and(x)", values, 2, 0.0);
    }

    @Test
    public void testBitOrFunc() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.BIT_OR, VM_FENNEL, VM_JAVA);
        this.tester.checkFails("bit_or(^*^)", "Unknown identifier '\\*'", false);
        this.tester.checkType("bit_or(1)", "INTEGER");
        this.tester.checkType("bit_or(CAST(2 AS TINYINT))", "TINYINT");
        this.tester.checkType("bit_or(CAST(2 AS SMALLINT))", "SMALLINT");
        this.tester.checkType("bit_or(distinct CAST(2 AS BIGINT))", "BIGINT");
        this.tester.checkFails("^bit_or(1.2)^", "Cannot apply 'BIT_OR' to arguments of type 'BIT_OR\\(<DECIMAL\\(2, 1\\)>\\)'\\. Supported form\\(s\\): 'BIT_OR\\(<INTEGER>\\)'", false);
        this.tester.checkFails("^bit_or()^", "Invalid number of arguments to function 'BIT_OR'. Was expecting 1 arguments", false);
        this.tester.checkFails("^bit_or(1, 2)^", "Invalid number of arguments to function 'BIT_OR'. Was expecting 1 arguments", false);
        String[] values = new String[]{"1", "2", "2"};
        this.tester.checkAgg("bit_or(x)", values, 3, 0.0);
    }

    @Test
    public void testLiteralAtLimit() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        if (!this.enable) {
            return;
        }
        List<RelDataType> types = SqlLimitsTest.getTypes(this.tester.getValidator().getTypeFactory());
        for (RelDataType type : types) {
            for (Object o : this.getValues((BasicSqlType)type, true)) {
                SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
                SqlString literalString = literal.toSqlString(AnsiSqlDialect.DEFAULT);
                String expr = "CAST(" + literalString + " AS " + type + ")";
                try {
                    this.tester.checkType(expr, type.getFullTypeString());
                    if (type.getSqlTypeName() == SqlTypeName.BINARY) continue;
                    this.tester.checkScalar(expr + " = " + literalString, true, "BOOLEAN NOT NULL");
                }
                catch (Error e) {
                    System.out.println("Failed for expr=[" + expr + "]");
                    throw e;
                }
                catch (RuntimeException e) {
                    System.out.println("Failed for expr=[" + expr + "]");
                    throw e;
                }
            }
        }
    }

    @Test
    public void testLiteralBeyondLimit() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        List<RelDataType> types = SqlLimitsTest.getTypes(this.tester.getValidator().getTypeFactory());
        for (RelDataType type : types) {
            for (Object o : this.getValues((BasicSqlType)type, false)) {
                SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
                SqlString literalString = literal.toSqlString(AnsiSqlDialect.DEFAULT);
                if (type.getSqlTypeName() == SqlTypeName.BIGINT || type.getSqlTypeName() == SqlTypeName.DECIMAL && type.getPrecision() == 19) {
                    this.tester.checkFails("CAST(^" + literalString + "^ AS " + type + ")", "Numeric literal '.*' out of range", false);
                    continue;
                }
                if (type.getSqlTypeName() != SqlTypeName.CHAR && type.getSqlTypeName() != SqlTypeName.VARCHAR && type.getSqlTypeName() != SqlTypeName.BINARY && type.getSqlTypeName() != SqlTypeName.VARBINARY) continue;
            }
        }
    }

    @Test
    public void testCastTruncates() {
        this.tester.setFor((SqlOperator)SqlStdOperatorTable.CAST, new SqlTester.VmName[0]);
        this.tester.checkScalar("CAST('ABCD' AS CHAR(2))", "AB", "CHAR(2) NOT NULL");
        this.tester.checkScalar("CAST('ABCD' AS VARCHAR(2))", "AB", "VARCHAR(2) NOT NULL");
        this.tester.checkScalar("CAST('ABCD' AS VARCHAR)", "ABCD", "VARCHAR NOT NULL");
        this.tester.checkScalar("CAST(CAST('ABCD' AS VARCHAR) AS VARCHAR(3))", "ABC", "VARCHAR(3) NOT NULL");
        this.tester.checkScalar("CAST(x'ABCDEF12' AS BINARY(2))", "abcd", "BINARY(2) NOT NULL");
        this.tester.checkScalar("CAST(x'ABCDEF12' AS VARBINARY(2))", "abcd", "VARBINARY(2) NOT NULL");
        this.tester.checkScalar("CAST(x'ABCDEF12' AS VARBINARY)", "abcdef12", "VARBINARY NOT NULL");
        this.tester.checkScalar("CAST(CAST(x'ABCDEF12' AS VARBINARY) AS VARBINARY(3))", "abcdef", "VARBINARY(3) NOT NULL");
        if (!this.enable) {
            return;
        }
        this.tester.checkBoolean("CAST(X'' AS BINARY(3)) = X'000000'", true);
        this.tester.checkBoolean("CAST(X'' AS BINARY(3)) = X''", false);
    }

    @Test
    public void testArgumentBounds() {
        if (!CalciteAssert.ENABLE_SLOW) {
            return;
        }
        SqlValidatorImpl validator = (SqlValidatorImpl)this.tester.getValidator();
        SqlValidatorScope scope = validator.getEmptyScope();
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        Builder builder = new Builder(typeFactory);
        builder.add0(SqlTypeName.BOOLEAN, true, false);
        builder.add0(SqlTypeName.TINYINT, 0, 1, -3, (byte)127, (byte)-128);
        builder.add0(SqlTypeName.SMALLINT, 0, 1, -4, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE);
        builder.add0(SqlTypeName.INTEGER, 0, 1, -2, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.add0(SqlTypeName.BIGINT, 0, 1, -5, Integer.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE);
        builder.add1(SqlTypeName.VARCHAR, 11, "", " ", "hello world");
        builder.add1(SqlTypeName.CHAR, 5, "", "e", "hello");
        builder.add0(SqlTypeName.TIMESTAMP, 0L, 86400000L);
        block9: for (SqlOperator op : SqlStdOperatorTable.instance().getOperatorList()) {
            switch (op.getKind()) {
                case TRIM: 
                case EXISTS: {
                    continue block9;
                }
            }
            switch (op.getSyntax()) {
                case SPECIAL: {
                    continue block9;
                }
            }
            SqlOperandTypeChecker typeChecker = op.getOperandTypeChecker();
            if (typeChecker == null) continue;
            SqlOperandCountRange range = typeChecker.getOperandCountRange();
            int max = range.getMax();
            for (int n = range.getMin(); n <= max; ++n) {
                List<List<ValueType>> argValues = Collections.nCopies(n, builder.values);
                for (List args : Linq4j.product(argValues)) {
                    SqlNodeList nodeList = new SqlNodeList(SqlParserPos.ZERO);
                    int nullCount = 0;
                    for (ValueType arg : args) {
                        if (arg.value == null) {
                            ++nullCount;
                        }
                        nodeList.add(arg.node);
                    }
                    SqlCall call = op.createCall(nodeList);
                    SqlCallBinding binding = new SqlCallBinding((SqlValidator)validator, scope, call);
                    if (!typeChecker.checkOperandTypes(binding, false)) continue;
                    SqlPrettyWriter writer = new SqlPrettyWriter(CalciteSqlDialect.DEFAULT);
                    op.unparse((SqlWriter)writer, call, 0, 0);
                    String s = writer.toSqlString().toString();
                    if (s.startsWith("OVERLAY(") || s.contains(" / 0") || s.matches("MOD\\(.*, 0\\)")) continue;
                    Strong.Policy policy = Strong.policy((SqlKind)op.kind);
                    try {
                        if (nullCount > 0 && policy == Strong.Policy.ANY) {
                            this.tester.checkNull(s);
                            continue;
                        }
                        String query = op instanceof SqlAggFunction ? (op.requiresOrder() ? "SELECT " + s + " OVER () FROM (VALUES (1))" : "SELECT " + s + " FROM (VALUES (1))") : AbstractSqlTester.buildQuery(s);
                        this.tester.check(query, SqlTests.ANY_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, result -> {});
                    }
                    catch (Error e) {
                        System.out.println(s + ": " + e.getMessage());
                        throw e;
                    }
                    catch (Exception e) {
                        System.out.println("Failed: " + s + ": " + e.getMessage());
                    }
                }
            }
        }
    }

    private List<Object> getValues(BasicSqlType type, boolean inBound) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (boolean sign : FALSE_TRUE) {
            for (SqlTypeName.Limit limit : SqlTypeName.Limit.values()) {
                Object o = type.getLimit(sign, limit, !inBound);
                if (o == null || values.contains(o)) continue;
                values.add(o);
            }
        }
        return values;
    }

    public static SqlTester tester() {
        return new TesterImpl(SqlTestFactory.INSTANCE);
    }

    static {
        CURRENT_TZ = LOCAL_TZ = TimeZone.getDefault();
        INVALID_ARG_FOR_POWER = Pattern.compile("(?s).*Invalid argument\\(s\\) for 'POWER' function.*");
        CODE_2201F = Pattern.compile("(?s).*could not calculate results for the following row.*PC=5 Code=2201F.*");
    }

    class OverlapChecker {
        final String[] values;

        OverlapChecker(String ... values) {
            this.values = values;
        }

        public void isTrue(String s) {
            SqlOperatorBaseTest.this.tester.checkBoolean(this.sub(s), Boolean.TRUE);
        }

        public void isFalse(String s) {
            SqlOperatorBaseTest.this.tester.checkBoolean(this.sub(s), Boolean.FALSE);
        }

        private String sub(String s) {
            return s.replace("$0", this.values[0]).replace("$1", this.values[1]).replace("$2", this.values[2]).replace("$3", this.values[3]);
        }
    }

    static class Builder {
        final RelDataTypeFactory typeFactory;
        final List<RelDataType> types = new ArrayList<RelDataType>();
        final List<ValueType> values = new ArrayList<ValueType>();

        Builder(RelDataTypeFactory typeFactory) {
            this.typeFactory = typeFactory;
        }

        public void add0(SqlTypeName typeName, Object ... values) {
            this.add(this.typeFactory.createSqlType(typeName), values);
        }

        public void add1(SqlTypeName typeName, int precision, Object ... values) {
            this.add(this.typeFactory.createSqlType(typeName, precision), values);
        }

        private void add(RelDataType type, Object[] values) {
            this.types.add(type);
            for (Object value : values) {
                this.values.add(new ValueType(type, value));
            }
            this.values.add(new ValueType(type, null));
        }
    }

    static class ValueType {
        final RelDataType type;
        final Object value;
        final SqlNode node;

        ValueType(RelDataType type, Object value) {
            this.type = type;
            this.value = value;
            this.node = this.literal(type, value);
        }

        private SqlNode literal(RelDataType type, Object value) {
            if (value == null) {
                int precision = type.getPrecision();
                int scale = type.getScale();
                if (!type.getSqlTypeName().allowsPrec()) {
                    precision = -1;
                }
                if (!type.getSqlTypeName().allowsScale()) {
                    scale = -1;
                }
                return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO), new SqlDataTypeSpec(new SqlIdentifier(type.getSqlTypeName().getName(), SqlParserPos.ZERO), precision, scale, null, null, SqlParserPos.ZERO)});
            }
            switch (type.getSqlTypeName()) {
                case BOOLEAN: {
                    return SqlLiteral.createBoolean((boolean)((Boolean)value), (SqlParserPos)SqlParserPos.ZERO);
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    return SqlLiteral.createExactNumeric((String)value.toString(), (SqlParserPos)SqlParserPos.ZERO);
                }
                case CHAR: 
                case VARCHAR: {
                    return SqlLiteral.createCharString((String)value.toString(), (SqlParserPos)SqlParserPos.ZERO);
                }
                case TIMESTAMP: {
                    TimestampString ts = TimestampString.fromMillisSinceEpoch((long)((Long)value));
                    return SqlLiteral.createTimestamp((TimestampString)ts, (int)type.getPrecision(), (SqlParserPos)SqlParserPos.ZERO);
                }
            }
            throw new AssertionError(type);
        }
    }

    protected static class TesterImpl
    extends SqlRuntimeTester {
        public TesterImpl(SqlTestFactory testFactory) {
            super(testFactory);
        }

        @Override
        public void check(String query, SqlTester.TypeChecker typeChecker, SqlTester.ParameterChecker parameterChecker, SqlTester.ResultChecker resultChecker) {
            super.check(query, typeChecker, parameterChecker, resultChecker);
            CalciteAssert.ConnectionFactory connectionFactory = (CalciteAssert.ConnectionFactory)this.getFactory().get("connectionFactory");
            try (Connection connection = connectionFactory.createConnection();
                 Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery(query);
                resultChecker.checkResult(resultSet);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected SqlTester with(SqlTestFactory factory) {
            return new TesterImpl(factory);
        }
    }

    private static class ValueOrExceptionResultChecker
    implements SqlTester.ResultChecker {
        private final Object expected;
        private final Pattern[] patterns;

        ValueOrExceptionResultChecker(Object expected, Pattern ... patterns) {
            this.expected = expected;
            this.patterns = patterns;
        }

        @Override
        public void checkResult(ResultSet result) throws Exception {
            SQLException thrown = null;
            try {
                if (!result.next()) {
                    return;
                }
                Object actual = result.getObject(1);
                Assert.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (SQLException e) {
                thrown = e;
            }
            if (thrown != null) {
                String stack = Throwables.getStackTraceAsString((Throwable)thrown);
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(stack).matches()) continue;
                    return;
                }
                Assert.fail((String)("Stack did not match any pattern; " + stack));
            }
        }
    }

    private static class ExceptionResultChecker
    implements SqlTester.ResultChecker {
        private final Pattern[] patterns;

        ExceptionResultChecker(Pattern ... patterns) {
            this.patterns = patterns;
        }

        @Override
        public void checkResult(ResultSet result) throws Exception {
            SQLException thrown = null;
            try {
                result.next();
                Assert.fail((String)"expected exception");
            }
            catch (SQLException e) {
                thrown = e;
            }
            String stack = Throwables.getStackTraceAsString((Throwable)thrown);
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(stack).matches()) continue;
                return;
            }
            Assert.fail((String)("Stack did not match any pattern; " + stack));
        }
    }
}

