/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSqlConvertletTable;
import org.apache.calcite.rex.RexSqlStandardConvertletTable;
import org.apache.calcite.rex.RexToSqlNodeConverter;
import org.apache.calcite.rex.RexToSqlNodeConverterImpl;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Closer;
import org.junit.Assert;
import org.junit.Test;

public class RexSqlStandardConvertletTableTest
extends SqlToRelTestBase {
    @Test
    public void testCoalesce() {
        Project project = (Project)this.convertSqlToRel("SELECT COALESCE(NULL, 'a')", false);
        RexNode rex = (RexNode)project.getChildExps().get(0);
        RexToSqlNodeConverter rexToSqlNodeConverter = RexSqlStandardConvertletTableTest.rexToSqlNodeConverter();
        SqlNode convertedSql = rexToSqlNodeConverter.convertNode(rex);
        Assert.assertEquals((Object)"CASE WHEN NULL IS NOT NULL THEN NULL ELSE 'a' END", (Object)convertedSql.toString());
    }

    @Test
    public void testCaseWithValue() {
        Project project = (Project)this.convertSqlToRel("SELECT CASE NULL WHEN NULL THEN NULL ELSE 'a' END", false);
        RexNode rex = (RexNode)project.getChildExps().get(0);
        RexToSqlNodeConverter rexToSqlNodeConverter = RexSqlStandardConvertletTableTest.rexToSqlNodeConverter();
        SqlNode convertedSql = rexToSqlNodeConverter.convertNode(rex);
        Assert.assertEquals((Object)"CASE WHEN NULL = NULL THEN NULL ELSE 'a' END", (Object)convertedSql.toString());
    }

    @Test
    public void testCaseNoValue() {
        Project project = (Project)this.convertSqlToRel("SELECT CASE WHEN NULL IS NULL THEN NULL ELSE 'a' END", false);
        RexNode rex = (RexNode)project.getChildExps().get(0);
        RexToSqlNodeConverter rexToSqlNodeConverter = RexSqlStandardConvertletTableTest.rexToSqlNodeConverter();
        SqlNode convertedSql = rexToSqlNodeConverter.convertNode(rex);
        Assert.assertEquals((Object)"CASE WHEN NULL IS NULL THEN NULL ELSE 'a' END", (Object)convertedSql.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RelNode convertSqlToRel(String sql, boolean simplifyRex) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(CalciteSchema.createRootSchema((boolean)false).plus()).parserConfig(SqlParser.configBuilder().build()).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        try (Closer closer = new Closer();){
            closer.add((AutoCloseable)Hook.REL_BUILDER_SIMPLIFY.addThread(Hook.propertyJ((Object)simplifyRex)));
            SqlNode parsed = planner.parse(sql);
            SqlNode validated = planner.validate(parsed);
            RelNode relNode = planner.rel((SqlNode)validated).rel;
            return relNode;
        }
        catch (SqlParseException | RelConversionException | ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static RexToSqlNodeConverter rexToSqlNodeConverter() {
        RexSqlStandardConvertletTable convertletTable = new RexSqlStandardConvertletTable();
        return new RexToSqlNodeConverterImpl((RexSqlConvertletTable)convertletTable);
    }
}

