/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.test.RexImplicationCheckerTest;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DateRangeRulesTest {
    @Test
    public void testExtractYearFromDateColumn() {
        Fixture2 f = new Fixture2();
        RexNode e = f.eq((RexNode)f.literal(2014), f.exYearD);
        Assert.assertThat((Object)DateRangeRules.extractTimeUnits((RexNode)e), (Matcher)Is.is(DateRangeRulesTest.set(TimeUnitRange.YEAR)));
        Assert.assertThat((Object)DateRangeRules.extractTimeUnits((RexNode)f.dec), (Matcher)Is.is(DateRangeRulesTest.set(new TimeUnitRange[0])));
        Assert.assertThat((Object)DateRangeRules.extractTimeUnits((RexNode)f.literal(1)), (Matcher)Is.is(DateRangeRulesTest.set(new TimeUnitRange[0])));
        this.checkDateRange(f, e, (Matcher<String>)Is.is((Object)"AND(>=($8, 2014-01-01), <($8, 2015-01-01))"));
        this.checkDateRange(f, f.eq(f.exYearD, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"AND(>=($8, 2014-01-01), <($8, 2015-01-01))"));
        this.checkDateRange(f, f.ge(f.exYearD, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($8, 2014-01-01)"));
        this.checkDateRange(f, f.gt(f.exYearD, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($8, 2015-01-01)"));
        this.checkDateRange(f, f.lt(f.exYearD, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($8, 2014-01-01)"));
        this.checkDateRange(f, f.le(f.exYearD, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($8, 2015-01-01)"));
        this.checkDateRange(f, f.ne(f.exYearD, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<>(EXTRACT(FLAG(YEAR), $8), 2014)"));
    }

    @Test
    public void testExtractYearFromTimestampColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.eq(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"AND(>=($9, 2014-01-01 00:00:00), <($9, 2015-01-01 00:00:00))"));
        this.checkDateRange(f, f.ge(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($9, 2014-01-01 00:00:00)"));
        this.checkDateRange(f, f.gt(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($9, 2015-01-01 00:00:00)"));
        this.checkDateRange(f, f.lt(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($9, 2014-01-01 00:00:00)"));
        this.checkDateRange(f, f.le(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($9, 2015-01-01 00:00:00)"));
        this.checkDateRange(f, f.ne(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<>(EXTRACT(FLAG(YEAR), $9), 2014)"));
    }

    @Test
    public void testExtractYearAndMonthFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYearD, (RexNode)f.literal(2014)), f.eq(f.exMonthD, (RexNode)f.literal(6))), "UTC", (Matcher<String>)Is.is((Object)"AND(AND(>=($8, 2014-01-01), <($8, 2015-01-01)), AND(>=($8, 2014-06-01), <($8, 2014-07-01)))"), (Matcher<String>)Is.is((Object)"AND(>=($8, 2014-01-01), <($8, 2015-01-01), >=($8, 2014-06-01), <($8, 2014-07-01))"));
    }

    @Test
    public void testExtractYearAndMonthFromDateColumn2() {
        Fixture2 f = new Fixture2();
        String s1 = "AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))";
        String s2 = "AND(>=($8, 2000-01-01), <($8, 2001-01-01), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))";
        RexNode e = f.and(f.eq(f.exYearD, (RexNode)f.literal(2000)), f.or(f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exMonthD, (RexNode)f.literal(3)), f.eq(f.exMonthD, (RexNode)f.literal(5))));
        this.checkDateRange(f, e, "UTC", (Matcher<String>)Is.is((Object)"AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))"), (Matcher<String>)Is.is((Object)"AND(>=($8, 2000-01-01), <($8, 2001-01-01), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))"));
    }

    @Test
    public void testExtractYearAndDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYearD, (RexNode)f.literal(2010)), f.eq(f.exDayD, (RexNode)f.literal(31))), (Matcher<String>)Is.is((Object)"AND(AND(>=($8, 2010-01-01), <($8, 2011-01-01)), OR(AND(>=($8, 2010-01-31), <($8, 2010-02-01)), AND(>=($8, 2010-03-31), <($8, 2010-04-01)), AND(>=($8, 2010-05-31), <($8, 2010-06-01)), AND(>=($8, 2010-07-31), <($8, 2010-08-01)), AND(>=($8, 2010-08-31), <($8, 2010-09-01)), AND(>=($8, 2010-10-31), <($8, 2010-11-01)), AND(>=($8, 2010-12-31), <($8, 2011-01-01))))"));
    }

    @Test
    public void testExtractYearMonthDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.gt(f.exYearD, (RexNode)f.literal(2010)), f.lt(f.exYearD, (RexNode)f.literal(2020)), f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exDayD, (RexNode)f.literal(29))), (Matcher<String>)Is.is((Object)"AND(>=($8, 2011-01-01), AND(>=($8, 2011-01-01), <($8, 2020-01-01)), OR(AND(>=($8, 2011-02-01), <($8, 2011-03-01)), AND(>=($8, 2012-02-01), <($8, 2012-03-01)), AND(>=($8, 2013-02-01), <($8, 2013-03-01)), AND(>=($8, 2014-02-01), <($8, 2014-03-01)), AND(>=($8, 2015-02-01), <($8, 2015-03-01)), AND(>=($8, 2016-02-01), <($8, 2016-03-01)), AND(>=($8, 2017-02-01), <($8, 2017-03-01)), AND(>=($8, 2018-02-01), <($8, 2018-03-01)), AND(>=($8, 2019-02-01), <($8, 2019-03-01))), OR(AND(>=($8, 2012-02-29), <($8, 2012-03-01)), AND(>=($8, 2016-02-29), <($8, 2016-03-01))))"));
    }

    @Test
    public void testExtractYearMonthDayFromTimestampColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.gt(f.exYearD, (RexNode)f.literal(2010)), f.lt(f.exYearD, (RexNode)f.literal(2020)), f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exDayD, (RexNode)f.literal(29))), (Matcher<String>)Is.is((Object)"AND(>=($8, 2011-01-01), AND(>=($8, 2011-01-01), <($8, 2020-01-01)), OR(AND(>=($8, 2011-02-01), <($8, 2011-03-01)), AND(>=($8, 2012-02-01), <($8, 2012-03-01)), AND(>=($8, 2013-02-01), <($8, 2013-03-01)), AND(>=($8, 2014-02-01), <($8, 2014-03-01)), AND(>=($8, 2015-02-01), <($8, 2015-03-01)), AND(>=($8, 2016-02-01), <($8, 2016-03-01)), AND(>=($8, 2017-02-01), <($8, 2017-03-01)), AND(>=($8, 2018-02-01), <($8, 2018-03-01)), AND(>=($8, 2019-02-01), <($8, 2019-03-01))), OR(AND(>=($8, 2012-02-29), <($8, 2012-03-01)), AND(>=($8, 2016-02-29), <($8, 2016-03-01))))"));
    }

    @Test
    public void testExtractWithOrCondition1() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.or(f.and(f.eq(f.exYearD, (RexNode)f.literal(2000)), f.or(f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exMonthD, (RexNode)f.literal(3)), f.eq(f.exMonthD, (RexNode)f.literal(5)))), f.and(f.eq(f.exYearD, (RexNode)f.literal(2001)), f.eq(f.exMonthD, (RexNode)f.literal(1)))), (Matcher<String>)Is.is((Object)"OR(AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01)))), AND(AND(>=($8, 2001-01-01), <($8, 2002-01-01)), AND(>=($8, 2001-01-01), <($8, 2001-02-01))))"));
    }

    @Test
    public void testExtractWithOrCondition2() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.or(f.eq(f.exYearD, (RexNode)f.literal(2000)), f.eq(f.exYearD, (RexNode)f.literal(2001))), f.or(f.and(f.eq(f.exYearD, (RexNode)f.literal(2000)), f.or(f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exMonthD, (RexNode)f.literal(3)), f.eq(f.exMonthD, (RexNode)f.literal(5)))), f.and(f.eq(f.exYearD, (RexNode)f.literal(2001)), f.eq(f.exMonthD, (RexNode)f.literal(1))))), (Matcher<String>)Is.is((Object)"AND(OR(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), AND(>=($8, 2001-01-01), <($8, 2002-01-01))), OR(AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01)))), AND(AND(>=($8, 2001-01-01), <($8, 2002-01-01)), AND(>=($8, 2001-01-01), <($8, 2001-02-01)))))"));
    }

    @Test
    public void testExtractPartialRewriteForNotEqualsYear() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.ne(f.exYearD, (RexNode)f.literal(2000)), f.or(f.and(f.eq(f.exYearD, (RexNode)f.literal(2000)), f.or(f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exMonthD, (RexNode)f.literal(3)), f.eq(f.exMonthD, (RexNode)f.literal(5)))), f.and(f.eq(f.exYearD, (RexNode)f.literal(2001)), f.eq(f.exMonthD, (RexNode)f.literal(1))))), (Matcher<String>)Is.is((Object)"AND(<>(EXTRACT(FLAG(YEAR), $8), 2000), OR(AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01)))), AND(AND(>=($8, 2001-01-01), <($8, 2002-01-01)), AND(>=($8, 2001-01-01), <($8, 2001-02-01)))))"));
    }

    @Test
    public void testExtractPartialRewriteForInMonth() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.or(f.eq(f.exMonthD, (RexNode)f.literal(1)), f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exMonthD, (RexNode)f.literal(3)), f.eq(f.exMonthD, (RexNode)f.literal(4)), f.eq(f.exMonthD, (RexNode)f.literal(5))), f.or(f.and(f.eq(f.exYearD, (RexNode)f.literal(2000)), f.or(f.eq(f.exMonthD, (RexNode)f.literal(2)), f.eq(f.exMonthD, (RexNode)f.literal(3)), f.eq(f.exMonthD, (RexNode)f.literal(5)))), f.and(f.eq(f.exYearD, (RexNode)f.literal(2001)), f.eq(f.exMonthD, (RexNode)f.literal(1))))), (Matcher<String>)Is.is((Object)"AND(OR(=(EXTRACT(FLAG(MONTH), $8), 1), =(EXTRACT(FLAG(MONTH), $8), 2), =(EXTRACT(FLAG(MONTH), $8), 3), =(EXTRACT(FLAG(MONTH), $8), 4), =(EXTRACT(FLAG(MONTH), $8), 5)), OR(AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01)))), AND(AND(>=($8, 2001-01-01), <($8, 2002-01-01)), AND(>=($8, 2001-01-01), <($8, 2001-02-01)))))"));
    }

    @Test
    public void testExtractRewriteForInvalidMonthComparison() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(14))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), false)"));
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(0))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), false)"));
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(13))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), false)"));
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(12))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-12-01 00:00:00), <($9, 2011-01-01 00:00:00)))"));
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(1))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-01-01 00:00:00), <($9, 2010-02-01 00:00:00)))"));
    }

    @Test
    public void testExtractRewriteForInvalidDayComparison() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(11)), f.eq(f.exDayTs, (RexNode)f.literal(32))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-11-01 00:00:00), <($9, 2010-12-01 00:00:00)), false)"));
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(2)), f.eq(f.exDayTs, (RexNode)f.literal(31))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-02-01 00:00:00), <($9, 2010-03-01 00:00:00)), false)"));
    }

    @Test
    public void testUnboundYearExtractRewrite() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.le(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(11)), f.eq(f.exDayTs, (RexNode)f.literal(2))), (Matcher<String>)Is.is((Object)"AND(<($9, 2011-01-01 00:00:00), =(EXTRACT(FLAG(MONTH), $9), 11), =(EXTRACT(FLAG(DAY), $9), 2))"));
        this.checkDateRange(f, f.and(f.ge(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(11)), f.eq(f.exDayTs, (RexNode)f.literal(2))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-01-01 00:00:00), =(EXTRACT(FLAG(MONTH), $9), 11), =(EXTRACT(FLAG(DAY), $9), 2))"));
        this.checkDateRange(f, f.and(f.le(f.exYearTs, (RexNode)f.literal(2010)), f.ge(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(5))), (Matcher<String>)Is.is((Object)"AND(<($9, 2011-01-01 00:00:00), AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-05-01 00:00:00), <($9, 2010-06-01 00:00:00)))"));
    }

    @Test
    public void testExtractRewriteMultipleOperands() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(10)), f.eq(f.exMonthD, (RexNode)f.literal(5))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-10-01 00:00:00), <($9, 2010-11-01 00:00:00)), =(EXTRACT(FLAG(MONTH), $8), 5))"));
        this.checkDateRange(f, f.and(f.eq(f.exYearTs, (RexNode)f.literal(2010)), f.eq(f.exMonthTs, (RexNode)f.literal(10)), f.eq(f.exYearD, (RexNode)f.literal(2011)), f.eq(f.exMonthD, (RexNode)f.literal(5))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-10-01 00:00:00), <($9, 2010-11-01 00:00:00)), AND(>=($8, 2011-01-01), <($8, 2012-01-01)), AND(>=($8, 2011-05-01), <($8, 2011-06-01)))"));
    }

    @Test
    public void testFloorEqRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.eq(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"false"));
        this.checkDateRange(f, f.eq(f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c)), f.floorYear), (Matcher<String>)Is.is((Object)"false"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00))"));
        c.set(2010, 1, 1, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.floorMonth, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-01 00:00:00), <($9, 2010-03-01 00:00:00))"));
        c.set(2010, 11, 1, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.floorMonth, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-12-01 00:00:00), <($9, 2011-01-01 00:00:00))"));
        c.set(2010, 1, 4, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.floorDay, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-04 00:00:00), <($9, 2010-02-05 00:00:00))"));
        c.set(2010, 11, 31, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.floorDay, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-12-31 00:00:00), <($9, 2011-01-01 00:00:00))"));
        c.set(2010, 1, 4, 4, 0, 0);
        this.checkDateRange(f, f.eq(f.floorHour, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-04 04:00:00), <($9, 2010-02-04 05:00:00))"));
        c.set(2010, 11, 31, 23, 0, 0);
        this.checkDateRange(f, f.eq(f.floorHour, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-12-31 23:00:00), <($9, 2011-01-01 00:00:00))"));
        c.set(2010, 1, 4, 2, 32, 0);
        this.checkDateRange(f, f.eq(f.floorMinute, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-04 02:32:00), <($9, 2010-02-04 02:33:00))"));
        c.set(2010, 1, 4, 2, 59, 0);
        this.checkDateRange(f, f.eq(f.floorMinute, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-04 02:59:00), <($9, 2010-02-04 03:00:00))"));
    }

    @Test
    public void testFloorLtRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.lt(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<($9, 2011-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.lt(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<($9, 2010-01-01 00:00:00)"));
    }

    @Test
    public void testFloorLeRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.le(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<($9, 2011-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.le(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<($9, 2011-01-01 00:00:00)"));
    }

    @Test
    public void testFloorGtRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.gt(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">=($9, 2011-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.gt(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">=($9, 2011-01-01 00:00:00)"));
    }

    @Test
    public void testFloorGeRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.ge(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">=($9, 2011-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.ge(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">=($9, 2010-01-01 00:00:00)"));
    }

    @Test
    public void testFloorExtractBothRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        Fixture2 f = new Fixture2();
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.and(f.eq(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), f.eq(f.exMonthTs, (RexNode)f.literal(5))), (Matcher<String>)Is.is((Object)"AND(AND(>=($9, 2010-01-01 00:00:00), <($9, 2011-01-01 00:00:00)), AND(>=($9, 2010-05-01 00:00:00), <($9, 2010-06-01 00:00:00)))"));
        this.checkDateRange(f, f.and(f.le(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), f.eq(f.exMonthTs, (RexNode)f.literal(5))), (Matcher<String>)Is.is((Object)"AND(<($9, 2011-01-01 00:00:00), =(EXTRACT(FLAG(MONTH), $9), 5))"));
        this.checkDateRange(f, f.and(f.gt(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), f.eq(f.exMonthTs, (RexNode)f.literal(5))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2011-01-01 00:00:00), =(EXTRACT(FLAG(MONTH), $9), 5))"));
        this.checkDateRange(f, f.and(f.le(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), f.eq(f.exMonthTs, (RexNode)f.literal(5)), f.ge(f.floorYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c)))), (Matcher<String>)Is.is((Object)"AND(<($9, 2011-01-01 00:00:00), AND(>=($9, 2010-05-01 00:00:00), <($9, 2010-06-01 00:00:00)), >=($9, 2010-01-01 00:00:00))"));
    }

    @Test
    public void testCeilEqRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.eq(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"false"));
        this.checkDateRange(f, f.eq(f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c)), f.ceilYear), (Matcher<String>)Is.is((Object)"false"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2009-01-01 00:00:00), <=($9, 2010-01-01 00:00:00))"));
        c.set(2010, 1, 1, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.ceilMonth, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-01-01 00:00:00), <=($9, 2010-02-01 00:00:00))"));
        c.set(2010, 11, 1, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.ceilMonth, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-11-01 00:00:00), <=($9, 2010-12-01 00:00:00))"));
        c.set(2010, 1, 4, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.ceilDay, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-02-03 00:00:00), <=($9, 2010-02-04 00:00:00))"));
        c.set(2010, 11, 31, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.ceilDay, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-12-30 00:00:00), <=($9, 2010-12-31 00:00:00))"));
        c.set(2010, 1, 4, 4, 0, 0);
        this.checkDateRange(f, f.eq(f.ceilHour, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-02-04 03:00:00), <=($9, 2010-02-04 04:00:00))"));
        c.set(2010, 11, 31, 23, 0, 0);
        this.checkDateRange(f, f.eq(f.ceilHour, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-12-31 22:00:00), <=($9, 2010-12-31 23:00:00))"));
        c.set(2010, 1, 4, 2, 32, 0);
        this.checkDateRange(f, f.eq(f.ceilMinute, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-02-04 02:31:00), <=($9, 2010-02-04 02:32:00))"));
        c.set(2010, 1, 4, 2, 59, 0);
        this.checkDateRange(f, f.eq(f.ceilMinute, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"AND(>($9, 2010-02-04 02:58:00), <=($9, 2010-02-04 02:59:00))"));
    }

    @Test
    public void testCeilLtRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.lt(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<=($9, 2010-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.lt(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<=($9, 2009-01-01 00:00:00)"));
    }

    @Test
    public void testCeilLeRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.le(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<=($9, 2010-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.le(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)"<=($9, 2010-01-01 00:00:00)"));
    }

    @Test
    public void testCeilGtRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.gt(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">($9, 2010-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.gt(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">($9, 2010-01-01 00:00:00)"));
    }

    @Test
    public void testCeilGeRewrite() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 10, 11, 12, 5);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.ge(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">($9, 2010-01-01 00:00:00)"));
        c.clear();
        c.set(2010, 0, 1, 0, 0, 0);
        this.checkDateRange(f, f.ge(f.ceilYear, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), (Matcher<String>)Is.is((Object)">($9, 2009-01-01 00:00:00)"));
    }

    @Test
    public void testFloorRewriteWithTimezone() {
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 1, 1, 11, 30, 0);
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.eq(f.floorHour, f.timestampLocalTzLiteral(TimestampString.fromCalendarFields((Calendar)c))), "IST", (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-01 17:00:00), <($9, 2010-02-01 18:00:00))"), (Matcher<String>)CoreMatchers.any(String.class));
        c.clear();
        c.set(2010, 1, 1, 11, 0, 0);
        this.checkDateRange(f, f.eq(f.floorHour, f.timestampLiteral(TimestampString.fromCalendarFields((Calendar)c))), "IST", (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-01 11:00:00), <($9, 2010-02-01 12:00:00))"), (Matcher<String>)CoreMatchers.any(String.class));
        c.clear();
        c.set(2010, 1, 1, 0, 0, 0);
        this.checkDateRange(f, f.eq(f.floorHour, f.dateLiteral(DateString.fromCalendarFields((Calendar)c))), "IST", (Matcher<String>)Is.is((Object)"AND(>=($9, 2010-02-01 00:00:00), <($9, 2010-02-01 01:00:00))"), (Matcher<String>)CoreMatchers.any(String.class));
    }

    private static Set<TimeUnitRange> set(TimeUnitRange ... es) {
        return ImmutableSet.copyOf((Object[])es);
    }

    private void checkDateRange(RexImplicationCheckerTest.Fixture f, RexNode e, Matcher<String> matcher) {
        this.checkDateRange(f, e, "UTC", matcher, (Matcher<String>)CoreMatchers.any(String.class));
    }

    private void checkDateRange(RexImplicationCheckerTest.Fixture f, RexNode e, String timeZone, Matcher<String> matcher, Matcher<String> simplifyMatcher) {
        e = DateRangeRules.replaceTimeUnits((RexBuilder)f.rexBuilder, (RexNode)e, (String)timeZone);
        Assert.assertThat((Object)e.toString(), matcher);
        RexNode e2 = f.simplify.simplify(e);
        Assert.assertThat((Object)e2.toString(), simplifyMatcher);
    }

    private static class Fixture2
    extends RexImplicationCheckerTest.Fixture {
        private final RexNode exYearTs;
        private final RexNode exMonthTs;
        private final RexNode exDayTs;
        private final RexNode exYearD;
        private final RexNode exMonthD;
        private final RexNode exDayD;
        private final RexNode floorYear;
        private final RexNode floorMonth;
        private final RexNode floorDay;
        private final RexNode floorHour;
        private final RexNode floorMinute;
        private final RexNode ceilYear;
        private final RexNode ceilMonth;
        private final RexNode ceilDay;
        private final RexNode ceilHour;
        private final RexNode ceilMinute;

        Fixture2() {
            this.exYearTs = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR), (Object)this.ts));
            this.exMonthTs = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), (Object)this.ts));
            this.exDayTs = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.ts));
            this.exYearD = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR), (Object)this.d));
            this.exMonthD = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), (Object)this.d));
            this.exDayD = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.d));
            this.floorYear = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.FLOOR, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR)));
            this.floorMonth = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.FLOOR, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH)));
            this.floorDay = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.FLOOR, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY)));
            this.floorHour = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.FLOOR, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.HOUR)));
            this.floorMinute = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.FLOOR, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MINUTE)));
            this.ceilYear = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.CEIL, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR)));
            this.ceilMonth = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.CEIL, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH)));
            this.ceilDay = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.CEIL, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY)));
            this.ceilHour = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.CEIL, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.HOUR)));
            this.ceilMinute = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.CEIL, (List)ImmutableList.of((Object)this.ts, (Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MINUTE)));
        }
    }
}

