/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelDistributions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelDistributionTest {
    @Test
    public void testRelDistributionSatisfy() {
        RelDistribution distribution1 = RelDistributions.hash((Collection)ImmutableList.of((Object)0));
        RelDistribution distribution2 = RelDistributions.hash((Collection)ImmutableList.of((Object)1));
        RelTraitSet traitSet = RelTraitSet.createEmpty();
        RelTraitSet simpleTrait1 = traitSet.plus((RelTrait)distribution1);
        RelTraitSet simpleTrait2 = traitSet.plus((RelTrait)distribution2);
        RelTraitSet compositeTrait = traitSet.replace((RelTraitDef)RelDistributionTraitDef.INSTANCE, (List)ImmutableList.of((Object)distribution1, (Object)distribution2));
        Assert.assertThat((Object)compositeTrait.satisfies(simpleTrait1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)compositeTrait.satisfies(simpleTrait2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)distribution1.compareTo((Object)distribution2), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)distribution2.compareTo((Object)distribution1), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)distribution2.compareTo((Object)distribution2), (Matcher)CoreMatchers.is((Object)0));
    }
}

