/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeRootNode;
import org.apache.calcite.materialize.LatticeSuggester;
import org.apache.calcite.prepare.PlannerImpl;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.FoodMartQuerySet;
import org.apache.calcite.test.SlowTests;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Util;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTests.class})
public class LatticeSuggesterTest {
    @Test
    public void testEmpDept() throws Exception {
        Tester t = new Tester();
        String q0 = "select dept.dname, count(*), sum(sal)\nfrom emp\njoin dept using (deptno)\ngroup by dept.dname";
        Assert.assertThat(t.addQuery("select dept.dname, count(*), sum(sal)\nfrom emp\njoin dept using (deptno)\ngroup by dept.dname"), this.isGraphs("EMP (DEPT:DEPTNO)", "[COUNT(), SUM(EMP.SAL)]"));
        String q1 = "select dept.dname, count(*), sum(sal)\nfrom emp, dept\nwhere emp.deptno = dept.deptno\ngroup by dept.dname";
        Assert.assertThat(t.addQuery("select dept.dname, count(*), sum(sal)\nfrom emp, dept\nwhere emp.deptno = dept.deptno\ngroup by dept.dname"), this.isGraphs("EMP (DEPT:DEPTNO)", "[COUNT(), SUM(EMP.SAL)]"));
        String q2 = "select dept.dname\nfrom emp, dept\nwhere emp.deptno = dept.deptno\ngroup by dept.dname\nhaving count(*) > 10";
        Assert.assertThat(t.addQuery("select dept.dname\nfrom emp, dept\nwhere emp.deptno = dept.deptno\ngroup by dept.dname\nhaving count(*) > 10"), this.isGraphs("EMP (DEPT:DEPTNO)", "[COUNT()]"));
        String q3 = "select distinct dname\nfrom dept";
        Assert.assertThat(t.addQuery("select distinct dname\nfrom dept"), this.isGraphs("DEPT", "[]"));
        String q4 = "select distinct t.c\nfrom (values 1, 2) as t(c)join (values 2, 3) as u(c) using (c)\n";
        Assert.assertThat(t.addQuery("select distinct t.c\nfrom (values 1, 2) as t(c)join (values 2, 3) as u(c) using (c)\n"), this.isGraphs(new String[0]));
        String q5 = "select *\nfrom emp as e\njoin emp as m on e.mgr = m.empno";
        Assert.assertThat(t.addQuery("select *\nfrom emp as e\njoin emp as m on e.mgr = m.empno"), this.isGraphs("EMP (EMP:MGR)", "[]"));
        String q6 = "select *\nfrom emp as e join emp as m on e.mgr = m.empno\njoin emp as m2 on m.mgr = m2.empno";
        Assert.assertThat(t.addQuery("select *\nfrom emp as e join emp as m on e.mgr = m.empno\njoin emp as m2 on m.mgr = m2.empno"), this.isGraphs("EMP (EMP:MGR (EMP:MGR))", "[]"));
        String q7 = "select *\nfrom emp as e\njoin emp as m on e.mgr = m.empno\njoin emp as m2 on m.mgr = m2.empno\nwhere m2.mgr = e.empno";
        Assert.assertThat(t.addQuery("select *\nfrom emp as e\njoin emp as m on e.mgr = m.empno\njoin emp as m2 on m.mgr = m2.empno\nwhere m2.mgr = e.empno"), this.isGraphs(new String[0]));
        String expected = "graph(vertices: [[scott, DEPT], [scott, EMP]], edges: [Step([scott, EMP], [scott, DEPT], DEPTNO:DEPTNO), Step([scott, EMP], [scott, EMP], MGR:EMPNO)])";
        Assert.assertThat((Object)t.s.space.g.toString(), (Matcher)CoreMatchers.is((Object)"graph(vertices: [[scott, DEPT], [scott, EMP]], edges: [Step([scott, EMP], [scott, DEPT], DEPTNO:DEPTNO), Step([scott, EMP], [scott, EMP], MGR:EMPNO)])"));
    }

    @Test
    public void testFoodmart() throws Exception {
        Tester t = new Tester().foodmart();
        String q = "select \"t\".\"the_year\" as \"c0\",\n \"t\".\"quarter\" as \"c1\",\n \"pc\".\"product_family\" as \"c2\",\n sum(\"s\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"t\",\n \"sales_fact_1997\" as \"s\",\n \"product_class\" as \"pc\",\n \"product\" as \"p\"\nwhere \"s\".\"time_id\" = \"t\".\"time_id\"\nand \"t\".\"the_year\" = 1997\nand \"s\".\"product_id\" = \"p\".\"product_id\"\nand \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"\ngroup by \"t\".\"the_year\",\n \"t\".\"quarter\",\n \"pc\".\"product_family\"";
        String g = "sales_fact_1997 (product:product_id (product_class:product_class_id) time_by_day:time_id)";
        Assert.assertThat(t.addQuery("select \"t\".\"the_year\" as \"c0\",\n \"t\".\"quarter\" as \"c1\",\n \"pc\".\"product_family\" as \"c2\",\n sum(\"s\".\"unit_sales\") as \"m0\"\nfrom \"time_by_day\" as \"t\",\n \"sales_fact_1997\" as \"s\",\n \"product_class\" as \"pc\",\n \"product\" as \"p\"\nwhere \"s\".\"time_id\" = \"t\".\"time_id\"\nand \"t\".\"the_year\" = 1997\nand \"s\".\"product_id\" = \"p\".\"product_id\"\nand \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"\ngroup by \"t\".\"the_year\",\n \"t\".\"quarter\",\n \"pc\".\"product_family\""), this.isGraphs("sales_fact_1997 (product:product_id (product_class:product_class_id) time_by_day:time_id)", "[SUM(sales_fact_1997.unit_sales)]"));
        String expected = "graph(vertices: [[foodmart, product], [foodmart, product_class], [foodmart, sales_fact_1997], [foodmart, time_by_day]], edges: [Step([foodmart, product], [foodmart, product_class], product_class_id:product_class_id), Step([foodmart, sales_fact_1997], [foodmart, product], product_id:product_id), Step([foodmart, sales_fact_1997], [foodmart, time_by_day], time_id:time_id)])";
        Assert.assertThat((Object)t.s.space.g.toString(), (Matcher)CoreMatchers.is((Object)"graph(vertices: [[foodmart, product], [foodmart, product_class], [foodmart, sales_fact_1997], [foodmart, time_by_day]], edges: [Step([foodmart, product], [foodmart, product_class], product_class_id:product_class_id), Step([foodmart, sales_fact_1997], [foodmart, product], product_id:product_id), Step([foodmart, sales_fact_1997], [foodmart, time_by_day], time_id:time_id)])"));
    }

    @Test
    public void testAggregateExpression() throws Exception {
        Tester t = new Tester().foodmart();
        String q = "select \"t\".\"the_year\" as \"c0\",\n \"pc\".\"product_family\" as \"c1\",\n sum((case when \"s\".\"promotion_id\" = 0\n     then 0 else \"s\".\"store_sales\"\n     end)) as \"sum_m0\"\nfrom \"time_by_day\" as \"t\",\n \"sales_fact_1997\" as \"s\",\n \"product_class\" as \"pc\",\n \"product\" as \"p\"\nwhere \"s\".\"time_id\" = \"t\".\"time_id\"\n and \"t\".\"the_year\" = 1997\n and \"s\".\"product_id\" = \"p\".\"product_id\"\n and \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"\ngroup by \"t\".\"the_year\",\n \"pc\".\"product_family\"\n";
        String g = "sales_fact_1997 (product:product_id (product_class:product_class_id) time_by_day:time_id)";
        String expected = "[SUM(m0)]";
        Assert.assertThat(t.addQuery("select \"t\".\"the_year\" as \"c0\",\n \"pc\".\"product_family\" as \"c1\",\n sum((case when \"s\".\"promotion_id\" = 0\n     then 0 else \"s\".\"store_sales\"\n     end)) as \"sum_m0\"\nfrom \"time_by_day\" as \"t\",\n \"sales_fact_1997\" as \"s\",\n \"product_class\" as \"pc\",\n \"product\" as \"p\"\nwhere \"s\".\"time_id\" = \"t\".\"time_id\"\n and \"t\".\"the_year\" = 1997\n and \"s\".\"product_id\" = \"p\".\"product_id\"\n and \"p\".\"product_class_id\" = \"pc\".\"product_class_id\"\ngroup by \"t\".\"the_year\",\n \"pc\".\"product_family\"\n"), (Matcher)CoreMatchers.allOf(this.isGraphs("sales_fact_1997 (product:product_id (product_class:product_class_id) time_by_day:time_id)", "[SUM(m0)]"), this.hasMeasureNames(0, "sum_m0"), this.hasDerivedColumnNames(0, "m0")));
    }

    private Matcher<List<Lattice>> hasMeasureNames(final int ordinal, final String ... names) {
        ImmutableList nameList = ImmutableList.copyOf((Object[])names);
        return new TypeSafeMatcher<List<Lattice>>((List)nameList){
            final /* synthetic */ List val$nameList;
            {
                this.val$nameList = list;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)names);
            }

            protected boolean matchesSafely(List<Lattice> lattices) {
                Lattice lattice = lattices.get(ordinal);
                List actualNameList = Util.transform((List)lattice.defaultMeasures, measure -> measure.name);
                return actualNameList.equals(this.val$nameList);
            }
        };
    }

    private Matcher<List<Lattice>> hasDerivedColumnNames(final int ordinal, final String ... names) {
        ImmutableList nameList = ImmutableList.copyOf((Object[])names);
        return new TypeSafeMatcher<List<Lattice>>((List)nameList){
            final /* synthetic */ List val$nameList;
            {
                this.val$nameList = list;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)names);
            }

            protected boolean matchesSafely(List<Lattice> lattices) {
                Lattice lattice = lattices.get(ordinal);
                List actualNameList = lattice.columns.stream().filter(c -> c instanceof Lattice.DerivedColumn).map(c -> ((Lattice.DerivedColumn)c).alias).collect(Collectors.toList());
                return actualNameList.equals(this.val$nameList);
            }
        };
    }

    @Test
    public void testSharedSnowflake() throws Exception {
        Tester t = new Tester().foodmart();
        String q = "select \"s\".\"store_country\" as \"c0\",\n \"r\".\"sales_region\" as \"c1\",\n \"r1\".\"sales_region\" as \"c2\",\n sum(\"f\".\"unit_sales\") as \"m0\"\nfrom \"store\" as \"s\",\n \"sales_fact_1997\" as \"f\",\n \"region\" as \"r\",\n \"region\" as \"r1\",\n \"customer\" as \"c\"\nwhere \"f\".\"store_id\" = \"s\".\"store_id\"\n and \"s\".\"store_country\" = 'USA'\n and \"s\".\"region_id\" = \"r\".\"region_id\"\n and \"r\".\"sales_region\" = 'South West'\n and \"f\".\"customer_id\" = \"c\".\"customer_id\"\n and \"c\".\"customer_region_id\" = \"r1\".\"region_id\"\n and \"r1\".\"sales_region\" = 'South West'\ngroup by \"s\".\"store_country\",\n \"r\".\"sales_region\",\n \"r1\".\"sales_region\"\n";
        String g = "sales_fact_1997 (customer:customer_id (region:customer_region_id) store:store_id (region:region_id))";
        Assert.assertThat(t.addQuery("select \"s\".\"store_country\" as \"c0\",\n \"r\".\"sales_region\" as \"c1\",\n \"r1\".\"sales_region\" as \"c2\",\n sum(\"f\".\"unit_sales\") as \"m0\"\nfrom \"store\" as \"s\",\n \"sales_fact_1997\" as \"f\",\n \"region\" as \"r\",\n \"region\" as \"r1\",\n \"customer\" as \"c\"\nwhere \"f\".\"store_id\" = \"s\".\"store_id\"\n and \"s\".\"store_country\" = 'USA'\n and \"s\".\"region_id\" = \"r\".\"region_id\"\n and \"r\".\"sales_region\" = 'South West'\n and \"f\".\"customer_id\" = \"c\".\"customer_id\"\n and \"c\".\"customer_region_id\" = \"r1\".\"region_id\"\n and \"r1\".\"sales_region\" = 'South West'\ngroup by \"s\".\"store_country\",\n \"r\".\"sales_region\",\n \"r1\".\"sales_region\"\n"), this.isGraphs("sales_fact_1997 (customer:customer_id (region:customer_region_id) store:store_id (region:region_id))", "[SUM(sales_fact_1997.unit_sales)]"));
    }

    @Test
    public void testExpressionInAggregate() throws Exception {
        Tester t = new Tester().withEvolve(true).foodmart();
        FoodMartQuerySet set = FoodMartQuerySet.instance();
        for (int id : new int[]{392, 393}) {
            t.addQuery(set.queries.get((Object)Integer.valueOf((int)id)).sql);
        }
    }

    private void checkFoodMartAll(boolean evolve) throws Exception {
        Tester t = new Tester().foodmart().withEvolve(evolve);
        FoodMartQuerySet set = FoodMartQuerySet.instance();
        block3: for (FoodMartQuerySet.FoodmartQuery query : set.queries.values()) {
            if (query.sql.contains("\"agg_10_foo_fact\"") || query.sql.contains("\"agg_line_class\"") || query.sql.contains("\"agg_tenant\"") || query.sql.contains("\"line\"") || query.sql.contains("\"line_class\"") || query.sql.contains("\"tenant\"") || query.sql.contains("\"test_lp_xxx_fact\"") || query.sql.contains("\"product_csv\"") || query.sql.contains("\"product_cat\"") || query.sql.contains("\"cat\"") || query.sql.contains("\"fact\"")) continue;
            switch (query.id) {
                case 2455: 
                case 2456: 
                case 2457: 
                case 5682: 
                case 5700: {
                    continue block3;
                }
            }
            t.addQuery(query.sql);
        }
        String expected = "graph(vertices: [[foodmart, agg_c_10_sales_fact_1997], [foodmart, agg_c_14_sales_fact_1997], [foodmart, agg_c_special_sales_fact_1997], [foodmart, agg_g_ms_pcat_sales_fact_1997], [foodmart, agg_l_03_sales_fact_1997], [foodmart, agg_l_04_sales_fact_1997], [foodmart, agg_l_05_sales_fact_1997], [foodmart, agg_lc_06_sales_fact_1997], [foodmart, agg_lc_100_sales_fact_1997], [foodmart, agg_ll_01_sales_fact_1997], [foodmart, agg_pl_01_sales_fact_1997], [foodmart, customer], [foodmart, department], [foodmart, employee], [foodmart, employee_closure], [foodmart, inventory_fact_1997], [foodmart, position], [foodmart, product], [foodmart, product_class], [foodmart, promotion], [foodmart, region], [foodmart, salary], [foodmart, sales_fact_1997], [foodmart, store], [foodmart, store_ragged], [foodmart, time_by_day], [foodmart, warehouse], [foodmart, warehouse_class]], edges: [Step([foodmart, agg_c_14_sales_fact_1997], [foodmart, store], store_id:store_id), Step([foodmart, agg_c_14_sales_fact_1997], [foodmart, time_by_day], month_of_year:month_of_year), Step([foodmart, customer], [foodmart, region], customer_region_id:region_id), Step([foodmart, customer], [foodmart, store], state_province:store_state), Step([foodmart, employee], [foodmart, employee], supervisor_id:employee_id), Step([foodmart, employee], [foodmart, position], position_id:position_id), Step([foodmart, employee], [foodmart, store], store_id:store_id), Step([foodmart, inventory_fact_1997], [foodmart, employee], product_id:employee_id), Step([foodmart, inventory_fact_1997], [foodmart, employee], time_id:employee_id), Step([foodmart, inventory_fact_1997], [foodmart, product], product_id:product_id), Step([foodmart, inventory_fact_1997], [foodmart, store], store_id:store_id), Step([foodmart, inventory_fact_1997], [foodmart, store], warehouse_id:store_id), Step([foodmart, inventory_fact_1997], [foodmart, time_by_day], time_id:time_id), Step([foodmart, inventory_fact_1997], [foodmart, warehouse], warehouse_id:warehouse_id), Step([foodmart, product], [foodmart, product_class], product_class_id:product_class_id), Step([foodmart, product], [foodmart, store], product_class_id:store_id), Step([foodmart, product_class], [foodmart, store], product_class_id:region_id), Step([foodmart, salary], [foodmart, department], department_id:department_id), Step([foodmart, salary], [foodmart, employee], employee_id:employee_id), Step([foodmart, salary], [foodmart, employee_closure], employee_id:employee_id), Step([foodmart, salary], [foodmart, time_by_day], pay_date:the_date), Step([foodmart, sales_fact_1997], [foodmart, customer], customer_id:customer_id), Step([foodmart, sales_fact_1997], [foodmart, customer], product_id:customer_id), Step([foodmart, sales_fact_1997], [foodmart, customer], store_id:customer_id), Step([foodmart, sales_fact_1997], [foodmart, product], product_id:product_id), Step([foodmart, sales_fact_1997], [foodmart, promotion], promotion_id:promotion_id), Step([foodmart, sales_fact_1997], [foodmart, store], product_id:store_id), Step([foodmart, sales_fact_1997], [foodmart, store], store_id:store_id), Step([foodmart, sales_fact_1997], [foodmart, store_ragged], store_id:store_id), Step([foodmart, sales_fact_1997], [foodmart, time_by_day], product_id:time_id), Step([foodmart, sales_fact_1997], [foodmart, time_by_day], time_id:time_id), Step([foodmart, store], [foodmart, region], region_id:region_id), Step([foodmart, store], [foodmart, warehouse], store_id:stores_id), Step([foodmart, warehouse], [foodmart, warehouse_class], warehouse_class_id:warehouse_class_id)])";
        Assert.assertThat((Object)t.s.space.g.toString(), (Matcher)CoreMatchers.is((Object)"graph(vertices: [[foodmart, agg_c_10_sales_fact_1997], [foodmart, agg_c_14_sales_fact_1997], [foodmart, agg_c_special_sales_fact_1997], [foodmart, agg_g_ms_pcat_sales_fact_1997], [foodmart, agg_l_03_sales_fact_1997], [foodmart, agg_l_04_sales_fact_1997], [foodmart, agg_l_05_sales_fact_1997], [foodmart, agg_lc_06_sales_fact_1997], [foodmart, agg_lc_100_sales_fact_1997], [foodmart, agg_ll_01_sales_fact_1997], [foodmart, agg_pl_01_sales_fact_1997], [foodmart, customer], [foodmart, department], [foodmart, employee], [foodmart, employee_closure], [foodmart, inventory_fact_1997], [foodmart, position], [foodmart, product], [foodmart, product_class], [foodmart, promotion], [foodmart, region], [foodmart, salary], [foodmart, sales_fact_1997], [foodmart, store], [foodmart, store_ragged], [foodmart, time_by_day], [foodmart, warehouse], [foodmart, warehouse_class]], edges: [Step([foodmart, agg_c_14_sales_fact_1997], [foodmart, store], store_id:store_id), Step([foodmart, agg_c_14_sales_fact_1997], [foodmart, time_by_day], month_of_year:month_of_year), Step([foodmart, customer], [foodmart, region], customer_region_id:region_id), Step([foodmart, customer], [foodmart, store], state_province:store_state), Step([foodmart, employee], [foodmart, employee], supervisor_id:employee_id), Step([foodmart, employee], [foodmart, position], position_id:position_id), Step([foodmart, employee], [foodmart, store], store_id:store_id), Step([foodmart, inventory_fact_1997], [foodmart, employee], product_id:employee_id), Step([foodmart, inventory_fact_1997], [foodmart, employee], time_id:employee_id), Step([foodmart, inventory_fact_1997], [foodmart, product], product_id:product_id), Step([foodmart, inventory_fact_1997], [foodmart, store], store_id:store_id), Step([foodmart, inventory_fact_1997], [foodmart, store], warehouse_id:store_id), Step([foodmart, inventory_fact_1997], [foodmart, time_by_day], time_id:time_id), Step([foodmart, inventory_fact_1997], [foodmart, warehouse], warehouse_id:warehouse_id), Step([foodmart, product], [foodmart, product_class], product_class_id:product_class_id), Step([foodmart, product], [foodmart, store], product_class_id:store_id), Step([foodmart, product_class], [foodmart, store], product_class_id:region_id), Step([foodmart, salary], [foodmart, department], department_id:department_id), Step([foodmart, salary], [foodmart, employee], employee_id:employee_id), Step([foodmart, salary], [foodmart, employee_closure], employee_id:employee_id), Step([foodmart, salary], [foodmart, time_by_day], pay_date:the_date), Step([foodmart, sales_fact_1997], [foodmart, customer], customer_id:customer_id), Step([foodmart, sales_fact_1997], [foodmart, customer], product_id:customer_id), Step([foodmart, sales_fact_1997], [foodmart, customer], store_id:customer_id), Step([foodmart, sales_fact_1997], [foodmart, product], product_id:product_id), Step([foodmart, sales_fact_1997], [foodmart, promotion], promotion_id:promotion_id), Step([foodmart, sales_fact_1997], [foodmart, store], product_id:store_id), Step([foodmart, sales_fact_1997], [foodmart, store], store_id:store_id), Step([foodmart, sales_fact_1997], [foodmart, store_ragged], store_id:store_id), Step([foodmart, sales_fact_1997], [foodmart, time_by_day], product_id:time_id), Step([foodmart, sales_fact_1997], [foodmart, time_by_day], time_id:time_id), Step([foodmart, store], [foodmart, region], region_id:region_id), Step([foodmart, store], [foodmart, warehouse], store_id:stores_id), Step([foodmart, warehouse], [foodmart, warehouse_class], warehouse_class_id:warehouse_class_id)])"));
        if (evolve) {
            Assert.assertThat((Object)t.s.space.nodeMap.size(), (Matcher)CoreMatchers.is((Object)133));
            Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)27));
            Assert.assertThat((Object)t.s.space.pathMap.size(), (Matcher)CoreMatchers.is((Object)42));
        } else {
            Assert.assertThat((Object)t.s.space.nodeMap.size(), (Matcher)CoreMatchers.is((Object)117));
            Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)386));
            Assert.assertThat((Object)t.s.space.pathMap.size(), (Matcher)CoreMatchers.is((Object)42));
        }
    }

    @Test
    public void testFoodMartAll() throws Exception {
        this.checkFoodMartAll(false);
    }

    @Test
    public void testFoodMartAllEvolve() throws Exception {
        this.checkFoodMartAll(true);
    }

    @Test
    public void testContains() throws Exception {
        Tester t = new Tester().foodmart();
        LatticeRootNode fNode = t.node("select *\nfrom \"sales_fact_1997\"");
        LatticeRootNode fcNode = t.node("select *\nfrom \"sales_fact_1997\"\njoin \"customer\" using (\"customer_id\")");
        LatticeRootNode fcpNode = t.node("select *\nfrom \"sales_fact_1997\"\njoin \"customer\" using (\"customer_id\")\njoin \"product\" using (\"product_id\")");
        Assert.assertThat((Object)fNode.contains(fNode), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fNode.contains(fcNode), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fNode.contains(fcpNode), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fcNode.contains(fNode), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fcNode.contains(fcNode), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fcNode.contains(fcpNode), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fcpNode.contains(fNode), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fcpNode.contains(fcNode), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fcpNode.contains(fcpNode), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEvolve() throws Exception {
        Tester t = new Tester().foodmart().withEvolve(true);
        String q0 = "select count(*)\nfrom \"sales_fact_1997\"";
        String l0 = "sales_fact_1997:[COUNT()]";
        t.addQuery("select count(*)\nfrom \"sales_fact_1997\"");
        Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)Iterables.getOnlyElement(t.s.latticeMap.keySet()), (Matcher)CoreMatchers.is((Object)"sales_fact_1997:[COUNT()]"));
        String q1 = "select sum(\"unit_sales\")\nfrom \"sales_fact_1997\"\njoin \"customer\" using (\"customer_id\")\ngroup by \"customer\".\"city\"";
        String l1 = "sales_fact_1997 (customer:customer_id):[COUNT(), SUM(sales_fact_1997.unit_sales)]";
        t.addQuery("select sum(\"unit_sales\")\nfrom \"sales_fact_1997\"\njoin \"customer\" using (\"customer_id\")\ngroup by \"customer\".\"city\"");
        Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)Iterables.getOnlyElement(t.s.latticeMap.keySet()), (Matcher)CoreMatchers.is((Object)"sales_fact_1997 (customer:customer_id):[COUNT(), SUM(sales_fact_1997.unit_sales)]"));
        String q2 = "select count(distinct \"the_day\")\nfrom \"sales_fact_1997\"\njoin \"time_by_day\" using (\"time_id\")\njoin \"product\" using (\"product_id\")";
        String l2 = "sales_fact_1997 (customer:customer_id product:product_id time_by_day:time_id):[COUNT(), SUM(sales_fact_1997.unit_sales), COUNT(DISTINCT time_by_day.the_day)]";
        t.addQuery("select count(distinct \"the_day\")\nfrom \"sales_fact_1997\"\njoin \"time_by_day\" using (\"time_id\")\njoin \"product\" using (\"product_id\")");
        Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)Iterables.getOnlyElement(t.s.latticeMap.keySet()), (Matcher)CoreMatchers.is((Object)"sales_fact_1997 (customer:customer_id product:product_id time_by_day:time_id):[COUNT(), SUM(sales_fact_1997.unit_sales), COUNT(DISTINCT time_by_day.the_day)]"));
        Lattice lattice = (Lattice)Iterables.getOnlyElement(t.s.latticeMap.values());
        List tableNames = (List)lattice.tables().stream().map(table -> table.t.getQualifiedName()).sorted(Comparator.comparing(Object::toString)).collect(Util.toImmutableList());
        Assert.assertThat((Object)tableNames.toString(), (Matcher)CoreMatchers.is((Object)"[[foodmart, customer], [foodmart, product], [foodmart, sales_fact_1997], [foodmart, time_by_day]]"));
        String q3 = "select min(\"product\".\"product_id\")\nfrom \"sales_fact_1997\"\njoin \"product\" using (\"product_id\")\njoin \"product_class\" as pc using (\"product_class_id\")\ngroup by pc.\"product_department\"";
        String l3 = "sales_fact_1997 (customer:customer_id product:product_id (product_class:product_class_id) time_by_day:time_id):[COUNT(), SUM(sales_fact_1997.unit_sales), MIN(product.product_id), COUNT(DISTINCT time_by_day.the_day)]";
        t.addQuery("select min(\"product\".\"product_id\")\nfrom \"sales_fact_1997\"\njoin \"product\" using (\"product_id\")\njoin \"product_class\" as pc using (\"product_class_id\")\ngroup by pc.\"product_department\"");
        Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)Iterables.getOnlyElement(t.s.latticeMap.keySet()), (Matcher)CoreMatchers.is((Object)"sales_fact_1997 (customer:customer_id product:product_id (product_class:product_class_id) time_by_day:time_id):[COUNT(), SUM(sales_fact_1997.unit_sales), MIN(product.product_id), COUNT(DISTINCT time_by_day.the_day)]"));
    }

    @Test
    public void testExpression() throws Exception {
        Tester t = new Tester().foodmart().withEvolve(true);
        String q0 = "select\n  \"fname\" || ' ' || \"lname\" as \"full_name\",\n  count(*) as c,\n  avg(\"total_children\" - \"num_children_at_home\")\nfrom \"customer\"\ngroup by \"fname\", \"lname\"";
        String l0 = "customer:[COUNT(), AVG($f2)]";
        t.addQuery("select\n  \"fname\" || ' ' || \"lname\" as \"full_name\",\n  count(*) as c,\n  avg(\"total_children\" - \"num_children_at_home\")\nfrom \"customer\"\ngroup by \"fname\", \"lname\"");
        Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)Iterables.getOnlyElement(t.s.latticeMap.keySet()), (Matcher)CoreMatchers.is((Object)"customer:[COUNT(), AVG($f2)]"));
        Lattice lattice = (Lattice)Iterables.getOnlyElement(t.s.latticeMap.values());
        List derivedColumns = lattice.columns.stream().filter(c -> c instanceof Lattice.DerivedColumn).map(c -> (Lattice.DerivedColumn)c).collect(Collectors.toList());
        Assert.assertThat((Object)derivedColumns.size(), (Matcher)CoreMatchers.is((Object)2));
        ImmutableList tables = ImmutableList.of((Object)"customer");
        Assert.assertThat((Object)((Lattice.DerivedColumn)derivedColumns.get((int)0)).tables, (Matcher)CoreMatchers.is((Object)tables));
        Assert.assertThat((Object)((Lattice.DerivedColumn)derivedColumns.get((int)1)).tables, (Matcher)CoreMatchers.is((Object)tables));
    }

    @Test
    public void testExpressionInJoin() throws Exception {
        Tester t = new Tester().foodmart().withEvolve(true);
        String q0 = "select\n  \"fname\" || ' ' || \"lname\" as \"full_name\",\n  count(*) as c,\n  avg(\"total_children\" - \"num_children_at_home\")\nfrom \"customer\" join \"sales_fact_1997\" using (\"customer_id\")\ngroup by \"fname\", \"lname\"";
        String l0 = "sales_fact_1997 (customer:customer_id):[COUNT(), AVG($f2)]";
        t.addQuery("select\n  \"fname\" || ' ' || \"lname\" as \"full_name\",\n  count(*) as c,\n  avg(\"total_children\" - \"num_children_at_home\")\nfrom \"customer\" join \"sales_fact_1997\" using (\"customer_id\")\ngroup by \"fname\", \"lname\"");
        Assert.assertThat((Object)t.s.latticeMap.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)Iterables.getOnlyElement(t.s.latticeMap.keySet()), (Matcher)CoreMatchers.is((Object)"sales_fact_1997 (customer:customer_id):[COUNT(), AVG($f2)]"));
        Lattice lattice = (Lattice)Iterables.getOnlyElement(t.s.latticeMap.values());
        List derivedColumns = lattice.columns.stream().filter(c -> c instanceof Lattice.DerivedColumn).map(c -> (Lattice.DerivedColumn)c).collect(Collectors.toList());
        Assert.assertThat((Object)derivedColumns.size(), (Matcher)CoreMatchers.is((Object)2));
        ImmutableList tables = ImmutableList.of((Object)"customer");
        Assert.assertThat((Object)((Lattice.DerivedColumn)derivedColumns.get((int)0)).tables, (Matcher)CoreMatchers.is((Object)tables));
        Assert.assertThat((Object)((Lattice.DerivedColumn)derivedColumns.get((int)1)).tables, (Matcher)CoreMatchers.is((Object)tables));
    }

    private BaseMatcher<List<Lattice>> isGraphs(String ... strings) {
        final List<String> expectedList = Arrays.asList(strings);
        return new BaseMatcher<List<Lattice>>(){

            public boolean matches(Object item) {
                return item instanceof List && ((List)item).size() * 2 == expectedList.size() && this.allEqual((List)item, expectedList);
            }

            private boolean allEqual(List<Lattice> items, List<String> expects) {
                for (int i = 0; i < items.size(); ++i) {
                    Lattice lattice = items.get(i);
                    String expectedNode = expects.get(2 * i);
                    if (!lattice.rootNode.digest.equals(expectedNode)) {
                        return false;
                    }
                    String expectedMeasures = expects.get(2 * i + 1);
                    if (lattice.defaultMeasures.toString().equals(expectedMeasures)) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expectedList);
            }
        };
    }

    private static class Tester {
        final LatticeSuggester s;
        private final FrameworkConfig config;

        Tester() {
            this(Frameworks.newConfigBuilder().defaultSchema(Tester.schemaFrom(CalciteAssert.SchemaSpec.SCOTT)).build());
        }

        private Tester(FrameworkConfig config) {
            this.config = config;
            this.s = new LatticeSuggester(config);
        }

        Tester withConfig(FrameworkConfig config) {
            return new Tester(config);
        }

        Tester foodmart() {
            return this.schema(CalciteAssert.SchemaSpec.JDBC_FOODMART);
        }

        private Tester schema(CalciteAssert.SchemaSpec schemaSpec) {
            return this.withConfig(this.builder().defaultSchema(Tester.schemaFrom(schemaSpec)).build());
        }

        private Frameworks.ConfigBuilder builder() {
            return Frameworks.newConfigBuilder((FrameworkConfig)this.config);
        }

        List<Lattice> addQuery(String q) throws SqlParseException, ValidationException, RelConversionException {
            PlannerImpl planner = new PlannerImpl(this.config);
            SqlNode node = planner.parse(q);
            SqlNode node2 = planner.validate(node);
            RelRoot root = planner.rel(node2);
            return this.s.addQuery(root.project());
        }

        LatticeRootNode node(String q) throws SqlParseException, ValidationException, RelConversionException {
            List<Lattice> list = this.addQuery(q);
            Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
            return list.get((int)0).rootNode;
        }

        private static SchemaPlus schemaFrom(CalciteAssert.SchemaSpec spec) {
            SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
            return CalciteAssert.addSchema(rootSchema, spec);
        }

        Tester withEvolve(boolean evolve) {
            return this.withConfig(this.builder().evolveLattice(evolve).build());
        }
    }
}

