/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.DynamicRecordTypeImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.CustomColumnResolvingTable;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.test.catalog.Fixture;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public abstract class MockCatalogReader
extends CalciteCatalogReader {
    static final String DEFAULT_CATALOG = "CATALOG";
    static final String DEFAULT_SCHEMA = "SALES";
    static final List<String> PREFIX = ImmutableList.of((Object)"SALES");

    public MockCatalogReader(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(CalciteSchema.createRootSchema((boolean)false, (boolean)false, (String)DEFAULT_CATALOG), SqlNameMatchers.withCaseSensitive((boolean)caseSensitive), (List)ImmutableList.of(PREFIX, (Object)ImmutableList.of()), typeFactory, null);
    }

    public boolean isCaseSensitive() {
        return this.nameMatcher.isCaseSensitive();
    }

    public SqlNameMatcher nameMatcher() {
        return this.nameMatcher;
    }

    public abstract MockCatalogReader init();

    protected void registerTablesWithRollUp(MockSchema schema, Fixture f) {
        MockTable empRolledTable = MockTable.create(this, schema, "EMP_R", false, 14.0);
        empRolledTable.addColumn("EMPNO", f.intType, true);
        empRolledTable.addColumn("DEPTNO", f.intType);
        empRolledTable.addColumn("SLACKER", f.booleanType);
        empRolledTable.addColumn("SLACKINGMIN", f.intType);
        empRolledTable.registerRolledUpColumn("SLACKINGMIN");
        this.registerTable(empRolledTable);
        MockTable deptSlackingTable = MockTable.create(this, schema, "DEPT_R", false, 4.0);
        deptSlackingTable.addColumn("DEPTNO", f.intType, true);
        deptSlackingTable.addColumn("SLACKINGMIN", f.intType);
        this.registerTable(deptSlackingTable);
        MockSchema nestedSchema = new MockSchema("NEST");
        this.registerNestedSchema(schema, nestedSchema);
        ImmutableList tablePath = ImmutableList.of((Object)schema.getCatalogName(), (Object)schema.name, (Object)nestedSchema.name, (Object)"EMP_R");
        MockTable nestedEmpRolledTable = MockTable.create(this, (List<String>)tablePath, false, 14.0);
        nestedEmpRolledTable.addColumn("EMPNO", f.intType, true);
        nestedEmpRolledTable.addColumn("DEPTNO", f.intType);
        nestedEmpRolledTable.addColumn("SLACKER", f.booleanType);
        nestedEmpRolledTable.addColumn("SLACKINGMIN", f.intType);
        nestedEmpRolledTable.registerRolledUpColumn("SLACKINGMIN");
        this.registerTable(nestedEmpRolledTable);
    }

    protected void registerType(List<String> names, RelProtoDataType relProtoDataType) {
        assert (names.get(0).equals(DEFAULT_CATALOG));
        List schemaPath = Util.skipLast(names);
        CalciteSchema schema = SqlValidatorUtil.getSchema((CalciteSchema)this.rootSchema, (Iterable)schemaPath, (SqlNameMatcher)SqlNameMatchers.withCaseSensitive((boolean)true));
        schema.add((String)Util.last(names), relProtoDataType);
    }

    protected void registerTable(MockTable table) {
        table.onRegister(this.typeFactory);
        final WrapperTable wrapperTable = new WrapperTable(table);
        if (table.stream) {
            this.registerTable(table.names, new StreamableWrapperTable(table){

                @Override
                public Table stream() {
                    return wrapperTable;
                }
            });
        } else {
            this.registerTable(table.names, wrapperTable);
        }
    }

    private void registerTable(List<String> names, Table table) {
        assert (names.get(0).equals(DEFAULT_CATALOG));
        List schemaPath = Util.skipLast(names);
        String tableName = (String)Util.last(names);
        CalciteSchema schema = SqlValidatorUtil.getSchema((CalciteSchema)this.rootSchema, (Iterable)schemaPath, (SqlNameMatcher)SqlNameMatchers.withCaseSensitive((boolean)true));
        schema.add(tableName, table);
    }

    protected void registerSchema(MockSchema schema) {
        this.rootSchema.add(schema.name, (Schema)new AbstractSchema());
    }

    private void registerNestedSchema(MockSchema parentSchema, MockSchema schema) {
        this.rootSchema.getSubSchema(parentSchema.getName(), true).add(schema.name, (Schema)new AbstractSchema());
    }

    private static List<RelCollation> deduceMonotonicity(Prepare.PreparingTable table) {
        ArrayList<RelCollation> collationList = new ArrayList<RelCollation>();
        int i = -1;
        for (RelDataTypeField field : table.getRowType().getFieldList()) {
            ++i;
            SqlMonotonicity monotonicity = table.getMonotonicity(field.getName());
            if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            RelFieldCollation.Direction direction = monotonicity.isDecreasing() ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
            collationList.add(RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(i, direction)}));
        }
        return collationList;
    }

    private static class StreamableWrapperTable
    extends WrapperTable
    implements StreamableTable {
        StreamableWrapperTable(MockTable table) {
            super(table);
        }

        public Table stream() {
            return this;
        }
    }

    private static class WrapperTable
    implements Table,
    Wrapper {
        private final MockTable table;

        WrapperTable(MockTable table) {
            this.table = table;
        }

        public <C> C unwrap(Class<C> aClass) {
            return (C)(aClass.isInstance(this) ? aClass.cast(this) : (aClass.isInstance((Object)this.table) ? aClass.cast((Object)this.table) : null));
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.table.getRowType();
        }

        public Statistic getStatistic() {
            return new Statistic(){

                public Double getRowCount() {
                    return ((WrapperTable)this).table.rowCount;
                }

                public boolean isKey(ImmutableBitSet columns) {
                    return table.isKey(columns);
                }

                public List<RelReferentialConstraint> getReferentialConstraints() {
                    return table.getReferentialConstraints();
                }

                public List<RelCollation> getCollations() {
                    return ((WrapperTable)this).table.collationList;
                }

                public RelDistribution getDistribution() {
                    return table.getDistribution();
                }
            };
        }

        public boolean isRolledUp(String column) {
            return this.table.rolledUpColumns.contains(column);
        }

        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
            return call.getKind() != SqlKind.MAX && (parent.getKind() == SqlKind.SELECT || parent.getKind() == SqlKind.FILTER);
        }

        public Schema.TableType getJdbcTableType() {
            return this.table.stream ? Schema.TableType.STREAM : Schema.TableType.TABLE;
        }
    }

    private static class DelegateStructType
    implements RelDataType {
        private RelDataType delegate;
        private StructKind structKind;

        DelegateStructType(RelDataType delegate, StructKind structKind) {
            assert (delegate.isStruct());
            this.delegate = delegate;
            this.structKind = structKind;
        }

        public boolean isStruct() {
            return this.delegate.isStruct();
        }

        public boolean isDynamicStruct() {
            return this.delegate.isDynamicStruct();
        }

        public List<RelDataTypeField> getFieldList() {
            return this.delegate.getFieldList();
        }

        public List<String> getFieldNames() {
            return this.delegate.getFieldNames();
        }

        public int getFieldCount() {
            return this.delegate.getFieldCount();
        }

        public StructKind getStructKind() {
            return this.structKind;
        }

        public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
            return this.delegate.getField(fieldName, caseSensitive, elideRecord);
        }

        public boolean isNullable() {
            return this.delegate.isNullable();
        }

        public RelDataType getComponentType() {
            return this.delegate.getComponentType();
        }

        public RelDataType getKeyType() {
            return this.delegate.getKeyType();
        }

        public RelDataType getValueType() {
            return this.delegate.getValueType();
        }

        public Charset getCharset() {
            return this.delegate.getCharset();
        }

        public SqlCollation getCollation() {
            return this.delegate.getCollation();
        }

        public SqlIntervalQualifier getIntervalQualifier() {
            return this.delegate.getIntervalQualifier();
        }

        public int getPrecision() {
            return this.delegate.getPrecision();
        }

        public int getScale() {
            return this.delegate.getScale();
        }

        public SqlTypeName getSqlTypeName() {
            return this.delegate.getSqlTypeName();
        }

        public SqlIdentifier getSqlIdentifier() {
            return this.delegate.getSqlIdentifier();
        }

        public String getFullTypeString() {
            return this.delegate.getFullTypeString();
        }

        public RelDataTypeFamily getFamily() {
            return this.delegate.getFamily();
        }

        public RelDataTypePrecedenceList getPrecedenceList() {
            return this.delegate.getPrecedenceList();
        }

        public RelDataTypeComparability getComparability() {
            return this.delegate.getComparability();
        }
    }

    public static class MockDynamicTable
    extends MockTable {
        public MockDynamicTable(MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount) {
            super(catalogReader, catalogName, schemaName, name, stream, rowCount, null, NullInitializerExpressionFactory.INSTANCE);
        }

        @Override
        public void onRegister(RelDataTypeFactory typeFactory) {
            this.rowType = new DynamicRecordTypeImpl(typeFactory);
        }

        @Override
        public RelNode toRel(RelOptTable.ToRelContext context) {
            if (this.rowType.isDynamicStruct()) {
                this.rowType = new RelRecordType(this.rowType.getFieldList());
            }
            return super.toRel(context);
        }
    }

    public static abstract class MockViewTable
    extends MockTable {
        private final MockTable fromTable;
        private final Table table;
        private final ImmutableIntList mapping;

        MockViewTable(MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, MockTable fromTable, ImmutableIntList mapping, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            super(catalogReader, catalogName, schemaName, name, stream, rowCount, resolver, initializerFactory);
            this.fromTable = fromTable;
            this.table = fromTable.unwrap(Table.class);
            this.mapping = mapping;
        }

        protected abstract RexNode getConstraint(RexBuilder var1, RelDataType var2);

        @Override
        public void onRegister(RelDataTypeFactory typeFactory) {
            super.onRegister(typeFactory);
            RelProtoDataType protoRowType = RelDataTypeImpl.proto((RelDataType)this.rowType);
            this.rowType = (RelDataType)protoRowType.apply((Object)typeFactory);
        }

        @Override
        public RelNode toRel(RelOptTable.ToRelContext context) {
            LogicalTableScan rel = LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)this.fromTable);
            RexBuilder rexBuilder = context.getCluster().getRexBuilder();
            rel = LogicalFilter.create((RelNode)rel, (RexNode)this.getConstraint(rexBuilder, rel.getRowType()));
            final List fieldList = rel.getRowType().getFieldList();
            AbstractList<Pair<RexNode, String>> projects = new AbstractList<Pair<RexNode, String>>(){

                @Override
                public Pair<RexNode, String> get(int index) {
                    return RexInputRef.of2((int)mapping.get(index), (List)fieldList);
                }

                @Override
                public int size() {
                    return mapping.size();
                }
            };
            return LogicalProject.create((RelNode)rel, (List)Pair.left((List)projects), (List)Pair.right((List)projects));
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isAssignableFrom(ModifiableView.class)) {
                ModifiableView view = this.resolver == null ? new ModifiableView() : new ModifiableViewWithCustomColumnResolving();
                return clazz.cast((Object)view);
            }
            return super.unwrap(clazz);
        }

        private class ModifiableViewWithCustomColumnResolving
        extends ModifiableView
        implements CustomColumnResolvingTable,
        Wrapper {
            private ModifiableViewWithCustomColumnResolving() {
            }

            public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType rowType, RelDataTypeFactory typeFactory, List<String> names) {
                return MockViewTable.this.resolver.resolveColumn(rowType, typeFactory, names);
            }

            @Override
            public <C> C unwrap(Class<C> aClass) {
                Object c;
                if (MockViewTable.this.table instanceof Wrapper && (c = ((Wrapper)MockViewTable.this.table).unwrap(aClass)) != null) {
                    return (C)c;
                }
                return super.unwrap(aClass);
            }
        }

        private class ModifiableView
        extends JdbcTest.AbstractModifiableView
        implements Wrapper {
            private ModifiableView() {
            }

            public Table getTable() {
                return MockViewTable.this.fromTable.unwrap(Table.class);
            }

            public Path getTablePath() {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String name : ((MockViewTable)MockViewTable.this).fromTable.names) {
                    builder.add((Object)Pair.of((Object)name, null));
                }
                return Schemas.path((ImmutableList)builder.build());
            }

            public ImmutableIntList getColumnMapping() {
                return MockViewTable.this.mapping;
            }

            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                return MockViewTable.this.getConstraint(rexBuilder, tableRowType);
            }

            public RelDataType getRowType(final RelDataTypeFactory typeFactory) {
                return typeFactory.createStructType((List)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return (Map.Entry)MockViewTable.this.table.getRowType(typeFactory).getFieldList().get(MockViewTable.this.mapping.get(index));
                    }

                    @Override
                    public int size() {
                        return MockViewTable.this.mapping.size();
                    }
                });
            }

            public <C> C unwrap(Class<C> aClass) {
                Object c;
                if (MockViewTable.this.table instanceof Wrapper && (c = ((Wrapper)MockViewTable.this.table).unwrap(aClass)) != null) {
                    return (C)c;
                }
                return (C)super.unwrap(aClass);
            }
        }
    }

    public static class MockModifiableViewRelOptTable
    extends MockTable {
        private final MockModifiableViewTable modifiableViewTable;

        private MockModifiableViewRelOptTable(MockModifiableViewTable modifiableViewTable, MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerExpressionFactory) {
            super(catalogReader, (List)ImmutableList.of((Object)catalogName, (Object)schemaName, (Object)name), stream, rowCount, resolver, initializerExpressionFactory);
            this.modifiableViewTable = modifiableViewTable;
        }

        private MockModifiableViewRelOptTable(MockModifiableViewTable modifiableViewTable, MockCatalogReader catalogReader, boolean stream, double rowCount, List<Map.Entry<String, RelDataType>> columnList, List<Integer> keyList, RelDataType rowType, List<RelCollation> collationList, List<String> names, Set<String> monotonicColumnSet, StructKind kind, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            super(catalogReader, stream, rowCount, columnList, keyList, rowType, collationList, names, monotonicColumnSet, kind, resolver, initializerFactory);
            this.modifiableViewTable = modifiableViewTable;
        }

        public static MockModifiableViewRelOptTable create(MockModifiableViewTable modifiableViewTable, MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, ColumnResolver resolver) {
            Table underlying = (Table)modifiableViewTable.unwrap(Table.class);
            InitializerExpressionFactory initializerExpressionFactory = underlying != null && underlying instanceof Wrapper ? (InitializerExpressionFactory)((Wrapper)underlying).unwrap(InitializerExpressionFactory.class) : NullInitializerExpressionFactory.INSTANCE;
            return new MockModifiableViewRelOptTable(modifiableViewTable, catalogReader, catalogName, schemaName, name, stream, rowCount, resolver, (InitializerExpressionFactory)Util.first((Object)initializerExpressionFactory, (Object)NullInitializerExpressionFactory.INSTANCE));
        }

        public static MockViewTableMacro viewMacro(CalciteSchema schema, String viewSql, List<String> schemaPath, List<String> viewPath, Boolean modifiable) {
            return new MockViewTableMacro(schema, viewSql, schemaPath, viewPath, modifiable);
        }

        @Override
        public RelDataType getRowType() {
            return this.modifiableViewTable.getRowType(this.catalogReader.typeFactory);
        }

        @Override
        protected RelOptTable extend(Table extendedTable) {
            return new MockModifiableViewRelOptTable((MockModifiableViewTable)extendedTable, this.catalogReader, this.stream, this.rowCount, this.columnList, this.keyList, this.rowType, this.collationList, this.names, this.monotonicColumnSet, this.kind, this.resolver, this.initializerFactory);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance((Object)this.modifiableViewTable)) {
                return clazz.cast((Object)this.modifiableViewTable);
            }
            return super.unwrap(clazz);
        }

        public static class MockModifiableViewTable
        extends ModifiableViewTable {
            private final RexNode constraint;

            MockModifiableViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, List<String> viewPath, Table table, Path tablePath, RexNode constraint, ImmutableIntList columnMapping) {
                super(elementType, rowType, viewSql, schemaPath, viewPath, table, tablePath, constraint, columnMapping);
                this.constraint = constraint;
            }

            public ModifiableViewTable extend(Table extendedTable, RelProtoDataType protoRowType, ImmutableIntList newColumnMapping) {
                return new MockModifiableViewTable(this.getElementType(), protoRowType, this.getViewSql(), this.getSchemaPath(), this.getViewPath(), extendedTable, this.getTablePath(), this.constraint, newColumnMapping);
            }
        }

        public static class MockViewTableMacro
        extends ViewTableMacro {
            MockViewTableMacro(CalciteSchema schema, String viewSql, List<String> schemaPath, List<String> viewPath, Boolean modifiable) {
                super(schema, viewSql, schemaPath, viewPath, modifiable);
            }

            protected ModifiableViewTable modifiableViewTable(CalcitePrepare.AnalyzeViewResult parsed, String viewSql, List<String> schemaPath, List<String> viewPath, CalciteSchema schema) {
                JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
                Type elementType = typeFactory.getJavaClass(parsed.rowType);
                return new MockModifiableViewTable(elementType, RelDataTypeImpl.proto((RelDataType)parsed.rowType), viewSql, schemaPath, viewPath, parsed.table, Schemas.path((CalciteSchema)schema.root(), (Iterable)parsed.tablePath), parsed.constraint, parsed.columnMapping);
            }
        }
    }

    public static class MockTable
    extends Prepare.AbstractPreparingTable {
        protected final MockCatalogReader catalogReader;
        protected final boolean stream;
        protected final double rowCount;
        protected final List<Map.Entry<String, RelDataType>> columnList = new ArrayList<Map.Entry<String, RelDataType>>();
        protected final List<Integer> keyList = new ArrayList<Integer>();
        protected final List<RelReferentialConstraint> referentialConstraints = new ArrayList<RelReferentialConstraint>();
        protected RelDataType rowType;
        protected List<RelCollation> collationList;
        protected final List<String> names;
        protected final Set<String> monotonicColumnSet = new HashSet<String>();
        protected StructKind kind = StructKind.FULLY_QUALIFIED;
        protected final ColumnResolver resolver;
        protected final InitializerExpressionFactory initializerFactory;
        protected final Set<String> rolledUpColumns = new HashSet<String>();

        public MockTable(MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            this(catalogReader, (List<String>)ImmutableList.of((Object)catalogName, (Object)schemaName, (Object)name), stream, rowCount, resolver, initializerFactory);
        }

        public void registerRolledUpColumn(String columnName) {
            this.rolledUpColumns.add(columnName);
        }

        private MockTable(MockCatalogReader catalogReader, List<String> names, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            this.catalogReader = catalogReader;
            this.stream = stream;
            this.rowCount = rowCount;
            this.names = names;
            this.resolver = resolver;
            this.initializerFactory = initializerFactory;
        }

        protected MockTable(MockCatalogReader catalogReader, boolean stream, double rowCount, List<Map.Entry<String, RelDataType>> columnList, List<Integer> keyList, RelDataType rowType, List<RelCollation> collationList, List<String> names, Set<String> monotonicColumnSet, StructKind kind, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            this.catalogReader = catalogReader;
            this.stream = stream;
            this.rowCount = rowCount;
            this.rowType = rowType;
            this.collationList = collationList;
            this.names = names;
            this.kind = kind;
            this.resolver = resolver;
            this.initializerFactory = initializerFactory;
            for (String name : monotonicColumnSet) {
                this.addMonotonic(name);
            }
        }

        protected RelOptTable extend(final Table extendedTable) {
            return new MockTable(this.catalogReader, this.names, this.stream, this.rowCount, this.resolver, this.initializerFactory){

                @Override
                public RelDataType getRowType() {
                    return extendedTable.getRowType(this.catalogReader.typeFactory);
                }
            };
        }

        public static MockTable create(MockCatalogReader catalogReader, MockSchema schema, String name, boolean stream, double rowCount) {
            return MockTable.create(catalogReader, schema, name, stream, rowCount, null);
        }

        public static MockTable create(MockCatalogReader catalogReader, List<String> names, boolean stream, double rowCount) {
            return new MockTable(catalogReader, names, stream, rowCount, null, NullInitializerExpressionFactory.INSTANCE);
        }

        public static MockTable create(MockCatalogReader catalogReader, MockSchema schema, String name, boolean stream, double rowCount, ColumnResolver resolver) {
            return MockTable.create(catalogReader, schema, name, stream, rowCount, resolver, NullInitializerExpressionFactory.INSTANCE);
        }

        public static MockTable create(MockCatalogReader catalogReader, MockSchema schema, String name, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerExpressionFactory) {
            MockTable table = new MockTable(catalogReader, schema.getCatalogName(), schema.name, name, stream, rowCount, resolver, initializerExpressionFactory);
            schema.addTable(name);
            return table;
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance((Object)this)) {
                return clazz.cast((Object)this);
            }
            if (clazz.isInstance(this.initializerFactory)) {
                return clazz.cast(this.initializerFactory);
            }
            if (clazz.isAssignableFrom(Table.class)) {
                ModifiableTable table = this.resolver == null ? new ModifiableTable((String)Util.last(this.names)) : new ModifiableTableWithCustomColumnResolving((String)Util.last(this.names));
                return clazz.cast((Object)table);
            }
            return null;
        }

        public double getRowCount() {
            return this.rowCount;
        }

        public RelOptSchema getRelOptSchema() {
            return this.catalogReader;
        }

        public RelNode toRel(RelOptTable.ToRelContext context) {
            return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)this);
        }

        public List<RelCollation> getCollationList() {
            return this.collationList;
        }

        public RelDistribution getDistribution() {
            return RelDistributions.BROADCAST_DISTRIBUTED;
        }

        public boolean isKey(ImmutableBitSet columns) {
            return !this.keyList.isEmpty() && columns.contains(ImmutableBitSet.of(this.keyList));
        }

        public List<RelReferentialConstraint> getReferentialConstraints() {
            return this.referentialConstraints;
        }

        public RelDataType getRowType() {
            return this.rowType;
        }

        public boolean supportsModality(SqlModality modality) {
            return modality == (this.stream ? SqlModality.STREAM : SqlModality.RELATION);
        }

        public void onRegister(RelDataTypeFactory typeFactory) {
            this.rowType = typeFactory.createStructType(this.kind, Pair.right(this.columnList), Pair.left(this.columnList));
            this.collationList = MockCatalogReader.deduceMonotonicity((Prepare.PreparingTable)this);
        }

        public List<String> getQualifiedName() {
            return this.names;
        }

        public SqlMonotonicity getMonotonicity(String columnName) {
            return this.monotonicColumnSet.contains(columnName) ? SqlMonotonicity.INCREASING : SqlMonotonicity.NOT_MONOTONIC;
        }

        public SqlAccessType getAllowedAccess() {
            return SqlAccessType.ALL;
        }

        public Expression getExpression(Class clazz) {
            throw new UnsupportedOperationException();
        }

        public void addColumn(String name, RelDataType type) {
            this.addColumn(name, type, false);
        }

        public void addColumn(String name, RelDataType type, boolean isKey) {
            if (isKey) {
                this.keyList.add(this.columnList.size());
            }
            this.columnList.add((Map.Entry<String, RelDataType>)Pair.of((Object)name, (Object)type));
        }

        public void addMonotonic(String name) {
            this.monotonicColumnSet.add(name);
            assert (Pair.left(this.columnList).contains(name));
        }

        public void setKind(StructKind kind) {
            this.kind = kind;
        }

        public StructKind getKind() {
            return this.kind;
        }

        private class ModifiableTableWithCustomColumnResolving
        extends ModifiableTable
        implements CustomColumnResolvingTable,
        Wrapper {
            ModifiableTableWithCustomColumnResolving(String tableName) {
                super(tableName);
            }

            public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType rowType, RelDataTypeFactory typeFactory, List<String> names) {
                return MockTable.this.resolver.resolveColumn(rowType, typeFactory, names);
            }
        }

        private class ModifiableTable
        extends JdbcTest.AbstractModifiableTable
        implements ExtensibleTable,
        Wrapper {
            protected ModifiableTable(String tableName) {
                super(tableName);
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.createStructType(MockTable.this.getRowType().getFieldList());
            }

            public Collection getModifiableCollection() {
                return null;
            }

            public <E> Queryable<E> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                return null;
            }

            public Type getElementType() {
                return null;
            }

            public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
                return null;
            }

            public <C> C unwrap(Class<C> aClass) {
                if (aClass.isInstance(MockTable.this.initializerFactory)) {
                    return aClass.cast(MockTable.this.initializerFactory);
                }
                if (aClass.isInstance((Object)MockTable.this)) {
                    return aClass.cast((Object)MockTable.this);
                }
                return (C)super.unwrap(aClass);
            }

            public Table extend(final List<RelDataTypeField> fields) {
                return new ModifiableTable((String)Util.last(MockTable.this.names)){

                    @Override
                    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                        ImmutableList allFields = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)ModifiableTable.this.getRowType(typeFactory).getFieldList(), (Iterable)fields));
                        return typeFactory.createStructType((List)allFields);
                    }
                };
            }

            public int getExtendedColumnOffset() {
                return MockTable.this.rowType.getFieldCount();
            }
        }
    }

    public static class MockSchema {
        private final List<String> tableNames = new ArrayList<String>();
        private String name;

        public MockSchema(String name) {
            this.name = name;
        }

        public void addTable(String name) {
            this.tableNames.add(name);
        }

        public String getCatalogName() {
            return MockCatalogReader.DEFAULT_CATALOG;
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface ColumnResolver {
        public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType var1, RelDataTypeFactory var2, List<String> var3);
    }
}

