/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import sqlline.SqlLine;

public class SqlLineTest {
    private static Pair<SqlLine.Status, String> run(String ... args) throws Throwable {
        SqlLine sqlline = new SqlLine();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream sqllineOutputStream = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
        sqlline.setOutputStream(sqllineOutputStream);
        sqlline.setErrorStream(sqllineOutputStream);
        SqlLine.Status status = SqlLine.Status.OK;
        Bug.upgrade((String)"[sqlline-35] Make Sqlline.begin public");
        return Pair.of((Object)status, (Object)os.toString("UTF8"));
    }

    private static Pair<SqlLine.Status, String> runScript(File scriptFile, boolean flag) throws Throwable {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "-u", "jdbc:calcite:", "-n", "sa", "-p", "");
        if (flag) {
            args.add("-f");
            args.add(scriptFile.getAbsolutePath());
        } else {
            args.add("--run=" + scriptFile.getAbsolutePath());
        }
        return SqlLineTest.run(args.toArray(new String[0]));
    }

    private void checkScriptFile(String scriptText, boolean flag, Matcher<SqlLine.Status> statusMatcher, Matcher<String> outputMatcher) throws Throwable {
        File scriptFile = File.createTempFile("foo", "temp");
        scriptFile.deleteOnExit();
        try (PrintWriter w = Util.printWriter((File)scriptFile);){
            w.print(scriptText);
        }
        Pair<SqlLine.Status, String> pair = SqlLineTest.runScript(scriptFile, flag);
        Assert.assertThat((Object)pair.right, outputMatcher);
        Assert.assertThat((Object)pair.left, statusMatcher);
        boolean delete = scriptFile.delete();
        Assert.assertThat((Object)delete, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSqlLine() throws Throwable {
        this.checkScriptFile("!tables", false, (Matcher<SqlLine.Status>)CoreMatchers.equalTo((Object)SqlLine.Status.OK), (Matcher<String>)CoreMatchers.equalTo((Object)""));
    }
}

