/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.foodmart.queries.FoodmartQuerySet;

public class FoodMartQuerySet {
    private static SoftReference<FoodMartQuerySet> ref;
    public final Map<Integer, FoodmartQuery> queries = new LinkedHashMap<Integer, FoodmartQuery>();

    private FoodMartQuerySet() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        InputStream inputStream = new FoodmartQuerySet().getQueries();
        FoodmartRoot root = (FoodmartRoot)mapper.readValue(inputStream, FoodmartRoot.class);
        for (FoodmartQuery query : root.queries) {
            this.queries.put(query.id, query);
        }
    }

    public static synchronized FoodMartQuerySet instance() throws IOException {
        FoodMartQuerySet set;
        SoftReference<FoodMartQuerySet> refLocal = ref;
        if (refLocal != null && (set = refLocal.get()) != null) {
            return set;
        }
        set = new FoodMartQuerySet();
        ref = new SoftReference<FoodMartQuerySet>(set);
        return set;
    }

    public static class FoodmartColumn {
        public String name;
        public String type;
    }

    public static class FoodmartQuery {
        public int id;
        public String sql;
        public final List<FoodmartColumn> columns = new ArrayList<FoodmartColumn>();
        public final List<List> rows = new ArrayList<List>();
    }

    public static class FoodmartRoot {
        public final List<FoodmartQuery> queries = new ArrayList<FoodmartQuery>();
    }
}

