/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.calcite.config.Lex;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class LexCaseSensitiveTest {
    private static Planner getPlanner(List<RelTraitDef> traitDefs, SqlParser.Config parserConfig, Program ... programs) {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.HR)).traitDefs(traitDefs).programs(programs).build();
        return Frameworks.getPlanner((FrameworkConfig)config);
    }

    private static void runProjectQueryWithLex(Lex lex, String sql) throws SqlParseException, ValidationException, RelConversionException {
        SqlParser.Config javaLex = SqlParser.configBuilder().setLex(lex).build();
        Planner planner = LexCaseSensitiveTest.getPlanner(null, javaLex, Programs.ofRules((Iterable)Programs.RULE_SET));
        SqlNode parse = planner.parse(sql);
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel((SqlNode)validate).rel;
        RelTraitSet traitSet = convert.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)transform, (Matcher)CoreMatchers.instanceOf(EnumerableProject.class));
        List fieldNames = transform.getRowType().getFieldNames();
        Assert.assertThat((Object)fieldNames.size(), (Matcher)Is.is((Object)2));
        if (lex.caseSensitive) {
            Assert.assertThat(fieldNames.get(0), (Matcher)Is.is((Object)"EMPID"));
            Assert.assertThat(fieldNames.get(1), (Matcher)Is.is((Object)"empid"));
        } else {
            Assert.assertThat((Object)((String)fieldNames.get(0) + "-" + (String)fieldNames.get(1)), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)"EMPID-empid0"), (Matcher)Is.is((Object)"EMPID0-empid")));
        }
    }

    @Test
    public void testCalciteCaseOracle() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select \"empid\" as EMPID, \"empid\" from\n (select \"empid\" from \"emps\" order by \"emps\".\"deptno\")";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.ORACLE, sql);
    }

    @Test(expected=ValidationException.class)
    public void testCalciteCaseOracleException() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select EMPID, \"empid\" from\n (select \"empid\" from \"emps\" order by \"emps\".\"deptno\")";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.ORACLE, sql);
    }

    @Test
    public void testCalciteCaseMySql() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select empid as EMPID, empid from (\n  select empid from emps order by `EMPS`.DEPTNO)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.MYSQL, sql);
    }

    @Test
    public void testCalciteCaseMySqlNoException() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select EMPID, empid from\n (select empid from emps order by emps.deptno)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.MYSQL, sql);
    }

    @Test
    public void testCalciteCaseMySqlAnsi() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select empid as EMPID, empid from (\n  select empid from emps order by EMPS.DEPTNO)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.MYSQL_ANSI, sql);
    }

    @Test
    public void testCalciteCaseMySqlAnsiNoException() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select EMPID, empid from\n (select empid from emps order by emps.deptno)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.MYSQL_ANSI, sql);
    }

    @Test
    public void testCalciteCaseSqlServer() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select empid as EMPID, empid from (\n  select empid from emps order by EMPS.DEPTNO)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.SQL_SERVER, sql);
    }

    @Test
    public void testCalciteCaseSqlServerNoException() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select EMPID, empid from\n (select empid from emps order by emps.deptno)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.SQL_SERVER, sql);
    }

    @Test
    public void testCalciteCaseJava() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select empid as EMPID, empid from (\n  select empid from emps order by emps.deptno)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.JAVA, sql);
    }

    @Test(expected=ValidationException.class)
    public void testCalciteCaseJavaException() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select EMPID, empid from\n (select empid from emps order by emps.deptno)";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.JAVA, sql);
    }

    @Test
    public void testCalciteCaseJoinOracle() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select t.\"empid\" as EMPID, s.\"empid\" from\n(select * from \"emps\" where \"emps\".\"deptno\" > 100) t join\n(select * from \"emps\" where \"emps\".\"deptno\" < 200) s\non t.\"empid\" = s.\"empid\"";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.ORACLE, sql);
    }

    @Test
    public void testCalciteCaseJoinMySql() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select t.empid as EMPID, s.empid from\n(select * from emps where emps.deptno > 100) t join\n(select * from emps where emps.deptno < 200) s on t.empid = s.empid";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.MYSQL, sql);
    }

    @Test
    public void testCalciteCaseJoinMySqlAnsi() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select t.empid as EMPID, s.empid from\n(select * from emps where emps.deptno > 100) t join\n(select * from emps where emps.deptno < 200) s on t.empid = s.empid";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.MYSQL_ANSI, sql);
    }

    @Test
    public void testCalciteCaseJoinSqlServer() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select t.empid as EMPID, s.empid from\n(select * from emps where emps.deptno > 100) t join\n(select * from emps where emps.deptno < 200) s on t.empid = s.empid";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.SQL_SERVER, sql);
    }

    @Test
    public void testCalciteCaseJoinJava() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select t.empid as EMPID, s.empid from\n(select * from emps where emps.deptno > 100) t join\n(select * from emps where emps.deptno < 200) s on t.empid = s.empid";
        LexCaseSensitiveTest.runProjectQueryWithLex(Lex.JAVA, sql);
    }
}

