/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.PlannerTests;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.junit.Assert;
import org.junit.Test;

public class ComboRuleTest {
    @Test
    public void testCombo() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRule((RelOptRule)new ComboRule());
        planner.addRule((RelOptRule)new AddIntermediateNodeRule());
        planner.addRule((RelOptRule)new PlannerTests.GoodSingleRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        PlannerTests.NoneLeafRel leafRel = new PlannerTests.NoneLeafRel(cluster, "a");
        PlannerTests.NoneSingleRel singleRel = new PlannerTests.NoneSingleRel(cluster, (RelNode)leafRel);
        PlannerTests.NoneSingleRel singleRel2 = new PlannerTests.NoneSingleRel(cluster, (RelNode)singleRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel2, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof IntermediateNode));
    }

    private static class ComboRule
    extends RelOptRule {
        ComboRule() {
            super(ComboRule.createOperand());
        }

        private static RelOptRuleOperand createOperand() {
            RelOptRuleOperand input = ComboRule.operand(RelNode.class, (RelOptRuleOperandChildren)ComboRule.any());
            input = ComboRule.operand(IntermediateNode.class, (RelOptRuleOperandChildren)ComboRule.some((RelOptRuleOperand)input, (RelOptRuleOperand[])new RelOptRuleOperand[0]));
            input = ComboRule.operand(PlannerTests.PhysSingleRel.class, (RelOptRuleOperandChildren)ComboRule.some((RelOptRuleOperand)input, (RelOptRuleOperand[])new RelOptRuleOperand[0]));
            return input;
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public boolean matches(RelOptRuleCall call) {
            if (call.rels.length < 3) {
                return false;
            }
            return call.rel(0) instanceof PlannerTests.PhysSingleRel && call.rel(1) instanceof IntermediateNode && call.rel(2) instanceof RelNode;
        }

        public void onMatch(RelOptRuleCall call) {
            ImmutableList newInputs = ImmutableList.of((Object)call.rel(2));
            IntermediateNode oldInter = (IntermediateNode)call.rel(1);
            RelNode physRel = call.rel(0).copy(call.rel(0).getTraitSet(), (List)newInputs);
            IntermediateNode converted = new IntermediateNode(physRel.getCluster(), physRel, oldInter.nodesBelowCount + 1);
            call.transformTo((RelNode)converted);
        }
    }

    private static class AddIntermediateNodeRule
    extends RelOptRule {
        AddIntermediateNodeRule() {
            super(AddIntermediateNodeRule.operand(PlannerTests.NoneLeafRel.class, (RelOptRuleOperandChildren)AddIntermediateNodeRule.any()));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            PlannerTests.NoneLeafRel leaf = (PlannerTests.NoneLeafRel)call.rel(0);
            PlannerTests.PhysLeafRel physLeaf = new PlannerTests.PhysLeafRel(leaf.getCluster(), leaf.label);
            IntermediateNode intermediateNode = new IntermediateNode(physLeaf.getCluster(), (RelNode)physLeaf, 1);
            call.transformTo((RelNode)intermediateNode);
        }
    }

    private static class IntermediateNode
    extends PlannerTests.TestSingleRel {
        final int nodesBelowCount;

        IntermediateNode(RelOptCluster cluster, RelNode input, int nodesBelowCount) {
            super(cluster, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION), input);
            this.nodesBelowCount = nodesBelowCount;
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeCost(100.0, 100.0, 100.0).multiplyBy(1.0 / (double)this.nodesBelowCount);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{PlannerTests.PHYS_CALLING_CONVENTION}));
            return new IntermediateNode(this.getCluster(), (RelNode)IntermediateNode.sole(inputs), this.nodesBelowCount);
        }
    }
}

