/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptMaterializations;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.calcite.util.trace.CalciteLogger;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaterializedViewRule
extends RelOptRule {
    private static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger(AbstractMaterializedViewRule.class));
    public static final MaterializedViewProjectFilterRule INSTANCE_PROJECT_FILTER = new MaterializedViewProjectFilterRule(RelFactories.LOGICAL_BUILDER, true, null, true);
    public static final MaterializedViewOnlyFilterRule INSTANCE_FILTER = new MaterializedViewOnlyFilterRule(RelFactories.LOGICAL_BUILDER, true, null, true);
    public static final MaterializedViewProjectJoinRule INSTANCE_PROJECT_JOIN = new MaterializedViewProjectJoinRule(RelFactories.LOGICAL_BUILDER, true, null, true);
    public static final MaterializedViewOnlyJoinRule INSTANCE_JOIN = new MaterializedViewOnlyJoinRule(RelFactories.LOGICAL_BUILDER, true, null, true);
    public static final MaterializedViewProjectAggregateRule INSTANCE_PROJECT_AGGREGATE = new MaterializedViewProjectAggregateRule(RelFactories.LOGICAL_BUILDER, true, null);
    public static final MaterializedViewOnlyAggregateRule INSTANCE_AGGREGATE = new MaterializedViewOnlyAggregateRule(RelFactories.LOGICAL_BUILDER, true, null);
    protected final boolean generateUnionRewriting;
    protected final HepProgram unionRewritingPullProgram;
    protected final boolean fastBailOut;

    protected AbstractMaterializedViewRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram, boolean fastBailOut) {
        super(operand, relBuilderFactory, description);
        this.generateUnionRewriting = generateUnionRewriting;
        this.unionRewritingPullProgram = unionRewritingPullProgram;
        this.fastBailOut = fastBailOut;
    }

    protected void perform(RelOptRuleCall call, Project topProject, RelNode node) {
        RexBuilder rexBuilder = node.getCluster().getRexBuilder();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPlanner planner = call.getPlanner();
        RexExecutor executor = Util.first(planner.getExecutor(), RexUtil.EXECUTOR);
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        RexSimplify simplify = new RexSimplify(rexBuilder, predicates, executor);
        List<RelOptMaterialization> materializations = planner.getMaterializations();
        if (!materializations.isEmpty()) {
            if (!this.isValidPlan(topProject, node, mq)) {
                return;
            }
            List<RelOptMaterialization> applicableMaterializations = RelOptMaterializations.getApplicableMaterializations(node, materializations);
            if (!applicableMaterializations.isEmpty()) {
                Set<RexTableInputRef.RelTableRef> queryTableRefs = mq.getTableReferences(node);
                if (queryTableRefs == null) {
                    return;
                }
                RelOptPredicateList queryPredicateList = mq.getAllPredicates(node);
                if (queryPredicateList == null) {
                    return;
                }
                RexNode pred = simplify.simplifyUnknownAsFalse(RexUtil.composeConjunction(rexBuilder, queryPredicateList.pulledUpPredicates));
                Triple<RexNode, RexNode, RexNode> queryPreds = AbstractMaterializedViewRule.splitPredicates(rexBuilder, pred);
                EquivalenceClasses qEC = new EquivalenceClasses();
                for (RexNode conj : RelOptUtil.conjunctions((RexNode)queryPreds.getLeft())) {
                    assert (conj.isA(SqlKind.EQUALS));
                    RexCall equiCond = (RexCall)conj;
                    qEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                }
                for (RelOptMaterialization materialization : applicableMaterializations) {
                    MatchModality matchModality;
                    RelOptPredicateList viewPredicateList;
                    RelNode viewNode;
                    Project topViewProject;
                    RelNode view = materialization.tableRel;
                    if (materialization.queryRel instanceof Project) {
                        topViewProject = (Project)materialization.queryRel;
                        viewNode = topViewProject.getInput();
                    } else {
                        topViewProject = null;
                        viewNode = materialization.queryRel;
                    }
                    if (!this.isValidPlan(topViewProject, viewNode, mq) || (viewPredicateList = mq.getAllPredicates(viewNode)) == null) continue;
                    RexNode viewPred = simplify.simplifyUnknownAsFalse(RexUtil.composeConjunction(rexBuilder, viewPredicateList.pulledUpPredicates));
                    Triple<RexNode, RexNode, RexNode> viewPreds = AbstractMaterializedViewRule.splitPredicates(rexBuilder, viewPred);
                    Set<RexTableInputRef.RelTableRef> viewTableRefs = mq.getTableReferences(viewNode);
                    if (viewTableRefs == null) {
                        return;
                    }
                    ArrayListMultimap compensationEquiColumns = ArrayListMultimap.create();
                    if (!queryTableRefs.equals(viewTableRefs)) {
                        if (viewTableRefs.containsAll(queryTableRefs)) {
                            matchModality = MatchModality.QUERY_PARTIAL;
                            EquivalenceClasses vEC = new EquivalenceClasses();
                            for (RexNode conj : RelOptUtil.conjunctions((RexNode)viewPreds.getLeft())) {
                                assert (conj.isA(SqlKind.EQUALS));
                                RexCall equiCond = (RexCall)conj;
                                vEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                            }
                            if (!AbstractMaterializedViewRule.compensatePartial(viewTableRefs, vEC, queryTableRefs, (Multimap<RexTableInputRef, RexTableInputRef>)compensationEquiColumns)) {
                                continue;
                            }
                        } else {
                            if (!queryTableRefs.containsAll(viewTableRefs)) continue;
                            matchModality = MatchModality.VIEW_PARTIAL;
                            ViewPartialRewriting partialRewritingResult = this.compensateViewPartial(call.builder(), rexBuilder, mq, view, topProject, node, queryTableRefs, qEC, topViewProject, viewNode, viewTableRefs);
                            if (partialRewritingResult == null) continue;
                            view = partialRewritingResult.newView;
                            topViewProject = partialRewritingResult.newTopViewProject;
                            viewNode = partialRewritingResult.newViewNode;
                        }
                    } else {
                        matchModality = MatchModality.COMPLETE;
                    }
                    ArrayListMultimap multiMapTables = ArrayListMultimap.create();
                    for (RexTableInputRef.RelTableRef queryTableRef1 : queryTableRefs) {
                        for (RexTableInputRef.RelTableRef queryTableRef2 : queryTableRefs) {
                            if (!queryTableRef1.getQualifiedName().equals(queryTableRef2.getQualifiedName())) continue;
                            multiMapTables.put((Object)queryTableRef1, (Object)queryTableRef2);
                        }
                    }
                    List<BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>> flatListMappings = AbstractMaterializedViewRule.generateTableMappings((Multimap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)multiMapTables);
                    for (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping : flatListMappings) {
                        RelNode viewWithFilter;
                        RexNode otherCompensationPred;
                        RexNode compensationColumnsEquiPred;
                        EquivalenceClasses currQEC = EquivalenceClasses.copy(qEC);
                        if (matchModality == MatchModality.QUERY_PARTIAL) {
                            for (Map.Entry e : compensationEquiColumns.entries()) {
                                RexTableInputRef.RelTableRef queryTableRef = (RexTableInputRef.RelTableRef)queryToViewTableMapping.inverse().get((Object)((RexTableInputRef)e.getKey()).getTableRef());
                                RexTableInputRef queryColumnRef = RexTableInputRef.of(queryTableRef, ((RexTableInputRef)e.getKey()).getIndex(), ((RexTableInputRef)e.getKey()).getType());
                                currQEC.addEquivalenceClass(queryColumnRef, (RexTableInputRef)e.getValue());
                                queryToViewTableMapping.put((Object)((RexTableInputRef)e.getValue()).getTableRef(), (Object)((RexTableInputRef)e.getValue()).getTableRef());
                            }
                        }
                        RexNode viewColumnsEquiPred = RexUtil.swapTableReferences(rexBuilder, (RexNode)viewPreds.getLeft(), (Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping.inverse());
                        EquivalenceClasses queryBasedVEC = new EquivalenceClasses();
                        for (RexNode conj : RelOptUtil.conjunctions(viewColumnsEquiPred)) {
                            assert (conj.isA(SqlKind.EQUALS));
                            RexCall equiCond = (RexCall)conj;
                            queryBasedVEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                        }
                        Triple<RexNode, RexNode, RexNode> compensationPreds = AbstractMaterializedViewRule.computeCompensationPredicates(rexBuilder, simplify, currQEC, queryPreds, queryBasedVEC, viewPreds, queryToViewTableMapping);
                        if (compensationPreds == null && this.generateUnionRewriting) {
                            RelNode result;
                            RelNode unionInputView;
                            compensationPreds = AbstractMaterializedViewRule.computeCompensationPredicates(rexBuilder, simplify, queryBasedVEC, viewPreds, currQEC, queryPreds, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping.inverse());
                            if (compensationPreds == null) continue;
                            compensationColumnsEquiPred = (RexNode)compensationPreds.getLeft();
                            otherCompensationPred = RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)ImmutableList.of((Object)compensationPreds.getMiddle(), (Object)compensationPreds.getRight()));
                            assert (!compensationColumnsEquiPred.isAlwaysTrue() || !otherCompensationPred.isAlwaysTrue());
                            RelNode unionInputQuery = this.rewriteQuery(call.builder(), rexBuilder, simplify, mq, compensationColumnsEquiPred, otherCompensationPred, topProject, node, queryToViewTableMapping, queryBasedVEC, currQEC);
                            if (unionInputQuery == null || (unionInputView = this.rewriteView(call.builder(), rexBuilder, simplify, mq, matchModality, true, view, topProject, node, topViewProject, viewNode, queryToViewTableMapping, currQEC)) == null || (result = this.createUnion(call.builder(), rexBuilder, topProject, unionInputQuery, unionInputView)) == null) continue;
                            call.transformTo(result);
                            continue;
                        }
                        if (compensationPreds == null) continue;
                        compensationColumnsEquiPred = (RexNode)compensationPreds.getLeft();
                        otherCompensationPred = RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)ImmutableList.of((Object)compensationPreds.getMiddle(), (Object)compensationPreds.getRight()));
                        if (!compensationColumnsEquiPred.isAlwaysTrue() || !otherCompensationPred.isAlwaysTrue()) {
                            List<RexNode> viewExprs;
                            List<RexNode> list = viewExprs = topViewProject == null ? AbstractMaterializedViewRule.extractReferences(rexBuilder, view) : topViewProject.getChildExps();
                            if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, view, viewNode, viewExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping.inverse(), queryBasedVEC, false, compensationColumnsEquiPred)) == null || !otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, view, viewNode, viewExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping.inverse(), currQEC, true, otherCompensationPred)) == null) continue;
                        }
                        RexNode viewCompensationPred = RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)ImmutableList.of((Object)compensationColumnsEquiPred, (Object)otherCompensationPred));
                        RelBuilder builder = call.builder();
                        if (!viewCompensationPred.isAlwaysTrue()) {
                            RexNode newPred = simplify.simplifyUnknownAsFalse(viewCompensationPred);
                            viewWithFilter = builder.push(view).filter(newPred).build();
                            Pair<RelNode, RelNode> pushedNodes = this.pushFilterToOriginalViewPlan(builder, topViewProject, viewNode, newPred);
                            topViewProject = (Project)pushedNodes.left;
                            viewNode = (RelNode)pushedNodes.right;
                        } else {
                            viewWithFilter = builder.push(view).build();
                        }
                        RelNode result = this.rewriteView(builder, rexBuilder, simplify, mq, matchModality, false, viewWithFilter, topProject, node, topViewProject, viewNode, queryToViewTableMapping, currQEC);
                        if (result == null) continue;
                        call.transformTo(result);
                    }
                }
            }
        }
    }

    protected abstract boolean isValidPlan(Project var1, RelNode var2, RelMetadataQuery var3);

    protected abstract ViewPartialRewriting compensateViewPartial(RelBuilder var1, RexBuilder var2, RelMetadataQuery var3, RelNode var4, Project var5, RelNode var6, Set<RexTableInputRef.RelTableRef> var7, EquivalenceClasses var8, Project var9, RelNode var10, Set<RexTableInputRef.RelTableRef> var11);

    protected abstract RelNode rewriteQuery(RelBuilder var1, RexBuilder var2, RexSimplify var3, RelMetadataQuery var4, RexNode var5, RexNode var6, Project var7, RelNode var8, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> var9, EquivalenceClasses var10, EquivalenceClasses var11);

    protected abstract RelNode createUnion(RelBuilder var1, RexBuilder var2, RelNode var3, RelNode var4, RelNode var5);

    protected abstract RelNode rewriteView(RelBuilder var1, RexBuilder var2, RexSimplify var3, RelMetadataQuery var4, MatchModality var5, boolean var6, RelNode var7, Project var8, RelNode var9, Project var10, RelNode var11, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> var12, EquivalenceClasses var13);

    protected abstract Pair<RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder var1, RelNode var2, RelNode var3, RexNode var4);

    private static List<RexNode> extractReferences(RexBuilder rexBuilder, RelNode node) {
        ImmutableList.Builder exprs = ImmutableList.builder();
        if (node instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)node;
            for (int i = 0; i < aggregate.getGroupCount(); ++i) {
                exprs.add((Object)rexBuilder.makeInputRef(aggregate, i));
            }
        } else {
            for (int i = 0; i < node.getRowType().getFieldCount(); ++i) {
                exprs.add((Object)rexBuilder.makeInputRef(node, i));
            }
        }
        return exprs.build();
    }

    private static List<BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>> generateTableMappings(Multimap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> multiMapTables) {
        if (multiMapTables.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList result = ImmutableList.of((Object)HashBiMap.create());
        for (Map.Entry e : multiMapTables.asMap().entrySet()) {
            if (((Collection)e.getValue()).size() == 1) {
                RexTableInputRef.RelTableRef target = (RexTableInputRef.RelTableRef)((Collection)e.getValue()).iterator().next();
                for (BiMap m : result) {
                    m.put(e.getKey(), (Object)target);
                }
                continue;
            }
            ImmutableList.Builder newResult = ImmutableList.builder();
            for (RexTableInputRef.RelTableRef target : (Collection)e.getValue()) {
                for (BiMap m : result) {
                    if (m.containsValue((Object)target)) continue;
                    HashBiMap newM = HashBiMap.create((Map)m);
                    newM.put(e.getKey(), (Object)target);
                    newResult.add((Object)newM);
                }
            }
            result = newResult.build();
        }
        return result;
    }

    private static boolean isValidRelNodePlan(RelNode node, RelMetadataQuery mq) {
        Multimap<Class<? extends RelNode>, RelNode> m = mq.getNodeTypes(node);
        for (Map.Entry e : m.asMap().entrySet()) {
            Class c = (Class)e.getKey();
            if (!(TableScan.class.isAssignableFrom(c) || Project.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || Join.class.isAssignableFrom(c) && !SemiJoin.class.isAssignableFrom(c))) {
                return false;
            }
            if (!Join.class.isAssignableFrom(c)) continue;
            for (RelNode n : (Collection)e.getValue()) {
                if (((Join)n).getJoinType() == JoinRelType.INNER) continue;
                return false;
            }
        }
        return true;
    }

    private static Triple<RexNode, RexNode, RexNode> splitPredicates(RexBuilder rexBuilder, RexNode pred) {
        ArrayList<RexNode> equiColumnsPreds = new ArrayList<RexNode>();
        ArrayList<RexNode> rangePreds = new ArrayList<RexNode>();
        ArrayList<RexNode> residualPreds = new ArrayList<RexNode>();
        block4: for (RexNode e : RelOptUtil.conjunctions(pred)) {
            switch (e.getKind()) {
                case EQUALS: {
                    RexCall eqCall = (RexCall)e;
                    if (RexUtil.isReferenceOrAccess(eqCall.getOperands().get(0), false) && RexUtil.isReferenceOrAccess(eqCall.getOperands().get(1), false)) {
                        equiColumnsPreds.add(e);
                        continue block4;
                    }
                    if (RexUtil.isReferenceOrAccess(eqCall.getOperands().get(0), false) && RexUtil.isConstant(eqCall.getOperands().get(1)) || RexUtil.isReferenceOrAccess(eqCall.getOperands().get(1), false) && RexUtil.isConstant(eqCall.getOperands().get(0))) {
                        rangePreds.add(e);
                        continue block4;
                    }
                    residualPreds.add(e);
                    continue block4;
                }
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    RexCall rangeCall = (RexCall)e;
                    if (RexUtil.isReferenceOrAccess(rangeCall.getOperands().get(0), false) && RexUtil.isConstant(rangeCall.getOperands().get(1)) || RexUtil.isReferenceOrAccess(rangeCall.getOperands().get(1), false) && RexUtil.isConstant(rangeCall.getOperands().get(0))) {
                        rangePreds.add(e);
                        continue block4;
                    }
                    residualPreds.add(e);
                    continue block4;
                }
            }
            residualPreds.add(e);
        }
        return ImmutableTriple.of((Object)RexUtil.composeConjunction(rexBuilder, equiColumnsPreds), (Object)RexUtil.composeConjunction(rexBuilder, rangePreds), (Object)RexUtil.composeConjunction(rexBuilder, residualPreds));
    }

    private static boolean compensatePartial(Set<RexTableInputRef.RelTableRef> sourceTableRefs, EquivalenceClasses sourceEC, Set<RexTableInputRef.RelTableRef> targetTableRefs, Multimap<RexTableInputRef, RexTableInputRef> compensationEquiColumns) {
        DefaultDirectedGraph<RexTableInputRef.RelTableRef, Edge> graph = DefaultDirectedGraph.create(Edge::new);
        ArrayListMultimap tableVNameToTableRefs = ArrayListMultimap.create();
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : sourceTableRefs) {
            graph.addVertex(tRef);
            tableVNameToTableRefs.put(tRef.getQualifiedName(), (Object)tRef);
            if (targetTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        for (RexTableInputRef.RelTableRef tRef : graph.vertexSet()) {
            List<RelReferentialConstraint> constraints = tRef.getTable().getReferentialConstraints();
            for (RelReferentialConstraint constraint : constraints) {
                Collection parentTableRefs = tableVNameToTableRefs.get(constraint.getTargetQualifiedName());
                for (RexTableInputRef.RelTableRef parentTRef : parentTableRefs) {
                    boolean canBeRewritten = true;
                    ArrayListMultimap equiColumns = ArrayListMultimap.create();
                    for (int pos = 0; pos < constraint.getNumColumns(); ++pos) {
                        int foreignKeyPos = constraint.getColumnPairs().get((int)pos).source;
                        RelDataType foreignKeyColumnType = tRef.getTable().getRowType().getFieldList().get(foreignKeyPos).getType();
                        RexTableInputRef foreignKeyColumnRef = RexTableInputRef.of(tRef, foreignKeyPos, foreignKeyColumnType);
                        int uniqueKeyPos = constraint.getColumnPairs().get((int)pos).target;
                        RexTableInputRef uniqueKeyColumnRef = RexTableInputRef.of(parentTRef, uniqueKeyPos, parentTRef.getTable().getRowType().getFieldList().get(uniqueKeyPos).getType());
                        if (foreignKeyColumnType.isNullable() || !sourceEC.getEquivalenceClassesMap().containsKey(uniqueKeyColumnRef) || !sourceEC.getEquivalenceClassesMap().get(uniqueKeyColumnRef).contains(foreignKeyColumnRef)) {
                            canBeRewritten = false;
                            break;
                        }
                        equiColumns.put((Object)foreignKeyColumnRef, (Object)uniqueKeyColumnRef);
                    }
                    if (!canBeRewritten) continue;
                    Edge edge = (Edge)graph.getEdge(tRef, parentTRef);
                    if (edge == null) {
                        edge = (Edge)graph.addEdge(tRef, parentTRef);
                    }
                    edge.equiColumns.putAll((Multimap)equiColumns);
                }
            }
        }
        boolean done = false;
        do {
            ArrayList<RexTableInputRef.RelTableRef> nodesToRemove = new ArrayList<RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef tRef : graph.vertexSet()) {
                if (graph.getInwardEdges(tRef).size() != 1 || !graph.getOutwardEdges(tRef).isEmpty()) continue;
                nodesToRemove.add(tRef);
                if (compensationEquiColumns == null || !extraTableRefs.contains(tRef)) continue;
                compensationEquiColumns.putAll(((Edge)graph.getInwardEdges((RexTableInputRef.RelTableRef)tRef).get((int)0)).equiColumns);
            }
            if (!nodesToRemove.isEmpty()) {
                graph.removeAllVertices(nodesToRemove);
                continue;
            }
            done = true;
        } while (!done);
        return Collections.disjoint(graph.vertexSet(), extraTableRefs);
    }

    private static Triple<RexNode, RexNode, RexNode> computeCompensationPredicates(RexBuilder rexBuilder, RexSimplify simplify, EquivalenceClasses sourceEC, Triple<RexNode, RexNode, RexNode> sourcePreds, EquivalenceClasses targetEC, Triple<RexNode, RexNode, RexNode> targetPreds, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> sourceToTargetTableMapping) {
        RexNode viewResidualPred;
        RexNode viewRangePred;
        RexNode compensationColumnsEquiPred = AbstractMaterializedViewRule.generateEquivalenceClasses(rexBuilder, sourceEC, targetEC);
        if (compensationColumnsEquiPred == null) {
            return null;
        }
        RexNode queryRangePred = RexUtil.swapColumnReferences(rexBuilder, (RexNode)sourcePreds.getMiddle(), sourceEC.getEquivalenceClassesMap());
        RexNode compensationRangePred = SubstitutionVisitor.splitFilter(simplify, queryRangePred, viewRangePred = RexUtil.swapTableColumnReferences(rexBuilder, (RexNode)targetPreds.getMiddle(), (Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)sourceToTargetTableMapping.inverse(), sourceEC.getEquivalenceClassesMap()));
        if (compensationRangePred == null) {
            return null;
        }
        RexNode queryResidualPred = RexUtil.swapColumnReferences(rexBuilder, (RexNode)sourcePreds.getRight(), sourceEC.getEquivalenceClassesMap());
        RexNode compensationResidualPred = SubstitutionVisitor.splitFilter(simplify, queryResidualPred, viewResidualPred = RexUtil.swapTableColumnReferences(rexBuilder, (RexNode)targetPreds.getRight(), (Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)sourceToTargetTableMapping.inverse(), sourceEC.getEquivalenceClassesMap()));
        if (compensationResidualPred == null) {
            return null;
        }
        return ImmutableTriple.of((Object)compensationColumnsEquiPred, (Object)compensationRangePred, (Object)compensationResidualPred);
    }

    private static RexNode generateEquivalenceClasses(RexBuilder rexBuilder, EquivalenceClasses sourceEC, EquivalenceClasses targetEC) {
        List<Set<RexTableInputRef>> targetEquivalenceClasses;
        if (sourceEC.getEquivalenceClasses().isEmpty() && targetEC.getEquivalenceClasses().isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        if (sourceEC.getEquivalenceClasses().isEmpty() && !targetEC.getEquivalenceClasses().isEmpty()) {
            return null;
        }
        List<Set<RexTableInputRef>> sourceEquivalenceClasses = sourceEC.getEquivalenceClasses();
        Multimap<Integer, Integer> mapping = AbstractMaterializedViewRule.extractPossibleMapping(sourceEquivalenceClasses, targetEquivalenceClasses = targetEC.getEquivalenceClasses());
        if (mapping == null) {
            return null;
        }
        RexNode compensationPredicate = rexBuilder.makeLiteral(true);
        for (int i = 0; i < sourceEquivalenceClasses.size(); ++i) {
            if (!mapping.containsKey((Object)i)) {
                Iterator<RexTableInputRef> it = sourceEquivalenceClasses.get(i).iterator();
                RexTableInputRef e0 = it.next();
                while (it.hasNext()) {
                    RexNode equals = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, e0, it.next());
                    compensationPredicate = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, compensationPredicate, equals);
                }
                continue;
            }
            Iterator iterator = mapping.get((Object)i).iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                HashSet difference = new HashSet(sourceEquivalenceClasses.get(i));
                difference.removeAll((Collection)targetEquivalenceClasses.get(j));
                for (RexTableInputRef e : difference) {
                    RexNode equals = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, e, targetEquivalenceClasses.get(j).iterator().next());
                    compensationPredicate = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, compensationPredicate, equals);
                }
            }
        }
        return compensationPredicate;
    }

    private static Multimap<Integer, Integer> extractPossibleMapping(List<Set<RexTableInputRef>> sourceEquivalenceClasses, List<Set<RexTableInputRef>> targetEquivalenceClasses) {
        ArrayListMultimap mapping = ArrayListMultimap.create();
        for (int i = 0; i < targetEquivalenceClasses.size(); ++i) {
            boolean foundQueryEquivalenceClass = false;
            Set<RexTableInputRef> viewEquivalenceClass = targetEquivalenceClasses.get(i);
            for (int j = 0; j < sourceEquivalenceClasses.size(); ++j) {
                Set<RexTableInputRef> queryEquivalenceClass = sourceEquivalenceClasses.get(j);
                if (!queryEquivalenceClass.containsAll(viewEquivalenceClass)) continue;
                mapping.put((Object)j, (Object)i);
                foundQueryEquivalenceClass = true;
                break;
            }
            if (foundQueryEquivalenceClass) continue;
            return null;
        }
        return mapping;
    }

    private static RexNode rewriteExpression(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode targetNode, RelNode node, List<RexNode> nodeExprs, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, boolean swapTableColumn, RexNode exprToRewrite) {
        List<RexNode> rewrittenExprs = AbstractMaterializedViewRule.rewriteExpressions(rexBuilder, mq, targetNode, node, nodeExprs, tableMapping, ec, swapTableColumn, (List<RexNode>)ImmutableList.of((Object)exprToRewrite));
        if (rewrittenExprs == null) {
            return null;
        }
        assert (rewrittenExprs.size() == 1);
        return rewrittenExprs.get(0);
    }

    private static List<RexNode> rewriteExpressions(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode targetNode, RelNode node, List<RexNode> nodeExprs, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, boolean swapTableColumn, List<RexNode> exprsToRewrite) {
        NodeLineage nodeLineage = swapTableColumn ? AbstractMaterializedViewRule.generateSwapTableColumnReferencesLineage(rexBuilder, mq, node, tableMapping, ec, nodeExprs) : AbstractMaterializedViewRule.generateSwapColumnTableReferencesLineage(rexBuilder, mq, node, tableMapping, ec, nodeExprs);
        ArrayList<RexNode> rewrittenExprs = new ArrayList<RexNode>(exprsToRewrite.size());
        for (RexNode exprToRewrite : exprsToRewrite) {
            RexNode rewrittenExpr = AbstractMaterializedViewRule.replaceWithOriginalReferences(rexBuilder, targetNode, nodeLineage, exprToRewrite);
            if (RexUtil.containsTableInputRef(rewrittenExpr) != null) {
                return null;
            }
            rewrittenExprs.add(rewrittenExpr);
        }
        return rewrittenExprs;
    }

    private static NodeLineage generateSwapTableColumnReferencesLineage(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, List<RexNode> nodeExprs) {
        HashMap<RexNode, Integer> exprsLineage = new HashMap<RexNode, Integer>();
        HashMap<RexNode, Integer> exprsLineageLosslessCasts = new HashMap<RexNode, Integer>();
        for (int i = 0; i < nodeExprs.size(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(node, nodeExprs.get(i));
            if (s == null) continue;
            assert (s.size() == 1);
            RexNode e = RexUtil.swapTableColumnReferences(rexBuilder, s.iterator().next(), tableMapping, ec.getEquivalenceClassesMap());
            exprsLineage.put(e, i);
            if (!RexUtil.isLosslessCast(e)) continue;
            exprsLineageLosslessCasts.put(((RexCall)e).getOperands().get(0), i);
        }
        return new NodeLineage(exprsLineage, exprsLineageLosslessCasts);
    }

    private static NodeLineage generateSwapColumnTableReferencesLineage(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, List<RexNode> nodeExprs) {
        HashMap<RexNode, Integer> exprsLineage = new HashMap<RexNode, Integer>();
        HashMap<RexNode, Integer> exprsLineageLosslessCasts = new HashMap<RexNode, Integer>();
        for (int i = 0; i < nodeExprs.size(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(node, nodeExprs.get(i));
            if (s == null) continue;
            RexNode node2 = (RexNode)Iterables.getOnlyElement(s);
            RexNode e = RexUtil.swapColumnTableReferences(rexBuilder, node2, ec.getEquivalenceClassesMap(), tableMapping);
            exprsLineage.put(e, i);
            if (!RexUtil.isLosslessCast(e)) continue;
            exprsLineageLosslessCasts.put(((RexCall)e).getOperands().get(0), i);
        }
        return new NodeLineage(exprsLineage, exprsLineageLosslessCasts);
    }

    private static RexNode replaceWithOriginalReferences(final RexBuilder rexBuilder, final RelNode node, final NodeLineage nodeLineage, RexNode exprToRewrite) {
        RexShuttle visitor = new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall call) {
                RexNode rw = this.replace(call);
                return rw != null ? rw : super.visitCall(call);
            }

            @Override
            public RexNode visitTableInputRef(RexTableInputRef inputRef) {
                RexNode rw = this.replace(inputRef);
                return rw != null ? rw : super.visitTableInputRef(inputRef);
            }

            private RexNode replace(RexNode e) {
                Integer pos = (Integer)nodeLineage.exprsLineage.get(e);
                if (pos != null) {
                    return rexBuilder.makeInputRef(node, (int)pos);
                }
                pos = (Integer)nodeLineage.exprsLineageLosslessCasts.get(e);
                if (pos != null) {
                    return rexBuilder.makeCast(e.getType(), rexBuilder.makeInputRef(node, (int)pos));
                }
                return null;
            }
        };
        return visitor.apply(exprToRewrite);
    }

    private static RexNode shuttleReferences(final RexBuilder rexBuilder, RexNode node, final Mapping mapping) {
        try {
            RexShuttle visitor = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    int pos = mapping.getTargetOpt(inputRef.getIndex());
                    if (pos != -1) {
                        return rexBuilder.makeInputRef(inputRef.getType(), pos);
                    }
                    throw Util.FoundOne.NULL;
                }
            };
            return visitor.apply(node);
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            return null;
        }
    }

    private static RexNode shuttleReferences(RexBuilder rexBuilder, RexNode expr, Multimap<RexNode, Integer> exprsLineage) {
        return AbstractMaterializedViewRule.shuttleReferences(rexBuilder, expr, exprsLineage, null, null);
    }

    private static RexNode shuttleReferences(final RexBuilder rexBuilder, RexNode expr, final Multimap<RexNode, Integer> exprsLineage, final RelNode node, final Mapping rewritingMapping) {
        try {
            RexShuttle visitor = new RexShuttle(){

                @Override
                public RexNode visitTableInputRef(RexTableInputRef ref) {
                    Collection c = exprsLineage.get((Object)ref);
                    if (c.isEmpty()) {
                        throw Util.FoundOne.NULL;
                    }
                    int pos = (Integer)c.iterator().next();
                    if (rewritingMapping != null && (pos = rewritingMapping.getTargetOpt(pos)) == -1) {
                        throw Util.FoundOne.NULL;
                    }
                    if (node != null) {
                        return rexBuilder.makeInputRef(node, pos);
                    }
                    return rexBuilder.makeInputRef(ref.getType(), pos);
                }

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    Collection c = exprsLineage.get((Object)inputRef);
                    if (c.isEmpty()) {
                        throw Util.FoundOne.NULL;
                    }
                    int pos = (Integer)c.iterator().next();
                    if (rewritingMapping != null && (pos = rewritingMapping.getTargetOpt(pos)) == -1) {
                        throw Util.FoundOne.NULL;
                    }
                    if (node != null) {
                        return rexBuilder.makeInputRef(node, pos);
                    }
                    return rexBuilder.makeInputRef(inputRef.getType(), pos);
                }

                @Override
                public RexNode visitCall(RexCall call) {
                    Collection c = exprsLineage.get((Object)call);
                    if (c.isEmpty()) {
                        return super.visitCall(call);
                    }
                    int pos = (Integer)c.iterator().next();
                    if (rewritingMapping != null && (pos = rewritingMapping.getTargetOpt(pos)) == -1) {
                        return super.visitCall(call);
                    }
                    if (node != null) {
                        return rexBuilder.makeInputRef(node, pos);
                    }
                    return rexBuilder.makeInputRef(call.getType(), pos);
                }
            };
            return visitor.apply(expr);
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            return null;
        }
    }

    private static enum MatchModality {
        COMPLETE,
        VIEW_PARTIAL,
        QUERY_PARTIAL;

    }

    private static class ViewPartialRewriting {
        private final RelNode newView;
        private final Project newTopViewProject;
        private final RelNode newViewNode;

        private ViewPartialRewriting(RelNode newView, Project newTopViewProject, RelNode newViewNode) {
            this.newView = newView;
            this.newTopViewProject = newTopViewProject;
            this.newViewNode = newViewNode;
        }

        protected static ViewPartialRewriting of(RelNode newView, Project newTopViewProject, RelNode newViewNode) {
            return new ViewPartialRewriting(newView, newTopViewProject, newViewNode);
        }
    }

    private static class Edge
    extends DefaultEdge {
        final Multimap<RexTableInputRef, RexTableInputRef> equiColumns = ArrayListMultimap.create();

        Edge(RexTableInputRef.RelTableRef source, RexTableInputRef.RelTableRef target) {
            super(source, target);
        }

        public String toString() {
            return "{" + this.source + " -> " + this.target + "}";
        }
    }

    private static class NodeLineage {
        private final Map<RexNode, Integer> exprsLineage;
        private final Map<RexNode, Integer> exprsLineageLosslessCasts;

        private NodeLineage(Map<RexNode, Integer> exprsLineage, Map<RexNode, Integer> exprsLineageLosslessCasts) {
            this.exprsLineage = ImmutableMap.copyOf(exprsLineage);
            this.exprsLineageLosslessCasts = ImmutableMap.copyOf(exprsLineageLosslessCasts);
        }
    }

    private static class EquivalenceClasses {
        private final Map<RexTableInputRef, Set<RexTableInputRef>> nodeToEquivalenceClass = new HashMap<RexTableInputRef, Set<RexTableInputRef>>();
        private Map<RexTableInputRef, Set<RexTableInputRef>> cacheEquivalenceClassesMap = ImmutableMap.of();
        private List<Set<RexTableInputRef>> cacheEquivalenceClasses = ImmutableList.of();

        protected EquivalenceClasses() {
        }

        protected void addEquivalenceClass(RexTableInputRef p1, RexTableInputRef p2) {
            this.cacheEquivalenceClassesMap = null;
            this.cacheEquivalenceClasses = null;
            Object c1 = this.nodeToEquivalenceClass.get(p1);
            Set<RexTableInputRef> c2 = this.nodeToEquivalenceClass.get(p2);
            if (c1 != null && c2 != null) {
                if (c1.size() < c2.size()) {
                    Set<RexTableInputRef> c2Temp = c2;
                    c2 = c1;
                    c1 = c2Temp;
                }
                for (RexTableInputRef newRef : c2) {
                    c1.add(newRef);
                    this.nodeToEquivalenceClass.put(newRef, (Set<RexTableInputRef>)c1);
                }
            } else if (c1 != null) {
                c1.add((RexTableInputRef)p2);
                this.nodeToEquivalenceClass.put(p2, (Set<RexTableInputRef>)c1);
            } else if (c2 != null) {
                c2.add(p1);
                this.nodeToEquivalenceClass.put(p1, c2);
            } else {
                LinkedHashSet<RexTableInputRef> equivalenceClass = new LinkedHashSet<RexTableInputRef>();
                equivalenceClass.add(p1);
                equivalenceClass.add(p2);
                this.nodeToEquivalenceClass.put(p1, equivalenceClass);
                this.nodeToEquivalenceClass.put(p2, equivalenceClass);
            }
        }

        protected Map<RexTableInputRef, Set<RexTableInputRef>> getEquivalenceClassesMap() {
            if (this.cacheEquivalenceClassesMap == null) {
                this.cacheEquivalenceClassesMap = ImmutableMap.copyOf(this.nodeToEquivalenceClass);
            }
            return this.cacheEquivalenceClassesMap;
        }

        protected List<Set<RexTableInputRef>> getEquivalenceClasses() {
            if (this.cacheEquivalenceClasses == null) {
                HashSet<RexTableInputRef> visited = new HashSet<RexTableInputRef>();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Set<RexTableInputRef> set : this.nodeToEquivalenceClass.values()) {
                    if (!Collections.disjoint(visited, set)) continue;
                    builder.add(set);
                    visited.addAll(set);
                }
                this.cacheEquivalenceClasses = builder.build();
            }
            return this.cacheEquivalenceClasses;
        }

        protected static EquivalenceClasses copy(EquivalenceClasses ec) {
            EquivalenceClasses newEc = new EquivalenceClasses();
            for (Map.Entry<RexTableInputRef, Set<RexTableInputRef>> e : ec.nodeToEquivalenceClass.entrySet()) {
                newEc.nodeToEquivalenceClass.put(e.getKey(), Sets.newLinkedHashSet((Iterable)e.getValue()));
            }
            newEc.cacheEquivalenceClassesMap = null;
            newEc.cacheEquivalenceClasses = null;
            return newEc;
        }
    }

    public static class MaterializedViewOnlyAggregateRule
    extends MaterializedViewAggregateRule {
        public MaterializedViewOnlyAggregateRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram) {
            super(MaterializedViewOnlyAggregateRule.operand(Aggregate.class, MaterializedViewOnlyAggregateRule.any()), relBuilderFactory, "MaterializedViewAggregateRule(Aggregate)", generateUnionRewriting, unionRewritingPullProgram);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            this.perform(call, null, aggregate);
        }
    }

    public static class MaterializedViewProjectAggregateRule
    extends MaterializedViewAggregateRule {
        public MaterializedViewProjectAggregateRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram) {
            super(MaterializedViewProjectAggregateRule.operand(Project.class, MaterializedViewProjectAggregateRule.operand(Aggregate.class, MaterializedViewProjectAggregateRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewAggregateRule(Project-Aggregate)", generateUnionRewriting, unionRewritingPullProgram);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Aggregate aggregate = (Aggregate)call.rel(1);
            this.perform(call, project, aggregate);
        }
    }

    private static abstract class MaterializedViewAggregateRule
    extends AbstractMaterializedViewRule {
        private static final ImmutableList<TimeUnitRange> SUPPORTED_DATE_TIME_ROLLUP_UNITS = ImmutableList.of((Object)TimeUnitRange.YEAR, (Object)TimeUnitRange.QUARTER, (Object)TimeUnitRange.MONTH, (Object)TimeUnitRange.DAY, (Object)TimeUnitRange.HOUR, (Object)TimeUnitRange.MINUTE, (Object)TimeUnitRange.SECOND, (Object)TimeUnitRange.MILLISECOND, (Object)TimeUnitRange.MICROSECOND);
        protected final RelOptRule filterProjectTransposeRule;
        protected final RelOptRule filterAggregateTransposeRule;
        protected final RelOptRule aggregateProjectPullUpConstantsRule;
        protected final RelOptRule projectMergeRule;

        protected MaterializedViewAggregateRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram) {
            super(operand, relBuilderFactory, description, generateUnionRewriting, unionRewritingPullProgram, false);
            this.filterProjectTransposeRule = new FilterProjectTransposeRule(Filter.class, Project.class, true, true, relBuilderFactory);
            this.filterAggregateTransposeRule = new FilterAggregateTransposeRule(Filter.class, relBuilderFactory, Aggregate.class);
            this.aggregateProjectPullUpConstantsRule = new AggregateProjectPullUpConstantsRule(Aggregate.class, Filter.class, relBuilderFactory, "AggFilterPullUpConstants");
            this.projectMergeRule = new ProjectMergeRule(true, relBuilderFactory);
        }

        @Override
        protected boolean isValidPlan(Project topProject, RelNode node, RelMetadataQuery mq) {
            if (!(node instanceof Aggregate)) {
                return false;
            }
            Aggregate aggregate = (Aggregate)node;
            if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
                return false;
            }
            return AbstractMaterializedViewRule.isValidRelNodePlan(aggregate.getInput(), mq);
        }

        @Override
        protected ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, EquivalenceClasses queryEC, Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
            HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
                if (viewTableRefs.contains(tRef)) continue;
                extraTableRefs.add(tRef);
            }
            Collection tableScanNodes = mq.getNodeTypes(node).get(TableScan.class);
            ArrayList<RelNode> newRels = new ArrayList<RelNode>();
            block1: for (RexTableInputRef.RelTableRef tRef : extraTableRefs) {
                int i = 0;
                for (RelNode relNode : tableScanNodes) {
                    if (!tRef.getQualifiedName().equals(relNode.getTable().getQualifiedName()) || tRef.getEntityNumber() != i++) continue;
                    newRels.add(relNode);
                    continue block1;
                }
            }
            assert (extraTableRefs.size() == newRels.size());
            relBuilder.push(input);
            for (RelNode newRel : newRels) {
                relBuilder.push(newRel);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            }
            RelNode newView = relBuilder.build();
            Aggregate aggregateViewNode = (Aggregate)viewNode;
            relBuilder.push(aggregateViewNode.getInput());
            int offset = 0;
            for (RelNode newRel : newRels) {
                relBuilder.push(newRel);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
                offset += newRel.getRowType().getFieldCount();
            }
            ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
            groupSet.addAll(aggregateViewNode.getGroupSet());
            groupSet.addAll(ImmutableBitSet.range(aggregateViewNode.getInput().getRowType().getFieldCount(), aggregateViewNode.getInput().getRowType().getFieldCount() + offset));
            Aggregate newViewNode = aggregateViewNode.copy(aggregateViewNode.getTraitSet(), relBuilder.build(), aggregateViewNode.indicator, groupSet.build(), null, aggregateViewNode.getAggCallList());
            relBuilder.push(newViewNode);
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            if (topViewProject != null) {
                int i;
                Mappings.TargetMapping shiftMapping = Mappings.createShiftMapping(newViewNode.getRowType().getFieldCount(), 0, 0, aggregateViewNode.getGroupCount(), newViewNode.getGroupCount(), aggregateViewNode.getGroupCount(), aggregateViewNode.getAggCallList().size());
                for (i = 0; i < topViewProject.getChildExps().size(); ++i) {
                    nodes.add(topViewProject.getChildExps().get(i).accept(new RexPermuteInputsShuttle(shiftMapping, newViewNode)));
                    fieldNames.add(topViewProject.getRowType().getFieldNames().get(i));
                }
                for (i = aggregateViewNode.getRowType().getFieldCount(); i < newViewNode.getRowType().getFieldCount(); ++i) {
                    int idx = i - aggregateViewNode.getAggCallList().size();
                    nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                    fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
                }
            } else {
                for (int i = 0; i < newViewNode.getRowType().getFieldCount(); ++i) {
                    int idx = i < aggregateViewNode.getGroupCount() ? i : (i < aggregateViewNode.getRowType().getFieldCount() ? i + offset : i - aggregateViewNode.getAggCallList().size());
                    nodes.add(rexBuilder.makeInputRef(newViewNode, idx));
                    fieldNames.add(newViewNode.getRowType().getFieldNames().get(idx));
                }
            }
            relBuilder.project(nodes, fieldNames, true);
            Project newTopViewProject = (Project)relBuilder.build();
            return ViewPartialRewriting.of(newView, newTopViewProject, newViewNode);
        }

        @Override
        protected RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, EquivalenceClasses viewEC, EquivalenceClasses queryEC) {
            Aggregate aggregate = (Aggregate)node;
            RelNode newAggregateInput = aggregate.getInput(0);
            RelNode target = aggregate.getInput(0);
            if (this.unionRewritingPullProgram != null) {
                HepPlanner tmpPlanner = new HepPlanner(this.unionRewritingPullProgram);
                tmpPlanner.setRoot(newAggregateInput);
                newAggregateInput = tmpPlanner.findBestExp();
                target = newAggregateInput.getInput(0);
            }
            List queryExprs = AbstractMaterializedViewRule.extractReferences(rexBuilder, target);
            if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, target, target, queryExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping, queryEC, false, compensationColumnsEquiPred)) == null) {
                return null;
            }
            if (!otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, target, target, queryExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping, viewEC, true, otherCompensationPred)) == null) {
                return null;
            }
            RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)ImmutableList.of((Object)compensationColumnsEquiPred, (Object)otherCompensationPred)));
            RelNode rewrittenPlan = relBuilder.push(target).filter(simplify.simplifyUnknownAsFalse(queryCompensationPred)).build();
            if (this.unionRewritingPullProgram != null) {
                return aggregate.copy(aggregate.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)newAggregateInput.copy(newAggregateInput.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan))));
            }
            return aggregate.copy(aggregate.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan));
        }

        @Override
        protected RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
            RelNode result;
            relBuilder.push(unionInputQuery);
            relBuilder.push(unionInputView);
            relBuilder.union(true);
            ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
            ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
            for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
                RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
                exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
                nameList.add(field.getName());
            }
            relBuilder.project(exprList, nameList);
            Aggregate aggregate = (Aggregate)unionInputQuery;
            ImmutableBitSet groupSet = ImmutableBitSet.range(aggregate.getGroupCount());
            ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
            for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
                AggregateCall aggCall = aggregate.getAggCallList().get(i);
                if (aggCall.isDistinct()) {
                    return null;
                }
                SqlAggFunction rollupAgg = this.getRollup(aggCall.getAggregation());
                if (rollupAgg == null) {
                    return null;
                }
                RexInputRef operand = rexBuilder.makeInputRef(relBuilder.peek(), aggregate.getGroupCount() + i);
                aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).distinct(aggCall.isDistinct()).approximate(aggCall.isApproximate()).as(aggCall.name));
            }
            RelNode prevNode = relBuilder.peek();
            if (prevNode == (result = relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls).build()) && groupSet.cardinality() != result.getRowType().getFieldCount()) {
                result = relBuilder.push(result).project((Iterable<? extends RexNode>)relBuilder.fields(groupSet.asList())).build();
            }
            if (topProject != null) {
                return topProject.copy(topProject.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)result));
            }
            return result;
        }

        @Override
        protected RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, MatchModality matchModality, boolean unionRewriting, RelNode input, Project topProject, RelNode node, Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, EquivalenceClasses queryEC) {
            RelDataType topRowType;
            Aggregate queryAggregate = (Aggregate)node;
            Aggregate viewAggregate = (Aggregate)viewNode;
            ImmutableBitSet.Builder indexes = ImmutableBitSet.builder();
            ImmutableBitSet references = null;
            if (topProject != null && !unionRewriting) {
                int i;
                RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(new LinkedHashSet<RelDataTypeField>());
                for (RexNode rexNode : topProject.getChildExps()) {
                    rexNode.accept(inputFinder);
                }
                references = inputFinder.inputBitSet.build();
                for (i = 0; i < queryAggregate.getGroupCount(); ++i) {
                    indexes.set(queryAggregate.getGroupSet().nth(i));
                }
                for (i = 0; i < queryAggregate.getAggCallList().size(); ++i) {
                    if (!references.get(queryAggregate.getGroupCount() + i)) continue;
                    for (int inputIdx : queryAggregate.getAggCallList().get(i).getArgList()) {
                        indexes.set(inputIdx);
                    }
                }
            } else {
                for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                    indexes.set(queryAggregate.getGroupSet().nth(i));
                }
                for (AggregateCall queryAggCall : queryAggregate.getAggCallList()) {
                    for (int inputIdx : queryAggCall.getArgList()) {
                        indexes.set(inputIdx);
                    }
                }
            }
            ArrayList<RexNode> rollupNodes = new ArrayList<RexNode>();
            Multimap<Integer, Integer> m = this.generateMapping(rexBuilder, simplify, mq, queryAggregate.getInput(), viewAggregate.getInput(), indexes.build(), queryToViewTableMapping, queryEC, rollupNodes);
            if (m == null) {
                return null;
            }
            int n = rollupNodes.size();
            int viewInputFieldCount = viewAggregate.getInput().getRowType().getFieldCount();
            int viewInputDifferenceViewFieldCount = viewAggregate.getRowType().getFieldCount() - viewInputFieldCount;
            int viewAggregateTotalFieldCount = viewAggregate.getRowType().getFieldCount() + rollupNodes.size();
            boolean forceRollup = false;
            Mapping aggregateMapping = Mappings.create(MappingType.FUNCTION, queryAggregate.getRowType().getFieldCount(), viewAggregateTotalFieldCount);
            for (int i = 0; i < queryAggregate.getGroupCount(); ++i) {
                Collection c = m.get((Object)queryAggregate.getGroupSet().nth(i));
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    if (j >= viewAggregate.getInput().getRowType().getFieldCount()) {
                        aggregateMapping.set(i, j + viewInputDifferenceViewFieldCount);
                        forceRollup = true;
                        break;
                    }
                    int targetIdx = viewAggregate.getGroupSet().indexOf(j);
                    if (targetIdx == -1) continue;
                    aggregateMapping.set(i, targetIdx);
                    break;
                }
                if (aggregateMapping.getTargetOpt(i) != -1) continue;
                return null;
            }
            boolean containsDistinctAgg = false;
            block9: for (int idx = 0; idx < queryAggregate.getAggCallList().size(); ++idx) {
                if (references != null && !references.get(queryAggregate.getGroupCount() + idx)) continue;
                AggregateCall queryAggCall = queryAggregate.getAggCallList().get(idx);
                if (queryAggCall.filterArg >= 0) {
                    return null;
                }
                ArrayList queryAggCallIndexes = new ArrayList();
                for (int aggCallIdx : queryAggCall.getArgList()) {
                    queryAggCallIndexes.add(m.get((Object)aggCallIdx).iterator().next());
                }
                for (int j = 0; j < viewAggregate.getAggCallList().size(); ++j) {
                    AggregateCall viewAggCall = viewAggregate.getAggCallList().get(j);
                    if (queryAggCall.getAggregation().getKind() != viewAggCall.getAggregation().getKind() || queryAggCall.isDistinct() != viewAggCall.isDistinct() || queryAggCall.getArgList().size() != viewAggCall.getArgList().size() || queryAggCall.getType() != viewAggCall.getType() || viewAggCall.filterArg >= 0 || !queryAggCallIndexes.equals(viewAggCall.getArgList())) continue;
                    aggregateMapping.set(queryAggregate.getGroupCount() + idx, viewAggregate.getGroupCount() + j);
                    if (!queryAggCall.isDistinct()) continue block9;
                    containsDistinctAgg = true;
                    continue block9;
                }
            }
            if (topViewProject == null) {
                topViewProject = (Project)relBuilder.push(viewNode).project((Iterable<? extends RexNode>)relBuilder.fields(), (Iterable<String>)ImmutableList.of(), true).build();
            }
            ArrayList<RexInputRef> additionalViewExprs = new ArrayList<RexInputRef>();
            Mapping rewritingMapping = null;
            RelNode result = relBuilder.push(input).build();
            ArrayList<RexNode> inputViewExprs = new ArrayList<RexNode>();
            inputViewExprs.addAll((Collection<RexNode>)relBuilder.push(result).fields());
            relBuilder.clear();
            if (forceRollup || queryAggregate.getGroupCount() != viewAggregate.getGroupCount() || matchModality == MatchModality.VIEW_PARTIAL) {
                int i;
                if (containsDistinctAgg) {
                    return null;
                }
                rewritingMapping = Mappings.create(MappingType.FUNCTION, topViewProject.getRowType().getFieldCount() + n, queryAggregate.getRowType().getFieldCount());
                ImmutableBitSet.Builder groupSetB = ImmutableBitSet.builder();
                for (int i2 = 0; i2 < queryAggregate.getGroupCount(); ++i2) {
                    int targetIdx = aggregateMapping.getTargetOpt(i2);
                    if (targetIdx == -1) {
                        return null;
                    }
                    boolean added = false;
                    if (targetIdx >= viewAggregate.getRowType().getFieldCount()) {
                        RexNode targetNode = (RexNode)rollupNodes.get(targetIdx - viewInputFieldCount - viewInputDifferenceViewFieldCount);
                        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                        ImmutableBitSet refs = RelOptUtil.InputFinder.bits(targetNode);
                        for (int childTargetIdx : refs) {
                            added = false;
                            for (int k = 0; k < topViewProject.getChildExps().size() && !added; ++k) {
                                int ref;
                                RexNode n2 = topViewProject.getChildExps().get(k);
                                if (!n2.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n2).getIndex()) != childTargetIdx) continue;
                                arrayListMultimap.put((Object)new RexInputRef(ref, targetNode.getType()), (Object)k);
                                added = true;
                            }
                            if (added) continue;
                            return null;
                        }
                        groupSetB.set(inputViewExprs.size());
                        rewritingMapping.set(inputViewExprs.size(), i2);
                        additionalViewExprs.add(new RexInputRef(targetIdx, targetNode.getType()));
                        inputViewExprs.add(AbstractMaterializedViewRule.shuttleReferences(rexBuilder, targetNode, (Multimap<RexNode, Integer>)((Multimap)arrayListMultimap)));
                        added = true;
                    } else {
                        for (int k = 0; k < topViewProject.getChildExps().size() && !added; ++k) {
                            int ref;
                            RexNode rexNode = topViewProject.getChildExps().get(k);
                            if (!rexNode.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)rexNode).getIndex()) != targetIdx) continue;
                            groupSetB.set(k);
                            rewritingMapping.set(k, i2);
                            added = true;
                        }
                    }
                    if (added) continue;
                    return null;
                }
                ImmutableBitSet groupSet = groupSetB.build();
                ArrayList<RelBuilder.AggCall> aggregateCalls = new ArrayList<RelBuilder.AggCall>();
                for (int i3 = 0; i3 < queryAggregate.getAggCallList().size(); ++i3) {
                    if (references != null && !references.get(queryAggregate.getGroupCount() + i3)) continue;
                    int sourceIdx = queryAggregate.getGroupCount() + i3;
                    int n3 = aggregateMapping.getTargetOpt(sourceIdx);
                    if (n3 < 0) {
                        return null;
                    }
                    AggregateCall queryAggCall = queryAggregate.getAggCallList().get(i3);
                    boolean added = false;
                    for (int k = 0; k < topViewProject.getChildExps().size() && !added; ++k) {
                        int ref;
                        RexNode n4 = topViewProject.getChildExps().get(k);
                        if (!n4.isA(SqlKind.INPUT_REF) || (ref = ((RexInputRef)n4).getIndex()) != n3) continue;
                        SqlAggFunction rollupAgg = this.getRollup(queryAggCall.getAggregation());
                        if (rollupAgg == null) {
                            return null;
                        }
                        RexInputRef operand = rexBuilder.makeInputRef(input, k);
                        aggregateCalls.add(relBuilder.aggregateCall(rollupAgg, operand).approximate(queryAggCall.isApproximate()).distinct(queryAggCall.isDistinct()).as(queryAggCall.name));
                        rewritingMapping.set(k, sourceIdx);
                        added = true;
                    }
                    if (added) continue;
                    return null;
                }
                RelNode prevNode = result;
                relBuilder.push(result);
                if (inputViewExprs.size() != result.getRowType().getFieldCount()) {
                    relBuilder.project(inputViewExprs);
                }
                if (prevNode == (result = relBuilder.aggregate(relBuilder.groupKey(groupSet), (Iterable<RelBuilder.AggCall>)aggregateCalls).build()) && groupSet.cardinality() != result.getRowType().getFieldCount()) {
                    result = relBuilder.push(result).project((Iterable<? extends RexNode>)relBuilder.fields(groupSet.asList())).build();
                }
                ArrayList projects = new ArrayList();
                Mapping mapping = rewritingMapping.inverse();
                for (i = 0; i < queryAggregate.getGroupCount(); ++i) {
                    projects.add(rexBuilder.makeInputRef(result, groupSet.indexOf(mapping.getTarget(i))));
                }
                for (i = 0; i < queryAggregate.getAggCallList().size(); ++i) {
                    projects.add(rexBuilder.makeInputRef(result, queryAggregate.getGroupCount() + i));
                }
                result = relBuilder.push(result).project(projects).build();
            }
            ArrayList<RexNode> topExprs = new ArrayList<RexNode>();
            if (topProject != null && !unionRewriting) {
                topExprs.addAll(topProject.getChildExps());
                topRowType = topProject.getRowType();
            } else {
                for (int pos = 0; pos < queryAggregate.getRowType().getFieldCount(); ++pos) {
                    topExprs.add(rexBuilder.makeInputRef(queryAggregate, pos));
                }
                topRowType = queryAggregate.getRowType();
            }
            ArrayListMultimap viewExprs = ArrayListMultimap.create();
            int numberViewExprs = 0;
            for (RexNode rexNode : topViewProject.getChildExps()) {
                viewExprs.put((Object)rexNode, (Object)numberViewExprs++);
            }
            for (RexNode rexNode : additionalViewExprs) {
                viewExprs.put((Object)rexNode, (Object)numberViewExprs++);
            }
            ArrayList<RexNode> rewrittenExprs = new ArrayList<RexNode>(topExprs.size());
            for (RexNode expr : topExprs) {
                RexNode rewrittenExpr = AbstractMaterializedViewRule.shuttleReferences(rexBuilder, expr, aggregateMapping);
                if (rewrittenExpr == null) {
                    return null;
                }
                if ((rewrittenExpr = AbstractMaterializedViewRule.shuttleReferences(rexBuilder, rewrittenExpr, (Multimap<RexNode, Integer>)((Multimap)viewExprs), result, rewritingMapping)) == null) {
                    return null;
                }
                rewrittenExprs.add(rewrittenExpr);
            }
            return relBuilder.push(result).project(rewrittenExprs).convert(topRowType, false).build();
        }

        protected Multimap<Integer, Integer> generateMapping(RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RelNode node, RelNode target, ImmutableBitSet positions, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses sourceEC, List<RexNode> additionalExprs) {
            Preconditions.checkArgument((boolean)additionalExprs.isEmpty());
            ArrayListMultimap m = ArrayListMultimap.create();
            Map<RexTableInputRef, Set<RexTableInputRef>> equivalenceClassesMap = sourceEC.getEquivalenceClassesMap();
            ArrayListMultimap exprsLineage = ArrayListMultimap.create();
            ArrayList<RexNode> timestampExprs = new ArrayList<RexNode>();
            for (int i = 0; i < target.getRowType().getFieldCount(); ++i) {
                Set<RexNode> s = mq.getExpressionLineage(target, rexBuilder.makeInputRef(target, i));
                if (s == null) continue;
                RexNode e = (RexNode)Iterables.getOnlyElement(s);
                RexNode simplified = simplify.simplifyUnknownAsFalse(e);
                RexNode expr = RexUtil.swapTableColumnReferences(rexBuilder, simplified, (Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)tableMapping.inverse(), equivalenceClassesMap);
                exprsLineage.put((Object)expr, (Object)i);
                SqlTypeName sqlTypeName = expr.getType().getSqlTypeName();
                if (sqlTypeName != SqlTypeName.TIMESTAMP && sqlTypeName != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) continue;
                timestampExprs.add(expr);
            }
            for (RexNode timestampExpr : timestampExprs) {
                for (TimeUnitRange value : SUPPORTED_DATE_TIME_ROLLUP_UNITS) {
                    RexNode floorExpr;
                    Object rewrittenFloorExpr;
                    RexNode ceilExpr = rexBuilder.makeCall((SqlOperator)this.getCeilSqlFunction(value), timestampExpr, rexBuilder.makeFlag((Enum)value));
                    RexNode rewrittenCeilExpr = AbstractMaterializedViewRule.shuttleReferences(rexBuilder, ceilExpr, (Multimap<RexNode, Integer>)((Multimap)exprsLineage));
                    if (rewrittenCeilExpr != null) {
                        additionalExprs.add(rewrittenCeilExpr);
                        RexNode simplified = simplify.simplifyUnknownAsFalse(ceilExpr);
                        exprsLineage.put((Object)simplified, (Object)(target.getRowType().getFieldCount() + additionalExprs.size() - 1));
                    }
                    if ((rewrittenFloorExpr = AbstractMaterializedViewRule.shuttleReferences(rexBuilder, floorExpr = rexBuilder.makeCall((SqlOperator)this.getFloorSqlFunction(value), timestampExpr, rexBuilder.makeFlag((Enum)value)), (Multimap<RexNode, Integer>)((Multimap)exprsLineage))) == null) continue;
                    additionalExprs.add((RexNode)rewrittenFloorExpr);
                    RexNode simplified = simplify.simplifyUnknownAsFalse(floorExpr);
                    exprsLineage.put((Object)simplified, (Object)(target.getRowType().getFieldCount() + additionalExprs.size() - 1));
                }
            }
            Iterator<Object> iterator = positions.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Set<RexNode> s = mq.getExpressionLineage(node, rexBuilder.makeInputRef(node, i));
                if (s == null) {
                    return null;
                }
                RexNode e = (RexNode)Iterables.getOnlyElement(s);
                RexNode simplified = simplify.simplifyUnknownAsFalse(e);
                RexNode targetExpr = RexUtil.swapColumnReferences(rexBuilder, simplified, equivalenceClassesMap);
                Collection c = exprsLineage.get((Object)targetExpr);
                if (!c.isEmpty()) {
                    for (Integer j : c) {
                        m.put((Object)i, (Object)j);
                    }
                    continue;
                }
                RexNode rewrittenTargetExpr = AbstractMaterializedViewRule.shuttleReferences(rexBuilder, targetExpr, (Multimap<RexNode, Integer>)((Multimap)exprsLineage));
                if (rewrittenTargetExpr == null) {
                    return null;
                }
                m.put((Object)i, (Object)(target.getRowType().getFieldCount() + additionalExprs.size()));
                additionalExprs.add(rewrittenTargetExpr);
            }
            return m;
        }

        protected SqlFunction getCeilSqlFunction(TimeUnitRange flag) {
            return SqlStdOperatorTable.CEIL;
        }

        protected SqlFunction getFloorSqlFunction(TimeUnitRange flag) {
            return SqlStdOperatorTable.FLOOR;
        }

        protected SqlAggFunction getRollup(SqlAggFunction aggregation) {
            if (aggregation == SqlStdOperatorTable.SUM || aggregation == SqlStdOperatorTable.MIN || aggregation == SqlStdOperatorTable.MAX || aggregation == SqlStdOperatorTable.SUM0 || aggregation == SqlStdOperatorTable.ANY_VALUE) {
                return aggregation;
            }
            if (aggregation == SqlStdOperatorTable.COUNT) {
                return SqlStdOperatorTable.SUM0;
            }
            return null;
        }

        @Override
        public Pair<RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder builder, RelNode topViewProject, RelNode viewNode, RexNode cond) {
            HepProgramBuilder pushFiltersProgram = new HepProgramBuilder();
            if (topViewProject != null) {
                pushFiltersProgram.addRuleInstance(this.filterProjectTransposeRule);
            }
            pushFiltersProgram.addRuleInstance(this.filterAggregateTransposeRule).addRuleInstance(this.aggregateProjectPullUpConstantsRule).addRuleInstance(this.projectMergeRule);
            HepPlanner tmpPlanner = new HepPlanner(pushFiltersProgram.build());
            RelNode topNode = builder.push(topViewProject != null ? topViewProject : viewNode).filter(cond).build();
            tmpPlanner.setRoot(topNode);
            topNode = tmpPlanner.findBestExp();
            RelNode resultTopViewProject = null;
            RelNode resultViewNode = null;
            while (topNode != null) {
                if (topNode instanceof Project) {
                    if (resultTopViewProject != null) {
                        return Pair.of(topViewProject, viewNode);
                    }
                    resultTopViewProject = topNode;
                    topNode = topNode.getInput(0);
                    continue;
                }
                if (topNode instanceof Aggregate) {
                    resultViewNode = topNode;
                    topNode = null;
                    continue;
                }
                topNode = topNode.getInput(0);
            }
            return Pair.of(resultTopViewProject, resultViewNode);
        }
    }

    public static class MaterializedViewOnlyFilterRule
    extends MaterializedViewJoinRule {
        public MaterializedViewOnlyFilterRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram, boolean fastBailOut) {
            super(MaterializedViewOnlyFilterRule.operand(Filter.class, MaterializedViewOnlyFilterRule.any()), relBuilderFactory, "MaterializedViewJoinRule(Filter)", generateUnionRewriting, unionRewritingPullProgram, fastBailOut);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            this.perform(call, null, filter);
        }
    }

    public static class MaterializedViewOnlyJoinRule
    extends MaterializedViewJoinRule {
        public MaterializedViewOnlyJoinRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram, boolean fastBailOut) {
            super(MaterializedViewOnlyJoinRule.operand(Join.class, MaterializedViewOnlyJoinRule.any()), relBuilderFactory, "MaterializedViewJoinRule(Join)", generateUnionRewriting, unionRewritingPullProgram, fastBailOut);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            this.perform(call, null, join);
        }
    }

    public static class MaterializedViewProjectFilterRule
    extends MaterializedViewJoinRule {
        public MaterializedViewProjectFilterRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram, boolean fastBailOut) {
            super(MaterializedViewProjectFilterRule.operand(Project.class, MaterializedViewProjectFilterRule.operand(Filter.class, MaterializedViewProjectFilterRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewJoinRule(Project-Filter)", generateUnionRewriting, unionRewritingPullProgram, fastBailOut);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Filter filter = (Filter)call.rel(1);
            this.perform(call, project, filter);
        }
    }

    public static class MaterializedViewProjectJoinRule
    extends MaterializedViewJoinRule {
        public MaterializedViewProjectJoinRule(RelBuilderFactory relBuilderFactory, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram, boolean fastBailOut) {
            super(MaterializedViewProjectJoinRule.operand(Project.class, MaterializedViewProjectJoinRule.operand(Join.class, MaterializedViewProjectJoinRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewJoinRule(Project-Join)", generateUnionRewriting, unionRewritingPullProgram, fastBailOut);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Join join = (Join)call.rel(1);
            this.perform(call, project, join);
        }
    }

    private static abstract class MaterializedViewJoinRule
    extends AbstractMaterializedViewRule {
        protected MaterializedViewJoinRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description, boolean generateUnionRewriting, HepProgram unionRewritingPullProgram, boolean fastBailOut) {
            super(operand, relBuilderFactory, description, generateUnionRewriting, unionRewritingPullProgram, fastBailOut);
        }

        @Override
        protected boolean isValidPlan(Project topProject, RelNode node, RelMetadataQuery mq) {
            return AbstractMaterializedViewRule.isValidRelNodePlan(node, mq);
        }

        @Override
        protected ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, EquivalenceClasses queryEC, Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
            if (this.fastBailOut) {
                for (RelNode relNode : node.getInputs()) {
                    if (!mq.getTableReferences(relNode).containsAll(viewTableRefs)) continue;
                    return null;
                }
            }
            HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
                if (viewTableRefs.contains(tRef)) continue;
                extraTableRefs.add(tRef);
            }
            Collection collection = mq.getNodeTypes(node).get(TableScan.class);
            ArrayList<RelNode> newRels = new ArrayList<RelNode>();
            block2: for (RexTableInputRef.RelTableRef relTableRef : extraTableRefs) {
                int i = 0;
                for (RelNode relNode : collection) {
                    if (!relTableRef.getQualifiedName().equals(relNode.getTable().getQualifiedName()) || relTableRef.getEntityNumber() != i++) continue;
                    newRels.add(relNode);
                    continue block2;
                }
            }
            assert (extraTableRefs.size() == newRels.size());
            relBuilder.push(input);
            for (RelNode relNode : newRels) {
                relBuilder.push(relNode);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            }
            RelNode newView = relBuilder.build();
            relBuilder.push(topViewProject != null ? topViewProject : viewNode);
            for (RelNode newRel : newRels) {
                relBuilder.push(newRel);
                relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
            }
            RelNode relNode = relBuilder.build();
            return ViewPartialRewriting.of(newView, null, relNode);
        }

        @Override
        protected RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> viewToQueryTableMapping, EquivalenceClasses viewEC, EquivalenceClasses queryEC) {
            RelNode newNode = node;
            RelNode target = node;
            if (this.unionRewritingPullProgram != null) {
                HepPlanner tmpPlanner = new HepPlanner(this.unionRewritingPullProgram);
                tmpPlanner.setRoot(newNode);
                newNode = tmpPlanner.findBestExp();
                target = newNode.getInput(0);
            }
            List queryExprs = AbstractMaterializedViewRule.extractReferences(rexBuilder, target);
            if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, target, target, queryExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)viewToQueryTableMapping.inverse(), queryEC, false, compensationColumnsEquiPred)) == null) {
                return null;
            }
            if (!otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = AbstractMaterializedViewRule.rewriteExpression(rexBuilder, mq, target, target, queryExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)viewToQueryTableMapping.inverse(), viewEC, true, otherCompensationPred)) == null) {
                return null;
            }
            RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)ImmutableList.of((Object)compensationColumnsEquiPred, (Object)otherCompensationPred)));
            RelNode rewrittenPlan = relBuilder.push(target).filter(simplify.simplifyUnknownAsFalse(queryCompensationPred)).build();
            if (this.unionRewritingPullProgram != null) {
                rewrittenPlan = newNode.copy(newNode.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan));
            }
            if (topProject != null) {
                return topProject.copy(topProject.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan));
            }
            return rewrittenPlan;
        }

        @Override
        protected RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
            relBuilder.push(unionInputQuery);
            relBuilder.push(unionInputView);
            relBuilder.union(true);
            ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
            ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
            for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
                RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
                exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
                nameList.add(field.getName());
            }
            relBuilder.project(exprList, nameList);
            return relBuilder.build();
        }

        @Override
        protected RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, MatchModality matchModality, boolean unionRewriting, RelNode input, Project topProject, RelNode node, Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, EquivalenceClasses queryEC) {
            List exprs = topProject == null ? AbstractMaterializedViewRule.extractReferences(rexBuilder, node) : topProject.getChildExps();
            ArrayList<RexNode> exprsLineage = new ArrayList<RexNode>(exprs.size());
            for (RexNode expr : exprs) {
                Set<RexNode> s = mq.getExpressionLineage(node, expr);
                if (s == null) {
                    return null;
                }
                assert (s.size() == 1);
                exprsLineage.add(RexUtil.swapColumnReferences(rexBuilder, s.iterator().next(), queryEC.getEquivalenceClassesMap()));
            }
            List viewExprs = topViewProject == null ? AbstractMaterializedViewRule.extractReferences(rexBuilder, viewNode) : topViewProject.getChildExps();
            List rewrittenExprs = AbstractMaterializedViewRule.rewriteExpressions(rexBuilder, mq, input, viewNode, viewExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping.inverse(), queryEC, true, exprsLineage);
            if (rewrittenExprs == null) {
                return null;
            }
            return relBuilder.push(input).project(rewrittenExprs).convert(topProject != null ? topProject.getRowType() : node.getRowType(), false).build();
        }

        @Override
        public Pair<RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder builder, RelNode topViewProject, RelNode viewNode, RexNode cond) {
            return Pair.of(topViewProject, viewNode);
        }
    }
}

