/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.RelReferentialConstraintImpl;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Smalls;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.mapping.IntPair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MaterializationTest {
    private static final Consumer<ResultSet> CONTAINS_M0 = CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, m0]])");
    private static final Consumer<ResultSet> CONTAINS_LOCATIONS = CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, locations]])");
    private static final Ordering<Iterable<String>> CASE_INSENSITIVE_LIST_COMPARATOR = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).lexicographical();
    private static final Ordering<Iterable<List<String>>> CASE_INSENSITIVE_LIST_LIST_COMPARATOR = CASE_INSENSITIVE_LIST_COMPARATOR.lexicographical();
    private static final String HR_FKUK_SCHEMA = "{\n       type: 'custom',\n       name: 'hr',\n       factory: '" + ReflectiveSchema.Factory.class.getName() + "',\n       operand: {\n         class: '" + HrFKUKSchema.class.getName() + "'\n       }\n     }\n";
    private static final String HR_FKUK_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'hr',\n   schemas: [\n" + HR_FKUK_SCHEMA + "   ]\n}";
    final JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    private final RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
    private final RexSimplify simplify = new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, RexUtil.EXECUTOR).withParanoid(true);

    @Test
    public void testScan() {
        CalciteAssert.that().withMaterializations("{\n  version: '1.0',\n  defaultSchema: 'SCOTT_CLONE',\n  schemas: [ {\n    name: 'SCOTT_CLONE',\n    type: 'custom',\n    factory: 'org.apache.calcite.adapter.clone.CloneSchema$Factory',\n    operand: {\n      jdbcDriver: '" + JdbcTest.SCOTT.driver + "',\n      jdbcUser: '" + JdbcTest.SCOTT.username + "',\n      jdbcPassword: '" + JdbcTest.SCOTT.password + "',\n      jdbcUrl: '" + JdbcTest.SCOTT.url + "',\n      jdbcSchema: 'SCOTT'\n   } } ]\n}", "m0", "select empno, deptno from emp order by deptno").query("select empno, deptno from emp").enableMaterializations(true).explainContains("EnumerableTableScan(table=[[SCOTT_CLONE, m0]])").sameResultWithMaterializationsDisabled();
    }

    @Test
    public void testFilter() {
        CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select * from \"emps\" where \"deptno\" = 10").query("select \"empid\" + 1 from \"emps\" where \"deptno\" = 10").enableMaterializations(true).explainContains("EnumerableTableScan(table=[[hr, m0]])").sameResultWithMaterializationsDisabled();
    }

    @Test
    public void testFilterQueryOnProjectView() {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select \"deptno\", \"empid\" from \"emps\"").query("select \"empid\" + 1 as x from \"emps\" where \"deptno\" = 10").enableMaterializations(true).explainContains("EnumerableTableScan(table=[[hr, m0]])").sameResultWithMaterializationsDisabled();
        }
    }

    private void checkMaterialize(String materialize, String query) {
        this.checkMaterialize(materialize, query, HR_FKUK_MODEL, CONTAINS_M0, RuleSets.ofList((Iterable)ImmutableList.of()));
    }

    private void checkMaterializeWithRules(String materialize, String query, RuleSet rules) {
        this.checkMaterialize(materialize, query, HR_FKUK_MODEL, CONTAINS_M0, rules);
    }

    private void checkMaterialize(String materialize, String query, String model, Consumer<ResultSet> explainChecker) {
        this.checkMaterialize(materialize, query, model, explainChecker, RuleSets.ofList((Iterable)ImmutableList.of()));
    }

    private void checkMaterialize(String materialize, String query, String model, Consumer<ResultSet> explainChecker, RuleSet rules) {
        this.checkThatMaterialize(materialize, query, "m0", false, model, explainChecker, rules).sameResultWithMaterializationsDisabled();
    }

    private CalciteAssert.AssertQuery checkThatMaterialize(String materialize, String query, String name, boolean existing, String model, Consumer<ResultSet> explainChecker, RuleSet rules) {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.AssertQuery that = CalciteAssert.that().withMaterializations(model, existing, name, materialize).query(query).enableMaterializations(true);
            if (rules.iterator().hasNext()) {
                that.withHook(Hook.PLANNER, planner -> {
                    for (RelOptRule rule : rules) {
                        planner.addRule(rule);
                    }
                });
            }
            CalciteAssert.AssertQuery assertQuery = that.explainMatches("", explainChecker);
            return assertQuery;
        }
    }

    private void checkNoMaterialize(String materialize, String query, String model) {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.that().withMaterializations(model, "m0", materialize).query(query).enableMaterializations(true).explainContains("EnumerableTableScan(table=[[hr, emps]])");
        }
    }

    @Test
    public void testFilterQueryOnProjectView0() {
        this.checkMaterialize("select \"deptno\", \"empid\" from \"emps\"", "select \"empid\" + 1 as x from \"emps\" where \"deptno\" = 10");
    }

    @Test
    public void testFilterQueryOnProjectView1() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\"", "select \"empid\" + 1 as x from \"emps\" where \"deptno\" = 10");
    }

    @Test
    public void testFilterQueryOnProjectView2() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\"", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10");
    }

    @Test
    public void testFilterQueryOnProjectView3() {
        this.checkMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1, \"name\" from \"emps\"", "select \"name\" from \"emps\" where \"deptno\" - 10 = 0");
    }

    @Test
    public void testFilterQueryOnProjectView4() {
        this.checkNoMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1, \"name\" from \"emps\"", "select \"name\" from \"emps\" where \"deptno\" + 10 = 20", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnProjectView5() {
        this.checkMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1 as ee, \"name\"\nfrom \"emps\"", "select \"name\", \"empid\" + 1 as e\nfrom \"emps\" where \"deptno\" - 10 = 2", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..2=[{inputs}], expr#3=[2], expr#4=[=($t0, $t3)], name=[$t2], EE=[$t1], $condition=[$t4])\n  EnumerableTableScan(table=[[hr, m0]]"));
    }

    @Test
    public void testFilterQueryOnProjectView6() {
        this.checkNoMaterialize("select \"deptno\" - 10 as \"x\", \"empid\"  from \"emps\"", "select \"name\" from \"emps\" where \"deptno\" - 10 = 0", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnProjectView7() {
        this.checkNoMaterialize("select \"deptno\" - 10 as \"x\", \"empid\" + 1, \"name\" from \"emps\"", "select \"name\", \"empid\" + 2 from \"emps\" where \"deptno\" - 10 = 0", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnProjectView8() {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            String m = "select \"salary\", \"commission\",\n\"deptno\", \"empid\", \"name\" from \"emps\"";
            String v = "select * from \"emps\" where \"name\" is null";
            String q = "select * from V where \"commission\" is null";
            JsonBuilder builder = new JsonBuilder();
            String model = "{\n  version: '1.0',\n  defaultSchema: 'hr',\n  schemas: [\n    {\n      materializations: [\n        {\n          table: 'm0',\n          view: 'm0v',\n          sql: " + builder.toJsonString((Object)"select \"salary\", \"commission\",\n\"deptno\", \"empid\", \"name\" from \"emps\"") + "        }\n      ],\n      tables: [\n        {\n          name: 'V',\n          type: 'view',\n          sql: " + builder.toJsonString((Object)"select * from \"emps\" where \"name\" is null") + "\n        }\n      ],\n      type: 'custom',\n      name: 'hr',\n      factory: 'org.apache.calcite.adapter.java.ReflectiveSchema$Factory',\n      operand: {\n        class: 'org.apache.calcite.test.JdbcTest$HrSchema'\n      }\n    }\n  ]\n}\n";
            CalciteAssert.that().withModel(model).query("select * from V where \"commission\" is null").enableMaterializations(true).explainMatches("", CONTAINS_M0).sameResultWithMaterializationsDisabled();
        }
    }

    @Test
    public void testFilterQueryOnFilterView() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\" where \"deptno\" = 10", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10");
    }

    @Ignore
    @Test
    public void testFilterQueryOnFilterView2() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\" where \"deptno\" = 10", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10 and \"empid\" < 150");
    }

    @Ignore(value="not implemented")
    @Test
    public void testFilterQueryOnFilterView3() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\" from \"emps\" where \"deptno\" = 10 or \"deptno\" = 20 or \"empid\" < 160", "select \"empid\" + 1 as x, \"name\" from \"emps\" where \"deptno\" = 10", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalcRel(expr#0..2=[{inputs}], expr#3=[1], expr#4=[+($t1, $t3)], X=[$t4], name=[$t2], condition=?)\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testFilterQueryOnFilterView4() {
        this.checkMaterialize("select * from \"emps\" where \"deptno\" > 10", "select \"name\" from \"emps\" where \"deptno\" > 30");
    }

    @Test
    public void testFilterQueryOnFilterView5() {
        this.checkMaterialize("select \"name\", \"deptno\" from \"emps\" where \"deptno\" > 10", "select \"name\" from \"emps\" where \"deptno\" > 30");
    }

    @Test
    public void testFilterQueryOnFilterView6() {
        this.checkMaterialize("select \"name\", \"deptno\", \"salary\" from \"emps\" where \"salary\" > 2000.5", "select \"name\" from \"emps\" where \"deptno\" > 30 and \"salary\" > 3000");
    }

    @Test
    public void testFilterQueryOnFilterView7() {
        this.checkMaterialize("select * from \"emps\" where ((\"salary\" < 1111.9 and \"deptno\" > 10)or (\"empid\" > 400 and \"salary\" > 5000) or \"salary\" > 500)", "select \"name\" from \"emps\" where (\"salary\" > 1000 or (\"deptno\" >= 30 and \"salary\" <= 500))");
    }

    @Test
    public void testFilterQueryOnFilterView8() {
        this.checkNoMaterialize("select \"name\", \"deptno\" from \"emps\" where \"deptno\" > 10", "select \"name\", \"empid\" from \"emps\" where \"deptno\" > 30", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnFilterView9() {
        this.checkNoMaterialize("select \"name\", \"deptno\" from \"emps\" where \"deptno\" > 10", "select \"name\", \"empid\" from \"emps\" where \"deptno\" > 30 or \"empid\" > 10", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnFilterView10() {
        this.checkNoMaterialize("select \"name\", \"deptno\" from \"emps\" where \"deptno\" > 10 and \"name\" = 'calcite'", "select \"name\", \"empid\" from \"emps\" where \"deptno\" > 30 or \"empid\" > 10", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnFilterView11() {
        this.checkNoMaterialize("select \"name\", \"deptno\" from \"emps\" where (\"salary\" < 1111.9 and \"deptno\" > 10)or (\"empid\" > 400 and \"salary\" > 5000)", "select \"name\" from \"emps\" where \"deptno\" > 30 and \"salary\" > 3000", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnFilterView12() {
        this.checkNoMaterialize("select \"name\", \"deptno\" from \"emps\" where \"salary\" > 2000.5", "select \"name\" from \"emps\" where \"deptno\" > 30 and \"salary\" > 3000", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnFilterView13() {
        this.checkNoMaterialize("select * from \"emps\" where (\"salary\" < 1111.9 and \"deptno\" > 10)or (\"empid\" > 400 and \"salary\" > 5000)", "select \"name\" from \"emps\" where \"salary\" > 1000 or (\"deptno\" > 30 and \"salary\" > 3000)", HR_FKUK_MODEL);
    }

    @Test
    public void testFilterQueryOnFilterView14() {
        String q = "select * from \"emps\" where (\"salary\" > 1000 or (\"deptno\" >= 30 and \"salary\" <= 500))";
        String m = "select \"deptno\", \"empid\", \"name\", \"salary\", \"commission\" from \"emps\" as em where ((\"salary\" < 1111.9 and \"deptno\" > 10)or (\"empid\" > 400 and \"salary\" > 5000) or \"salary\" > 500)";
        this.checkMaterialize(m, q);
    }

    @Test
    public void testAlias() {
        this.checkMaterialize("select * from \"emps\" as em where (em.\"salary\" < 1111.9 and em.\"deptno\" > 10)or (em.\"empid\" > 400 and em.\"salary\" > 5000)", "select \"name\" as n from \"emps\" as e where (e.\"empid\" > 500 and e.\"salary\" > 6000)");
    }

    @Test
    public void testAggregate() {
        this.checkMaterialize("select \"deptno\", count(*) as c, sum(\"empid\") as s from \"emps\" group by \"deptno\"", "select count(*) + 1 as c, \"deptno\" from \"emps\" group by \"deptno\"");
    }

    @Test
    public void testAggregateRollUp() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) as c, sum(\"empid\") as s from \"emps\" group by \"empid\", \"deptno\"", "select count(*) + 1 as c, \"deptno\" from \"emps\" group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], C=[$t3], deptno=[$t0])\n  EnumerableAggregate(group=[{1}], agg#0=[$SUM0($2)])\n    EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Ignore(value="work in progress")
    @Test
    public void testAggregateProject() {
        this.checkMaterialize("select \"deptno\", count(*) as c, \"empid\" + 2, sum(\"empid\") as s from \"emps\" group by \"empid\", \"deptno\"", "select count(*) + 1 as c, \"deptno\" from \"emps\" group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("xxx"));
    }

    @Ignore
    @Test
    public void testSwapJoin() {
        String q1 = "select count(*) as c from \"foodmart\".\"sales_fact_1997\" as s join \"foodmart\".\"time_by_day\" as t on s.\"time_id\" = t.\"time_id\"";
        String q2 = "select count(*) as c from \"foodmart\".\"time_by_day\" as t join \"foodmart\".\"sales_fact_1997\" as s on t.\"time_id\" = s.\"time_id\"";
    }

    @Ignore
    @Test
    public void testOrderByQueryOnProjectView() {
        this.checkMaterialize("select \"deptno\", \"empid\" from \"emps\"", "select \"empid\" from \"emps\" order by \"deptno\"");
    }

    @Ignore
    @Test
    public void testOrderByQueryOnOrderByView() {
        this.checkMaterialize("select \"deptno\", \"empid\" from \"emps\" order by \"deptno\"", "select \"empid\" from \"emps\" order by \"deptno\"");
    }

    @Ignore
    @Test
    public void testDifferentColumnNames() {
    }

    @Ignore
    @Test
    public void testDifferentType() {
    }

    @Ignore
    @Test
    public void testPartialUnion() {
    }

    @Ignore
    @Test
    public void testNonDisjointUnion() {
    }

    @Ignore
    @Test
    public void testMaterializationReferencesTableInOtherSchema() {
    }

    @Test
    public void testSatisfiable() {
        this.checkSatisfiable((RexNode)this.rexBuilder.makeLiteral(true), "true");
        this.checkNotSatisfiable((RexNode)this.rexBuilder.makeLiteral(false));
        RexNode i0_eq_0 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createType(Integer.TYPE), 0), this.rexBuilder.makeExactLiteral(BigDecimal.ZERO)});
        this.checkSatisfiable(i0_eq_0, "=($0, 0)");
        RexNode e0 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeLiteral(true)});
        this.checkSatisfiable(e0, "=($0, 0)");
        RexNode e1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeLiteral(false)});
        this.checkNotSatisfiable(e1);
        RexNode e2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})});
        this.checkNotSatisfiable(e2);
        RexNode e3 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder.makeLiteral(true), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})});
        this.checkSatisfiable(e3, "<>($0, 0)");
        RexNode i1_eq_1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createType(Integer.TYPE), 1), this.rexBuilder.makeExactLiteral(BigDecimal.ONE)});
        RexNode e4 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i1_eq_1, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})})});
        this.checkNotSatisfiable(e4);
        RexNode e5 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i1_eq_1})});
        this.checkSatisfiable(e5, "AND(=($0, 0), <>($1, 1))");
        RexNode e6 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, i1_eq_1})})});
        this.checkSatisfiable(e6, "AND(=($0, 0), OR(<>($0, 0), <>($1, 1)))");
        RexNode e7 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i1_eq_1, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i0_eq_0})})});
        this.checkNotSatisfiable(e7);
        RexInputRef i2 = this.rexBuilder.makeInputRef(this.typeFactory.createType(Boolean.TYPE), 2);
        RexInputRef i3 = this.rexBuilder.makeInputRef(this.typeFactory.createType(Boolean.TYPE), 3);
        RexInputRef i4 = this.rexBuilder.makeInputRef(this.typeFactory.createType(Boolean.TYPE), 4);
        RexNode e8 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i0_eq_0, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i2, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i3, this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{i2, i3, i4})}), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{i4})})})});
        this.checkSatisfiable(e8, "AND(=($0, 0), $2, $3, OR(NOT($2), NOT($3), NOT($4)), NOT($4))");
    }

    private void checkNotSatisfiable(RexNode e) {
        Assert.assertFalse((boolean)SubstitutionVisitor.mayBeSatisfiable((RexNode)e));
        RexNode simple = this.simplify.simplifyUnknownAs(e, RexUnknownAs.UNKNOWN);
        Assert.assertFalse((boolean)RexLiteral.booleanValue((RexNode)simple));
    }

    private void checkSatisfiable(RexNode e, String s) {
        Assert.assertTrue((boolean)SubstitutionVisitor.mayBeSatisfiable((RexNode)e));
        RexNode simple = this.simplify.simplifyUnknownAs(e, RexUnknownAs.UNKNOWN);
        Assert.assertEquals((Object)s, (Object)simple.toString());
    }

    @Test
    public void testSplitFilter() {
        RexLiteral i1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral i2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        RexLiteral i3 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L));
        RelDataType intType = this.typeFactory.createType(Integer.TYPE);
        RexInputRef x = this.rexBuilder.makeInputRef(intType, 0);
        RexInputRef y = this.rexBuilder.makeInputRef(intType, 1);
        RexInputRef z = this.rexBuilder.makeInputRef(intType, 2);
        RexNode x_eq_1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{x, i1});
        RexNode x_eq_1_b = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{i1, x});
        RexNode x_eq_2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{x, i2});
        RexNode y_eq_2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{y, i2});
        RexNode z_eq_3 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{z, i3});
        RexNode newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{y_eq_2, x_eq_1_b}));
        Assert.assertThat((Object)newFilter.isAlwaysTrue(), (Matcher)CoreMatchers.equalTo((Object)true));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)x_eq_1, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, z_eq_3}));
        Assert.assertThat((Object)newFilter.toString(), (Matcher)CoreMatchers.equalTo((Object)"=($0, 1)"));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2, z_eq_3}));
        Assert.assertThat((Object)newFilter.toString(), (Matcher)CoreMatchers.equalTo((Object)"OR(=($0, 1), =($1, 2))"));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)x_eq_1, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2, z_eq_3}));
        Assert.assertThat((Object)newFilter.toString(), (Matcher)CoreMatchers.equalTo((Object)"=($0, 1)"));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{y_eq_2, x_eq_1}));
        Assert.assertThat((Object)newFilter.isAlwaysTrue(), (Matcher)CoreMatchers.equalTo((Object)true));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)x_eq_1, (RexNode)x_eq_1_b);
        Assert.assertThat((Object)newFilter.isAlwaysTrue(), (Matcher)CoreMatchers.equalTo((Object)true));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)x_eq_1);
        Assert.assertNull((Object)newFilter);
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{y_eq_2, x_eq_1}));
        Assert.assertThat((Object)newFilter.isAlwaysTrue(), (Matcher)CoreMatchers.equalTo((Object)true));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{x_eq_1, y_eq_2}), (RexNode)y_eq_2);
        Assert.assertThat((Object)newFilter.toString(), (Matcher)CoreMatchers.equalTo((Object)"=($0, 1)"));
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)x_eq_1, (RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{x_eq_1, y_eq_2}));
        Assert.assertNull((Object)newFilter);
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)x_eq_1, (RexNode)y_eq_2);
        Assert.assertNull((Object)newFilter);
        newFilter = SubstitutionVisitor.splitFilter((RexSimplify)this.simplify, (RexNode)x_eq_1, (RexNode)x_eq_2);
        Assert.assertNull((Object)newFilter);
    }

    @Ignore
    @Test
    public void testFilterGroupQueryOnStar() {
        this.checkMaterialize("select p.\"product_name\", t.\"the_year\",\n  sum(f.\"unit_sales\") as \"sum_unit_sales\", count(*) as \"c\"\nfrom \"foodmart\".\"sales_fact_1997\" as f\njoin (\n    select \"time_id\", \"the_year\", \"the_month\"\n    from \"foodmart\".\"time_by_day\") as t\n  on f.\"time_id\" = t.\"time_id\"\njoin \"foodmart\".\"product\" as p\n  on f.\"product_id\" = p.\"product_id\"\njoin \"foodmart\".\"product_class\" as pc  on p.\"product_class_id\" = pc.\"product_class_id\"\ngroup by t.\"the_year\",\n t.\"the_month\",\n pc.\"product_department\",\n pc.\"product_category\",\n p.\"product_name\"", "select t.\"the_month\", count(*) as x\nfrom (\n  select \"time_id\", \"the_year\", \"the_month\"\n  from \"foodmart\".\"time_by_day\") as t,\n \"foodmart\".\"sales_fact_1997\" as f\nwhere t.\"the_year\" = 1997\nand t.\"time_id\" = f.\"time_id\"\ngroup by t.\"the_year\",\n t.\"the_month\"\n", JdbcTest.FOODMART_MODEL, CONTAINS_M0);
    }

    @Ignore
    @Test
    public void testQueryOnStar() {
        String q = "select *\nfrom \"foodmart\".\"sales_fact_1997\" as f\njoin \"foodmart\".\"time_by_day\" as t on f.\"time_id\" = t.\"time_id\"\njoin \"foodmart\".\"product\" as p on f.\"product_id\" = p.\"product_id\"\njoin \"foodmart\".\"product_class\" as pc on p.\"product_class_id\" = pc.\"product_class_id\"\n";
        this.checkMaterialize(q, q + "where t.\"month_of_year\" = 10", JdbcTest.FOODMART_MODEL, CONTAINS_M0);
    }

    @Ignore
    @Test
    public void testJoinOnUnionMaterialization() {
        String q = "select *\nfrom (select * from \"emps\" union all select * from \"emps\")\njoin \"depts\" using (\"deptno\")";
        this.checkNoMaterialize(q, q, HR_FKUK_MODEL);
    }

    @Test
    public void testJoinMaterialization() {
        String q = "select *\nfrom (select * from \"emps\" where \"empid\" < 300)\njoin \"depts\" using (\"deptno\")";
        this.checkMaterialize("select * from \"emps\" where \"empid\" < 500", q);
    }

    @Test
    public void testJoinMaterialization2() {
        String q = "select *\nfrom \"emps\"\njoin \"depts\" using (\"deptno\")";
        String m = "select \"deptno\", \"empid\", \"name\",\n\"salary\", \"commission\" from \"emps\"";
        this.checkMaterialize("select \"deptno\", \"empid\", \"name\",\n\"salary\", \"commission\" from \"emps\"", q);
    }

    @Test
    public void testJoinMaterialization3() {
        String q = "select \"empid\" \"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" = 1";
        String m = "select \"empid\" \"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\")";
        this.checkMaterialize("select \"empid\" \"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\")", q);
    }

    @Test
    public void testUnionAll() {
        String q = "select * from \"emps\" where \"empid\" > 300\nunion all select * from \"emps\" where \"empid\" < 200";
        String m = "select * from \"emps\" where \"empid\" < 500";
        this.checkMaterialize(m, q, HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, m0]])", 1));
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs1() {
        this.checkMaterialize("select \"empid\", \"deptno\" from \"emps\" group by \"empid\", \"deptno\"", "select \"empid\", \"deptno\" from \"emps\" group by \"empid\", \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs2() {
        this.checkMaterialize("select \"empid\", \"deptno\" from \"emps\" group by \"empid\", \"deptno\"", "select \"deptno\" from \"emps\" group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs3() {
        this.checkNoMaterialize("select \"deptno\" from \"emps\" group by \"deptno\"", "select \"empid\", \"deptno\" from \"emps\" group by \"empid\", \"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs4() {
        this.checkMaterialize("select \"empid\", \"deptno\" from \"emps\" where \"deptno\" = 10 group by \"empid\", \"deptno\"", "select \"deptno\" from \"emps\" where \"deptno\" = 10 group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs5() {
        this.checkNoMaterialize("select \"empid\", \"deptno\" from \"emps\" where \"deptno\" = 5 group by \"empid\", \"deptno\"", "select \"deptno\" from \"emps\" where \"deptno\" = 10 group by \"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs6() {
        this.checkMaterialize("select \"empid\", \"deptno\" from \"emps\" where \"deptno\" > 5 group by \"empid\", \"deptno\"", "select \"deptno\" from \"emps\" where \"deptno\" > 10 group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[10], expr#3=[<($t2, $t1)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs7() {
        this.checkNoMaterialize("select \"empid\", \"deptno\" from \"emps\" where \"deptno\" > 5 group by \"empid\", \"deptno\"", "select \"deptno\" from \"emps\" where \"deptno\" < 10 group by \"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs8() {
        this.checkNoMaterialize("select \"empid\" from \"emps\" group by \"empid\", \"deptno\"", "select \"deptno\" from \"emps\" group by \"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testAggregateMaterializationNoAggregateFuncs9() {
        this.checkNoMaterialize("select \"empid\", \"deptno\" from \"emps\"\nwhere \"salary\" > 1000 group by \"name\", \"empid\", \"deptno\"", "select \"empid\" from \"emps\"\nwhere \"salary\" > 2000 group by \"name\", \"empid\"", HR_FKUK_MODEL);
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs1() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", \"deptno\"", "select \"deptno\" from \"emps\" group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs2() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", \"deptno\"", "select \"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}], C=[$SUM0($2)], S=[$SUM0($3)])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs3() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", \"deptno\"", "select \"deptno\", \"empid\", sum(\"empid\") as s, count(*) as c\nfrom \"emps\" group by \"empid\", \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..3=[{inputs}], deptno=[$t1], empid=[$t0], S=[$t3], C=[$t2])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs4() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" where \"deptno\" >= 10 group by \"empid\", \"deptno\"", "select \"deptno\", sum(\"empid\") as s\nfrom \"emps\" where \"deptno\" > 10 group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}], S=[$SUM0($3)])\n  EnumerableCalc(expr#0..3=[{inputs}], expr#4=[10], expr#5=[<($t4, $t1)], proj#0..3=[{exprs}], $condition=[$t5])\n    EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs5() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" where \"deptno\" >= 10 group by \"empid\", \"deptno\"", "select \"deptno\", sum(\"empid\") + 1 as s\nfrom \"emps\" where \"deptno\" > 10 group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], deptno=[$t0], $f1=[$t3])\n  EnumerableAggregate(group=[{1}], agg#0=[$SUM0($3)])\n    EnumerableCalc(expr#0..3=[{inputs}], expr#4=[10], expr#5=[<($t4, $t1)], proj#0..3=[{exprs}], $condition=[$t5])\n      EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs6() {
        this.checkNoMaterialize("select \"empid\", \"deptno\", count(*) + 1 as c, sum(\"empid\") + 2 as s\nfrom \"emps\" where \"deptno\" >= 10 group by \"empid\", \"deptno\"", "select \"deptno\", sum(\"empid\") + 1 as s\nfrom \"emps\" where \"deptno\" > 10 group by \"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs7() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" where \"deptno\" >= 10 group by \"empid\", \"deptno\"", "select \"deptno\" + 1, sum(\"empid\") + 1 as s\nfrom \"emps\" where \"deptno\" > 10 group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t0, $t2)], expr#4=[+($t1, $t2)], $f0=[$t3], $f1=[$t4])\n  EnumerableAggregate(group=[{1}], agg#0=[$SUM0($3)])\n    EnumerableCalc(expr#0..3=[{inputs}], expr#4=[10], expr#5=[<($t4, $t1)], proj#0..3=[{exprs}], $condition=[$t5])\n      EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Ignore
    @Test
    public void testAggregateMaterializationAggregateFuncs8() {
        this.checkMaterialize("select \"empid\", \"deptno\" + 1, count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" where \"deptno\" >= 10 group by \"empid\", \"deptno\"", "select \"deptno\" + 1, sum(\"empid\") + 1 as s\nfrom \"emps\" where \"deptno\" > 10 group by \"deptno\"");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs9() {
        this.checkMaterialize("select \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to month), count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to month)", "select floor(cast('1997-01-20 12:34:56' as timestamp) to year), sum(\"empid\") as s\nfrom \"emps\" group by floor(cast('1997-01-20 12:34:56' as timestamp) to year)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs10() {
        this.checkMaterialize("select \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to month), count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to month)", "select floor(cast('1997-01-20 12:34:56' as timestamp) to year), sum(\"empid\") + 1 as s\nfrom \"emps\" group by floor(cast('1997-01-20 12:34:56' as timestamp) to year)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs11() {
        this.checkMaterialize("select \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to second), count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to second)", "select floor(cast('1997-01-20 12:34:56' as timestamp) to minute), sum(\"empid\") as s\nfrom \"emps\" group by floor(cast('1997-01-20 12:34:56' as timestamp) to minute)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs12() {
        this.checkMaterialize("select \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to second), count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to second)", "select floor(cast('1997-01-20 12:34:56' as timestamp) to month), sum(\"empid\") as s\nfrom \"emps\" group by floor(cast('1997-01-20 12:34:56' as timestamp) to month)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs13() {
        this.checkMaterialize("select \"empid\", cast('1997-01-20 12:34:56' as timestamp), count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", cast('1997-01-20 12:34:56' as timestamp)", "select floor(cast('1997-01-20 12:34:56' as timestamp) to year), sum(\"empid\") as s\nfrom \"emps\" group by floor(cast('1997-01-20 12:34:56' as timestamp) to year)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs14() {
        this.checkMaterialize("select \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to month), count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", floor(cast('1997-01-20 12:34:56' as timestamp) to month)", "select floor(cast('1997-01-20 12:34:56' as timestamp) to hour), sum(\"empid\") as s\nfrom \"emps\" group by floor(cast('1997-01-20 12:34:56' as timestamp) to hour)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs15() {
        this.checkMaterialize("select \"eventid\", floor(cast(\"ts\" as timestamp) to second), count(*) + 1 as c, sum(\"eventid\") as s\nfrom \"events\" group by \"eventid\", floor(cast(\"ts\" as timestamp) to second)", "select floor(cast(\"ts\" as timestamp) to minute), sum(\"eventid\") as s\nfrom \"events\" group by floor(cast(\"ts\" as timestamp) to minute)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs16() {
        this.checkMaterialize("select \"eventid\", cast(\"ts\" as timestamp), count(*) + 1 as c, sum(\"eventid\") as s\nfrom \"events\" group by \"eventid\", cast(\"ts\" as timestamp)", "select floor(cast(\"ts\" as timestamp) to year), sum(\"eventid\") as s\nfrom \"events\" group by floor(cast(\"ts\" as timestamp) to year)");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs17() {
        this.checkMaterialize("select \"eventid\", floor(cast(\"ts\" as timestamp) to month), count(*) + 1 as c, sum(\"eventid\") as s\nfrom \"events\" group by \"eventid\", floor(cast(\"ts\" as timestamp) to month)", "select floor(cast(\"ts\" as timestamp) to hour), sum(\"eventid\") as s\nfrom \"events\" group by floor(cast(\"ts\" as timestamp) to hour)", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, events]])"));
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs18() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", \"deptno\"", "select \"empid\"*\"deptno\", sum(\"empid\") as s\nfrom \"emps\" group by \"empid\"*\"deptno\"");
    }

    @Test
    public void testAggregateMaterializationAggregateFuncs19() {
        this.checkMaterialize("select \"empid\", \"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" group by \"empid\", \"deptno\"", "select \"empid\" + 10, count(*) + 1 as c\nfrom \"emps\" group by \"empid\" + 10");
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs1() {
        this.checkMaterialize("select \"empid\", \"depts\".\"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"depts\".\"deptno\" > 10\ngroup by \"empid\", \"depts\".\"deptno\"", "select \"empid\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"depts\".\"deptno\" > 20\ngroup by \"empid\", \"depts\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[20], expr#3=[<($t2, $t1)], empid=[$t0], $condition=[$t3])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs2() {
        this.checkMaterialize("select \"depts\".\"deptno\", \"empid\" from \"depts\"\njoin \"emps\" using (\"deptno\") where \"depts\".\"deptno\" > 10\ngroup by \"empid\", \"depts\".\"deptno\"", "select \"empid\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"depts\".\"deptno\" > 20\ngroup by \"empid\", \"depts\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[20], expr#3=[<($t2, $t0)], empid=[$t1], $condition=[$t3])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs3() {
        this.checkNoMaterialize("select \"empid\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"depts\".\"deptno\" > 10\ngroup by \"empid\", \"depts\".\"deptno\"", "select \"empid\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"depts\".\"deptno\" > 20\ngroup by \"empid\", \"depts\".\"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs4() {
        this.checkMaterialize("select \"empid\", \"depts\".\"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"emps\".\"deptno\" > 10\ngroup by \"empid\", \"depts\".\"deptno\"", "select \"empid\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"depts\".\"deptno\" > 20\ngroup by \"empid\", \"depts\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[20], expr#3=[<($t2, $t1)], empid=[$t0], $condition=[$t3])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs5() {
        this.checkMaterialize("select \"depts\".\"deptno\", \"emps\".\"empid\" from \"depts\"\njoin \"emps\" using (\"deptno\") where \"emps\".\"empid\" > 10\ngroup by \"depts\".\"deptno\", \"emps\".\"empid\"", "select \"depts\".\"deptno\" from \"depts\"\njoin \"emps\" using (\"deptno\") where \"emps\".\"empid\" > 15\ngroup by \"depts\".\"deptno\", \"emps\".\"empid\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[15], expr#3=[<($t2, $t1)], deptno=[$t0], $condition=[$t3])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs6() {
        this.checkMaterialize("select \"depts\".\"deptno\", \"emps\".\"empid\" from \"depts\"\njoin \"emps\" using (\"deptno\") where \"emps\".\"empid\" > 10\ngroup by \"depts\".\"deptno\", \"emps\".\"empid\"", "select \"depts\".\"deptno\" from \"depts\"\njoin \"emps\" using (\"deptno\") where \"emps\".\"empid\" > 15\ngroup by \"depts\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}])\n  EnumerableCalc(expr#0..1=[{inputs}], expr#2=[15], expr#3=[<($t2, $t1)], proj#0..1=[{exprs}], $condition=[$t3])\n    EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs7() {
        this.checkMaterialize("select \"depts\".\"deptno\", \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 11\ngroup by \"depts\".\"deptno\", \"dependents\".\"empid\"", "select \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 10\ngroup by \"dependents\".\"empid\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}])", "EnumerableUnion(all=[true])", "EnumerableAggregate(group=[{2}])", "EnumerableTableScan(table=[[hr, m0]])", "expr#5=[10], expr#6=[>($t0, $t5)], expr#7=[11], expr#8=[>=($t7, $t0)]"));
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs8() {
        this.checkNoMaterialize("select \"depts\".\"deptno\", \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 20\ngroup by \"depts\".\"deptno\", \"dependents\".\"empid\"", "select \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 10 and \"depts\".\"deptno\" < 20\ngroup by \"dependents\".\"empid\"", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs9() {
        this.checkMaterialize("select \"depts\".\"deptno\", \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 11 and \"depts\".\"deptno\" < 19\ngroup by \"depts\".\"deptno\", \"dependents\".\"empid\"", "select \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 10 and \"depts\".\"deptno\" < 20\ngroup by \"dependents\".\"empid\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}])", "EnumerableUnion(all=[true])", "EnumerableAggregate(group=[{2}])", "EnumerableTableScan(table=[[hr, m0]])", "expr#13=[OR($t10, $t12)], expr#14=[AND($t6, $t8, $t13)]"));
    }

    @Test
    public void testJoinAggregateMaterializationNoAggregateFuncs10() {
        this.checkMaterialize("select \"depts\".\"name\", \"dependents\".\"name\" as \"name2\", \"emps\".\"deptno\", \"depts\".\"deptno\" as \"deptno2\", \"dependents\".\"empid\"\nfrom \"depts\", \"dependents\", \"emps\"\nwhere \"depts\".\"deptno\" > 10\ngroup by \"depts\".\"name\", \"dependents\".\"name\", \"emps\".\"deptno\", \"depts\".\"deptno\", \"dependents\".\"empid\"", "select \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 10\ngroup by \"dependents\".\"empid\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{4}])\n  EnumerableCalc(expr#0..4=[{inputs}], expr#5=[=($t2, $t3)], expr#6=[CAST($t1):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], expr#7=[CAST($t0):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], expr#8=[=($t6, $t7)], expr#9=[AND($t5, $t8)], proj#0..4=[{exprs}], $condition=[$t9])\n    EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs1() {
        this.checkMaterialize("select \"empid\", \"depts\".\"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\ngroup by \"empid\", \"depts\".\"deptno\"", "select \"deptno\" from \"emps\" group by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs2() {
        this.checkMaterialize("select \"empid\", \"emps\".\"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\ngroup by \"empid\", \"emps\".\"deptno\"", "select \"depts\".\"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\ngroup by \"depts\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}], C=[$SUM0($2)], S=[$SUM0($3)])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs3() {
        this.checkMaterialize("select \"empid\", \"depts\".\"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\ngroup by \"empid\", \"depts\".\"deptno\"", "select \"deptno\", \"empid\", sum(\"empid\") as s, count(*) as c\nfrom \"emps\" group by \"empid\", \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..3=[{inputs}], deptno=[$t1], empid=[$t0], S=[$t3], C=[$t2])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs4() {
        this.checkMaterialize("select \"empid\", \"emps\".\"deptno\", count(*) as c, sum(\"empid\") as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\nwhere \"emps\".\"deptno\" >= 10 group by \"empid\", \"emps\".\"deptno\"", "select \"depts\".\"deptno\", sum(\"empid\") as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\nwhere \"emps\".\"deptno\" > 10 group by \"depts\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{1}], S=[$SUM0($3)])\n  EnumerableCalc(expr#0..3=[{inputs}], expr#4=[10], expr#5=[<($t4, $t1)], proj#0..3=[{exprs}], $condition=[$t5])\n    EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs5() {
        this.checkMaterialize("select \"empid\", \"depts\".\"deptno\", count(*) + 1 as c, sum(\"empid\") as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\nwhere \"depts\".\"deptno\" >= 10 group by \"empid\", \"depts\".\"deptno\"", "select \"depts\".\"deptno\", sum(\"empid\") + 1 as s\nfrom \"emps\" join \"depts\" using (\"deptno\")\nwhere \"depts\".\"deptno\" > 10 group by \"depts\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], deptno=[$t0], S=[$t3])\n  EnumerableAggregate(group=[{1}], agg#0=[$SUM0($3)])\n    EnumerableCalc(expr#0..3=[{inputs}], expr#4=[10], expr#5=[<($t4, $t1)], proj#0..3=[{exprs}], $condition=[$t5])\n      EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Ignore
    @Test
    public void testJoinAggregateMaterializationAggregateFuncs6() {
        String m = "select \"depts\".\"name\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\ngroup by \"depts\".\"name\"";
        String q = "select \"dependents\".\"empid\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\ngroup by \"dependents\".\"empid\"";
        this.checkMaterialize("select \"depts\".\"name\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\ngroup by \"depts\".\"name\"", "select \"dependents\".\"empid\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\ngroup by \"dependents\".\"empid\"");
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs7() {
        this.checkMaterialize("select \"dependents\".\"empid\", \"emps\".\"deptno\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\", \"emps\".\"deptno\"", "select \"dependents\".\"empid\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}], S=[$SUM0($2)])\n  EnumerableJoin(condition=[=($1, $3)], joinType=[inner])\n    EnumerableTableScan(table=[[hr, m0]])\n    EnumerableTableScan(table=[[hr, depts]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs8() {
        this.checkMaterialize("select \"dependents\".\"empid\", \"emps\".\"deptno\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\", \"emps\".\"deptno\"", "select \"depts\".\"name\", sum(\"salary\") as s\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"depts\".\"name\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{4}], S=[$SUM0($2)])\n  EnumerableJoin(condition=[=($1, $3)], joinType=[inner])\n    EnumerableTableScan(table=[[hr, m0]])\n    EnumerableTableScan(table=[[hr, depts]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs9() {
        this.checkMaterialize("select \"dependents\".\"empid\", \"emps\".\"deptno\", count(distinct \"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\", \"emps\".\"deptno\"", "select \"emps\".\"deptno\", count(distinct \"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\", \"emps\".\"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..2=[{inputs}], deptno=[$t1], S=[$t2])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs10() {
        this.checkNoMaterialize("select \"dependents\".\"empid\", \"emps\".\"deptno\", count(distinct \"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\", \"emps\".\"deptno\"", "select \"emps\".\"deptno\", count(distinct \"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"emps\".\"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs11() {
        this.checkMaterialize("select \"depts\".\"deptno\", \"dependents\".\"empid\", count(\"emps\".\"salary\") as s\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 11 and \"depts\".\"deptno\" < 19\ngroup by \"depts\".\"deptno\", \"dependents\".\"empid\"", "select \"dependents\".\"empid\", count(\"emps\".\"salary\") + 1\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 10 and \"depts\".\"deptno\" < 20\ngroup by \"dependents\".\"empid\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("PLAN=EnumerableCalc(expr#0..1=[{inputs}], expr#2=[1], expr#3=[+($t1, $t2)], empid=[$t0], EXPR$1=[$t3])\n  EnumerableAggregate(group=[{0}], agg#0=[$SUM0($1)])", "EnumerableUnion(all=[true])", "EnumerableAggregate(group=[{2}], agg#0=[COUNT()])", "EnumerableAggregate(group=[{1}], agg#0=[$SUM0($2)])", "EnumerableTableScan(table=[[hr, m0]])", "expr#13=[OR($t10, $t12)], expr#14=[AND($t6, $t8, $t13)]"));
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs12() {
        this.checkNoMaterialize("select \"depts\".\"deptno\", \"dependents\".\"empid\", count(distinct \"emps\".\"salary\") as s\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 11 and \"depts\".\"deptno\" < 19\ngroup by \"depts\".\"deptno\", \"dependents\".\"empid\"", "select \"dependents\".\"empid\", count(distinct \"emps\".\"salary\") + 1\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 10 and \"depts\".\"deptno\" < 20\ngroup by \"dependents\".\"empid\"", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinAggregateMaterializationAggregateFuncs13() {
        this.checkNoMaterialize("select \"dependents\".\"empid\", \"emps\".\"deptno\", count(distinct \"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\", \"emps\".\"deptno\"", "select \"emps\".\"deptno\", count(\"salary\") as s\nfrom \"emps\"\njoin \"dependents\" on (\"emps\".\"empid\" = \"dependents\".\"empid\")\ngroup by \"dependents\".\"empid\", \"emps\".\"deptno\"", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinMaterialization4() {
        this.checkMaterialize("select \"empid\" \"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\")", "select \"empid\" \"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" = 1", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0=[{inputs}], expr#1=[CAST($t0):INTEGER NOT NULL], expr#2=[1], expr#3=[=($t1, $t2)], deptno=[$t0], $condition=[$t3])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterialization5() {
        this.checkMaterialize("select cast(\"empid\" as BIGINT) from \"emps\"\njoin \"depts\" using (\"deptno\")", "select \"empid\" \"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" > 1", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0=[{inputs}], expr#1=[CAST($t0):JavaType(int) NOT NULL], expr#2=[1], expr#3=[>($t1, $t2)], EXPR$0=[$t1], $condition=[$t3])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterialization6() {
        this.checkMaterialize("select cast(\"empid\" as BIGINT) from \"emps\"\njoin \"depts\" using (\"deptno\")", "select \"empid\" \"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" = 1", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0=[{inputs}], expr#1=[CAST($t0):JavaType(int) NOT NULL], expr#2=[CAST($t1):INTEGER NOT NULL], expr#3=[1], expr#4=[=($t2, $t3)], EXPR$0=[$t1], $condition=[$t4])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterialization7() {
        this.checkMaterialize("select \"depts\".\"name\"\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")", "select \"dependents\".\"empid\"\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..2=[{inputs}], empid=[$t1])\n  EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n    EnumerableCalc(expr#0=[{inputs}], expr#1=[CAST($t0):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], name=[$t1])\n      EnumerableTableScan(table=[[hr, m0]])\n    EnumerableCalc(expr#0..1=[{inputs}], expr#2=[CAST($t1):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], empid=[$t0], name0=[$t2])\n      EnumerableTableScan(table=[[hr, dependents]])"));
    }

    @Test
    public void testJoinMaterialization8() {
        this.checkMaterialize("select \"depts\".\"name\"\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")", "select \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..4=[{inputs}], empid=[$t2])\n  EnumerableJoin(condition=[=($1, $4)], joinType=[inner])\n    EnumerableCalc(expr#0=[{inputs}], expr#1=[CAST($t0):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], proj#0..1=[{exprs}])\n      EnumerableTableScan(table=[[hr, m0]])\n    EnumerableCalc(expr#0..1=[{inputs}], expr#2=[CAST($t1):VARCHAR CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"], proj#0..2=[{exprs}])\n      EnumerableTableScan(table=[[hr, dependents]])"));
    }

    @Test
    public void testJoinMaterialization9() {
        this.checkMaterialize("select \"depts\".\"name\"\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")", "select \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"locations\" on (\"locations\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")", HR_FKUK_MODEL, CONTAINS_M0);
    }

    @Test
    public void testJoinMaterialization10() {
        this.checkMaterialize("select \"depts\".\"deptno\", \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 30", "select \"dependents\".\"empid\"\nfrom \"depts\"\njoin \"dependents\" on (\"depts\".\"name\" = \"dependents\".\"name\")\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")\nwhere \"depts\".\"deptno\" > 10", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableUnion(all=[true])", "EnumerableTableScan(table=[[hr, m0]])", "expr#5=[10], expr#6=[>($t0, $t5)], expr#7=[30], expr#8=[>=($t7, $t0)]"));
    }

    @Test
    public void testJoinMaterialization11() {
        this.checkNoMaterialize("select \"empid\" from \"emps\"\njoin \"depts\" using (\"deptno\")", "select \"empid\" from \"emps\"\nwhere \"deptno\" in (select \"deptno\" from \"depts\")", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinMaterializationUKFK1() {
        this.checkMaterialize("select \"a\".\"empid\" \"deptno\" from\n(select * from \"emps\" where \"empid\" = 1) \"a\"\njoin \"depts\" using (\"deptno\")\njoin \"dependents\" using (\"empid\")", "select \"a\".\"empid\" from \n(select * from \"emps\" where \"empid\" = 1) \"a\"\njoin \"dependents\" using (\"empid\")\n", HR_FKUK_MODEL, CalciteAssert.checkResultContains("PLAN=EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterializationUKFK2() {
        this.checkMaterialize("select \"a\".\"empid\", \"a\".\"deptno\" from\n(select * from \"emps\" where \"empid\" = 1) \"a\"\njoin \"depts\" using (\"deptno\")\njoin \"dependents\" using (\"empid\")", "select \"a\".\"empid\" from \n(select * from \"emps\" where \"empid\" = 1) \"a\"\njoin \"dependents\" using (\"empid\")\n", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], empid=[$t0])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterializationUKFK3() {
        this.checkNoMaterialize("select \"a\".\"empid\", \"a\".\"deptno\" from\n(select * from \"emps\" where \"empid\" = 1) \"a\"\njoin \"depts\" using (\"deptno\")\njoin \"dependents\" using (\"empid\")", "select \"a\".\"name\" from \n(select * from \"emps\" where \"empid\" = 1) \"a\"\njoin \"dependents\" using (\"empid\")\n", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinMaterializationUKFK4() {
        this.checkMaterialize("select \"empid\" \"deptno\" from\n(select * from \"emps\" where \"empid\" = 1)\njoin \"depts\" using (\"deptno\")", "select \"empid\" from \"emps\" where \"empid\" = 1\n", HR_FKUK_MODEL, CalciteAssert.checkResultContains("PLAN=EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterializationUKFK5() {
        this.checkMaterialize("select \"emps\".\"empid\", \"emps\".\"deptno\" from \"emps\"\njoin \"depts\" using (\"deptno\")\njoin \"dependents\" using (\"empid\")where \"emps\".\"empid\" = 1", "select \"emps\".\"empid\" from \"emps\"\njoin \"dependents\" using (\"empid\")\nwhere \"emps\".\"empid\" = 1", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], empid0=[$t0])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterializationUKFK6() {
        this.checkMaterialize("select \"emps\".\"empid\", \"emps\".\"deptno\" from \"emps\"\njoin \"depts\" \"a\" on (\"emps\".\"deptno\"=\"a\".\"deptno\")\njoin \"depts\" \"b\" on (\"emps\".\"deptno\"=\"b\".\"deptno\")\njoin \"dependents\" using (\"empid\")where \"emps\".\"empid\" = 1", "select \"emps\".\"empid\" from \"emps\"\njoin \"dependents\" using (\"empid\")\nwhere \"emps\".\"empid\" = 1", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableCalc(expr#0..1=[{inputs}], empid0=[$t0])\n  EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testJoinMaterializationUKFK7() {
        this.checkNoMaterialize("select \"emps\".\"empid\", \"emps\".\"deptno\" from \"emps\"\njoin \"depts\" \"a\" on (\"emps\".\"name\"=\"a\".\"name\")\njoin \"depts\" \"b\" on (\"emps\".\"name\"=\"b\".\"name\")\njoin \"dependents\" using (\"empid\")where \"emps\".\"empid\" = 1", "select \"emps\".\"empid\" from \"emps\"\njoin \"dependents\" using (\"empid\")\nwhere \"emps\".\"empid\" = 1", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinMaterializationUKFK8() {
        this.checkNoMaterialize("select \"emps\".\"empid\", \"emps\".\"deptno\" from \"emps\"\njoin \"depts\" \"a\" on (\"emps\".\"deptno\"=\"a\".\"deptno\")\njoin \"depts\" \"b\" on (\"emps\".\"name\"=\"b\".\"name\")\njoin \"dependents\" using (\"empid\")where \"emps\".\"empid\" = 1", "select \"emps\".\"empid\" from \"emps\"\njoin \"dependents\" using (\"empid\")\nwhere \"emps\".\"empid\" = 1", HR_FKUK_MODEL);
    }

    @Test
    public void testJoinMaterializationUKFK9() {
        this.checkMaterialize("select * from \"emps\"\njoin \"dependents\" using (\"empid\")", "select \"emps\".\"empid\", \"dependents\".\"empid\", \"emps\".\"deptno\"\nfrom \"emps\"\njoin \"dependents\" using (\"empid\")join \"depts\" \"a\" on (\"emps\".\"deptno\"=\"a\".\"deptno\")\nwhere \"emps\".\"name\" = 'Bill'", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, m0]])"));
    }

    @Test
    public void testViewMaterialization() {
        this.checkThatMaterialize("select \"depts\".\"name\"\nfrom \"emps\"\njoin \"depts\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")", "select \"depts\".\"name\"\nfrom \"depts\"\njoin \"emps\" on (\"emps\".\"deptno\" = \"depts\".\"deptno\")", "matview", true, HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableValues(tuples=[[{ 'noname' }]])"), RuleSets.ofList((Iterable)ImmutableList.of())).returnsValue("noname");
    }

    @Test
    public void testSubQuery() {
        String q = "select \"empid\", \"deptno\", \"salary\" from \"emps\" e1\nwhere \"empid\" = (\n  select max(\"empid\") from \"emps\"\n  where \"deptno\" = e1.\"deptno\")";
        String m = "select \"empid\", \"deptno\" from \"emps\"\n";
        this.checkMaterialize("select \"empid\", \"deptno\" from \"emps\"\n", q, HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, m0]])", 1));
    }

    @Test
    public void testTableModify() {
        String m = "select \"deptno\", \"empid\", \"name\"from \"emps\" where \"deptno\" = 10";
        String q = "upsert into \"dependents\"select \"empid\" + 1 as x, \"name\"from \"emps\" where \"deptno\" = 10";
        ArrayList substitutedNames = new ArrayList();
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select \"deptno\", \"empid\", \"name\"from \"emps\" where \"deptno\" = 10").query("upsert into \"dependents\"select \"empid\" + 1 as x, \"name\"from \"emps\" where \"deptno\" = 10").withHook(Hook.SUB, r -> substitutedNames.add(new TableNameVisitor().run((RelNode)r))).enableMaterializations(true).explainContains("hr, m0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertThat(substitutedNames, (Matcher)CoreMatchers.is(MaterializationTest.list3(new String[][][]{{{"hr", "m0"}}})));
    }

    @Test
    public void testPrePopulated() {
        String q = "select \"deptno\" from \"emps\"";
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, builder -> {
                Map map = builder.map();
                map.put("table", "locations");
                String sql = "select `deptno` as `empid`, '' as `name`\nfrom `emps`";
                String sql2 = sql.replaceAll("`", "\"");
                map.put("sql", sql2);
                return ImmutableList.of((Object)map);
            }).query(q).enableMaterializations(true).explainMatches("", CONTAINS_LOCATIONS).sameResultWithMaterializationsDisabled();
        }
    }

    @Test
    public void testViewSchemaPath() {
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            String m = "select empno, deptno from emp";
            String q = "select deptno from scott.emp";
            ImmutableList path = ImmutableList.of((Object)"SCOTT");
            JsonBuilder builder = new JsonBuilder();
            String model = "{\n  version: '1.0',\n  defaultSchema: 'hr',\n  schemas: [\n" + JdbcTest.SCOTT_SCHEMA + "  ,\n    {\n      materializations: [\n        {\n          table: 'm0',\n          view: 'm0v',\n          sql: " + builder.toJsonString((Object)"select empno, deptno from emp") + ",\n          viewSchemaPath: " + builder.toJsonString((Object)path) + "        }\n      ],\n      type: 'custom',\n      name: 'hr',\n      factory: 'org.apache.calcite.adapter.java.ReflectiveSchema$Factory',\n      operand: {\n        class: 'org.apache.calcite.test.JdbcTest$HrSchema'\n      }\n    }\n  ]\n}\n";
            CalciteAssert.that().withModel(model).query("select deptno from scott.emp").enableMaterializations(true).explainMatches("", CONTAINS_M0).sameResultWithMaterializationsDisabled();
        }
    }

    @Test
    public void testSingleMaterializationMultiUsage() {
        String q = "select *\nfrom (select * from \"emps\" where \"empid\" < 300)\njoin (select * from \"emps\" where \"empid\" < 200) using (\"empid\")";
        String m = "select * from \"emps\" where \"empid\" < 500";
        this.checkMaterialize(m, q, HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableTableScan(table=[[hr, m0]])", 2));
    }

    @Test
    public void testMultiMaterializationMultiUsage() {
        String q = "select *\nfrom (select * from \"emps\" where \"empid\" < 300)\njoin (select \"deptno\", count(*) as c from \"emps\" group by \"deptno\") using (\"deptno\")";
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select \"deptno\", count(*) as c, sum(\"empid\") as s from \"emps\" group by \"deptno\"", "m1", "select * from \"emps\" where \"empid\" < 500").query(q).enableMaterializations(true).explainContains("EnumerableTableScan(table=[[hr, m0]])").explainContains("EnumerableTableScan(table=[[hr, m1]])").sameResultWithMaterializationsDisabled();
        }
    }

    @Test
    public void testMaterializationOnJoinQuery() {
        String q = "select *\nfrom \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" < 300 ";
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select * from \"emps\" where \"empid\" < 500").query("select *\nfrom \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" < 300 ").enableMaterializations(true).explainContains("EnumerableTableScan(table=[[hr, m0]])").sameResultWithMaterializationsDisabled();
        }
    }

    @Ignore(value="Creating mv for depts considering all its column throws exception")
    @Test
    public void testMultiMaterializationOnJoinQuery() {
        String q = "select *\nfrom \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" < 300 and \"depts\".\"deptno\" > 200";
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select * from \"emps\" where \"empid\" < 500", "m1", "select * from \"depts\" where \"deptno\" > 100").query("select *\nfrom \"emps\"\njoin \"depts\" using (\"deptno\") where \"empid\" < 300 and \"depts\".\"deptno\" > 200").enableMaterializations(true).explainContains("EnumerableTableScan(table=[[hr, m0]])").explainContains("EnumerableTableScan(table=[[hr, m1]])").sameResultWithMaterializationsDisabled();
        }
    }

    @Test
    public void testAggregateMaterializationOnCountDistinctQuery1() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"salary\"\nfrom \"emps\"\ngroup by \"deptno\", \"empid\", \"salary\"", "select \"deptno\", count(distinct \"empid\") as c from (\nselect \"deptno\", \"empid\"\nfrom \"emps\"\ngroup by \"deptno\", \"empid\")\ngroup by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}], C=[COUNT($1)])\n  EnumerableTableScan(table=[[hr, m0]]"));
    }

    @Test
    public void testAggregateMaterializationOnCountDistinctQuery2() {
        this.checkMaterialize("select \"deptno\", \"salary\", \"empid\"\nfrom \"emps\"\ngroup by \"deptno\", \"salary\", \"empid\"", "select \"deptno\", count(distinct \"empid\") as c from (\nselect \"deptno\", \"empid\"\nfrom \"emps\"\ngroup by \"deptno\", \"empid\")\ngroup by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}], C=[COUNT($2)])\n  EnumerableTableScan(table=[[hr, m0]]"));
    }

    @Test
    public void testAggregateMaterializationOnCountDistinctQuery3() {
        this.checkMaterialize("select \"deptno\", \"empid\", \"salary\"\nfrom \"emps\"\ngroup by \"deptno\", \"empid\", \"salary\"", "select \"deptno\", count(distinct \"salary\") from (\nselect \"deptno\", \"salary\"\nfrom \"emps\"\ngroup by \"deptno\", \"salary\")\ngroup by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}], EXPR$1=[COUNT($1)])\n  EnumerableAggregate(group=[{0, 2}])\n    EnumerableTableScan(table=[[hr, m0]]"));
    }

    @Test
    public void testAggregateMaterializationOnCountDistinctQuery4() {
        this.checkMaterialize("select \"deptno\", \"salary\", \"empid\"\nfrom \"emps\"\ngroup by \"deptno\", \"salary\", \"empid\"", "select \"deptno\", count(\"salary\") from (\nselect \"deptno\", \"salary\"\nfrom \"emps\"\ngroup by \"deptno\", \"salary\")\ngroup by \"deptno\"", HR_FKUK_MODEL, CalciteAssert.checkResultContains("EnumerableAggregate(group=[{0}], EXPR$1=[COUNT()])\n  EnumerableAggregate(group=[{0, 1}])\n    EnumerableTableScan(table=[[hr, m0]]"));
    }

    @Test
    public void testMaterializationSubstitution() {
        String q = "select *\nfrom (select * from \"emps\" where \"empid\" < 300)\njoin (select * from \"emps\" where \"empid\" < 200) using (\"empid\")";
        String[][][] expectedNames = new String[][][]{{{"hr", "emps"}, {"hr", "m0"}}, {{"hr", "emps"}, {"hr", "m1"}}, {{"hr", "m0"}, {"hr", "emps"}}, {{"hr", "m0"}, {"hr", "m0"}}, {{"hr", "m0"}, {"hr", "m1"}}, {{"hr", "m1"}, {"hr", "emps"}}, {{"hr", "m1"}, {"hr", "m0"}}, {{"hr", "m1"}, {"hr", "m1"}}};
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            ArrayList<Iterable<List<String>>> substitutedNames = new ArrayList<Iterable<List<String>>>();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select * from \"emps\" where \"empid\" < 300", "m1", "select * from \"emps\" where \"empid\" < 600").query(q).withHook(Hook.SUB, r -> substitutedNames.add(new TableNameVisitor().run((RelNode)r))).enableMaterializations(true).sameResultWithMaterializationsDisabled();
            substitutedNames.sort((Comparator<Iterable<List<String>>>)CASE_INSENSITIVE_LIST_LIST_COMPARATOR);
            Assert.assertThat(substitutedNames, (Matcher)CoreMatchers.is(MaterializationTest.list3(expectedNames)));
        }
    }

    @Test
    public void testMaterializationSubstitution2() {
        String q = "select *\nfrom (select * from \"emps\" where \"empid\" < 300)\njoin (select * from \"emps\" where \"empid\" < 200) using (\"empid\")";
        String[][][] expectedNames = new String[][][]{{{"hr", "emps"}, {"hr", "m0"}}, {{"hr", "emps"}, {"hr", "m1"}}, {{"hr", "emps"}, {"hr", "m2"}}, {{"hr", "m0"}, {"hr", "emps"}}, {{"hr", "m0"}, {"hr", "m0"}}, {{"hr", "m0"}, {"hr", "m1"}}, {{"hr", "m0"}, {"hr", "m2"}}, {{"hr", "m1"}, {"hr", "emps"}}, {{"hr", "m1"}, {"hr", "m0"}}, {{"hr", "m1"}, {"hr", "m1"}}, {{"hr", "m1"}, {"hr", "m2"}}, {{"hr", "m2"}, {"hr", "emps"}}, {{"hr", "m2"}, {"hr", "m0"}}, {{"hr", "m2"}, {"hr", "m1"}}, {{"hr", "m2"}, {"hr", "m2"}}};
        try (TryThreadLocal.Memo ignored = Prepare.THREAD_TRIM.push((Object)true);){
            MaterializationService.setThreadLocal();
            ArrayList<Iterable<List<String>>> substitutedNames = new ArrayList<Iterable<List<String>>>();
            CalciteAssert.that().withMaterializations(HR_FKUK_MODEL, "m0", "select * from \"emps\" where \"empid\" < 300", "m1", "select * from \"emps\" where \"empid\" < 600", "m2", "select * from \"m1\"").query(q).withHook(Hook.SUB, r -> substitutedNames.add(new TableNameVisitor().run((RelNode)r))).enableMaterializations(true).sameResultWithMaterializationsDisabled();
            substitutedNames.sort((Comparator<Iterable<List<String>>>)CASE_INSENSITIVE_LIST_LIST_COMPARATOR);
            Assert.assertThat(substitutedNames, (Matcher)CoreMatchers.is(MaterializationTest.list3(expectedNames)));
        }
    }

    private static <E> List<List<List<E>>> list3(E[][][] as) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (E[][] a : as) {
            builder.add(MaterializationTest.list2(a));
        }
        return builder.build();
    }

    private static <E> List<List<E>> list2(E[][] as) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object[] objectArray : as) {
            builder.add((Object)ImmutableList.copyOf((Object[])objectArray));
        }
        return builder.build();
    }

    public static class HrFKUKSchema {
        public final JdbcTest.Employee[] emps = new JdbcTest.Employee[]{new JdbcTest.Employee(100, 10, "Bill", 10000.0f, 1000), new JdbcTest.Employee(200, 20, "Eric", 8000.0f, 500), new JdbcTest.Employee(150, 10, "Sebastian", 7000.0f, null), new JdbcTest.Employee(110, 10, "Theodore", 10000.0f, 250)};
        public final JdbcTest.Department[] depts = new JdbcTest.Department[]{new JdbcTest.Department(10, "Sales", Arrays.asList(this.emps[0], this.emps[2], this.emps[3]), new JdbcTest.Location(-122, 38)), new JdbcTest.Department(30, "Marketing", (List<JdbcTest.Employee>)ImmutableList.of(), new JdbcTest.Location(0, 52)), new JdbcTest.Department(20, "HR", Collections.singletonList(this.emps[1]), null)};
        public final JdbcTest.Dependent[] dependents = new JdbcTest.Dependent[]{new JdbcTest.Dependent(10, "Michael"), new JdbcTest.Dependent(10, "Jane")};
        public final JdbcTest.Dependent[] locations = new JdbcTest.Dependent[]{new JdbcTest.Dependent(10, "San Francisco"), new JdbcTest.Dependent(20, "San Diego")};
        public final JdbcTest.Event[] events = new JdbcTest.Event[]{new JdbcTest.Event(100, new Timestamp(0L)), new JdbcTest.Event(200, new Timestamp(0L)), new JdbcTest.Event(150, new Timestamp(0L)), new JdbcTest.Event(110, null)};
        public final RelReferentialConstraint rcs0 = RelReferentialConstraintImpl.of((List)ImmutableList.of((Object)"hr", (Object)"emps"), (List)ImmutableList.of((Object)"hr", (Object)"depts"), (List)ImmutableList.of((Object)IntPair.of((int)1, (int)0)));

        public String toString() {
            return "HrFKUKSchema";
        }

        public QueryableTable foo(int count) {
            return Smalls.generateStrings(count);
        }

        public TranslatableTable view(String s) {
            return Smalls.view(s);
        }

        public TranslatableTable matview() {
            return Smalls.strView("noname");
        }
    }

    private static class TableNameVisitor
    extends RelVisitor {
        private List<List<String>> names = new ArrayList<List<String>>();

        private TableNameVisitor() {
        }

        List<List<String>> run(RelNode input) {
            this.go(input);
            return this.names;
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof TableScan) {
                RelOptTable table = node.getTable();
                List qName = table.getQualifiedName();
                this.names.add(qName);
            }
            super.visit(node, ordinal, parent);
        }
    }
}

