/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class SqlTests {
    public static final SqlTester.TypeChecker INTEGER_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.INTEGER);
    public static final SqlTester.TypeChecker BOOLEAN_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.BOOLEAN);
    public static final SqlTester.TypeChecker ANY_TYPE_CHECKER = type -> {};
    public static final SqlTester.ParameterChecker ANY_PARAMETER_CHECKER = parameterRowType -> {};
    public static final SqlTester.ResultChecker ANY_RESULT_CHECKER = result -> {
        while (result.next()) {
        }
    };
    private static final Pattern LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
    private static final Pattern LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");

    public static String getTypeString(RelDataType sqlType) {
        switch (sqlType.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                String actual = sqlType.getSqlTypeName().name();
                if (sqlType.getPrecision() != -1) {
                    actual = actual + "(" + sqlType.getPrecision() + ")";
                }
                if (!sqlType.isNullable()) {
                    actual = actual + " NOT NULL";
                }
                return actual;
            }
        }
        String s = sqlType.getFullTypeString();
        return s.replace(" CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"", "");
    }

    public static String generateAggQuery(String expr, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" FROM ");
        if (inputValues.length == 0) {
            buf.append("(VALUES 1) AS t(x) WHERE false");
        } else {
            buf.append("(");
            for (int i = 0; i < inputValues.length; ++i) {
                if (i > 0) {
                    buf.append(" UNION ALL ");
                }
                buf.append("SELECT ");
                String inputValue = inputValues[i];
                buf.append(inputValue).append(" AS x FROM (VALUES (1))");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String generateAggQueryWithMultipleArgs(String expr, String[][] inputValues) {
        int argCount = -1;
        for (Object[] objectArray : inputValues) {
            if (argCount == -1) {
                argCount = objectArray.length;
                continue;
            }
            if (argCount == objectArray.length) continue;
            throw new IllegalArgumentException("invalid test input: " + Arrays.toString(objectArray));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" FROM ");
        if (inputValues.length == 0) {
            buf.append("(VALUES 1) AS t(x) WHERE false");
        } else {
            buf.append("(");
            for (int i = 0; i < inputValues.length; ++i) {
                if (i > 0) {
                    buf.append(" UNION ALL ");
                }
                buf.append("SELECT ");
                for (int j = 0; j < argCount; ++j) {
                    if (j != 0) {
                        buf.append(", ");
                    }
                    String string = inputValues[i][j];
                    buf.append(string).append(" AS x");
                    if (j == 0) continue;
                    buf.append(j + 1);
                }
                buf.append(" FROM (VALUES (1))");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String generateWinAggQuery(String expr, String windowSpec, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" OVER (").append(windowSpec).append(") FROM (");
        for (int i = 0; i < inputValues.length; ++i) {
            if (i > 0) {
                buf.append(" UNION ALL ");
            }
            buf.append("SELECT ");
            String inputValue = inputValues[i];
            buf.append(inputValue).append(" AS x FROM (VALUES (1))");
        }
        buf.append(")");
        return buf.toString();
    }

    public static void compareResultSet(ResultSet resultSet, Set<String> refSet) throws Exception {
        HashSet<String> actualSet = new HashSet<String>();
        int columnType = resultSet.getMetaData().getColumnType(1);
        ColumnMetaData.Rep rep = SqlTests.rep(columnType);
        while (resultSet.next()) {
            String s = resultSet.getString(1);
            String s0 = s == null ? "0" : s;
            boolean wasNull0 = resultSet.wasNull();
            actualSet.add(s);
            switch (rep) {
                case BOOLEAN: {
                    Assert.assertThat((Object)resultSet.getBoolean(1), (Matcher)CoreMatchers.equalTo((Object)Boolean.valueOf(s)));
                    break;
                }
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    long l;
                    try {
                        l = Long.parseLong(s0);
                    }
                    catch (NumberFormatException e) {
                        l = (long)Double.parseDouble(s0);
                    }
                    Assert.assertThat((Object)resultSet.getByte(1), (Matcher)CoreMatchers.equalTo((Object)((byte)l)));
                    Assert.assertThat((Object)resultSet.getShort(1), (Matcher)CoreMatchers.equalTo((Object)((short)l)));
                    Assert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)((int)l)));
                    Assert.assertThat((Object)resultSet.getLong(1), (Matcher)CoreMatchers.equalTo((Object)l));
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    double d = Double.parseDouble(s0);
                    Assert.assertThat((Object)Float.valueOf(resultSet.getFloat(1)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf((float)d)));
                    Assert.assertThat((Object)resultSet.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)d));
                }
            }
            boolean wasNull1 = resultSet.wasNull();
            Object object = resultSet.getObject(1);
            boolean wasNull2 = resultSet.wasNull();
            Assert.assertThat((Object)(object == null ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)wasNull0));
            Assert.assertThat((Object)wasNull1, (Matcher)CoreMatchers.equalTo((Object)wasNull0));
            Assert.assertThat((Object)wasNull2, (Matcher)CoreMatchers.equalTo((Object)wasNull0));
        }
        resultSet.close();
        Assert.assertEquals(refSet, actualSet);
    }

    private static ColumnMetaData.Rep rep(int columnType) {
        switch (columnType) {
            case 16: {
                return ColumnMetaData.Rep.BOOLEAN;
            }
            case -6: {
                return ColumnMetaData.Rep.BYTE;
            }
            case 5: {
                return ColumnMetaData.Rep.SHORT;
            }
            case 4: {
                return ColumnMetaData.Rep.INTEGER;
            }
            case -5: {
                return ColumnMetaData.Rep.LONG;
            }
            case 7: {
                return ColumnMetaData.Rep.FLOAT;
            }
            case 8: {
                return ColumnMetaData.Rep.DOUBLE;
            }
            case 92: {
                return ColumnMetaData.Rep.JAVA_SQL_TIME;
            }
            case 93: {
                return ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP;
            }
            case 91: {
                return ColumnMetaData.Rep.JAVA_SQL_DATE;
            }
        }
        return ColumnMetaData.Rep.OBJECT;
    }

    public static void compareResultSetWithPattern(ResultSet resultSet, Pattern pattern) throws Exception {
        if (!resultSet.next()) {
            Assert.fail((String)"Query returned 0 rows, expected 1");
        }
        String actual = resultSet.getString(1);
        if (resultSet.next()) {
            Assert.fail((String)"Query returned 2 or more rows, expected 1");
        }
        if (!pattern.matcher(actual).matches()) {
            Assert.fail((String)("Query returned '" + actual + "', expected '" + pattern.pattern() + "'"));
        }
    }

    public static void compareResultSetWithDelta(ResultSet resultSet, double expected, double delta) throws Exception {
        if (!resultSet.next()) {
            Assert.fail((String)"Query returned 0 rows, expected 1");
        }
        double actual = resultSet.getDouble(1);
        if (resultSet.next()) {
            Assert.fail((String)"Query returned 2 or more rows, expected 1");
        }
        if (actual < expected - delta || actual > expected + delta) {
            Assert.fail((String)("Query returned " + actual + ", expected " + expected + (delta == 0.0 ? "" : "+/-" + delta)));
        }
    }

    public static void checkEx(Throwable ex, String expectedMsgPattern, SqlParserUtil.StringAndPos sap, Stage stage) {
        String sqlWithCarets;
        if (null == ex) {
            if (expectedMsgPattern == null) {
                return;
            }
            throw new AssertionError((Object)("Expected query to throw exception, but it did not; query [" + sap.sql + "]; expected [" + expectedMsgPattern + "]"));
        }
        Throwable actualException = ex;
        String actualMessage = actualException.getMessage();
        int actualLine = -1;
        int actualColumn = -1;
        int actualEndLine = 100;
        int actualEndColumn = 99;
        CalciteContextException ece = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof CalciteContextException) {
                ece = (CalciteContextException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        SqlParseException spe = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof SqlParseException && ((SqlParseException)x).getPos() != null) {
                spe = (SqlParseException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        if (ece != null) {
            actualLine = ece.getPosLine();
            actualColumn = ece.getPosColumn();
            actualEndLine = ece.getEndPosLine();
            actualEndColumn = ece.getEndPosColumn();
            if (ece.getCause() != null) {
                actualException = ece.getCause();
                actualMessage = actualException.getMessage();
            }
        } else if (spe != null) {
            actualLine = spe.getPos().getLineNum();
            actualColumn = spe.getPos().getColumnNum();
            actualEndLine = spe.getPos().getEndLineNum();
            actualEndColumn = spe.getPos().getEndColumnNum();
            if (spe.getCause() != null) {
                actualException = spe.getCause();
                actualMessage = actualException.getMessage();
            }
        } else {
            String message = ex.getMessage();
            if (message != null) {
                java.util.regex.Matcher matcher = LINE_COL_TWICE_PATTERN.matcher(message);
                if (matcher.matches()) {
                    actualLine = Integer.parseInt(matcher.group(1));
                    actualColumn = Integer.parseInt(matcher.group(2));
                    actualEndLine = Integer.parseInt(matcher.group(3));
                    actualEndColumn = Integer.parseInt(matcher.group(4));
                    actualMessage = matcher.group(5);
                } else {
                    matcher = LINE_COL_PATTERN.matcher(message);
                    if (matcher.matches()) {
                        actualLine = Integer.parseInt(matcher.group(1));
                        actualColumn = Integer.parseInt(matcher.group(2));
                    } else if (expectedMsgPattern != null && actualMessage.matches(expectedMsgPattern)) {
                        return;
                    }
                }
            }
        }
        if (null == expectedMsgPattern) {
            actualException.printStackTrace();
            Assert.fail((String)(stage.componentName + " threw unexpected exception; query [" + sap.sql + "]; exception [" + actualMessage + "]; class [" + actualException.getClass() + "]; pos [line " + actualLine + " col " + actualColumn + " thru line " + actualLine + " col " + actualColumn + "]"));
        }
        if (actualColumn <= 0 || actualLine <= 0 || actualEndColumn <= 0 || actualEndLine <= 0) {
            if (sap.pos != null) {
                throw new AssertionError("Expected error to have position, but actual error did not:  actual pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]", actualException);
            }
            sqlWithCarets = sap.sql;
        } else {
            sqlWithCarets = SqlParserUtil.addCarets((String)sap.sql, (int)actualLine, (int)actualColumn, (int)actualEndLine, (int)(actualEndColumn + 1));
            if (sap.pos == null) {
                throw new AssertionError((Object)("Actual error had a position, but expected error did not. Add error position carets to sql:\n" + sqlWithCarets));
            }
        }
        if (actualMessage != null) {
            actualMessage = Util.toLinux((String)actualMessage);
        }
        if (actualMessage == null || !actualMessage.matches(expectedMsgPattern)) {
            actualException.printStackTrace();
            String actualJavaRegexp = actualMessage == null ? "null" : TestUtil.quoteForJava(TestUtil.quotePattern(actualMessage));
            Assert.fail((String)(stage.componentName + " threw different exception than expected; query [" + sap.sql + "];\n expected pattern [" + expectedMsgPattern + "];\n actual [" + actualMessage + "];\n actual as java regexp [" + actualJavaRegexp + "]; pos [" + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]; sql [" + sqlWithCarets + "]"));
        } else if (sap.pos != null && (actualLine != sap.pos.getLineNum() || actualColumn != sap.pos.getColumnNum() || actualEndLine != sap.pos.getEndLineNum() || actualEndColumn != sap.pos.getEndColumnNum())) {
            Assert.fail((String)(stage.componentName + " threw expected exception [" + actualMessage + "];\nbut at pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "];\nsql [" + sqlWithCarets + "]"));
        }
    }

    public static SqlTester.ResultChecker createChecker(Object result, double delta) {
        if (result instanceof Pattern) {
            return new PatternResultChecker((Pattern)result);
        }
        if (delta != 0.0) {
            Assert.assertTrue((boolean)(result instanceof Number));
            return new ApproximateResultChecker((Number)result, delta);
        }
        HashSet<String> refSet = new HashSet<String>();
        if (result == null) {
            refSet.add(null);
        } else if (result instanceof Collection) {
            Collection collection = (Collection)result;
            refSet.addAll(collection);
        } else {
            refSet.add(result.toString());
        }
        return new RefSetResultChecker(refSet);
    }

    public static class RefSetResultChecker
    implements SqlTester.ResultChecker {
        private final Set<String> expected;

        private RefSetResultChecker(Set<String> expected) {
            this.expected = expected;
        }

        @Override
        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSet(resultSet, this.expected);
        }
    }

    public static class ApproximateResultChecker
    implements SqlTester.ResultChecker {
        private final Number expected;
        private final double delta;

        public ApproximateResultChecker(Number expected, double delta) {
            this.expected = expected;
            this.delta = delta;
        }

        @Override
        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSetWithDelta(resultSet, this.expected.doubleValue(), this.delta);
        }
    }

    public static class PatternResultChecker
    implements SqlTester.ResultChecker {
        private final Pattern pattern;

        public PatternResultChecker(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSetWithPattern(resultSet, this.pattern);
        }
    }

    public static class StringTypeChecker
    implements SqlTester.TypeChecker {
        private final String expected;

        public StringTypeChecker(String expected) {
            this.expected = expected;
        }

        @Override
        public void checkType(RelDataType type) {
            String actual = SqlTests.getTypeString(type);
            Assert.assertThat((Object)actual, (Matcher)CoreMatchers.is((Object)this.expected));
        }
    }

    private static class SqlTypeChecker
    implements SqlTester.TypeChecker {
        private final SqlTypeName typeName;

        SqlTypeChecker(SqlTypeName typeName) {
            this.typeName = typeName;
        }

        @Override
        public void checkType(RelDataType type) {
            Assert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)this.typeName.toString()));
        }
    }

    public static enum Stage {
        PARSE("Parser"),
        VALIDATE("Validator"),
        RUNTIME("Executor");

        public final String componentName;

        private Stage(String componentName) {
            this.componentName = componentName;
        }
    }
}

