/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.DelegatingTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.MockSqlOperatorTable;
import org.apache.calcite.test.catalog.MockCatalogReader;
import org.apache.calcite.test.catalog.MockCatalogReaderSimple;
import org.apache.calcite.util.SourceStringReader;

public class SqlTestFactory {
    public static final ImmutableMap<String, Object> DEFAULT_OPTIONS = ImmutableSortedMap.naturalOrder().put((Object)"quoting", (Object)Quoting.DOUBLE_QUOTE).put((Object)"quotedCasing", (Object)Casing.UNCHANGED).put((Object)"unquotedCasing", (Object)Casing.TO_UPPER).put((Object)"caseSensitive", (Object)true).put((Object)"conformance", (Object)SqlConformanceEnum.DEFAULT).put((Object)"operatorTable", (Object)SqlStdOperatorTable.instance()).put((Object)"connectionFactory", (Object)CalciteAssert.EMPTY_CONNECTION_FACTORY.with(new CalciteAssert.AddSchemaSpecPostProcessor(CalciteAssert.SchemaSpec.HR))).build();
    public static final SqlTestFactory INSTANCE = new SqlTestFactory();
    private final ImmutableMap<String, Object> options;
    private final MockCatalogReaderFactory catalogReaderFactory;
    private final ValidatorFactory validatorFactory;
    private final Supplier<RelDataTypeFactory> typeFactory;
    private final Supplier<SqlOperatorTable> operatorTable;
    private final Supplier<SqlValidatorCatalogReader> catalogReader;
    private final Supplier<SqlParser.Config> parserConfig;

    protected SqlTestFactory() {
        this(DEFAULT_OPTIONS, MockCatalogReaderSimple::new, SqlValidatorUtil::newValidator);
    }

    protected SqlTestFactory(ImmutableMap<String, Object> options, MockCatalogReaderFactory catalogReaderFactory, ValidatorFactory validatorFactory) {
        this.options = options;
        this.catalogReaderFactory = catalogReaderFactory;
        this.validatorFactory = validatorFactory;
        this.operatorTable = Suppliers.memoize(() -> SqlTestFactory.createOperatorTable((SqlOperatorTable)options.get((Object)"operatorTable")));
        this.typeFactory = Suppliers.memoize(() -> SqlTestFactory.createTypeFactory((SqlConformance)options.get((Object)"conformance")));
        Boolean caseSensitive = (Boolean)options.get((Object)"caseSensitive");
        this.catalogReader = Suppliers.memoize(() -> catalogReaderFactory.create((RelDataTypeFactory)this.typeFactory.get(), caseSensitive).init());
        this.parserConfig = Suppliers.memoize(() -> SqlTestFactory.createParserConfig(options));
    }

    private static SqlOperatorTable createOperatorTable(SqlOperatorTable opTab0) {
        MockSqlOperatorTable opTab = new MockSqlOperatorTable(opTab0);
        MockSqlOperatorTable.addRamp(opTab);
        return opTab;
    }

    public SqlParser.Config getParserConfig() {
        return (SqlParser.Config)this.parserConfig.get();
    }

    public SqlParser createParser(String sql) {
        return SqlParser.create((Reader)new SourceStringReader(sql), (SqlParser.Config)((SqlParser.Config)this.parserConfig.get()));
    }

    public static SqlParser.Config createParserConfig(ImmutableMap<String, Object> options) {
        return SqlParser.configBuilder().setQuoting((Quoting)options.get((Object)"quoting")).setUnquotedCasing((Casing)options.get((Object)"unquotedCasing")).setQuotedCasing((Casing)options.get((Object)"quotedCasing")).setConformance((SqlConformance)options.get((Object)"conformance")).setCaseSensitive(((Boolean)options.get((Object)"caseSensitive")).booleanValue()).build();
    }

    public SqlValidator getValidator() {
        SqlConformance conformance = (SqlConformance)this.options.get((Object)"conformance");
        return this.validatorFactory.create((SqlOperatorTable)this.operatorTable.get(), (SqlValidatorCatalogReader)this.catalogReader.get(), (RelDataTypeFactory)this.typeFactory.get(), conformance);
    }

    public SqlAdvisor createAdvisor() {
        SqlValidator validator = this.getValidator();
        if (validator instanceof SqlValidatorWithHints) {
            return new SqlAdvisor((SqlValidatorWithHints)validator, (SqlParser.Config)this.parserConfig.get());
        }
        throw new UnsupportedOperationException("Validator should implement SqlValidatorWithHints, actual validator is " + validator);
    }

    public SqlTestFactory with(String name, Object value) {
        if (Objects.equals(value, this.options.get((Object)name))) {
            return this;
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry : this.options.entrySet()) {
            if (name.equals(entry.getKey())) continue;
            builder.put(entry);
        }
        builder.put((Object)name, value);
        return new SqlTestFactory((ImmutableMap<String, Object>)builder.build(), this.catalogReaderFactory, this.validatorFactory);
    }

    public SqlTestFactory withCatalogReader(MockCatalogReaderFactory newCatalogReaderFactory) {
        return new SqlTestFactory(this.options, newCatalogReaderFactory, this.validatorFactory);
    }

    public SqlTestFactory withValidator(ValidatorFactory newValidatorFactory) {
        return new SqlTestFactory(this.options, this.catalogReaderFactory, newValidatorFactory);
    }

    public final Object get(String name) {
        return this.options.get((Object)name);
    }

    private static RelDataTypeFactory createTypeFactory(SqlConformance conformance) {
        Object typeSystem = RelDataTypeSystem.DEFAULT;
        if (conformance.shouldConvertRaggedUnionTypesToVarying()) {
            typeSystem = new DelegatingTypeSystem((RelDataTypeSystem)typeSystem){

                public boolean shouldConvertRaggedUnionTypesToVarying() {
                    return true;
                }
            };
        }
        if (conformance.allowExtendedTrim()) {
            typeSystem = new DelegatingTypeSystem((RelDataTypeSystem)typeSystem){

                public boolean allowExtendedTrim() {
                    return true;
                }
            };
        }
        return new JavaTypeFactoryImpl(typeSystem);
    }

    public static interface MockCatalogReaderFactory {
        public MockCatalogReader create(RelDataTypeFactory var1, boolean var2);
    }

    public static interface ValidatorFactory {
        public SqlValidator create(SqlOperatorTable var1, SqlValidatorCatalogReader var2, RelDataTypeFactory var3, SqlConformance var4);
    }
}

