/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.EqualityComparer;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.linq4j.function.Predicate2;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class EnumerablesTest {
    private static final Enumerable<Emp> EMPS = Linq4j.asEnumerable(Arrays.asList(new Emp(10, "Fred"), new Emp(20, "Theodore"), new Emp(20, "Sebastian"), new Emp(30, "Joe")));
    private static final Enumerable<Dept> DEPTS = Linq4j.asEnumerable(Arrays.asList(new Dept(20, "Sales"), new Dept(15, "Marketing")));
    private static final Function2<Emp, Dept, String> EMP_DEPT_TO_STRING = (v0, v1) -> "{" + (v0 == null ? null : v0.name) + ", " + (v0 == null ? null : Integer.valueOf(v0.deptno)) + ", " + (v1 == null ? null : Integer.valueOf(v1.deptno)) + ", " + (v1 == null ? null : v1.name) + "}";
    private static final Predicate2<Emp, Dept> EQUAL_DEPTNO = (e, d) -> e.deptno == d.deptno;

    @Test
    public void testSemiJoin() {
        Assert.assertThat((Object)EnumerableDefaults.semiJoin(EMPS, DEPTS, e -> e.deptno, d -> d.deptno, (EqualityComparer)Functions.identityComparer()).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[Emp(20, Theodore), Emp(20, Sebastian)]"));
    }

    @Test
    public void testMergeJoin() {
        Assert.assertThat((Object)EnumerableDefaults.mergeJoin((Enumerable)Linq4j.asEnumerable(Arrays.asList(new Emp(10, "Fred"), new Emp(20, "Theodore"), new Emp(20, "Sebastian"), new Emp(30, "Joe"), new Emp(30, "Greg"))), (Enumerable)Linq4j.asEnumerable(Arrays.asList(new Dept(15, "Marketing"), new Dept(20, "Sales"), new Dept(30, "Research"), new Dept(30, "Development"))), e -> e.deptno, d -> d.deptno, (v0, v1) -> v0 + ", " + v1, (boolean)false, (boolean)false).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[Emp(20, Theodore), Dept(20, Sales), Emp(20, Sebastian), Dept(20, Sales), Emp(30, Joe), Dept(30, Research), Emp(30, Joe), Dept(30, Development), Emp(30, Greg), Dept(30, Research), Emp(30, Greg), Dept(30, Development)]"));
    }

    @Test
    public void testMergeJoin2() {
        Assert.assertThat((Object)EnumerablesTest.intersect(Lists.newArrayList((Object[])new Integer[]{1, 3, 4}), Lists.newArrayList((Object[])new Integer[]{1, 4})).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 4]"));
        Assert.assertThat((Object)EnumerablesTest.intersect(Lists.newArrayList((Object[])new Integer[]{0, 1, 3, 4, 5}), Lists.newArrayList((Object[])new Integer[]{1, 4})).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 4]"));
        Assert.assertThat((Object)EnumerablesTest.intersect(Lists.newArrayList((Object[])new Integer[]{1, 3, 4}), Lists.newArrayList((Object[])new Integer[]{0, 1, 4, 5})).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 4]"));
        Assert.assertThat((Object)EnumerablesTest.intersect(Lists.newArrayList((Object[])new Integer[]{0, 2, 3, 4, 5}), Lists.newArrayList((Object[])new Integer[]{1, 3, 4, 6})).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[3, 4]"));
    }

    @Test
    public void testMergeJoin3() {
        Assert.assertThat((Object)EnumerablesTest.intersect(Lists.newArrayList((Object[])new Integer[]{0, 2, 4}), Lists.newArrayList((Object[])new Integer[]{1, 3, 5})).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        Assert.assertThat((Object)EnumerablesTest.intersect(new ArrayList(), Lists.newArrayList((Object[])new Integer[]{1, 3, 4, 6})).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        Assert.assertThat((Object)EnumerablesTest.intersect(Lists.newArrayList((Object[])new Integer[]{3, 7}), new ArrayList()).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        Assert.assertThat((Object)EnumerablesTest.intersect(new ArrayList(), new ArrayList()).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
    }

    private static <T extends Comparable<T>> Enumerable<T> intersect(List<T> list0, List<T> list1) {
        return EnumerableDefaults.mergeJoin((Enumerable)Linq4j.asEnumerable(list0), (Enumerable)Linq4j.asEnumerable(list1), (Function1)Functions.identitySelector(), (Function1)Functions.identitySelector(), (v0, v1) -> v0, (boolean)false, (boolean)false);
    }

    @Test
    public void testThetaJoin() {
        Assert.assertThat((Object)EnumerableDefaults.thetaJoin(EMPS, DEPTS, EQUAL_DEPTNO, EMP_DEPT_TO_STRING, (boolean)false, (boolean)false).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{Theodore, 20, 20, Sales}, {Sebastian, 20, 20, Sales}]"));
    }

    @Test
    public void testThetaLeftJoin() {
        Assert.assertThat((Object)EnumerableDefaults.thetaJoin(EMPS, DEPTS, EQUAL_DEPTNO, EMP_DEPT_TO_STRING, (boolean)false, (boolean)true).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{Fred, 10, null, null}, {Theodore, 20, 20, Sales}, {Sebastian, 20, 20, Sales}, {Joe, 30, null, null}]"));
    }

    @Test
    public void testThetaRightJoin() {
        Assert.assertThat((Object)EnumerableDefaults.thetaJoin(EMPS, DEPTS, EQUAL_DEPTNO, EMP_DEPT_TO_STRING, (boolean)true, (boolean)false).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{Theodore, 20, 20, Sales}, {Sebastian, 20, 20, Sales}, {null, null, 15, Marketing}]"));
    }

    @Test
    public void testThetaFullJoin() {
        Assert.assertThat((Object)EnumerableDefaults.thetaJoin(EMPS, DEPTS, EQUAL_DEPTNO, EMP_DEPT_TO_STRING, (boolean)true, (boolean)true).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{Fred, 10, null, null}, {Theodore, 20, 20, Sales}, {Sebastian, 20, 20, Sales}, {Joe, 30, null, null}, {null, null, 15, Marketing}]"));
    }

    @Test
    public void testThetaFullJoinLeftEmpty() {
        Assert.assertThat((Object)EnumerableDefaults.thetaJoin((Enumerable)EMPS.take(0), DEPTS, EQUAL_DEPTNO, EMP_DEPT_TO_STRING, (boolean)true, (boolean)true).orderBy(Functions.identitySelector()).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{null, null, 15, Marketing}, {null, null, 20, Sales}]"));
    }

    @Test
    public void testThetaFullJoinRightEmpty() {
        Assert.assertThat((Object)EnumerableDefaults.thetaJoin(EMPS, (Enumerable)DEPTS.take(0), EQUAL_DEPTNO, EMP_DEPT_TO_STRING, (boolean)true, (boolean)true).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[{Fred, 10, null, null}, {Theodore, 20, null, null}, {Sebastian, 20, null, null}, {Joe, 30, null, null}]"));
    }

    @Test
    public void testThetaFullJoinBothEmpty() {
        Assert.assertThat((Object)EnumerableDefaults.thetaJoin((Enumerable)EMPS.take(0), (Enumerable)DEPTS.take(0), EQUAL_DEPTNO, EMP_DEPT_TO_STRING, (boolean)true, (boolean)true).toList().toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
    }

    private static class Dept {
        final int deptno;
        final String name;

        Dept(int deptno, String name) {
            this.deptno = deptno;
            this.name = name;
        }

        public String toString() {
            return "Dept(" + this.deptno + ", " + this.name + ")";
        }
    }

    private static class Emp {
        final int deptno;
        final String name;

        Emp(int deptno, String name) {
            this.deptno = deptno;
            this.name = name;
        }

        public String toString() {
            return "Emp(" + this.deptno + ", " + this.name + ")";
        }
    }
}

