/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.dialect.JethroDataSqlDialect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.test.RelBuilderTest;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelToSqlConverterTest {
    static final SqlToRelConverter.Config DEFAULT_REL_CONFIG = SqlToRelConverter.configBuilder().withTrimUnusedFields(false).withConvertTableAccess(false).build();
    static final SqlToRelConverter.Config NO_EXPAND_CONFIG = SqlToRelConverter.configBuilder().withTrimUnusedFields(false).withConvertTableAccess(false).withExpand(false).build();

    private Sql sql(String sql) {
        return new Sql(CalciteAssert.SchemaSpec.JDBC_FOODMART, sql, CalciteSqlDialect.DEFAULT, DEFAULT_REL_CONFIG, (List<Function<RelNode, RelNode>>)ImmutableList.of());
    }

    private static Planner getPlanner(List<RelTraitDef> traitDefs, SqlParser.Config parserConfig, SchemaPlus schema, SqlToRelConverter.Config sqlToRelConf, Program ... programs) {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(schema).traitDefs(traitDefs).sqlToRelConverterConfig(sqlToRelConf).programs(programs).build();
        return Frameworks.getPlanner((FrameworkConfig)config);
    }

    private static JethroDataSqlDialect jethroDataSqlDialect() {
        SqlDialect.Context dummyContext = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.JETHRO).withDatabaseMajorVersion(1).withDatabaseMinorVersion(0).withDatabaseVersion("1.0").withIdentifierQuoteString("\"").withNullCollation(NullCollation.HIGH).withJethroInfo(JethroDataSqlDialect.JethroInfo.EMPTY);
        return new JethroDataSqlDialect(dummyContext);
    }

    private static MysqlSqlDialect mySqlDialect(NullCollation nullCollation) {
        return new MysqlSqlDialect(SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.MYSQL).withIdentifierQuoteString("`").withNullCollation(nullCollation));
    }

    private static RelBuilder relBuilder() {
        return RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
    }

    private String toSql(RelNode root) {
        return RelToSqlConverterTest.toSql(root, SqlDialect.DatabaseProduct.CALCITE.getDialect());
    }

    private static String toSql(RelNode root, SqlDialect dialect) {
        RelToSqlConverter converter = new RelToSqlConverter(dialect);
        SqlNode sqlNode = converter.visitChild(0, root).asStatement();
        return sqlNode.toSqlString(dialect).getSql();
    }

    @Test
    public void testSimpleSelectStarFromProductTable() {
        String query = "select * from \"product\"";
        this.sql(query).ok("SELECT *\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testSimpleSelectQueryFromProductTable() {
        String query = "select \"product_id\", \"product_class_id\" from \"product\"";
        String expected = "SELECT \"product_id\", \"product_class_id\"\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT \"product_id\", \"product_class_id\"\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testSelectQueryWithWhereClauseOfLessThan() {
        String query = "select \"product_id\", \"shelf_width\"  from \"product\" where \"product_id\" < 10";
        String expected = "SELECT \"product_id\", \"shelf_width\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" < 10";
        this.sql(query).ok("SELECT \"product_id\", \"shelf_width\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" < 10");
    }

    @Test
    public void testSelectQueryWithWhereClauseOfBasicOperators() {
        String query = "select * from \"product\" where (\"product_id\" = 10 OR \"product_id\" <= 5) AND (80 >= \"shelf_width\" OR \"shelf_width\" > 30)";
        String expected = "SELECT *\nFROM \"foodmart\".\"product\"\nWHERE (\"product_id\" = 10 OR \"product_id\" <= 5) AND (80 >= \"shelf_width\" OR \"shelf_width\" > 30)";
        this.sql(query).ok("SELECT *\nFROM \"foodmart\".\"product\"\nWHERE (\"product_id\" = 10 OR \"product_id\" <= 5) AND (80 >= \"shelf_width\" OR \"shelf_width\" > 30)");
    }

    @Test
    public void testSelectQueryWithGroupBy() {
        String query = "select count(*) from \"product\" group by \"product_class_id\", \"product_id\"";
        String expected = "SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"";
        this.sql(query).ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"");
    }

    @Test
    public void testSelectQueryWithGroupByEmpty() {
        String sql0 = "select count(*) from \"product\" group by ()";
        String sql1 = "select count(*) from \"product\"";
        String expected = "SELECT COUNT(*)\nFROM \"foodmart\".\"product\"";
        String expectedMySql = "SELECT COUNT(*)\nFROM `foodmart`.`product`";
        this.sql("select count(*) from \"product\" group by ()").ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"").withMysql().ok("SELECT COUNT(*)\nFROM `foodmart`.`product`");
        this.sql("select count(*) from \"product\"").ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"").withMysql().ok("SELECT COUNT(*)\nFROM `foodmart`.`product`");
    }

    @Test
    public void testSelectQueryWithGroupByEmpty2() {
        String query = "select 42 as c from \"product\" group by ()";
        String expected = "SELECT 42 AS \"C\"\nFROM \"foodmart\".\"product\"\nGROUP BY ()";
        String expectedMySql = "SELECT 42 AS `C`\nFROM `foodmart`.`product`\nGROUP BY ()";
        this.sql("select 42 as c from \"product\" group by ()").ok("SELECT 42 AS \"C\"\nFROM \"foodmart\".\"product\"\nGROUP BY ()").withMysql().ok("SELECT 42 AS `C`\nFROM `foodmart`.`product`\nGROUP BY ()");
    }

    @Test
    public void testSelectQueryWithMinAggregateFunction() {
        String query = "select min(\"net_weight\") from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithMinAggregateFunction1() {
        String query = "select \"product_class_id\", min(\"net_weight\") from \"product\" group by \"product_class_id\"";
        String expected = "SELECT \"product_class_id\", MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT \"product_class_id\", MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithSumAggregateFunction() {
        String query = "select sum(\"net_weight\") from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT SUM(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT SUM(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithMultipleAggregateFunction() {
        String query = "select sum(\"net_weight\"), min(\"low_fat\"), count(*) from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithMultipleAggregateFunction1() {
        String query = "select \"product_class_id\", sum(\"net_weight\"), min(\"low_fat\"), count(*) from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT \"product_class_id\", SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT \"product_class_id\", SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithGroupByAndProjectList() {
        String query = "select \"product_class_id\", \"product_id\", count(*) from \"product\" group by \"product_class_id\", \"product_id\"  ";
        String expected = "SELECT \"product_class_id\", \"product_id\", COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"";
        this.sql(query).ok("SELECT \"product_class_id\", \"product_id\", COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"");
    }

    @Test
    public void testCastLongVarchar1() {
        String query = "select cast(\"store_id\" as VARCHAR(10485761))\n from \"expense_fact\"";
        String expected = "SELECT CAST(\"store_id\" AS VARCHAR(256))\nFROM \"foodmart\".\"expense_fact\"";
        this.sql("select cast(\"store_id\" as VARCHAR(10485761))\n from \"expense_fact\"").withPostgresqlModifiedTypeSystem().ok("SELECT CAST(\"store_id\" AS VARCHAR(256))\nFROM \"foodmart\".\"expense_fact\"");
    }

    @Test
    public void testCastLongVarchar2() {
        String query = "select cast(\"store_id\" as VARCHAR(175))\n from \"expense_fact\"";
        String expected = "SELECT CAST(\"store_id\" AS VARCHAR(175))\nFROM \"foodmart\".\"expense_fact\"";
        this.sql("select cast(\"store_id\" as VARCHAR(175))\n from \"expense_fact\"").withPostgresqlModifiedTypeSystem().ok("SELECT CAST(\"store_id\" AS VARCHAR(175))\nFROM \"foodmart\".\"expense_fact\"");
    }

    @Test
    public void testSum0BecomesCoalesce() {
        RelBuilder builder = RelToSqlConverterTest.relBuilder();
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.SUM0, new RexNode[]{builder.field(3)}).as("s")}).build();
        String expectedMysql = "SELECT COALESCE(SUM(`MGR`), 0) AS `s`\nFROM `scott`.`EMP`";
        Assert.assertThat((Object)RelToSqlConverterTest.toSql(root, SqlDialect.DatabaseProduct.MYSQL.getDialect()), Matchers.isLinux("SELECT COALESCE(SUM(`MGR`), 0) AS `s`\nFROM `scott`.`EMP`"));
        String expectedPostgresql = "SELECT COALESCE(SUM(\"MGR\"), 0) AS \"s\"\nFROM \"scott\".\"EMP\"";
        Assert.assertThat((Object)RelToSqlConverterTest.toSql(root, SqlDialect.DatabaseProduct.POSTGRESQL.getDialect()), Matchers.isLinux("SELECT COALESCE(SUM(\"MGR\"), 0) AS \"s\"\nFROM \"scott\".\"EMP\""));
    }

    @Test
    public void testWindowedSum0BecomesCoalesce() {
        String query = "select\n  AVG(\"net_weight\") OVER (order by \"product_id\" rows 3 preceding)\nfrom \"foodmart\".\"product\"";
        String expectedPostgresql = "SELECT CASE WHEN (COUNT(\"net_weight\") OVER (ORDER BY \"product_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW)) > 0 THEN CAST(COALESCE(SUM(\"net_weight\") OVER (ORDER BY \"product_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW), 0) AS DOUBLE PRECISION) ELSE NULL END / (COUNT(\"net_weight\") OVER (ORDER BY \"product_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW))\nFROM \"foodmart\".\"product\"";
        this.sql("select\n  AVG(\"net_weight\") OVER (order by \"product_id\" rows 3 preceding)\nfrom \"foodmart\".\"product\"").withPostgresql().ok("SELECT CASE WHEN (COUNT(\"net_weight\") OVER (ORDER BY \"product_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW)) > 0 THEN CAST(COALESCE(SUM(\"net_weight\") OVER (ORDER BY \"product_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW), 0) AS DOUBLE PRECISION) ELSE NULL END / (COUNT(\"net_weight\") OVER (ORDER BY \"product_id\" ROWS BETWEEN 3 PRECEDING AND CURRENT ROW))\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testNestedAggregates() {
        String query = "select\n    SUM(\"net_weight1\") as \"net_weight_converted\"\n  from (    select\n       SUM(\"net_weight\") as \"net_weight1\"\n    from \"foodmart\".\"product\"\n    group by \"product_id\")";
        String expectedOracle = "SELECT SUM(SUM(\"net_weight\")) \"net_weight_converted\"\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_id\"";
        String expectedMySQL = "SELECT SUM(`net_weight1`) AS `net_weight_converted`\nFROM (SELECT SUM(`net_weight`) AS `net_weight1`\nFROM `foodmart`.`product`\nGROUP BY `product_id`) AS `t1`";
        String expectedVertica = "SELECT SUM(\"net_weight1\") AS \"net_weight_converted\"\nFROM (SELECT SUM(\"net_weight\") AS \"net_weight1\"\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_id\") AS \"t1\"";
        String expectedPostgresql = "SELECT SUM(\"net_weight1\") AS \"net_weight_converted\"\nFROM (SELECT SUM(\"net_weight\") AS \"net_weight1\"\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_id\") AS \"t1\"";
        this.sql("select\n    SUM(\"net_weight1\") as \"net_weight_converted\"\n  from (    select\n       SUM(\"net_weight\") as \"net_weight1\"\n    from \"foodmart\".\"product\"\n    group by \"product_id\")").withOracle().ok("SELECT SUM(SUM(\"net_weight\")) \"net_weight_converted\"\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_id\"").withMysql().ok("SELECT SUM(`net_weight1`) AS `net_weight_converted`\nFROM (SELECT SUM(`net_weight`) AS `net_weight1`\nFROM `foodmart`.`product`\nGROUP BY `product_id`) AS `t1`").withVertica().ok("SELECT SUM(\"net_weight1\") AS \"net_weight_converted\"\nFROM (SELECT SUM(\"net_weight\") AS \"net_weight1\"\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_id\") AS \"t1\"").withPostgresql().ok("SELECT SUM(\"net_weight1\") AS \"net_weight_converted\"\nFROM (SELECT SUM(\"net_weight\") AS \"net_weight1\"\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_id\") AS \"t1\"");
    }

    @Test
    public void testNestedAggregatesMySqlTable() {
        RelBuilder builder = RelToSqlConverterTest.relBuilder();
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[]{builder.field(3)})}).build();
        SqlDialect dialect = SqlDialect.DatabaseProduct.MYSQL.getDialect();
        String expectedSql = "SELECT COUNT(`MGR`) AS `c`\nFROM `scott`.`EMP`";
        Assert.assertThat((Object)RelToSqlConverterTest.toSql(root, dialect), Matchers.isLinux("SELECT COUNT(`MGR`) AS `c`\nFROM `scott`.`EMP`"));
    }

    @Test
    public void testNestedAggregatesMySqlStar() {
        RelBuilder builder = RelToSqlConverterTest.relBuilder();
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.equals((RexNode)builder.field("DEPTNO"), builder.literal((Object)10))}).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.count(false, "c", new RexNode[]{builder.field(3)})}).build();
        SqlDialect dialect = SqlDialect.DatabaseProduct.MYSQL.getDialect();
        String expectedSql = "SELECT COUNT(`MGR`) AS `c`\nFROM `scott`.`EMP`\nWHERE `DEPTNO` = 10";
        Assert.assertThat((Object)RelToSqlConverterTest.toSql(root, dialect), Matchers.isLinux("SELECT COUNT(`MGR`) AS `c`\nFROM `scott`.`EMP`\nWHERE `DEPTNO` = 10"));
    }

    @Test
    public void testSelectQueryWithGroupByAndProjectList1() {
        String query = "select count(*)  from \"product\" group by \"product_class_id\", \"product_id\"";
        String expected = "SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"";
        this.sql(query).ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"");
    }

    @Test
    public void testSelectQueryWithGroupByHaving() {
        String query = "select count(*) from \"product\" group by \"product_class_id\", \"product_id\"  having \"product_id\"  > 10";
        String expected = "SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"\nHAVING \"product_id\" > 10";
        this.sql(query).ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"\nHAVING \"product_id\" > 10");
    }

    @Test
    public void testSelectQueryWithGroupByHaving2() {
        String query = " select \"product\".\"product_id\",\n    min(\"sales_fact_1997\".\"store_id\")\n    from \"product\"\n    inner join \"sales_fact_1997\"\n    on \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\n    group by \"product\".\"product_id\"\n    having count(*) > 1";
        String expected = "SELECT \"product\".\"product_id\", MIN(\"sales_fact_1997\".\"store_id\")\nFROM \"foodmart\".\"product\"\nINNER JOIN \"foodmart\".\"sales_fact_1997\" ON \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\nGROUP BY \"product\".\"product_id\"\nHAVING COUNT(*) > 1";
        this.sql(query).ok(expected);
    }

    @Test
    public void testSelectQueryWithGroupByHaving3() {
        String query = " select * from (select \"product\".\"product_id\",\n    min(\"sales_fact_1997\".\"store_id\")\n    from \"product\"\n    inner join \"sales_fact_1997\"\n    on \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\n    group by \"product\".\"product_id\"\n    having count(*) > 1) where \"product_id\" > 100";
        String expected = "SELECT *\nFROM (SELECT \"product\".\"product_id\", MIN(\"sales_fact_1997\".\"store_id\")\nFROM \"foodmart\".\"product\"\nINNER JOIN \"foodmart\".\"sales_fact_1997\" ON \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\nGROUP BY \"product\".\"product_id\"\nHAVING COUNT(*) > 1) AS \"t2\"\nWHERE \"t2\".\"product_id\" > 100";
        this.sql(query).ok(expected);
    }

    @Test
    public void testSelectQueryWithOrderByClause() {
        String query = "select \"product_id\"  from \"product\" order by \"net_weight\"";
        String expected = "SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"");
    }

    @Test
    public void testSelectQueryWithOrderByClause1() {
        String query = "select \"product_id\", \"net_weight\" from \"product\" order by \"net_weight\"";
        String expected = "SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"");
    }

    @Test
    public void testSelectQueryWithTwoOrderByClause() {
        String query = "select \"product_id\"  from \"product\" order by \"net_weight\", \"gross_weight\"";
        String expected = "SELECT \"product_id\", \"net_weight\", \"gross_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\", \"gross_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\"");
    }

    @Test
    public void testSelectQueryWithAscDescOrderByClause() {
        String query = "select \"product_id\" from \"product\" order by \"net_weight\" asc, \"gross_weight\" desc, \"low_fat\"";
        String expected = "SELECT \"product_id\", \"net_weight\", \"gross_weight\", \"low_fat\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\" DESC, \"low_fat\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\", \"gross_weight\", \"low_fat\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\" DESC, \"low_fat\"");
    }

    @Test
    public void testHiveSelectCharset() {
        String query = "select \"hire_date\", cast(\"hire_date\" as varchar(10)) from \"foodmart\".\"reserve_employee\"";
        String expected = "SELECT hire_date, CAST(hire_date AS VARCHAR(10))\nFROM foodmart.reserve_employee";
        this.sql(query).withHive().ok("SELECT hire_date, CAST(hire_date AS VARCHAR(10))\nFROM foodmart.reserve_employee");
    }

    @Test
    public void testMssqlCharacterSet() {
        String query = "select \"hire_date\", cast(\"hire_date\" as varchar(10))\nfrom \"foodmart\".\"reserve_employee\"";
        String expected = "SELECT [hire_date], CAST([hire_date] AS VARCHAR(10))\nFROM [foodmart].[reserve_employee]";
        this.sql(query).withMssql().ok("SELECT [hire_date], CAST([hire_date] AS VARCHAR(10))\nFROM [foodmart].[reserve_employee]");
    }

    @Test
    public void testUnparseIn1() {
        RelBuilder builder = RelToSqlConverterTest.relBuilder().scan(new String[]{"EMP"});
        RexNode condition = builder.call((SqlOperator)SqlStdOperatorTable.IN, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)21)});
        RelNode root = RelToSqlConverterTest.relBuilder().scan(new String[]{"EMP"}).filter(new RexNode[]{condition}).build();
        String sql = this.toSql(root);
        String expectedSql = "SELECT *\nFROM \"scott\".\"EMP\"\nWHERE \"DEPTNO\" IN (21)";
        Assert.assertThat((Object)sql, Matchers.isLinux("SELECT *\nFROM \"scott\".\"EMP\"\nWHERE \"DEPTNO\" IN (21)"));
    }

    @Test
    public void testUnparseIn2() {
        RelBuilder builder = RelToSqlConverterTest.relBuilder();
        RelNode rel = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.IN, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20), builder.literal((Object)21)})}).build();
        String sql = this.toSql(rel);
        String expectedSql = "SELECT *\nFROM \"scott\".\"EMP\"\nWHERE \"DEPTNO\" IN (20, 21)";
        Assert.assertThat((Object)sql, Matchers.isLinux("SELECT *\nFROM \"scott\".\"EMP\"\nWHERE \"DEPTNO\" IN (20, 21)"));
    }

    @Test
    public void testUnparseInStruct1() {
        RelBuilder builder = RelToSqlConverterTest.relBuilder().scan(new String[]{"EMP"});
        RexNode condition = builder.call((SqlOperator)SqlStdOperatorTable.IN, new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.ROW, new RexNode[]{builder.field("DEPTNO"), builder.field("JOB")}), builder.call((SqlOperator)SqlStdOperatorTable.ROW, new RexNode[]{builder.literal((Object)1), builder.literal((Object)"PRESIDENT")})});
        RelNode root = RelToSqlConverterTest.relBuilder().scan(new String[]{"EMP"}).filter(new RexNode[]{condition}).build();
        String sql = this.toSql(root);
        String expectedSql = "SELECT *\nFROM \"scott\".\"EMP\"\nWHERE ROW(\"DEPTNO\", \"JOB\") IN (ROW(1, 'PRESIDENT'))";
        Assert.assertThat((Object)sql, Matchers.isLinux("SELECT *\nFROM \"scott\".\"EMP\"\nWHERE ROW(\"DEPTNO\", \"JOB\") IN (ROW(1, 'PRESIDENT'))"));
    }

    @Test
    public void testUnparseInStruct2() {
        RelBuilder builder = RelToSqlConverterTest.relBuilder().scan(new String[]{"EMP"});
        RexNode condition = builder.call((SqlOperator)SqlStdOperatorTable.IN, new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.ROW, new RexNode[]{builder.field("DEPTNO"), builder.field("JOB")}), builder.call((SqlOperator)SqlStdOperatorTable.ROW, new RexNode[]{builder.literal((Object)1), builder.literal((Object)"PRESIDENT")}), builder.call((SqlOperator)SqlStdOperatorTable.ROW, new RexNode[]{builder.literal((Object)2), builder.literal((Object)"PRESIDENT")})});
        RelNode root = RelToSqlConverterTest.relBuilder().scan(new String[]{"EMP"}).filter(new RexNode[]{condition}).build();
        String sql = this.toSql(root);
        String expectedSql = "SELECT *\nFROM \"scott\".\"EMP\"\nWHERE ROW(\"DEPTNO\", \"JOB\") IN (ROW(1, 'PRESIDENT'), ROW(2, 'PRESIDENT'))";
        Assert.assertThat((Object)sql, Matchers.isLinux("SELECT *\nFROM \"scott\".\"EMP\"\nWHERE ROW(\"DEPTNO\", \"JOB\") IN (ROW(1, 'PRESIDENT'), ROW(2, 'PRESIDENT'))"));
    }

    @Test
    public void testSelectQueryWithLimitClause() {
        String query = "select \"product_id\"  from \"product\" limit 100 offset 10";
        String expected = "SELECT product_id\nFROM foodmart.product\nLIMIT 100\nOFFSET 10";
        this.sql(query).withHive().ok("SELECT product_id\nFROM foodmart.product\nLIMIT 100\nOFFSET 10");
    }

    @Test
    public void testHiveSelectQueryWithOrderByDescAndNullsFirstShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT product_id\nFROM foodmart.product\nORDER BY product_id IS NULL DESC, product_id DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect(HiveSqlDialect.DEFAULT).ok("SELECT product_id\nFROM foodmart.product\nORDER BY product_id IS NULL DESC, product_id DESC");
    }

    @Test
    public void testHiveSelectQueryWithOrderByAscAndNullsLastShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls last";
        String expected = "SELECT product_id\nFROM foodmart.product\nORDER BY product_id IS NULL, product_id";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls last").dialect(HiveSqlDialect.DEFAULT).ok("SELECT product_id\nFROM foodmart.product\nORDER BY product_id IS NULL, product_id");
    }

    @Test
    public void testHiveSelectQueryWithOrderByAscNullsFirstShouldNotAddNullEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls first";
        String expected = "SELECT product_id\nFROM foodmart.product\nORDER BY product_id";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls first").dialect(HiveSqlDialect.DEFAULT).ok("SELECT product_id\nFROM foodmart.product\nORDER BY product_id");
    }

    @Test
    public void testHiveSelectQueryWithOrderByDescNullsLastShouldNotAddNullEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last";
        String expected = "SELECT product_id\nFROM foodmart.product\nORDER BY product_id DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last").dialect(HiveSqlDialect.DEFAULT).ok("SELECT product_id\nFROM foodmart.product\nORDER BY product_id DESC");
    }

    @Test
    public void testMysqlCastToBigint() {
        String query = "select cast(\"product_id\" as bigint) from \"product\"";
        String expected = "SELECT CAST(`product_id` AS SIGNED)\nFROM `foodmart`.`product`";
        this.sql("select cast(\"product_id\" as bigint) from \"product\"").withMysql().ok("SELECT CAST(`product_id` AS SIGNED)\nFROM `foodmart`.`product`");
    }

    @Test
    public void testMysqlCastToInteger() {
        String query = "select \"employee_id\",\n  cast(\"salary_paid\" * 10000 as integer)\nfrom \"salary\"";
        String expected = "SELECT `employee_id`, CAST(`salary_paid` * 10000 AS SIGNED)\nFROM `foodmart`.`salary`";
        this.sql("select \"employee_id\",\n  cast(\"salary_paid\" * 10000 as integer)\nfrom \"salary\"").withMysql().ok("SELECT `employee_id`, CAST(`salary_paid` * 10000 AS SIGNED)\nFROM `foodmart`.`salary`");
    }

    @Test
    public void testHiveSelectQueryWithOrderByDescAndHighNullsWithVersionGreaterThanOrEq21() {
        HiveSqlDialect hive2_1Dialect = new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT.withDatabaseMajorVersion(2).withDatabaseMinorVersion(1).withNullCollation(NullCollation.LOW));
        HiveSqlDialect hive2_2_Dialect = new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT.withDatabaseMajorVersion(2).withDatabaseMinorVersion(2).withNullCollation(NullCollation.LOW));
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT product_id\nFROM foodmart.product\nORDER BY product_id DESC NULLS FIRST";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect((SqlDialect)hive2_1Dialect).ok("SELECT product_id\nFROM foodmart.product\nORDER BY product_id DESC NULLS FIRST");
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect((SqlDialect)hive2_2_Dialect).ok("SELECT product_id\nFROM foodmart.product\nORDER BY product_id DESC NULLS FIRST");
    }

    @Test
    public void testHiveSelectQueryWithOrderByDescAndHighNullsWithVersion20() {
        HiveSqlDialect hive2_1_0_Dialect = new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT.withDatabaseMajorVersion(2).withDatabaseMinorVersion(0).withNullCollation(NullCollation.LOW));
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT product_id\nFROM foodmart.product\nORDER BY product_id IS NULL DESC, product_id DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect((SqlDialect)hive2_1_0_Dialect).ok("SELECT product_id\nFROM foodmart.product\nORDER BY product_id IS NULL DESC, product_id DESC");
    }

    @Test
    public void testJethroDataSelectQueryWithOrderByDescAndNullsFirstShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nORDER BY \"product_id\", \"product_id\" DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect((SqlDialect)RelToSqlConverterTest.jethroDataSqlDialect()).ok("SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nORDER BY \"product_id\", \"product_id\" DESC");
    }

    @Test
    public void testMySqlSelectQueryWithOrderByDescAndNullsFirstShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect(MysqlSqlDialect.DEFAULT).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id` DESC");
    }

    @Test
    public void testMySqlSelectQueryWithOrderByAscAndNullsLastShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls last").dialect(MysqlSqlDialect.DEFAULT).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id`");
    }

    @Test
    public void testMySqlSelectQueryWithOrderByAscNullsFirstShouldNotAddNullEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls first").dialect(MysqlSqlDialect.DEFAULT).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`");
    }

    @Test
    public void testMySqlSelectQueryWithOrderByDescNullsLastShouldNotAddNullEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last").dialect(MysqlSqlDialect.DEFAULT).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC");
    }

    @Test
    public void testMySqlWithHighNullsSelectWithOrderByAscNullsLastAndNoEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls last").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.HIGH)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`");
    }

    @Test
    public void testMySqlWithHighNullsSelectWithOrderByAscNullsFirstAndNullEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls first").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.HIGH)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id`");
    }

    @Test
    public void testMySqlWithHighNullsSelectWithOrderByDescNullsFirstAndNoEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.HIGH)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC");
    }

    @Test
    public void testMySqlWithHighNullsSelectWithOrderByDescNullsLastAndNullEmulation() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.HIGH)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id` DESC");
    }

    @Test
    public void testMySqlWithFirstNullsSelectWithOrderByDescAndNullsFirstShouldNotBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.FIRST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC");
    }

    @Test
    public void testMySqlWithFirstNullsSelectWithOrderByAscAndNullsFirstShouldNotBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls first").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.FIRST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`");
    }

    @Test
    public void testMySqlWithFirstNullsSelectWithOrderByDescAndNullsLastShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.FIRST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id` DESC");
    }

    @Test
    public void testMySqlWithFirstNullsSelectWithOrderByAscAndNullsLastShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls last").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.FIRST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL, `product_id`");
    }

    @Test
    public void testMySqlWithLastNullsSelectWithOrderByDescAndNullsFirstShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls first").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.LAST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id` DESC");
    }

    @Test
    public void testMySqlWithLastNullsSelectWithOrderByAscAndNullsFirstShouldBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls first";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls first").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.LAST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` IS NULL DESC, `product_id`");
    }

    @Test
    public void testMySqlWithLastNullsSelectWithOrderByDescAndNullsLastShouldNotBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" desc nulls last").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.LAST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id` DESC");
    }

    @Test
    public void testMySqlWithLastNullsSelectWithOrderByAscAndNullsLastShouldNotBeEmulated() {
        String query = "select \"product_id\" from \"product\"\norder by \"product_id\" nulls last";
        String expected = "SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`";
        this.sql("select \"product_id\" from \"product\"\norder by \"product_id\" nulls last").dialect((SqlDialect)RelToSqlConverterTest.mySqlDialect(NullCollation.LAST)).ok("SELECT `product_id`\nFROM `foodmart`.`product`\nORDER BY `product_id`");
    }

    @Test
    public void testSelectQueryWithLimitClauseWithoutOrder() {
        String query = "select \"product_id\"  from \"product\" limit 100 offset 10";
        String expected = "SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY";
        this.sql(query).ok("SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY");
    }

    @Test
    public void testSelectQueryWithLimitOffsetClause() {
        String query = "select \"product_id\"  from \"product\" order by \"net_weight\" asc limit 100 offset 10";
        String expected = "SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY");
    }

    @Test
    public void testSelectQueryWithParameters() {
        String query = "select * from \"product\" where \"product_id\" = ? AND ? >= \"shelf_width\"";
        String expected = "SELECT *\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" = ? AND ? >= \"shelf_width\"";
        this.sql(query).ok("SELECT *\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" = ? AND ? >= \"shelf_width\"");
    }

    @Test
    public void testSelectQueryWithFetchOffsetClause() {
        String query = "select \"product_id\"  from \"product\" order by \"product_id\" offset 10 rows fetch next 100 rows only";
        String expected = "SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nORDER BY \"product_id\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY";
        this.sql(query).ok("SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nORDER BY \"product_id\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY");
    }

    @Test
    public void testSelectQueryComplex() {
        String query = "select count(*), \"units_per_case\" from \"product\" where \"cases_per_pallet\" > 100 group by \"product_id\", \"units_per_case\" order by \"units_per_case\" desc";
        String expected = "SELECT COUNT(*), \"units_per_case\"\nFROM \"foodmart\".\"product\"\nWHERE \"cases_per_pallet\" > 100\nGROUP BY \"product_id\", \"units_per_case\"\nORDER BY \"units_per_case\" DESC";
        this.sql(query).ok("SELECT COUNT(*), \"units_per_case\"\nFROM \"foodmart\".\"product\"\nWHERE \"cases_per_pallet\" > 100\nGROUP BY \"product_id\", \"units_per_case\"\nORDER BY \"units_per_case\" DESC");
    }

    @Test
    public void testSelectQueryWithGroup() {
        String query = "select count(*), sum(\"employee_id\") from \"reserve_employee\" where \"hire_date\" > '2015-01-01' and (\"position_title\" = 'SDE' or \"position_title\" = 'SDM') group by \"store_id\", \"position_title\"";
        String expected = "SELECT COUNT(*), SUM(\"employee_id\")\nFROM \"foodmart\".\"reserve_employee\"\nWHERE \"hire_date\" > '2015-01-01' AND (\"position_title\" = 'SDE' OR \"position_title\" = 'SDM')\nGROUP BY \"store_id\", \"position_title\"";
        this.sql(query).ok("SELECT COUNT(*), SUM(\"employee_id\")\nFROM \"foodmart\".\"reserve_employee\"\nWHERE \"hire_date\" > '2015-01-01' AND (\"position_title\" = 'SDE' OR \"position_title\" = 'SDM')\nGROUP BY \"store_id\", \"position_title\"");
    }

    @Test
    public void testSimpleJoin() {
        String query = "select *\nfrom \"sales_fact_1997\" as s\njoin \"customer\" as c on s.\"customer_id\" = c.\"customer_id\"\njoin \"product\" as p on s.\"product_id\" = p.\"product_id\"\njoin \"product_class\" as pc\n  on p.\"product_class_id\" = pc.\"product_class_id\"\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks'\n";
        String expected = "SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks'";
        this.sql(query).ok("SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks'");
    }

    @Test
    public void testSimpleJoinUsing() {
        String query = "select *\nfrom \"sales_fact_1997\" as s\n  join \"customer\" as c using (\"customer_id\")\n  join \"product\" as p using (\"product_id\")\n  join \"product_class\" as pc using (\"product_class_id\")\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks'\n";
        String expected = "SELECT \"product\".\"product_class_id\", \"sales_fact_1997\".\"product_id\", \"sales_fact_1997\".\"customer_id\", \"sales_fact_1997\".\"time_id\", \"sales_fact_1997\".\"promotion_id\", \"sales_fact_1997\".\"store_id\", \"sales_fact_1997\".\"store_sales\", \"sales_fact_1997\".\"store_cost\", \"sales_fact_1997\".\"unit_sales\", \"customer\".\"account_num\", \"customer\".\"lname\", \"customer\".\"fname\", \"customer\".\"mi\", \"customer\".\"address1\", \"customer\".\"address2\", \"customer\".\"address3\", \"customer\".\"address4\", \"customer\".\"city\", \"customer\".\"state_province\", \"customer\".\"postal_code\", \"customer\".\"country\", \"customer\".\"customer_region_id\", \"customer\".\"phone1\", \"customer\".\"phone2\", \"customer\".\"birthdate\", \"customer\".\"marital_status\", \"customer\".\"yearly_income\", \"customer\".\"gender\", \"customer\".\"total_children\", \"customer\".\"num_children_at_home\", \"customer\".\"education\", \"customer\".\"date_accnt_opened\", \"customer\".\"member_card\", \"customer\".\"occupation\", \"customer\".\"houseowner\", \"customer\".\"num_cars_owned\", \"customer\".\"fullname\", \"product\".\"brand_name\", \"product\".\"product_name\", \"product\".\"SKU\", \"product\".\"SRP\", \"product\".\"gross_weight\", \"product\".\"net_weight\", \"product\".\"recyclable_package\", \"product\".\"low_fat\", \"product\".\"units_per_case\", \"product\".\"cases_per_pallet\", \"product\".\"shelf_width\", \"product\".\"shelf_height\", \"product\".\"shelf_depth\", \"product_class\".\"product_subcategory\", \"product_class\".\"product_category\", \"product_class\".\"product_department\", \"product_class\".\"product_family\"\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks'";
        this.sql(query).ok("SELECT \"product\".\"product_class_id\", \"sales_fact_1997\".\"product_id\", \"sales_fact_1997\".\"customer_id\", \"sales_fact_1997\".\"time_id\", \"sales_fact_1997\".\"promotion_id\", \"sales_fact_1997\".\"store_id\", \"sales_fact_1997\".\"store_sales\", \"sales_fact_1997\".\"store_cost\", \"sales_fact_1997\".\"unit_sales\", \"customer\".\"account_num\", \"customer\".\"lname\", \"customer\".\"fname\", \"customer\".\"mi\", \"customer\".\"address1\", \"customer\".\"address2\", \"customer\".\"address3\", \"customer\".\"address4\", \"customer\".\"city\", \"customer\".\"state_province\", \"customer\".\"postal_code\", \"customer\".\"country\", \"customer\".\"customer_region_id\", \"customer\".\"phone1\", \"customer\".\"phone2\", \"customer\".\"birthdate\", \"customer\".\"marital_status\", \"customer\".\"yearly_income\", \"customer\".\"gender\", \"customer\".\"total_children\", \"customer\".\"num_children_at_home\", \"customer\".\"education\", \"customer\".\"date_accnt_opened\", \"customer\".\"member_card\", \"customer\".\"occupation\", \"customer\".\"houseowner\", \"customer\".\"num_cars_owned\", \"customer\".\"fullname\", \"product\".\"brand_name\", \"product\".\"product_name\", \"product\".\"SKU\", \"product\".\"SRP\", \"product\".\"gross_weight\", \"product\".\"net_weight\", \"product\".\"recyclable_package\", \"product\".\"low_fat\", \"product\".\"units_per_case\", \"product\".\"cases_per_pallet\", \"product\".\"shelf_width\", \"product\".\"shelf_height\", \"product\".\"shelf_depth\", \"product_class\".\"product_subcategory\", \"product_class\".\"product_category\", \"product_class\".\"product_department\", \"product_class\".\"product_family\"\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks'");
    }

    @Test
    public void testSubQueryAlias() {
        String query = "select t1.\"customer_id\", t2.\"customer_id\" \nfrom (select \"customer_id\" from \"sales_fact_1997\") as t1 \ninner join (select \"customer_id\" from \"sales_fact_1997\") t2 \non t1.\"customer_id\" = t2.\"customer_id\"";
        String expected = "SELECT *\nFROM (SELECT sales_fact_1997.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_1997) AS t\nINNER JOIN (SELECT sales_fact_19970.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_19970) AS t0 ON t.customer_id = t0.customer_id";
        this.sql(query).withDb2().ok("SELECT *\nFROM (SELECT sales_fact_1997.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_1997) AS t\nINNER JOIN (SELECT sales_fact_19970.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_19970) AS t0 ON t.customer_id = t0.customer_id");
    }

    @Test
    public void testCartesianProductWithCommaSyntax() {
        String query = "select * from \"department\" , \"employee\"";
        String expected = "SELECT *\nFROM \"foodmart\".\"department\",\n\"foodmart\".\"employee\"";
        this.sql(query).ok(expected);
    }

    @Test
    public void testJoinOnBoolean() {
        String sql = "SELECT 1\nfrom emps\njoin emp on (emp.deptno = emps.empno and manager)";
        String s = this.sql("SELECT 1\nfrom emps\njoin emp on (emp.deptno = emps.empno and manager)").schema(CalciteAssert.SchemaSpec.POST).exec();
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCartesianProductWithInnerJoinSyntax() {
        String query = "select * from \"department\"\nINNER JOIN \"employee\" ON TRUE";
        String expected = "SELECT *\nFROM \"foodmart\".\"department\",\n\"foodmart\".\"employee\"";
        this.sql(query).ok(expected);
    }

    @Test
    public void testFullJoinOnTrueCondition() {
        String query = "select * from \"department\"\nFULL JOIN \"employee\" ON TRUE";
        String expected = "SELECT *\nFROM \"foodmart\".\"department\"\nFULL JOIN \"foodmart\".\"employee\" ON TRUE";
        this.sql(query).ok(expected);
    }

    @Test
    public void testSimpleIn() {
        String query = "select * from \"department\" where \"department_id\" in (\n  select \"department_id\" from \"employee\"\n  where \"store_id\" < 150)";
        String expected = "SELECT \"department\".\"department_id\", \"department\".\"department_description\"\nFROM \"foodmart\".\"department\"\nINNER JOIN (SELECT \"department_id\"\nFROM \"foodmart\".\"employee\"\nWHERE \"store_id\" < 150\nGROUP BY \"department_id\") AS \"t1\" ON \"department\".\"department_id\" = \"t1\".\"department_id\"";
        this.sql(query).ok("SELECT \"department\".\"department_id\", \"department\".\"department_description\"\nFROM \"foodmart\".\"department\"\nINNER JOIN (SELECT \"department_id\"\nFROM \"foodmart\".\"employee\"\nWHERE \"store_id\" < 150\nGROUP BY \"department_id\") AS \"t1\" ON \"department\".\"department_id\" = \"t1\".\"department_id\"");
    }

    @Test
    public void testDb2DialectJoinStar() {
        String query = "select * from \"foodmart\".\"employee\" A join \"foodmart\".\"department\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id";
        this.sql(query).withDb2().ok("SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id");
    }

    @Test
    public void testDb2DialectSelfJoinStar() {
        String query = "select * from \"foodmart\".\"employee\" A join \"foodmart\".\"employee\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id";
        this.sql(query).withDb2().ok("SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id");
    }

    @Test
    public void testDb2DialectJoin() {
        String query = "select A.\"employee_id\", B.\"department_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"department\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id";
        this.sql(query).withDb2().ok("SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id");
    }

    @Test
    public void testDb2DialectSelfJoin() {
        String query = "select A.\"employee_id\", B.\"employee_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"employee\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id";
        this.sql(query).withDb2().ok("SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id");
    }

    @Test
    public void testDb2DialectWhere() {
        String query = "select A.\"employee_id\" from \"foodmart\".\"employee\" A where A.\"department_id\" < 1000";
        String expected = "SELECT employee.employee_id\nFROM foodmart.employee AS employee\nWHERE employee.department_id < 1000";
        this.sql(query).withDb2().ok("SELECT employee.employee_id\nFROM foodmart.employee AS employee\nWHERE employee.department_id < 1000");
    }

    @Test
    public void testDb2DialectJoinWhere() {
        String query = "select A.\"employee_id\", B.\"department_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"department\" B\non A.\"department_id\" = B.\"department_id\" where A.\"employee_id\" < 1000";
        String expected = "SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id\nWHERE employee.employee_id < 1000";
        this.sql(query).withDb2().ok("SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id\nWHERE employee.employee_id < 1000");
    }

    @Test
    public void testDb2DialectSelfJoinWhere() {
        String query = "select A.\"employee_id\", B.\"employee_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"employee\" B\non A.\"department_id\" = B.\"department_id\" where B.\"employee_id\" < 2000";
        String expected = "SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id\nWHERE employee0.employee_id < 2000";
        this.sql(query).withDb2().ok("SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id\nWHERE employee0.employee_id < 2000");
    }

    @Test
    public void testDb2DialectCast() {
        String query = "select \"hire_date\", cast(\"hire_date\" as varchar(10)) from \"foodmart\".\"reserve_employee\"";
        String expected = "SELECT reserve_employee.hire_date, CAST(reserve_employee.hire_date AS VARCHAR(10))\nFROM foodmart.reserve_employee AS reserve_employee";
        this.sql(query).withDb2().ok("SELECT reserve_employee.hire_date, CAST(reserve_employee.hire_date AS VARCHAR(10))\nFROM foodmart.reserve_employee AS reserve_employee");
    }

    @Test
    public void testDb2DialectSelectQueryWithGroupByHaving() {
        String query = "select count(*) from \"product\" group by \"product_class_id\", \"product_id\" having \"product_id\"  > 10";
        String expected = "SELECT COUNT(*)\nFROM foodmart.product AS product\nGROUP BY product.product_class_id, product.product_id\nHAVING product.product_id > 10";
        this.sql(query).withDb2().ok("SELECT COUNT(*)\nFROM foodmart.product AS product\nGROUP BY product.product_class_id, product.product_id\nHAVING product.product_id > 10");
    }

    @Test
    public void testDb2DialectSelectQueryComplex() {
        String query = "select count(*), \"units_per_case\" from \"product\" where \"cases_per_pallet\" > 100 group by \"product_id\", \"units_per_case\" order by \"units_per_case\" desc";
        String expected = "SELECT COUNT(*), product.units_per_case\nFROM foodmart.product AS product\nWHERE product.cases_per_pallet > 100\nGROUP BY product.product_id, product.units_per_case\nORDER BY product.units_per_case DESC";
        this.sql(query).withDb2().ok("SELECT COUNT(*), product.units_per_case\nFROM foodmart.product AS product\nWHERE product.cases_per_pallet > 100\nGROUP BY product.product_id, product.units_per_case\nORDER BY product.units_per_case DESC");
    }

    @Test
    public void testDb2DialectSelectQueryWithGroup() {
        String query = "select count(*), sum(\"employee_id\") from \"reserve_employee\" where \"hire_date\" > '2015-01-01' and (\"position_title\" = 'SDE' or \"position_title\" = 'SDM') group by \"store_id\", \"position_title\"";
        String expected = "SELECT COUNT(*), SUM(reserve_employee.employee_id)\nFROM foodmart.reserve_employee AS reserve_employee\nWHERE reserve_employee.hire_date > '2015-01-01' AND (reserve_employee.position_title = 'SDE' OR reserve_employee.position_title = 'SDM')\nGROUP BY reserve_employee.store_id, reserve_employee.position_title";
        this.sql(query).withDb2().ok("SELECT COUNT(*), SUM(reserve_employee.employee_id)\nFROM foodmart.reserve_employee AS reserve_employee\nWHERE reserve_employee.hire_date > '2015-01-01' AND (reserve_employee.position_title = 'SDE' OR reserve_employee.position_title = 'SDM')\nGROUP BY reserve_employee.store_id, reserve_employee.position_title");
    }

    @Test
    public void testJoinPlan2() {
        String sql = "SELECT v1.deptno, v2.deptno\nFROM dept v1 LEFT JOIN emp v2 ON v1.deptno = v2.deptno\nWHERE v2.job LIKE 'PRESIDENT'";
        String expected = "SELECT \"DEPT\".\"DEPTNO\", \"EMP\".\"DEPTNO\" AS \"DEPTNO0\"\nFROM \"JDBC_SCOTT\".\"DEPT\"\nLEFT JOIN \"JDBC_SCOTT\".\"EMP\" ON \"DEPT\".\"DEPTNO\" = \"EMP\".\"DEPTNO\"\nWHERE \"EMP\".\"JOB\" LIKE 'PRESIDENT'";
        String expected2 = "SELECT DEPT.DEPTNO, EMP.DEPTNO AS DEPTNO0\nFROM JDBC_SCOTT.DEPT AS DEPT\nLEFT JOIN JDBC_SCOTT.EMP AS EMP ON DEPT.DEPTNO = EMP.DEPTNO\nWHERE EMP.JOB LIKE 'PRESIDENT'";
        this.sql("SELECT v1.deptno, v2.deptno\nFROM dept v1 LEFT JOIN emp v2 ON v1.deptno = v2.deptno\nWHERE v2.job LIKE 'PRESIDENT'").schema(CalciteAssert.SchemaSpec.JDBC_SCOTT).ok("SELECT \"DEPT\".\"DEPTNO\", \"EMP\".\"DEPTNO\" AS \"DEPTNO0\"\nFROM \"JDBC_SCOTT\".\"DEPT\"\nLEFT JOIN \"JDBC_SCOTT\".\"EMP\" ON \"DEPT\".\"DEPTNO\" = \"EMP\".\"DEPTNO\"\nWHERE \"EMP\".\"JOB\" LIKE 'PRESIDENT'").withDb2().ok("SELECT DEPT.DEPTNO, EMP.DEPTNO AS DEPTNO0\nFROM JDBC_SCOTT.DEPT AS DEPT\nLEFT JOIN JDBC_SCOTT.EMP AS EMP ON DEPT.DEPTNO = EMP.DEPTNO\nWHERE EMP.JOB LIKE 'PRESIDENT'");
    }

    @Test
    public void testSimpleJoinConditionWithIsNullOperators() {
        String query = "select *\nfrom \"foodmart\".\"sales_fact_1997\" as \"t1\"\ninner join \"foodmart\".\"customer\" as \"t2\"\non \"t1\".\"customer_id\" = \"t2\".\"customer_id\" or (\"t1\".\"customer_id\" is null and \"t2\".\"customer_id\" is null) or\n\"t2\".\"occupation\" is null\ninner join \"foodmart\".\"product\" as \"t3\"\non \"t1\".\"product_id\" = \"t3\".\"product_id\" or (\"t1\".\"product_id\" is not null or \"t3\".\"product_id\" is not null)";
        String expected = "SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" OR FALSE AND FALSE OR \"customer\".\"occupation\" IS NULL\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" OR TRUE OR TRUE";
        this.sql(query).ok(expected);
    }

    @Test
    public void testThreeQueryUnion() {
        String query = "SELECT \"product_id\" FROM \"product\"  UNION ALL SELECT \"product_id\" FROM \"sales_fact_1997\"  UNION ALL SELECT \"product_class_id\" AS product_id FROM \"product_class\"";
        String expected = "SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nUNION ALL\nSELECT \"product_id\"\nFROM \"foodmart\".\"sales_fact_1997\"\nUNION ALL\nSELECT \"product_class_id\" AS \"PRODUCT_ID\"\nFROM \"foodmart\".\"product_class\"";
        HepProgram program = new HepProgramBuilder().addRuleClass(UnionMergeRule.class).build();
        RuleSet rules = RuleSets.ofList((RelOptRule[])new RelOptRule[]{UnionMergeRule.INSTANCE});
        this.sql(query).optimize(rules, (RelOptPlanner)new HepPlanner(program)).ok(expected);
    }

    @Test
    public void testUnionWrappedInASelect() {
        String query = "select sum(\n  case when \"product_id\"=0 then \"net_weight\" else 0 end) as net_weight\nfrom (\n  select \"product_id\", \"net_weight\"\n  from \"product\"\n  union all\n  select \"product_id\", 0 as \"net_weight\"\n  from \"sales_fact_1997\") t0";
        String expected = "SELECT SUM(CASE WHEN \"product_id\" = 0 THEN \"net_weight\" ELSE 0 END) AS \"NET_WEIGHT\"\nFROM (SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nUNION ALL\nSELECT \"product_id\", 0 AS \"net_weight\"\nFROM \"foodmart\".\"sales_fact_1997\") AS \"t1\"";
        this.sql("select sum(\n  case when \"product_id\"=0 then \"net_weight\" else 0 end) as net_weight\nfrom (\n  select \"product_id\", \"net_weight\"\n  from \"product\"\n  union all\n  select \"product_id\", 0 as \"net_weight\"\n  from \"sales_fact_1997\") t0").ok("SELECT SUM(CASE WHEN \"product_id\" = 0 THEN \"net_weight\" ELSE 0 END) AS \"NET_WEIGHT\"\nFROM (SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nUNION ALL\nSELECT \"product_id\", 0 AS \"net_weight\"\nFROM \"foodmart\".\"sales_fact_1997\") AS \"t1\"");
    }

    @Test
    public void testLiteral() {
        this.checkLiteral("DATE '1978-05-02'");
        this.checkLiteral2("DATE '1978-5-2'", "DATE '1978-05-02'");
        this.checkLiteral("TIME '12:34:56'");
        this.checkLiteral("TIME '12:34:56.78'");
        this.checkLiteral2("TIME '1:4:6.080'", "TIME '01:04:06.080'");
        this.checkLiteral("TIMESTAMP '1978-05-02 12:34:56.78'");
        this.checkLiteral2("TIMESTAMP '1978-5-2 2:4:6.80'", "TIMESTAMP '1978-05-02 02:04:06.80'");
        this.checkLiteral("'I can''t explain'");
        this.checkLiteral("''");
        this.checkLiteral("TRUE");
        this.checkLiteral("123");
        this.checkLiteral("123.45");
        this.checkLiteral("-123.45");
        this.checkLiteral("INTERVAL '1-2' YEAR TO MONTH");
        this.checkLiteral("INTERVAL -'1-2' YEAR TO MONTH");
        this.checkLiteral("INTERVAL '12-11' YEAR TO MONTH");
        this.checkLiteral("INTERVAL '1' YEAR");
        this.checkLiteral("INTERVAL '1' MONTH");
        this.checkLiteral("INTERVAL '12' DAY");
        this.checkLiteral("INTERVAL -'12' DAY");
        this.checkLiteral2("INTERVAL '1 2' DAY TO HOUR", "INTERVAL '1 02' DAY TO HOUR");
        this.checkLiteral2("INTERVAL '1 2:10' DAY TO MINUTE", "INTERVAL '1 02:10' DAY TO MINUTE");
        this.checkLiteral2("INTERVAL '1 2:00' DAY TO MINUTE", "INTERVAL '1 02:00' DAY TO MINUTE");
        this.checkLiteral2("INTERVAL '1 2:34:56' DAY TO SECOND", "INTERVAL '1 02:34:56' DAY TO SECOND");
        this.checkLiteral2("INTERVAL '1 2:34:56.789' DAY TO SECOND", "INTERVAL '1 02:34:56.789' DAY TO SECOND");
        this.checkLiteral2("INTERVAL '1 2:34:56.78' DAY TO SECOND", "INTERVAL '1 02:34:56.78' DAY TO SECOND");
        this.checkLiteral2("INTERVAL '1 2:34:56.078' DAY TO SECOND", "INTERVAL '1 02:34:56.078' DAY TO SECOND");
        this.checkLiteral2("INTERVAL -'1 2:34:56.078' DAY TO SECOND", "INTERVAL -'1 02:34:56.078' DAY TO SECOND");
        this.checkLiteral2("INTERVAL '1 2:3:5.070' DAY TO SECOND", "INTERVAL '1 02:03:05.07' DAY TO SECOND");
        this.checkLiteral("INTERVAL '1:23' HOUR TO MINUTE");
        this.checkLiteral("INTERVAL '1:02' HOUR TO MINUTE");
        this.checkLiteral("INTERVAL -'1:02' HOUR TO MINUTE");
        this.checkLiteral("INTERVAL '1:23:45' HOUR TO SECOND");
        this.checkLiteral("INTERVAL '1:03:05' HOUR TO SECOND");
        this.checkLiteral("INTERVAL '1:23:45.678' HOUR TO SECOND");
        this.checkLiteral("INTERVAL '1:03:05.06' HOUR TO SECOND");
        this.checkLiteral("INTERVAL '12' MINUTE");
        this.checkLiteral("INTERVAL '12:34' MINUTE TO SECOND");
        this.checkLiteral("INTERVAL '12:34.567' MINUTE TO SECOND");
        this.checkLiteral("INTERVAL '12' SECOND");
        this.checkLiteral("INTERVAL '12.345' SECOND");
    }

    private void checkLiteral(String expression) {
        this.checkLiteral2(expression, expression);
    }

    private void checkLiteral2(String expression, String expected) {
        this.sql("VALUES " + expression).withHsqldb().ok("SELECT *\nFROM (VALUES  (" + expected + ")) AS t (EXPR$0)");
    }

    @Test
    public void testFloor() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE) FROM \"employee\"";
        String expected = "SELECT TRUNC(hire_date, 'MI')\nFROM foodmart.employee";
        this.sql(query).withHsqldb().ok(expected);
    }

    @Test
    public void testFloorPostgres() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE) FROM \"employee\"";
        String expected = "SELECT DATE_TRUNC('MINUTE', \"hire_date\")\nFROM \"foodmart\".\"employee\"";
        this.sql(query).withPostgresql().ok(expected);
    }

    @Test
    public void testFloorOracle() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE) FROM \"employee\"";
        String expected = "SELECT TRUNC(\"hire_date\", 'MINUTE')\nFROM \"foodmart\".\"employee\"";
        this.sql(query).withOracle().ok(expected);
    }

    @Test
    public void testFloorMssqlWeek() {
        String query = "SELECT floor(\"hire_date\" TO WEEK) FROM \"employee\"";
        String expected = "SELECT CONVERT(DATETIME, CONVERT(VARCHAR(10), DATEADD(day, - (6 + DATEPART(weekday, [hire_date] )) % 7, [hire_date] ), 126))\nFROM [foodmart].[employee]";
        this.sql(query).withMssql().ok(expected);
    }

    @Test
    public void testFloorMssqlMonth() {
        String query = "SELECT floor(\"hire_date\" TO MONTH) FROM \"employee\"";
        String expected = "SELECT CONVERT(DATETIME, CONVERT(VARCHAR(7), [hire_date] , 126)+'-01')\nFROM [foodmart].[employee]";
        this.sql(query).withMssql().ok(expected);
    }

    @Test
    public void testFloorMysqlMonth() {
        String query = "SELECT floor(\"hire_date\" TO MONTH) FROM \"employee\"";
        String expected = "SELECT DATE_FORMAT(`hire_date`, '%Y-%m-01')\nFROM `foodmart`.`employee`";
        this.sql(query).withMysql().ok(expected);
    }

    @Test
    public void testUnparseSqlIntervalQualifierDb2() {
        String queryDatePlus = "select  * from \"employee\" where  \"hire_date\" + INTERVAL '19800' SECOND(5) > TIMESTAMP '2005-10-17 00:00:00' ";
        String expectedDatePlus = "SELECT *\nFROM foodmart.employee AS employee\nWHERE (employee.hire_date + 19800 SECOND) > TIMESTAMP '2005-10-17 00:00:00'";
        this.sql(queryDatePlus).withDb2().ok(expectedDatePlus);
        String queryDateMinus = "select  * from \"employee\" where  \"hire_date\" - INTERVAL '19800' SECOND(5) > TIMESTAMP '2005-10-17 00:00:00' ";
        String expectedDateMinus = "SELECT *\nFROM foodmart.employee AS employee\nWHERE (employee.hire_date - 19800 SECOND) > TIMESTAMP '2005-10-17 00:00:00'";
        this.sql(queryDateMinus).withDb2().ok(expectedDateMinus);
    }

    @Test
    public void testUnparseSqlIntervalQualifierMySql() {
        String sql0 = "select  * from \"employee\" where  \"hire_date\" - INTERVAL '19800' SECOND(5) > TIMESTAMP '2005-10-17 00:00:00' ";
        String expect0 = "SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` - INTERVAL '19800' SECOND) > TIMESTAMP '2005-10-17 00:00:00'";
        this.sql("select  * from \"employee\" where  \"hire_date\" - INTERVAL '19800' SECOND(5) > TIMESTAMP '2005-10-17 00:00:00' ").withMysql().ok("SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` - INTERVAL '19800' SECOND) > TIMESTAMP '2005-10-17 00:00:00'");
        String sql1 = "select  * from \"employee\" where  \"hire_date\" + INTERVAL '10' HOUR > TIMESTAMP '2005-10-17 00:00:00' ";
        String expect1 = "SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` + INTERVAL '10' HOUR) > TIMESTAMP '2005-10-17 00:00:00'";
        this.sql("select  * from \"employee\" where  \"hire_date\" + INTERVAL '10' HOUR > TIMESTAMP '2005-10-17 00:00:00' ").withMysql().ok("SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` + INTERVAL '10' HOUR) > TIMESTAMP '2005-10-17 00:00:00'");
        String sql2 = "select  * from \"employee\" where  \"hire_date\" + INTERVAL '1-2' year to month > TIMESTAMP '2005-10-17 00:00:00' ";
        String expect2 = "SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` + INTERVAL '1-2' YEAR_MONTH) > TIMESTAMP '2005-10-17 00:00:00'";
        this.sql("select  * from \"employee\" where  \"hire_date\" + INTERVAL '1-2' year to month > TIMESTAMP '2005-10-17 00:00:00' ").withMysql().ok("SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` + INTERVAL '1-2' YEAR_MONTH) > TIMESTAMP '2005-10-17 00:00:00'");
        String sql3 = "select  * from \"employee\" where  \"hire_date\" + INTERVAL '39:12' MINUTE TO SECOND > TIMESTAMP '2005-10-17 00:00:00' ";
        String expect3 = "SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` + INTERVAL '39:12' MINUTE_SECOND) > TIMESTAMP '2005-10-17 00:00:00'";
        this.sql("select  * from \"employee\" where  \"hire_date\" + INTERVAL '39:12' MINUTE TO SECOND > TIMESTAMP '2005-10-17 00:00:00' ").withMysql().ok("SELECT *\nFROM `foodmart`.`employee`\nWHERE (`hire_date` + INTERVAL '39:12' MINUTE_SECOND) > TIMESTAMP '2005-10-17 00:00:00'");
    }

    @Test
    public void testUnparseSqlIntervalQualifierMsSql() {
        String queryDatePlus = "select  * from \"employee\" where  \"hire_date\" +INTERVAL '19800' SECOND(5) > TIMESTAMP '2005-10-17 00:00:00' ";
        String expectedDatePlus = "SELECT *\nFROM [foodmart].[employee]\nWHERE DATEADD(SECOND, 19800, [hire_date]) > '2005-10-17 00:00:00'";
        this.sql(queryDatePlus).withMssql().ok(expectedDatePlus);
        String queryDateMinus = "select  * from \"employee\" where  \"hire_date\" -INTERVAL '19800' SECOND(5) > TIMESTAMP '2005-10-17 00:00:00' ";
        String expectedDateMinus = "SELECT *\nFROM [foodmart].[employee]\nWHERE DATEADD(SECOND, -19800, [hire_date]) > '2005-10-17 00:00:00'";
        this.sql(queryDateMinus).withMssql().ok(expectedDateMinus);
        String queryDateMinusNegate = "select  * from \"employee\" where  \"hire_date\" -INTERVAL '-19800' SECOND(5) > TIMESTAMP '2005-10-17 00:00:00' ";
        String expectedDateMinusNegate = "SELECT *\nFROM [foodmart].[employee]\nWHERE DATEADD(SECOND, 19800, [hire_date]) > '2005-10-17 00:00:00'";
        this.sql(queryDateMinusNegate).withMssql().ok(expectedDateMinusNegate);
    }

    @Test
    public void testFloorMysqlWeek() {
        String query = "SELECT floor(\"hire_date\" TO WEEK) FROM \"employee\"";
        String expected = "SELECT STR_TO_DATE(DATE_FORMAT(`hire_date` , '%x%v-1'), '%x%v-%w')\nFROM `foodmart`.`employee`";
        this.sql(query).withMysql().ok(expected);
    }

    @Test
    public void testFloorMysqlHour() {
        String query = "SELECT floor(\"hire_date\" TO HOUR) FROM \"employee\"";
        String expected = "SELECT DATE_FORMAT(`hire_date`, '%Y-%m-%d %H:00:00')\nFROM `foodmart`.`employee`";
        this.sql(query).withMysql().ok(expected);
    }

    @Test
    public void testFloorMysqlMinute() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE) FROM \"employee\"";
        String expected = "SELECT DATE_FORMAT(`hire_date`, '%Y-%m-%d %H:%i:00')\nFROM `foodmart`.`employee`";
        this.sql(query).withMysql().ok(expected);
    }

    @Test
    public void testFloorMysqlSecond() {
        String query = "SELECT floor(\"hire_date\" TO SECOND) FROM \"employee\"";
        String expected = "SELECT DATE_FORMAT(`hire_date`, '%Y-%m-%d %H:%i:%s')\nFROM `foodmart`.`employee`";
        this.sql(query).withMysql().ok(expected);
    }

    @Test
    public void testFloorWithGroupBy() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE)\nFROM \"employee\"\nGROUP BY floor(\"hire_date\" TO MINUTE)";
        String expected = "SELECT TRUNC(hire_date, 'MI')\nFROM foodmart.employee\nGROUP BY TRUNC(hire_date, 'MI')";
        String expectedOracle = "SELECT TRUNC(\"hire_date\", 'MINUTE')\nFROM \"foodmart\".\"employee\"\nGROUP BY TRUNC(\"hire_date\", 'MINUTE')";
        String expectedPostgresql = "SELECT DATE_TRUNC('MINUTE', \"hire_date\")\nFROM \"foodmart\".\"employee\"\nGROUP BY DATE_TRUNC('MINUTE', \"hire_date\")";
        String expectedMysql = "SELECT DATE_FORMAT(`hire_date`, '%Y-%m-%d %H:%i:00')\nFROM `foodmart`.`employee`\nGROUP BY DATE_FORMAT(`hire_date`, '%Y-%m-%d %H:%i:00')";
        this.sql("SELECT floor(\"hire_date\" TO MINUTE)\nFROM \"employee\"\nGROUP BY floor(\"hire_date\" TO MINUTE)").withHsqldb().ok("SELECT TRUNC(hire_date, 'MI')\nFROM foodmart.employee\nGROUP BY TRUNC(hire_date, 'MI')").withOracle().ok("SELECT TRUNC(\"hire_date\", 'MINUTE')\nFROM \"foodmart\".\"employee\"\nGROUP BY TRUNC(\"hire_date\", 'MINUTE')").withPostgresql().ok("SELECT DATE_TRUNC('MINUTE', \"hire_date\")\nFROM \"foodmart\".\"employee\"\nGROUP BY DATE_TRUNC('MINUTE', \"hire_date\")").withMysql().ok("SELECT DATE_FORMAT(`hire_date`, '%Y-%m-%d %H:%i:00')\nFROM `foodmart`.`employee`\nGROUP BY DATE_FORMAT(`hire_date`, '%Y-%m-%d %H:%i:00')");
    }

    @Test
    public void testSubstring() {
        String query = "select substring(\"brand_name\" from 2) from \"product\"\n";
        String expectedOracle = "SELECT SUBSTR(\"brand_name\", 2)\nFROM \"foodmart\".\"product\"";
        String expectedPostgresql = "SELECT SUBSTRING(\"brand_name\" FROM 2)\nFROM \"foodmart\".\"product\"";
        String expectedMysql = "SELECT SUBSTRING(`brand_name` FROM 2)\nFROM `foodmart`.`product`";
        this.sql("select substring(\"brand_name\" from 2) from \"product\"\n").withOracle().ok("SELECT SUBSTR(\"brand_name\", 2)\nFROM \"foodmart\".\"product\"").withPostgresql().ok("SELECT SUBSTRING(\"brand_name\" FROM 2)\nFROM \"foodmart\".\"product\"").withMysql().ok("SELECT SUBSTRING(`brand_name` FROM 2)\nFROM `foodmart`.`product`").withMssql().throws_("MSSQL SUBSTRING requires FROM and FOR arguments");
    }

    @Test
    public void testSubstringWithFor() {
        String query = "select substring(\"brand_name\" from 2 for 3) from \"product\"\n";
        String expectedOracle = "SELECT SUBSTR(\"brand_name\", 2, 3)\nFROM \"foodmart\".\"product\"";
        String expectedPostgresql = "SELECT SUBSTRING(\"brand_name\" FROM 2 FOR 3)\nFROM \"foodmart\".\"product\"";
        String expectedMysql = "SELECT SUBSTRING(`brand_name` FROM 2 FOR 3)\nFROM `foodmart`.`product`";
        String expectedMssql = "SELECT SUBSTRING([brand_name], 2, 3)\nFROM [foodmart].[product]";
        this.sql("select substring(\"brand_name\" from 2 for 3) from \"product\"\n").withOracle().ok("SELECT SUBSTR(\"brand_name\", 2, 3)\nFROM \"foodmart\".\"product\"").withPostgresql().ok("SELECT SUBSTRING(\"brand_name\" FROM 2 FOR 3)\nFROM \"foodmart\".\"product\"").withMysql().ok("SELECT SUBSTRING(`brand_name` FROM 2 FOR 3)\nFROM `foodmart`.`product`").withMssql().ok("SELECT SUBSTRING([brand_name], 2, 3)\nFROM [foodmart].[product]");
    }

    @Test
    public void testExistsWithExpand() {
        String query = "select \"product_name\" from \"product\" a where exists (select count(*) from \"sales_fact_1997\"b where b.\"product_id\" = a.\"product_id\")";
        String expected = "SELECT \"product_name\"\nFROM \"foodmart\".\"product\"\nWHERE EXISTS (SELECT COUNT(*)\nFROM \"foodmart\".\"sales_fact_1997\"\nWHERE \"product_id\" = \"product\".\"product_id\")";
        this.sql(query).config(NO_EXPAND_CONFIG).ok(expected);
    }

    @Test
    public void testNotExistsWithExpand() {
        String query = "select \"product_name\" from \"product\" a where not exists (select count(*) from \"sales_fact_1997\"b where b.\"product_id\" = a.\"product_id\")";
        String expected = "SELECT \"product_name\"\nFROM \"foodmart\".\"product\"\nWHERE NOT EXISTS (SELECT COUNT(*)\nFROM \"foodmart\".\"sales_fact_1997\"\nWHERE \"product_id\" = \"product\".\"product_id\")";
        this.sql(query).config(NO_EXPAND_CONFIG).ok(expected);
    }

    @Test
    public void testSubQueryInWithExpand() {
        String query = "select \"product_name\" from \"product\" a where \"product_id\" in (select \"product_id\" from \"sales_fact_1997\"b where b.\"product_id\" = a.\"product_id\")";
        String expected = "SELECT \"product_name\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" IN (SELECT \"product_id\"\nFROM \"foodmart\".\"sales_fact_1997\"\nWHERE \"product_id\" = \"product\".\"product_id\")";
        this.sql(query).config(NO_EXPAND_CONFIG).ok(expected);
    }

    @Test
    public void testSubQueryInWithExpand2() {
        String query = "select \"product_name\" from \"product\" a where \"product_id\" in (1, 2)";
        String expected = "SELECT \"product_name\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" = 1 OR \"product_id\" = 2";
        this.sql(query).config(NO_EXPAND_CONFIG).ok(expected);
    }

    @Test
    public void testSubQueryNotInWithExpand() {
        String query = "select \"product_name\" from \"product\" a where \"product_id\" not in (select \"product_id\" from \"sales_fact_1997\"b where b.\"product_id\" = a.\"product_id\")";
        String expected = "SELECT \"product_name\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" NOT IN (SELECT \"product_id\"\nFROM \"foodmart\".\"sales_fact_1997\"\nWHERE \"product_id\" = \"product\".\"product_id\")";
        this.sql(query).config(NO_EXPAND_CONFIG).ok(expected);
    }

    @Test
    public void testLike() {
        String query = "select \"product_name\" from \"product\" a where \"product_name\" like 'abc'";
        String expected = "SELECT \"product_name\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_name\" LIKE 'abc'";
        this.sql(query).ok(expected);
    }

    @Test
    public void testNotLike() {
        String query = "select \"product_name\" from \"product\" a where \"product_name\" not like 'abc'";
        String expected = "SELECT \"product_name\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_name\" NOT LIKE 'abc'";
        this.sql(query).ok(expected);
    }

    @Test
    public void testMatchRecognizePatternExpression() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    partition by \"product_class_id\", \"brand_name\" \n    order by \"product_class_id\" asc, \"brand_name\" desc \n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nPARTITION BY \"product_class_id\", \"brand_name\"\nORDER BY \"product_class_id\", \"brand_name\" DESC\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql(sql).ok(expected);
    }

    @Test
    public void testMatchRecognizePatternExpression2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression5() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down* up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" * \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down* up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" * \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression6() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down-} up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" -} \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down-} up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" -} \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression7() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{2} up{3,})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { 2 } \"UP\" { 3, })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{2} up{3,})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { 2 } \"UP\" { 3, })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression8() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{,2} up{3,5})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { , 2 } \"UP\" { 3, 5 })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{,2} up{3,5})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { , 2 } \"UP\" { 3, 5 })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression9() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down+-} {-up*-})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" + -} {- \"UP\" * -})\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down+-} {-up*-})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" + -} {- \"UP\" * -})\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression10() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (A B C | A C B | B A C | B C A | C A B | C B A)\n    define\n      A as A.\"net_weight\" < PREV(A.\"net_weight\"),\n      B as B.\"net_weight\" > PREV(B.\"net_weight\"),\n      C as C.\"net_weight\" < PREV(C.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"A\" \"B\" \"C\" | \"A\" \"C\" \"B\" | \"B\" \"A\" \"C\" | \"B\" \"C\" \"A\" | \"C\" \"A\" \"B\" | \"C\" \"B\" \"A\")\nDEFINE \"A\" AS PREV(\"A\".\"net_weight\", 0) < PREV(\"A\".\"net_weight\", 1), \"B\" AS PREV(\"B\".\"net_weight\", 0) > PREV(\"B\".\"net_weight\", 1), \"C\" AS PREV(\"C\".\"net_weight\", 0) < PREV(\"C\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (A B C | A C B | B A C | B C A | C A B | C B A)\n    define\n      A as A.\"net_weight\" < PREV(A.\"net_weight\"),\n      B as B.\"net_weight\" > PREV(B.\"net_weight\"),\n      C as C.\"net_weight\" < PREV(C.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"A\" \"B\" \"C\" | \"A\" \"C\" \"B\" | \"B\" \"A\" \"C\" | \"B\" \"C\" \"A\" | \"C\" \"A\" \"B\" | \"C\" \"B\" \"A\")\nDEFINE \"A\" AS PREV(\"A\".\"net_weight\", 0) < PREV(\"A\".\"net_weight\", 1), \"B\" AS PREV(\"B\".\"net_weight\", 0) > PREV(\"B\".\"net_weight\", 1), \"C\" AS PREV(\"C\".\"net_weight\", 0) < PREV(\"C\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression11() {
        String sql = "select *\n  from (select * from \"product\") match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from (select * from \"product\") match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression12() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"");
    }

    @Test
    public void testMatchRecognizePatternExpression13() {
        String sql = "select *\n  from (\nselect *\nfrom \"sales_fact_1997\" as s\njoin \"customer\" as c\n  on s.\"customer_id\" = c.\"customer_id\"\njoin \"product\" as p\n  on s.\"product_id\" = p.\"product_id\"\njoin \"product_class\" as pc\n  on p.\"product_class_id\" = pc.\"product_class_id\"\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks') match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks') MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"";
        this.sql("select *\n  from (\nselect *\nfrom \"sales_fact_1997\" as s\njoin \"customer\" as c\n  on s.\"customer_id\" = c.\"customer_id\"\njoin \"product\" as p\n  on s.\"product_id\" = p.\"product_id\"\njoin \"product_class\" as pc\n  on p.\"product_class_id\" = pc.\"product_class_id\"\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks') match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks') MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"");
    }

    @Test
    public void testMatchRecognizeDefineClause() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizeDefineClause2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < FIRST(down.\"net_weight\"),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < FIRST(\"DOWN\".\"net_weight\", 0), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < FIRST(down.\"net_weight\"),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < FIRST(\"DOWN\".\"net_weight\", 0), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0))");
    }

    @Test
    public void testMatchRecognizeDefineClause3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\" + up.\"gross_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\" + up.\"gross_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0))");
    }

    @Test
    public void testMatchRecognizeDefineClause4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > PREV(LAST(up.\"net_weight\" + up.\"gross_weight\"),3)\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0), 3))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > PREV(LAST(up.\"net_weight\" + up.\"gross_weight\"),3)\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0), 3))");
    }

    @Test
    public void testMatchRecognizeMeasures1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures MATCH_NUMBER() as match_num,    CLASSIFIER() as var_match,    STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL MATCH_NUMBER () AS \"MATCH_NUM\", FINAL CLASSIFIER() AS \"VAR_MATCH\", FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures MATCH_NUMBER() as match_num,    CLASSIFIER() as var_match,    STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL MATCH_NUMBER () AS \"MATCH_NUM\", FINAL CLASSIFIER() AS \"VAR_MATCH\", FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   RUNNING LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL (RUNNING LAST(\"DOWN\".\"net_weight\", 0)) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   RUNNING LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL (RUNNING LAST(\"DOWN\".\"net_weight\", 0)) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL COUNT(up.\"net_weight\") as up_cnt,   FINAL COUNT(\"net_weight\") as down_cnt,   RUNNING COUNT(\"net_weight\") as running_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL COUNT(\"UP\".\"net_weight\") AS \"UP_CNT\", FINAL COUNT(\"*\".\"net_weight\") AS \"DOWN_CNT\", FINAL (RUNNING COUNT(\"*\".\"net_weight\")) AS \"RUNNING_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL COUNT(up.\"net_weight\") as up_cnt,   FINAL COUNT(\"net_weight\") as down_cnt,   RUNNING COUNT(\"net_weight\") as running_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL COUNT(\"UP\".\"net_weight\") AS \"UP_CNT\", FINAL COUNT(\"*\".\"net_weight\") AS \"DOWN_CNT\", FINAL (RUNNING COUNT(\"*\".\"net_weight\")) AS \"RUNNING_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures5() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(UP.\"net_weight\") as up_cnt,   AVG(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"UP_CNT\", FINAL (SUM(\"DOWN\".\"net_weight\") / COUNT(\"DOWN\".\"net_weight\")) AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(UP.\"net_weight\") as up_cnt,   AVG(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"UP_CNT\", FINAL (SUM(\"DOWN\".\"net_weight\") / COUNT(\"DOWN\".\"net_weight\")) AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures6() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures7() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by start_nw, up_cnt";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"START_NW\", \"UP_CNT\"";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by start_nw, up_cnt").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"START_NW\", \"UP_CNT\"");
    }

    @Test
    public void testMatchRecognizePatternSkip1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip past last row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP PAST LAST ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip past last row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP PAST LAST ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to FIRST down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO FIRST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to FIRST down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO FIRST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to last down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to last down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip5() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizeSubset1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizeSubset2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   AVG(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL (SUM(\"STDN\".\"net_weight\") / COUNT(\"STDN\".\"net_weight\")) AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   AVG(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL (SUM(\"STDN\".\"net_weight\") / COUNT(\"STDN\".\"net_weight\")) AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeSubset3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeSubset4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeRowsPerMatch1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ONE ROW PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ONE ROW PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeRowsPerMatch2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ALL ROWS PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES RUNNING \"STRT\".\"net_weight\" AS \"START_NW\", RUNNING LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", RUNNING SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nALL ROWS PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ALL ROWS PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES RUNNING \"STRT\".\"net_weight\" AS \"START_NW\", RUNNING LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", RUNNING SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nALL ROWS PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeWithin() {
        String sql = "select *\n  from \"employee\" match_recognize\n  (\n   order by \"hire_date\"\n   ALL ROWS PER MATCH\n   pattern (strt down+ up+) within interval '3:12:22.123' hour to second\n   define\n     down as down.\"salary\" < PREV(down.\"salary\"),\n     up as up.\"salary\" > prev(up.\"salary\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"employee\") MATCH_RECOGNIZE(\nORDER BY \"hire_date\"\nALL ROWS PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +) WITHIN INTERVAL '3:12:22.123' HOUR TO SECOND\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"salary\", 0) < PREV(\"DOWN\".\"salary\", 1), \"UP\" AS PREV(\"UP\".\"salary\", 0) > PREV(\"UP\".\"salary\", 1))";
        this.sql("select *\n  from \"employee\" match_recognize\n  (\n   order by \"hire_date\"\n   ALL ROWS PER MATCH\n   pattern (strt down+ up+) within interval '3:12:22.123' hour to second\n   define\n     down as down.\"salary\" < PREV(down.\"salary\"),\n     up as up.\"salary\" > prev(up.\"salary\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"employee\") MATCH_RECOGNIZE(\nORDER BY \"hire_date\"\nALL ROWS PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +) WITHIN INTERVAL '3:12:22.123' HOUR TO SECOND\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"salary\", 0) < PREV(\"DOWN\".\"salary\", 1), \"UP\" AS PREV(\"UP\".\"salary\", 0) > PREV(\"UP\".\"salary\", 1))");
    }

    @Test
    public void testValues() {
        String sql = "select \"a\"\nfrom (values (1, 'x'), (2, 'yy')) as t(\"a\", \"b\")";
        String expectedHsqldb = "SELECT a\nFROM (VALUES  (1, 'x '),\n (2, 'yy')) AS t (a, b)";
        String expectedPostgresql = "SELECT \"a\"\nFROM (VALUES  (1, 'x '),\n (2, 'yy')) AS \"t\" (\"a\", \"b\")";
        String expectedOracle = "SELECT \"a\"\nFROM (SELECT 1 \"a\", 'x ' \"b\"\nFROM \"DUAL\"\nUNION ALL\nSELECT 2 \"a\", 'yy' \"b\"\nFROM \"DUAL\")";
        this.sql("select \"a\"\nfrom (values (1, 'x'), (2, 'yy')) as t(\"a\", \"b\")").withHsqldb().ok("SELECT a\nFROM (VALUES  (1, 'x '),\n (2, 'yy')) AS t (a, b)").withPostgresql().ok("SELECT \"a\"\nFROM (VALUES  (1, 'x '),\n (2, 'yy')) AS \"t\" (\"a\", \"b\")").withOracle().ok("SELECT \"a\"\nFROM (SELECT 1 \"a\", 'x ' \"b\"\nFROM \"DUAL\"\nUNION ALL\nSELECT 2 \"a\", 'yy' \"b\"\nFROM \"DUAL\")");
    }

    @Test
    public void testPreserveAlias() {
        String sql = "select \"warehouse_class_id\" as \"id\",\n \"description\"\nfrom \"warehouse_class\"";
        String expected = "SELECT \"warehouse_class_id\" AS \"id\", \"description\"\nFROM \"foodmart\".\"warehouse_class\"";
        this.sql("select \"warehouse_class_id\" as \"id\",\n \"description\"\nfrom \"warehouse_class\"").ok("SELECT \"warehouse_class_id\" AS \"id\", \"description\"\nFROM \"foodmart\".\"warehouse_class\"");
        String sql2 = "select \"warehouse_class_id\", \"description\"\nfrom \"warehouse_class\"";
        String expected2 = "SELECT *\nFROM \"foodmart\".\"warehouse_class\"";
        this.sql("select \"warehouse_class_id\", \"description\"\nfrom \"warehouse_class\"").ok("SELECT *\nFROM \"foodmart\".\"warehouse_class\"");
    }

    @Test
    public void testPreservePermutation() {
        String sql = "select \"description\", \"warehouse_class_id\"\nfrom \"warehouse_class\"";
        String expected = "SELECT \"description\", \"warehouse_class_id\"\nFROM \"foodmart\".\"warehouse_class\"";
        this.sql("select \"description\", \"warehouse_class_id\"\nfrom \"warehouse_class\"").ok("SELECT \"description\", \"warehouse_class_id\"\nFROM \"foodmart\".\"warehouse_class\"");
    }

    @Test
    public void testFieldNamesWithAggregateSubQuery() {
        String query = "select mytable.\"city\",\n  sum(mytable.\"store_sales\") as \"my-alias\"\nfrom (select c.\"city\", s.\"store_sales\"\n  from \"sales_fact_1997\" as s\n    join \"customer\" as c using (\"customer_id\")\n  group by c.\"city\", s.\"store_sales\") AS mytable\ngroup by mytable.\"city\"";
        String expected = "SELECT \"t0\".\"city\", SUM(\"t0\".\"store_sales\") AS \"my-alias\"\nFROM (SELECT \"customer\".\"city\", \"sales_fact_1997\".\"store_sales\"\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nGROUP BY \"customer\".\"city\", \"sales_fact_1997\".\"store_sales\") AS \"t0\"\nGROUP BY \"t0\".\"city\"";
        this.sql("select mytable.\"city\",\n  sum(mytable.\"store_sales\") as \"my-alias\"\nfrom (select c.\"city\", s.\"store_sales\"\n  from \"sales_fact_1997\" as s\n    join \"customer\" as c using (\"customer_id\")\n  group by c.\"city\", s.\"store_sales\") AS mytable\ngroup by mytable.\"city\"").ok("SELECT \"t0\".\"city\", SUM(\"t0\".\"store_sales\") AS \"my-alias\"\nFROM (SELECT \"customer\".\"city\", \"sales_fact_1997\".\"store_sales\"\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nGROUP BY \"customer\".\"city\", \"sales_fact_1997\".\"store_sales\") AS \"t0\"\nGROUP BY \"t0\".\"city\"");
    }

    @Test
    public void testUnparseSelectMustUseDialect() {
        String query = "select * from \"product\"";
        String expected = "SELECT *\nFROM foodmart.product";
        final boolean[] callsUnparseCallOnSqlSelect = new boolean[]{false};
        SqlDialect dialect = new SqlDialect(SqlDialect.EMPTY_CONTEXT){

            public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
                if (call instanceof SqlSelect) {
                    callsUnparseCallOnSqlSelect[0] = true;
                }
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        };
        this.sql("select * from \"product\"").dialect(dialect).ok("SELECT *\nFROM foodmart.product");
        Assert.assertThat((String)"Dialect must be able to customize unparseCall() for SqlSelect", (Object)callsUnparseCallOnSqlSelect[0], (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testWithinGroup1() {
        String query = "select \"product_class_id\", collect(\"net_weight\") within group (order by \"net_weight\" desc) from \"product\" group by \"product_class_id\"";
        String expected = "SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"net_weight\" DESC)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql("select \"product_class_id\", collect(\"net_weight\") within group (order by \"net_weight\" desc) from \"product\" group by \"product_class_id\"").ok("SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"net_weight\" DESC)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testWithinGroup2() {
        String query = "select \"product_class_id\", collect(\"net_weight\") within group (order by \"low_fat\", \"net_weight\" desc nulls last) from \"product\" group by \"product_class_id\"";
        String expected = "SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"low_fat\", \"net_weight\" DESC NULLS LAST)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql("select \"product_class_id\", collect(\"net_weight\") within group (order by \"low_fat\", \"net_weight\" desc nulls last) from \"product\" group by \"product_class_id\"").ok("SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"low_fat\", \"net_weight\" DESC NULLS LAST)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testWithinGroup3() {
        String query = "select \"product_class_id\", collect(\"net_weight\") within group (order by \"net_weight\" desc), min(\"low_fat\")from \"product\" group by \"product_class_id\"";
        String expected = "SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"net_weight\" DESC), MIN(\"low_fat\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql("select \"product_class_id\", collect(\"net_weight\") within group (order by \"net_weight\" desc), min(\"low_fat\")from \"product\" group by \"product_class_id\"").ok("SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"net_weight\" DESC), MIN(\"low_fat\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testWithinGroup4() {
        String query = "select \"product_class_id\", collect(\"net_weight\") within group (order by \"net_weight\" desc) filter (where \"net_weight\" > 0)from \"product\" group by \"product_class_id\"";
        String expected = "SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"net_weight\" DESC)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql("select \"product_class_id\", collect(\"net_weight\") within group (order by \"net_weight\" desc) filter (where \"net_weight\" > 0)from \"product\" group by \"product_class_id\"").ok("SELECT \"product_class_id\", COLLECT(\"net_weight\") WITHIN GROUP (ORDER BY \"net_weight\" DESC)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testJsonExists() {
        String query = "select json_exists(\"product_name\", 'lax $') from \"product\"";
        String expected = "SELECT JSON_EXISTS(\"product_name\" FORMAT JSON, 'lax $')\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT JSON_EXISTS(\"product_name\" FORMAT JSON, 'lax $')\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testJsonValue() {
        String query = "select json_value(\"product_name\", 'lax $') from \"product\"";
        String expected = "SELECT CAST(JSON_VALUE_ANY(\"product_name\" FORMAT JSON, 'lax $' NULL ON EMPTY NULL ON ERROR) AS VARCHAR(2000) CHARACTER SET \"ISO-8859-1\")\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT CAST(JSON_VALUE_ANY(\"product_name\" FORMAT JSON, 'lax $' NULL ON EMPTY NULL ON ERROR) AS VARCHAR(2000) CHARACTER SET \"ISO-8859-1\")\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testJsonQuery() {
        String query = "select json_query(\"product_name\", 'lax $') from \"product\"";
        String expected = "SELECT JSON_QUERY(\"product_name\" FORMAT JSON, 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT JSON_QUERY(\"product_name\" FORMAT JSON, 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testJsonArray() {
        String query = "select json_array(\"product_name\", \"product_name\") from \"product\"";
        String expected = "SELECT JSON_ARRAY(\"product_name\", \"product_name\" ABSENT ON NULL)\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT JSON_ARRAY(\"product_name\", \"product_name\" ABSENT ON NULL)\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testJsonArrayAgg() {
        String query = "select json_arrayagg(\"product_name\") from \"product\"";
        String expected = "SELECT JSON_ARRAYAGG(\"product_name\" ABSENT ON NULL)\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT JSON_ARRAYAGG(\"product_name\" ABSENT ON NULL)\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testJsonObject() {
        String query = "select json_object(\"product_name\": \"product_id\") from \"product\"";
        String expected = "SELECT JSON_OBJECT(KEY \"product_name\" VALUE \"product_id\" NULL ON NULL)\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT JSON_OBJECT(KEY \"product_name\" VALUE \"product_id\" NULL ON NULL)\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testJsonObjectAgg() {
        String query = "select json_objectagg(\"product_name\": \"product_id\") from \"product\"";
        String expected = "SELECT JSON_OBJECTAGG(KEY \"product_name\" VALUE \"product_id\" NULL ON NULL)\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT JSON_OBJECTAGG(KEY \"product_name\" VALUE \"product_id\" NULL ON NULL)\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testJsonPredicate() {
        String query = "select \"product_name\" is json, \"product_name\" is json value, \"product_name\" is json object, \"product_name\" is json array, \"product_name\" is json scalar, \"product_name\" is not json, \"product_name\" is not json value, \"product_name\" is not json object, \"product_name\" is not json array, \"product_name\" is not json scalar from \"product\"";
        String expected = "SELECT \"product_name\" IS JSON VALUE, \"product_name\" IS JSON VALUE, \"product_name\" IS JSON OBJECT, \"product_name\" IS JSON ARRAY, \"product_name\" IS JSON SCALAR, \"product_name\" IS NOT JSON VALUE, \"product_name\" IS NOT JSON VALUE, \"product_name\" IS NOT JSON OBJECT, \"product_name\" IS NOT JSON ARRAY, \"product_name\" IS NOT JSON SCALAR\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT \"product_name\" IS JSON VALUE, \"product_name\" IS JSON VALUE, \"product_name\" IS JSON OBJECT, \"product_name\" IS JSON ARRAY, \"product_name\" IS JSON SCALAR, \"product_name\" IS NOT JSON VALUE, \"product_name\" IS NOT JSON VALUE, \"product_name\" IS NOT JSON OBJECT, \"product_name\" IS NOT JSON ARRAY, \"product_name\" IS NOT JSON SCALAR\nFROM \"foodmart\".\"product\"");
    }

    static class Sql {
        private final SchemaPlus schema;
        private final String sql;
        private final SqlDialect dialect;
        private final List<Function<RelNode, RelNode>> transforms;
        private final SqlToRelConverter.Config config;

        Sql(CalciteAssert.SchemaSpec schemaSpec, String sql, SqlDialect dialect, SqlToRelConverter.Config config, List<Function<RelNode, RelNode>> transforms) {
            SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
            this.schema = CalciteAssert.addSchema(rootSchema, schemaSpec);
            this.sql = sql;
            this.dialect = dialect;
            this.transforms = ImmutableList.copyOf(transforms);
            this.config = config;
        }

        Sql(SchemaPlus schema, String sql, SqlDialect dialect, SqlToRelConverter.Config config, List<Function<RelNode, RelNode>> transforms) {
            this.schema = schema;
            this.sql = sql;
            this.dialect = dialect;
            this.transforms = ImmutableList.copyOf(transforms);
            this.config = config;
        }

        Sql dialect(SqlDialect dialect) {
            return new Sql(this.schema, this.sql, dialect, this.config, this.transforms);
        }

        Sql withDb2() {
            return this.dialect(SqlDialect.DatabaseProduct.DB2.getDialect());
        }

        Sql withHive() {
            return this.dialect(SqlDialect.DatabaseProduct.HIVE.getDialect());
        }

        Sql withHsqldb() {
            return this.dialect(SqlDialect.DatabaseProduct.HSQLDB.getDialect());
        }

        Sql withMssql() {
            return this.dialect(SqlDialect.DatabaseProduct.MSSQL.getDialect());
        }

        Sql withMysql() {
            return this.dialect(SqlDialect.DatabaseProduct.MYSQL.getDialect());
        }

        Sql withOracle() {
            return this.dialect(SqlDialect.DatabaseProduct.ORACLE.getDialect());
        }

        Sql withPostgresql() {
            return this.dialect(SqlDialect.DatabaseProduct.POSTGRESQL.getDialect());
        }

        Sql withVertica() {
            return this.dialect(SqlDialect.DatabaseProduct.VERTICA.getDialect());
        }

        Sql withPostgresqlModifiedTypeSystem() {
            PostgresqlSqlDialect postgresqlSqlDialect = new PostgresqlSqlDialect(SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.POSTGRESQL).withIdentifierQuoteString("\"").withDataTypeSystem((RelDataTypeSystem)new RelDataTypeSystemImpl(){

                public int getMaxPrecision(SqlTypeName typeName) {
                    switch (typeName) {
                        case VARCHAR: {
                            return 256;
                        }
                    }
                    return super.getMaxPrecision(typeName);
                }
            }));
            return this.dialect((SqlDialect)postgresqlSqlDialect);
        }

        Sql config(SqlToRelConverter.Config config) {
            return new Sql(this.schema, this.sql, this.dialect, config, this.transforms);
        }

        Sql optimize(RuleSet ruleSet, RelOptPlanner relOptPlanner) {
            return new Sql(this.schema, this.sql, this.dialect, this.config, (List<Function<RelNode, RelNode>>)FlatLists.append(this.transforms, r -> {
                Program program = Programs.of((RuleSet)ruleSet);
                return program.run(relOptPlanner, r, r.getTraitSet(), (List)ImmutableList.of(), (List)ImmutableList.of());
            }));
        }

        Sql ok(String expectedQuery) {
            Assert.assertThat((Object)this.exec(), Matchers.isLinux(expectedQuery));
            return this;
        }

        Sql throws_(String errorMessage) {
            try {
                String s = this.exec();
                throw new AssertionError((Object)("Expected exception with message `" + errorMessage + "` but nothing was thrown; got " + s));
            }
            catch (Exception e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)errorMessage));
                return this;
            }
        }

        String exec() {
            Planner planner = RelToSqlConverterTest.getPlanner(null, SqlParser.Config.DEFAULT, this.schema, this.config, new Program[0]);
            try {
                SqlNode parse = planner.parse(this.sql);
                SqlNode validate = planner.validate(parse);
                RelNode rel = planner.rel((SqlNode)validate).rel;
                for (Function<RelNode, RelNode> transform : this.transforms) {
                    rel = transform.apply(rel);
                }
                return RelToSqlConverterTest.toSql(rel, this.dialect);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Sql schema(CalciteAssert.SchemaSpec schemaSpec) {
            return new Sql(schemaSpec, this.sql, this.dialect, this.config, this.transforms);
        }
    }
}

