/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class RelOptUtilTest {
    private static final RelBuilder REL_BUILDER = RelBuilder.create((FrameworkConfig)RelOptUtilTest.config().build());
    private static final RelNode EMP_SCAN = REL_BUILDER.scan(new String[]{"EMP"}).build();
    private static final RelNode DEPT_SCAN = REL_BUILDER.scan(new String[]{"DEPT"}).build();
    private static final RelDataType EMP_ROW = EMP_SCAN.getRowType();
    private static final RelDataType DEPT_ROW = DEPT_SCAN.getRowType();
    private static final List<RelDataTypeField> EMP_DEPT_JOIN_REL_FIELDS = Lists.newArrayList((Iterable)Iterables.concat((Iterable)EMP_ROW.getFieldList(), (Iterable)DEPT_ROW.getFieldList()));

    private static Frameworks.ConfigBuilder config() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        return Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.SCOTT));
    }

    @Test
    public void testTypeDump() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType t1 = typeFactory.builder().add("f0", SqlTypeName.DECIMAL, 5, 2).add("f1", SqlTypeName.VARCHAR, 10).build();
        TestUtil.assertEqualsVerbose(TestUtil.fold("f0 DECIMAL(5, 2) NOT NULL,", "f1 VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL"), Util.toLinux((String)(RelOptUtil.dumpType((RelDataType)t1) + "\n")));
        RelDataType t2 = typeFactory.builder().add("f0", t1).add("f1", typeFactory.createMultisetType(t1, -1L)).build();
        TestUtil.assertEqualsVerbose(TestUtil.fold("f0 RECORD (", "  f0 DECIMAL(5, 2) NOT NULL,", "  f1 VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL) NOT NULL,", "f1 RECORD (", "  f0 DECIMAL(5, 2) NOT NULL,", "  f1 VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL) NOT NULL MULTISET NOT NULL"), Util.toLinux((String)(RelOptUtil.dumpType((RelDataType)t2) + "\n")));
    }

    @Test
    public void testRuleGuessDescription() {
        Assert.assertEquals((Object)"Bar", (Object)RelOptRule.guessDescription((String)"com.foo.Bar"));
        Assert.assertEquals((Object)"Baz", (Object)RelOptRule.guessDescription((String)"com.flatten.Bar$Baz"));
        try {
            Util.discard((Object)RelOptRule.guessDescription((String)"com.foo.Bar$1"));
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Derived description of rule class com.foo.Bar$1 is an integer, not valid. Supply a description manually.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSplitJoinConditionEquals() {
        int leftJoinIndex = EMP_SCAN.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = DEPT_ROW.getFieldNames().indexOf("DEPTNO");
        RexNode joinCond = REL_BUILDER.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{RexInputRef.of((int)leftJoinIndex, EMP_DEPT_JOIN_REL_FIELDS), RexInputRef.of((int)(EMP_ROW.getFieldCount() + rightJoinIndex), EMP_DEPT_JOIN_REL_FIELDS)});
        RelOptUtilTest.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(true), REL_BUILDER.literal((Object)true));
    }

    @Test
    public void testSplitJoinConditionIsNotDistinctFrom() {
        int leftJoinIndex = EMP_SCAN.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = DEPT_ROW.getFieldNames().indexOf("DEPTNO");
        RexNode joinCond = REL_BUILDER.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{RexInputRef.of((int)leftJoinIndex, EMP_DEPT_JOIN_REL_FIELDS), RexInputRef.of((int)(EMP_ROW.getFieldCount() + rightJoinIndex), EMP_DEPT_JOIN_REL_FIELDS)});
        RelOptUtilTest.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(false), REL_BUILDER.literal((Object)true));
    }

    @Test
    public void testSplitJoinConditionExpandedIsNotDistinctFrom() {
        int leftJoinIndex = EMP_SCAN.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = DEPT_ROW.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, EMP_DEPT_JOIN_REL_FIELDS);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(EMP_ROW.getFieldCount() + rightJoinIndex), EMP_DEPT_JOIN_REL_FIELDS);
        RexNode joinCond = REL_BUILDER.call((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{REL_BUILDER.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{leftKeyInputRef, rightKeyInputRef}), REL_BUILDER.call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{REL_BUILDER.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{leftKeyInputRef}), REL_BUILDER.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rightKeyInputRef})})});
        RelOptUtilTest.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(false), REL_BUILDER.literal((Object)true));
    }

    private static void splitJoinConditionHelper(RexNode joinCond, List<Integer> expLeftKeys, List<Integer> expRightKeys, List<Boolean> expFilterNulls, RexNode expRemaining) {
        ArrayList actLeftKeys = new ArrayList();
        ArrayList actRightKeys = new ArrayList();
        ArrayList actFilterNulls = new ArrayList();
        RexNode actRemaining = RelOptUtil.splitJoinCondition((RelNode)EMP_SCAN, (RelNode)DEPT_SCAN, (RexNode)joinCond, actLeftKeys, actRightKeys, actFilterNulls);
        Assert.assertEquals((Object)expRemaining.toString(), (Object)actRemaining.toString());
        Assert.assertEquals(expFilterNulls, actFilterNulls);
        Assert.assertEquals(expLeftKeys, actLeftKeys);
        Assert.assertEquals(expRightKeys, actRightKeys);
    }
}

