/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class CassandraFilter
extends Filter
implements CassandraRel {
    private final List<String> partitionKeys;
    private Boolean singlePartition;
    private final List<String> clusteringKeys;
    private List<RelFieldCollation> implicitFieldCollations;
    private RelCollation implicitCollation;
    private String match;

    public CassandraFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition, List<String> partitionKeys, List<String> clusteringKeys, List<RelFieldCollation> implicitFieldCollations) {
        super(cluster, traitSet, child, condition);
        this.partitionKeys = partitionKeys;
        this.singlePartition = false;
        this.clusteringKeys = new ArrayList<String>(clusteringKeys);
        this.implicitFieldCollations = implicitFieldCollations;
        Translator translator = new Translator(this.getRowType(), partitionKeys, clusteringKeys, implicitFieldCollations);
        this.match = translator.translateMatch(condition);
        this.singlePartition = translator.isSinglePartition();
        this.implicitCollation = translator.getImplicitCollation();
        assert (this.getConvention() == CassandraRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public CassandraFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new CassandraFilter(this.getCluster(), traitSet, input, condition, this.partitionKeys, this.clusteringKeys, this.implicitFieldCollations);
    }

    @Override
    public void implement(CassandraRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        implementor.add(null, Collections.singletonList(this.match));
    }

    public boolean isSinglePartition() {
        return this.singlePartition;
    }

    public RelCollation getImplicitCollation() {
        return this.implicitCollation;
    }

    static class Translator {
        private final RelDataType rowType;
        private final List<String> fieldNames;
        private final Set<String> partitionKeys;
        private final List<String> clusteringKeys;
        private int restrictedClusteringKeys;
        private final List<RelFieldCollation> implicitFieldCollations;

        Translator(RelDataType rowType, List<String> partitionKeys, List<String> clusteringKeys, List<RelFieldCollation> implicitFieldCollations) {
            this.rowType = rowType;
            this.fieldNames = CassandraRules.cassandraFieldNames(rowType);
            this.partitionKeys = new HashSet<String>(partitionKeys);
            this.clusteringKeys = clusteringKeys;
            this.restrictedClusteringKeys = 0;
            this.implicitFieldCollations = implicitFieldCollations;
        }

        public boolean isSinglePartition() {
            return this.partitionKeys.isEmpty();
        }

        public RelCollation getImplicitCollation() {
            if (!this.isSinglePartition()) {
                return RelCollations.EMPTY;
            }
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
            for (int i = this.restrictedClusteringKeys; i < this.clusteringKeys.size(); ++i) {
                int fieldIndex = this.fieldNames.indexOf(this.clusteringKeys.get(i));
                RelFieldCollation.Direction direction = this.implicitFieldCollations.get(i).getDirection();
                fieldCollations.add(new RelFieldCollation(fieldIndex, direction));
            }
            return RelCollations.of(fieldCollations);
        }

        private String translateMatch(RexNode condition) {
            List disjunctions = RelOptUtil.disjunctions((RexNode)condition);
            if (disjunctions.size() == 1) {
                return this.translateAnd((RexNode)disjunctions.get(0));
            }
            throw new AssertionError((Object)("cannot translate " + condition));
        }

        private static String literalValue(RexLiteral literal) {
            Object value = literal.getValue2();
            StringBuilder buf = new StringBuilder();
            buf.append(value);
            return buf.toString();
        }

        private String translateAnd(RexNode condition) {
            ArrayList<String> predicates = new ArrayList<String>();
            for (RexNode node : RelOptUtil.conjunctions((RexNode)condition)) {
                predicates.add(this.translateMatch2(node));
            }
            return Util.toString(predicates, (String)"", (String)" AND ", (String)"");
        }

        private String translateMatch2(RexNode node) {
            switch (node.getKind()) {
                case EQUALS: {
                    return this.translateBinary("=", "=", (RexCall)node);
                }
                case LESS_THAN: {
                    return this.translateBinary("<", ">", (RexCall)node);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.translateBinary("<=", ">=", (RexCall)node);
                }
                case GREATER_THAN: {
                    return this.translateBinary(">", "<", (RexCall)node);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.translateBinary(">=", "<=", (RexCall)node);
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private String translateBinary(String op, String rop, RexCall call) {
            RexNode right;
            RexNode left = (RexNode)call.operands.get(0);
            String expression = this.translateBinary2(op, left, right = (RexNode)call.operands.get(1));
            if (expression != null) {
                return expression;
            }
            expression = this.translateBinary2(rop, right, left);
            if (expression != null) {
                return expression;
            }
            throw new AssertionError((Object)("cannot translate op " + op + " call " + call));
        }

        private String translateBinary2(String op, RexNode left, RexNode right) {
            switch (right.getKind()) {
                case LITERAL: {
                    break;
                }
                default: {
                    return null;
                }
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    return this.translateOp2(op, name, rightLiteral);
                }
                case CAST: {
                    return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right);
                }
            }
            return null;
        }

        private String translateOp2(String op, String name, RexLiteral right) {
            SqlTypeName typeName;
            if (op.equals("=")) {
                this.partitionKeys.remove(name);
                if (this.clusteringKeys.contains(name)) {
                    ++this.restrictedClusteringKeys;
                }
            }
            String value = Translator.literalValue(right);
            String valueString = value.toString();
            if (value instanceof String && (typeName = this.rowType.getField(name, true, false).getType().getSqlTypeName()) != SqlTypeName.CHAR) {
                valueString = "'" + valueString + "'";
            }
            return name + " " + op + " " + valueString;
        }
    }
}

