/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.cassandraunit.CassandraCQLUnit;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.cql.ClassPathCQLDataSet;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@NotThreadSafe
public class CassandraAdapterTest {
    @ClassRule
    public static final ExternalResource RULE = CassandraAdapterTest.initCassandraIfEnabled();
    private static final ImmutableMap<String, String> TWISSANDRA = ImmutableMap.of((Object)"model", (Object)Sources.of((URL)CassandraAdapterTest.class.getResource("/model.json")).file().getAbsolutePath());

    private static boolean enabled() {
        boolean enabled = Util.getBooleanProperty((String)"calcite.test.cassandra", (boolean)true);
        Bug.upgrade((String)"remove JDK version check once current adapter supports Cassandra 4.x");
        boolean compatibleJdk = TestUtil.getJavaMajorVersion() != 11 && TestUtil.getJavaMajorVersion() != 12;
        return enabled && compatibleJdk;
    }

    private static ExternalResource initCassandraIfEnabled() {
        if (!CassandraAdapterTest.enabled()) {
            return new ExternalResource(){

                public Statement apply(Statement base, Description description) {
                    return super.apply(base, description);
                }
            };
        }
        String configurationFileName = null;
        long startUpTimeoutMillis = TimeUnit.SECONDS.toMillis(60L);
        CassandraCQLUnit rule = new CassandraCQLUnit((CQLDataSet)new ClassPathCQLDataSet("twissandra.cql"), configurationFileName, startUpTimeoutMillis);
        DatabaseDescriptor.daemonInitialization();
        return rule;
    }

    @BeforeClass
    public static void setUp() {
        Assume.assumeTrue((String)"test explicitly disabled", (boolean)CassandraAdapterTest.enabled());
    }

    @Test
    public void testSelect() {
        CalciteAssert.that().with(TWISSANDRA).query("select * from \"users\"").returnsCount(10);
    }

    @Test
    public void testFilter() {
        CalciteAssert.that().with(TWISSANDRA).query("select * from \"userline\" where \"username\"='!PUBLIC!'").limit(1).returns("username=!PUBLIC!; time=e8754000-80b8-1fe9-8e73-e3698c967ddd; tweet_id=f3c329de-d05b-11e5-b58b-90e2ba530b12\n").explainContains("PLAN=CassandraToEnumerableConverter\n  CassandraFilter(condition=[=($0, '!PUBLIC!')])\n    CassandraTableScan(table=[[twissandra, userline]]");
    }

    @Test
    public void testFilterUUID() {
        CalciteAssert.that().with(TWISSANDRA).query("select * from \"tweets\" where \"tweet_id\"='f3cd759c-d05b-11e5-b58b-90e2ba530b12'").limit(1).returns("tweet_id=f3cd759c-d05b-11e5-b58b-90e2ba530b12; body=Lacus augue pede posuere.; username=JmuhsAaMdw\n").explainContains("PLAN=CassandraToEnumerableConverter\n  CassandraFilter(condition=[=(CAST($0):CHAR(36), 'f3cd759c-d05b-11e5-b58b-90e2ba530b12')])\n    CassandraTableScan(table=[[twissandra, tweets]]");
    }

    @Test
    public void testSort() {
        CalciteAssert.that().with(TWISSANDRA).query("select * from \"userline\" where \"username\" = '!PUBLIC!' order by \"time\" desc").returnsCount(146).explainContains("PLAN=CassandraToEnumerableConverter\n  CassandraSort(sort0=[$1], dir0=[DESC])\n    CassandraFilter(condition=[=($0, '!PUBLIC!')])\n");
    }

    @Test
    public void testProject() {
        CalciteAssert.that().with(TWISSANDRA).query("select \"tweet_id\" from \"userline\" where \"username\" = '!PUBLIC!' limit 2").returns("tweet_id=f3c329de-d05b-11e5-b58b-90e2ba530b12\ntweet_id=f3dbb03a-d05b-11e5-b58b-90e2ba530b12\n").explainContains("PLAN=CassandraToEnumerableConverter\n  CassandraLimit(fetch=[2])\n    CassandraProject(tweet_id=[$2])\n      CassandraFilter(condition=[=($0, '!PUBLIC!')])\n");
    }

    @Test
    public void testProjectAlias() {
        CalciteAssert.that().with(TWISSANDRA).query("select \"tweet_id\" as \"foo\" from \"userline\" where \"username\" = '!PUBLIC!' limit 1").returns("foo=f3c329de-d05b-11e5-b58b-90e2ba530b12\n");
    }

    @Test
    public void testProjectConstant() {
        CalciteAssert.that().with(TWISSANDRA).query("select 'foo' as \"bar\" from \"userline\" limit 1").returns("bar=foo\n");
    }

    @Test
    public void testLimit() {
        CalciteAssert.that().with(TWISSANDRA).query("select \"tweet_id\" from \"userline\" where \"username\" = '!PUBLIC!' limit 8").explainContains("CassandraLimit(fetch=[8])\n");
    }

    @Test
    public void testSortLimit() {
        CalciteAssert.that().with(TWISSANDRA).query("select * from \"userline\" where \"username\"='!PUBLIC!' order by \"time\" desc limit 10").explainContains("  CassandraLimit(fetch=[10])\n    CassandraSort(sort0=[$1], dir0=[DESC])");
    }

    @Test
    public void testSortOffset() {
        CalciteAssert.that().with(TWISSANDRA).query("select \"tweet_id\" from \"userline\" where \"username\"='!PUBLIC!' limit 2 offset 1").explainContains("CassandraLimit(offset=[1], fetch=[2])").returns("tweet_id=f3dbb03a-d05b-11e5-b58b-90e2ba530b12\ntweet_id=f3e4182e-d05b-11e5-b58b-90e2ba530b12\n");
    }

    @Test
    public void testMaterializedView() {
        CalciteAssert.that().with(TWISSANDRA).query("select \"tweet_id\" from \"tweets\" where \"username\"='JmuhsAaMdw'").enableMaterializations(true).explainContains("CassandraTableScan(table=[[twissandra, Tweets_By_User]])");
    }
}

