/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.util.Arrays;
import java.util.Locale;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserTest;
import org.apache.calcite.sql.parser.babel.SqlBabelParserImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BabelParserTest
extends SqlParserTest {
    protected SqlParserImplFactory parserImplFactory() {
        return SqlBabelParserImpl.FACTORY;
    }

    public void testGenerateKeyWords() {
    }

    @Test
    public void testReservedWords() {
        Assert.assertThat((Object)this.isReserved("escape"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMetadata() {
        SqlAbstractParserImpl.Metadata metadata = this.getSqlParser("").getMetadata();
        Assert.assertThat((Object)metadata.isReservedFunctionName("ABS"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isReservedFunctionName("FOO"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isContextVariableName("CURRENT_USER"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isContextVariableName("CURRENT_CATALOG"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isContextVariableName("CURRENT_SCHEMA"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isContextVariableName("ABS"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isContextVariableName("FOO"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isNonReservedKeyword("A"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isNonReservedKeyword("KEY"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isNonReservedKeyword("SELECT"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isNonReservedKeyword("FOO"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isNonReservedKeyword("ABS"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("ABS"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("CURRENT_USER"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("CURRENT_CATALOG"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("CURRENT_SCHEMA"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("KEY"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("SELECT"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("HAVING"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("A"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isKeyword("BAR"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isReservedWord("SELECT"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)metadata.isReservedWord("CURRENT_CATALOG"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isReservedWord("CURRENT_SCHEMA"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)metadata.isReservedWord("KEY"), (Matcher)CoreMatchers.is((Object)false));
        String jdbcKeywords = metadata.getJdbcKeywords();
        Assert.assertThat((Object)jdbcKeywords.contains(",COLLECT,"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)(!jdbcKeywords.contains(",SELECT,") ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSelect() {
        String sql = "select 1 from t";
        String expected = "SELECT 1\nFROM `T`";
        this.sql("select 1 from t").ok("SELECT 1\nFROM `T`");
    }

    @Test
    public void testYearIsNotReserved() {
        String sql = "select 1 as year from t";
        String expected = "SELECT 1 AS `YEAR`\nFROM `T`";
        this.sql("select 1 as year from t").ok("SELECT 1 AS `YEAR`\nFROM `T`");
    }

    @Ignore
    @Test
    public void testKeywords() {
        String[] reserved = new String[]{"AND", "ANY", "END-EXEC"};
        StringBuilder sql = new StringBuilder("select ");
        StringBuilder expected = new StringBuilder("SELECT ");
        for (String keyword : BabelParserTest.keywords(null)) {
            if (Arrays.asList(reserved).contains(keyword)) continue;
            sql.append("1 as ").append(keyword).append(", ");
            expected.append("1 as `").append(keyword.toUpperCase(Locale.ROOT)).append("`,\n");
        }
        sql.setLength(sql.length() - 2);
        expected.setLength(expected.length() - 2);
        sql.append(" from t");
        expected.append("\nFROM t");
        this.sql(sql.toString()).ok(expected.toString());
    }

    @Test
    public void testAs() {
        String expected = "SELECT `AS`\nFROM `T`";
        this.sql("select as from t").ok("SELECT `AS`\nFROM `T`");
    }

    @Test
    public void testDesc() {
        String sql = "select desc\nfrom t\norder by desc asc, desc desc";
        String expected = "SELECT `DESC`\nFROM `T`\nORDER BY `DESC`, `DESC` DESC";
        this.sql("select desc\nfrom t\norder by desc asc, desc desc").ok("SELECT `DESC`\nFROM `T`\nORDER BY `DESC`, `DESC` DESC");
    }
}

