/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.quidem.AbstractCommand;
import net.hydromatic.quidem.Command;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.babel.SqlBabelParserImpl;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.test.BabelTest;
import org.apache.calcite.test.QuidemTest;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class BabelQuidemTest
extends QuidemTest {
    public BabelQuidemTest(String path) {
        super(path);
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            new BabelQuidemTest(arg).test();
        }
    }

    @Test
    public void test() throws Exception {
        MaterializationService.setThreadLocal();
        super.test();
    }

    @Parameterized.Parameters(name="{index}: quidem({0})")
    public static Collection<Object[]> data() {
        String first = "sql/select.iq";
        return BabelQuidemTest.data((String)"sql/select.iq");
    }

    protected Quidem.ConnectionFactory createConnectionFactory() {
        return new QuidemTest.QuidemConnectionFactory(){

            public Connection connect(String name, boolean reference) throws Exception {
                switch (name) {
                    case "babel": {
                        return BabelTest.connect();
                    }
                }
                return super.connect(name, reference);
            }
        };
    }

    protected CommandHandler createCommandHandler() {
        return new BabelCommandHandler();
    }

    private static class BabelCommandHandler
    implements CommandHandler {
        private BabelCommandHandler() {
        }

        public Command parseCommand(List<String> lines, List<String> content, String line) {
            Pattern pattern;
            Matcher matcher;
            String prefix = "explain-validated-on";
            if (line.startsWith("explain-validated-on") && (matcher = (pattern = Pattern.compile("explain-validated-on( [-_+a-zA-Z0-9]+)*?")).matcher(line)).matches()) {
                ImmutableSet.Builder set = ImmutableSet.builder();
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    set.add((Object)matcher.group(i + 1));
                }
                return new ExplainValidatedCommand(lines, content, (Set<String>)set.build());
            }
            return null;
        }
    }

    static class ExplainValidatedCommand
    extends AbstractCommand {
        private final ImmutableList<String> lines;
        private final ImmutableList<String> content;
        private final Set<String> productSet;

        ExplainValidatedCommand(List<String> lines, List<String> content, Set<String> productSet) {
            this.lines = ImmutableList.copyOf(lines);
            this.content = ImmutableList.copyOf(content);
            this.productSet = ImmutableSet.copyOf(productSet);
        }

        public void execute(Command.Context x, boolean execute) throws Exception {
            if (execute) {
                SqlParser.ConfigBuilder parserConfig = SqlParser.configBuilder().setParserFactory(SqlBabelParserImpl.FACTORY);
                Properties properties = new Properties();
                properties.setProperty(CalciteConnectionProperty.CONFORMANCE.name(), SqlConformanceEnum.BABEL.name());
                CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(properties);
                CalciteConnection calciteConnection = x.connection().unwrap(CalciteConnection.class);
                String schemaName = calciteConnection.getSchema();
                SchemaPlus schema = schemaName != null ? calciteConnection.getRootSchema().getSubSchema(schemaName) : calciteConnection.getRootSchema();
                Frameworks.ConfigBuilder config = Frameworks.newConfigBuilder().defaultSchema(schema).parserConfig(parserConfig.build()).context(Contexts.of((Object)connectionConfig));
                Quidem.SqlCommand sqlCommand = x.previousSqlCommand();
                Planner planner = Frameworks.getPlanner((FrameworkConfig)config.build());
                SqlNode node = planner.parse(sqlCommand.sql);
                SqlNode validateNode = planner.validate(node);
                SqlPrettyWriter sqlWriter = new SqlPrettyWriter(CalciteSqlDialect.DEFAULT);
                validateNode.unparse((SqlWriter)sqlWriter, 0, 0);
                x.echo((List)ImmutableList.of((Object)sqlWriter.toSqlString().getSql()));
            } else {
                x.echo(this.content);
            }
            x.echo(this.lines);
        }
    }
}

